# 34.12.VLAN

VLAN（虚拟局域网）是一种将网络虚拟分割成许多不同子网的方法，也称为分段。每个分段将拥有自己的广播域，并与其他 VLAN 隔离。

在 FreeBSD 上，VLAN 必须由网络接口驱动程序支持。要查看哪些驱动程序支持 VLAN，请参阅 vlan(4)手册页。

在配置 VLAN 时，必须了解一些信息。首先，是哪个网络接口？其次，VLAN 标记是什么？

要在运行时配置 VLAN，使用 em0 的网卡和 5 的 VLAN 标记，命令如下：

```
# ifconfig em0.5 create vlan 5 vlandev em0 inet 192.168.20.20/24
```

|  | 看到接口名称包含了 NIC 驱动名称和 VLAN 标签，并用句号分隔了吗？这是一个最佳实践，可以在机器上存在多个 VLAN 时轻松维护 VLAN 配置。|
| -- | ----------------------------------------------------------------------------------------------------------------------------------- |

```
# ifconfig em0 up
```

要在启动时配置 VLAN，必须更新 /etc/rc.conf。要复制上述配置，需要添加以下内容：

```
vlans_em0="5"
ifconfig_em0_5="inet 192.168.20.20/24"
```

可以通过简单地将标签添加到 vlans_em0 字段并添加配置该 VLAN 标签接口的额外行来添加其他 VLAN。

```
ifconfig_em0="up"
```

为接口分配符号名称很有用，这样当关联的硬件更改时，只需要更新少量配置变量。例如，安全摄像头需要在 VLAN 1 上运行 em0。稍后，如果更换为使用 ixgb(4) 驱动程序的卡，所有对 em0.1 的引用都不需要更改为 ixgb0.1。

要配置 VLAN 5，在 NIC em0 上，分配接口名称 cameras，并为接口分配 IP 地址 <em>192.168.20.20</em>，使用 24 位前缀，使用此命令：

```
# ifconfig em0.5 create vlan 5 vlandev em0 name cameras inet 192.168.20.20/24
```

对于名为 video 的接口，请使用以下命令：

```
# ifconfig video.5 create vlan 5 vlandev video name cameras inet 192.168.20.20/24
```

要在启动时应用更改，请将以下行添加到 /etc/rc.conf 文件中：

```
vlans_video="cameras"
create_args_cameras="vlan 5"
ifconfig_cameras="inet 192.168.20.20/24"
```
