# 34.2.网关和路由

路由是一种机制，能让系统找到到达另一个系统的网络路径。路由是一对定义好的地址，代表“目的地”和“网关”。路由表明，当尝试到达指定目的地时，通过指定的网关发送数据包。有三种类型的目的地：单个主机、子网和“默认”。如果没有其他路由适用，将使用“默认路由”。网关也有三种类型：单个主机、接口（也称为链路）和以太网硬件（MAC 地址）。已知的路由存储在路由表中。

本节概述了路由基础知识。然后演示如何将 FreeBSD 系统配置为路由器，并提供一些故障排除技巧。

### 34.2.1. 路由基础

要查看 FreeBSD 系统的路由表，请使用 netstat(1)命令：

```
% netstat -r
Routing tables

Internet:
Destination      Gateway            Flags     Refs     Use     Netif Expire
default          outside-gw         UGS        37      418       em0
localhost        localhost          UH          0      181       lo0
test0            0:e0:b5:36:cf:4f   UHLW        5    63288       re0     77
10.20.30.255     link#1             UHLW        1     2421
example.com      link#1             UC          0        0
host1            0:e0:a8:37:8:1e    UHLW        3     4601       lo0
host2            0:e0:a8:37:8:1e    UHLW        0        5       lo0 =>
host2.example.com link#1            UC          0        0
224              link#1             UC          0        0
```

此示例中的条目如下：

 默认

该表中的第一条路由指定了 default 路由。当本地系统需要与远程主机建立连接时，它会检查路由表以确定是否存在已知路径。如果远程主机匹配表中的某个条目，系统将检查是否可以使用该条目中指定的接口进行连接。

如果目标与任何条目都不匹配，或者所有已知路径失败，系统将使用默认路由的条目。对于本地区域网络上的主机，默认路由中的 Gateway 字段设置为直接连接到互联网的系统。在阅读该条目时，请验证 Flags 列是否指示网关是否可用（ UG ）。

如果某台主机本身作为通往外部世界的网关，则其默认路由将是互联网服务提供商（ISP）处的网关机器。

 本地主机

第二条路由是 localhost 路由。localhost 在 Netif 列中指定的接口是 lo0，也称为环回设备。这表明所有到该目的地的流量都应是内部流量，而不是通过网络发送出去。

 MAC 地址

以 0:e0: 开头的地址是 MAC 地址。FreeBSD 将自动识别任何主机，例如例子中的 test0，在本地以太网上并添加一条通过以太网接口 re0 到该主机的路由。这种类型的路由有一个超时时间，见 Expire 列，如果主机在特定时间内没有响应，就会使用该超时时间。当这种情况发生时，到该主机的路由将被自动删除。这些主机使用路由信息协议（RIP）进行识别，该协议基于最短路径确定计算到本地主机的路由。

 子网

FreeBSD 将自动为本地子网添加子网路由。在这个例子中，10.20.30.255 是子网 10.20.30 的广播地址，example.com 是与该子网关联的域名。指定 link#1 指的是机器中的第一块以太网卡。

本地网络主机和本地子网的路由将由一个叫做 routed(8) 的守护进程自动配置。如果它没有运行，只有由管理员静态定义的路由存在。

 主机

host1 行指的是主机的以太网地址。由于它是发送主机，FreeBSD 知道要使用回环接口（lo0），而不是以太网接口。

这两个 host2 行表示使用 ifconfig(8)创建的别名。lo0 接口后面的 ⇒ 符号表示除了回环地址外还设置了别名。这样的路由只会出现在支持该别名的主机上，本地网络上的所有其他主机将为这样的路由 link#1 行。

224

最终一行（目的地子网 224 ）涉及多播。

每条路由的各种属性都可以在 Flags 列中看到。常见的路由表标志总结了其中一些标志及其含义：

表 1. 常见的路由表标志

| 旗帜 | 目的                                                                     |
| ------ | -------------------------------------------------------------------------- |
| U    | 路由处于活动状态（已启动）。                              |
| H    | 目的地路由是单一主机。                                    |
| G    | 将任何发往此目的地的内容发送到这个网关，然后网关会从那里决定发送到哪里。|
| S    | 这个路由是静态配置的。                                    |
| C    | 为机器连接而克隆基于此路由的新路由。这种类型的路由通常用于本地网络。  |
| W    | 此路由是基于本地区域网络（克隆）路由自动配置的。          |
| L    | 路由涉及到以太网（链路）硬件的引用。                      |

在 FreeBSD 系统上，可以通过在/etc/rc.conf 中指定默认网关的 IP 地址来定义默认路由：

```
defaultrouter="10.20.30.1"
```

也可以使用 route 手动添加路由:

```
# route add default 10.20.30.1
```

请注意，手动添加的路由在重启后不会保存。有关手动操作网络路由表的更多信息，请参考 route(8)。

### 34.2.2. 配置静态路由的路由器

一个 FreeBSD 系统如果是双主机系统，可以配置为网络的默认网关或路由器。双主机系统是指位于至少两个不同网络上的主机。通常，每个网络连接到一个独立的网络接口，虽然 IP 别名可以用于将多个地址绑定到一个物理接口上，每个地址位于不同的子网上。

为了使系统能够在接口之间转发数据包，FreeBSD 必须被配置为路由器。互联网标准和良好的工程实践阻止了 FreeBSD 项目默认启用此功能，但可以通过将以下行添加到/etc/rc.conf 来配置系统在启动时启用此功能：

```
gateway_enable="YES"          # Set to YES if this host will be a gateway
```

现在要启用路由，请将 sysctl(8) 变量 net.inet.ip.forwarding 设置为 1。要停止路由，请将此变量重置为 0。

路由器的路由表需要额外的路由条目，以便知道如何访问其他网络。路由可以通过静态路由手动添加，也可以通过路由协议自动学习。静态路由适用于小型网络，本节说明了如何为小型网络添加静态路由条目。

|  | 对于大型网络，静态路由很快就变得不可扩展。FreeBSD 自带标准的 BSD 路由守护程序 routed(8)，提供路由协议 RIP 版本 1 和 2，以及 IRDP 的支持。可以使用 net/quagga 软件包或 port 安装 BGP 和 OSPF 路由协议的支持。|
| -- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |

请考虑以下网络：

![static routes](https://docs.freebsd.org/images/books/handbook/advanced-networking/static-routes.png)

在这种情况下，RouterA 是一台充当路由器的 FreeBSD 机器，连接到互联网的其他部分。它设置了一个指向 10.0.0.1 的默认路由，使其能够连接到外部世界。RouterB 已经配置为使用 192.168.1.1 作为其默认网关。

在添加任何静态路由之前，RouterA 上的路由表如下所示：

```
% netstat -nr
Routing tables

Internet:
Destination        Gateway            Flags    Refs      Use  Netif  Expire
default            10.0.0.1           UGS         0    49378    xl0
127.0.0.1          127.0.0.1          UH          0        6    lo0
10.0.0.0/24        link#1             UC          0        0    xl0
192.168.1.0/24     link#2             UC          0        0    xl1
```

当前的路由表中，RouterA 没有到达 192.168.2.0/24 网络的路由。以下命令使用 192.168.1.2 作为下一跳，将 Internal Net 2 网络添加到 RouterA 的路由表中：

```
# route add -net 192.168.2.0/24 192.168.1.2
```

现在，RouterA 可以访问 192.168.2.0/24 网络上的任何主机。但是，如果 FreeBSD 系统重启，路由信息将不会保留。如果需要静态路由保持持久性，将其添加到 /etc/rc.conf 文件中：

```
# Add Internal Net 2 as a persistent static route
static_routes="internalnet2"
route_internalnet2="-net 192.168.2.0/24 192.168.1.2"
```

static_routes 配置变量是一个由空格分隔的字符串列表，其中每个字符串引用一个路由名称。变量 route_internalnet2 包含该路由名称的静态路由。

使用 static_routes 中的多个字符串将创建多个静态路由。以下是添加 192.168.0.0/24 和 192.168.1.0/24 网络静态路由的示例：

```
static_routes="net1 net2"
route_net1="-net 192.168.0.0/24 192.168.0.1"
route_net2="-net 192.168.1.0/24 192.168.1.1"
```

### 34.2.3. 故障排除

当向网络分配地址空间时，服务提供商会配置其路由表，以便将网络的所有流量发送到站点的链路。但外部站点如何知道将其数据包发送到网络的 ISP？

有一个系统跟踪所有分配的地址空间，并定义它们与互联网主干的连接点，也就是贯穿整个国家和全球的主干线路，它们承载着互联网流量。每个主干机器都有一个主要表的副本，这些表将特定网络的流量引导到特定的主干载波，然后通过服务提供商链路传输，直到到达特定网络。

服务提供商的任务是向主干站点宣传它们是连接点，从而是站点的内部路径。这就是路径传播。

有时，路径传播会出现问题，一些站点无法连接。当路由发生故障时，尝试找出路由中断的最有用的命令可能是 traceroute。当 ping 失败时，这个命令很有用。

使用 traceroute 时，请包括要连接的远程主机的地址。输出将显示尝试的路径上的网关主机，最终要么到达目标主机，要么因为连接不足而终止。有关更多信息，请参考 traceroute（8）。

### 34.2.4. 多播注意事项

FreeBSD 原生支持多播应用程序和多播路由。在 FreeBSD 上运行多播应用程序不需要任何特殊配置。支持多播路由需要将以下选项编译到自定义内核中：

```
options MROUTING
```

多播路由守护程序 mrouted 可以使用 net/mrouted 软件包或port进行安装。该守护程序实现 DVMRP 多播路由协议，并通过编辑/usr/local/etc/mrouted.conf 进行配置，以建立隧道和 DVMRP。安装 mrouted 还安装了 map-mbone 和 mrinfo，以及它们各自的 man 页。请参考这些内容查看配置示例。

|  | 在许多多播安装中，DVMRP 已被 PIM 协议大量取代。有关更多信息，请参阅 pim(4)。|
| -- | ------------------------------------------------------------------------------ |
