# 34.3.虚拟主机

FreeBSD 的常见用途是虚拟站点托管，在这种情况下，一个服务器看起来像是许多服务器。这是通过为单个接口分配多个网络地址来实现的。

给定的网络接口有一个“真实”地址，可能有任意数量的“别名”地址。这些别名通常是通过在/etc/rc.conf 中放置别名条目来添加的，就像在这个例子中看到的那样。

```
# sysrc ifconfig_fxp0_alias0="inet xxx.xxx.xxx.xxx netmask xxx.xxx.xxx.xxx"
```

别名条目必须以 alias*0* 开头，使用诸如 alias0 、 alias1 等的顺序号。配置过程将在第一个缺失的数字处停止。

别名掩码的计算很重要。对于给定的接口，必须有一个地址正确地表示网络的子网掩码。此网络中的任何其他地址必须具有全为 1 的掩码，表示为 255.255.255.255 或 0xffffffff。

例如，考虑这样一种情况： fxp0 接口连接到两个网络：具有子网掩码 255.255.255.0 的 10.1.1.0 和具有子网掩码 255.255.255.240 的 202.0.75.16。系统将被配置为出现在 10.1.1.1 到 10.1.1.5 和 202.0.75.17 到 202.0.75.20 的范围内。给定网络范围中的第一个地址应具有真实子网掩码。所有其他地址（ 10.1.1.2 到 10.1.1.5 和 202.0.75.18 到 202.0.75.20 ）必须配置为具有子网掩码 255.255.255.255。

以下 /etc/rc.conf 条目正确配置适配器以适应这种情况：

```
# sysrc ifconfig_fxp0="inet 10.1.1.1 netmask 255.255.255.0"
# sysrc ifconfig_fxp0_alias0="inet 10.1.1.2 netmask 255.255.255.255"
# sysrc ifconfig_fxp0_alias1="inet 10.1.1.3 netmask 255.255.255.255"
# sysrc ifconfig_fxp0_alias2="inet 10.1.1.4 netmask 255.255.255.255"
# sysrc ifconfig_fxp0_alias3="inet 10.1.1.5 netmask 255.255.255.255"
# sysrc ifconfig_fxp0_alias4="inet 202.0.75.17 netmask 255.255.255.240"
# sysrc ifconfig_fxp0_alias5="inet 202.0.75.18 netmask 255.255.255.255"
# sysrc ifconfig_fxp0_alias6="inet 202.0.75.19 netmask 255.255.255.255"
# sysrc ifconfig_fxp0_alias7="inet 202.0.75.20 netmask 255.255.255.255"
```

表达这一点的更简单方式是使用一个以空格分隔的 IP 地址范围列表。第一个地址将被给予指定的子网掩码，额外的地址将具有子网掩码 255.255.255.255。

```
# sysrc ifconfig_fxp0_aliases="inet 10.1.1.1-5/24 inet 202.0.75.17-20/28"
```
