# 34.4.无线高级身份验证

FreeBSD 支持连接到无线网络的不同方式。这一部分说明了如何对无线网络执行高级身份验证。

要建立连接并进行基本身份验证到无线网络，网络章节中的连接和身份验证到无线网络说明了如何执行此操作。

### 34.4.1. WPA with EAP-TLS

第二种使用 WPA 的方式是与 802.1X 后端认证服务器一起使用。在这种情况下，WPA 被称为 WPA Enterprise，以区分于较不安全的 WPA Personal。WPA Enterprise 中的认证基于可扩展认证协议（EAP）。

EAP 不带有加密方法。相反，EAP 嵌入在加密隧道中。有许多 EAP 身份验证方法，但 EAP-TLS、EAP-TTLS 和 EAP-PEAP 是最常见的。

具有传输层安全性（EAP-TLS）的 EAP 是一种得到良好支持的无线身份验证协议，因为它是第一个获得 Wi-Fi 联盟认证的 EAP 方法。EAP-TLS 需要三个证书才能运行：安装在所有机器上的证书颁发机构（CA）的证书，用于认证服务器的服务器证书，以及每个无线客户端的一个客户端证书。在这种 EAP 方法中，认证服务器和无线客户端通过展示各自的证书进行相互认证，然后验证这些证书是由组织的 CA 签名的。

与以前一样，配置是通过/etc/wpa_supplicant.conf 完成的：

```
network={
  ssid="freebsdap" 
  proto=RSN  
  key_mgmt=WPA-EAP 
  eap=TLS 
  identity="loader" 
  ca_cert="/etc/certs/cacert.pem" 
  client_cert="/etc/certs/clientcert.pem" 
  private_key="/etc/certs/clientkey.pem" 
  private_key_passwd="freebsdmallclient" 
}
```

|  | 此字段表示网络名称（SSID）。                                            |
| -- | ---------------------------------------------------------------------------------------- |
|  | 此示例使用 RSN IEEE® 802.11i 协议，也称为 WPA2。                       |
|  | key_mgmt 行指的是要使用的密钥管理协议。在此示例中，它是使用 EAP 认证的 WPA。 |
|  | 此字段表示连接的 EAP 方法。                                             |
|  | identity 字段包含 EAP 的身份字符串。                                    |
|  | ca_cert 字段表示 CA 证书文件的路径名。此文件用于验证服务器证书。        |
|  | client_cert 行提供了客户端证书文件的路径名。此证书对于网络的每个无线客户端都是唯一的。|
|  | private_key 字段是客户端证书私钥文件的路径名。                          |
|  | private_key_passwd 字段包含私钥的密码短语。                             |

然后，将以下行添加到 /etc/rc.conf 中：

```
wlans_ath0="wlan0"
ifconfig_wlan0="WPA DHCP"
```

下一步是启动接口：

```
# service netif start
Starting wpa_supplicant.
DHCPREQUEST on wlan0 to 255.255.255.255 port 67 interval 7
DHCPREQUEST on wlan0 to 255.255.255.255 port 67 interval 15
DHCPACK from 192.168.0.20
bound to 192.168.0.254 -- renewal in 300 seconds.
wlan0: flags=8843<UP,BROADCAST,RUNNING,SIMPLEX,MULTICAST> mtu 1500
      ether 00:11:95:d5:43:62
      inet 192.168.0.254 netmask 0xffffff00 broadcast 192.168.0.255
      media: IEEE 802.11 Wireless Ethernet DS/11Mbps mode 11g
      status: associated
      ssid freebsdap channel 1 (2412 Mhz 11g) bssid 00:11:95:c3:0d:ac
      country US ecm authmode WPA2/802.11i privacy ON deftxkey UNDEF
      AES-CCM 3:128-bit txpower 21.5 bmiss 7 scanvalid 450 bgscan
      bgscanintvl 300 bgscanidle 250 roam:rssi 7 roam:rate 5 protmode CTS
      wme burst roaming MANUAL
```

也可以使用 wpa_supplicant(8) 和 ifconfig(8) 手动启动接口。

### 34.4.2. 使用 EAP-TTLS 的 WPA

使用 EAP-TLS，认证服务器和客户端都需要证书。使用 EAP-TTLS，客户端证书是可选的。这种方法类似于一个 Web 服务器，即使访问者没有客户端证书，也会创建一个安全的 SSL 隧道。EAP-TTLS 使用加密的 TLS 隧道来安全传输认证数据。

所需的配置可以添加到 /etc/wpa_supplicant.conf：

```
network={
  ssid="freebsdap"
  proto=RSN
  key_mgmt=WPA-EAP
  eap=TTLS 
  identity="test" 
  password="test" 
  ca_cert="/etc/certs/cacert.pem" 
  phase2="auth=MD5" 
}
```

|  | 该字段指定连接的 EAP 方法。                                                                                    |
| -- | ------------------------------------------------------------------------------------------------------------------------------- |
|  | “ identity ”字段包含加密的 TLS 隧道中用于 EAP 认证的标识字符串。                                             |
|  | “ password ”字段包含用于 EAP 认证的密钥。                                                                    |
|  | ca_cert 字段指示 CA 证书文件的路径名。需要此文件来验证服务器证书。                                             |
|  | 此字段指定加密 TLS 隧道中使用的身份验证方法。在此示例中，使用 EAP 与 MD5-Challenge。通常将“内部认证”阶段称为“第 2 阶段”。|

接下来，将以下行添加到/etc/rc.conf 中：

```
wlans_ath0="wlan0"
ifconfig_wlan0="WPA DHCP"
```

下一步是启动接口：

```
# service netif start
Starting wpa_supplicant.
DHCPREQUEST on wlan0 to 255.255.255.255 port 67 interval 7
DHCPREQUEST on wlan0 to 255.255.255.255 port 67 interval 15
DHCPREQUEST on wlan0 to 255.255.255.255 port 67 interval 21
DHCPACK from 192.168.0.20
bound to 192.168.0.254 -- renewal in 300 seconds.
wlan0: flags=8843<UP,BROADCAST,RUNNING,SIMPLEX,MULTICAST> mtu 1500
      ether 00:11:95:d5:43:62
      inet 192.168.0.254 netmask 0xffffff00 broadcast 192.168.0.255
      media: IEEE 802.11 Wireless Ethernet DS/11Mbps mode 11g
      status: associated
      ssid freebsdap channel 1 (2412 Mhz 11g) bssid 00:11:95:c3:0d:ac
      country US ecm authmode WPA2/802.11i privacy ON deftxkey UNDEF
      AES-CCM 3:128-bit txpower 21.5 bmiss 7 scanvalid 450 bgscan
      bgscanintvl 300 bgscanidle 250 roam:rssi 7 roam:rate 5 protmode CTS
      wme burst roaming MANUAL
```

### 34.4.3. WPA 与 EAP-PEAP

|  | PEAPv0/EAP-MSCHAPv2 是最常见的 PEAP 方法。本章中，术语 PEAP 用来指代该方法。|
| -- | ------------------------------------------------------------------------------ |

受保护的 EAP（PEAP）被设计为 EAP-TTLS 的替代方案，在 EAP-TLS 之后是最常用的 EAP 标准。在具有混合操作系统的网络中，PEAP 应该是仅次于 EAP-TLS 的最受支持的标准。

PEAP 类似于 EAP-TTLS，因为它使用服务器端证书通过在客户端和认证服务器之间创建加密的 TLS 隧道来对客户端进行身份验证，从而保护随后的身份验证信息交换。PEAP 身份验证与 EAP-TTLS 不同，因为它以明文广播用户名，只有密码在加密的 TLS 隧道中发送。EAP-TTLS 将同时使用 TLS 隧道用于用户名和密码。

将以下行添加到/etc/wpa_supplicant.conf 以配置与 EAP-PEAP 相关的设置：

```
network={
  ssid="freebsdap"
  proto=RSN
  key_mgmt=WPA-EAP
  eap=PEAP 
  identity="test" 
  password="test" 
  ca_cert="/etc/certs/cacert.pem" 
  phase1="peaplabel=0" 
  phase2="auth=MSCHAPV2" 
}
```

|  | 此字段指定连接的 EAP 方法。                                                                                                                                                        |
| -- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
|  | identity 字段包含加密的 TLS 隧道内用于 EAP 身份验证的标识字符串。                                                                                                                  |
|  | password 字段包含用于 EAP 身份验证的密码。                                                                                                                                         |
|  | ca_cert 字段表示 CA 证书文件的路径名。需要此文件来验证服务器证书。                                                                                                                 |
|  | 此字段包含第一个认证阶段 TLS 隧道的参数。根据所使用的认证服务器，指定认证的特定标签。大多数情况下，标签将是使用 peaplabel=0 设置的"客户端 EAP 加密"。更多信息可以在 wpasupplicant.conf(5)中找到。|
|  | 此字段指定在加密的 TLS 隧道中使用的认证协议。在 PEAP 的情况下，它是 auth=MSCHAPV2。                                                                                               |

将以下内容添加到 /etc/rc.conf 中：

```
wlans_ath0="wlan0"
ifconfig_wlan0="WPA DHCP"
```

然后，启动接口：

```
# service netif start
Starting wpa_supplicant.
DHCPREQUEST on wlan0 to 255.255.255.255 port 67 interval 7
DHCPREQUEST on wlan0 to 255.255.255.255 port 67 interval 15
DHCPREQUEST on wlan0 to 255.255.255.255 port 67 interval 21
DHCPACK from 192.168.0.20
bound to 192.168.0.254 -- renewal in 300 seconds.
wlan0: flags=8843<UP,BROADCAST,RUNNING,SIMPLEX,MULTICAST> mtu 1500
      ether 00:11:95:d5:43:62
      inet 192.168.0.254 netmask 0xffffff00 broadcast 192.168.0.255
      media: IEEE 802.11 Wireless Ethernet DS/11Mbps mode 11g
      status: associated
      ssid freebsdap channel 1 (2412 Mhz 11g) bssid 00:11:95:c3:0d:ac
      country US ecm authmode WPA2/802.11i privacy ON deftxkey UNDEF
      AES-CCM 3:128-bit txpower 21.5 bmiss 7 scanvalid 450 bgscan
      bgscanintvl 300 bgscanidle 250 roam:rssi 7 roam:rate 5 protmode CTS
      wme burst roaming MANUAL
```
