# 34.5.无线自组织（Ad-hoc）模式

IBSS 模式，也称为自组织模式，用于点对点连接。例如，要在 A 和 B 之间建立一个自组织网络，选择两个 IP 地址和一个 SSID。

 在 A 上：

```
# ifconfig wlan0 create wlandev ath0 wlanmode adhoc
# ifconfig wlan0 inet 192.168.0.1 netmask 255.255.255.0 ssid freebsdap
# ifconfig wlan0
  wlan0: flags=8843<UP,BROADCAST,RUNNING,SIMPLEX,MULTICAST> metric 0 mtu 1500
	  ether 00:11:95:c3:0d:ac
	  inet 192.168.0.1 netmask 0xffffff00 broadcast 192.168.0.255
	  media: IEEE 802.11 Wireless Ethernet autoselect mode 11g <adhoc>
	  status: running
	  ssid freebsdap channel 2 (2417 Mhz 11g) bssid 02:11:95:c3:0d:ac
	  country US ecm authmode OPEN privacy OFF txpower 21.5 scanvalid 60
	  protmode CTS wme burst
```

adhoc 参数指示接口正在以 IBSS 模式运行。

现在应该能检测到 A ：

```
# ifconfig wlan0 create wlandev ath0 wlanmode adhoc
# ifconfig wlan0 up scan
  SSID/MESH ID    BSSID              CHAN RATE   S:N     INT CAPS
  freebsdap       02:11:95:c3:0d:ac    2   54M -64:-96  100 IS   WME
```

输出中的 I 确认 A 处于临时模式。现在，配置 B 使用不同的 IP 地址：

```
# ifconfig wlan0 inet 192.168.0.2 netmask 255.255.255.0 ssid freebsdap
# ifconfig wlan0
  wlan0: flags=8843<UP,BROADCAST,RUNNING,SIMPLEX,MULTICAST> metric 0 mtu 1500
	  ether 00:11:95:d5:43:62
	  inet 192.168.0.2 netmask 0xffffff00 broadcast 192.168.0.255
	  media: IEEE 802.11 Wireless Ethernet autoselect mode 11g <adhoc>
	  status: running
	  ssid freebsdap channel 2 (2417 Mhz 11g) bssid 02:11:95:c3:0d:ac
	  country US ecm authmode OPEN privacy OFF txpower 21.5 scanvalid 60
	  protmode CTS wme burst
```

A 和 B 现在都可以交换信息了。

### 34.5.1. FreeBSD 主机访问点

FreeBSD 可以充当访问点（AP），从而无需购买硬件 AP 或运行自组网络。当 FreeBSD 机器充当到另一个网络（如互联网）的网关时，这尤其有用。

#### 34.5.1.1. 基本设置

在将 FreeBSD 机器配置为 AP 之前，必须为无线网卡以及使用的安全协议配置适当的网络支持。有关详细信息，请参阅[network-wireless-basic]。

|  | 用于 Windows® 驱动程序的 NDIS 驱动程序包装器当前不支持 AP 操作。只有原生 FreeBSD 无线驱动程序支持 AP 模式。|
| -- | -------------------------------------------------------------------------------------------------------------- |

若加载无线网络支持，请检查无线设备是否支持基于主机的访问点模式，也称为 hostap 模式：

```
# ifconfig wlan0 create wlandev ath0
# ifconfig wlan0 list caps
drivercaps=6f85edc1<STA,FF,TURBOP,IBSS,HOSTAP,AHDEMO,TXPMGT,SHSLOT,SHPREAMBLE,MONITOR,MBSS,WPA1,WPA2,BURST,WME,WDS,BGSCAN,TXFRAG>
cryptocaps=1f<WEP,TKIP,AES,AES_CCM,TKIPMIC>
```

此输出显示卡的功能。HOSTAP 一词确认此无线卡可以充当 AP。还列出了各种支持的密码：WEP、TKIP 和 AES。这些信息指示可以在 AP 上使用哪些安全协议。

无线设备只能在创建网络伪设备时放置到主机模式，因此必须先销毁先前创建的设备：

```
# ifconfig wlan0 destroy
```

然后使用正确的选项重新生成设备，然后设置其他参数：

```
# ifconfig wlan0 create wlandev ath0 wlanmode hostap
# ifconfig wlan0 inet 192.168.0.1 netmask 255.255.255.0 ssid freebsdap mode 11g channel 1
```

再次使用 ifconfig(8)查看 wlan0 接口的状态：

```
# ifconfig wlan0
  wlan0: flags=8843<UP,BROADCAST,RUNNING,SIMPLEX,MULTICAST> metric 0 mtu 1500
	  ether 00:11:95:c3:0d:ac
	  inet 192.168.0.1 netmask 0xffffff00 broadcast 192.168.0.255
	  media: IEEE 802.11 Wireless Ethernet autoselect mode 11g <hostap>
	  status: running
	  ssid freebsdap channel 1 (2412 Mhz 11g) bssid 00:11:95:c3:0d:ac
	  country US ecm authmode OPEN privacy OFF txpower 21.5 scanvalid 60
	  protmode CTS wme burst dtimperiod 1 -dfs
```

hostap 参数指示接口正在以基于主机的访问点模式运行。

可以通过在/etc/rc.conf 中添加以下行来在启动时自动完成接口配置：

```
wlans_ath0="wlan0"
create_args_wlan0="wlanmode hostap"
ifconfig_wlan0="inet 192.168.0.1 netmask 255.255.255.0 ssid freebsdap mode 11g channel 1"
```

#### 34.5.1.2. 在不进行身份验证或加密的基于主机的访问点

尽管不建议在没有任何身份验证或加密的情况下运行 AP，但这是检查 AP 是否工作的简单方法。这种配置对于调试客户端问题也很重要。

配置完 AP 后，从另一台无线机器发起扫描以找到 AP：

```
# ifconfig wlan0 create wlandev ath0
# ifconfig wlan0 up scan
SSID/MESH ID    BSSID              CHAN RATE   S:N     INT CAPS
freebsdap       00:11:95:c3:0d:ac    1   54M -66:-96  100 ES   WME
```

客户端机器找到了 AP 并可以与其关联：

```
# ifconfig wlan0 inet 192.168.0.2 netmask 255.255.255.0 ssid freebsdap
# ifconfig wlan0
  wlan0: flags=8843<UP,BROADCAST,RUNNING,SIMPLEX,MULTICAST> metric 0 mtu 1500
	  ether 00:11:95:d5:43:62
	  inet 192.168.0.2 netmask 0xffffff00 broadcast 192.168.0.255
	  media: IEEE 802.11 Wireless Ethernet OFDM/54Mbps mode 11g
	  status: associated
	  ssid freebsdap channel 1 (2412 Mhz 11g) bssid 00:11:95:c3:0d:ac
	  country US ecm authmode OPEN privacy OFF txpower 21.5 bmiss 7
	  scanvalid 60 bgscan bgscanintvl 300 bgscanidle 250 roam:rssi 7
	  roam:rate 5 protmode CTS wme burst
```

#### 34.5.1.3. WPA2 基于主机的接入点

本节重点介绍如何使用 WPA2 安全协议在 FreeBSD 接入点上进行设置。有关 WPA 和基于 WPA 的无线客户端配置的更多详细信息，请参阅[network-wireless-wpa]。

hostapd(8)守护程序用于处理 WPA2 启用的接入点上的客户端身份验证和密钥管理。

在 FreeBSD 机器上执行以下配置操作，该机器作为 AP。若 AP 工作正常，可以在/etc/rc.conf 中添加以下内容，使 hostapd(8)能够在启动时自动启动:

```
hostapd_enable="YES"
```

在尝试配置 hostapd(8)之前，先配置 Basic Settings 中介绍的基本设置。

##### 34.5.1.3.1. WPA2-PSK

WPA2-PSK 适用于小型网络，其中不可能或不希望使用后端身份验证服务器。

配置在 /etc/hostapd.conf 中完成：

```
interface=wlan0          
debug=1                  
ctrl_interface=/var/run/hostapd  
ctrl_interface_group=wheel   
ssid=freebsdap           
wpa=2                    
wpa_passphrase=freebsdmall   
wpa_key_mgmt=WPA-PSK     
wpa_pairwise=CCMP        
```

|  | 用于访问点的无线接口。                                                                                                                |
| -- | ------------------------------------------------------------------------------------------------------------------------------------------------------ |
|  | 在主机 ap(8)执行期间使用的详细级别。1 的值代表最小级别。                                                                             |
|  | hostapd(8)用于存储与外部程序（如 hostapdcli(8)）通信的域套接字文件的目录路径。在此示例中使用默认值。                                  |
|  | 允许访问控制接口文件的组。                                                                                                            |
|  | 无线网络名称或 SSID，将出现在无线扫描中。                                                                                             |
|  | 启用 WPA 并指定所需的 WPA 认证协议。值 2 将 AP 配置为 WPA2，推荐使用。仅在需要过时的 WPA 时设置为 1。                                |
|  | 用于 WPA 认证的 ASCII 密码短语。                                                                                                      |
|  | 要使用的密钥管理协议。此示例设置 WPA-PSK。                                                                                            |
|  | 接入点接受的加密算法。在此示例中，只接受 CCMP (AES) 密码。CCMP 是 TKIP 的替代方案，并在可能时强烈推荐使用。TKIP 应该仅在无法使用 CCMP 的情况下允许。|

下一步是启动 hostapd(8)：

```
# service hostapd forcestart
```

```
# ifconfig wlan0
wlan0: flags=8943<UP,BROADCAST,RUNNING,PROMISC,SIMPLEX,MULTICAST> metric 0 mtu 1500
	ether 04:f0:21:16:8e:10
	inet6 fe80::6f0:21ff:fe16:8e10%wlan0 prefixlen 64 scopeid 0x9
	nd6 options=21<PERFORMNUD,AUTO_LINKLOCAL>
	media: IEEE 802.11 Wireless Ethernet autoselect mode 11na <hostap>
	status: running
	ssid No5ignal channel 36 (5180 MHz 11a ht/40+) bssid 04:f0:21:16:8e:10
	country US ecm authmode WPA2/802.11i privacy MIXED deftxkey 2
	AES-CCM 2:128-bit AES-CCM 3:128-bit txpower 17 mcastrate 6 mgmtrate 6
	scanvalid 60 ampdulimit 64k ampdudensity 8 shortgi wme burst
	dtimperiod 1 -dfs
	groups: wlan
```

若 AP 运行起来，客户端可以与其关联。有关更多详细信息，请参阅[network-wireless-wpa]。可以使用 `ifconfig wlan0 list sta` 查看与 AP 关联的站点。
