# 34.9.链路聚合与故障转移

FreeBSD 提供了可以将多个网络接口聚合成一个虚拟接口的 lagg（4）接口，以实现故障转移和链路聚合。故障转移能让流量继续流动，只要至少有一个聚合的网络接口建立了连接。链路聚合在支持 LACP 的交换机上效果最好，因为该协议可以双向分发流量，并在单个链路发生故障时做出响应。

lagg 接口支持的聚合协议确定用于传出流量的ports以及特定port是否接受传入流量。lagg(4) 支持以下协议：

 故障转移

此模式仅通过主port发送和接收流量。如果主port不可用，则使用下一个活动的port。添加到虚拟接口的第一个接口是主port，随后添加的所有接口均用作故障转移设备。如果故障转移到非主port，则原始port再次可用后将恢复为主。

 负载均衡

这提供了一个静态设置，不与对端协商聚合，也不交换帧来监控链路。如果交换机支持 LACP，则应使用 LACP。

lacp

IEEE® 802.3ad 链路聚合控制协议（LACP）与对等方协商一组可聚合的链路，形成一个或多个链路聚合组（LAG）。每个 LAG 由ports相同速度的链路组成，设置为全双工操作，并通过具有最大总速度的 LAG 中的ports平衡流量。通常，只有一个包含所有ports的 LAG。在物理连接发生变化时，LACP 将迅速收敛到新配置。

LACP 根据散列协议头信息平衡传出流量，并接受来自任何活动port的传入流量。散列包括以太网源和目的地址，如果可用，则包括 VLAN 标记，以及 IPv4 或 IPv6 源和目的地址。

 轮询

该模式使用循环调度程序通过所有活动的 ports 分发传出流量，并从任何活动的 port 接收传入流量。由于这种模式违反了以太网帧顺序，应谨慎使用。

 广播

该模式将传出流量发送到 lagg 接口上配置的所有 ports，并在任何 port 上接收帧。

### 34.9.1。配置示例

本节演示如何配置 Cisco® 交换机和 FreeBSD 系统以进行 LACP 负载平衡。然后显示如何在冗余模式下配置两个以太网接口，以及如何在以太网接口和无线接口之间配置故障切换模式。

示例 1。使用 Cisco® 交换机进行 LACP 聚合

本示例将 FreeBSD 机器上的两个 fxp(4)以太网接口连接到 Cisco®交换机上的前两个以太网ports，作为单一负载均衡和容错链接。可以添加更多接口以增加吞吐量和容错能力。请根据本地配置替换示例中显示的 Cisco® ports、以太网设备、信道组号和 IP 地址的名称。

在以太网链路上，帧排序是强制的，两个站点之间的任何流量始终通过同一物理链路流动，将最大速度限制在一个接口的速度。发送算法尝试尽可能多地使用信息来区分不同的流量，并在可用接口之间平衡流量。

在 Cisco®交换机上，将 FastEthernet0/1 和 FastEthernet0/2 接口添加到信道组 1 中：

```
interface FastEthernet0/1
 channel-group 1 mode active
 channel-protocol lacp
!
interface FastEthernet0/2
 channel-group 1 mode active
 channel-protocol lacp
```

在 FreeBSD 系统上，使用物理接口 fxp0 和 fxp1 创建 lagg(4)接口，并使用 IP 地址 10.0.0.3/24 将接口激活：

```
# ifconfig fxp0 up
# ifconfig fxp1 up
# ifconfig lagg0 create
# ifconfig lagg0 up laggproto lacp laggport fxp0 laggport fxp1 10.0.0.3/24
```

接下来，验证虚拟接口的状态：

```
# ifconfig lagg0
lagg0: flags=8843<UP,BROADCAST,RUNNING,SIMPLEX,MULTICAST> metric 0 mtu 1500
        options=8<VLAN_MTU>
        ether 00:05:5d:71:8d:b8
        inet 10.0.0.3 netmask 0xffffff00 broadcast 10.0.0.255
        media: Ethernet autoselect
        status: active
        laggproto lacp
        laggport: fxp1 flags=1c<ACTIVE,COLLECTING,DISTRIBUTING>
        laggport: fxp0 flags=1c<ACTIVE,COLLECTING,DISTRIBUTING>
```

Ports标记为 ACTIVE 是已与远程交换机协商过的 LAG 的一部分。流量将通过这些活动的ports进行发送和接收。在上述命令中加上 -v 以查看 LAG 标识符。

要查看 Cisco® 交换机上的 port 状态：

```
switch# show lacp neighbor
Flags:  S - Device is requesting Slow LACPDUs
        F - Device is requesting Fast LACPDUs
        A - Device is in Active mode       P - Device is in Passive mode

Channel group 1 neighbors

Partner's information:

                  LACP port                        Oper    Port     Port
Port      Flags   Priority  Dev ID         Age     Key     Number   State
Fa0/1     SA      32768     0005.5d71.8db8  29s    0x146   0x3      0x3D
Fa0/2     SA      32768     0005.5d71.8db8  29s    0x146   0x4      0x3D
```

要获取更多详细信息，请输入 show lacp neighbor detail。

要在 FreeBSD 系统上的 /etc/rc.conf 中添加以下条目以保留此配置跨重启：

```
ifconfig_fxp0="up"
ifconfig_fxp1="up"
cloned_interfaces="lagg0"
ifconfig_lagg0="laggproto lacp laggport fxp0 laggport fxp1 10.0.0.3/24"
```

示例 2. 故障转移模式

如果主接口丢失连接，可以使用故障转移模式切换到次要接口。要配置故障转移，请确保基础物理接口正常运行，然后创建 lagg(4)接口。在此示例中，fxp0 是主接口，fxp1 是次要接口，并且虚拟接口被分配 IP 地址 10.0.0.15/24：

```
# ifconfig fxp0 up
# ifconfig fxp1 up
# ifconfig lagg0 create
# ifconfig lagg0 up laggproto failover laggport fxp0 laggport fxp1 10.0.0.15/24
```

虚拟接口应该类似于这样：

```
# ifconfig lagg0
lagg0: flags=8843<UP,BROADCAST,RUNNING,SIMPLEX,MULTICAST> metric 0 mtu 1500
        options=8<VLAN_MTU>
        ether 00:05:5d:71:8d:b8
        inet 10.0.0.15 netmask 0xffffff00 broadcast 10.0.0.255
        media: Ethernet autoselect
        status: active
        laggproto failover
        laggport: fxp1 flags=0<>
        laggport: fxp0 flags=5<MASTER,ACTIVE>
```

流量将通过 fxp0 进行传输和接收。如果 fxp0 上的连接丢失，fxp1 将成为活动链接。如果主接口上的连接恢复，它将再次成为活动链接。

要跨重启保留此配置，请将以下条目添加到/etc/rc.conf 中：

```
ifconfig_fxp0="up"
ifconfig_fxp1="up"
cloned_interfaces="lagg0"
ifconfig_lagg0="laggproto failover laggport fxp0 laggport fxp1 10.0.0.15/24"
```

例 3。以太网和无线接口之间的故障转移模式

对于笔记本电脑用户，通常希望将无线设备配置为次要设备，仅在以太网连接不可用时使用。通过 lagg(4)，可以配置故障转移，优先考虑以太网连接，同时保持通过无线连接传输数据的能力。

这是通过使用无线接口的 MAC 地址覆盖以太网接口的 MAC 地址来实现的。

理论上，可以更改以太网或无线 MAC 地址以匹配另一个。然而，一些流行的无线接口不支持覆盖 MAC 地址。因此，我们建议为此目的覆盖以太网 MAC 地址。

如果在 GENERIC 或自定义内核中未加载无线接口的驱动程序，并且计算机正在运行 FreeBSD 12.1，则通过在 /boot/loader.conf 中添加 <strong>driver_load="YES"</strong> 并重启来加载相应的 .ko。另一种更好的方法是通过将其添加到 /etc/rc.conf 中（有关详细信息，请参阅 rc.conf(5)）加载驱动程序，并重启。这是必需的，否则在设置 lagg(4) 接口时，驱动程序尚未加载。

在此示例中，以太网接口 re0 是主接口，无线接口 wlan0 是故障转移接口。wlan0 接口是从 ath0 物理无线接口创建的，并且以太网接口将配置为无线接口的 MAC 地址。首先，启动无线接口（用自己的 2 个字母国家代码替换 FR），但不设置 IP 地址。将 wlan0 替换为系统的无线接口名称：

```
# ifconfig wlan0 create wlandev ath0 country FR ssid my_router up
```

现在，你可以确定无线接口的 MAC 地址：

```
# ifconfig wlan0
wlan0: flags=8843<UP,BROADCAST,RUNNING,SIMPLEX,MULTICAST> metric 0 mtu 1500
	ether b8:ee:65:5b:32:59
	groups: wlan
	ssid Bbox-A3BD2403 channel 6 (2437 MHz 11g ht/20) bssid 00:37:b7:56:4b:60
	regdomain ETSI country FR indoor ecm authmode WPA2/802.11i privacy ON
	deftxkey UNDEF AES-CCM 2:128-bit txpower 30 bmiss 7 scanvalid 60
	protmode CTS ampdulimit 64k ampdudensity 8 shortgi -stbctx stbcrx
	-ldpc wme burst roaming MANUAL
	media: IEEE 802.11 Wireless Ethernet MCS mode 11ng
	status: associated
	nd6 options=29<PERFORMNUD,IFDISABLED,AUTO_LINKLOCAL>
```

ether 行将包含指定接口的 MAC 地址。现在，将以太网接口的 MAC 地址更改为匹配：

```
# ifconfig re0 ether b8:ee:65:5b:32:59
```

确保 re0 接口正常运行，然后使用 re0 作为主控，故障转移至 wlan0 创建 lagg(4) 接口：

```
# ifconfig re0 up
# ifconfig lagg0 create
# ifconfig lagg0 up laggproto failover laggport re0 laggport wlan0
```

虚拟接口应该看起来像这样：

```
# ifconfig lagg0
lagg0: flags=8843<UP,BROADCAST,RUNNING,SIMPLEX,MULTICAST> metric 0 mtu 1500
        options=8<VLAN_MTU>
        ether b8:ee:65:5b:32:59
        laggproto failover lagghash l2,l3,l4
        laggport: re0 flags=5<MASTER,ACTIVE>
        laggport: wlan0 flags=0<>
        groups: lagg
        media: Ethernet autoselect
        status: active
```

然后，启动 DHCP 客户端以获取 IP 地址：

```
# dhclient lagg0
```

为了在重启后保留此配置，请将以下条目添加到/etc/rc.conf：

```
ifconfig_re0="ether b8:ee:65:5b:32:59"
wlans_ath0="wlan0"
ifconfig_wlan0="WPA"
create_args_wlan0="country FR"
cloned_interfaces="lagg0"
ifconfig_lagg0="up laggproto failover laggport re0 laggport wlan0 DHCP"
```
