# 4.2.软件安装的概述

FreeBSD *port* 是一组旨在自动化从源代码编译应用程序的过程的文件。这些组成 Ports 的文件包含所有必要的信息，能够自动下载、解压、打补丁、编译和安装应用程序。

如果软件尚未适配并经过 FreeBSD 测试，可能需要编辑源代码，以便其能够正确安装和运行。

然而，已有超过 [36000](https://ports.freebsd.org/) 种第三方应用程序被移植到 FreeBSD。当可行时，这些应用程序会作为预编译的 *包* 提供下载。

可以使用 FreeBSD 包管理命令来操作包。

包和 Ports 都能处理依赖关系。如果使用包或 Ports 安装应用程序，而所依赖的库尚未安装，库将自动先行安装。

FreeBSD 包包含应用程序的所有命令的预编译副本，以及任何配置文件和文档。可以使用 [pkg(8)](https://man.freebsd.org/cgi/man.cgi?query=pkg&sektion=8&format=html) 命令（例如 `pkg install`）来操作包。

尽管这两种技术相似，包和 Ports 各自有其优势。选择符合你需求的技术来安装特定应用程序。

**包的优点**

* 压缩的包 tarball 通常比包含应用程序源代码的压缩包小。
* 包不需要编译时间。对于大型应用程序，如 Firefox、KDE Plasma 或 GNOME，这在系统较慢时尤为重要。
* 包不需要理解在 FreeBSD 上编译软件的过程。

** Ports 的优点**

* 包通常使用保守选项进行编译，因为它们必须在最大数量的系统上运行。通过从 Ports 编译，可以更改编译选项。
* 一些应用程序有与安装特性相关的编译时选项。例如，NGINX® 可以通过各种内建选项进行配置。
  在某些情况下，同一个应用程序可能会有多个包，配置不同的选项。例如，NGINX® 有 `nginx` 包和 `nginx-lite` 包，前者启用了更多的选项，但这也需要安装更多的依赖项，因此会增加空间消耗和攻击面。

  传递依赖项可能会变得相当庞大，例如完整的 `nginx` 包会拉入多个 X 库，这可能让人感到惊讶，因此从 Ports 编译可以让你选择仅需要的选项，而不使用“万金油”方法。在某些情况下，可能会为同一应用程序提供多个包，以指定特定设置。
* 某些软件的许可条款禁止二进制分发。这类软件必须以源代码形式分发，且必须由最终用户编译。
* 有些人不信任二进制分发，或更愿意通过源代码查找潜在问题。
* 应用自定义补丁时需要源代码。

要跟踪更新的 Port，可以订阅 [FreeBSD  Ports 邮件列表](https://lists.freebsd.org/subscription/freebsd-ports) 和 [FreeBSD  Ports 错误邮件列表](https://lists.freebsd.org/subscription/freebsd-ports-bugs)。

>**警告**
>
>在安装应用程序之前，请检查 [https://vuxml.freebsd.org/](https://vuxml.freebsd.org/) 以了解相关的安全问题。
>
>要审核已安装的包以检查已知漏洞，请运行 `pkg audit -F`。 

本章其余部分将解释如何使用包和 Ports 在 FreeBSD 上安装和管理第三方软件。
