# 4.5.使用 Ports


ports 是一组 Makefiles，补丁和说明文件。这些文件集用于在 FreeBSD 上编译和安装单个应用程序，并被称为port。

默认情况下，Ports 本身存储为 /usr/ports 的子目录。

|  | 在安装和使用 Ports 之前，请注意，通常不建议使用 Ports 与通过 pkg 提供的二进制软件包同时安装软件。pkg 默认跟踪 ports 源代码的季度分支发布，而不是 HEAD。与季度分支发布中的 port 相比，HEAD 中的 port 依赖关系可能不同，这可能导致 pkg 安装的依赖关系与 Ports 中的依赖关系之间发生冲突。如果必须同时使用 Ports 和 pkg，则请确保你的 Ports 和 pkg 处于相同的 ports 源代码分支发布上。|
| -- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |

Ports 包含了软件类别的目录。在每个类别内部，有各个应用程序的子目录。每个应用程序子目录包含一组文件，告诉 FreeBSD 如何编译和安装该程序，称为 ports 骨架。每个 port 骨架包括这些文件和目录：

* Makefile：包含指定应用程序应如何编译以及其组件应安装到何处的代码。
* distinfo：包含必须下载的文件的名称和校验和，以构建 port。
* files/：此目录包含编译和在 FreeBSD 上安装程序所需的任何补丁。此目录还可能包含用于构建 port 的其他文件。
* 提供程序的更详细说明。
* pkg-plist: 将由port安装的所有文件列表。它还告诉ports系统在卸载时要删除哪些文件。

某些ports包括 pkg-message 或其他文件来处理特殊情况。有关这些文件以及ports的更多详细信息，请参阅 FreeBSD Porter's Handbook。

该port不包含实际的源代码，也被称为 distfile。构建port的解压缩部分将自动将下载的源代码保存到 /usr/ports/distfiles。

#### 4.5.1. 安装ports 

在使用port编译应用程序之前，必须先安装ports 。如果在安装 FreeBSD 期间没有安装它，请使用以下方法之一进行安装：

** 过程：Git 方法**

如果需要对 ports 树有更多控制，或者需要维护本地更改，或者运行 FreeBSD-CURRENT，可以使用 Git 来获取 Ports 。有关 Git 的详细说明，请参阅 Git Primer。

我们在 git 命令行中添加 --depth 1 来克隆树而不获取提交历史，这样可以节省时间，对大多数用户来说是可以接受的。如果你对 ports 树有自己的更改，或者因任何原因需要历史记录，请省略下面的 --depth 1 参数。

1. Git 必须安装好才能用来检出 ports 树。如果已经有一份 ports 源代码，请这样安装 Git：

    ```
    # cd /usr/ports/devel/git
    # make install clean
    ```

    如果 ports 不可用，或者正在使用 pkg 管理软件包，则可以通过软件包安装 Git：

    ```
    # pkg install git
    ```
2. 检出 ports 树的 HEAD 分支的副本：

    ```
    # git clone --depth 1 https://git.FreeBSD.org/ports.git /usr/ports
    ```
3. 或者，检出一个季度分支的副本：

    ```
    # git clone --depth 1 https://git.FreeBSD.org/ports.git -b 2023Q1 /usr/ports
    ```
4. 根据需要，在初始的 Git 检出后更新 /usr/ports ：

    ```
    # git -C /usr/ports pull
    ```
5. 根据需要，将 /usr/ports 切换到另一个季度分支：

    ```
    # git -C /usr/ports switch 2023Q1
    ```

#### 4.5.2。安装Ports

本节提供了有关使用ports 安装或删除软件的基本说明。可在ports(7)中获取可用 make 目标和环境变量的详细说明。

|  | 在编译任何port之前，请务必按照前一节中的说明更新ports 。由于安装任何第三方软件可能会引入安全漏洞，建议在安装新port之前先检查 https://vuxml.freebsd.org/ 以获取与port相关的已知安全问题。或者，在安装新port之前运行 pkg audit -F。可以配置此命令在每日安全系统检查期间自动执行安全审计和漏洞数据库更新。有关更多信息，请参阅 pkg-audit(8) 和 periodic(8)。|
| -- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |

使用Ports 假设你有工作的互联网连接。它还需要超级用户特权。

要编译和安装port，切换到要安装的port目录，然后在提示符处键入 make install。消息将指示进度：

```
# cd /usr/ports/sysutils/lsof
# make install
>> lsof_4.88D.freebsd.tar.gz doesn't seem to exist in /usr/ports/distfiles/.
>> Attempting to fetch from ftp://lsof.itap.purdue.edu/pub/tools/unix/lsof/.
===>  Extracting for lsof-4.88
...
[extraction output snipped]
...
>> Checksum OK for lsof_4.88D.freebsd.tar.gz.
===>  Patching for lsof-4.88.d,8
===>  Applying FreeBSD patches for lsof-4.88.d,8
===>  Configuring for lsof-4.88.d,8
...
[configure output snipped]
...
===>  Building for lsof-4.88.d,8
...
[compilation output snipped]
...

===>  Installing for lsof-4.88.d,8
...
[installation output snipped]
...
===>   Generating temporary packing list
===>   Compressing manual pages for lsof-4.88.d,8
===>   Registering installation for lsof-4.88.d,8
===>  SECURITY NOTE:
      This port has installed the following binaries which execute with
      increased privileges.
/usr/local/sbin/lsof
#
```

由于 lsof 是以增加特权运行的程序，在安装时显示安全警告。安装完成后，提示符将返回。

一些 shells 会在列在 PATH 环境变量中的目录中保留命令的缓存，以加快查找这些命令的可执行文件的速度。tcsh shell 的用户应该输入 rehash，这样新安装的命令就可以在不指定其完整路径的情况下使用。对于 sh shell，请使用 hash -r。有关更多信息，请查阅 shell 的文档。

在安装过程中，会创建一个包含编译期间使用的所有临时文件的工作子目录。删除这个目录可以节省磁盘空间，并最大限度地减少升级到新版本的 port 时出现问题的几率：

```
# make clean
===>  Cleaning for lsof-88.d,8
#
```

|  | 为了节省这个额外步骤，编译 port 时，请改用 make install clean。|
| -- | ------------------------------------------------------------------ |

##### 4.5.2.1. 自定义 Ports 安装

有些 ports 提供构建选项，可以用于启用或禁用应用程序组件，提供安全选项，或能进行其他定制。示例包括 www/firefox 和 security/gpgme。如果 port 依赖于其他具有可配置选项的 ports，它可能会在几个地方暂停，等待用户交互，因为默认行为是提示用户从菜单中选择选项。为了避免这种情况，并在一次批处理中执行所有配置，请在 port 框架中运行 make config-recursive。然后，运行 make install [clean] 来编译和安装 port。

|  | 使用 config-recursive 时，要配置的 ports 列表是由 all-depends-list 目标收集的。建议重复运行 make config-recursive，直到所有依赖的 ports 选项都已定义，并且 ports 选项屏幕不再出现，确保已配置所有依赖选项。|
| -- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |

有几种方法可以在构建完port之后重新访问port的构建选项菜单，以添加、删除或更改这些选项。一种方法是 cd 到包含port的目录，并键入 make config。另一个选项是使用 make showconfig。另一个选项是执行 make rmconfig，这将删除所有已选择的选项，使你可以重新开始。所有这些选项以及其他选项都在ports（7）中详细解释。

ports系统使用 fetch（1）下载源文件，支持各种环境变量。如果 FreeBSD 系统位于防火墙或 FTP/HTTP 代理后面，则可能需要设置 FTP_PASSIVE_MODE 、 FTP_PROXY 和 FTP_PASSWORD 变量。有关支持的变量的完整列表，请参阅 fetch（3）。

对于不能始终连接到互联网的用户，可以在 /usr/ports 内运行 make fetch，以获取所有 distfiles，或在一个类别中运行，例如 /usr/ports/net，或在特定的port骨架中运行。请注意，如果port有任何依赖项，则在类别或ports骨架中运行此命令将无法获取来自另一个类别的ports的 distfiles。而是使用 make fetch-recursive 也获取port的所有依赖项的 distfiles。

在罕见情况下，比如当一个组织有一个本地 distfiles 存储库时，MASTER_SITES 变量可以用来覆盖 Makefile 中指定的下载位置。在使用时，请指定替代位置：

```
# cd /usr/ports/directory
# make MASTER_SITE_OVERRIDE= \
ftp://ftp.organization.org/pub/FreeBSD/ports/distfiles/ fetch
```

WRKDIRPREFIX 和 PREFIX 变量可以覆盖默认的工作目录和目标目录。例如：

```
# make WRKDIRPREFIX=/usr/home/example/ports install
```

将port编译在 /usr/home/example/ports 中，并将所有内容安装在 /usr/local 下。

```
# make PREFIX=/usr/home/example/local install
```

将 port 编译在 /usr/ports 并安装在 /usr/home/example/local。和：

```
# make WRKDIRPREFIX=../ports PREFIX=../local install
```

将两者合并。

这些也可以设置为环境变量。请参考你的 shell 手册了解如何设置环境变量。

#### 删除已安装 Ports

已安装 ports 可以使用 pkg delete 进行卸载。使用该命令的示例可以在 pkg-delete(8) 手册页中找到。

或者，make deinstall 可以在 port 的目录中运行：

```
# cd /usr/ports/sysutils/lsof
# make deinstall
===>  Deinstalling for sysutils/lsof
===>   Deinstalling
Deinstallation has been requested for the following 1 packages:

	lsof-4.88.d,8

The deinstallation will free 229 kB
[1/1] Deleting lsof-4.88.d,8... done
```

推荐阅读消息，因为 port 已被卸载。如果 port 有任何依赖于它的应用程序，将显示此信息但卸载将继续。在这种情况下，重新安装应用程序可能更好，以防止破坏依赖关系。

#### 4.5.4. 升级 Ports

随着时间的推移，更高版本的软件会在 Ports 中变得可用。本节说明了如何确定应升级哪些软件以及如何执行升级。

确定已安装 ports 的更新版本是否可用，请确保安装了ports树的最新版本，使用"Git 方法"中说明的更新命令。下面的命令将列出已安装的过时 ports。

```
# pkg version -l "<"
```

|  | 尝试升级之前，从文件顶部开始阅读 /usr/ports/UPDATING，以找到最接近上次升级ports或系统安装时间的日期。该文件说明了在更新port时用户可能遇到和需要执行的各种问题和附加步骤，包括文件格式更改、配置文件位置更改或与以前版本不兼容的任何问题。注意任何与需要升级的ports匹配的说明，并在执行升级时遵循这些说明。|
| -- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |

##### 4.5.4.1. 用于升级和管理 Ports 的工具

ports 包含多个实用工具，用于执行实际升级。每个工具都有其优势和劣势。

从历史来看，大多数安装都使用 Portmaster 或 Portupgrade。Synth 是一个更新的选择。

|  | 选择哪种工具最适合特定系统取决于系统管理员。在使用这些工具之前建议备份数据。|
| -- | ------------------------------------------------------------------------------ |

##### 4.5.4.2。使用 Portmaster 升级 Ports

ports-mgmt/portmaster 是一个非常小的实用程序，用于升级已安装的 ports。它旨在使用安装在 FreeBSD 基本系统中的工具，而不依赖于其他 ports 或数据库。要将此实用程序安装为 port：

```
# cd /usr/ports/ports-mgmt/portmaster
# make install clean
```

Portmaster 定义了 ports 的四个类别:

* 根 port：没有依赖项，也不是任何其他ports 的依赖项。
* 主干 port：没有依赖项，但其他ports 依赖它。
* 分支 port：有依赖项，其他ports 依赖它。
* 叶port：有依赖项，但没有其他ports依赖它。

要列出这些类别并搜索更新：

```
# portmaster -L
===>>> Root ports (No dependencies, not depended on)
===>>> ispell-3.2.06_18
===>>> screen-4.0.3
        ===>>> New version available: screen-4.0.3_1
===>>> tcpflow-0.21_1
===>>> 7 root ports
...
===>>> Branch ports (Have dependencies, are depended on)
===>>> apache22-2.2.3
        ===>>> New version available: apache22-2.2.8
...
===>>> Leaf ports (Have dependencies, not depended on)
===>>> automake-1.9.6_2
===>>> bash-3.1.17
        ===>>> New version available: bash-3.2.33
...
===>>> 32 leaf ports

===>>> 137 total installed ports
        ===>>> 83 have new versions available
```

此命令用于升级所有过时的ports：

```
# portmaster -a
```

|  | 默认情况下，Portmaster 在删除现有 port 之前会创建一个备份包。如果新版本安装成功，Portmaster 会删除备份。使用 -b 可以指示 Portmaster 不要自动删除备份。添加 -i 会启动 Portmaster 进入交互模式，在升级每个 port 前提示确认。还有许多其他选项可用。阅读 portmaster(8) 的手册页以获取有关它们用法的详细信息。|
| -- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |

如果在升级过程中遇到错误，请添加 -f 以升级并重建所有 ports：

```
# portmaster -af
```

Portmaster 也可用于在系统上安装新 ports，在构建和安装新 port 之前升级所有依赖项。要使用此功能，请在 Ports 中指定 port 的位置。

```
# portmaster shells/bash
```

ports-mgmt/portmaster 的详细信息可在其 pkg-descr 中找到。

##### 4.5.4.3. 使用 Portupgrade 升级 Ports

ports-mgmt/portupgrade 是另一个可以用于升级 ports 的实用程序。它安装了一套可以用来管理 ports 的应用程序。但是，它依赖于 Ruby。要安装 port：

```
# cd /usr/ports/ports-mgmt/portupgrade
# make install clean
```

使用此实用工具执行升级之前，建议扫描已安装的ports列表，使用 pkgdb -F 并修复报告的所有不一致性。

要升级系统上安装的所有过时ports，请使用 portupgrade -a。另外，包括 -i 以便在每个单独的升级时进行确认：

```
# portupgrade -ai
```

要仅升级指定的应用程序而不是所有可用的ports，请使用 portupgrade<span> </span><em>pkgname</em>。非常重要的是首先包括 -R 以升级给定应用程序所需的所有ports：

```
# portupgrade -R firefox
```

如果包含 -P，Portupgrade 将在列在 PKG_PATH 中的本地目录中搜索可用的软件包。如果本地没有可用的软件包，则会从远程站点获取软件包。如果在本地找不到软件包或无法从远程获取，则 Portupgrade 将使用 ports。要完全避免使用 ports，请指定 -PP。最后一组选项告诉 Portupgrade 如果没有可用的软件包就中止：

```
# portupgrade -PP gnome3
```

要仅获取 port 资源文件，或者如果指定 -P，而不构建或安装任何内容，请使用 -F。要获取所有可用开关的进一步信息，请参阅 portupgrade 的手册页面。

有关 ports-mgmt/portupgrade 的更多信息，请参阅其 pkg-descr。

#### 4.5.5. Ports 和磁盘空间

使用 Ports 会随着时间使用磁盘空间。构建和安装 port 后，在 ports 骨架中运行 make clean 将清理临时 work 目录。如果使用 Portmaster 安装 port，它将自动删除此目录，除非指定了 -K。如果安装了 Portupgrade，此命令将删除在本地 Ports 的副本中找到的所有 work 目录：

```
# portsclean -C
```

另外，过时的源分发文件会随着时间在 /usr/ports/distfiles 中累积。要使用 Portupgrade 删除任何不再被任何 ports 引用的所有 distfiles：

```
# portsclean -D
```

`Portupgrade` 可以删除系统上当前未被任何已安装软件包引用的所有 distfiles：

```
# portsclean -DD
```

如果已安装 `Portmaster`，请使用：

```
# portmaster --clean-distfiles
```

默认情况下，此命令是交互式的，并提示用户确认是否删除 distfile。

除了这些命令外，ports-mgmt/pkg_cutleaves 可自动完成移除不再需要的已安装ports操作。
