# 4.6.使用 Poudriere 构建软件包

poudriere 是一个基于 BSD 许可，用于创建和测试 FreeBSD 软件包的工具。它使用 FreeBSD jail 来设置隔离的编译环境。这些 jail 可以用于为与安装它的系统不同的 FreeBSD 版本构建软件包，也可以用于在主机为 amd64 系统的情况下构建 i386 的软件包。软件包构建完成后，它们的布局与官方镜像完全相同。这些软件包可被 pkg(8) 和其他软件包管理工具使用。

poudriere 是使用包或 port ports-mgmt/poudriere  进行安装的。安装包含了一个示例配置文件 /usr/local/etc/poudriere.conf.sample。请将此文件复制到 /usr/local/etc/poudriere.conf。编辑复制的文件以适应本地配置。

虽然运行 poudriere 无需 ZFS，但ZFS是有好处的。当使用 ZFS 时，必须在 /usr/local/etc/poudriere.conf 中指定 ZPOOL 并且 FREEBSD_HOST 应设置为附近的镜像。定义 CCACHE_DIR 可以启用使用 devel/ccache 来缓存编译并减少经常编译代码的构建时间。将 poudriere 数据集放在一个隔离的树中并挂载到 /poudriere 可能更方便。其他配置值的默认值是足够的。

检测到的处理器核心数量用于定义并行运行多少个构建。提供足够的虚拟内存，可以使用 RAM 和交换空间。如果虚拟内存耗尽，编译 jail 将会停止并被清除，导致出现奇怪的错误信息。

#### 初始化Jail和Port树

配置后，初始化 poudriere，使其安装jail，并附带所需的 FreeBSD 树和一个ports树。使用 -j 指定jail的名称，并使用 -v 指定 FreeBSD 版本。在运行 FreeBSD/amd64 的系统上，架构可以通过 -a 设置为 i386 或 amd64。默认是 uname 所显示的架构。

```
# poudriere jail -c -j 13amd64 -v 13.1-RELEASE
[00:00:00] Creating 13amd64 fs at /poudriere/jails/13amd64... done
[00:00:00] Using pre-distributed MANIFEST for FreeBSD 13.1-RELEASE amd64
[00:00:00] Fetching base for FreeBSD 13.1-RELEASE amd64
/poudriere/jails/13amd64/fromftp/base.txz              125 MB 4110 kBps    31s
[00:00:33] Extracting base... done
[00:00:54] Fetching src for FreeBSD 13.1-RELEASE amd64
/poudriere/jails/13amd64/fromftp/src.txz               154 MB 4178 kBps    38s
[00:01:33] Extracting src... done
[00:02:31] Fetching lib32 for FreeBSD 13.1-RELEASE amd64
/poudriere/jails/13amd64/fromftp/lib32.txz              24 MB 3969 kBps    06s
[00:02:38] Extracting lib32... done
[00:02:42] Cleaning up... done
[00:02:42] Recording filesystem state for clean... done
[00:02:42] Upgrading using ftp
/etc/resolv.conf -> /poudriere/jails/13amd64/etc/resolv.conf
Looking up update.FreeBSD.org mirrors... 3 mirrors found.
Fetching public key from update4.freebsd.org... done.
Fetching metadata signature for 13.1-RELEASE from update4.freebsd.org... done.
Fetching metadata index... done.
Fetching 2 metadata files... done.
Inspecting system... done.
Preparing to download files... done.
Fetching 124 patches.....10....20....30....40....50....60....70....80....90....100....110....120.. done.
Applying patches... done.
Fetching 6 files... done.
The following files will be added as part of updating to
13.1-RELEASE-p1:
/usr/src/contrib/unbound/.github
/usr/src/contrib/unbound/.github/FUNDING.yml
/usr/src/contrib/unbound/contrib/drop2rpz
/usr/src/contrib/unbound/contrib/unbound_portable.service.in
/usr/src/contrib/unbound/services/rpz.c
/usr/src/contrib/unbound/services/rpz.h
/usr/src/lib/libc/tests/gen/spawnp_enoexec.sh
The following files will be updated as part of updating to
13.1-RELEASE-p1:
[…]
Installing updates...Scanning //usr/share/certs/blacklisted for certificates...
Scanning //usr/share/certs/trusted for certificates...
 done.
13.1-RELEASE-p1
[00:04:06] Recording filesystem state for clean... done
[00:04:07] Jail 13amd64 13.1-RELEASE-p1 amd64 is ready to be used
```

```
# poudriere ports -c -p local -m git+https
[00:00:00] Creating local fs at /poudriere/ports/local... done
[00:00:00] Checking out the ports tree... done
```

在一台计算机上，poudriere 可以使用多个配置构建ports，可以在多个jail上进行构建，并且可以从不同的port树构建。这些组合的自定义配置称为。安装了ports-mgmt/poudriere 或ports-mgmt/poudriere-devel 后，详细信息请参阅 poudriere(8)的 CUSTOMIZATION 部分。

这里显示的基本配置将单个jail，port和特定于设置的 make.conf 放在 /usr/local/etc/poudriere.d 中。在此示例中，文件名是通过组合jail名称，port名称和设置名称 13amd64-local-workstation-make.conf 创建的。系统 make.conf 和这个新文件在构建时结合在一起，以创建构建jail使用的 make.conf。

要构建的软件包在 13amd64-local-workstation-pkglist 中输入（通过 FLAVORS 定义了ports，可以使用@FLAVOR）：

```
editors/emacs
devel/git
devel/php-composer2@php82
ports-mgmt/pkg
...
```

针对指定ports配置选项和依赖项：

```
# poudriere options -j 13amd64 -p local -z workstation -f 13amd64-local-workstation-pkglist
```

终于，包已构建，包存储库已创建：

```
# poudriere bulk -j 13amd64 -p local -z workstation -f 13amd64-local-workstation-pkglist
```

在运行时，按下 Ctrl + t 键会显示当前构建状态。poudriere 还会在 /poudriere/logs/bulk/jailname 中构建文件，这些文件可与 Web 服务器一起使用，用于显示构建信息。

完成后，新包现在可以从 poudriere 存储库进行安装。

有关使用 poudriere 的更多信息，请参阅 poudriere(8) 和主网站 https://github.com/freebsd/poudriere/wiki。

#### 配置 pkg 客户端以使用 poudriere 存储库

尽管可能同时使用自定义存储库和官方存储库，但有时禁用官方存储库会很有用。这可以通过创建覆盖并禁用官方配置文件的配置文件来完成。创建一个包含以下内容的 /usr/local/etc/pkg/repos/FreeBSD.conf ：

```
FreeBSD: {
	enabled: no
}
```

通常，最容易将 poudriere 存储库通过 HTTP 服务提供给客户机。设置一个 Web 服务器来提供软件包目录，例如： /usr/local/poudriere/data/packages/13amd64，其中 13amd64 是构建的名称。

如果软件包存储库的网址是： <http://pkg.example.com/13amd64>，那么 /usr/local/etc/pkg/repos/custom.conf 中的存储库配置文件将如下所示：

```
custom: {
	url: "http://pkg.example.com/13amd64",
	enabled: yes,
}
```

如果不希望将软件包存储库暴露到互联网上，可以使用 file:// 协议直接指向存储库：

```
custom: {
	url: "file:///usr/local/poudriere/data/packages/11amd64",
	enabled: yes,
}
```
