# 5.3.显卡驱动


下表显示了 FreeBSD 支持的不同显卡，应安装的软件包以及相应的模块。

第 7 表  显卡列表

| 品牌         | 类型   | 软件包          | 模块                                           |
| -------------- | -------- | ------------------- | ------------------------------------------------ |
| 英特尔®     | 开源   | drm | `i915kms`                                               |
| AMD®        | 开源   | drm  | amdgpu 和 radeonkms                            |
| NVIDIA®     | 专有 | nvidia-driver     | nvidia 或 nvidia-modeset                       |
| VESA         | 开源   | xf86-video-vesa    | vesa                                           |
| SCFB         | 开源   | xf86-video-scfb   | scfb                                        |
| VirtualBox® | 开源   | 虚拟盒-ose-添加   | VirtualBox® OSE 添加包括 vboxvideo 驱动程序。|
| VMware®     | 开源   | xf86-video-vmware | vmwgfx                                         |

以下命令可用于识别系统中安装的显卡：

```
% pciconf -lv|grep -B4 VGA
```

输出应类似于以下内容：

```
vgapci0@pci0:0:2:0:     class=0x030000 rev=0x07 hdr=0x00 vendor=0x8086 device=0x2a42 subvendor=0x17aa subdevice=0x20e4
    vendor     = 'Intel Corporation'
    device     = 'Mobile 4 Series Chipset Integrated Graphics Controller'
    class      = display
    subclass   = VGA
```

```
% sysctl machdep.bootmethod
```

输出应类似于以下内容：

```
machdep.bootmethod: BIOS
```

#### 5.3.1. 英特尔®

英特尔®显卡指的是集成在与英特尔® CPU 同一芯片上的显卡芯片类别。维基百科提供了关于英特尔 HD Graphics 世代变化和名称使用的良好概述。

软件包graphics/drm-kmod 间接提供了一系列用于英特尔®显卡配套使用的内核模块。可以通过执行以下命令安装英特尔®驱动程序：

```
# pkg install drm-kmod
```

然后将模块添加到 /etc/rc.conf 文件中，执行以下命令：

```
# sysrc kld_list+=i915kms
```

```
# pkg install libva-intel-driver mesa-libs mesa-dri
```

#### 5.3.2. AMD®

软件包 graphics/drm-kmod 间接了提供一系列与 AMD®显卡配合使用的内核模块。可以使用模块 amdgpu 和 radeonkms，具体取决于硬件的世代。FreeBSD 项目维护着一个 AMD 显卡支持矩阵，以确定必须使用哪个驱动程序。

可以通过执行以下命令来安装 AMD®驱动程序：

```
# pkg install drm-kmod
```

对于后-HD7000 或 Tahiti 显卡，在 /etc/rc.conf 文件中添加模块，执行以下命令：

```
# sysrc kld_list+=amdgpu
```

对于旧的显卡（前-HD7000 或前-Tahiti），在 /etc/rc.conf 文件中添加模块，执行以下命令：

```
# sysrc kld_list+=radeonkms
```

#### 5.3.3. NVIDIA®的

FreeBSD 支持专有 NVIDIA®驱动程序的不同版本。使用更新的显卡的用户应安装 x11/nvidia-driver 软件包。那些使用旧显卡的用户需要查看下面哪个版本支持它们。

NVIDIA®驱动程序的支持版本

表格 8.

| 包                      | 支持的硬件 |
| ------------------------- | ------------ |
| x11/nvidia-driver-304   | [ 支持的硬件](https://www.nvidia.com/Download/driverResults.aspx/123712/en-us/)           |
| x11/nvidia-driver-340   | [ 支持的硬件](https://www.nvidia.com/Download/driverResults.aspx/156167/en-us/)           |
| x11/nvidia-driver-390 | [ 支持的硬件](https://www.nvidia.com/Download/driverResults.aspx/191122/en-us/)           |
| x11/nvidia-driver-470 | [ 支持的硬件](https://www.nvidia.com/Download/driverResults.aspx/194639/en-us/)           |
| x11/nvidia-driver     | [ 支持的硬件](https://www.nvidia.com/Download/driverResults.aspx/210651/en-us/)           |


|  | 第 304 版的 NVIDIA® 显卡驱动程序(nvidia-driver-304) 不支持 xorg-server 1.20 及更高版本。|
| -- | ------------------------------------------------------------------------------------------- |

最新的 NVIDIA® 驱动程序可通过运行以下命令进行安装：

```
# pkg install nvidia-driver
```

然后将该模块添加到 /etc/rc.conf 文件中，执行以下命令：

```
# sysrc kld_list+=nvidia-modeset
```

```
# sysrc kld_list+=nvidia
```
