# 5.4.Xorg 配置

Xorg 支持大多数常见的显卡卡、键盘和指向设备。

|  | Xorg 会自动检测显卡，显示器和输入设备，无需任何手动配置。除非自动配置失败，否则不要创建 xorg.conf 及运行 Xorg -configure 这一步骤。|
| -- | -------------------------------------------------------------------------------------------------------------------------------- |

#### 5.4.1. 配置文件

Xorg 在多个目录中查找配置文件。在 FreeBSD 上，/usr/local/etc/X11/ 是这些文件的推荐目录。使用这个目录有助于将应用文件与操作系统文件保持分开。

#### 5.4.2. 单个文件或多个文件

使用每个配置特定设置的多个文件比传统的单个 xorg.conf 更容易。这些文件存储在 /usr/local/etc/X11/xorg.conf.d/ 子目录中。

|  | 传统的单个 xorg.conf 仍然有效，但与 /usr/local/etc/X11/xorg.conf.d/ 子目录中的多个文件相比，既不清晰也不灵活。|
| -- | ---------------------------------------------------------------------------------------------------------------- |

#### 5.4.3. 显卡

显卡的驱动程序可以在/usr/local/etc/X11/xorg.conf.d/目录中指定。

要在配置文件中配置 Intel®驱动程序：

例 14。在文件中选择 Intel®视频驱动程序

/usr/local/etc/X11/xorg.conf.d/20-intel.conf

```
Section "Device"
	Identifier "Card0"
	Driver     "intel"
EndSection
```

要在配置文件中配置 AMD®驱动程序：

例 15。在文件中选择 AMD®视频驱动程序

/usr/local/etc/X11/xorg.conf.d/20-radeon.conf

```
Section "Device"
	Identifier "Card0"
	Driver     "radeon"
EndSection
```

要在配置文件中配置 NVIDIA®驱动程序:

例 16。在文件中选择 NVIDIA®视频驱动程序

/usr/local/etc/X11/xorg.conf.d/20-nvidia.conf

```
Section "Device"
	Identifier "Card0"
	Driver     "nvidia"
EndSection
```

|  | x11/nvidia-xconfig 也可以用于对 NVIDIA 驱动程序中可用配置选项进行基本控制。|
| -- | ----------------------------------------------------------------------------- |

配置 VESA 驱动程序的配置文件：

示例 17. 在文件中选择 VESA 视频驱动程序

/usr/local/etc/X11/xorg.conf.d/20-vesa.conf

```
Section "Device"
	Identifier "Card0"
	Driver     "vesa"
EndSection
```

配置 SCFB 驱动程序在配置文件中：

示例 18. 在文件中选择 SCFB 视频驱动程序

/usr/local/etc/X11/xorg.conf.d/20-scfb.conf

```
Section "Device"
	Identifier "Card0"
	Driver     "scfb"
EndSection
```

配置多个视频卡，可以添加 BusID。执行以下命令可以显示视频卡总线 ID 的列表：

```
% pciconf -lv | grep -B3 display
```

输出应类似于以下内容：

```
vgapci0@pci0:0:2:0:     class=0x030000 rev=0x07 hdr=0x00 vendor=0x8086 device=0x2a42 subvendor=0x17aa subdevice=0x20e4
    vendor     = 'Intel Corporation'
    device     = 'Mobile 4 Series Chipset Integrated Graphics Controller'
    class      = display
--
vgapci1@pci0:0:2:1:     class=0x038000 rev=0x07 hdr=0x00 vendor=0x8086 device=0x2a43 subvendor=0x17aa subdevice=0x20e4
    vendor     = 'Intel Corporation'
    device     = 'Mobile 4 Series Chipset Integrated Graphics Controller'
    class      = display
```

示例 19.在文件中选择 Intel®视频驱动程序和 NVIDIA®视频驱动程序

/usr/local/etc/X11/xorg.conf.d/20-drivers.conf

```
Section "Device"
	Identifier "Card0"
	Driver     "intel"
	BusID     "pci0:0:2:0"
EndSection

Section "Device"
	Identifier "Card0"
	Driver     "nvidia"
	BusID     "pci0:0:2:1"
EndSection
```

#### 5.4.4. 显示器

几乎所有显示器都支持扩展显示识别数据标准 ( EDID )。Xorg 使用 EDID 与显示器通信，以侦测支持的分辨率和刷新率。然后它选择与该显示器一起使用的最合适的设置组合。

显示器支持的其他分辨率可通过将所需分辨率设置在配置文件中或在启动 X 服务器后使用 xrandr(1) 选择。

##### 5.4.4.1. 使用 RandR（重新调整和旋转）

运行 xrandr(1) 而不带任何参数以查看视频输出和检测到的显示器模式列表：

```
% xrandr
```

输出应该类似于以下内容：

```
Screen 0: minimum 320 x 200, current 2560 x 960, maximum 8192 x 8192
LVDS-1 connected 1280x800+0+0 (normal left inverted right x axis y axis) 261mm x 163mm
   1280x800      59.99*+  59.81    59.91    50.00
   1280x720      59.86    59.74
   1024x768      60.00
   1024x576      59.90    59.82
   960x540       59.63    59.82
   800x600       60.32    56.25
   864x486       59.92    59.57
   640x480       59.94
   720x405       59.51    58.99
   640x360       59.84    59.32
VGA-1 connected primary 1280x960+1280+0 (normal left inverted right x axis y axis) 410mm x 257mm
   1280x1024     75.02    60.02
   1440x900      74.98    60.07
   1280x960      60.00*
   1280x800      74.93    59.81
   1152x864      75.00
   1024x768      75.03    70.07    60.00
   832x624       74.55
   800x600       72.19    75.00    60.32    56.25
   640x480       75.00    72.81    66.67    59.94
   720x400       70.08
HDMI-1 disconnected (normal left inverted right x axis y axis)
DP-1 disconnected (normal left inverted right x axis y axis)
HDMI-2 disconnected (normal left inverted right x axis y axis)
DP-2 disconnected (normal left inverted right x axis y axis)
DP-3 disconnected (normal left inverted right x axis y axis)
```

这表明 VGA-1 输出被用来显示分辨率为 1280x960 像素，刷新率约为 60 Hz 的屏幕。LVDS-1 用作辅助显示器，显示分辨率为 1280x800 像素，刷新率约为 60 Hz。显示器未连接到 HDMI-1，HDMI-2，DP-1，DP-2 和 DP-3 连接器。

任何其他显示模式均可通过 xrandr(1)选择。例如，要切换到 1280x1024，60 Hz：

```
% xrandr --output LVDS-1 --mode 1280x720 --rate 60
```

##### 使用 Xorg 配置文件 5.4.4.2。

显示器配置也可以在配置文件中设置。

在配置文件中设置屏幕分辨率为 1024x768。

示例 20。在文件中设置屏幕分辨率

/usr/local/etc/X11/xorg.conf.d/10-monitor.conf

```
Section "Screen"
	Identifier "Screen0"
	Device     "Card0"
	SubSection "Display"
	Modes      "1024x768"
	EndSubSection
EndSection
```

#### 5.4.5。输入设备

Xorg 通过 x11/libinput 支持绝大部分输入设备。

|  | 一些桌面环境（如 KDE Plasma）提供了用于设置这些参数的图形用户界面。在手动编辑配置之前，请检查一下是否有这样的功能。|
| -- | --------------------------------------------------------------------------------------------------------------------- |

例如，要配置键盘布局：

例 21. 设置键盘布局

/usr/local/etc/X11/xorg.conf.d/00-keyboard.conf

```
Section "InputClass"
        Identifier "Keyboard1"
        MatchIsKeyboard "on"
        Option "XkbLayout" "es, fr"
        Option "XkbModel" "pc104"
        Option "XkbVariant" ",qwerty"
        Option "XkbOptions" "grp:win_space_toggle"
EndSection
```
