# 5.5.在 X11 中使用字体


Xorg 的默认字体对于典型的桌面开发应用来说并不理想。大号的演示字体显示得很不清晰，不够专业，而小号的字体几乎完全没有可读性。然而，有几款免费的高质量 Type1（PostScript®）字体可供 Xorg 随时使用。

#### 5.5.1. Type1 字体

URW 字体（x11-fonts/urwfonts）包括标准 Type1 字体（Times Roman™，Helvetica™，Palatino™ 等）的高质量版本。Freefonts （x11-fonts/freefonts）包含更多字体，但其中大多数是为图形软件（如 Gimp）使用而设计的，并不完整到足以用作屏幕字体。此外，Xorg 可以很容易地配置为使用 TrueType® 字体。有关更多详情，请参阅 X(7) 手册页面或 TrueType® 字体。

要安装上述 Type1 字体的二进制软件包，请运行以下命令：

```
# pkg install urwfonts
```

同样，对于 freefont 或其他也是一样。要让 X 服务器检测这些字体，请向 X 服务器配置文件（/usr/local/etc/X11/xorg.conf.d/90-fonts.conf）添加一行适当的内容，内容如下：

```
Section "Files"
  FontPath "/usr/local/share/fonts/urwfonts/"
EndSection
```

或者，在 X 会话的命令行中运行：

```
% xset fp+ /usr/local/share/fonts/urwfonts
% xset fp rehash
```

这将起作用，但在关闭 X 会话时将会丢失，除非将其添加到启动文件（~/.xinitrc 适用于正常 startx 会话，或者在像 XDM 这样的图形登录管理器登录时为~/.xsession）。第三种方法是使用新的/usr/local/etc/fonts/local.conf，如《抗锯齿字体》所示。

#### 5.5.2. TrueType®字体

Xorg 内置支持呈现 TrueType®字体。有两个不同的模块可以启用此功能。在此示例中使用 freetype 模块，因为它与其他字体呈现后端更一致。要启用 freetype 模块，只需将以下行添加到/usr/local/etc/X11/xorg.conf.d/90-fonts.conf 的 "Module" 部分。

```
Load  "freetype"
```

现在为 TrueType®字体创建一个目录（例如，/usr/local/share/fonts/TrueType），并将所有 TrueType®字体复制到此目录。请记住，TrueType®字体不能直接从 Apple® Mac®中获取；它们必须以 UNIX®/MS-DOS®/Windows®格式供 Xorg 使用。若文件被复制到此目录中，请使用 mkfontscale 创建一个 fonts.dir，以便 X 字体呈现器知道这些新文件已被安装。mkfontscale 可以作为一个软件包安装：

```
# pkg install mkfontscale
```

然后在目录中创建 X 字体文件的索引：

```
# cd /usr/local/share/fonts/TrueType
# mkfontscale
```

现在将 TrueType® 目录添加到字体路径中。这与 Type1 字体中说明的内容完全相同：

```
% xset fp+ /usr/local/share/fonts/TrueType
% xset fp rehash
```

或者在 xorg.conf 中添加 FontPath 行。

Gimp、LibreOffice 和所有其他 X 应用程序现在应该能够识别已安装的 TrueType® 字体。现在，在高分辨率显示器上的文本（如网页上的文本）和在 LibreOffice 中的极大字体将会看起来好得多。

#### 5.5.3. 抗锯齿字体

Xorg 中的所有字体，位于 /usr/local/share/fonts/ 和 ~/.fonts/ 中的字体，都会自动提供给支持 Xft 的应用程序进行抗锯齿处理。大多数最新的应用程序都支持 Xft，包括 KDE、GNOME 和 Firefox。

控制反锯齿哪些字体，或配置反锯齿属性，请创建（如果尚不存在则编辑）文件 /usr/local/etc/fonts/local.conf。可以使用此文件调整 Xft 字体系统的几个高级功能；本节仅介绍一些简单可能性。有关更多详细信息，请参阅 fonts-conf(5)。

此文件必须为 XML 格式。要注意大小写，并确保所有标签正确闭合。文件以通常的 XML 标头开头，后跟一个 DOCTYPE 定义，然后是 `<fontconfig>` 标签：

```
<?xml version="1.0"?>
      <!DOCTYPE fontconfig SYSTEM "fonts.dtd">
      <fontconfig>
```

如前所述，/usr/local/share/fonts/ 中的所有字体以及 ~/.fonts/ 中的字体都已提供给支持 Xft 的应用程序。要添加到这两个目录树之外的另一个目录，请向 /usr/local/etc/fonts/local.conf 添加类似以下行：

```
<dir>/path/to/my/fonts</dir>
```

添加新字体，特别是新字体目录后，重新生成字体缓存：

```
# fc-cache -f
```

抗锯齿会使边框略显模糊，这使得非常小的文本更易读，并移除大文本的“阶梯”，但如果应用于普通文本可能会导致眼部疲劳。要从抗锯齿中排除小于 14 磅的字体大小，请包含以下行：

```
	<match target="font">
	    <test name="size" compare="less">
		<double>14</double>
	    </test>
	    <edit name="antialias" mode="assign">
		<bool>false</bool>
	    </edit>
	</match>
	<match target="font">
	    <test name="pixelsize" compare="less" qual="any">
		<double>14</double>
	    </test>
	    <edit mode="assign" name="antialias">
		<bool>false</bool>
	    </edit>
	</match>
```

某些等宽字体的间距在抗锯齿下可能不合适。这似乎是 KDE 的一个问题。一个可能的修复方法是强制使这些字体的间距为 100。添加以下内容：

```
	<match target="pattern" name="family">
	   <test qual="any" name="family">
	       <string>fixed</string>
	   </test>
	   <edit name="family" mode="assign">
	       <string>mono</string>
	   </edit>
	</match>
	<match target="pattern" name="family">
	    <test qual="any" name="family">
		<string>console</string>
	    </test>
	    <edit name="family" mode="assign">
		<string>mono</string>
	    </edit>
	</match>
```

（这别名为 "mono" 的固定字体）并且添加：

```
	<match target="pattern" name="family">
	     <test qual="any" name="family">
		 <string>mono</string>
	     </test>
	     <edit name="spacing" mode="assign">
		 <int>100</int>
	     </edit>
	 </match>
```

某些字体，比如 Helvetica，在抗锯齿时可能会出现问题。通常表现为字体在垂直方向被切成两半。最糟糕的情况下可能导致应用程序崩溃。为了避免这种情况，考虑在 local.conf 中添加以下内容：

```
	<match target="pattern" name="family">
	     <test qual="any" name="family">
		 <string>Helvetica</string>
	     </test>
	     <edit name="family" mode="assign">
		 <string>sans-serif</string>
	     </edit>
	 </match>
```

在编辑 local.conf 后，请确保以 </fontconfig> 标签结尾。如果不这样做，将导致更改被忽略。

用户可以通过创建自己的 ~/.config/fontconfig/fonts.conf 文件来添加个性化设置。该文件使用上述相同的 XML 格式。

最后一点：对于液晶屏幕，可能需要进行亚像素抽样。基本上是分别处理（水平分离的）红、绿和蓝色分量，以提高水平分辨率；结果可能会很惊人。要启用此功能，请在 local.conf 的某处添加以下行：

```
	 <match target="font">
	     <test qual="all" name="rgba">
		 <const>unknown</const>
	     </test>
	     <edit name="rgba" mode="assign">
		 <const>rgb</const>
	     </edit>
	 </match>
```

|  | 根据显示器的类型，可能需要将 rgb 更改为 bgr 、 vrgb 和 vbgr ：逐个尝试并查看哪个效果最好。|
| -- | ---------------------------------------------------------------------------------------- |

有关如何在 FreeBSD 上安装和配置字体的更多信息，请阅读文章《字体和 FreeBSD》。
