# 6.2.Wayland 概述

Wayland 是一个新的显示服务器，但它与 Xorg 在几个重要方面有所不同。首先，Wayland 只是一个协议，作为客户端之间的中介，使用不同的机制，这消除了对 X 服务器的依赖。Xorg 包括了 X11 协议，用于运行远程显示，X 服务器将接受连接并显示窗口。在 Wayland 下，由混成器和窗口管理器提供显示服务器，而不是传统的 X 服务器。

由于 Wayland 不是 X 服务器，传统的 X 屏幕连接（如 VNC 或 RDP）将需要使用其他方法来进行远程桌面管理。其次，Wayland 可以将客户端与混成器之间的复合通信作为一个单独的实体进行管理，不需要支持 X 协议。

Wayland 相对较新，还没有更新所有软件以在没有 Xwayland 支持的情况下本地运行。因为 Wayland 不提供 X 服务器，并期望复合器提供该支持，尚不支持 Wayland 的 X11 窗口管理器将要求以 -rootless 参数不启动 Xwayland。去除 -rootless 参数将恢复对 X11 窗口管理器的支持。

|  | 当前的 NVIDIA® 驱动程序应该可以与大多数 wlroots 混成器一起工作，但可能有点不稳定，并且目前不支持所有功能。请求志愿者参与 NVIDIA® DRM 的开发工作。|
| -- | ------------------------------------------------------------------------------------------------------------------------------------------------- |

目前，许多软件在 Wayland 上都可以正常运行，包括 Firefox。此外，还有一些可用的桌面环境，比如 Compiz Fusion 的替代品 Wayfire 和 i3 窗口管理器的替代品 Sway。

|  | 截至 2021 年 5 月，plasma5-kwin 在 FreeBSD 上支持 Wayland。要在 Wayland 下使用 Plasma，请使用参数 startplasma-wayland 和用 dbus-launch --exit-with-x11 ck-launch-session startplasma-wayland 绑定 dbus 以使其工作。|
| -- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |

对于混成器，必须存在支持 evdev(4)驱动程序的内核才能利用快捷键功能。这是默认内建在通用内核中的；但是，如果它已经被定制并且 evdev(4)支持被剥离，evdev(4)模块将需要被加载。另外，Wayland 的用户需要是 video 组的成员。要快速进行这一更改，请使用 pw 命令：

```
pw groupmod video -m user
```

安装 Wayland 很简单；协议本身并不需要太多配置。大部分的组合将取决于所选择的混成器。通过现在安装 seatd，作为混成器安装和配置的一部分，跳过了一个步骤，因为 seatd 需要为某些设备提供非 root 访问。

这里说明的所有混成器应该与图形/drm-kmod 开源驱动程序一起工作；然而，NVIDIA®显卡卡在使用专有驱动程序时可能会出现问题。首先安装以下软件包：

```
# pkg install wayland seatd
```

若协议和支持软件包安装完毕，混成器必须创建用户界面。后面的几节将涉及几个使用 Wayland 的混成器。所有使用 Wayland 的混成器都需要在环境中定义一个运行目录，这可以通过在 Bourne shell 中使用以下命令来实现：

```
% export XDG_RUNTIME_DIR=/var/run/user/`id -u`
```

注意：大多数混成器将在 XDG_RUNTIME_DIR 目录中搜索配置文件。在这里包含的示例中，将使用一个参数来指定配置文件在 ~/.config 中，以保持临时文件和配置文件分开。建议为每个混成器配置一个别名，以加载指定的配置文件。

|  | 有报道称 ZFS 用户可能会遇到一些 Wayland 客户端的问题，因为它们需要访问运行时目录中的 posix_fallocate()。尽管作者在他们的 ZFS 系统上无法重现这个问题，一个推荐的解决方法是不要在运行时目录中使用 ZFS，而是在 /var/run 目录中使用 tmpfs。在这种情况下，tmpfs 文件系统用于 /var/run，并通过 mount -t tmpfs tmpfs /var/run 命令挂载，然后通过 /etc/fstab 使此更改跨重启保持不变。可以配置 XDG_RUNTIME_DIR 环境变量以使用 /var/run/user/$UID，并避免在 ZFS 上出现潜在问题。在查看以下各节中的配置示例时，请考虑这种情况。|
| -- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |

seatd 守护程序可帮助管理对非根用户在混成器中共享系统设备的访问权限；这包括显卡。对于传统的 X11 管理器，不需要 seatd，比如 Plasma 和 GNOME，但是对于这里讨论的 Wayland 混成器，需要在系统中启用它并在启动混成器环境之前运行。要立即启用并启动 seatd 守护程序，并将其纳入系统初始化：

```
# sysrc seatd_enable="YES"
# service seatd start
```

之后，需要安装一个类似于 X11 桌面的排版器，用于 GUI 环境。这里讨论了三种，包括基本配置选项、设置屏幕锁定以及更多信息的建议。
