# 6.3.Wayfire 混成器

Wayfire 是一个旨在轻量化和可定制的混成器。它具有多种功能，并且从之前发布的 Compiz Fusion 桌面中带回了几个元素。所有部分在现代硬件上看起来都很美观。要启动和运行 Wayfire，请首先安装所需的软件包：

```
# pkg install wayfire wf-shell alacritty swaylock-effects swayidle wlogout kanshi mako wlsunset
```

alacritty 软件包提供了一个终端模拟器。但完全不需要，因为已经测试并验证了其他终端模拟器，比如 kitty 和 XFCE-4 Terminal 在 Wayfire 混成器下可以工作。Wayfire 配置相对简单；它使用一个文件，应该查看任何自定义。要开始，请复制示例文件到运行时环境配置目录，然后编辑文件：

```
% mkdir ~/.config/wayfire
% cp /usr/local/share/examples/wayfire/wayfire.ini ~/.config/wayfire
```

对于大多数用户来说，默认设置应该就可以。在配置文件中，像著名的 cube 这样的项目是预先配置的，并且有帮助可用设置的说明。一些需要注意的主要设置包括：

```
[output]
mode = 1920x1080@60000
position = 0,0
transform = normal
scale = 1.000000
```

在这个例子中，从配置文件中，屏幕输出应该是列出的模式在列出的赫兹下。例如，模式应设置为 widthxheight@refresh_rate。位置将输出放置在指定的像素位置上。对于大多数用户来说，默认设置应该很好。最后，transform 设置一个背景变换，scale 将输出按指定比例因子进行缩放。这些选项的默认设置通常是可以接受的；有关更多信息，请参阅文档。

正如所提到的，Wayland 是新的，不是所有的应用程序都支持这个协议。目前，sddm 似乎不支持在 Wayland 中启动和管理混成器。在这些示例中，取而代之的是 swaylock 实用程序。配置文件包含运行 swayidle 和 swaylock 的选项，用于屏幕的空闲和锁定。

在系统空闲时定义要采取的操作的选项如下所示：

```
idle = swaylock
```

锁定超时是使用以下行配置的：

```
[idle]
toggle = <super> KEY_Z
screensaver_timeout = 300
dpms_timeout = 600
```

第一个选项将在 300 秒后锁定屏幕，再过 300 秒，屏幕将通过 dpms_timeout 选项关闭。

最后需要注意的一点是键位。大多数配置都提到了这个键位，它是键盘上传统的 Windows 键。大多数键盘都有这个 Win 键；但是，如果没有，应该在此配置文件中重新映射它。例如，要锁定屏幕，请按住 Win 键、Shift 键，然后按 Esc 键。除非映射已更改，否则这将执行 swaylock 应用程序。swaylock 的默认配置将显示灰屏；但是，该应用程序可以高度定制，并且有很好的文档。此外，由于安装的是 swaylock-effects 版本，有几个选项可用，比如模糊效果，可以使用以下命令查看：

```
% swaylock --effect-blur 7x5
```

还有一个 --clock 参数，将在锁定屏幕上显示带有日期和时间的时钟。安装 x11/swaylock-effects 时，包含了默认的 pam.d 配置。它提供了适合大多数用户的默认选项。更高级的选项可用；有关更多信息，请参阅 PAM 文档。

在这一点上，是时候测试 Wayfire，看看它是否可以在系统上启动。只需键入以下命令：

```
% wayfire -c ~/.config/wayfire/wayfire.ini
```

现在混成器应该启动并显示屏幕顶部的背景图片和菜单栏。Wayfire 将尝试列出桌面上安装的兼容应用程序，并在此下拉菜单中展示它们；例如，如果安装了 XFCE-4 文件管理器，它将显示在此下拉菜单中。如果特定应用程序是兼容的并且对于键盘快捷键非常有价值，可以使用 wayfire.ini 配置文件将其映射到键盘序列。Wayfire 还有一个名为 Wayfire 配置管理器的配置工具。它位于下拉菜单栏中，但也可以通过在终端中发出以下命令来启动：

```
% wcm
```

可以通过该应用程序启用、禁用或配置各种 Wayfire 配置选项，包括合成特效。此外，为了获得更加用户友好的体验，可以在配置文件中启用背景管理器、面板和停靠应用程序。

```
panel = wf-panel
dock = wf-dock
background = wf-background
```

|  | 通过 wcm 进行的更改将覆盖 wayfire.ini 配置文件中的自定义更改。强烈建议备份 wayfire.ini 文件，以便恢复任何重要更改。|
| -- | --------------------------------------------------------------------------------------------------------------------- |

最后，在 wayfire.ini 中列出的默认启动器是 x11/wf-shell，用户可以根据需要替换为其他面板。
