# 6.4.Hikari 混成器

Hikari 混成器使用围绕生产力的几个概念，例如 sheets，工作区等。从这个角度来看，它类似于平铺式窗口管理器。具体来说，混成器从单个工作区开始，类似于虚拟桌面。Hikari 使用单个工作区或虚拟桌面进行用户交互。工作空间由几个视图组成，这些视图是混成器中作为 sheets 或 groups 分组的工作窗口。sheets 和 groups 都由一系列视图组成；再次强调，这些窗口被分组在一起。在 sheets 或 groups 之间切换时，活跃的 sheet 或 group 将集体成为工作空间。手册页面将进一步解释每个功能的信息，但在本文档中，请考虑单个工作区使用单个 sheet。Hikari 安装将包括一个单一包，x11-wm/hikari，和一个终端模拟器 alacritty ：

```
# pkg install hikari alacritty
```

|  | 其他 shell，如 kitty 或等离子 Terminal，将在 Wayland 下运行。用户应该尝试他们喜欢的终端编辑器来验证兼容性。|
| -- | -------------------------------------------------------------------------------------------------------------- |

Hikari 使用一个配置文件，hikari.conf，该文件可以放在 XDG_RUNTIME_DIR 中，也可以在启动时使用 -c 参数指定。不需要自动启动配置文件，但可能会使迁移到这个混成器更容易一些。开始配置是创建 Hikari 配置目录并复制配置文件进行编辑：

```
% mkdir ~/.config/hikari
% cp /usr/local/etc/hikari/hikari.conf ~/.config/hikari
```

配置分为各种部分，如 ui、outputs、layouts 等。对于大多数用户，默认设置将运行良好；但是，应该进行一些重要的更改。例如，$TERMINAL 变量通常未在用户环境中设置。更改此变量或修改 hikari.conf 文件如下：

```
terminal = "/usr/local/bin/alacritty"
```

使用绑定的按键按下将启动 alacritty 终端。在阅读配置文件时，应注意使用大写字母来为用户映射键。例如，用于启动终端的 L 键 L+Return 实际上是先前讨论过的超级键或 Windows 徽标键。因此，按住 L/super/Windows 键并按回车键将使用默认配置打开指定的终端模拟器。将其他键映射到应用程序需要创建操作定义。为此，动作项应列在 actions 段中，例如：

```
actions {
  terminal = "/usr/local/bin/alacritty"
  browser = "/usr/local/bin/firefox"
}
```

然后，可以在键盘段下映射一个动作，该键盘段在绑定段中定义：

```
bindings {
  keyboard {
SNIP
    "L+Return" = action-terminal
    "L+b" = action-browser
SNIP
```

在重启 Hikari 后，按住 Windows 徽标按钮并在键盘上按下 b 键将启动 Web 浏览器。混成器没有菜单栏，建议用户在迁移之前至少设置一个终端模拟器。手册页面包含大量文档，应在执行完整迁移之前阅读。关于 Hikari 的另一个积极方面是，在迁移到混成器时，Hikari 可以在 Plasma 和 GNOME 桌面环境中启动，能让在完全迁移之前进行试用。

在 Hikari 中锁定屏幕很容易，因为默认的 pam.d 配置文件和解锁实用程序已与软件包捆绑在一起。锁定屏幕的键绑定为 L（Windows 徽标键）+ Shift + Backspace。值得注意的是，所有未标记为公共的视图将被隐藏。这些视图在锁定时将不接受输入，但请注意敏感信息可能会可见。对于一些用户来说，可能更容易迁移到其他屏幕锁定实用程序，比如本节讨论的 swaylock-effects。要启动 Hikari，请使用以下命令：

```
% hikari -c ~/.config/hikari/hikari.conf
```
