# 6.5.Sway 混成器

Sway 混成器是一种平铺式混成器，旨在取代 i3 窗口管理器。它应该可以与用户当前的 i3 配置一起工作；但是，新功能可能需要一些额外的设置。在即将介绍的示例中，将假定进行全新安装，而不迁移任何 i3 配置。要安装 Sway 和有价值的组件，请以 root 用户身份执行以下命令：

```
# pkg install sway swayidle swaylock-effects alacritty dmenu-wayland dmenu
```

为了基本配置文件，执行以下命令，然后在复制后编辑配置文件：

```
% mkdir ~/.config/sway
% cp /usr/local/etc/sway/config ~/.config/sway
```

基本配置文件有许多默认值，对于大多数用户来说，这将是很好的。应该进行几个重要的更改，如下所示：

```
# Logo key. Use Mod1 for Alt.
input * xkb_rules evdev
set $mod Mod4
# Your preferred terminal emulator
set $term alacritty
set $lock swaylock -f -c 000000
output "My Workstation" mode 1366x786@60Hz position 1366 0
output * bg ~/wallpapers/mywallpaper.png stretch
### Idle configuration
exec swayidle -w \
          timeout 300 'swaylock -f -c 000000' \
          timeout 600 'swaymsg "output * dpms off"' resume 'swaymsg "output * dpms on"' \
          before-sleep 'swaylock -f -c 000000'
```

在前面的示例中，加载了 evdev(4) 事件的 xkb 规则，并将 $mod 键设置为用于快捷键的 Windows 徽标键。接下来，终端模拟器被设置为 alacritty，并定义了一个屏幕锁定命令；稍后将详细介绍这些内容。还告知输出关键字、模式、位置、背景壁纸以及要求 Sway 拉伸此壁纸以填充屏幕。最后，设置 swaylock 以将进程变为守护进程并在超时后锁定屏幕，将屏幕或监视器在 600 秒后置于睡眠模式。还在此定义了 000000 的锁定背景颜色，即黑色。使用 swaylock-effects，也可以通过 --clock 参数显示时钟。查看手册页以获取更多选项。还应该查阅 sway-output(5) 手册页；它包含大量关于自定义可用输出选项的信息。

当在 Sway 中时，要打开应用程序菜单，请按住 Windows 徽标键（mod）并按下 d 键。可以使用键盘上的箭头键导航菜单。还有一种方法可以操作栏的布局并添加托盘；请阅读 sway-bar(5)手册页面了解更多信息。默认配置会在右上角添加日期和时间。请参阅配置文件中的 Bar 节以查看示例。默认情况下，配置不包括锁定屏幕，除非像上面的示例一样启用锁定计时器。要创建锁定键绑定，需要将以下行添加到 Key bindings 部分：

```
# Lock the screen manually
bindsym $mod+Shift+Return exec $lock
```

现在可以使用按住 Windows 徽标键，同时按住 Shift 键，最后按回车来锁定屏幕。当安装 Sway 时，无论是从软件包还是 FreeBSD ports 安装，都会安装一个默认的 pam.d 文件。默认配置对大多数用户应该是可以接受的，但也有更高级的选项。请阅读 PAM 文档了解更多信息。

最后，要退出 Sway 并返回shell，请按住 Windows 徽标键、Shift，并按下按键 e。将显示一个提示，询问是否要退出 Sway。在迁移期间，可以通过 X11 桌面上的终端模拟器（如 Plasma）启动 Sway。这使得在完全迁移到这个混成器之前测试不同的修改和快捷键更加容易。要启动 Sway，请执行以下命令：

```
% sway -c ~/.config/sway/config
```
