# 6.6.使用 Xwayland

在安装 Wayland 时，应该已安装了 Xwayland 二进制文件，除非 Wayland 是在没有 X11 支持的情况下构建的。如果没有 /usr/local/bin/Xwayland 这个文件，请使用以下命令进行安装：

```
# pkg install xwayland-devel
```

|  | Xwayland 的开发版本是推荐的，且很可能是与 Wayland 软件包一起安装的。每个混成器都有一种启用或禁用此功能的方法。|
| -- | -------------------------------------------------------------------------------------------------------------- |

Xwayland 安装完成后，在所选混成器中进行配置。对于 Wayfire，wayfire.ini 文件中需要以下行：

```
xwayland = true
```

对于 Sway 混成器，默认情况下应该启用 Xwayland。即便如此，建议在~/.config/sway/config 中手动添加一个配置行，如下所示：

```
xwayland enable
```

最后，对于 Hikari，不需要任何修改。支持 Xwayland 默认已构建。要禁用此功能，请从 ports 重新构建软件包并在那时禁用 Xwayland 支持。

进行这些更改后，通过命令行启动混成器，并从快捷键启动终端。在此终端中，发出 env 命令并搜索 DISPLAY 变量。如果混成器能够正确启动 Xwayland X 服务器，则这些环境变量应该看起来类似于以下内容：

```
% env | grep DISPLAY
```

```
WAYLAND_DISPLAY=wayland-1
DISPLAY=:0
```

在此输出中，有一个默认的 Wayland 显示和为 Xwayland 服务器设置的显示。验证 Xwayland 是否正常工作的另一种方法是使用安装和测试小软件包：[x11/eyes] 并检查输出。如果 xeyes 应用程序启动并眼睛跟随鼠标指针，那么 Xwayland 就正常工作。如果显示类似于以下内容的错误，那么在 Xwayland 初始化期间发生了某些问题，可能需要重新安装：

```
Error: Cannot open display wayland-0
```

|  | Wayland 的一个安全特性是，在没有运行 X 服务器的情况下，没有其他的网络监听者。如果启用 Xwayland，这个安全特性对系统就不再适用了。|
| -- | ----------------------------------------------------------------------------------------------------------------------------------- |

对于一些混成器，比如 Wayfire，Xwayland 可能无法正常启动。因此，env 将显示有关 DISPLAY 环境变量的以下信息：

```
% env | grep DISPLAY
```

```
DISPLAY=wayland-1
WAYLAND_DISPLAY=wayland-1
```

即使已经安装和配置了 Xwayfire，X11 应用程序也无法启动，会出现显示问题。为解决此问题，请验证是否已经有一个实例正在使用 UNIX 套接字的 Xwayland。首先，检查从 sockstat 输出的内容，并搜索 X11-unix：

```
% sockstat | grep x11
```

应该有类似以下信息：

```
trhodes  Xwayland   2734  8  stream /tmp/.X11-unix/X0
trhodes  Xwayland   2734  9  stream /tmp/.X11-unix/X0
trhodes  Xwayland   2734  10 stream /tmp/.X11-unix/X0
trhodes  Xwayland   2734  27 stream /tmp/.X11-unix/X0_
trhodes  Xwayland   2734  28 stream /tmp/.X11-unix/X0
```

这表明存在一个 X11 套接字。可以通过在运行在混成器下的终端模拟器中手动尝试执行 Xwayland 来进一步验证这一点：

```
% Xwayland
```

如果已经存在一个 X11 套接字，将向用户呈现以下错误：

```
(EE)
Fatal server error:
(EE) Server is already active for display 0
	If this server is no longer running, remove /tmp/.X0-lock
	and start again.
(EE)
```

由于存在一个活动的 X 显示器，使用显示为 0，环境变量只是设置不正确，要修正这个问题，将 DISPLAY 环境变量更改为 :0，然后尝试再次执行应用程序。以下示例使用 mail/claws-mail 作为需要 Xwayland 服务的应用程序：

```
export DISPLAY=:0
```

修改后，程序 mail/claws-mail 现在应该开始使用 Xwayland 并正常运行。
