# 7.2.设置网络

建立有线和无线连接是 FreeBSD 用户的常见任务。本节将展示如何识别有线和无线网络适配器以及如何配置它们。

在开始配置之前，有必要了解以下网络数据：

* 如果网络有 DHCP
* 如果网络没有 DHCP，则需使用静态 IP
* 网络掩码
* 默认网关的 IP 地址

|  | 网络连接可能在安装时由 bsdinstall(8)配置。|
| -- | -------------------------------------------- |

#### 7.2.1. 识别网络适配器

FreeBSD 支持各种有线和无线网络适配器。查看所用 FreeBSD 发行版的硬件兼容性列表，看看该网络适配器是否受支持。

要获取系统使用的网络适配器，请执行以下命令：

```
% pciconf -lv | grep -A1 -B3 network
```

输出应类似于以下内容：

```
em0@pci0:0:25:0:        class=0x020000 rev=0x03 hdr=0x00 vendor=0x8086 device=0x10f5 subvendor=0x17aa subdevice=0x20ee
    vendor     = 'Intel Corporation' 
    device     = '82567LM Gigabit Network Connection' 
    class      = network
    subclass   = ethernet
--
iwn0@pci0:3:0:0:        class=0x028000 rev=0x00 hdr=0x00 vendor=0x8086 device=0x4237 subvendor=0x8086 subdevice=0x1211
    vendor     = 'Intel Corporation' 
    device     = 'PRO/Wireless 5100 AGN [Shiloh] Network Connection' 
    class      = networ
```

“`@`” 符号之前的文本是控制设备的驱动程序的名称。在这种情况下，这些是 em（4）和 iwn（4）。

|  | 显示供应商的名称 |
| -- | ------------------ |
|  | 显示设备名称     |

```
# kldload if_alc
```

或者，在启动时将驱动程序作为模块加载，将以下行放入/boot/loader.conf 中:

```
if_alc_load="YES"
```
