# 7.3.有线网络


如加载了正确的驱动程序，就需要配置网络适配器。FreeBSD 使用驱动程序名称后跟一个单元编号来命名网络接口适配器。单元编号表示在引导时检测适配器的顺序，或者稍后被发现的顺序。

例如, em0 是系统上使用 em(4) 驱动程序的第一块网卡 (NIC)。

要显示网络接口配置，请输入以下命令:

```
% ifconfig
```

输出应类似于以下内容:

```
em0: flags=8863<UP,BROADCAST,RUNNING,SIMPLEX,MULTICAST> metric 0 mtu 1500
        options=481249b<RXCSUM,TXCSUM,VLAN_MTU,VLAN_HWTAGGING,VLAN_HWCSUM,LRO,WOL_MAGIC,VLAN_HWFILTER,NOMAP>
        ether 00:1f:16:0f:27:5a
        inet6 fe80::21f:16ff:fe0f:275a%em0 prefixlen 64 scopeid 0x1
        inet 192.168.1.19 netmask 0xffffff00 broadcast 192.168.1.255
        media: Ethernet autoselect (1000baseT <full-duplex>)
        status: active
        nd6 options=23<PERFORMNUD,ACCEPT_RTADV,AUTO_LINKLOCAL>
lo0: flags=8049<UP,LOOPBACK,RUNNING,MULTICAST> metric 0 mtu 16384
        options=680003<RXCSUM,TXCSUM,LINKSTATE,RXCSUM_IPV6,TXCSUM_IPV6>
        inet6 ::1 prefixlen 128
        inet6 fe80::1%lo0 prefixlen 64 scopeid 0x2
        inet 127.0.0.1 netmask 0xff000000
        groups: lo
        nd6 options=21<PERFORMNUD,AUTO_LINKLOCAL>
```

在这个例子中，显示了以下设备：

* em0 ：以太网接口。
* lo0 ：环回接口是一个软件环回机制，可用于性能分析、软件测试/本地通信。有关更多信息，请参阅 lo(4)。

这个例子表示 em0 正在运行。

关键参数是：

1. UP 表示界面已配置准备就绪。
2. 接口具有 IPv4 互联网 ( inet ) 地址，192.168.1.19。
3. 接口具有 IPv6 互联网 ( inet6 ) 地址，fe80::21f:16ff:fe0f:275a%em0。
4. 它有一个有效的子网掩码 ( netmask )，其中 0xffffff00 与 255.255.255.0 相同。
5. 它具有有效的广播地址, 192.168.1.255。
6. 接口的 MAC 地址（ ether ）是 00:1f:16:0f:27:5a。
7. 物理媒体选择处于自动选择模式（ media: Ethernet autoselect (1000baseT <full-duplex>) ）。
8. 连接（ status ）的状态为 active，表示检测到载波信号。对于 em0，当未插入以太网电缆时，status: no carrier 状态正常。

如果 ifconfig（8）的输出显示类似于下一个输出，它表示接口尚未配置：

```
em0: flags=8822<BROADCAST,SIMPLEX,MULTICAST> metric 0 mtu 1500
        options=481249b<RXCSUM,TXCSUM,VLAN_MTU,VLAN_HWTAGGING,VLAN_HWCSUM,LRO,WOL_MAGIC,VLAN_HWFILTER,NOMAP>
        ether 00:1f:16:0f:27:5a
        media: Ethernet autoselect
        status: no carrier
        nd6 options=29<PERFORMNUD,IFDISABLED,AUTO_LINKLOCAL>
```

#### 7.3.1. 配置静态 IPv4 地址

本节提供了在 FreeBSD 系统上配置静态 IPv4 地址的指南。

可以通过 ifconfig(8) 命令行配置网卡，但除非配置也添加到 /etc/rc.conf 中，否则在重启后不会保留。

|  | 如果网络在安装期间由 bsdinstall(8) 配置，那么一些网卡(NIC)的条目可能已经存在。在执行 sysrc(8) 之前，请仔细检查 /etc/rc.conf。|
| -- | -------------------------------------------------------------------------------------------------------------------------------------- |

IP 地址可以通过执行以下命令进行设置：

```
# ifconfig em0 inet 192.168.1.150/24
```

要使更改跨重启生效，请执行以下命令：

```
# sysrc ifconfig_em0="inet 192.168.1.150 netmask 255.255.255.0"
```

添加默认路由器执行以下命令：

```
# sysrc defaultrouter="192.168.1.1"
```

将 DNS 记录添加到/etc/resolv.conf：

```
nameserver 8.8.8.8
nameserver 8.8.4.4
```

然后重启 netif 和 routing，执行以下命令：

```
# service netif restart && service routing restart
```

可以使用 ping(8)来测试连接：

```
% ping -c2 www.FreeBSD.org
```

输出应该类似于以下内容：

```
PING web.geo.FreeBSD.org (147.28.184.45): 56 data bytes
64 bytes from 147.28.184.45: icmp_seq=0 ttl=51 time=55.173 ms
64 bytes from 147.28.184.45: icmp_seq=1 ttl=51 time=53.093 ms

--- web.geo.FreeBSD.org ping statistics ---
2 packets transmitted, 2 packets received, 0.0% packet loss
round-trip min/avg/max/stddev = 53.093/54.133/55.173/1.040 ms
```

#### 7.3.2. 配置动态 IPv4 地址

如果网络有 DHCP 服务器，非常容易配置网络接口以使用 DHCP。FreeBSD 使用 dhclient(8)作为 DHCP 客户端。dhclient(8)将自动提供 IP、子网掩码和默认路由器。

使界面与 DHCP 配合工作，请执行以下命令：

```
# sysrc ifconfig_em0="DHCP"
```

dhclient(8)可以通过运行以下命令来手动使用：

```
# dhclient em0
```

输出应类似如下：

```
DHCPREQUEST on em0 to 255.255.255.255 port 67
DHCPACK from 192.168.1.1
unknown dhcp option value 0x7d
bound to 192.168.1.19 -- renewal in 43200 seconds.
```

通过这种方式可以验证使用 DHCP 的地址分配是否正确。

```
# sysrc background_dhclient="YES"
```

然后重启 netif 执行以下命令：

```
# service netif restart
```

可以使用 ping(8)来测试连接：

```
% ping -c2 www.FreeBSD.org
```

输出应该类似于以下内容:

```
PING web.geo.FreeBSD.org (147.28.184.45): 56 data bytes
64 bytes from 147.28.184.45: icmp_seq=0 ttl=51 time=55.173 ms
64 bytes from 147.28.184.45: icmp_seq=1 ttl=51 time=53.093 ms

--- web.geo.FreeBSD.org ping statistics ---
2 packets transmitted, 2 packets received, 0.0% packet loss
round-trip min/avg/max/stddev = 53.093/54.133/55.173/1.040 ms
```

#### 7.3.3. IPv6

IPv6 是众所周知的 IP 协议的新版本，也称为 IPv4。

IPv6 提供了许多优于 IPv4 以及许多新功能的优势：

* 其 128 位地址空间能让拥有 340,282,366,920,938,463,463,374,607,431,768,211,456 个地址。这解决了 IPv4 地址短缺和最终 IPv4 地址枯竭的问题。
* 路由器仅在其路由表中存储网络聚合地址，从而将路由表的平均空间减少到 8192 个条目。这解决了与 IPv4 相关的可伸缩性问题，IPv4 要求 Internet 路由器之间交换每个分配的 IPv4 地址块，导致它们的路由表变得太大，无法实现有效的路由。
* 地址自动配置 (RFC2462)。
* 强制组播地址。
* 内置 IPsec（IP 安全）。
* 简化的标头结构。
* 支持移动 IP。
* IPv6 到 IPv4 的过渡机制。

FreeBSD 包含 KAME 项目 IPv6 参考实现，并配备了使用 IPv6 所需的一切。

本节重点介绍如何配置和运行 IPv6。

IPv6 地址有三种不同类型。

单播发送到单播地址的数据包将到达属于该地址的接口。

任播这些地址在语法上无法与单播地址区分，但它们寻址一组接口。发送到任播地址的数据包将到达最近的路由器接口。任播地址只被路由器使用。

多播这些地址标识一组接口。发送到多播地址的数据包将到达属于多播组的所有接口。IPv4 的广播地址通常为 xxx.xxx.xxx.255，在 IPv6 中通过多播地址来表示。

当阅读 IPv6 地址时，规范形式表示为 xxxx:x，其中每个 x 代表一个 16 位十六进制值。一个示例是 FEBC:A574:382B:23C1:AA49:4592:4EFE:9982。

通常，一个地址会有很长的全零子串。一个 :: （双冒号）可用于替换每个地址的一个子串。此外，每个十六进制值最多可以省略前三个领先的 0。例如，fe80::1 对应于规范形式 fe80:0000:0000:0000:0000:0000:0000:0001。

第三种形式是使用众所周知的 IPv4 表示法写入最后 32 位。例如，2002::10.0.0.1 对应于十六进制规范表示 2002:0000:0000:0000:0000:0000:0a00:0001，而这又等同于 2002::a00:1。

查看 FreeBSD 系统的 IPv6 地址，请执行以下命令：

```
# ifconfig
```

输出应类似于以下内容：

```
em0: flags=8863<UP,BROADCAST,RUNNING,SIMPLEX,MULTICAST> metric 0 mtu 1500
        options=481249b<RXCSUM,TXCSUM,VLAN_MTU,VLAN_HWTAGGING,VLAN_HWCSUM,LRO,WOL_MAGIC,VLAN_HWFILTER,NOMAP>
        ether 00:1f:16:0f:27:5a
        inet 192.168.1.150 netmask 0xffffff00 broadcast 192.168.1.255
        inet6 fe80::21f:16ff:fe0f:275a%em0 prefixlen 64 scopeid 0x1
        media: Ethernet autoselect (1000baseT <full-duplex>)
        status: active
        nd6 options=23<PERFORMNUD,ACCEPT_RTADV,AUTO_LINKLOCAL>
```

在此示例中，em0 接口正在使用 fe80::21f:16ff:fe0f:275a%em0，这是一个自动从 MAC 地址生成的自动配置的链路本地地址。

一些 IPv6 地址是保留的。可以在以下表中查看保留地址的列表：

表 9. 示例 IPv6 保留地址

|IPv6 地址|前缀长度（位）|说明|备注|
| --------------------------------| ---------------------| -------------| -------| 
| :: |128 位|未指定|等同于 IPv4 中的 0.0.0.0。|
| ::1 |128 位|环回地址|等同于 IPv4 中的 127.0.0.1。|
 | ::00:xx:xx:xx:xx |96 位|嵌入式 IPv4|低 32 位是对应的 IPv4 地址。|
 | ::ff:xx:xx:xx:xx |96 位|IPv4 映射的 IPv6 地址|对于不支持 IPv6 的主机，低 32 位是 IPv4 地址。| 
| fe80::/10 |10 位|链路本地|等同于 IPv4 中的 169.254.0.0/16。| 
| fc00::/7 |7 位|唯一本地|唯一本地地址用于本地通信，仅在一组合作站点内可路由。|
 | ff00:: |8 位|组播||
 | 2000::-3fff:: |3 位|全局单播|所有全局单播地址都从该池中分配。前 3 位是 001。|

关于 IPv6 地址结构的进一步信息，请参阅 RFC3513。

#### 配置静态 IPv6 地址

要将 FreeBSD 系统配置为具有静态 IPv6 地址的 IPv6 客户端，需要设置 IPv6 地址。

执行以下命令以满足要求：

```
# sysrc ifconfig_em0_ipv6="inet6 2001:db8:4672:6565:2026:5043:2d42:5344 prefixlen 64"
```

指定其地址来分配默认路由，请执行以下命令：

```
# sysrc ipv6_defaultrouter="2001:db8:4672:6565::1"
```

#### 7.3.5. 配置动态 IPv6 地址

如果网络有 DHCP 服务器，则很容易配置网络接口以使用 DHCP。dhclient(8)将自动提供 IP、子网掩码和默认路由。

使界面在没有 DHCP 的情况下工作，请执行以下命令：

```
# sysrc ifconfig_em0_ipv6="inet6 accept_rtadv"
# sysrc rtsold_enable="YES"
```

#### 7.3.6. 路由器通告和主机自动配置

本节演示如何在 IPv6 路由器上设置 rtadvd(8)以广播 IPv6 网络前缀和默认路由。

启用 rtadvd(8)，执行以下命令：

```
# sysrc rtadvd_enable="YES"
```

指定要执行 IPv6 路由器通告的接口非常重要。例如，告诉 rtadvd(8) 使用 em0 ：

```
# sysrc rtadvd_interfaces="em0"
```

接下来，创建配置文件，/etc/rtadvd.conf，示例如下：

```
em0:\
	:addrs#1:addr="2001:db8:1f11:246::":prefixlen#64:tc=ether:
```

用 em0 替换要使用的接口，用 2001:db8:1f11:246:: 替换分配的前缀。

对于专用 /64 子网，无需更改其他内容。否则，将 prefixlen# 更改为正确的值。

#### 7.3.7. IPv6 和 IPv4 地址映射

当在服务器上启用 IPv6 时，可能需要启用 IPv4 映射的 IPv6 地址通信。这个兼容选项能让 IPv4 地址表示为 IPv6 地址。能让 IPv6 应用程序与 IPv4 通信，反之亦然，可能存在安全问题。

在大多数情况下可能不需要此选项，仅供兼容性使用。此选项将能让仅支持 IPv6 的应用程序与双栈环境中的 IPv4 一起工作。这对于可能不支持仅 IPv6 环境的第三方应用程序非常有用。

要启用此功能，请执行以下命令：

```
# sysrc ipv6_ipv4mapping="YES"
```
