# 7.4.无线网络

大多数无线网络都基于 IEEE® 802.11 标准。

FreeBSD 支持使用 802.11a、802.11b、802.11g 和 802.11n 运行的网络。

|  | FreeBSD 上的 802.11ac 支持目前正在开发中。|
| -- | -------------------------------------------- |

一个基本的无线网络由多个站点组成，这些站点使用在 2.4GHz 或 5GHz 频段广播的无线电进行通信，尽管这根据地区而异，并且也在变化中，以实现在 2.3GHz 和 4.9GHz 频段的通信。

配置无线网络有三个基本步骤：

1. 扫描并选择接入点
2. 对站点进行身份验证
3. 配置 IP 地址或使用 DHCP。

以下各节讨论每个步骤。

#### 7.4.1. 连接到无线网络的快速入门。

连接 FreeBSD 到现有无线网络是一种非常常见的情况。

这个过程显示所需的步骤：

* 第一步将是从网络管理员获取该无线网络的 SSID（服务集标识）和 PSK（预共享密钥）。
* 第二步是将此网络添加到 /etc/wpa_supplicant.conf 的条目中。如果文件不存在，请创建之：

```
network={
 ssid="myssid" 
 psk="mypsk" 
}
```

|  | 无线网络的 SSID。用无线网络的名称替换它。                            |
| -- | ------------------------------------------------------------------------------------- |
|  | 无线网络的 PSK。用无线网络的密码替换它。<br />第三步将是添加网络条目以配置启动时的网络: |

```
# sysrc wlans_iwn0="wlan0"
# sysrc ifconfig_wlan0="WPA DHCP"
```

* 最后一步将是重启 netif 服务，执行以下命令:

```
# service netif restart
```

#### 7.4.2. 基本无线配置

第一步将是配置无线网络卡至一个接口。要找出系统中有哪些无线网络卡，请查看识别网络适配器部分。

```
# ifconfig wlan0 create wlandev iwm0
```

要使更改持续到重启，执行以下命令：

```
# sysrc wlans_iwm0="wlan0"
```

```
# ifconfig wlan0 regdomain etsi2 country AT
```

要使设置持续下去，将其添加到 /etc/rc.conf 中：

```
# sysrc create_args_wlan0="country AT regdomain etsi2"
```

#### 扫描无线网络

可以使用 ifconfig(8)来扫描可用的无线网络。

要列出无线网络，请执行以下命令：

```
# ifconfig wlan0 up list scan
```

输出应类似于以下内容：

```
SSID/MESH ID                      BSSID              CHAN RATE    S:N     INT CAPS
FreeBSD                           e8:d1:1b:1b:58:ae    1   54M  -47:-96   100 EP   RSN BSSLOAD HTCAP WPS WME
NetBSD                            d4:b9:2f:35:fe:08    1   54M  -80:-96   100 EP   RSN BSSLOAD HTCAP WPS WME
OpenBSD                           fc:40:09:c6:31:bd   36   54M  -94:-96   100 EPS  VHTPWRENV APCHANREP RSN WPS BSSLOAD HTCAP VHTCAP VHTOPMODE WME
GNU-Linux                         dc:f8:b9:a0:a8:e0   44   54M  -95:-96   100 EP   WPA RSN WPS HTCAP VHTCAP VHTOPMODE WME VHTPWRENV
Windows                           44:48:b9:b3:c3:ff   44   54M  -84:-96   100 EP   BSSLOAD VHTPWRENV HTCAP WME RSN VHTCAP VHTOPMODE WPS
MacOS                             46:48:b9:b3:c3:ff   44   54M  -84:-96   100 EP   BSSLOAD VHTPWRENV HTCAP WME RSN VHTCAP VHTOPMODE WPS
```

1. SSID / MESH ID 标识网络的名称。
2. BSSID 标识访问点的 MAC 地址。
3. CAPS 字段标识着每个网络的类型以及在那里操作的站点的功能（有关更多详细信息，请参见 ifconfig(8)中的 list scan 的定义）。

#### 7.4.4. 连接和认证到无线网络

从扫描的网络列表中选择了无线网络之后，就需要执行连接和认证。在绝大多数的无线网络中，认证是通过在路由器中配置密码来完成的。其他方案要求在数据流量可以流动之前完成加密握手，可以使用预共享密钥或密码，也可以使用涉及后端服务（如 RADIUS）的更复杂方案。

##### 7.4.4.1. 使用 WPA2/WPA/Personal 进行身份验证

无线网络中的认证流程由 wpa_supplicant(8)管理。

wpa_supplicant(8)的配置将在/etc/wpa_supplicant.conf 文件中进行。更多信息，请参阅 wpa_supplicant.conf(5)。

扫描无线网络，选择接入拥有密码（PSK）的网络，该信息将被添加到文件/etc/wpa_supplicant.conf 中，如下例所示：

```
network={
        scan_ssid=1 
        ssid="FreeBSD" 
        psk="12345678" 
}
```

|  | SSID 扫描技术。只有在网络隐藏时才需要使用此选项。|
| -- | --------------------------------------------------- |
|  | 网络名称。                         |
|  | 无线网络的密码。                   |

下一步将是在文件 /etc/rc.conf 中配置无线连接。

要使用静态地址，需要执行以下命令：

```
# sysrc ifconfig_wlan0="inet 192.168.1.20 netmask 255.255.255.0"
```

使用动态地址需要执行以下命令：

```
# sysrc ifconfig_wlan0="WPA DHCP"
```

然后执行以下命令重启网络：

```
# service netif restart
```

|  | 欲了解更高级的身份验证方法，请参阅 Wireless Advanced Authentication。|
| -- | ----------------------------------------------------------------------- |

##### 7.4.4.2. 使用开放网络进行身份验证

|  | 当用户在没有任何形式的身份验证的情况下连接到开放网络时，非常重要要小心。|
| -- | -------------------------------------------------------------------------- |

完成无线网络扫描并选择了无线网络的 SSID后，执行以下命令：

```
# ifconfig wlan0 ssid SSID
```

然后执行 dhclient(8)获取配置的地址：

```
# dhclient wlan0
```

#### 7.4.5.同时使用有线和无线连接

有线连接提供更好的性能和可靠性，而无线连接提供灵活性和移动性。笔记本电脑用户通常希望在这两种连接类型之间无缝漫游。

在 FreeBSD 上，可以以“故障转移”方式将两个甚至更多的网络接口组合在一起。这种类型的配置使用一组网络接口中最优先和可用的连接，并在链接状态发生变化时，操作系统会自动切换。

链路聚合和故障转移在链路聚合和故障转移中进行了介绍，并提供了一个关于使用有线和无线连接的故障转移模式示例。
