# 7.6.DNS

DNS 可以被理解为一个电话簿，在其中 IP 地址与主机名相互对应。

FreeBSD 系统处理 DNS 交互的三个文件是 hosts(5)、resolv.conf(5)和 nsswitch.conf(5)。

除非在/etc/nsswitch.conf 文件中另有说明，FreeBSD 将查看/etc/hosts 文件中的地址，然后是/etc/resolv.conf 文件中的 DNS 信息。

```
hosts: files dns
```

例如，在使用 nscd(8)服务的情况下，可以通过保留以下行来修改偏好顺序。

```
hosts: files cache dns
```

#### 7.6.1. 本地地址

/etc/hosts 文件是一个简单的文本数据库，用于提供主机名到 IP 地址的映射。可以将通过局域网连接的本地计算机的条目添加到此文件中，以便简化命名，而不是设置 DNS 服务器。此外，/etc/hosts 可用于提供互联网名称的本地记录，减少了查询外部 DNS 服务器以获取常用名称的需求。

例如，在本地环境中有一个名为 www/gitlab-ce 的本地实例的情况下，可以将其添加到/etc/hosts 文件中如下：

```
192.168.1.150 git.example.com git
```

#### 配置域名服务器

FreeBSD 系统如何访问互联网域名系统(DNS)受 resolv.conf(5)控制。

/etc/resolv.conf 中最常见的条目有：

| `nameserver` | 域名解析器应查询的名称服务器的 IP 地址。服务器按照列出的顺序查询，最多三个。|
| -- | ------------------------------------------------------------------------------- |
| `search` | 用于主机名查找的搜索列表。这通常由本地主机名的域确定。        |
| `domain` | 本地域名。                                                     |

一个典型的 /etc/resolv.conf 看起来像这样:

```
search example.com
nameserver 147.11.1.11
nameserver 147.11.100.30
```

|  | 参数 search 和 domain 只能使用一个。|
| -- | --------------------------------------- |

当使用 DHCP 时，dhclient(8) 通常会使用从 DHCP 服务器接收的信息重写 /etc/resolv.conf。

```
# sysrc local_unbound_enable="YES"
```

要启动 local unbound（8）服务，请执行以下命令：

```
# service local_unbound start
```
