# 8.2.桌面环境


本节介绍了如何在 FreeBSD 系统上对常见的桌面环境进行安装和配置。桌面环境可以是简单的窗口管理器，也可以是完整的桌面应用程序套件。

支持的桌面环境表 1

| 名称       | 许可证             | 软件包         |
| ------------ | -------------------- | -------------- |
| KDE Plasma | GPL 2.0 或更高     | x11/kde5     |
| GNOME      | GPL 2.0 或更高版本 | x11/gnome    |
| XFCE       | GPL，LGPL，BSD     | x11-wm/xfce4 |
| MATE       | GPL 2.0，LGPL 2.0  | x11/mate     |
| cinnamon     | GPL 2.0 或更高版本 | x11/cinnamon     |
| LXQT       | GPL，LGPL          | x11-wm/lxqt  |

### 8.2.1. KDE Plasma

KDE Plasma 是一个易于使用的桌面环境。这个桌面提供了一套具有一致外观和感觉的应用程序，标准化的菜单和工具栏，快捷键，颜色方案，国际化以及集中的、对话框驱动的桌面配置。有关 KDE 的更多信息，请访问 KDE 主页。要获取特定于 FreeBSD 的信息，请查阅 KDE 的 FreeBSD 主页。

#### 8.2.1.1. 安装 KDE Plasma 元包

安装 KDE Plasma 元包，包含 KDE 框架、Plasma 桌面和应用程序，执行：

```
# pkg install kde5
```

#### 8.2.1.2. 最小的 KDE Plasma 安装

安装最小化的 KDE Plasma 执行：

```
# pkg install plasma5-plasma
```

```
# pkg install konsole
```

#### 8.2.1.3。配置 KDE Plasma

KDE Plasma 使用 dbus-daemon（1）作为消息总线和硬件抽象层。这个应用程序会自动安装为 KDE Plasma 的依赖。

在 /etc/rc.conf 中启用 D-BUS 服务以便在系统启动时启动：

```
# sysrc dbus_enable="YES"
```

增加消息大小，请执行：

```
sysctl net.local.stream.recvspace=65536
sysctl net.local.stream.sendspace=65536
```

#### 8.2.1.4. 启动 KDE Plasma

KDE Plasma 首选的显示管理器是 x11/sddm。要安装 x11/sddm，请执行：

```
# pkg install sddm
```

在 /etc/rc.conf 中启用 SDDM 服务以便在系统启动时启动：

```
# sysrc sddm_enable="YES"
```

可以通过运行以下命令在 SDDM 中设置键盘语言（例如，对于西班牙语）：

```
# sysrc sddm_lang="es_ES"
```

通过手动调用 startx(1)的方式启动 KDE Plasma 的第二种方法。为了使其正常工作，需要在~/.xinitrc 中添加以下行：

```
% echo "exec dbus-launch --exit-with-x11 ck-launch-session startplasma-x11" > ~/.xinitrc
```

### 8.2.2. GNOME

GNOME 是个用户友好的桌面环境。它包括一个面板用于启动应用程序和显示状态，一个桌面，一组工具和应用程序，以及一组使应用程序易于合作并与彼此一致的约定。

#### 8.2.2.1. 安装 GNOME 元包


要通过软件包安装 GNOME 元包（含桌面及应用程序），请执行：
```
# pkg install gnome
```

#### 8.2.2.2. Minimal GNOME installation


要通过软件包安装 GNOME-lite 元包（仅含桌面所必需的），请执行；

```
# pkg install gnome-lite
```

#### 8.2.2.3. 配置 GNOME

GNOME 需要挂载 /proc。添加此行 /etc/fstab 以在系统启动时自动挂载此文件系统：

```
# Device                Mountpoint      FStype  Options         Dump    Pass#
proc                    /proc           procfs  rw              0       0
```

GNOME 使用 dbus-daemon(1) 来进行消息总线和硬件抽象。该应用程序会自动作为 GNOME 的依赖进行安装。

启用 D-BUS 服务在 /etc/rc.conf 中，以便在系统启动时启动：

```
# sysrc dbus_enable="YES"
```

#### 8.2.2.4. 启动 GNOME

GNOME 显示管理器是 GNOME 的首选显示管理器。GDM 是 GNOME 套件的一部分，已一起安装。

在 /etc/rc.conf 中启用 GDM 以在系统启动时启动：

```
# sysrc gdm_enable="YES"
```

启动 GNOME 的另一种方法是通过手动调用 startx(1)。为了使其工作，需要在 ~/.xinitrc 中添加以下行：

```
% echo "exec gnome-session" > ~/.xinitrc
```

### 8.2.3. XFCE

XFCE 是基于 GTK+ 的桌面环境，轻量级且提供简单、高效、易于使用的桌面环境。它是完全可配置的，有一个带有菜单、小程序和应用启动器的主面板，提供文件管理器和声音管理器，并且支持主题定制。由于它快速、轻量且高效，非常适合内存有限的旧款或较卡的计算机。

#### 8.2.3.1. 安装 XFCE

要安装 XFCE 元包，请执行:

```
# pkg install xfce
```

#### 8.2.3.2. Configure XFCE

XFCE 需要挂载 /proc。添加此行 /etc/fstab 以在系统启动时自动挂载此文件系统：


```
# Device                Mountpoint      FStype  Options         Dump    Pass#
proc                    /proc           procfs  rw              0       0
```

XFCE 使用 [dbus-daemon(1)](https://man.freebsd.org/cgi/man.cgi?query=dbus-daemon&sektion=1&format=html) 来进行消息总线和硬件抽象。该应用程序会自动作为 XFCE的依赖进行安装。

在 /etc/rc.conf 中启用 D-BUS 以便在系统启动时启动：

```
# sysrc dbus_enable="YES"
```

#### 8.2.3.3. 启动 XFCE

x11/lightdm 是一个支持多种显示技术的显示管理器，作为选择非常轻量级，需要少量内存，性能高。

要安装它，请执行：

```
# pkg install lightdm lightdm-gtk-greeter
```

在 /etc/rc.conf 中启用 lightdm 以便在系统启动时启动：

```
# sysrc lightdm_enable="YES"
```

第二种启动 XFCE 的方法是手动调用 startx(1)。为使此方法起作用，需要在 ~/.xinitrc 中添加以下行：

```
% echo '. /usr/local/etc/xdg/xfce4/xinitrc' > ~/.xinitrc
```

### 8.2.4。MATE

MATE 桌面环境是 GNOME 2 的延续。它提供了一个使用传统GNOME 的直观和吸引人的桌面环境。

#### 8.2.4.1。安装 MATE 元包

安装包含 MATE 桌面及一些额外应用程序（如文本编辑器、档案管理器等）的 MATE 元包，请执行：

```
# pkg install mate
```

#### 8.2.4.2. 精简的 MATE 安装

要安装仅包含 MATE 桌面基本内容的 MATE 轻量级元包，请执行：

```
# pkg install mate-base
```

#### 8.2.4.3. Configure MATE

MATE 需要挂载 /proc。添加此行 /etc/fstab 以在系统启动时自动挂载此文件系统：


```
# Device                Mountpoint      FStype  Options         Dump    Pass#
proc                    /proc           procfs  rw              0       0
```

MATE 使用 [dbus-daemon(1)](https://man.freebsd.org/cgi/man.cgi?query=dbus-daemon&sektion=1&format=html)来进行消息总线和硬件抽象。该应用程序会自动作为 MATE的依赖进行安装。

在 /etc/rc.conf 中启用 D-BUS 以便在系统启动时启动：
 

```
# sysrc dbus_enable="YES"
```

#### 8.2.4.4. 启动 MATE

x11/lightdm 是一个支持多种显示技术的显示管理器，是一个很好的选择，因为它非常轻量级，占用内存小，且性能高。

要安装它，请执行：

```
# pkg install lightdm lightdm-gtk-greeter
```

将 lightdm 在 /etc/rc.conf 中启用以在系统启动时启动：

```
# sysrc lightdm_enable="YES"
```

第二种启动 MATE 的方法是手动调用 startx(1)来实现。为了使此方法起作用，在 ~/.xinitrc 中需要以下行：

```
% echo "exec dbus-launch --exit-with-x11 ck-launch-session mate-session" > ~/.xinitrc
```

### 8.2.5. cinnamon

Cinnamon 是一款 UNIX® 桌面，提供先进的创新功能和传统的用户体验。桌面布局与 Gnome 2 相似。其底层技术源自 Gnome Shell。其重点是让用户有宾至如归的感觉，并为他们提供易于使用和舒适的桌面体验。

#### 8.2.5.1.安装cinnamon

要安装 cinnamon，请执行：
```
# pkg install cinnamon
```

#### 8.2.5.2. 配置 cinnamon

Cinnamon 需要 /proc 被挂载。在系统启动时，将以下行添加到 /etc/fstab 以在系统启动时自动挂载此文件系统：

```
# Device                Mountpoint      FStype  Options         Dump    Pass#
proc                    /proc           procfs  rw              0       0
```

cinnamon 使用 dbus-daemon(1) 作为消息总线和硬件抽象。此应用程序会自动作为 Cinnamon 依赖项安装。在 /etc/rc.conf 中启用 D-BUS 以在系统启动时启动：

```
# sysrc dbus_enable="YES"
```

#### 8.2.5.3. 启动cinnamon

x11/lightdm 是一款支持不同显示技术的显示管理器，它是一个很好的选择，因为它非常轻量级，需要很少的内存使用，并且具有快速的性能。

要安装它，执行：

```
# pkg install lightdm lightdm-gtk-greeter
```

在 /etc/rc.conf 启用 lightdm 以在系统引导时启动：

```
# sysrc lightdm_enable="YES"
```

另一种启动 Cinnamon 的方法是手动调用 startx(1)。要使此方法起作用，需要在 ~/.xinitrc 中添加以下行：

```
% echo "exec dbus-launch --exit-with-x11 ck-launch-session cinnamon-session" > ~/.xinitrc
```

### 8.2.6. LXQT

LXQt 是基于 Qt 技术的先进、易用、快速的桌面环境。它专为注重简单、快速和直观界面的用户量身定制。与大多数桌面环境不同，LXQt 还能在性能较弱的机器上正常运行。

#### 8.2.6.1. 安装 LXQT

要安装 LXQT 元软件包，请执行

```
# pkg install lxqt
```

#### 8.2.6.2. 配置 LXQT

LXQT 需要挂载/proc 。将此行添加到 /etc/fstab 以在系统启动期间自动挂载此文件系统：

```
# Device                Mountpoint      FStype  Options         Dump    Pass#
proc                    /proc           procfs  rw              0       0
```

LXQT 使用 dbus-daemon(1) 作为消息总线和硬件抽象。此应用程序会作为 LXQT 的依赖自动安装。

在 /etc/rc.conf 上启用 D-BUS 以在系统启动时启动:

```
# sysrc dbus_enable="YES"
```

#### 8.2.6.3. 启动 LXQT

LXQT 首选的显示管理器是 x11/sddm。要安装 x11/sddm，请执行:

```
# pkg install sddm
```

在 `/etc/rc.conf` 中启用 SDDM 服务，以便在系统启动时启动：

```
# sysrc sddm_enable="YES"
```


可通过运行以下命令在 SDDM 中设置键盘语言（如西班牙语）：

```
# sysrc sddm_lang="es_ES"
```

第二种启动 LXQT 的方法是手动调用 [startx(1)](https://man.freebsd.org/cgi/man.cgi?query=startx&sektion=1&format=html)。

为此，需要在 `~/.xinitrc` 中加入以下一行：

```
% echo "exec dbus-launch --exit-with-x11 ck-launch-session startlxqt" > ~/.xinitrc
```
