# 8.3.浏览器

本节讲解了如何在 FreeBSD 系统上安装和配置常见的网络浏览器，从资源消耗高的完整网络浏览器到资源使用较少的命令行网络浏览器。

支持的浏览器表格 2

| 名称         | 许可证             | 软件包 | 所需资源 |
| --------------- | -------------------- | ---- | ---------- |
| Firefox      | MPL 2.0            | [www/firefox](https://cgit.freebsd.org/ports/tree/www/firefox/)   | 重    |
| Chromium            | BSD-3 和其他       | [www/chromium](https://cgit.freebsd.org/ports/tree/www/chromium/)   | 重       |
|Iridium browser      | BSD-3 和其他       | [www/iridium-browser](https://cgit.freebsd.org/ports/tree/www/iridium-browser/)   | 重       |
| Falkon         | MPL 2.0            | [www/falkon-qtonly](https://cgit.freebsd.org/ports/tree/www/falkon-qtonly/)   | 重     |
| Konqueror        | GPL 2.0 或更高版本 | [x11-fm/konqueror](https://cgit.freebsd.org/ports/tree/x11-fm/konqueror/)   | 中       |
| Gnome Web (Epiphany)| GPL 3.0 或更高版本 | [www/epiphany](https://cgit.freebsd.org/ports/tree/www/epiphany/)   | 中   |
| qutebrowser   | GPL 3.0 或更高版本 | [www/qutebrowser](https://cgit.freebsd.org/ports/tree/www/qutebrowser/)   | 中    |
| Dillo          | GPL 3.0 或更高版本 | [www/dillo2](https://cgit.freebsd.org/ports/tree/www/dillo2/)   | 轻      |
|Links          | GPL 2.0 或更高版本 | [Links](https://cgit.freebsd.org/ports/tree/www/links/)   | 轻      |
| w3m           | MIT                | [w3m](https://cgit.freebsd.org/ports/tree/www/w3m/)   | 轻     |

### 8.3.1. 火狐

火狐浏览器是一款开源浏览器，具有符合标准的 HTML 显示引擎、标签式浏览、弹出屏蔽、扩展、改进的安全性等功能。Firefox 基于 Mozilla 的存储库。

要安装最新发行版本的 Firefox 软件包，请执行：

```
# pkg install firefox
```

要安装 Firefox Extended Support Release (ESR)版本，请执行：

```
# pkg install firefox-esr
```

### 8.3.2. Chromium

Chromium 是一款旨在构建更安全、更快速、更稳定的网络浏览体验的开源浏览器项目。Chromium 具有分页浏览、弹出窗口阻止、扩展等功能。Google Chrome 浏览器就基于 Chromium 这个开源项目。

要安装 Chromium，请执行：

```
# pkg install chromium
```

|  | Chromium 的可执行文件是/usr/local/bin/chrome，而不是 /usr/local/bin/chromium。|
| -- | ------------------------------------------------------------------------------- |

### 8.3.3. Iridium browser

Iridium browser 是 Chromium 存储库的免费、开源、自由浏览器修改版，在几个关键领域增强了隐私保护。自动传输部分查询、关键词、指标到中央服务被禁止，只有在获得同意的情况下才会发生。

安装 Iridium browser execute：

```
# pkg install iridium-browser
```

### 8.3.4. falkon

falkon 是一款较新且非常快速的 QtWebEngine 浏览器。它旨在成为一个轻量级的 web 浏览器，可在所有主要平台上使用。法尔肯具有所有人们可以从 web 浏览器中期望的标准功能。它包括书签、历史记录（侧边栏中也都有）和选项卡。除此之外，AdBlock 插件可以阻止广告，Click2Flash 可以阻止 Flash 内容，而 SSL 管理器可以编辑本地 CA 证书数据库。

安装 Falkon，请执行:

```
# pkg install falkon
```

### 8.3.5. Konqueror

Konqueror 不仅是一个网页浏览器，还是一个文件管理器和多媒体查看器。它支持 WebKit，这也是许多现代浏览器（包括 Chromium）使用的渲染引擎，以及它自己的 KHTML 引擎。

安装 Konqueror，请执行：

```
# pkg install konqueror
```

### 8.3.6. Gnome Web (Epiphany)

Gnome Web (Epiphany) 是一款设计得尽可能轻量和快速的网页浏览器，牺牲了许多其他浏览器中的功能。

安装 Gnome Web（Epiphany），执行：

```
# pkg install epiphany
```

### 8.3.7. qutebrowser

Qutebrowser 是一款以键盘为焦点的浏览器，拥有最小化的 GUI。它基于 Python 和 PyQt5，并且是根据 GPL 许可的自由软件。

安装 qutebrowser，请执行：

```
# pkg install qutebrowser
```

### 8.3.8. Dillo

Dillo 旨在成为一款多平台的替代浏览器，体积小，稳定，开发者友好，易用，快速且可扩展。这个新的、实验性的 Dillo 版本基于 FLTK 工具包，而不是 GTK1，并且已经进行了大幅重写。

安装 Dillo，请执行：

```
# pkg install dillo2
```

### 8.3.9. Links

它是一款类似 Lynx 的具有文本和图形模式的 Web 浏览器，具有许多功能，如显示表格、菜单等。

安装 Links，请执行：

```
# pkg install links
```

### 8.3.10. w3m

w3m 是一款分页器/基于文本的网页浏览器。它类似于 Lynx 应用程序，但它具有几个 Lynx 没有的功能，如表格渲染和框架渲染。

安装 w3m，请执行：

```
# pkg install w3m
```
