# 8.4.开发工具

本节概述了在 FreeBSD 系统上安装和配置一些流行的开发工具的方法。

支持的开发工具

表 3

| 名称               | 许可证                                   | 包 | 所需资源     |
| -------------------- | ------------------------------------------ | ---- | -------------- |
| Visual Studio Code | MIT                                      | [editors/vscode](https://cgit.freebsd.org/ports/tree/editors/vscode/)   | 重           |
| Qt Creator         | QtGPL (特许)                             | [devel/qtcreator](https://cgit.freebsd.org/ports/tree/devel/qtcreator/)   | 重|
| Kdevelop           | GPL 2.0 或更高版本和 LGPL 2.0 或更高版本 | [devel/kdevelop](https://cgit.freebsd.org/ports/tree/devel/kdevelop/)   | 重           |
| Eclipse IDE        | EPL                                      | [java/eclipse](https://cgit.freebsd.org/ports/tree/java/eclipse/)   | 重           |
| Vim               | VIM                                      | [editors/vim](https://cgit.freebsd.org/ports/tree/editors/vim/)   | 轻          |
| Neovim             | Apache 2.0                               | [editors/neovim](https://cgit.freebsd.org/ports/tree/editors/neovim/)   | 轻           |
| GNU Emacs          | GPL 3.0 或更高版本                       | [editors/emacs](https://cgit.freebsd.org/ports/tree/editors/emacs/)   | 轻         |

### 8.4.1. Visual Studio Code

Visual Studio Code 是一种工具，它将代码编辑器的简单性与开发人员在核心编辑构建调试周期中所需的功能相结合。它提供全面的编辑和调试支持，具有可扩展性模型，并与现有工具轻量级集成。

要安装 Visual Studio Code，请执行：

```
# pkg install vscode
```

### 8.4.2. Qt Creator

Qt Creator 是专为 Qt 开发人员需求量身定制的跨平台集成开发环境。Qt Creator 包含的功能包括：

* 具有 C++、QML 和 ECMAscript 支持的代码编辑器；
* 快速代码导航工具;
* 当你输入时，提供静态代码检查和样式提示;
* 上下文敏感的帮助;
* 可视化调试器;
* 集成的 GUI 布局和表单设计器。

要安装 Qt Creator，请执行：

```
# pkg install qtcreator
```

### 8.4.3. kdevelop

开源、功能丰富、插件可扩展的 C/C++和其他编程语言 IDE。它基于 KDevPlatform 以及 KDE 和 Qt 库，自 1998 年以来一直在开发中。

要安装 KDevelop，请执行：

```
# pkg install kdevelop
```

### 8.4.4. Eclipse IDE

Eclipse 平台是一款开放可扩展的 IDE，可以用于任何事情，但没有特定用途。Eclipse 平台提供构建块和构建及运行集成软件开发工具的基础。Eclipse 平台能让工具构建者独立开发能与其他人的工具集成的工具。

要安装 Eclipse IDE，请执行：

```
# pkg install eclipse
```

### 8.4.5. Vim

Vim 是一种高度可配置的文本编辑器，旨在实现高效的文本编辑。它是大多数 UNIX 系统中分发的 vi 编辑器的改进版本。

Vim 经常被称为 “程序员的编辑器”，对于编程非常有用，许多人认为它是整个 IDE。不过，Vim 不仅适用于程序员。从撰写电子邮件到编辑配置文件，Vim 都非常适用于各种文本编辑。

安装 Vim，请执行：

```
# pkg install vim
```

### 8.4.6. Neovim

Neovim 是编辑器/vim 的一个激进改写。它代表了对代码库的完全改造，包括合理的默认设置，内置终端模拟器，异步插件架构以及为速度和可扩展性而设计的强大 API。它几乎保留与所有 Vim 插件和脚本的完全兼容性。

安装 Neovim，执行：

```
# pkg install neovim
```

### 8.4.7. GNU Emacs

GNU Emacs 是一款可扩展、可定制、自由的文本编辑器。其核心是用于 Emacs Lisp 解释器，这是一种带有扩展以支持文本编辑的 Lisp 编程语言方言。

要安装 GNU Emacs，请执行：

```
# pkg install emacs
```
