# 8.5.桌面办公应用

谈到生产力，用户通常会寻找办公套件或易于使用的文字处理软件。虽然一些桌面环境如 KDE Plasma 提供了办公套件，但不是默认的生产力套件。在 FreeBSD 上有几个办公套件和图形文字处理软件可供选择，无论安装了哪个桌面环境。

本节演示如何安装以下流行的办公软件，并指出应用程序是否需要大量资源，需要从ports编译，或者有任何重要依赖。

支持的桌面办公生产力套件

表 4

| 名称          | 许可证             | 包 | 所需资源 |
| --------------------------------------------| ---------| ---------| ------------------|
|LibreOffice|MPL 2.0|[editors/libreoffice](https://cgit.freebsd.org/ports/tree/editors/libreoffice/)|重|
|Calligra Suite|LGPL 和 GPL|[editors/calligra](https://cgit.freebsd.org/ports/tree/editors/calligra/)|中等|
|AbiWord|GPL 2.0 及更高|[editors/abiword](https://cgit.freebsd.org/ports/tree/editors/abiword/)|中等|


### 8.5.1. LibreOffice

LibreOffice 是由 The Document Foundation 开发的免费软件办公套件。它与其他主要办公套件兼容，并可在多种平台上使用。它是 Apache OpenOffice 的重新品牌复刻，并包括在完整办公生产力套件中找到的应用程序：文字处理器、电子表格、演示文稿管理器、绘图程序、数据库管理程序以及用于创建和编辑数学公式的工具。它提供多种不同语言版本，并且国际化已扩展到界面、拼写检查和词典。有关 LibreOffice 的更多信息，请访问 libreoffice.org。

要安装 LibreOffice，请执行：

```
# pkg install libreoffice
```

LibreOffice 软件包仅默认提供英文版本。要获得针对本地区的 LibreOffice 版本，需要安装语言包。例如，安装西班牙语本地化版本，需要使用以下命令安装 editors/libreoffice-es 软件包：

```
# pkg install libreoffice-es
```

### 8.5.2. Calligra

KDE Plasma 桌面环境包含一个办公套件，可与 KDE Plasma 分开安装。Calligra 包含其他办公套件中常见的标准组件。Words 是文字处理程序，Sheets 是电子表格程序，Stage 用于管理幻灯片演示，Karbon 用于绘制图形文档.

安装 Calligra，请执行：

```
# pkg install calligra
```

### 8.5.3. AbiWord

AbiWord 是一款免费的文字处理程序，外观和感觉类似于 Microsoft® Word。它速度快，功能丰富，使用方便。

AbiWord 可以导入或导出许多文件格式，包括某些专有格式，如 Microsoft® .rtf。

要安装 AbiWord，请执行：

```
# pkg install abiword
```
