# 9.2.设置声卡


默认情况下，FreeBSD 将自动检测设备使用的声卡。FreeBSD 支持各种各样的声卡。可以在 sound(4)中查阅受支持的声卡列表。

|  | 只有在 FreeBSD 没有正确检测到声卡时才需要加载声卡模块。|
| -- | --------------------------------------------------------- |

如果不知道系统使用哪种声卡，或者要使用哪个模块，可以通过执行以下命令加载 snd_driver 元驱动程序。

```
# kldload snd_driver
```

或者可在启动时将驱动程序作为模块加载，将以下行放入/boot/loader.conf 中。

```
snd_driver_load="YES"
```

### 9.2.1. 测试声音

要确认是否检测到了声卡，可执行以下命令：

```
% dmesg | grep pcm
```

输出应该类似于以下内容：

```
pcm0: <Conexant CX20561 (Hermosa) (Analog 2.0+HP/2.0)> at nid 26,22 and 24 on hdaa0
pcm1: <Conexant CX20561 (Hermosa) (Internal Analog Mic)> at nid 29 on hdaa0
```

也可以使用此命令进行查看声卡的状态：

```
# cat /dev/sndstat
```

输出应类似于以下内容：

```
Installed devices:
pcm0: <Conexant CX20561 (Hermosa) (Analog 2.0+HP/2.0)> (play/rec) default
pcm1: <Conexant CX20561 (Hermosa) (Internal Analog Mic)> (rec)
```

如果未列出任何 pcm 设备，请再次检查是否加载了正确的设备驱动程序。如果一切顺利，声卡现在应该在 FreeBSD 中工作了。

beep(1) 可用于产生一些声音，以确认声卡工作与否：

```
% beep
```

### 9.2.2. 混音器

FreeBSD 有不同的实用程序可用于设置和显示内置在 FreeBSD 声音系统上的声卡混音器值：

支持的混音器软件包表 1

| 名称                  | 许可证  | 软件包               | 工具包 |
| ----------------------- | --------- | ------------------ | -------- |
| [ 混音器(8)](https://man.freebsd.org/cgi/man.cgi?query=mixer&sektion=8&format=html)                      | BSD-2   | 包含在基本系统中 | CLI    |
| dsbmixer              | BSD-2   | [ 音频/dsbmixer](https://cgit.freebsd.org/ports/tree/audio/dsbmixer/)                 | Qt     |
| KDE Plasma 音频小部件 | GPL 2.0 | [ 音频/等离子 5-等离子 PA](https://cgit.freebsd.org/ports/tree/audio/plasma5-plasma-pa/)                 | Qt     |
| mixertui              | BSD-2   | [ 音频/混音台用户界面](https://cgit.freebsd.org/ports/tree/audio/mixertui/)                 | TUI    |

### 9.2.3. 显卡音频

显卡通常配备自己集成的声音设备，可能不清楚哪个被用作默认设备。要确认，请运行 dmesg 并查看 pcm 条目来确定系统如何枚举输出。执行以下命令：

```
% dmesg | grep pcm
```

输出看起来像这样：

```
pcm0: <HDA NVIDIA (Unknown) PCM #0 DisplayPort> at cad 0 nid 1 on hdac0
pcm1: <HDA NVIDIA (Unknown) PCM #0 DisplayPort> at cad 1 nid 1 on hdac0
pcm2: <HDA NVIDIA (Unknown) PCM #0 DisplayPort> at cad 2 nid 1 on hdac0
pcm3: <HDA NVIDIA (Unknown) PCM #0 DisplayPort> at cad 3 nid 1 on hdac0
hdac1: HDA Codec #2: Realtek ALC889
pcm4: <HDA Realtek ALC889 PCM #0 Analog> at cad 2 nid 1 on hdac1
pcm5: <HDA Realtek ALC889 PCM #1 Analog> at cad 2 nid 1 on hdac1
pcm6: <HDA Realtek ALC889 PCM #2 Digital> at cad 2 nid 1 on hdac1
pcm7: <HDA Realtek ALC889 PCM #3 Digital> at cad 2 nid 1 on hdac1
```

显卡（NVIDIA®）在声卡（Realtek®）之前被枚举，声卡显示为 pcm4。系统可以通过执行以下命令将声卡配置为默认设备：

```
# sysctl hw.snd.default_unit=4
```

要使此更改永久生效，请将下一行添加到 /etc/sysctl.conf：

```
hw.snd.default_unit=4
```

### 9.2.4. 自动切换到耳机

某些设备可能在音频输出之间切换时遇到困难，但幸运的是，FreeBSD 能让在 device.hints 中配置自动切换。

通过执行以下命令来确定系统是如何枚举音频输出的：

```
% dmesg | grep pcm
```

输出看起来有点像这样：

```
pcm0: <Realtek ALC892 Analog> at nid 23 and 26 on hdaa0
pcm1: <Realtek ALC892 Right Analog Headphones> at nid 22 on hdaa0
```

将以下行添加到 /boot/device.hints：

```
hint.hdac.0.cad0.nid22.config="as=1 seq=15 device=Headphones"
hint.hdac.0.cad0.nid26.config="as=2 seq=0 device=speakers"
```

|  | 请记住，这些值是为上述示例而指定的。它们可能会因系统而异。|
| -- | ------------------------------------------------------------- |

### 9.2.5. 声音故障排除

某些常见的错误消息及其解决方案：

表 2. 常见错误消息

| 错误 | 解决方案                                                                                                         |
| ------ | ------------------------------------------------------------------------------------------------------------------ |
| `xxx: can’t open /dev/dsp!`     | 输入 fstat \| grep dsp 以检查是否有其他应用程序打开了设备。值得注意的麻烦制造者是 esound 和 KDE 的声音支持。|

使用音频 / pulseaudio 的程序可能需要重启音频 / pulseaudio 守护进程，以使修改生效。或者，可以在运行时更改音频 / pulseaudio 设置。pacmd(1) 打开到音频 / pulseaudio 守护进程的命令行连接：

```
# pacmd
Welcome to PulseAudio 14.2! Use "help" for usage information.
>>>
```

以下命令将默认的 sink 更改为卡号 4，如前面的示例所示：

```
set-default-sink 4
```

|  | 不要使用 exit 命令退出命令行界面。那会终止音频 / pulseaudio 守护进程。应该使用 Ctrl+D。|
| -- | --------------------------------------------------------------------------------------------- |
