# 9.5.视频会议


FreeBSD 桌面环境可用于加入视频会议。本节将解释如何配置网络摄像头以及 FreeBSD 支持哪些视频会议应用程序。

### 设置网络摄像头

为了能让 FreeBSD 访问网络摄像头并执行其配置，需要安装某些实用程序：

* multimedia/webcamd 是一个守护进程，可以启用数百种不同的基于 USB 的网络摄像头和 DVB USB 设备的使用。
* 多媒体/pwcview 是一个可以用来查看网络摄像头视频流的应用程序。

要安装所需的实用工具，请执行：

```
# pkg install webcamd pwcview
```

在 /etc/rc.conf 中启用 webcamd(8) 服务，以便在系统启动时启动它。

```
# sysrc webcamd_enable="YES"
```

The user must belong to the `webcamd` group. To add the user to `webcamd` group execute the following command:

```
# pw groupmod webcamd -m username
```

Since [multimedia/webcamd](https://cgit.freebsd.org/ports/tree/multimedia/webcamd/) needs the [cuse(3)](https://man.freebsd.org/cgi/man.cgi?query=cuse&sektion=3&format=html) module this module must be loaded by executing the following command:

```
# kldload cuse
```

To load [cuse(3)](https://man.freebsd.org/cgi/man.cgi?query=cuse&sektion=3&format=html) at system boot, execute the command:

```
# sysrc kld_list += "cuse"
```

若安装了实用程序，可以使用 webcamd(8)显示可用网络摄像头的列表：

```
# webcamd -l
```

输出应类似于以下内容：

```
webcamd [-d ugen0.2] -N SunplusIT-Inc-HP-TrueVision-HD-Camera -S unknown -M 0 
webcamd [-d ugen1.3] -N Realtek-802-11n-WLAN-Adapter -S 00e04c000001 -M 0
```

|  | 可用的网络摄像头 |
| -- | ------------------ |

配置可用的网络摄像头，执行以下命令：

```
# sysrc webcamd_0_flags="-d ugen0.2" 
```

|  | 请注意，如果这是即插即用的 USB 网络摄像头，更改连接的 USBport将更改 webcamd -l 的输出，rc.conf 中的条目可能需要更新。对于使用 USB 集成网络摄像头的笔记本电脑，这不应该是一个问题。|
| -- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |

必须通过执行以下命令启动 webcamd(8)服务：

```
# service webcamd start
```

输出应该类似于以下内容:

```
Starting webcamd.
webcamd 1616 - - Attached to ugen0.2[0]
```

可以使用 multimedia/pwcview 检查网络摄像头的正常工作。可以使用以下命令来执行 multimedia/pwcview:

```
% pwcview -f 30 -s vga
```

然后 multimedia/pwcview 将显示网络摄像头:

![pwcview showing Absolute FreeBSD 3rd edition as an example](https://docs.freebsd.org/images/books/handbook/multimedia/pwcview.png)

### 9.5.2。会议软件状态

FreeBSD 目前支持用于进行视频会议的以下工具。

表 5。会议软件

| 名字            | 火狐支持     | Chromium 支持 | Website |
| ----------------- | --------------- | -------- | --------- |
|Microsoft Teams|不支持|支持|[https://teams.live.com](https://teams.live.com/)|
|Google Meet|不支持|支持|[https://meet.google.com/](https://meet.google.com/)|
|Zoom|支持|支持|[https://zoom.us](https://zoom.us/)|
|Jitsi|不支持|支持|[https://meet.jit.si/](https://meet.jit.si/)|
|BigBlueButton|不支持|支持|[https://bigbluebutton.org/](https://bigbluebutton.org/)|
