# 9.6.图像扫描仪


在 FreeBSD 中，对图像扫描仪的访问是通过 SANE（Scanner Access Now Easy）提供的，它在 FreeBSD ports 中可用。

### 检查扫描仪

在尝试任何配置之前，重要的是检查扫描仪是否受 SANE 支持。

连接扫描仪后，运行以下命令以获取所有已连接的 USB 设备：

```
# usbconfig list
```

输出应该类似如下：

```
ugen4.2: <LITE-ON Technology USB NetVista Full Width Keyboard.> at usbus4, cfg=0 md=HOST spd=LOW (1.5Mbps) pwr=ON (70mA)
ugen4.3: <Logitech USB Optical Mouse> at usbus4, cfg=0 md=HOST spd=LOW (1.5Mbps) pwr=ON (100mA)
ugen3.2: <HP Deskjet 1050 J410 series> at usbus3, cfg=0 md=HOST spd=HIGH (480Mbps) pwr=ON (2mA)
```

运行以下命令以获得 idVendor 和 idProduct ：

```
# usbconfig -d 3.2 dump_device_desc
```

|  | 在这里注意，扫描仪是一种即插即用的设备，更改连接它的 USB port 将会更改从 usbconfig list 输出的内容。|
| -- | ------------------------------------------------------------------------------------------------------ |

输出应类似于以下内容：

```
ugen3.2: <HP Deskjet 1050 J410 series> at usbus3, cfg=0 md=HOST spd=HIGH (480Mbps) pwr=ON (2mA)

bLength = 0x0012
bDescriptorType = 0x0001
bcdUSB = 0x0200
bDeviceClass = 0x0000  <Probed by interface class>
bDeviceSubClass = 0x0000
bDeviceProtocol = 0x0000
bMaxPacketSize0 = 0x0040
idVendor = 0x03f0
idProduct = 0x8911
bcdDevice = 0x0100
iManufacturer = 0x0001  <HP>
iProduct = 0x0002  <Deskjet 1050 J410 series>
bNumConfigurations = 0x0001
```

若获得 idVendor 和 idProduct，有必要检查 SANE 支持设备列表，通过 idProduct 进行过滤以查看是否支持该扫描仪。

### 9.6.2. SANE 配置

SANE 通过后端提供对扫描仪的访问。为了能够在 FreeBSD 上进行扫描，必须通过运行以下命令安装 graphics/sane-backends 软件包：

```
# pkg install sane-backends
```

|  | 一些 USB 扫描仪需要加载固件。就像上面的示例中使用的 HP 扫描仪一样，它需要安装 print/hplip 软件包。|
| -- | ---------------------------------------------------------------------------------------------------- |

在安装必要的软件包之后，必须配置 devd(8) 以能让 FreeBSD 访问扫描仪。

将 saned.conf 文件添加到 /usr/local/etc/devd/saned.conf 中，内容如下：

```
notify 100 {
        match "system" "USB";
        match "subsystem" "INTERFACE";
        match "type" "ATTACH";
        match "cdev" "ugen[0-9].[0-9]";
        match "vendor" "0x03f0"; 
        match "product" "0x8911"; 
        action "chown -L cups:saned /dev/\$cdev && chmod -L 660 /dev/\$cdev";
};
```

|  | vendor ：是通过运行 usbconfig -d 3.2 dump_device_desc 命令之前获得的 idVendor。|
| -- | ----------------------------------------------------------------------------------- |
|  | product ：是通过运行 usbconfig -d 3.2 dump_device_desc 命令之前获得的 idProduct。|

之后，必须通过运行以下命令重启 devd(8)：

```
# service devd restart
```

SANE 后端包括 scanimage(1)，可以用来列出设备并执行图像采集。

使用 -L 参数执行 scanimage(1)以列出扫描仪设备：

```
# scanimage -L
```

输出应该类似于以下内容：

```
device `hpaio:/usb/Deskjet_1050_J410_series?serial=XXXXXXXXXXXXXX' is a Hewlett-Packard Deskjet_1050_J410_series all-in-one
```

如果 scanimage(1)无法识别扫描仪，将出现此消息：

```
No scanners were identified. If you were expecting something different,
check that the scanner is plugged in, turned on and detected by the
sane-find-scanner tool (if appropriate). Please read the documentation
which came with this software (README, FAQ, manpages).
```

若 scanimage(1)看到扫描仪，配置就完成了，扫描仪现在已经可以使用。

要激活服务并让其在引导时运行，请执行以下命令：

```
# sysrc saned_enable="YES"
```

虽然 scanimage（1）可用于在命令行中执行图像采集，但通常更好的选择是使用图形界面来执行图像扫描。

图形扫描程序表 6

| 名字           | 许可证  | 包            |
| ---------------- | --------- | --------------- |
|skanlite|GPL 2.0|graphics/skanlite|
|GNOME Simple Scan|GPL 3.0|graphics/simple-scan|
|XSANE|GPL 2.0|graphics/xsane|

