# D.1.官方成员

FreeBSD.org 官员的 OpenPGP 密钥显示在这里。这些密钥可用于验证签名或发送加密电子邮件给其中一位官员。FreeBSD OpenPGP 密钥的完整列表可在 PGP Keys 文章中找到。完整的密钥环可以在 pgpkeyring.txt 下载。

## D.1.1. 安全团队

```
pub   rsa4096/D9AD2A18057474CB 2022-12-11 [C] [expires: 2026-01-24]
      Key fingerprint = 0BE3 3275 D74C 953C 79F8  1107 D9AD 2A18 0574 74CB
uid                            FreeBSD Security Officer <security-officer@freebsd.org>
sub   rsa4096/6E58DE901F001AEF 2022-12-11 [S] [expires: 2025-01-15]
sub   rsa4096/46DB26D62F6039B7 2022-12-11 [E] [expires: 2025-01-15]
```

```
-----BEGIN PGP PUBLIC KEY BLOCK-----
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=QvUh
-----END PGP PUBLIC KEY BLOCK-----
```

### D.1.2. 核心团队秘书 <<a href="mailto:core-secretary@FreeBSD.org">core-secretary@FreeBSD.org</a>>

```
pub   rsa4096/4D632518C3546B05 2024-02-17 [SC] [expires: 2025-02-16]
      Key fingerprint = 1A23 6A92 528D 00DD 7965  76FE 4D63 2518 C354 6B05
uid                            FreeBSD Core Team Secretary <core-secretary@FreeBSD.org>
sub   rsa4096/CABFDE12CA516ED2 2024-02-17 [E] [expires: 2025-02-16]
```

```
-----BEGIN PGP PUBLIC KEY BLOCK-----

mQINBGXQ1o8BEAC+Rcg8cmVxuP17Vu+q5KgCx/XiulQuqKXAqqBlYCH2jqk6DINP
yFrREGBhzd/qNmlAYEahQ4Zgl0bUZNTrZVDyzicOvPP0jH+KSTQwRs7NOawEdlVO
cyHrwDCPEqf5ZzD4NhfTriEOw+j0pEH/onitUGvoQRtx15xWyaJQxDEBMTYMLewE
86D1bltwnTNczE3UZb7oQLJXkAX5hcLtou70XJGgZITvJkK+kp/xot2eFjnqRz/u
WeXnKhYAmC07EKwZ1uw047eHKwMMRBYqzApLwoQtfE430Kxf2q8de64x8zDbi6YM
1J4r8OAxOtHVyfJ0j7Q23DEZz0VVb4b1Tx5OG2Re/KSNvqI0awJO4TcRmOR88OyY
dzyXgnX6Sa7GVQY1FXvn7vtFuDAt7egZOzeomSHL9bdX07LTQ4UtM88EV9wm3q4q
smoatV9jsvPQ1zxCU3aQD/5eWTJH2/kz1LIuBL/Qi5XQpJn91lBtUWJrCgkHWPGu
f//rnnXmsG7DAChW+yZ7cFO8lfNa8sFhPqSxCYphWmJTrvadyQtDngB8JakWdnmK
pfGS6y5lel+181vw38ZZKt04AKM+nDY8051lBM7Q9Q6kTLI33UZeImndx5xYukVD
kV6aQ31HYfEark15c7iEz+OAcwFnM2ntXMt7kKGd40CqzusiPcQkPqPbAQARAQAB
tDhGcmVlQlNEIENvcmUgVGVhbSBTZWNyZXRhcnkgPGNvcmUtc2VjcmV0YXJ5QEZy
ZWVCU0Qub3JnPokCVwQTAQoAQRYhBBojapJSjQDdeWV2/k1jJRjDVGsFBQJl0NaP
AhsDBQkB4TOACAsJDQgMBwsDBRUKCQgLBRYDAgEAAh4FAheAAAoJEE1jJRjDVGsF
nacP/3PSg8JPmWoBfWrgT287NZ7OAU16/uGpDxlBUoVeEtkEDqZVW8yBFzrMhbwj
bJs3CZ+L85HMUDLZoxSwVnPM8PLVRzHTybYV7agYYzMox5C/jp2aeAgy9KYVd0Tk
07GMTYrSh4fhHWpxXz7IBOxk0RXvQxTHlg1u0DASkibYb2UTDcUNG5Q9kP/8jaIZ
kVDX8a5LDdOCgWaYdKPg4blv/UMjkegJz+Ayp7gXTcux6koW5F6ysSw9sgLBWb2D
b/KNIi4MBMe46xyXB/dqGAR4ibrUXTcQ4OAZNq1L6uWG1A49XuSgykdIwr00MzQw
wfVpKT31ww4ayVHLgj7NuqPlab9S5/fPfJ4MAvGE4GqWQFgsPKgKImUMgnnxTGpv
l7Dqk2MnWqn+wEi0bRES0PVBG96G+sZJQeaxBhoB+HwUSFqoZQg166AJIl//4t2w
bx0a1aWQSS0DZt3wsQW3NW9AE6L+FnFfIc2pQVoLjmvcGalDuvnemRmEOgotiZmt
32bi2aWxg0/Qio2rjLS2LpV+fhwDSN3Agvtnu53yUdD1TFFjTSMloM4SKhiXoPbI
XgfCLiBLNMsZL0AvO7wQfSePzPYxDLyEcwsfPJ8be+eGG1L62RUyad+MdfyXMH/S
m0sgqW/MW6Nv10RyPQOq3Jbgmp2laRMzKTOvQt5WwQf2FEl9uQINBGXQ1o8BEAC9
1cBYn6Z0QmM0OFWdXQI6fMOeNokaa6ngPgt7bzW5NjryqTdwyHOPZdm4DWf1SO/0
+fJRCqxbICyuMAFrb9fDle8bodALjm5ZquTL3D61HpZD4+RwOzOjYP6wLm7h38HT
/yIyK882Ovlw4Xz/TeSiL/VUSWE9twW7yz3oreCeLUBAfzacS9y+syO+aquEd0/x
JBz+mPQbrqfS64rCZXMZEivgsjkQoE6RM+n1rF4kw4Eu3E2kPevVwsoAaY+MEUM8
JAXaJMaNcLIhbeMy7dO/z6z2I3h5bUw5KxfVwzYSzSeRpYh53dNaB4NY+f5/vTrL
4dZmqBcLgcV0zZ02dj/u0SiwWlUFUpFGuSiW16DN7+2zG1zOWi7Nl44JawM62Tlf
mO8zruVGEHaV3e8fFwBLRKM0Sc7e3aLECISsfYeC5ZbRRbpQ1KX+VQr3FBKAMzG4
l9Go7vZ+UcLKpQx2rVPTJt1vDnRV49X6CF2Q/lV9iafQ4MTy6ACdAloT1yfH/lhU
iWQo1qDyRCSlmNBDsYl8gLrwMp4gGQAv3imZHxnJF5ru3nUYGG0U08D5mf2sWv5P
Wh7By8Jm8bmaP8cUF86lO9BJXh2d9QN5jqrAtXqYzenZ+ABSoL1XrD/yv3270rH7
H4gAUtgP+vJ3uMyRu9055OC+ie/b613NojCW5nYN2QARAQABiQI8BBgBCgAmFiEE
GiNqklKNAN15ZXb+TWMlGMNUawUFAmXQ1o8CGwwFCQHhM4AACgkQTWMlGMNUawXh
7w/+KjbEWTwAhjm2HJ3w4tXtPC5URg+A+BzYYVH/q0+956c1QeD0LYafHBw4LEMI
lhRvHQnmzwjtY8v/DgmLOVDMiMWVHo0Q2iQyMvOT1WyEPcgOTJLhvyVzDqRZx7AS
B4G8uNVkKAdBZ7OSXAP27lR/2SEoG05esw8b7Y39pVtucC3aeiua+19PLJWadBjj
XuvXuSCho0km+nk4IgadYmxIDyiMeyKZ8wCl7CJkzECm83q2OtNsMe3k8lgEXybt
KlQxnYApZmhqLMV5ob8WOk3AgAVsif1m332CiEIb1Sfx6wt3nXy/410CXdDDucuj
ndJVfJ6Un33tn0irZ5scPA2HmzK1PGMfgOGtkM8B3LE/x8kEKeWKb3l9boB32Unm
iTfKgEna+JISEab3bzOPWdCQFB8LyGXuWlhtvqmRoX8GtiMRy/F4mzh+l3lYHjj3
4EvPVyippO5zwU+S9HElJ2G37K6zrOmd5cGBrw4aBDoO70QVrMN4O86uvC9kChDb
qyFF5UgXg29QxJjiSCv98ksDMqpJ5AFYrmrsBtwU64OANrxxJ4AZLQ1apYmG9RWD
VHZgfeI60FNBLfKwix9UffFT7piQ/MLrjSde8gPH5S6ezBMrYpfGEopaI9A5qXe3
LnHz88gfdmaBM77YDZM/p23nmCrUxlE3kkbgjTY8NRjYyF8=
=MkAH
-----END PGP PUBLIC KEY BLOCK-----
```

### D.1.3. Ports 管理团队秘书 <<a href="mailto:portmgr-secretary@FreeBSD.org">portmgr-secretary@FreeBSD.org</a>>

```
pub   ed25519/E3C401F60D709D59 2023-03-06 [SC] [expires: 2027-03-05]
      Key fingerprint = BED4 A1D3 6555 B681 2E9F  ABDA E3C4 01F6 0D70 9D59
uid                            FreeBSD Ports Management Team Secretary <portmgr-secretary@FreeBSD.org>
sub   cv25519/2C92B55E27A641C3 2023-03-06 [E] [expires: 2027-03-05]
```

```
-----BEGIN PGP PUBLIC KEY BLOCK-----

mDMEZAXJvxYJKwYBBAHaRw8BAQdASFAC20WL3R1T6uNyGMZbfJCxDkcP4C5vi3Op
tcZ2fbq0R0ZyZWVCU0QgUG9ydHMgTWFuYWdlbWVudCBUZWFtIFNlY3JldGFyeSA8
cG9ydG1nci1zZWNyZXRhcnlARnJlZUJTRC5vcmc+iJYEExYKAD4WIQS+1KHTZVW2
gS6fq9rjxAH2DXCdWQUCZAXJvwIbAwUJB4TOAAULCQgHAwUVCgkICwUWAwIBAAIe
BQIXgAAKCRDjxAH2DXCdWYN1AP43TjyfZtZ3DLYT++g0+SuPsoO/3yWVybA+UmFL
zb8MngEA+LLNUfvEwCuXS/soh+ww5bpfmi3UUmeGiQEAXug3iA+JATMEEAEKAB0W
IQT7N0XIbxXo7ayBMvzYKU7Du8TX1QUCZAXLkwAKCRDYKU7Du8TX1XHMB/9R1MX4
6zMgpKqPPt76GOI+eGEdBK6bY8aJZjQGdqTh9f6VtXVoTGIG7cvhc9X8tDBoB0PT
2KZWheF51AV1+NHU4HwLAQ1BMebrFvWSfkw4xg4fBGwDhz9/GN85No+Js772V5ey
8lRiL6meRVWxMlLyWcxGd8JjcC5yX/iAUQ3SBGCLqW7unWjjg7CTd+AMBwcqPGrv
ax8q6eFVguJcHJAjMnKf6HAy4cpK3s+uMoUBCGnszSN12B3ysKfyC4pNO/pix5tA
Q5v8aRqTeFPh5zmNhWo0KGPzplTPqRQSHDl7GDQC8Ru3MhzFkeWzHsexjZVwS6W2
DPcYpuuAsA0XOZIZiQIzBBABCgAdFiEEEBpxaxYrAOVb7eoFrbv4YQo3ibcFAmQF
0u0ACgkQrbv4YQo3ibccwg/9F2Xuic3nhKxRbB3mJeDo6SYQETa/Gh1qQ34+8zlt
8UMazOx67gnYQfy+pXjro6eQ2up0a4eUYezcNOudqAQD21nRz3HA6EQVNcE/TzEA
xl5CJntTaLOt7S+EDXFW5BuQIvhhoMGgm8+WNVgA0EJ7tfL0OcYBSvr19fqwChEn
9c14cSk6mgHSsleP5NvskYN053pxHwy0LTSb8YBBv52th37t/CRFC1363rS5q+D7
JixFopd1O5pKpA5ipvE4gGgRjPtwjx0SjjepwK/3fuhEJQQyKzTIKlMfu2Dj/iR2
Li1Sfccau5LQXOj9fUITU3u1YG7yrm8VGzT7ao4d+KRwgMLjd2pLqiGIbbJwGBiP
FRmtilWQoeIlmSlFX4obAA517DOK0pW1mH8+eEn4EJd3SekT3yzFyKTASv0J48Z8
3F928xg+eZvHxVC0t1J+J5IG0gt3EEncuWKIPQGR7PiQbti6R3FQVTz6WfMWOebP
Qi0E9F/Aqakr6Vj2sKGrDq+ebpaF5G8Yw1YrUl2IDiPzkCegp3ZbI0wh11Xvzhi8
LXPQGK4jBQas4G8cegfitzmtdGRHYrbMv0R9I4mvaL+WlOuD2AvyVG28lguqVhnN
AZP+ohdquYyX2CNCVvbKWAtXo6Ur0vWG8BL8m6defAtEkIwVBALaOHQOSI3aNUz4
lwy4OARkBcm/EgorBgEEAZdVAQUBAQdAsefmSfxEOdOr02+K/6noYCuJ1FeAWVz6
jFYQ+9w6jggDAQgHiH4EGBYKACYWIQS+1KHTZVW2gS6fq9rjxAH2DXCdWQUCZAXJ
vwIbDAUJB4TOAAAKCRDjxAH2DXCdWRl4AP9h5ot212BK29S6ZcMBhHvmtF5PG1oD
c7LnZycSRmbFiwEAndCMpAGOhDW8iVgDd0wLQq/ZMPe+xccfG1b3zFH2EgE=
=iiAT
-----END PGP PUBLIC KEY BLOCK-----
```

### D.1.4. `doceng-secretary@FreeBSD.org`

```
pub   rsa2048/E1C03580AEB45E58 2019-10-31 [SC] [expires: 2022-10-30]
      Key fingerprint = F24D 7B32 B864 625E 5541  A0E4 E1C0 3580 AEB4 5E58
uid                            FreeBSD Doceng Team Secretary <doceng-secretary@freebsd.org>
sub   rsa2048/9EA8D713509472FC 2019-10-31 [E] [expires: 2022-10-30]
```

```
-----BEGIN PGP PUBLIC KEY BLOCK-----

mQENBF27FFcBCADeoSsIgyQUY8vREwkTikwFFlNg31MVy5s/Nq1cNK1PRfRMnprS
yfB62KqbYuz16bmQKaA9zHN4FGfiTvR6tl66LVHm1s/5HPiLv8sP14GsruLro9zN
v72dO7a9i68bMw+jarPOnu9dGiDFEI0dACOkdCGEYKEUapQeNpmWRrQ46BeXyFwF
JcNx76bJJUkwk6fWC0W63D762e6lCEX6ndoaPjjLBnFvtx13heNGUc8RukBwe2mA
U5pSGHj47J05bdWiRSwZaXa8PcW+20zTWaP755w7zWe4h60GANY7OsT9nuOqsioJ
QonxTrJuZweKRV8fNQ1EfDws3HZr7/7iXvO3ABEBAAG0PEZyZWVCU0QgRG9jZW5n
IFRlYW0gU2VjcmV0YXJ5IDxkb2Nlbmctc2VjcmV0YXJ5QGZyZWVic2Qub3JnPokB
VAQTAQoAPhYhBPJNezK4ZGJeVUGg5OHANYCutF5YBQJduxRXAhsDBQkFo5qABQsJ
CAcDBRUKCQgLBRYDAgEAAh4BAheAAAoJEOHANYCutF5YB2IIALw+EPYmOz9qlqIn
oTFmk/5MrcdzC5iLEfxubbF6TopDWsWPiOh5mAuvfEmROSGf6ctvdYe9UtQV3VNY
KeeyskeFrIBOFo2KG/dFqKPAWef6IfhbW3HWDWo5uOBg01jHzQ/pB1n6SMKiXfsM
idL9wN+UQKxF3Y7S/bVrZTV0isRUolO9+8kQeSYT/NMojVM0H2fWrTP/TaNEW4fY
JBDAl5hsktzdl8sdbNqdC0GiX3xb4GvgVzGGQELagsxjfuXk6PfOyn6Wx2d+yRcI
FrKojmhihBp5VGFQkntBIXQkaW0xhW+WBGxwXdaAl0drQlZ3W+edgdOl705x73kf
Uw3Fh2a5AQ0EXbsUVwEIANEPAsltM4vFj2pi5xEuHEcZIrIX/ZJhoaBtZkqvkB+H
4pu3/eQHK5hg0Dw12ugffPMz8mi57iGNI9TXd8ZYMJxAdvEZSDHCKZTX9G+FcxWa
/AzKNiG25uSISzz7rMB/lV1gofCdGtpHFRFTiNxFcoacugTdlYDiscgJZMJSg/hC
GXBdEKXR5WRAgAGandcL8llCToOt1lZEOkd5vJM861w6evgDhAZ2HGhRuG8/NDxG
r4UtlnYGUCFof/Q4oPNbDJzmZXF+8OQyTNcEpVD3leEOWG1Uv5XWS2XKVHcHZZ++
ISo/B5Q6Oi3SJFCVV9f+g09YF+PgfP/mVMBgif2fT20AEQEAAYkBPAQYAQoAJhYh
BPJNezK4ZGJeVUGg5OHANYCutF5YBQJduxRXAhsMBQkFo5qAAAoJEOHANYCutF5Y
kecIAMTh2VHQqjXHTszQMsy3NjiTVVITI3z+pzY0u2EYmLytXQ2pZMzLHMcklmub
5po0X4EvL6bZiJcLMI2mSrOs0Gp8P3hyMI40IkqoLMp7VA2LFlPgIJ7K5W4oVwf8
khY6lw7qg2l69APm/MM3xAyiL4p6MU8tpvWg5AncZ6lxyy27rxVflzEtCrKQuG/a
oVaOlMjH3uxvOK6IIxlhvWD0nKs/e2h2HIAZ+ILE6ytS5ZEg2GXuigoQZdEnv71L
xyvE9JANwGZLkDxnS5pgN2ikfkQYlFpJEkrNTQleCOHIIIp8vgJngEaP51xOIbQM
CiG/y3cmKQ/ZfH7BBvlZVtZKQsI=
=MQKT
-----END PGP PUBLIC KEY BLOCK-----
```
