# 术语表


此术语表包含在 FreeBSD 社区和文档中使用的术语和缩写。

## A

`ACL`

 查看访问控制列表。

`ACPI`

查看高级配置和电源接口。

`AMD`

查看自动挂载守护程序。

`AML`

查看 ACPI 机器语言。

`API`

查看应用程序编程接口。

`APIC`

查看高级可编程中断控制器。

`APM`

查看高级电源管理。

`APOP`

查看认证邮局协议。

`ASL`

查看 ACPI 源语言。

`ATA`

查看高级技术附件。

`ATM`

查看异步传输模式。

`ACPI Machine Language`

由 ACPI 兼容的操作系统内的虚拟机解释的伪代码，提供底层硬件和向操作系统呈现的文档化接口之间的一层。

`ACPI Source Language`

编写的编程语言 AML。

`Access Control List`

附加到对象（通常为文件或网络设备）的权限列表。

`Advanced Configuration and Power Interface`

一个规范，它提供了操作系统与硬件接口的抽象，使操作系统在最大程度利用硬件的同时，无需了解底层硬件的具体情况。ACPI 发展并取代了以前由 APM、PNPBIOS 和其他技术提供的功能，提供了控制功耗、系统暂停、设备启用和禁用等功能。

`Application Programming Interface`

一组过程、协议和工具，规定了一个或多个程序部分的标准互动方式；它们如何、何时以及为什么协同工作，以及它们共享或操作的数据。

`Advanced Power Management`

一个 API，使操作系统能够与 BIOS 协同工作，以实现电源管理。对于大多数应用程序来说，APM 已被更通用且功能更强大的 ACPI 规范所取代。

`Advanced Programmable Interrupt Controller`

高级技术附件

`Asynchronous Transfer Mode`

认证后的邮局协议

`Automatic Mount Daemon`

当文件系统中的文件或目录被访问时自动挂载文件系统的守护程序

## B

`BAR`

查看基址寄存器。

`BIND`

查看伯克利互联网名称域。

`BIOS`

查看基本输入输出系统。

`BSD`

查看伯克利软件套装。

`Base Address Register`

确定 PCI 设备响应的地址范围的寄存器。

`Basic Input/Output System`

BIOS 的定义在不同的上下文中有所不同。一些人将其称为带有基本例程的 ROM 芯片，用于提供软件与硬件之间的接口。其他人可能将其称为存储在芯片中的一组例程，帮助引导系统启动。有些人还可能将其称为用于配置引导过程的屏幕。BIOS 是针对 PC 的，但其他系统也有类似的东西。

`Berkeley Internet Name Domain`

DNS 协议的实现。

`Berkeley Software Distribution`

这是加利福尼亚大学伯克利分校的计算机系统研究组（CSRG）对他们对 AT&T 的 32V UNIX® 进行的改进和修改所给出的名称。FreeBSD 是 CSRG 工作的后代。

`Bikeshed Building`

一种现象，即许多人会对一个简单的话题发表意见，而一个复杂的话题却很少或没有讨论。请参阅常见问题解答以了解术语的起源。

## C

`CD`

 参见载波检测。

`CHAP`

查看挑战握手认证协议。

`CLIP`

查看经典的 ATM 上的 IP。

`COFF`

查看常见对象文件格式。

`CPU`

查看中央处理器。

`CTS`

 查看清空发送。

`Carrier Detect`

RS232C 信号，指示检测到载波。

`Central Processing Unit`

也被称为处理器。这是计算机的大脑，所有的计算都在这里进行。有多种不同的架构，具有不同的指令集。其中比较知名的有 Intel-x86 及其衍生产品、Arm 和 PowerPC。

`Challenge Handshake Authentication Protocol`

一种基于客户端和服务器之间共享的秘钥进行用户认证的方法。

`Classical IP over ATM`

`Clear To Send`

一种 RS232C 信号，表示远程系统有权限发送数据。

请参见请求发送。

`Common Object File Format`

## D

`DAC`

请参见自主访问控制。

`DDB`

 请参见调试器。

`DES`

请参见数据加密标准。

`DHCP`

请参见动态主机配置协议。

`DNS`

 查看域名系统。

`DSDT`

查看差异化系统描述表。

`DSR`

 查看数据集准备。

`DTR`

 查看数据终端就绪。

`DVMRP`

查看距离矢量组播路由协议。

`Discretionary Access Control`

`Data Encryption Standard`

一种加密信息的方法，传统上用作 UNIX®密码的加密方法和 crypt(3)函数的加密方法。

`Data Set Ready`

从调制解调器发送到计算机或终端的 RS232C 信号，表示准备好发送和接收数据。

另请参阅数据终端就绪。

D`ata Terminal Ready`

计算机或终端向调制解调器发送的 RS232C 信号，表示准备好发送和接收数据。

`Debugger`

一种交互式的内核工具，用于检查系统状态，通常在系统崩溃后使用，以确定失败事件的详细情况。

`Differentiated System Description Table`

ACPI 表，提供关于基本系统配置信息的基本信息。

`Distance-Vector Multicast Routing Protocol`

`Domain Name System`

将人类可读的主机名（即 mail.example.net）转换为互联网地址及反之的系统。

`Dynamic Host Configuration Protocol`

当计算机（主机）从服务器请求 IP 地址时动态分配 IP 地址的协议。地址分配称为“租约”。

## E

`ECOFF`

 查看扩展 COFF。

`ELF`

查看可执行和链接格式。

`ESP`

查看封装安全载荷。

`Encapsulated Security Payload`

`Executable and Linking Format`

`Extended COFF`

## F

`FADT`

查看固定 ACPI 描述表。

`FAT`

查看文件分配表。

`FAT16`

查看文件分配表（16 位）。

`FTP`

查看文件传输协议。

`File Allocation Table`

`File Allocation Table (16-bit)`

`File Transfer Protocol`

TCP/IP 网络上传输文件时可用的高级协议族中的一员。

`Fixed ACPI Description Table`

## G

`GUI`

查看图形用户界面。

`Giant`

一个相互排斥机制的名称（一个睡眠 mutex ），用于保护大量内核资源。尽管在机器可能仅有几十个进程、一个网络卡，当然只有一个处理器的时代，简单的锁定机制是足够的，在当前时代，这是无法接受的性能瓶颈。FreeBSD 开发人员正在积极努力将其替换为保护各个资源的锁，这将能让单处理器和多处理器机器的更高程度的并行性。

`Graphical User Interface`

一个用户与计算机通过图形交互的系统。

## H

`HTML`

参见超文本标记语言。

`HUP`

 看挂机。

`HangUp`

超文本标记语言

用于创建网页的标记语言。

## 我

`I/O`

 看见输入/输出。

`IASL`

查看英特尔的 ASL 编译器。

`IMAP`

查看互联网消息访问协议。

`IP`

 查看互联网协议。

`IPFW`

 查看 IP 防火墙。

`IPP`

参见 Internet 打印协议。

`IPv4`

 参见 IP 版本 4。

`IPv6`

 参见 IP 版本 6。

`ISP`

查看互联网服务提供商。

`IP Firewall`

`IP Version 4`

IP 协议版本 4，使用 32 位地址。这个版本仍然是最广泛使用的，但正逐渐被 IPv6 取代。

另请参阅 IP 版本 6。

`IP Version 6`

新的 IP 协议。因为 IPv4 的地址空间即将耗尽而发明。使用 128 位地址。

`Input/Output`

`Intel’s ASL compiler`

Intel 的编译器，用于将 ASL 转换为 AML。

`Internet Message Access Protocol`

一种用于访问邮件服务器上电子邮件的协议，其特点是邮件通常保存在服务器上，而不是下载到邮件阅读客户端。

查看邮政协议版本 3。

`Internet Printing Protocol`

`Internet Protocol`

这是互联网上的基本协议，用于传输数据包。最初由美国国防部开发，是 TCP/IP 协议栈的重要组成部分。没有互联网协议，互联网就不可能成为今天的样子。更多信息，请参阅 RFC 791。

`Internet Service Provider`

一家提供互联网接入的公司。

## K

`KAME`

日本译为“乌龟”，在计算机界中用于指代 KAME 项目，他们致力于 IPv6 的实现。

`KDC`

参见密钥分发中心。

`KLD`

 查看内核 ld(1)。

`KSE`

查看内核调度程序实体。

`KVA`

查看内核虚拟地址。

`Kbps`

见每秒千比特。

`Kernel`​[ld(1)](https://man.freebsd.org/cgi/man.cgi?query=ld&sektion=1&format=html)

一种在不重启系统的情况下将功能动态加载到 FreeBSD 内核的方法。

`Kernel Scheduler Entities`

内核支持的线程系统。有关详细信息，请参阅项目主页。

`Kernel Virtual Address`

`Key Distribution Center`

`Kilo Bits Per Second`

用于测量带宽（数据在指定时间内通过给定点的量）。与千（Kilo）前缀的替代包括兆（Mega）、吉（Giga）、太（Tera）等。

## L

`LAN`

 查看本地区域网络。

`LOR`

 查看锁定顺序颠倒。

`LPD`

 查看行式打印机守护进程。

`Line Printer Daemon`

`Local Area Network`

局域网是指在办公室、家庭等本地区域使用的网络。

`Lock Order Reversal`

FreeBSD 内核使用多个资源锁来调节对这些资源的竞争。在 FreeBSD-CURRENT 内核中存在一个运行时锁诊断系统（在发布版中已移除），称为 witness(4)，用于检测由于锁定错误而导致死锁的潜在问题。（witness(4)实际上稍微保守，因此可能会产生误报。）真实的正报告表示，“如果你运气不好，死锁可能会在这里发生”。

真实的正报告的锁定竞争条件（LOR）通常会被快速修复，请在发布到邮件列表之前检查 https://lists.FreeBSD.org/subscription/freebsd-current 和已看到的 LOR 页面。

## M

`MAC`

查看强制访问控制。

`MADT`

查看多个 APIC 描述表。

`MFC`

 看到从当前合并。

`MFH`

 看到从头合并。

MFS

 从稳定版合并查看。

MFV

 从供应商合并查看。

 麻省理工学院

参见麻省理工学院。

MLS

查看多级安全。

MOTD

查看今日消息。

MTA

 看看邮件传输代理。

MUA

 请参阅邮件用户代理。

 邮件传输代理

用于传输电子邮件的应用程序。MTA 传统上是 BSD 基本系统的一部分。今天 Sendmail 包含在基本系统中，但还有许多其他 MTA，如 postfix、qmail 和 Exim。

 邮件用户代理

用户用于显示和编写电子邮件的应用程序

强制访问控制

麻省理工学院

 合并自当前

将功能或补丁从当前分支合并到另一个分支，通常是稳定分支。

 从头合并

将功能或补丁从存储库的 HEAD 合并到较早的分支。

 从稳定版合并

在 FreeBSD 开发的正常过程中，更改将首先提交到-CURRENT 分支进行测试，然后才合并到-STABLE。在罕见情况下，更改会先进入-STABLE，然后再合并到-CURRENT。

当从-STABLE 合并到安全分支时，也使用这个术语。

参见也合并自当前。

 从供应商合并

今日消息

通常在登录时显示的一条消息，常用于向系统用户分发信息。

 多级安全

多个 APIC 描述表

## N

 网络地址转换

见网络地址转换。

NDISulator

 查看“邪恶项目”。

NFS

 查看网络文件系统。

NTFS

新技术文件系统查看。

NTP

查看网络时间协议。

网络地址转换

一种技术，在网关通过时重新编写 IP 数据包，使得网关后面的许多计算机能够有效地共享一个单一的 IP 地址。

 网络文件系统

新技术文件系统

由微软开发的文件系统，适用于其“新技术”操作系统，如 Windows® 2000、Windows NT®和 Windows® XP。

 网络时间协议

一种通过网络同步时钟的方式。

## O

 被超越了的事件

 看到超越了的事件。

ODMR

查看按需邮件中继。

 操作系统

 查看操作系统。

 按需邮件中继

 操作系统

一组程序、库和工具，用于访问计算机的硬件资源。当今的操作系统范围从仅支持一次运行一个程序，仅访问一个设备的简单设计，到完全支持多用户、多任务和多进程的系统，可以同时为成千上万的用户提供服务，每个用户运行几十个不同的应用程序。

 事件超越了

指出建议的更改（如问题报告或功能请求），由于 FreeBSD 的后续更改、网络标准的更改、受影响的硬件已经过时等原因，这些更改已不再相关或适用。

## P

 物理地址扩展

参见物理地址扩展。

PAM

查看可插拔认证模块。

PAP

查看密码认证协议。

 个人电脑

 查看个人电脑。

PCNSFD

查看个人计算机网络文件系统守护程序。

PDF

查看便携式文档格式。

 进程标识符

 查看进程标识符

POLA

参见最小惊讶原则。

POP

参见邮局协议。

POP3

看到第三版的邮局协议。

PPD

查看后置脚本打印机说明。

PPP

查看点对点协议。

PPPoA

 查看 PPP over ATM.

PPPoE

 通过以太网上的 PPP 查看。

 ATM 上的 PPP。

 以太网上的 PPP。

PR

See [Problem Report](https://docs.freebsd.org/en/books/handbook/glossary/#pr-glossary).

PXE

查看预启动执行环境。

密码认证协议

 个人电脑

个人计算机网络文件系统守护程序

物理地址扩展

一种能让在仅具有 32 位宽地址空间的系统上访问高达 64 GB RAM 的方法（否则会受到 4 GB 限制）

可插拔身份验证模块

 点对点协议

 尖帽

一个神话般的头饰，很像一个傻瓜帽，授予任何破坏构建、使修订号倒退或在源代码库中制造任何其他混乱的 FreeBSD 贡献者。任何值得其盐的贡献者很快就会积累大量这样的头饰。使用方式（几乎总是？）是幽默的。

可移植文档格式

 邮局协议

查看也可以通过使用电子邮件协议版本 3。

电子邮件协议版本 3

一种用于访问电子邮件服务器上电子邮件消息的协议，其特点是消息通常从服务器下载到客户端，而不是保留在服务器上。

查看 Internet 消息访问协议。

PostScript 打印机说明

预引导执行环境

最小惊讶原则

随着 FreeBSD 的发展，用户可见的变化应尽量保持不令人惊讶。例如，在/etc/defaults/rc.conf 中随意重新排列系统启动变量违反了最小惊讶原则。开发者在考虑用户可见的系统变更时会考虑到最小惊讶原则。

 问题报告

已经在 FreeBSD 源代码或文档中发现的某种问题说明。请参阅撰写 FreeBSD 问题报告。

 进程 ID

一个数字，对于系统上的特定进程是唯一的，它标识进程并能让采取针对它的行动。

 邪恶项目

NDISulator 的工作标题，由 Bill Paul 编写，他命名它是因为需要在首次需要像这样恶劣（从哲学角度看）的东西。NDISulator 是一个特殊的兼容性模块，能让使用 Microsoft Windows™ NDIS miniport 网络驱动程序与 FreeBSD/i386 一起使用。这通常是使用驱动程序为闭源的卡的唯一方式。见 src/sys/compat/ndis/subr_ndis.c。

## R

 路由器

查看路由器广告。

RAID

参见廉价冗余磁盘阵列。

 内存

参见随机存取存储器。

RD

 查看接收到的数据。

RFC

查看请求评论。

RISC

查看精简指令集计算机。

RPC

参见远程过程调用。

RS232C

查看推荐标准 232C。

RTS

 查看请求发送。

 随机存取内存

 修订控制系统

修订控制系统（RCS）是实现普通文件“修订控制”的最古老软件套件之一。它能让对每个文件的多个修订版本进行存储、检索、归档、记录、标识和合并。RCS 由许多小工具组成，这些工具共同工作。它缺少一些现代修订控制系统（如 Git）中的一些特性，但对于安装、配置和开始使用一小组文件来说非常简单。

 参见 Subversion。

 接收到的数据

用于接收数据的 RS232C 引脚或线。

查看也传输的数据。

推荐标准 232C

串行设备间通信的标准。

简化指令集计算机

一种处理器设计方法，其中硬件可以执行的操作被简化，但尽可能通用。这可以降低功耗、减少晶体管数量，并在某些情况下提升性能和增加代码密度。RISC 处理器的例子包括 Alpha、SPARC®、ARM®和 PowerPC®。

廉价磁盘冗余阵列

 远程过程调用

 请求评议

定义互联网标准、协议等的一组文件。请参阅 www.rfc-editor.org。

当某人提出改变建议并希望得到反馈时，也作为一般术语使用。

 请求发送

RS232C 信号，请求远程系统开始传输数据。

请参阅清除发送。

 路由器通告

## S

SCI

系统控制中断查看

SCSI

参见小型计算机系统接口。

SG

 参见信号地。

SMB

查看服务器消息块。

SMP

查看对称多处理器。

SMTP

查看简单邮件传输协议。

SMTP AUTH

 查看 SMTP 身份验证。

SSH

 看安全Shell。

STR

 看挂起到 RAM。

SVN

 查看 Subversion。

 SMTP 身份验证

 服务器消息块

 信号地

RS232 引脚或线是信号的地参考。

简单邮件传输协议

 安全 Shell

小型计算机系统接口

 子版本

Subversion 是当前由 FreeBSD 项目使用的版本控制系统。

 暂停到 RAM

对称多处理器

系统控制中断

## T

TCP

见传输控制协议。

TCP/IP

查看传输控制协议/因特网协议。

TD

 查看传输数据。

TFTP

 简单文件传输协议

TGT

查看凭据授予票证。

TSC

 查看时间戳计数器。

 凭据

 时间戳计数器

现代奔腾®处理器内部的性能分析计数器，用于计算核心频率时钟周期。

传输控制协议

坐在（例如）IP 协议顶部，并保证数据包以可靠、有序的方式传输的协议。

传输控制协议/互联网协议

运行在 IP 协议之上的 TCP 协议的组合术语。大部分互联网运行在 TCP/IP 上。

 传输数据

数据传输的 RS232C 引脚或电线。

 查看已收到的数据。

 定制 FTP

## U 盘

UDP

见用户数据报协议。

UFS1

查看 Unix 文件系统版本 1。

UFS2

查看 Unix 文件系统版本 2。

 用户 ID

 查看用户 ID。

 网址

查看统一资源定位符。

 通用串行总线

查看通用串行总线。

统一资源定位符

一种定位资源的方法，例如互联网上的文档，以及识别该资源的手段。

Unix 文件系统版本 1

原始的 UNIX®文件系统，有时称为伯克利快速文件系统。

Unix 文件系统第 2 版

UFS1 的扩展，引入于 FreeBSD 5-CURRENT。UFS2 添加了 64 位块指针（突破了 1T 的限制），支持扩展文件存储和其他功能。

 通用串行总线

一种硬件标准，用于将各种计算机外围设备连接到通用接口。

 用户标识

每位计算机用户分配的唯一编号，用于识别分配给该用户的资源和权限。

 用户数据包协议

一种简单、不可靠的数据包协议，用于在 TCP/IP 网络上交换数据。UDP 不像 TCP 那样提供错误检查和校正。

## V

VPN

请参阅虚拟专用网络。

 虚拟专用网络

利用公共电信设施（如互联网）提供远程访问局域网（如企业局域网）的一种方法。
