package me.ykrank.s1next.view.adapter;

import android.content.Context;
import androidx.annotation.LayoutRes;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

import java.util.List;

import me.ykrank.s1next.data.api.model.collection.Posts;

public final class ThreadAttachmentInfoListArrayAdapter
        extends ArrayAdapter<Posts.ThreadAttachment.Info> {

    @LayoutRes
    private final int mResource;

    public ThreadAttachmentInfoListArrayAdapter(Context context, @LayoutRes int resource, List<Posts.ThreadAttachment.Info> objects) {
        super(context, resource, objects);

        this.mResource = resource;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder;
        if (convertView == null) {
            convertView = LayoutInflater.from(getContext()).inflate(mResource, parent, false);

            viewHolder = new ViewHolder();
            viewHolder.labelView = (TextView) convertView.findViewById(android.R.id.text1);
            viewHolder.valueView = (TextView) convertView.findViewById(android.R.id.text2);
            convertView.setTag(viewHolder);
        } else {
            viewHolder = (ViewHolder) convertView.getTag();
        }

        Posts.ThreadAttachment.Info info = getItem(position);

        viewHolder.labelView.setText(info.getLabel());
        viewHolder.valueView.setText(info.getValue());

        return convertView;
    }

    @Override
    public boolean hasStableIds() {
        return true;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }


    private static final class ViewHolder {

        private TextView labelView;
        private TextView valueView;
    }
}
