from __future__ import annotations
from win32more import ARCH, Annotated, Boolean, Byte, Bytes, Char, ComPtr, ConstantLazyLoader, Double, Enum, FAILED, FlexibleArray, Guid, Int16, Int32, Int64, IntPtr, NativeBitfieldAttribute, POINTER, SByte, SUCCEEDED, Single, String, Structure, UInt16, UInt32, UInt64, UIntPtr, UnicodeAlias, Union, Void, VoidPtr, cfunctype, cfunctype_pointer, commethod, make_ready, winfunctype, winfunctype_pointer
from win32more._winrt import AwaitableProtocol, ContextManagerProtocol, FillArray, Generic, IInspectable, IUnknown, IterableProtocol, K, MappingProtocol, MulticastDelegate, PassArray, ReceiveArray, SequenceProtocol, T, TProgress, TResult, TSender, Tuple, V, WinRT_String, event, winrt_activatemethod, winrt_classmethod, winrt_commethod, winrt_factorymethod, winrt_mixinmethod, winrt_overload
import win32more.Microsoft.Graphics.Canvas
import win32more.Microsoft.Graphics.Canvas.Brushes
import win32more.Windows.Foundation
import win32more.Windows.Foundation.Numerics
import win32more.Windows.UI
class CanvasGradientStop(Structure):
    Position: Single
    Color: win32more.Windows.UI.Color
class CanvasGradientStopHdr(Structure):
    Position: Single
    Color: win32more.Windows.Foundation.Numerics.Vector4
class CanvasImageBrush(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasImageBrush
    _classid_ = 'Microsoft.Graphics.Canvas.Brushes.CanvasImageBrush'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Brushes.CanvasImageBrush.Create(*args))
        elif len(args) == 2:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Brushes.CanvasImageBrush.CreateWithImage(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def Create(cls: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasImageBrushFactory, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasImageBrush: ...
    @winrt_factorymethod
    def CreateWithImage(cls: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasImageBrushFactory, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasImageBrush: ...
    @winrt_mixinmethod
    def get_Image(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasImageBrush) -> win32more.Microsoft.Graphics.Canvas.ICanvasImage: ...
    @winrt_mixinmethod
    def put_Image(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasImageBrush, value: win32more.Microsoft.Graphics.Canvas.ICanvasImage) -> Void: ...
    @winrt_mixinmethod
    def get_ExtendX(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasImageBrush) -> win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior: ...
    @winrt_mixinmethod
    def put_ExtendX(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasImageBrush, value: win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior) -> Void: ...
    @winrt_mixinmethod
    def get_ExtendY(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasImageBrush) -> win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior: ...
    @winrt_mixinmethod
    def put_ExtendY(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasImageBrush, value: win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior) -> Void: ...
    @winrt_mixinmethod
    def get_SourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasImageBrush) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def put_SourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasImageBrush, value: win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.Rect]) -> Void: ...
    @winrt_mixinmethod
    def get_Interpolation(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasImageBrush) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_mixinmethod
    def put_Interpolation(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasImageBrush, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_mixinmethod
    def get_Opacity(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Single: ...
    @winrt_mixinmethod
    def put_Opacity(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Transform(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> win32more.Windows.Foundation.Numerics.Matrix3x2: ...
    @winrt_mixinmethod
    def put_Transform(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, value: win32more.Windows.Foundation.Numerics.Matrix3x2) -> Void: ...
    @winrt_mixinmethod
    def get_Device(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    Device = property(get_Device, None)
    ExtendX = property(get_ExtendX, put_ExtendX)
    ExtendY = property(get_ExtendY, put_ExtendY)
    Image = property(get_Image, put_Image)
    Interpolation = property(get_Interpolation, put_Interpolation)
    Opacity = property(get_Opacity, put_Opacity)
    SourceRectangle = property(get_SourceRectangle, put_SourceRectangle)
    Transform = property(get_Transform, put_Transform)
class CanvasLinearGradientBrush(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasLinearGradientBrush
    _classid_ = 'Microsoft.Graphics.Canvas.Brushes.CanvasLinearGradientBrush'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 2:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Brushes.CanvasLinearGradientBrush.CreateWithStops(*args))
        elif len(args) == 3:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Brushes.CanvasLinearGradientBrush.CreateSimple(*args))
        elif len(args) == 4:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Brushes.CanvasLinearGradientBrush.CreateWithEdgeBehaviorAndAlphaMode(*args))
        elif len(args) == 7:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Brushes.CanvasLinearGradientBrush.CreateWithEdgeBehaviorAndInterpolationOptions(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def CreateWithStops(cls: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasLinearGradientBrushFactory, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, gradientStops: PassArray[win32more.Microsoft.Graphics.Canvas.Brushes.CanvasGradientStop]) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasLinearGradientBrush: ...
    @winrt_factorymethod
    def CreateSimple(cls: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasLinearGradientBrushFactory, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, startColor: win32more.Windows.UI.Color, endColor: win32more.Windows.UI.Color) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasLinearGradientBrush: ...
    @winrt_factorymethod
    def CreateWithEdgeBehaviorAndAlphaMode(cls: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasLinearGradientBrushFactory, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, gradientStops: PassArray[win32more.Microsoft.Graphics.Canvas.Brushes.CanvasGradientStop], edgeBehavior: win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior, alphaMode: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasLinearGradientBrush: ...
    @winrt_factorymethod
    def CreateWithEdgeBehaviorAndInterpolationOptions(cls: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasLinearGradientBrushFactory, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, gradientStops: PassArray[win32more.Microsoft.Graphics.Canvas.Brushes.CanvasGradientStop], edgeBehavior: win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior, alphaMode: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode, preInterpolationSpace: win32more.Microsoft.Graphics.Canvas.CanvasColorSpace, postInterpolationSpace: win32more.Microsoft.Graphics.Canvas.CanvasColorSpace, bufferPrecision: win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasLinearGradientBrush: ...
    @winrt_mixinmethod
    def get_StartPoint(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasLinearGradientBrush) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_mixinmethod
    def put_StartPoint(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasLinearGradientBrush, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_mixinmethod
    def get_EndPoint(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasLinearGradientBrush) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_mixinmethod
    def put_EndPoint(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasLinearGradientBrush, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_mixinmethod
    def get_Stops(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasLinearGradientBrush) -> ReceiveArray[win32more.Microsoft.Graphics.Canvas.Brushes.CanvasGradientStop]: ...
    @winrt_mixinmethod
    def get_StopsHdr(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasLinearGradientBrush) -> ReceiveArray[win32more.Microsoft.Graphics.Canvas.Brushes.CanvasGradientStopHdr]: ...
    @winrt_mixinmethod
    def get_EdgeBehavior(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasLinearGradientBrush) -> win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior: ...
    @winrt_mixinmethod
    def get_PreInterpolationSpace(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasLinearGradientBrush) -> win32more.Microsoft.Graphics.Canvas.CanvasColorSpace: ...
    @winrt_mixinmethod
    def get_PostInterpolationSpace(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasLinearGradientBrush) -> win32more.Microsoft.Graphics.Canvas.CanvasColorSpace: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasLinearGradientBrush) -> win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision: ...
    @winrt_mixinmethod
    def get_AlphaMode(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasLinearGradientBrush) -> win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode: ...
    @winrt_mixinmethod
    def get_Opacity(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Single: ...
    @winrt_mixinmethod
    def put_Opacity(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Transform(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> win32more.Windows.Foundation.Numerics.Matrix3x2: ...
    @winrt_mixinmethod
    def put_Transform(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, value: win32more.Windows.Foundation.Numerics.Matrix3x2) -> Void: ...
    @winrt_mixinmethod
    def get_Device(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    @winrt_classmethod
    def CreateHdrSimple(cls: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasLinearGradientBrushStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, startColorHdr: win32more.Windows.Foundation.Numerics.Vector4, endColorHdr: win32more.Windows.Foundation.Numerics.Vector4) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasLinearGradientBrush: ...
    @winrt_classmethod
    def CreateHdrWithStops(cls: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasLinearGradientBrushStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, gradientStopsHdr: PassArray[win32more.Microsoft.Graphics.Canvas.Brushes.CanvasGradientStopHdr]) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasLinearGradientBrush: ...
    @winrt_classmethod
    def CreateHdrWithEdgeBehaviorAndAlphaMode(cls: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasLinearGradientBrushStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, gradientStopsHdr: PassArray[win32more.Microsoft.Graphics.Canvas.Brushes.CanvasGradientStopHdr], edgeBehavior: win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior, alphaMode: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasLinearGradientBrush: ...
    @winrt_classmethod
    def CreateHdrWithEdgeBehaviorAndInterpolationOptions(cls: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasLinearGradientBrushStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, gradientStopsHdr: PassArray[win32more.Microsoft.Graphics.Canvas.Brushes.CanvasGradientStopHdr], edgeBehavior: win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior, alphaMode: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode, preInterpolationSpace: win32more.Microsoft.Graphics.Canvas.CanvasColorSpace, postInterpolationSpace: win32more.Microsoft.Graphics.Canvas.CanvasColorSpace, bufferPrecision: win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasLinearGradientBrush: ...
    @winrt_classmethod
    def CreateRainbow(cls: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasLinearGradientBrushStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, eldritchness: Single) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasLinearGradientBrush: ...
    AlphaMode = property(get_AlphaMode, None)
    BufferPrecision = property(get_BufferPrecision, None)
    Device = property(get_Device, None)
    EdgeBehavior = property(get_EdgeBehavior, None)
    EndPoint = property(get_EndPoint, put_EndPoint)
    Opacity = property(get_Opacity, put_Opacity)
    PostInterpolationSpace = property(get_PostInterpolationSpace, None)
    PreInterpolationSpace = property(get_PreInterpolationSpace, None)
    StartPoint = property(get_StartPoint, put_StartPoint)
    Stops = property(get_Stops, None)
    StopsHdr = property(get_StopsHdr, None)
    Transform = property(get_Transform, put_Transform)
class CanvasRadialGradientBrush(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasRadialGradientBrush
    _classid_ = 'Microsoft.Graphics.Canvas.Brushes.CanvasRadialGradientBrush'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 2:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Brushes.CanvasRadialGradientBrush.CreateWithStops(*args))
        elif len(args) == 3:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Brushes.CanvasRadialGradientBrush.CreateSimple(*args))
        elif len(args) == 4:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Brushes.CanvasRadialGradientBrush.CreateWithEdgeBehaviorAndAlphaMode(*args))
        elif len(args) == 7:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Brushes.CanvasRadialGradientBrush.CreateWithEdgeBehaviorAndInterpolationOptions(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def CreateWithStops(cls: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasRadialGradientBrushFactory, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, gradientStops: PassArray[win32more.Microsoft.Graphics.Canvas.Brushes.CanvasGradientStop]) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasRadialGradientBrush: ...
    @winrt_factorymethod
    def CreateSimple(cls: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasRadialGradientBrushFactory, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, startColor: win32more.Windows.UI.Color, endColor: win32more.Windows.UI.Color) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasRadialGradientBrush: ...
    @winrt_factorymethod
    def CreateWithEdgeBehaviorAndAlphaMode(cls: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasRadialGradientBrushFactory, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, gradientStops: PassArray[win32more.Microsoft.Graphics.Canvas.Brushes.CanvasGradientStop], edgeBehavior: win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior, alphaMode: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasRadialGradientBrush: ...
    @winrt_factorymethod
    def CreateWithEdgeBehaviorAndInterpolationOptions(cls: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasRadialGradientBrushFactory, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, gradientStops: PassArray[win32more.Microsoft.Graphics.Canvas.Brushes.CanvasGradientStop], edgeBehavior: win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior, alphaMode: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode, preInterpolationSpace: win32more.Microsoft.Graphics.Canvas.CanvasColorSpace, postInterpolationSpace: win32more.Microsoft.Graphics.Canvas.CanvasColorSpace, bufferPrecision: win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasRadialGradientBrush: ...
    @winrt_mixinmethod
    def get_Center(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasRadialGradientBrush) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_mixinmethod
    def put_Center(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasRadialGradientBrush, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_mixinmethod
    def get_OriginOffset(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasRadialGradientBrush) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_mixinmethod
    def put_OriginOffset(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasRadialGradientBrush, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_mixinmethod
    def get_RadiusX(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasRadialGradientBrush) -> Single: ...
    @winrt_mixinmethod
    def put_RadiusX(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasRadialGradientBrush, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_RadiusY(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasRadialGradientBrush) -> Single: ...
    @winrt_mixinmethod
    def put_RadiusY(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasRadialGradientBrush, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Stops(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasRadialGradientBrush) -> ReceiveArray[win32more.Microsoft.Graphics.Canvas.Brushes.CanvasGradientStop]: ...
    @winrt_mixinmethod
    def get_StopsHdr(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasRadialGradientBrush) -> ReceiveArray[win32more.Microsoft.Graphics.Canvas.Brushes.CanvasGradientStopHdr]: ...
    @winrt_mixinmethod
    def get_EdgeBehavior(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasRadialGradientBrush) -> win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior: ...
    @winrt_mixinmethod
    def get_PreInterpolationSpace(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasRadialGradientBrush) -> win32more.Microsoft.Graphics.Canvas.CanvasColorSpace: ...
    @winrt_mixinmethod
    def get_PostInterpolationSpace(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasRadialGradientBrush) -> win32more.Microsoft.Graphics.Canvas.CanvasColorSpace: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasRadialGradientBrush) -> win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision: ...
    @winrt_mixinmethod
    def get_AlphaMode(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasRadialGradientBrush) -> win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode: ...
    @winrt_mixinmethod
    def get_Opacity(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Single: ...
    @winrt_mixinmethod
    def put_Opacity(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Transform(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> win32more.Windows.Foundation.Numerics.Matrix3x2: ...
    @winrt_mixinmethod
    def put_Transform(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, value: win32more.Windows.Foundation.Numerics.Matrix3x2) -> Void: ...
    @winrt_mixinmethod
    def get_Device(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    @winrt_classmethod
    def CreateHdrSimple(cls: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasRadialGradientBrushStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, startColorHdr: win32more.Windows.Foundation.Numerics.Vector4, endColorHdr: win32more.Windows.Foundation.Numerics.Vector4) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasRadialGradientBrush: ...
    @winrt_classmethod
    def CreateHdrWithStops(cls: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasRadialGradientBrushStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, gradientStops: PassArray[win32more.Microsoft.Graphics.Canvas.Brushes.CanvasGradientStopHdr]) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasRadialGradientBrush: ...
    @winrt_classmethod
    def CreateHdrWithEdgeBehaviorAndAlphaMode(cls: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasRadialGradientBrushStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, gradientStops: PassArray[win32more.Microsoft.Graphics.Canvas.Brushes.CanvasGradientStopHdr], edgeBehavior: win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior, alphaMode: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasRadialGradientBrush: ...
    @winrt_classmethod
    def CreateHdrWithEdgeBehaviorAndInterpolationOptions(cls: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasRadialGradientBrushStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, gradientStops: PassArray[win32more.Microsoft.Graphics.Canvas.Brushes.CanvasGradientStopHdr], edgeBehavior: win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior, alphaMode: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode, preInterpolationSpace: win32more.Microsoft.Graphics.Canvas.CanvasColorSpace, postInterpolationSpace: win32more.Microsoft.Graphics.Canvas.CanvasColorSpace, bufferPrecision: win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasRadialGradientBrush: ...
    @winrt_classmethod
    def CreateRainbow(cls: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasRadialGradientBrushStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, eldritchness: Single) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasRadialGradientBrush: ...
    AlphaMode = property(get_AlphaMode, None)
    BufferPrecision = property(get_BufferPrecision, None)
    Center = property(get_Center, put_Center)
    Device = property(get_Device, None)
    EdgeBehavior = property(get_EdgeBehavior, None)
    Opacity = property(get_Opacity, put_Opacity)
    OriginOffset = property(get_OriginOffset, put_OriginOffset)
    PostInterpolationSpace = property(get_PostInterpolationSpace, None)
    PreInterpolationSpace = property(get_PreInterpolationSpace, None)
    RadiusX = property(get_RadiusX, put_RadiusX)
    RadiusY = property(get_RadiusY, put_RadiusY)
    Stops = property(get_Stops, None)
    StopsHdr = property(get_StopsHdr, None)
    Transform = property(get_Transform, put_Transform)
class CanvasSolidColorBrush(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasSolidColorBrush
    _classid_ = 'Microsoft.Graphics.Canvas.Brushes.CanvasSolidColorBrush'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 2:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Brushes.CanvasSolidColorBrush.Create(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def Create(cls: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasSolidColorBrushFactory, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, color: win32more.Windows.UI.Color) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasSolidColorBrush: ...
    @winrt_mixinmethod
    def get_Color(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasSolidColorBrush) -> win32more.Windows.UI.Color: ...
    @winrt_mixinmethod
    def put_Color(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasSolidColorBrush, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def get_ColorHdr(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasSolidColorBrush) -> win32more.Windows.Foundation.Numerics.Vector4: ...
    @winrt_mixinmethod
    def put_ColorHdr(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasSolidColorBrush, value: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_mixinmethod
    def get_Opacity(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Single: ...
    @winrt_mixinmethod
    def put_Opacity(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Transform(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> win32more.Windows.Foundation.Numerics.Matrix3x2: ...
    @winrt_mixinmethod
    def put_Transform(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, value: win32more.Windows.Foundation.Numerics.Matrix3x2) -> Void: ...
    @winrt_mixinmethod
    def get_Device(self: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    @winrt_classmethod
    def CreateHdr(cls: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasSolidColorBrushStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, colorHdr: win32more.Windows.Foundation.Numerics.Vector4) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasSolidColorBrush: ...
    Color = property(get_Color, put_Color)
    ColorHdr = property(get_ColorHdr, put_ColorHdr)
    Device = property(get_Device, None)
    Opacity = property(get_Opacity, put_Opacity)
    Transform = property(get_Transform, put_Transform)
class ICanvasBrush(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Brushes.ICanvasBrush'
    _iid_ = Guid('{f5d58591-c803-41b4-878e-79d92ab13295}')
    @winrt_commethod(6)
    def get_Opacity(self) -> Single: ...
    @winrt_commethod(7)
    def put_Opacity(self, value: Single) -> Void: ...
    @winrt_commethod(8)
    def get_Transform(self) -> win32more.Windows.Foundation.Numerics.Matrix3x2: ...
    @winrt_commethod(9)
    def put_Transform(self, value: win32more.Windows.Foundation.Numerics.Matrix3x2) -> Void: ...
    @winrt_commethod(10)
    def get_Device(self) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    Device = property(get_Device, None)
    Opacity = property(get_Opacity, put_Opacity)
    Transform = property(get_Transform, put_Transform)
class ICanvasImageBrush(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Brushes.ICanvasImageBrush'
    _iid_ = Guid('{5a21c4e7-d450-4942-8bbd-f017097ab763}')
    @winrt_commethod(6)
    def get_Image(self) -> win32more.Microsoft.Graphics.Canvas.ICanvasImage: ...
    @winrt_commethod(7)
    def put_Image(self, value: win32more.Microsoft.Graphics.Canvas.ICanvasImage) -> Void: ...
    @winrt_commethod(8)
    def get_ExtendX(self) -> win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior: ...
    @winrt_commethod(9)
    def put_ExtendX(self, value: win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior) -> Void: ...
    @winrt_commethod(10)
    def get_ExtendY(self) -> win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior: ...
    @winrt_commethod(11)
    def put_ExtendY(self, value: win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior) -> Void: ...
    @winrt_commethod(12)
    def get_SourceRectangle(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.Rect]: ...
    @winrt_commethod(13)
    def put_SourceRectangle(self, value: win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.Rect]) -> Void: ...
    @winrt_commethod(14)
    def get_Interpolation(self) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_commethod(15)
    def put_Interpolation(self, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    ExtendX = property(get_ExtendX, put_ExtendX)
    ExtendY = property(get_ExtendY, put_ExtendY)
    Image = property(get_Image, put_Image)
    Interpolation = property(get_Interpolation, put_Interpolation)
    SourceRectangle = property(get_SourceRectangle, put_SourceRectangle)
class ICanvasImageBrushFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.Brushes.ICanvasImageBrushFactory'
    _iid_ = Guid('{c40ccb59-1b87-4394-a6a6-ecd278e877d6}')
    @winrt_commethod(6)
    def Create(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasImageBrush: ...
    @winrt_commethod(7)
    def CreateWithImage(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasImageBrush: ...
class ICanvasLinearGradientBrush(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Brushes.ICanvasLinearGradientBrush'
    _iid_ = Guid('{a4ffbcb1-ec22-48c8-b1af-09bcfd34eebd}')
    @winrt_commethod(6)
    def get_StartPoint(self) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_commethod(7)
    def put_StartPoint(self, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_commethod(8)
    def get_EndPoint(self) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_commethod(9)
    def put_EndPoint(self, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_commethod(10)
    def get_Stops(self) -> ReceiveArray[win32more.Microsoft.Graphics.Canvas.Brushes.CanvasGradientStop]: ...
    @winrt_commethod(11)
    def get_StopsHdr(self) -> ReceiveArray[win32more.Microsoft.Graphics.Canvas.Brushes.CanvasGradientStopHdr]: ...
    @winrt_commethod(12)
    def get_EdgeBehavior(self) -> win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior: ...
    @winrt_commethod(13)
    def get_PreInterpolationSpace(self) -> win32more.Microsoft.Graphics.Canvas.CanvasColorSpace: ...
    @winrt_commethod(14)
    def get_PostInterpolationSpace(self) -> win32more.Microsoft.Graphics.Canvas.CanvasColorSpace: ...
    @winrt_commethod(15)
    def get_BufferPrecision(self) -> win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision: ...
    @winrt_commethod(16)
    def get_AlphaMode(self) -> win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode: ...
    AlphaMode = property(get_AlphaMode, None)
    BufferPrecision = property(get_BufferPrecision, None)
    EdgeBehavior = property(get_EdgeBehavior, None)
    EndPoint = property(get_EndPoint, put_EndPoint)
    PostInterpolationSpace = property(get_PostInterpolationSpace, None)
    PreInterpolationSpace = property(get_PreInterpolationSpace, None)
    StartPoint = property(get_StartPoint, put_StartPoint)
    Stops = property(get_Stops, None)
    StopsHdr = property(get_StopsHdr, None)
class ICanvasLinearGradientBrushFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.Brushes.ICanvasLinearGradientBrushFactory'
    _iid_ = Guid('{a2e8e34a-8592-4b9d-ba1c-00d3f3c34f54}')
    @winrt_commethod(6)
    def CreateSimple(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, startColor: win32more.Windows.UI.Color, endColor: win32more.Windows.UI.Color) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasLinearGradientBrush: ...
    @winrt_commethod(7)
    def CreateWithStops(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, gradientStops: PassArray[win32more.Microsoft.Graphics.Canvas.Brushes.CanvasGradientStop]) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasLinearGradientBrush: ...
    @winrt_commethod(8)
    def CreateWithEdgeBehaviorAndAlphaMode(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, gradientStops: PassArray[win32more.Microsoft.Graphics.Canvas.Brushes.CanvasGradientStop], edgeBehavior: win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior, alphaMode: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasLinearGradientBrush: ...
    @winrt_commethod(9)
    def CreateWithEdgeBehaviorAndInterpolationOptions(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, gradientStops: PassArray[win32more.Microsoft.Graphics.Canvas.Brushes.CanvasGradientStop], edgeBehavior: win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior, alphaMode: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode, preInterpolationSpace: win32more.Microsoft.Graphics.Canvas.CanvasColorSpace, postInterpolationSpace: win32more.Microsoft.Graphics.Canvas.CanvasColorSpace, bufferPrecision: win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasLinearGradientBrush: ...
class ICanvasLinearGradientBrushStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.Brushes.ICanvasLinearGradientBrushStatics'
    _iid_ = Guid('{e9de3392-8fbf-478c-8e6a-d0a0ea753b37}')
    @winrt_commethod(6)
    def CreateHdrSimple(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, startColorHdr: win32more.Windows.Foundation.Numerics.Vector4, endColorHdr: win32more.Windows.Foundation.Numerics.Vector4) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasLinearGradientBrush: ...
    @winrt_commethod(7)
    def CreateHdrWithStops(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, gradientStopsHdr: PassArray[win32more.Microsoft.Graphics.Canvas.Brushes.CanvasGradientStopHdr]) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasLinearGradientBrush: ...
    @winrt_commethod(8)
    def CreateHdrWithEdgeBehaviorAndAlphaMode(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, gradientStopsHdr: PassArray[win32more.Microsoft.Graphics.Canvas.Brushes.CanvasGradientStopHdr], edgeBehavior: win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior, alphaMode: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasLinearGradientBrush: ...
    @winrt_commethod(9)
    def CreateHdrWithEdgeBehaviorAndInterpolationOptions(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, gradientStopsHdr: PassArray[win32more.Microsoft.Graphics.Canvas.Brushes.CanvasGradientStopHdr], edgeBehavior: win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior, alphaMode: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode, preInterpolationSpace: win32more.Microsoft.Graphics.Canvas.CanvasColorSpace, postInterpolationSpace: win32more.Microsoft.Graphics.Canvas.CanvasColorSpace, bufferPrecision: win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasLinearGradientBrush: ...
    @winrt_commethod(10)
    def CreateRainbow(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, eldritchness: Single) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasLinearGradientBrush: ...
class ICanvasRadialGradientBrush(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Brushes.ICanvasRadialGradientBrush'
    _iid_ = Guid('{4d27d756-14a9-4eb7-973f-e6614d4f89e7}')
    @winrt_commethod(6)
    def get_Center(self) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_commethod(7)
    def put_Center(self, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_commethod(8)
    def get_OriginOffset(self) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_commethod(9)
    def put_OriginOffset(self, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_commethod(10)
    def get_RadiusX(self) -> Single: ...
    @winrt_commethod(11)
    def put_RadiusX(self, value: Single) -> Void: ...
    @winrt_commethod(12)
    def get_RadiusY(self) -> Single: ...
    @winrt_commethod(13)
    def put_RadiusY(self, value: Single) -> Void: ...
    @winrt_commethod(14)
    def get_Stops(self) -> ReceiveArray[win32more.Microsoft.Graphics.Canvas.Brushes.CanvasGradientStop]: ...
    @winrt_commethod(15)
    def get_StopsHdr(self) -> ReceiveArray[win32more.Microsoft.Graphics.Canvas.Brushes.CanvasGradientStopHdr]: ...
    @winrt_commethod(16)
    def get_EdgeBehavior(self) -> win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior: ...
    @winrt_commethod(17)
    def get_PreInterpolationSpace(self) -> win32more.Microsoft.Graphics.Canvas.CanvasColorSpace: ...
    @winrt_commethod(18)
    def get_PostInterpolationSpace(self) -> win32more.Microsoft.Graphics.Canvas.CanvasColorSpace: ...
    @winrt_commethod(19)
    def get_BufferPrecision(self) -> win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision: ...
    @winrt_commethod(20)
    def get_AlphaMode(self) -> win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode: ...
    AlphaMode = property(get_AlphaMode, None)
    BufferPrecision = property(get_BufferPrecision, None)
    Center = property(get_Center, put_Center)
    EdgeBehavior = property(get_EdgeBehavior, None)
    OriginOffset = property(get_OriginOffset, put_OriginOffset)
    PostInterpolationSpace = property(get_PostInterpolationSpace, None)
    PreInterpolationSpace = property(get_PreInterpolationSpace, None)
    RadiusX = property(get_RadiusX, put_RadiusX)
    RadiusY = property(get_RadiusY, put_RadiusY)
    Stops = property(get_Stops, None)
    StopsHdr = property(get_StopsHdr, None)
class ICanvasRadialGradientBrushFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.Brushes.ICanvasRadialGradientBrushFactory'
    _iid_ = Guid('{7933a51f-a910-4548-849f-42ddec466f41}')
    @winrt_commethod(6)
    def CreateSimple(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, startColor: win32more.Windows.UI.Color, endColor: win32more.Windows.UI.Color) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasRadialGradientBrush: ...
    @winrt_commethod(7)
    def CreateWithStops(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, gradientStops: PassArray[win32more.Microsoft.Graphics.Canvas.Brushes.CanvasGradientStop]) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasRadialGradientBrush: ...
    @winrt_commethod(8)
    def CreateWithEdgeBehaviorAndAlphaMode(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, gradientStops: PassArray[win32more.Microsoft.Graphics.Canvas.Brushes.CanvasGradientStop], edgeBehavior: win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior, alphaMode: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasRadialGradientBrush: ...
    @winrt_commethod(9)
    def CreateWithEdgeBehaviorAndInterpolationOptions(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, gradientStops: PassArray[win32more.Microsoft.Graphics.Canvas.Brushes.CanvasGradientStop], edgeBehavior: win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior, alphaMode: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode, preInterpolationSpace: win32more.Microsoft.Graphics.Canvas.CanvasColorSpace, postInterpolationSpace: win32more.Microsoft.Graphics.Canvas.CanvasColorSpace, bufferPrecision: win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasRadialGradientBrush: ...
class ICanvasRadialGradientBrushStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.Brushes.ICanvasRadialGradientBrushStatics'
    _iid_ = Guid('{3b0d4dae-3e21-4818-99b4-779acaaf18be}')
    @winrt_commethod(6)
    def CreateHdrSimple(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, startColorHdr: win32more.Windows.Foundation.Numerics.Vector4, endColorHdr: win32more.Windows.Foundation.Numerics.Vector4) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasRadialGradientBrush: ...
    @winrt_commethod(7)
    def CreateHdrWithStops(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, gradientStops: PassArray[win32more.Microsoft.Graphics.Canvas.Brushes.CanvasGradientStopHdr]) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasRadialGradientBrush: ...
    @winrt_commethod(8)
    def CreateHdrWithEdgeBehaviorAndAlphaMode(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, gradientStops: PassArray[win32more.Microsoft.Graphics.Canvas.Brushes.CanvasGradientStopHdr], edgeBehavior: win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior, alphaMode: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasRadialGradientBrush: ...
    @winrt_commethod(9)
    def CreateHdrWithEdgeBehaviorAndInterpolationOptions(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, gradientStops: PassArray[win32more.Microsoft.Graphics.Canvas.Brushes.CanvasGradientStopHdr], edgeBehavior: win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior, alphaMode: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode, preInterpolationSpace: win32more.Microsoft.Graphics.Canvas.CanvasColorSpace, postInterpolationSpace: win32more.Microsoft.Graphics.Canvas.CanvasColorSpace, bufferPrecision: win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasRadialGradientBrush: ...
    @winrt_commethod(10)
    def CreateRainbow(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, eldritchness: Single) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasRadialGradientBrush: ...
class ICanvasSolidColorBrush(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Brushes.ICanvasSolidColorBrush'
    _iid_ = Guid('{8bc30f87-bad5-4871-88b8-9fe3c63d204a}')
    @winrt_commethod(6)
    def get_Color(self) -> win32more.Windows.UI.Color: ...
    @winrt_commethod(7)
    def put_Color(self, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(8)
    def get_ColorHdr(self) -> win32more.Windows.Foundation.Numerics.Vector4: ...
    @winrt_commethod(9)
    def put_ColorHdr(self, value: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    Color = property(get_Color, put_Color)
    ColorHdr = property(get_ColorHdr, put_ColorHdr)
class ICanvasSolidColorBrushFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.Brushes.ICanvasSolidColorBrushFactory'
    _iid_ = Guid('{8abf4780-4edd-4f2b-bf63-2c385115b201}')
    @winrt_commethod(6)
    def Create(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, color: win32more.Windows.UI.Color) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasSolidColorBrush: ...
class ICanvasSolidColorBrushStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.Brushes.ICanvasSolidColorBrushStatics'
    _iid_ = Guid('{629b7244-5b9e-4ef8-8e09-264714201ee8}')
    @winrt_commethod(6)
    def CreateHdr(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, colorHdr: win32more.Windows.Foundation.Numerics.Vector4) -> win32more.Microsoft.Graphics.Canvas.Brushes.CanvasSolidColorBrush: ...


make_ready(__name__)
