from __future__ import annotations
from win32more import ARCH, Annotated, Boolean, Byte, Bytes, Char, ComPtr, ConstantLazyLoader, Double, Enum, FAILED, FlexibleArray, Guid, Int16, Int32, Int64, IntPtr, NativeBitfieldAttribute, POINTER, SByte, SUCCEEDED, Single, String, Structure, UInt16, UInt32, UInt64, UIntPtr, UnicodeAlias, Union, Void, VoidPtr, cfunctype, cfunctype_pointer, commethod, make_ready, winfunctype, winfunctype_pointer
from win32more._winrt import AwaitableProtocol, ContextManagerProtocol, FillArray, Generic, IInspectable, IUnknown, IterableProtocol, K, MappingProtocol, MulticastDelegate, PassArray, ReceiveArray, SequenceProtocol, T, TProgress, TResult, TSender, Tuple, V, WinRT_String, event, winrt_activatemethod, winrt_classmethod, winrt_commethod, winrt_factorymethod, winrt_mixinmethod, winrt_overload
import win32more.Microsoft.Graphics.Canvas
import win32more.Microsoft.Graphics.Canvas.Geometry
import win32more.Microsoft.Graphics.Canvas.Text
import win32more.Windows.Foundation
import win32more.Windows.Foundation.Numerics
import win32more.Windows.Graphics
class CanvasArcSize(Enum, Int32):
    Small = 0
    Large = 1
class CanvasCachedGeometry(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasCachedGeometry
    _classid_ = 'Microsoft.Graphics.Canvas.Geometry.CanvasCachedGeometry'
    @winrt_mixinmethod
    def get_Device(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasCachedGeometry) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    @winrt_classmethod
    def CreateFill(cls: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasCachedGeometryStatics, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCachedGeometry: ...
    @winrt_classmethod
    def CreateFillWithFlatteningTolerance(cls: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasCachedGeometryStatics, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, flatteningTolerance: Single) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCachedGeometry: ...
    @winrt_classmethod
    def CreateStroke(cls: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasCachedGeometryStatics, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, strokeWidth: Single) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCachedGeometry: ...
    @winrt_classmethod
    def CreateStrokeWithStrokeStyle(cls: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasCachedGeometryStatics, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCachedGeometry: ...
    @winrt_classmethod
    def CreateStrokeWithStrokeStyleAndFlatteningTolerance(cls: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasCachedGeometryStatics, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle, flatteningTolerance: Single) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCachedGeometry: ...
    Device = property(get_Device, None)
class CanvasCapStyle(Enum, Int32):
    Flat = 0
    Square = 1
    Round = 2
    Triangle = 3
class CanvasDashStyle(Enum, Int32):
    Solid = 0
    Dash = 1
    Dot = 2
    DashDot = 3
    DashDotDot = 4
class CanvasFigureFill(Enum, Int32):
    Default = 0
    DoesNotAffectFills = 1
class CanvasFigureLoop(Enum, Int32):
    Open = 0
    Closed = 1
class CanvasFigureSegmentOptions(Enum, UInt32):
    None_ = 0
    ForceUnstroked = 1
    ForceRoundLineJoin = 2
class CanvasFilledRegionDetermination(Enum, Int32):
    Alternate = 0
    Winding = 1
class _CanvasGeometry_Meta_(ComPtr.__class__):
    pass
class CanvasGeometry(ComPtr, metaclass=_CanvasGeometry_Meta_):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry
    _classid_ = 'Microsoft.Graphics.Canvas.Geometry.CanvasGeometry'
    @winrt_mixinmethod
    def CombineWith(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry, otherGeometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, otherGeometryTransform: win32more.Windows.Foundation.Numerics.Matrix3x2, combine: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometryCombine) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_mixinmethod
    def CombineWithUsingFlatteningTolerance(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry, otherGeometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, otherGeometryTransform: win32more.Windows.Foundation.Numerics.Matrix3x2, combine: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometryCombine, flatteningTolerance: Single) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_mixinmethod
    def Stroke(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry, strokeWidth: Single) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_mixinmethod
    def StrokeWithStrokeStyle(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_mixinmethod
    def StrokeWithAllOptions(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle, transform: win32more.Windows.Foundation.Numerics.Matrix3x2, flatteningTolerance: Single) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_mixinmethod
    def Outline(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_mixinmethod
    def OutlineWithTransformAndFlatteningTolerance(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry, transform: win32more.Windows.Foundation.Numerics.Matrix3x2, flatteningTolerance: Single) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_mixinmethod
    def Simplify(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry, simplification: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometrySimplification) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_mixinmethod
    def SimplifyWithTransformAndFlatteningTolerance(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry, simplification: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometrySimplification, transform: win32more.Windows.Foundation.Numerics.Matrix3x2, flatteningTolerance: Single) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_mixinmethod
    def Transform(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_mixinmethod
    def CompareWith(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry, otherGeometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometryRelation: ...
    @winrt_mixinmethod
    def CompareWithUsingTransformAndFlatteningTolerance(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry, otherGeometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, otherGeometryTransform: win32more.Windows.Foundation.Numerics.Matrix3x2, flatteningTolerance: Single) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometryRelation: ...
    @winrt_mixinmethod
    def ComputeArea(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry) -> Single: ...
    @winrt_mixinmethod
    def ComputeAreaWithTransformAndFlatteningTolerance(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry, transform: win32more.Windows.Foundation.Numerics.Matrix3x2, flatteningTolerance: Single) -> Single: ...
    @winrt_mixinmethod
    def ComputePathLength(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry) -> Single: ...
    @winrt_mixinmethod
    def ComputePathLengthWithTransformAndFlatteningTolerance(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry, transform: win32more.Windows.Foundation.Numerics.Matrix3x2, flatteningTolerance: Single) -> Single: ...
    @winrt_mixinmethod
    def ComputePointOnPath(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry, distance: Single) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_mixinmethod
    def ComputePointOnPathWithTangent(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry, distance: Single, tangent: POINTER(win32more.Windows.Foundation.Numerics.Vector2)) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_mixinmethod
    def ComputePointOnPathWithTransformAndFlatteningToleranceAndTangent(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry, length: Single, transform: win32more.Windows.Foundation.Numerics.Matrix3x2, flatteningTolerance: Single, tangent: POINTER(win32more.Windows.Foundation.Numerics.Vector2)) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_mixinmethod
    def FillContainsPoint(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry, point: win32more.Windows.Foundation.Numerics.Vector2) -> Boolean: ...
    @winrt_mixinmethod
    def FillContainsPointWithTransformAndFlatteningTolerance(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry, point: win32more.Windows.Foundation.Numerics.Vector2, transform: win32more.Windows.Foundation.Numerics.Matrix3x2, flatteningTolerance: Single) -> Boolean: ...
    @winrt_mixinmethod
    def ComputeBounds(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def ComputeBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def ComputeStrokeBounds(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry, strokeWidth: Single) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def ComputeStrokeBoundsWithStrokeStyle(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def ComputeStrokeBoundsWithAllOptions(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle, transform: win32more.Windows.Foundation.Numerics.Matrix3x2, flatteningTolerance: Single) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def StrokeContainsPoint(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry, point: win32more.Windows.Foundation.Numerics.Vector2, strokeWidth: Single) -> Boolean: ...
    @winrt_mixinmethod
    def StrokeContainsPointWithStrokeStyle(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry, point: win32more.Windows.Foundation.Numerics.Vector2, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Boolean: ...
    @winrt_mixinmethod
    def StrokeContainsPointWithAllOptions(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry, point: win32more.Windows.Foundation.Numerics.Vector2, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle, transform: win32more.Windows.Foundation.Numerics.Matrix3x2, flatteningTolerance: Single) -> Boolean: ...
    @winrt_mixinmethod
    def Tessellate(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry) -> ReceiveArray[win32more.Microsoft.Graphics.Canvas.Geometry.CanvasTriangleVertices]: ...
    @winrt_mixinmethod
    def TessellateWithTransformAndFlatteningTolerance(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry, transform: win32more.Windows.Foundation.Numerics.Matrix3x2, flatteningTolerance: Single) -> ReceiveArray[win32more.Microsoft.Graphics.Canvas.Geometry.CanvasTriangleVertices]: ...
    @winrt_mixinmethod
    def SendPathTo(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry, streamReader: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasPathReceiver) -> Void: ...
    @winrt_mixinmethod
    def get_Device(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    @winrt_classmethod
    def CreateRectangle(cls: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometryStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, rect: win32more.Windows.Foundation.Rect) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_classmethod
    def CreateRectangleAtCoords(cls: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometryStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, x: Single, y: Single, w: Single, h: Single) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_classmethod
    def CreateRoundedRectangle(cls: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometryStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, rect: win32more.Windows.Foundation.Rect, radiusX: Single, radiusY: Single) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_classmethod
    def CreateRoundedRectangleAtCoords(cls: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometryStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, x: Single, y: Single, w: Single, h: Single, radiusX: Single, radiusY: Single) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_classmethod
    def CreateEllipse(cls: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometryStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radiusX: Single, radiusY: Single) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_classmethod
    def CreateEllipseAtCoords(cls: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometryStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, x: Single, y: Single, radiusX: Single, radiusY: Single) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_classmethod
    def CreateCircle(cls: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometryStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radius: Single) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_classmethod
    def CreateCircleAtCoords(cls: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometryStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, x: Single, y: Single, radius: Single) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_classmethod
    def CreatePath(cls: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometryStatics, pathBuilder: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasPathBuilder) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_classmethod
    def CreatePolygon(cls: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometryStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, points: PassArray[win32more.Windows.Foundation.Numerics.Vector2]) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_classmethod
    def CreateGroup(cls: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometryStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, geometries: PassArray[win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry]) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_classmethod
    def CreateGroupWithFilledRegionDetermination(cls: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometryStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, geometries: PassArray[win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry], filledRegionDetermination: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasFilledRegionDetermination) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_classmethod
    def CreateText(cls: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometryStatics, textLayout: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextLayout) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_classmethod
    def CreateGlyphRun(cls: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometryStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, point: win32more.Windows.Foundation.Numerics.Vector2, fontFace: win32more.Microsoft.Graphics.Canvas.Text.CanvasFontFace, fontSize: Single, glyphs: PassArray[win32more.Microsoft.Graphics.Canvas.Text.CanvasGlyph], isSideways: Boolean, bidiLevel: UInt32, measuringMode: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextMeasuringMode, glyphOrientation: win32more.Microsoft.Graphics.Canvas.Text.CanvasGlyphOrientation) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_classmethod
    def ComputeFlatteningTolerance(cls: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometryStatics, dpi: Single, maximumZoomFactor: Single) -> Single: ...
    @winrt_classmethod
    def ComputeFlatteningToleranceWithTransform(cls: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometryStatics, dpi: Single, maximumZoomFactor: Single, expectedGeometryTransform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> Single: ...
    @winrt_classmethod
    def get_DefaultFlatteningTolerance(cls: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGeometryStatics) -> Single: ...
    Device = property(get_Device, None)
    _CanvasGeometry_Meta_.DefaultFlatteningTolerance = property(get_DefaultFlatteningTolerance, None)
class CanvasGeometryCombine(Enum, Int32):
    Union = 0
    Intersect = 1
    Xor = 2
    Exclude = 3
class CanvasGeometryRelation(Enum, Int32):
    Disjoint = 0
    Contained = 1
    Contains = 2
    Overlap = 3
class CanvasGeometrySimplification(Enum, Int32):
    CubicsAndLines = 0
    Lines = 1
class CanvasGradientMesh(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGradientMesh
    _classid_ = 'Microsoft.Graphics.Canvas.Geometry.CanvasGradientMesh'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 2:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGradientMesh.Create(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def Create(cls: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGradientMeshFactory, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, patchElements: PassArray[win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGradientMeshPatch]) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGradientMesh: ...
    @winrt_mixinmethod
    def get_Patches(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGradientMesh) -> ReceiveArray[win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGradientMeshPatch]: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGradientMesh, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGradientMesh, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def get_Device(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGradientMesh) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    @winrt_classmethod
    def CreateCoonsPatch(cls: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGradientMeshStatics, points: PassArray[win32more.Windows.Foundation.Numerics.Vector2], colors: PassArray[win32more.Windows.Foundation.Numerics.Vector4], edges: PassArray[win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGradientMeshPatchEdge]) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGradientMeshPatch: ...
    @winrt_classmethod
    def CreateTensorPatch(cls: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasGradientMeshStatics, points: PassArray[win32more.Windows.Foundation.Numerics.Vector2], colors: PassArray[win32more.Windows.Foundation.Numerics.Vector4], edges: PassArray[win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGradientMeshPatchEdge]) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGradientMeshPatch: ...
    Device = property(get_Device, None)
    Patches = property(get_Patches, None)
class CanvasGradientMeshPatch(Structure):
    Point00: win32more.Windows.Foundation.Numerics.Vector2
    Point01: win32more.Windows.Foundation.Numerics.Vector2
    Point02: win32more.Windows.Foundation.Numerics.Vector2
    Point03: win32more.Windows.Foundation.Numerics.Vector2
    Point10: win32more.Windows.Foundation.Numerics.Vector2
    Point11: win32more.Windows.Foundation.Numerics.Vector2
    Point12: win32more.Windows.Foundation.Numerics.Vector2
    Point13: win32more.Windows.Foundation.Numerics.Vector2
    Point20: win32more.Windows.Foundation.Numerics.Vector2
    Point21: win32more.Windows.Foundation.Numerics.Vector2
    Point22: win32more.Windows.Foundation.Numerics.Vector2
    Point23: win32more.Windows.Foundation.Numerics.Vector2
    Point30: win32more.Windows.Foundation.Numerics.Vector2
    Point31: win32more.Windows.Foundation.Numerics.Vector2
    Point32: win32more.Windows.Foundation.Numerics.Vector2
    Point33: win32more.Windows.Foundation.Numerics.Vector2
    Color00: win32more.Windows.Foundation.Numerics.Vector4
    Color03: win32more.Windows.Foundation.Numerics.Vector4
    Color30: win32more.Windows.Foundation.Numerics.Vector4
    Color33: win32more.Windows.Foundation.Numerics.Vector4
    Edge00To03: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGradientMeshPatchEdge
    Edge03To33: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGradientMeshPatchEdge
    Edge33To30: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGradientMeshPatchEdge
    Edge30To00: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGradientMeshPatchEdge
class CanvasGradientMeshPatchEdge(Enum, Int32):
    Aliased = 0
    Antialiased = 1
    AliasedAndInflated = 2
class CanvasLineJoin(Enum, Int32):
    Miter = 0
    Bevel = 1
    Round = 2
    MiterOrBevel = 3
class CanvasPathBuilder(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasPathBuilder
    _classid_ = 'Microsoft.Graphics.Canvas.Geometry.CanvasPathBuilder'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Geometry.CanvasPathBuilder.Create(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def Create(cls: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasPathBuilderFactory, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasPathBuilder: ...
    @winrt_mixinmethod
    def BeginFigureWithFigureFill(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasPathBuilder, startPoint: win32more.Windows.Foundation.Numerics.Vector2, figureFill: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasFigureFill) -> Void: ...
    @winrt_mixinmethod
    def BeginFigure(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasPathBuilder, startPoint: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_mixinmethod
    def BeginFigureAtCoordsWithFigureFill(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasPathBuilder, startX: Single, startY: Single, figureFill: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasFigureFill) -> Void: ...
    @winrt_mixinmethod
    def BeginFigureAtCoords(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasPathBuilder, startX: Single, startY: Single) -> Void: ...
    @winrt_mixinmethod
    def AddArcToPoint(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasPathBuilder, endPoint: win32more.Windows.Foundation.Numerics.Vector2, radiusX: Single, radiusY: Single, rotationAngle: Single, sweepDirection: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasSweepDirection, arcSize: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasArcSize) -> Void: ...
    @winrt_mixinmethod
    def AddArcAroundEllipse(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasPathBuilder, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radiusX: Single, radiusY: Single, startAngle: Single, sweepAngle: Single) -> Void: ...
    @winrt_mixinmethod
    def AddCubicBezier(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasPathBuilder, controlPoint1: win32more.Windows.Foundation.Numerics.Vector2, controlPoint2: win32more.Windows.Foundation.Numerics.Vector2, endPoint: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_mixinmethod
    def AddLine(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasPathBuilder, endPoint: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_mixinmethod
    def AddLineWithCoords(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasPathBuilder, x: Single, y: Single) -> Void: ...
    @winrt_mixinmethod
    def AddQuadraticBezier(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasPathBuilder, controlPoint: win32more.Windows.Foundation.Numerics.Vector2, endPoint: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_mixinmethod
    def SetFilledRegionDetermination(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasPathBuilder, filledRegionDetermination: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasFilledRegionDetermination) -> Void: ...
    @winrt_mixinmethod
    def SetSegmentOptions(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasPathBuilder, figureSegmentOptions: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasFigureSegmentOptions) -> Void: ...
    @winrt_mixinmethod
    def EndFigure(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasPathBuilder, figureLoop: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasFigureLoop) -> Void: ...
    @winrt_mixinmethod
    def AddGeometry(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasPathBuilder, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry) -> Void: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
class CanvasStrokeStyle(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasStrokeStyle
    _classid_ = 'Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle: ...
    @winrt_mixinmethod
    def get_StartCap(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasStrokeStyle) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCapStyle: ...
    @winrt_mixinmethod
    def put_StartCap(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasStrokeStyle, value: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCapStyle) -> Void: ...
    @winrt_mixinmethod
    def get_EndCap(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasStrokeStyle) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCapStyle: ...
    @winrt_mixinmethod
    def put_EndCap(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasStrokeStyle, value: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCapStyle) -> Void: ...
    @winrt_mixinmethod
    def get_DashCap(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasStrokeStyle) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCapStyle: ...
    @winrt_mixinmethod
    def put_DashCap(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasStrokeStyle, value: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCapStyle) -> Void: ...
    @winrt_mixinmethod
    def get_LineJoin(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasStrokeStyle) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasLineJoin: ...
    @winrt_mixinmethod
    def put_LineJoin(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasStrokeStyle, value: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasLineJoin) -> Void: ...
    @winrt_mixinmethod
    def get_MiterLimit(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasStrokeStyle) -> Single: ...
    @winrt_mixinmethod
    def put_MiterLimit(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasStrokeStyle, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_DashStyle(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasStrokeStyle) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasDashStyle: ...
    @winrt_mixinmethod
    def put_DashStyle(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasStrokeStyle, value: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasDashStyle) -> Void: ...
    @winrt_mixinmethod
    def get_DashOffset(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasStrokeStyle) -> Single: ...
    @winrt_mixinmethod
    def put_DashOffset(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasStrokeStyle, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_CustomDashStyle(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasStrokeStyle) -> ReceiveArray[Single]: ...
    @winrt_mixinmethod
    def put_CustomDashStyle(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasStrokeStyle, valueElements: PassArray[Single]) -> Void: ...
    @winrt_mixinmethod
    def get_TransformBehavior(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasStrokeStyle) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeTransformBehavior: ...
    @winrt_mixinmethod
    def put_TransformBehavior(self: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasStrokeStyle, value: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeTransformBehavior) -> Void: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    CustomDashStyle = property(get_CustomDashStyle, put_CustomDashStyle)
    DashCap = property(get_DashCap, put_DashCap)
    DashOffset = property(get_DashOffset, put_DashOffset)
    DashStyle = property(get_DashStyle, put_DashStyle)
    EndCap = property(get_EndCap, put_EndCap)
    LineJoin = property(get_LineJoin, put_LineJoin)
    MiterLimit = property(get_MiterLimit, put_MiterLimit)
    StartCap = property(get_StartCap, put_StartCap)
    TransformBehavior = property(get_TransformBehavior, put_TransformBehavior)
class CanvasStrokeTransformBehavior(Enum, Int32):
    Normal = 0
    Fixed = 1
    Hairline = 2
class CanvasSweepDirection(Enum, Int32):
    CounterClockwise = 0
    Clockwise = 1
class CanvasTriangleVertices(Structure):
    Vertex1: win32more.Windows.Foundation.Numerics.Vector2
    Vertex2: win32more.Windows.Foundation.Numerics.Vector2
    Vertex3: win32more.Windows.Foundation.Numerics.Vector2
class ICanvasCachedGeometry(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Geometry.ICanvasCachedGeometry'
    _iid_ = Guid('{ba6cb114-e1a1-448d-ab7c-8d2b92674119}')
    @winrt_commethod(6)
    def get_Device(self) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    Device = property(get_Device, None)
class ICanvasCachedGeometryStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.Geometry.ICanvasCachedGeometryStatics'
    _iid_ = Guid('{80ba1060-a9d7-41ba-9372-ec3fc1744e5d}')
    @winrt_commethod(6)
    def CreateFill(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCachedGeometry: ...
    @winrt_commethod(7)
    def CreateFillWithFlatteningTolerance(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, flatteningTolerance: Single) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCachedGeometry: ...
    @winrt_commethod(8)
    def CreateStroke(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, strokeWidth: Single) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCachedGeometry: ...
    @winrt_commethod(9)
    def CreateStrokeWithStrokeStyle(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCachedGeometry: ...
    @winrt_commethod(10)
    def CreateStrokeWithStrokeStyleAndFlatteningTolerance(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle, flatteningTolerance: Single) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCachedGeometry: ...
class ICanvasGeometry(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Geometry.ICanvasGeometry'
    _iid_ = Guid('{74ea89fa-c87c-4d0d-9057-2743b8db67ee}')
    @winrt_commethod(6)
    def CombineWith(self, otherGeometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, otherGeometryTransform: win32more.Windows.Foundation.Numerics.Matrix3x2, combine: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometryCombine) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_commethod(7)
    def CombineWithUsingFlatteningTolerance(self, otherGeometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, otherGeometryTransform: win32more.Windows.Foundation.Numerics.Matrix3x2, combine: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometryCombine, flatteningTolerance: Single) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_commethod(8)
    def Stroke(self, strokeWidth: Single) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_commethod(9)
    def StrokeWithStrokeStyle(self, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_commethod(10)
    def StrokeWithAllOptions(self, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle, transform: win32more.Windows.Foundation.Numerics.Matrix3x2, flatteningTolerance: Single) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_commethod(11)
    def Outline(self) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_commethod(12)
    def OutlineWithTransformAndFlatteningTolerance(self, transform: win32more.Windows.Foundation.Numerics.Matrix3x2, flatteningTolerance: Single) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_commethod(13)
    def Simplify(self, simplification: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometrySimplification) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_commethod(14)
    def SimplifyWithTransformAndFlatteningTolerance(self, simplification: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometrySimplification, transform: win32more.Windows.Foundation.Numerics.Matrix3x2, flatteningTolerance: Single) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_commethod(15)
    def Transform(self, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_commethod(16)
    def CompareWith(self, otherGeometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometryRelation: ...
    @winrt_commethod(17)
    def CompareWithUsingTransformAndFlatteningTolerance(self, otherGeometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, otherGeometryTransform: win32more.Windows.Foundation.Numerics.Matrix3x2, flatteningTolerance: Single) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometryRelation: ...
    @winrt_commethod(18)
    def ComputeArea(self) -> Single: ...
    @winrt_commethod(19)
    def ComputeAreaWithTransformAndFlatteningTolerance(self, transform: win32more.Windows.Foundation.Numerics.Matrix3x2, flatteningTolerance: Single) -> Single: ...
    @winrt_commethod(20)
    def ComputePathLength(self) -> Single: ...
    @winrt_commethod(21)
    def ComputePathLengthWithTransformAndFlatteningTolerance(self, transform: win32more.Windows.Foundation.Numerics.Matrix3x2, flatteningTolerance: Single) -> Single: ...
    @winrt_commethod(22)
    def ComputePointOnPath(self, distance: Single) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_commethod(23)
    def ComputePointOnPathWithTangent(self, distance: Single, tangent: POINTER(win32more.Windows.Foundation.Numerics.Vector2)) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_commethod(24)
    def ComputePointOnPathWithTransformAndFlatteningToleranceAndTangent(self, length: Single, transform: win32more.Windows.Foundation.Numerics.Matrix3x2, flatteningTolerance: Single, tangent: POINTER(win32more.Windows.Foundation.Numerics.Vector2)) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_commethod(25)
    def FillContainsPoint(self, point: win32more.Windows.Foundation.Numerics.Vector2) -> Boolean: ...
    @winrt_commethod(26)
    def FillContainsPointWithTransformAndFlatteningTolerance(self, point: win32more.Windows.Foundation.Numerics.Vector2, transform: win32more.Windows.Foundation.Numerics.Matrix3x2, flatteningTolerance: Single) -> Boolean: ...
    @winrt_commethod(27)
    def ComputeBounds(self) -> win32more.Windows.Foundation.Rect: ...
    @winrt_commethod(28)
    def ComputeBoundsWithTransform(self, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_commethod(29)
    def ComputeStrokeBounds(self, strokeWidth: Single) -> win32more.Windows.Foundation.Rect: ...
    @winrt_commethod(30)
    def ComputeStrokeBoundsWithStrokeStyle(self, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> win32more.Windows.Foundation.Rect: ...
    @winrt_commethod(31)
    def ComputeStrokeBoundsWithAllOptions(self, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle, transform: win32more.Windows.Foundation.Numerics.Matrix3x2, flatteningTolerance: Single) -> win32more.Windows.Foundation.Rect: ...
    @winrt_commethod(32)
    def StrokeContainsPoint(self, point: win32more.Windows.Foundation.Numerics.Vector2, strokeWidth: Single) -> Boolean: ...
    @winrt_commethod(33)
    def StrokeContainsPointWithStrokeStyle(self, point: win32more.Windows.Foundation.Numerics.Vector2, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Boolean: ...
    @winrt_commethod(34)
    def StrokeContainsPointWithAllOptions(self, point: win32more.Windows.Foundation.Numerics.Vector2, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle, transform: win32more.Windows.Foundation.Numerics.Matrix3x2, flatteningTolerance: Single) -> Boolean: ...
    @winrt_commethod(35)
    def Tessellate(self) -> ReceiveArray[win32more.Microsoft.Graphics.Canvas.Geometry.CanvasTriangleVertices]: ...
    @winrt_commethod(36)
    def TessellateWithTransformAndFlatteningTolerance(self, transform: win32more.Windows.Foundation.Numerics.Matrix3x2, flatteningTolerance: Single) -> ReceiveArray[win32more.Microsoft.Graphics.Canvas.Geometry.CanvasTriangleVertices]: ...
    @winrt_commethod(37)
    def SendPathTo(self, streamReader: win32more.Microsoft.Graphics.Canvas.Geometry.ICanvasPathReceiver) -> Void: ...
    @winrt_commethod(38)
    def get_Device(self) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    Device = property(get_Device, None)
class ICanvasGeometryStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.Geometry.ICanvasGeometryStatics'
    _iid_ = Guid('{d94e33cf-cd59-46f2-8df4-55066aabfd56}')
    @winrt_commethod(6)
    def CreateRectangle(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, rect: win32more.Windows.Foundation.Rect) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_commethod(7)
    def CreateRectangleAtCoords(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, x: Single, y: Single, w: Single, h: Single) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_commethod(8)
    def CreateRoundedRectangle(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, rect: win32more.Windows.Foundation.Rect, radiusX: Single, radiusY: Single) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_commethod(9)
    def CreateRoundedRectangleAtCoords(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, x: Single, y: Single, w: Single, h: Single, radiusX: Single, radiusY: Single) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_commethod(10)
    def CreateEllipse(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radiusX: Single, radiusY: Single) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_commethod(11)
    def CreateEllipseAtCoords(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, x: Single, y: Single, radiusX: Single, radiusY: Single) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_commethod(12)
    def CreateCircle(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radius: Single) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_commethod(13)
    def CreateCircleAtCoords(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, x: Single, y: Single, radius: Single) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_commethod(14)
    def CreatePath(self, pathBuilder: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasPathBuilder) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_commethod(15)
    def CreatePolygon(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, points: PassArray[win32more.Windows.Foundation.Numerics.Vector2]) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_commethod(16)
    def CreateGroup(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, geometries: PassArray[win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry]) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_commethod(17)
    def CreateGroupWithFilledRegionDetermination(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, geometries: PassArray[win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry], filledRegionDetermination: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasFilledRegionDetermination) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_commethod(18)
    def CreateText(self, textLayout: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextLayout) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_commethod(19)
    def CreateGlyphRun(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, point: win32more.Windows.Foundation.Numerics.Vector2, fontFace: win32more.Microsoft.Graphics.Canvas.Text.CanvasFontFace, fontSize: Single, glyphs: PassArray[win32more.Microsoft.Graphics.Canvas.Text.CanvasGlyph], isSideways: Boolean, bidiLevel: UInt32, measuringMode: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextMeasuringMode, glyphOrientation: win32more.Microsoft.Graphics.Canvas.Text.CanvasGlyphOrientation) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_commethod(20)
    def ComputeFlatteningTolerance(self, dpi: Single, maximumZoomFactor: Single) -> Single: ...
    @winrt_commethod(21)
    def ComputeFlatteningToleranceWithTransform(self, dpi: Single, maximumZoomFactor: Single, expectedGeometryTransform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> Single: ...
    @winrt_commethod(22)
    def get_DefaultFlatteningTolerance(self) -> Single: ...
    DefaultFlatteningTolerance = property(get_DefaultFlatteningTolerance, None)
class ICanvasGradientMesh(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Geometry.ICanvasGradientMesh'
    _iid_ = Guid('{6bfc2bf1-0a7a-449c-a7ef-6706321b0c1a}')
    @winrt_commethod(6)
    def get_Patches(self) -> ReceiveArray[win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGradientMeshPatch]: ...
    @winrt_commethod(7)
    def GetBounds(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_commethod(8)
    def GetBoundsWithTransform(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_commethod(9)
    def get_Device(self) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    Device = property(get_Device, None)
    Patches = property(get_Patches, None)
class ICanvasGradientMeshFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.Geometry.ICanvasGradientMeshFactory'
    _iid_ = Guid('{4756492d-251e-421d-834d-87ec260d5e4d}')
    @winrt_commethod(6)
    def Create(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, patchElements: PassArray[win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGradientMeshPatch]) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGradientMesh: ...
class ICanvasGradientMeshStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.Geometry.ICanvasGradientMeshStatics'
    _iid_ = Guid('{44027640-3eab-4199-aa3b-644890d0123d}')
    @winrt_commethod(6)
    def CreateCoonsPatch(self, points: PassArray[win32more.Windows.Foundation.Numerics.Vector2], colors: PassArray[win32more.Windows.Foundation.Numerics.Vector4], edges: PassArray[win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGradientMeshPatchEdge]) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGradientMeshPatch: ...
    @winrt_commethod(7)
    def CreateTensorPatch(self, points: PassArray[win32more.Windows.Foundation.Numerics.Vector2], colors: PassArray[win32more.Windows.Foundation.Numerics.Vector4], edges: PassArray[win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGradientMeshPatchEdge]) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGradientMeshPatch: ...
class ICanvasPathBuilder(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Geometry.ICanvasPathBuilder'
    _iid_ = Guid('{bcf5822f-8127-4e5c-96b8-29983b915541}')
    @winrt_commethod(6)
    def BeginFigureWithFigureFill(self, startPoint: win32more.Windows.Foundation.Numerics.Vector2, figureFill: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasFigureFill) -> Void: ...
    @winrt_commethod(7)
    def BeginFigure(self, startPoint: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_commethod(8)
    def BeginFigureAtCoordsWithFigureFill(self, startX: Single, startY: Single, figureFill: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasFigureFill) -> Void: ...
    @winrt_commethod(9)
    def BeginFigureAtCoords(self, startX: Single, startY: Single) -> Void: ...
    @winrt_commethod(10)
    def AddArcToPoint(self, endPoint: win32more.Windows.Foundation.Numerics.Vector2, radiusX: Single, radiusY: Single, rotationAngle: Single, sweepDirection: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasSweepDirection, arcSize: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasArcSize) -> Void: ...
    @winrt_commethod(11)
    def AddArcAroundEllipse(self, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radiusX: Single, radiusY: Single, startAngle: Single, sweepAngle: Single) -> Void: ...
    @winrt_commethod(12)
    def AddCubicBezier(self, controlPoint1: win32more.Windows.Foundation.Numerics.Vector2, controlPoint2: win32more.Windows.Foundation.Numerics.Vector2, endPoint: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_commethod(13)
    def AddLine(self, endPoint: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_commethod(14)
    def AddLineWithCoords(self, x: Single, y: Single) -> Void: ...
    @winrt_commethod(15)
    def AddQuadraticBezier(self, controlPoint: win32more.Windows.Foundation.Numerics.Vector2, endPoint: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_commethod(16)
    def SetFilledRegionDetermination(self, filledRegionDetermination: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasFilledRegionDetermination) -> Void: ...
    @winrt_commethod(17)
    def SetSegmentOptions(self, figureSegmentOptions: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasFigureSegmentOptions) -> Void: ...
    @winrt_commethod(18)
    def EndFigure(self, figureLoop: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasFigureLoop) -> Void: ...
    @winrt_commethod(19)
    def AddGeometry(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry) -> Void: ...
class ICanvasPathBuilderFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.Geometry.ICanvasPathBuilderFactory'
    _iid_ = Guid('{ac2bee14-efd1-4343-8e53-ba62153d8966}')
    @winrt_commethod(6)
    def Create(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasPathBuilder: ...
class ICanvasPathReceiver(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.Geometry.ICanvasPathReceiver'
    _iid_ = Guid('{70e65373-7fb3-4645-8b6d-f616d1b9a9d7}')
    @winrt_commethod(6)
    def BeginFigure(self, startPoint: win32more.Windows.Foundation.Numerics.Vector2, figureFill: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasFigureFill) -> Void: ...
    @winrt_commethod(7)
    def AddArc(self, endPoint: win32more.Windows.Foundation.Numerics.Vector2, radiusX: Single, radiusY: Single, rotationAngle: Single, sweepDirection: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasSweepDirection, arcSize: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasArcSize) -> Void: ...
    @winrt_commethod(8)
    def AddCubicBezier(self, controlPoint1: win32more.Windows.Foundation.Numerics.Vector2, controlPoint2: win32more.Windows.Foundation.Numerics.Vector2, endPoint: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_commethod(9)
    def AddLine(self, endPoint: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_commethod(10)
    def AddQuadraticBezier(self, controlPoint: win32more.Windows.Foundation.Numerics.Vector2, endPoint: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_commethod(11)
    def SetFilledRegionDetermination(self, filledRegionDetermination: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasFilledRegionDetermination) -> Void: ...
    @winrt_commethod(12)
    def SetSegmentOptions(self, figureSegmentOptions: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasFigureSegmentOptions) -> Void: ...
    @winrt_commethod(13)
    def EndFigure(self, figureLoop: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasFigureLoop) -> Void: ...
class ICanvasStrokeStyle(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Geometry.ICanvasStrokeStyle'
    _iid_ = Guid('{fd3e1cd2-6019-40a1-b315-267eef6c2aeb}')
    @winrt_commethod(6)
    def get_StartCap(self) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCapStyle: ...
    @winrt_commethod(7)
    def put_StartCap(self, value: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCapStyle) -> Void: ...
    @winrt_commethod(8)
    def get_EndCap(self) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCapStyle: ...
    @winrt_commethod(9)
    def put_EndCap(self, value: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCapStyle) -> Void: ...
    @winrt_commethod(10)
    def get_DashCap(self) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCapStyle: ...
    @winrt_commethod(11)
    def put_DashCap(self, value: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCapStyle) -> Void: ...
    @winrt_commethod(12)
    def get_LineJoin(self) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasLineJoin: ...
    @winrt_commethod(13)
    def put_LineJoin(self, value: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasLineJoin) -> Void: ...
    @winrt_commethod(14)
    def get_MiterLimit(self) -> Single: ...
    @winrt_commethod(15)
    def put_MiterLimit(self, value: Single) -> Void: ...
    @winrt_commethod(16)
    def get_DashStyle(self) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasDashStyle: ...
    @winrt_commethod(17)
    def put_DashStyle(self, value: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasDashStyle) -> Void: ...
    @winrt_commethod(18)
    def get_DashOffset(self) -> Single: ...
    @winrt_commethod(19)
    def put_DashOffset(self, value: Single) -> Void: ...
    @winrt_commethod(20)
    def get_CustomDashStyle(self) -> ReceiveArray[Single]: ...
    @winrt_commethod(21)
    def put_CustomDashStyle(self, valueElements: PassArray[Single]) -> Void: ...
    @winrt_commethod(22)
    def get_TransformBehavior(self) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeTransformBehavior: ...
    @winrt_commethod(23)
    def put_TransformBehavior(self, value: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeTransformBehavior) -> Void: ...
    CustomDashStyle = property(get_CustomDashStyle, put_CustomDashStyle)
    DashCap = property(get_DashCap, put_DashCap)
    DashOffset = property(get_DashOffset, put_DashOffset)
    DashStyle = property(get_DashStyle, put_DashStyle)
    EndCap = property(get_EndCap, put_EndCap)
    LineJoin = property(get_LineJoin, put_LineJoin)
    MiterLimit = property(get_MiterLimit, put_MiterLimit)
    StartCap = property(get_StartCap, put_StartCap)
    TransformBehavior = property(get_TransformBehavior, put_TransformBehavior)


make_ready(__name__)
