from __future__ import annotations
from win32more import ARCH, Annotated, Boolean, Byte, Bytes, Char, ComPtr, ConstantLazyLoader, Double, Enum, FAILED, FlexibleArray, Guid, Int16, Int32, Int64, IntPtr, NativeBitfieldAttribute, POINTER, SByte, SUCCEEDED, Single, String, Structure, UInt16, UInt32, UInt64, UIntPtr, UnicodeAlias, Union, Void, VoidPtr, cfunctype, cfunctype_pointer, commethod, make_ready, winfunctype, winfunctype_pointer
from win32more._winrt import AwaitableProtocol, ContextManagerProtocol, FillArray, Generic, IInspectable, IUnknown, IterableProtocol, K, MappingProtocol, MulticastDelegate, PassArray, ReceiveArray, SequenceProtocol, T, TProgress, TResult, TSender, Tuple, V, WinRT_String, event, winrt_activatemethod, winrt_classmethod, winrt_commethod, winrt_factorymethod, winrt_mixinmethod, winrt_overload
import win32more.Microsoft.Graphics.Canvas
import win32more.Microsoft.Graphics.Canvas.Brushes
import win32more.Microsoft.Graphics.Canvas.Effects
import win32more.Microsoft.Graphics.Canvas.Geometry
import win32more.Microsoft.Graphics.Canvas.Svg
import win32more.Microsoft.Graphics.Canvas.Text
import win32more.Microsoft.UI
import win32more.Windows.Foundation
import win32more.Windows.Foundation.Numerics
import win32more.Windows.Graphics.DirectX
import win32more.Windows.Graphics.DirectX.Direct3D11
import win32more.Windows.Graphics.Effects
import win32more.Windows.Graphics.Imaging
import win32more.Windows.Storage.Streams
import win32more.Windows.UI
import win32more.Windows.UI.Core
class CanvasActiveLayer(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.ICanvasActiveLayer
    _classid_ = 'Microsoft.Graphics.Canvas.CanvasActiveLayer'
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
class CanvasAlphaMode(Enum, Int32):
    Premultiplied = 0
    Straight = 1
    Ignore = 2
class CanvasAntialiasing(Enum, Int32):
    Antialiased = 0
    Aliased = 1
class CanvasBitmap(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.ICanvasBitmap
    _classid_ = 'Microsoft.Graphics.Canvas.CanvasBitmap'
    @winrt_mixinmethod
    def get_SizeInPixels(self: win32more.Microsoft.Graphics.Canvas.ICanvasBitmap) -> win32more.Windows.Graphics.Imaging.BitmapSize: ...
    @winrt_mixinmethod
    def get_Size(self: win32more.Microsoft.Graphics.Canvas.ICanvasBitmap) -> win32more.Windows.Foundation.Size: ...
    @winrt_mixinmethod
    def get_Bounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasBitmap) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def get_Format(self: win32more.Microsoft.Graphics.Canvas.ICanvasBitmap) -> win32more.Windows.Graphics.DirectX.DirectXPixelFormat: ...
    @winrt_mixinmethod
    def get_AlphaMode(self: win32more.Microsoft.Graphics.Canvas.ICanvasBitmap) -> win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode: ...
    @winrt_mixinmethod
    def SaveToFileAsync(self: win32more.Microsoft.Graphics.Canvas.ICanvasBitmap, fileName: WinRT_String) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_mixinmethod
    def SaveToFileWithBitmapFileFormatAsync(self: win32more.Microsoft.Graphics.Canvas.ICanvasBitmap, fileName: WinRT_String, fileFormat: win32more.Microsoft.Graphics.Canvas.CanvasBitmapFileFormat) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_mixinmethod
    def SaveToFileWithBitmapFileFormatAndQualityAsync(self: win32more.Microsoft.Graphics.Canvas.ICanvasBitmap, fileName: WinRT_String, fileFormat: win32more.Microsoft.Graphics.Canvas.CanvasBitmapFileFormat, quality: Single) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_mixinmethod
    def SaveToStreamAsync(self: win32more.Microsoft.Graphics.Canvas.ICanvasBitmap, stream: win32more.Windows.Storage.Streams.IRandomAccessStream, fileFormat: win32more.Microsoft.Graphics.Canvas.CanvasBitmapFileFormat) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_mixinmethod
    def SaveToStreamWithQualityAsync(self: win32more.Microsoft.Graphics.Canvas.ICanvasBitmap, stream: win32more.Windows.Storage.Streams.IRandomAccessStream, fileFormat: win32more.Microsoft.Graphics.Canvas.CanvasBitmapFileFormat, quality: Single) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_mixinmethod
    def GetPixelBytes(self: win32more.Microsoft.Graphics.Canvas.ICanvasBitmap) -> ReceiveArray[Byte]: ...
    @winrt_mixinmethod
    def GetPixelBytesWithSubrectangle(self: win32more.Microsoft.Graphics.Canvas.ICanvasBitmap, left: Int32, top: Int32, width: Int32, height: Int32) -> ReceiveArray[Byte]: ...
    @winrt_mixinmethod
    def GetPixelBytesWithBuffer(self: win32more.Microsoft.Graphics.Canvas.ICanvasBitmap, buffer: win32more.Windows.Storage.Streams.IBuffer) -> Void: ...
    @winrt_mixinmethod
    def GetPixelBytesWithBufferAndSubrectangle(self: win32more.Microsoft.Graphics.Canvas.ICanvasBitmap, buffer: win32more.Windows.Storage.Streams.IBuffer, left: Int32, top: Int32, width: Int32, height: Int32) -> Void: ...
    @winrt_mixinmethod
    def GetPixelColors(self: win32more.Microsoft.Graphics.Canvas.ICanvasBitmap) -> ReceiveArray[win32more.Windows.UI.Color]: ...
    @winrt_mixinmethod
    def GetPixelColorsWithSubrectangle(self: win32more.Microsoft.Graphics.Canvas.ICanvasBitmap, left: Int32, top: Int32, width: Int32, height: Int32) -> ReceiveArray[win32more.Windows.UI.Color]: ...
    @winrt_mixinmethod
    def SetPixelBytes(self: win32more.Microsoft.Graphics.Canvas.ICanvasBitmap, valueElements: PassArray[Byte]) -> Void: ...
    @winrt_mixinmethod
    def SetPixelBytesWithSubrectangle(self: win32more.Microsoft.Graphics.Canvas.ICanvasBitmap, valueElements: PassArray[Byte], left: Int32, top: Int32, width: Int32, height: Int32) -> Void: ...
    @winrt_mixinmethod
    def SetPixelBytesWithBuffer(self: win32more.Microsoft.Graphics.Canvas.ICanvasBitmap, buffer: win32more.Windows.Storage.Streams.IBuffer) -> Void: ...
    @winrt_mixinmethod
    def SetPixelBytesWithBufferAndSubrectangle(self: win32more.Microsoft.Graphics.Canvas.ICanvasBitmap, buffer: win32more.Windows.Storage.Streams.IBuffer, left: Int32, top: Int32, width: Int32, height: Int32) -> Void: ...
    @winrt_mixinmethod
    def SetPixelColors(self: win32more.Microsoft.Graphics.Canvas.ICanvasBitmap, valueElements: PassArray[win32more.Windows.UI.Color]) -> Void: ...
    @winrt_mixinmethod
    def SetPixelColorsWithSubrectangle(self: win32more.Microsoft.Graphics.Canvas.ICanvasBitmap, valueElements: PassArray[win32more.Windows.UI.Color], left: Int32, top: Int32, width: Int32, height: Int32) -> Void: ...
    @winrt_mixinmethod
    def CopyPixelsFromBitmap(self: win32more.Microsoft.Graphics.Canvas.ICanvasBitmap, otherBitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap) -> Void: ...
    @winrt_mixinmethod
    def CopyPixelsFromBitmapWithDestPoint(self: win32more.Microsoft.Graphics.Canvas.ICanvasBitmap, otherBitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, destX: Int32, destY: Int32) -> Void: ...
    @winrt_mixinmethod
    def CopyPixelsFromBitmapWithDestPointAndSourceRect(self: win32more.Microsoft.Graphics.Canvas.ICanvasBitmap, otherBitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, destX: Int32, destY: Int32, sourceRectLeft: Int32, sourceRectTop: Int32, sourceRectWidth: Int32, sourceRectHeight: Int32) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    @winrt_mixinmethod
    def get_Description(self: win32more.Windows.Graphics.DirectX.Direct3D11.IDirect3DSurface) -> win32more.Windows.Graphics.DirectX.Direct3D11.Direct3DSurfaceDescription: ...
    @winrt_mixinmethod
    def get_Dpi(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> Single: ...
    @winrt_mixinmethod
    def ConvertPixelsToDips(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, pixels: Int32) -> Single: ...
    @winrt_mixinmethod
    def ConvertDipsToPixels(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, dips: Single, dpiRounding: win32more.Microsoft.Graphics.Canvas.CanvasDpiRounding) -> Int32: ...
    @winrt_mixinmethod
    def get_Device(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    @winrt_classmethod
    def CreateFromDirect3D11Surface(cls: win32more.Microsoft.Graphics.Canvas.ICanvasBitmapStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, surface: win32more.Windows.Graphics.DirectX.Direct3D11.IDirect3DSurface) -> win32more.Microsoft.Graphics.Canvas.CanvasBitmap: ...
    @winrt_classmethod
    def CreateFromDirect3D11SurfaceWithDpi(cls: win32more.Microsoft.Graphics.Canvas.ICanvasBitmapStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, surface: win32more.Windows.Graphics.DirectX.Direct3D11.IDirect3DSurface, dpi: Single) -> win32more.Microsoft.Graphics.Canvas.CanvasBitmap: ...
    @winrt_classmethod
    def CreateFromDirect3D11SurfaceWithDpiAndAlpha(cls: win32more.Microsoft.Graphics.Canvas.ICanvasBitmapStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, surface: win32more.Windows.Graphics.DirectX.Direct3D11.IDirect3DSurface, dpi: Single, alpha: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Microsoft.Graphics.Canvas.CanvasBitmap: ...
    @winrt_classmethod
    def CreateFromBytes(cls: win32more.Microsoft.Graphics.Canvas.ICanvasBitmapStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, bytes: PassArray[Byte], widthInPixels: Int32, heightInPixels: Int32, format: win32more.Windows.Graphics.DirectX.DirectXPixelFormat) -> win32more.Microsoft.Graphics.Canvas.CanvasBitmap: ...
    @winrt_classmethod
    def CreateFromBytesWithDpi(cls: win32more.Microsoft.Graphics.Canvas.ICanvasBitmapStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, bytes: PassArray[Byte], widthInPixels: Int32, heightInPixels: Int32, format: win32more.Windows.Graphics.DirectX.DirectXPixelFormat, dpi: Single) -> win32more.Microsoft.Graphics.Canvas.CanvasBitmap: ...
    @winrt_classmethod
    def CreateFromBytesWithDpiAndAlpha(cls: win32more.Microsoft.Graphics.Canvas.ICanvasBitmapStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, bytes: PassArray[Byte], widthInPixels: Int32, heightInPixels: Int32, format: win32more.Windows.Graphics.DirectX.DirectXPixelFormat, dpi: Single, alpha: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Microsoft.Graphics.Canvas.CanvasBitmap: ...
    @winrt_classmethod
    def CreateFromBytesWithBuffer(cls: win32more.Microsoft.Graphics.Canvas.ICanvasBitmapStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, buffer: win32more.Windows.Storage.Streams.IBuffer, widthInPixels: Int32, heightInPixels: Int32, format: win32more.Windows.Graphics.DirectX.DirectXPixelFormat) -> win32more.Microsoft.Graphics.Canvas.CanvasBitmap: ...
    @winrt_classmethod
    def CreateFromBytesWithBufferAndDpi(cls: win32more.Microsoft.Graphics.Canvas.ICanvasBitmapStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, buffer: win32more.Windows.Storage.Streams.IBuffer, widthInPixels: Int32, heightInPixels: Int32, format: win32more.Windows.Graphics.DirectX.DirectXPixelFormat, dpi: Single) -> win32more.Microsoft.Graphics.Canvas.CanvasBitmap: ...
    @winrt_classmethod
    def CreateFromBytesWithBufferAndDpiAndAlpha(cls: win32more.Microsoft.Graphics.Canvas.ICanvasBitmapStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, buffer: win32more.Windows.Storage.Streams.IBuffer, widthInPixels: Int32, heightInPixels: Int32, format: win32more.Windows.Graphics.DirectX.DirectXPixelFormat, dpi: Single, alpha: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Microsoft.Graphics.Canvas.CanvasBitmap: ...
    @winrt_classmethod
    def CreateFromColors(cls: win32more.Microsoft.Graphics.Canvas.ICanvasBitmapStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, colors: PassArray[win32more.Windows.UI.Color], widthInPixels: Int32, heightInPixels: Int32) -> win32more.Microsoft.Graphics.Canvas.CanvasBitmap: ...
    @winrt_classmethod
    def CreateFromColorsWithDpi(cls: win32more.Microsoft.Graphics.Canvas.ICanvasBitmapStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, colors: PassArray[win32more.Windows.UI.Color], widthInPixels: Int32, heightInPixels: Int32, dpi: Single) -> win32more.Microsoft.Graphics.Canvas.CanvasBitmap: ...
    @winrt_classmethod
    def CreateFromColorsWithDpiAndAlpha(cls: win32more.Microsoft.Graphics.Canvas.ICanvasBitmapStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, colors: PassArray[win32more.Windows.UI.Color], widthInPixels: Int32, heightInPixels: Int32, dpi: Single, alpha: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Microsoft.Graphics.Canvas.CanvasBitmap: ...
    @winrt_classmethod
    def CreateFromSoftwareBitmap(cls: win32more.Microsoft.Graphics.Canvas.ICanvasBitmapStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, sourceBitmap: win32more.Windows.Graphics.Imaging.SoftwareBitmap) -> win32more.Microsoft.Graphics.Canvas.CanvasBitmap: ...
    @winrt_classmethod
    def LoadAsyncFromHstring(cls: win32more.Microsoft.Graphics.Canvas.ICanvasBitmapStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, fileName: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasBitmap]: ...
    @winrt_classmethod
    def LoadAsyncFromHstringWithDpi(cls: win32more.Microsoft.Graphics.Canvas.ICanvasBitmapStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, fileName: WinRT_String, dpi: Single) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasBitmap]: ...
    @winrt_classmethod
    def LoadAsyncFromHstringWithDpiAndAlpha(cls: win32more.Microsoft.Graphics.Canvas.ICanvasBitmapStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, fileName: WinRT_String, dpi: Single, alpha: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasBitmap]: ...
    @winrt_classmethod
    def LoadAsyncFromUri(cls: win32more.Microsoft.Graphics.Canvas.ICanvasBitmapStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, uri: win32more.Windows.Foundation.Uri) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasBitmap]: ...
    @winrt_classmethod
    def LoadAsyncFromUriWithDpi(cls: win32more.Microsoft.Graphics.Canvas.ICanvasBitmapStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, uri: win32more.Windows.Foundation.Uri, dpi: Single) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasBitmap]: ...
    @winrt_classmethod
    def LoadAsyncFromUriWithDpiAndAlpha(cls: win32more.Microsoft.Graphics.Canvas.ICanvasBitmapStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, uri: win32more.Windows.Foundation.Uri, dpi: Single, alpha: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasBitmap]: ...
    @winrt_classmethod
    def LoadAsyncFromStream(cls: win32more.Microsoft.Graphics.Canvas.ICanvasBitmapStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, stream: win32more.Windows.Storage.Streams.IRandomAccessStream) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasBitmap]: ...
    @winrt_classmethod
    def LoadAsyncFromStreamWithDpi(cls: win32more.Microsoft.Graphics.Canvas.ICanvasBitmapStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, stream: win32more.Windows.Storage.Streams.IRandomAccessStream, dpi: Single) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasBitmap]: ...
    @winrt_classmethod
    def LoadAsyncFromStreamWithDpiAndAlpha(cls: win32more.Microsoft.Graphics.Canvas.ICanvasBitmapStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, stream: win32more.Windows.Storage.Streams.IRandomAccessStream, dpi: Single, alpha: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasBitmap]: ...
    AlphaMode = property(get_AlphaMode, None)
    Bounds = property(get_Bounds, None)
    Description = property(get_Description, None)
    Device = property(get_Device, None)
    Dpi = property(get_Dpi, None)
    Format = property(get_Format, None)
    Size = property(get_Size, None)
    SizeInPixels = property(get_SizeInPixels, None)
class CanvasBitmapFileFormat(Enum, Int32):
    Auto = 0
    Bmp = 1
    Png = 2
    Jpeg = 3
    Tiff = 4
    Gif = 5
    JpegXR = 6
class CanvasBlend(Enum, Int32):
    SourceOver = 0
    Copy = 1
    Min = 2
    Add = 3
class CanvasBufferPrecision(Enum, Int32):
    Precision8UIntNormalized = 0
    Precision8UIntNormalizedSrgb = 1
    Precision16UIntNormalized = 2
    Precision16Float = 3
    Precision32Float = 4
class CanvasColorSpace(Enum, Int32):
    Custom = 0
    Srgb = 1
    ScRgb = 2
class CanvasCommandList(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.ICanvasCommandList
    _classid_ = 'Microsoft.Graphics.Canvas.CanvasCommandList'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.CanvasCommandList.Create(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def Create(cls: win32more.Microsoft.Graphics.Canvas.ICanvasCommandListFactory, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Microsoft.Graphics.Canvas.CanvasCommandList: ...
    @winrt_mixinmethod
    def CreateDrawingSession(self: win32more.Microsoft.Graphics.Canvas.ICanvasCommandList) -> win32more.Microsoft.Graphics.Canvas.CanvasDrawingSession: ...
    @winrt_mixinmethod
    def get_Device(self: win32more.Microsoft.Graphics.Canvas.ICanvasCommandList) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    Device = property(get_Device, None)
class CanvasComposite(Enum, Int32):
    SourceOver = 0
    DestinationOver = 1
    SourceIn = 2
    DestinationIn = 3
    SourceOut = 4
    DestinationOut = 5
    SourceAtop = 6
    DestinationAtop = 7
    Xor = 8
    Add = 9
    Copy = 10
    BoundedCopy = 11
    MaskInvert = 12
class CanvasDebugLevel(Enum, Int32):
    None_ = 0
    Error = 1
    Warning = 2
    Information = 3
class _CanvasDevice_Meta_(ComPtr.__class__):
    pass
class CanvasDevice(ComPtr, metaclass=_CanvasDevice_Meta_):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.ICanvasDevice
    _classid_ = 'Microsoft.Graphics.Canvas.CanvasDevice'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.CanvasDevice.CreateInstance(*args))
        elif len(args) == 1:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.CanvasDevice.CreateWithForceSoftwareRendererOption(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    @winrt_factorymethod
    def CreateWithForceSoftwareRendererOption(cls: win32more.Microsoft.Graphics.Canvas.ICanvasDeviceFactory, forceSoftwareRenderer: Boolean) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    @winrt_mixinmethod
    def get_ForceSoftwareRenderer(self: win32more.Microsoft.Graphics.Canvas.ICanvasDevice) -> Boolean: ...
    @winrt_mixinmethod
    def get_MaximumBitmapSizeInPixels(self: win32more.Microsoft.Graphics.Canvas.ICanvasDevice) -> Int32: ...
    @winrt_mixinmethod
    def IsPixelFormatSupported(self: win32more.Microsoft.Graphics.Canvas.ICanvasDevice, pixelFormat: win32more.Windows.Graphics.DirectX.DirectXPixelFormat) -> Boolean: ...
    @winrt_mixinmethod
    def IsBufferPrecisionSupported(self: win32more.Microsoft.Graphics.Canvas.ICanvasDevice, bufferPrecision: win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision) -> Boolean: ...
    @winrt_mixinmethod
    def get_MaximumCacheSize(self: win32more.Microsoft.Graphics.Canvas.ICanvasDevice) -> UInt64: ...
    @winrt_mixinmethod
    def put_MaximumCacheSize(self: win32more.Microsoft.Graphics.Canvas.ICanvasDevice, value: UInt64) -> Void: ...
    @winrt_mixinmethod
    def get_LowPriority(self: win32more.Microsoft.Graphics.Canvas.ICanvasDevice) -> Boolean: ...
    @winrt_mixinmethod
    def put_LowPriority(self: win32more.Microsoft.Graphics.Canvas.ICanvasDevice, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def add_DeviceLost(self: win32more.Microsoft.Graphics.Canvas.ICanvasDevice, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.Graphics.Canvas.CanvasDevice, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_DeviceLost(self: win32more.Microsoft.Graphics.Canvas.ICanvasDevice, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def IsDeviceLost(self: win32more.Microsoft.Graphics.Canvas.ICanvasDevice, hresult: Int32) -> Boolean: ...
    @winrt_mixinmethod
    def RaiseDeviceLost(self: win32more.Microsoft.Graphics.Canvas.ICanvasDevice) -> Void: ...
    @winrt_mixinmethod
    def Lock(self: win32more.Microsoft.Graphics.Canvas.ICanvasDevice) -> win32more.Microsoft.Graphics.Canvas.CanvasLock: ...
    @winrt_mixinmethod
    def IsDeviceLost2(self: win32more.Microsoft.Graphics.Canvas.ICanvasDevice) -> Boolean: ...
    @winrt_mixinmethod
    def GetDeviceLostReason(self: win32more.Microsoft.Graphics.Canvas.ICanvasDevice) -> Int32: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    @winrt_mixinmethod
    def get_Device(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    @winrt_mixinmethod
    def Trim(self: win32more.Windows.Graphics.DirectX.Direct3D11.IDirect3DDevice) -> Void: ...
    @winrt_classmethod
    def CreateFromDirect3D11Device(cls: win32more.Microsoft.Graphics.Canvas.ICanvasDeviceStatics, direct3DDevice: win32more.Windows.Graphics.DirectX.Direct3D11.IDirect3DDevice) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    @winrt_classmethod
    def GetSharedDevice(cls: win32more.Microsoft.Graphics.Canvas.ICanvasDeviceStatics) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    @winrt_classmethod
    def GetSharedDeviceWithForceSoftwareRenderer(cls: win32more.Microsoft.Graphics.Canvas.ICanvasDeviceStatics, forceSoftwareRenderer: Boolean) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    @winrt_classmethod
    def put_DebugLevel(cls: win32more.Microsoft.Graphics.Canvas.ICanvasDeviceStatics, value: win32more.Microsoft.Graphics.Canvas.CanvasDebugLevel) -> Void: ...
    @winrt_classmethod
    def get_DebugLevel(cls: win32more.Microsoft.Graphics.Canvas.ICanvasDeviceStatics) -> win32more.Microsoft.Graphics.Canvas.CanvasDebugLevel: ...
    Device = property(get_Device, None)
    ForceSoftwareRenderer = property(get_ForceSoftwareRenderer, None)
    LowPriority = property(get_LowPriority, put_LowPriority)
    MaximumBitmapSizeInPixels = property(get_MaximumBitmapSizeInPixels, None)
    MaximumCacheSize = property(get_MaximumCacheSize, put_MaximumCacheSize)
    _CanvasDevice_Meta_.DebugLevel = property(get_DebugLevel, put_DebugLevel)
    DeviceLost = event()
class CanvasDpiRounding(Enum, Int32):
    Floor = 0
    Round = 1
    Ceiling = 2
class CanvasDrawingSession(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession
    _classid_ = 'Microsoft.Graphics.Canvas.CanvasDrawingSession'
    @winrt_mixinmethod
    def Clear(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def ClearHdr(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, color: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_mixinmethod
    def Flush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession) -> Void: ...
    @winrt_mixinmethod
    def DrawImageAtOrigin(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage) -> Void: ...
    @winrt_mixinmethod
    def DrawImageAtOffset(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, offset: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_mixinmethod
    def DrawImageAtCoords(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, x: Single, y: Single) -> Void: ...
    @winrt_mixinmethod
    def DrawImageToRect(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, destinationRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def DrawImageAtOffsetWithSourceRect(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, offset: win32more.Windows.Foundation.Numerics.Vector2, sourceRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def DrawImageAtCoordsWithSourceRect(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, x: Single, y: Single, sourceRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def DrawImageToRectWithSourceRect(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, destinationRectangle: win32more.Windows.Foundation.Rect, sourceRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def DrawImageAtOffsetWithSourceRectAndOpacity(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, offset: win32more.Windows.Foundation.Numerics.Vector2, sourceRectangle: win32more.Windows.Foundation.Rect, opacity: Single) -> Void: ...
    @winrt_mixinmethod
    def DrawImageAtCoordsWithSourceRectAndOpacity(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, x: Single, y: Single, sourceRectangle: win32more.Windows.Foundation.Rect, opacity: Single) -> Void: ...
    @winrt_mixinmethod
    def DrawImageToRectWithSourceRectAndOpacity(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, destinationRectangle: win32more.Windows.Foundation.Rect, sourceRectangle: win32more.Windows.Foundation.Rect, opacity: Single) -> Void: ...
    @winrt_mixinmethod
    def DrawImageAtOffsetWithSourceRectAndOpacityAndInterpolation(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, offset: win32more.Windows.Foundation.Numerics.Vector2, sourceRectangle: win32more.Windows.Foundation.Rect, opacity: Single, interpolation: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_mixinmethod
    def DrawImageAtCoordsWithSourceRectAndOpacityAndInterpolation(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, x: Single, y: Single, sourceRectangle: win32more.Windows.Foundation.Rect, opacity: Single, interpolation: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_mixinmethod
    def DrawImageToRectWithSourceRectAndOpacityAndInterpolation(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, destinationRectangle: win32more.Windows.Foundation.Rect, sourceRectangle: win32more.Windows.Foundation.Rect, opacity: Single, interpolation: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_mixinmethod
    def DrawImageAtOffsetWithSourceRectAndOpacityAndInterpolationAndComposite(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, offset: win32more.Windows.Foundation.Numerics.Vector2, sourceRectangle: win32more.Windows.Foundation.Rect, opacity: Single, interpolation: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation, composite: win32more.Microsoft.Graphics.Canvas.CanvasComposite) -> Void: ...
    @winrt_mixinmethod
    def DrawImageAtCoordsWithSourceRectAndOpacityAndInterpolationAndComposite(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, x: Single, y: Single, sourceRectangle: win32more.Windows.Foundation.Rect, opacity: Single, interpolation: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation, composite: win32more.Microsoft.Graphics.Canvas.CanvasComposite) -> Void: ...
    @winrt_mixinmethod
    def DrawImageToRectWithSourceRectAndOpacityAndInterpolationAndComposite(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, destinationRectangle: win32more.Windows.Foundation.Rect, sourceRectangle: win32more.Windows.Foundation.Rect, opacity: Single, interpolation: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation, composite: win32more.Microsoft.Graphics.Canvas.CanvasComposite) -> Void: ...
    @winrt_mixinmethod
    def DrawImageAtOffsetWithSourceRectAndOpacityAndInterpolationAndPerspective(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, offset: win32more.Windows.Foundation.Numerics.Vector2, sourceRectangle: win32more.Windows.Foundation.Rect, opacity: Single, interpolation: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation, perspective: win32more.Windows.Foundation.Numerics.Matrix4x4) -> Void: ...
    @winrt_mixinmethod
    def DrawImageAtCoordsWithSourceRectAndOpacityAndInterpolationAndPerspective(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, x: Single, y: Single, sourceRectangle: win32more.Windows.Foundation.Rect, opacity: Single, interpolation: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation, perspective: win32more.Windows.Foundation.Numerics.Matrix4x4) -> Void: ...
    @winrt_mixinmethod
    def DrawImageToRectWithSourceRectAndOpacityAndInterpolationAndPerspective(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, destinationRectangle: win32more.Windows.Foundation.Rect, sourceRectangle: win32more.Windows.Foundation.Rect, opacity: Single, interpolation: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation, perspective: win32more.Windows.Foundation.Numerics.Matrix4x4) -> Void: ...
    @winrt_mixinmethod
    def DrawLineWithBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, point0: win32more.Windows.Foundation.Numerics.Vector2, point1: win32more.Windows.Foundation.Numerics.Vector2, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def DrawLineAtCoordsWithBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x0: Single, y0: Single, x1: Single, y1: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def DrawLineWithColor(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, point0: win32more.Windows.Foundation.Numerics.Vector2, point1: win32more.Windows.Foundation.Numerics.Vector2, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def DrawLineAtCoordsWithColor(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x0: Single, y0: Single, x1: Single, y1: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def DrawLineWithBrushAndStrokeWidth(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, point0: win32more.Windows.Foundation.Numerics.Vector2, point1: win32more.Windows.Foundation.Numerics.Vector2, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single) -> Void: ...
    @winrt_mixinmethod
    def DrawLineAtCoordsWithBrushAndStrokeWidth(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x0: Single, y0: Single, x1: Single, y1: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single) -> Void: ...
    @winrt_mixinmethod
    def DrawLineWithColorAndStrokeWidth(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, point0: win32more.Windows.Foundation.Numerics.Vector2, point1: win32more.Windows.Foundation.Numerics.Vector2, color: win32more.Windows.UI.Color, strokeWidth: Single) -> Void: ...
    @winrt_mixinmethod
    def DrawLineAtCoordsWithColorAndStrokeWidth(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x0: Single, y0: Single, x1: Single, y1: Single, color: win32more.Windows.UI.Color, strokeWidth: Single) -> Void: ...
    @winrt_mixinmethod
    def DrawLineWithBrushAndStrokeWidthAndStrokeStyle(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, point0: win32more.Windows.Foundation.Numerics.Vector2, point1: win32more.Windows.Foundation.Numerics.Vector2, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_mixinmethod
    def DrawLineAtCoordsWithBrushAndStrokeWidthAndStrokeStyle(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x0: Single, y0: Single, x1: Single, y1: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_mixinmethod
    def DrawLineWithColorAndStrokeWidthAndStrokeStyle(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, point0: win32more.Windows.Foundation.Numerics.Vector2, point1: win32more.Windows.Foundation.Numerics.Vector2, color: win32more.Windows.UI.Color, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_mixinmethod
    def DrawLineAtCoordsWithColorAndStrokeWidthAndStrokeStyle(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x0: Single, y0: Single, x1: Single, y1: Single, color: win32more.Windows.UI.Color, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_mixinmethod
    def DrawRectangleWithBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, rect: win32more.Windows.Foundation.Rect, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def DrawRectangleAtCoordsWithBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x: Single, y: Single, w: Single, h: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def DrawRectangleWithColor(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, rect: win32more.Windows.Foundation.Rect, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def DrawRectangleAtCoordsWithColor(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x: Single, y: Single, w: Single, h: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def DrawRectangleWithBrushAndStrokeWidth(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, rect: win32more.Windows.Foundation.Rect, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single) -> Void: ...
    @winrt_mixinmethod
    def DrawRectangleAtCoordsWithBrushAndStrokeWidth(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x: Single, y: Single, w: Single, h: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single) -> Void: ...
    @winrt_mixinmethod
    def DrawRectangleWithColorAndStrokeWidth(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, rect: win32more.Windows.Foundation.Rect, color: win32more.Windows.UI.Color, strokeWidth: Single) -> Void: ...
    @winrt_mixinmethod
    def DrawRectangleAtCoordsWithColorAndStrokeWidth(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x: Single, y: Single, w: Single, h: Single, color: win32more.Windows.UI.Color, strokeWidth: Single) -> Void: ...
    @winrt_mixinmethod
    def DrawRectangleWithBrushAndStrokeWidthAndStrokeStyle(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, rect: win32more.Windows.Foundation.Rect, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_mixinmethod
    def DrawRectangleAtCoordsWithBrushAndStrokeWidthAndStrokeStyle(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x: Single, y: Single, w: Single, h: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_mixinmethod
    def DrawRectangleWithColorAndStrokeWidthAndStrokeStyle(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, rect: win32more.Windows.Foundation.Rect, color: win32more.Windows.UI.Color, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_mixinmethod
    def DrawRectangleAtCoordsWithColorAndStrokeWidthAndStrokeStyle(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x: Single, y: Single, w: Single, h: Single, color: win32more.Windows.UI.Color, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_mixinmethod
    def FillRectangleWithBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, rect: win32more.Windows.Foundation.Rect, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def FillRectangleAtCoordsWithBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x: Single, y: Single, w: Single, h: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def FillRectangleWithColor(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, rect: win32more.Windows.Foundation.Rect, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def FillRectangleAtCoordsWithColor(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x: Single, y: Single, w: Single, h: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def FillRectangleWithBrushAndOpacityBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, rect: win32more.Windows.Foundation.Rect, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, opacityBrush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def FillRectangleAtCoordsWithBrushAndOpacityBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x: Single, y: Single, w: Single, h: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, opacityBrush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def DrawRoundedRectangleWithBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, rect: win32more.Windows.Foundation.Rect, radiusX: Single, radiusY: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def DrawRoundedRectangleAtCoordsWithBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x: Single, y: Single, w: Single, h: Single, radiusX: Single, radiusY: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def DrawRoundedRectangleWithColor(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, rect: win32more.Windows.Foundation.Rect, radiusX: Single, radiusY: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def DrawRoundedRectangleAtCoordsWithColor(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x: Single, y: Single, w: Single, h: Single, radiusX: Single, radiusY: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def DrawRoundedRectangleWithBrushAndStrokeWidth(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, rect: win32more.Windows.Foundation.Rect, radiusX: Single, radiusY: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single) -> Void: ...
    @winrt_mixinmethod
    def DrawRoundedRectangleAtCoordsWithBrushAndStrokeWidth(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x: Single, y: Single, w: Single, h: Single, radiusX: Single, radiusY: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single) -> Void: ...
    @winrt_mixinmethod
    def DrawRoundedRectangleWithColorAndStrokeWidth(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, rect: win32more.Windows.Foundation.Rect, radiusX: Single, radiusY: Single, color: win32more.Windows.UI.Color, strokeWidth: Single) -> Void: ...
    @winrt_mixinmethod
    def DrawRoundedRectangleAtCoordsWithColorAndStrokeWidth(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x: Single, y: Single, w: Single, h: Single, radiusX: Single, radiusY: Single, color: win32more.Windows.UI.Color, strokeWidth: Single) -> Void: ...
    @winrt_mixinmethod
    def DrawRoundedRectangleWithBrushAndStrokeWidthAndStrokeStyle(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, rect: win32more.Windows.Foundation.Rect, radiusX: Single, radiusY: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_mixinmethod
    def DrawRoundedRectangleAtCoordsWithBrushAndStrokeWidthAndStrokeStyle(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x: Single, y: Single, w: Single, h: Single, radiusX: Single, radiusY: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_mixinmethod
    def DrawRoundedRectangleWithColorAndStrokeWidthAndStrokeStyle(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, rect: win32more.Windows.Foundation.Rect, radiusX: Single, radiusY: Single, color: win32more.Windows.UI.Color, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_mixinmethod
    def DrawRoundedRectangleAtCoordsWithColorAndStrokeWidthAndStrokeStyle(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x: Single, y: Single, w: Single, h: Single, radiusX: Single, radiusY: Single, color: win32more.Windows.UI.Color, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_mixinmethod
    def FillRoundedRectangleWithBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, rect: win32more.Windows.Foundation.Rect, radiusX: Single, radiusY: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def FillRoundedRectangleAtCoordsWithBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x: Single, y: Single, w: Single, h: Single, radiusX: Single, radiusY: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def FillRoundedRectangleWithColor(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, rect: win32more.Windows.Foundation.Rect, radiusX: Single, radiusY: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def FillRoundedRectangleAtCoordsWithColor(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x: Single, y: Single, w: Single, h: Single, radiusX: Single, radiusY: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def DrawEllipseWithBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radiusX: Single, radiusY: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def DrawEllipseAtCoordsWithBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x: Single, y: Single, radiusX: Single, radiusY: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def DrawEllipseWithColor(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radiusX: Single, radiusY: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def DrawEllipseAtCoordsWithColor(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x: Single, y: Single, radiusX: Single, radiusY: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def DrawEllipseWithBrushAndStrokeWidth(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radiusX: Single, radiusY: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single) -> Void: ...
    @winrt_mixinmethod
    def DrawEllipseAtCoordsWithBrushAndStrokeWidth(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x: Single, y: Single, radiusX: Single, radiusY: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single) -> Void: ...
    @winrt_mixinmethod
    def DrawEllipseWithColorAndStrokeWidth(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radiusX: Single, radiusY: Single, color: win32more.Windows.UI.Color, strokeWidth: Single) -> Void: ...
    @winrt_mixinmethod
    def DrawEllipseAtCoordsWithColorAndStrokeWidth(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x: Single, y: Single, radiusX: Single, radiusY: Single, color: win32more.Windows.UI.Color, strokeWidth: Single) -> Void: ...
    @winrt_mixinmethod
    def DrawEllipseWithBrushAndStrokeWidthAndStrokeStyle(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radiusX: Single, radiusY: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_mixinmethod
    def DrawEllipseAtCoordsWithBrushAndStrokeWidthAndStrokeStyle(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x: Single, y: Single, radiusX: Single, radiusY: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_mixinmethod
    def DrawEllipseWithColorAndStrokeWidthAndStrokeStyle(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radiusX: Single, radiusY: Single, color: win32more.Windows.UI.Color, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_mixinmethod
    def DrawEllipseAtCoordsWithColorAndStrokeWidthAndStrokeStyle(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x: Single, y: Single, radiusX: Single, radiusY: Single, color: win32more.Windows.UI.Color, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_mixinmethod
    def FillEllipseWithBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radiusX: Single, radiusY: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def FillEllipseAtCoordsWithBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x: Single, y: Single, radiusX: Single, radiusY: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def FillEllipseWithColor(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radiusX: Single, radiusY: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def FillEllipseAtCoordsWithColor(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x: Single, y: Single, radiusX: Single, radiusY: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def DrawCircleWithBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radius: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def DrawCircleAtCoordsWithBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x: Single, y: Single, radius: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def DrawCircleWithColor(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radius: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def DrawCircleAtCoordsWithColor(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x: Single, y: Single, radius: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def DrawCircleWithBrushAndStrokeWidth(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radius: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single) -> Void: ...
    @winrt_mixinmethod
    def DrawCircleAtCoordsWithBrushAndStrokeWidth(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x: Single, y: Single, radius: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single) -> Void: ...
    @winrt_mixinmethod
    def DrawCircleWithColorAndStrokeWidth(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radius: Single, color: win32more.Windows.UI.Color, strokeWidth: Single) -> Void: ...
    @winrt_mixinmethod
    def DrawCircleAtCoordsWithColorAndStrokeWidth(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x: Single, y: Single, radius: Single, color: win32more.Windows.UI.Color, strokeWidth: Single) -> Void: ...
    @winrt_mixinmethod
    def DrawCircleWithBrushAndStrokeWidthAndStrokeStyle(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radius: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_mixinmethod
    def DrawCircleAtCoordsWithBrushAndStrokeWidthAndStrokeStyle(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x: Single, y: Single, radius: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_mixinmethod
    def DrawCircleWithColorAndStrokeWidthAndStrokeStyle(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radius: Single, color: win32more.Windows.UI.Color, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_mixinmethod
    def DrawCircleAtCoordsWithColorAndStrokeWidthAndStrokeStyle(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x: Single, y: Single, radius: Single, color: win32more.Windows.UI.Color, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_mixinmethod
    def FillCircleWithBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radius: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def FillCircleAtCoordsWithBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x: Single, y: Single, radius: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def FillCircleWithColor(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radius: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def FillCircleAtCoordsWithColor(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, x: Single, y: Single, radius: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def DrawTextAtPointWithColor(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, text: WinRT_String, point: win32more.Windows.Foundation.Numerics.Vector2, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def DrawTextAtPointCoordsWithColor(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, text: WinRT_String, x: Single, y: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def DrawTextAtPointWithBrushAndFormat(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, text: WinRT_String, point: win32more.Windows.Foundation.Numerics.Vector2, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, format: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextFormat) -> Void: ...
    @winrt_mixinmethod
    def DrawTextAtRectWithBrushAndFormat(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, text: WinRT_String, rectangle: win32more.Windows.Foundation.Rect, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, format: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextFormat) -> Void: ...
    @winrt_mixinmethod
    def DrawTextAtPointCoordsWithBrushAndFormat(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, text: WinRT_String, x: Single, y: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, format: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextFormat) -> Void: ...
    @winrt_mixinmethod
    def DrawTextAtRectCoordsWithBrushAndFormat(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, text: WinRT_String, x: Single, y: Single, w: Single, h: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, format: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextFormat) -> Void: ...
    @winrt_mixinmethod
    def DrawTextAtPointWithColorAndFormat(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, text: WinRT_String, point: win32more.Windows.Foundation.Numerics.Vector2, color: win32more.Windows.UI.Color, format: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextFormat) -> Void: ...
    @winrt_mixinmethod
    def DrawTextAtRectWithColorAndFormat(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, text: WinRT_String, rectangle: win32more.Windows.Foundation.Rect, color: win32more.Windows.UI.Color, format: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextFormat) -> Void: ...
    @winrt_mixinmethod
    def DrawTextAtPointCoordsWithColorAndFormat(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, text: WinRT_String, x: Single, y: Single, color: win32more.Windows.UI.Color, format: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextFormat) -> Void: ...
    @winrt_mixinmethod
    def DrawTextAtRectCoordsWithColorAndFormat(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, text: WinRT_String, x: Single, y: Single, w: Single, h: Single, color: win32more.Windows.UI.Color, format: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextFormat) -> Void: ...
    @winrt_mixinmethod
    def DrawGeometryWithBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, offset: win32more.Windows.Foundation.Numerics.Vector2, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def DrawGeometryWithColor(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, offset: win32more.Windows.Foundation.Numerics.Vector2, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def DrawGeometryAtCoordsWithBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, x: Single, y: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def DrawGeometryAtCoordsWithColor(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, x: Single, y: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def DrawGeometryAtOriginWithBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def DrawGeometryAtOriginWithColor(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def DrawGeometryWithBrushAndStrokeWidth(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, offset: win32more.Windows.Foundation.Numerics.Vector2, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single) -> Void: ...
    @winrt_mixinmethod
    def DrawGeometryWithColorAndStrokeWidth(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, offset: win32more.Windows.Foundation.Numerics.Vector2, color: win32more.Windows.UI.Color, strokeWidth: Single) -> Void: ...
    @winrt_mixinmethod
    def DrawGeometryAtCoordsWithBrushAndStrokeWidth(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, x: Single, y: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single) -> Void: ...
    @winrt_mixinmethod
    def DrawGeometryAtCoordsWithColorAndStrokeWidth(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, x: Single, y: Single, color: win32more.Windows.UI.Color, strokeWidth: Single) -> Void: ...
    @winrt_mixinmethod
    def DrawGeometryAtOriginWithBrushAndStrokeWidth(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single) -> Void: ...
    @winrt_mixinmethod
    def DrawGeometryAtOriginWithColorAndStrokeWidth(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, color: win32more.Windows.UI.Color, strokeWidth: Single) -> Void: ...
    @winrt_mixinmethod
    def DrawGeometryWithBrushAndStrokeWidthAndStrokeStyle(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, offset: win32more.Windows.Foundation.Numerics.Vector2, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_mixinmethod
    def DrawGeometryWithColorAndStrokeWidthAndStrokeStyle(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, offset: win32more.Windows.Foundation.Numerics.Vector2, color: win32more.Windows.UI.Color, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_mixinmethod
    def DrawGeometryAtCoordsWithBrushAndStrokeWidthAndStrokeStyle(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, x: Single, y: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_mixinmethod
    def DrawGeometryAtCoordsWithColorAndStrokeWidthAndStrokeStyle(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, x: Single, y: Single, color: win32more.Windows.UI.Color, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_mixinmethod
    def DrawGeometryAtOriginWithBrushAndStrokeWidthAndStrokeStyle(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_mixinmethod
    def DrawGeometryAtOriginWithColorAndStrokeWidthAndStrokeStyle(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, color: win32more.Windows.UI.Color, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_mixinmethod
    def FillGeometryWithBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, offset: win32more.Windows.Foundation.Numerics.Vector2, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def FillGeometryWithBrushAndOpacityBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, offset: win32more.Windows.Foundation.Numerics.Vector2, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, opacityBrush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def FillGeometryWithColor(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, offset: win32more.Windows.Foundation.Numerics.Vector2, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def FillGeometryAtCoordsWithBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, x: Single, y: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def FillGeometryAtCoordsWithBrushAndOpacityBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, x: Single, y: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, opacityBrush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def FillGeometryAtCoordsWithColor(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, x: Single, y: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def FillGeometryAtOriginWithBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def FillGeometryAtOriginWithBrushAndOpacityBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, opacityBrush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def FillGeometryAtOriginWithColor(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def DrawCachedGeometryWithBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCachedGeometry, offset: win32more.Windows.Foundation.Numerics.Vector2, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def DrawCachedGeometryWithColor(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCachedGeometry, offset: win32more.Windows.Foundation.Numerics.Vector2, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def DrawCachedGeometryAtCoordsWithBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCachedGeometry, x: Single, y: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def DrawCachedGeometryAtCoordsWithColor(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCachedGeometry, x: Single, y: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def DrawCachedGeometryAtOriginWithBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCachedGeometry, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def DrawCachedGeometryAtOriginWithColor(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCachedGeometry, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def DrawTextLayoutWithBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, textLayout: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextLayout, point: win32more.Windows.Foundation.Numerics.Vector2, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def DrawTextLayoutAtCoordsWithBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, textLayout: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextLayout, x: Single, y: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def DrawTextLayoutWithColor(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, textLayout: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextLayout, point: win32more.Windows.Foundation.Numerics.Vector2, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def DrawTextLayoutAtCoordsWithColor(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, textLayout: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextLayout, x: Single, y: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def DrawGradientMeshAtOrigin(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, gradientMesh: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGradientMesh) -> Void: ...
    @winrt_mixinmethod
    def DrawGradientMesh(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, gradientMesh: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGradientMesh, point: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_mixinmethod
    def DrawGradientMeshAtCoords(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, gradientMesh: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGradientMesh, x: Single, y: Single) -> Void: ...
    @winrt_mixinmethod
    def DrawSvgAtOrigin(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, svgDocument: win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgDocument, viewportSize: win32more.Windows.Foundation.Size) -> Void: ...
    @winrt_mixinmethod
    def DrawSvgAtPoint(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, svgDocument: win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgDocument, viewportSize: win32more.Windows.Foundation.Size, point: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_mixinmethod
    def DrawSvgAtCoords(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, svgDocument: win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgDocument, viewportSize: win32more.Windows.Foundation.Size, x: Single, y: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Antialiasing(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession) -> win32more.Microsoft.Graphics.Canvas.CanvasAntialiasing: ...
    @winrt_mixinmethod
    def put_Antialiasing(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, value: win32more.Microsoft.Graphics.Canvas.CanvasAntialiasing) -> Void: ...
    @winrt_mixinmethod
    def get_Blend(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession) -> win32more.Microsoft.Graphics.Canvas.CanvasBlend: ...
    @winrt_mixinmethod
    def put_Blend(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, value: win32more.Microsoft.Graphics.Canvas.CanvasBlend) -> Void: ...
    @winrt_mixinmethod
    def get_TextAntialiasing(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession) -> win32more.Microsoft.Graphics.Canvas.Text.CanvasTextAntialiasing: ...
    @winrt_mixinmethod
    def put_TextAntialiasing(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, value: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextAntialiasing) -> Void: ...
    @winrt_mixinmethod
    def get_TextRenderingParameters(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession) -> win32more.Microsoft.Graphics.Canvas.Text.CanvasTextRenderingParameters: ...
    @winrt_mixinmethod
    def put_TextRenderingParameters(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, value: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextRenderingParameters) -> Void: ...
    @winrt_mixinmethod
    def get_Transform(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession) -> win32more.Windows.Foundation.Numerics.Matrix3x2: ...
    @winrt_mixinmethod
    def put_Transform(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, value: win32more.Windows.Foundation.Numerics.Matrix3x2) -> Void: ...
    @winrt_mixinmethod
    def get_Units(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession) -> win32more.Microsoft.Graphics.Canvas.CanvasUnits: ...
    @winrt_mixinmethod
    def put_Units(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, value: win32more.Microsoft.Graphics.Canvas.CanvasUnits) -> Void: ...
    @winrt_mixinmethod
    def get_EffectBufferPrecision(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_EffectBufferPrecision(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def get_EffectTileSize(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession) -> win32more.Windows.Graphics.Imaging.BitmapSize: ...
    @winrt_mixinmethod
    def put_EffectTileSize(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, value: win32more.Windows.Graphics.Imaging.BitmapSize) -> Void: ...
    @winrt_mixinmethod
    def CreateLayerWithOpacity(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, opacity: Single) -> win32more.Microsoft.Graphics.Canvas.CanvasActiveLayer: ...
    @winrt_mixinmethod
    def CreateLayerWithOpacityBrush(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, opacityBrush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> win32more.Microsoft.Graphics.Canvas.CanvasActiveLayer: ...
    @winrt_mixinmethod
    def CreateLayerWithOpacityAndClipRectangle(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, opacity: Single, clipRectangle: win32more.Windows.Foundation.Rect) -> win32more.Microsoft.Graphics.Canvas.CanvasActiveLayer: ...
    @winrt_mixinmethod
    def CreateLayerWithOpacityBrushAndClipRectangle(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, opacityBrush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, clipRectangle: win32more.Windows.Foundation.Rect) -> win32more.Microsoft.Graphics.Canvas.CanvasActiveLayer: ...
    @winrt_mixinmethod
    def CreateLayerWithOpacityAndClipGeometry(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, opacity: Single, clipGeometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry) -> win32more.Microsoft.Graphics.Canvas.CanvasActiveLayer: ...
    @winrt_mixinmethod
    def CreateLayerWithOpacityBrushAndClipGeometry(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, opacityBrush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, clipGeometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry) -> win32more.Microsoft.Graphics.Canvas.CanvasActiveLayer: ...
    @winrt_mixinmethod
    def CreateLayerWithOpacityAndClipGeometryAndTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, opacity: Single, clipGeometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, geometryTransform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Microsoft.Graphics.Canvas.CanvasActiveLayer: ...
    @winrt_mixinmethod
    def CreateLayerWithOpacityBrushAndClipGeometryAndTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, opacityBrush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, clipGeometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, geometryTransform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Microsoft.Graphics.Canvas.CanvasActiveLayer: ...
    @winrt_mixinmethod
    def CreateLayerWithAllOptions(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, opacity: Single, opacityBrush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, clipRectangle: win32more.Windows.Foundation.Rect, clipGeometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, geometryTransform: win32more.Windows.Foundation.Numerics.Matrix3x2, options: win32more.Microsoft.Graphics.Canvas.CanvasLayerOptions) -> win32more.Microsoft.Graphics.Canvas.CanvasActiveLayer: ...
    @winrt_mixinmethod
    def DrawGlyphRun(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, point: win32more.Windows.Foundation.Numerics.Vector2, fontFace: win32more.Microsoft.Graphics.Canvas.Text.CanvasFontFace, fontSize: Single, glyphs: PassArray[win32more.Microsoft.Graphics.Canvas.Text.CanvasGlyph], isSideways: Boolean, bidiLevel: UInt32, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_mixinmethod
    def DrawGlyphRunWithMeasuringMode(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, point: win32more.Windows.Foundation.Numerics.Vector2, fontFace: win32more.Microsoft.Graphics.Canvas.Text.CanvasFontFace, fontSize: Single, glyphs: PassArray[win32more.Microsoft.Graphics.Canvas.Text.CanvasGlyph], isSideways: Boolean, bidiLevel: UInt32, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, measuringMode: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextMeasuringMode) -> Void: ...
    @winrt_mixinmethod
    def DrawGlyphRunWithMeasuringModeAndDescription(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, point: win32more.Windows.Foundation.Numerics.Vector2, fontFace: win32more.Microsoft.Graphics.Canvas.Text.CanvasFontFace, fontSize: Single, glyphs: PassArray[win32more.Microsoft.Graphics.Canvas.Text.CanvasGlyph], isSideways: Boolean, bidiLevel: UInt32, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, measuringMode: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextMeasuringMode, localeName: WinRT_String, textString: WinRT_String, clusterMapIndices: PassArray[Int32], textPosition: UInt32) -> Void: ...
    @winrt_mixinmethod
    def CreateSpriteBatch(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession) -> win32more.Microsoft.Graphics.Canvas.CanvasSpriteBatch: ...
    @winrt_mixinmethod
    def CreateSpriteBatchWithSortMode(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, sortMode: win32more.Microsoft.Graphics.Canvas.CanvasSpriteSortMode) -> win32more.Microsoft.Graphics.Canvas.CanvasSpriteBatch: ...
    @winrt_mixinmethod
    def CreateSpriteBatchWithSortModeAndInterpolation(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, sortMode: win32more.Microsoft.Graphics.Canvas.CanvasSpriteSortMode, interpolation: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> win32more.Microsoft.Graphics.Canvas.CanvasSpriteBatch: ...
    @winrt_mixinmethod
    def CreateSpriteBatchWithSortModeAndInterpolationAndOptions(self: win32more.Microsoft.Graphics.Canvas.ICanvasDrawingSession, sortMode: win32more.Microsoft.Graphics.Canvas.CanvasSpriteSortMode, interpolation: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation, options: win32more.Microsoft.Graphics.Canvas.CanvasSpriteOptions) -> win32more.Microsoft.Graphics.Canvas.CanvasSpriteBatch: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    @winrt_mixinmethod
    def get_Dpi(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> Single: ...
    @winrt_mixinmethod
    def ConvertPixelsToDips(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, pixels: Int32) -> Single: ...
    @winrt_mixinmethod
    def ConvertDipsToPixels(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, dips: Single, dpiRounding: win32more.Microsoft.Graphics.Canvas.CanvasDpiRounding) -> Int32: ...
    @winrt_mixinmethod
    def get_Device(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    Antialiasing = property(get_Antialiasing, put_Antialiasing)
    Blend = property(get_Blend, put_Blend)
    Device = property(get_Device, None)
    Dpi = property(get_Dpi, None)
    EffectBufferPrecision = property(get_EffectBufferPrecision, put_EffectBufferPrecision)
    EffectTileSize = property(get_EffectTileSize, put_EffectTileSize)
    TextAntialiasing = property(get_TextAntialiasing, put_TextAntialiasing)
    TextRenderingParameters = property(get_TextRenderingParameters, put_TextRenderingParameters)
    Transform = property(get_Transform, put_Transform)
    Units = property(get_Units, put_Units)
class CanvasEdgeBehavior(Enum, Int32):
    Clamp = 0
    Wrap = 1
    Mirror = 2
class CanvasImage(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.CanvasImage'
    @winrt_classmethod
    def SaveAsync(cls: win32more.Microsoft.Graphics.Canvas.ICanvasImageStatics, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, sourceRectangle: win32more.Windows.Foundation.Rect, dpi: Single, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, stream: win32more.Windows.Storage.Streams.IRandomAccessStream, fileFormat: win32more.Microsoft.Graphics.Canvas.CanvasBitmapFileFormat) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_classmethod
    def SaveWithQualityAsync(cls: win32more.Microsoft.Graphics.Canvas.ICanvasImageStatics, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, sourceRectangle: win32more.Windows.Foundation.Rect, dpi: Single, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, stream: win32more.Windows.Storage.Streams.IRandomAccessStream, fileFormat: win32more.Microsoft.Graphics.Canvas.CanvasBitmapFileFormat, quality: Single) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_classmethod
    def SaveWithQualityAndBufferPrecisionAsync(cls: win32more.Microsoft.Graphics.Canvas.ICanvasImageStatics, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, sourceRectangle: win32more.Windows.Foundation.Rect, dpi: Single, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, stream: win32more.Windows.Storage.Streams.IRandomAccessStream, fileFormat: win32more.Microsoft.Graphics.Canvas.CanvasBitmapFileFormat, quality: Single, bufferPrecision: win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_classmethod
    def ComputeHistogram(cls: win32more.Microsoft.Graphics.Canvas.ICanvasImageStatics, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, sourceRectangle: win32more.Windows.Foundation.Rect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, channelSelect: win32more.Microsoft.Graphics.Canvas.Effects.EffectChannelSelect, numberOfBins: Int32) -> ReceiveArray[Single]: ...
    @winrt_classmethod
    def IsHistogramSupported(cls: win32more.Microsoft.Graphics.Canvas.ICanvasImageStatics, device: win32more.Microsoft.Graphics.Canvas.CanvasDevice) -> Boolean: ...
class CanvasImageInterpolation(Enum, Int32):
    NearestNeighbor = 0
    Linear = 1
    Cubic = 2
    MultiSampleLinear = 3
    Anisotropic = 4
    HighQualityCubic = 5
class CanvasLayerOptions(Enum, UInt32):
    None_ = 0
    InitializeFromBackground = 1
    IgnoreAlpha = 2
class CanvasLock(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.ICanvasLock
    _classid_ = 'Microsoft.Graphics.Canvas.CanvasLock'
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
class CanvasRenderTarget(ComPtr):
    extends: win32more.Microsoft.Graphics.Canvas.CanvasBitmap
    default_interface: win32more.Microsoft.Graphics.Canvas.ICanvasRenderTarget
    _classid_ = 'Microsoft.Graphics.Canvas.CanvasRenderTarget'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 2:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.CanvasRenderTarget.CreateWithSize(*args))
        elif len(args) == 3:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.CanvasRenderTarget.CreateWithWidthAndHeight(*args))
        elif len(args) == 4:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.CanvasRenderTarget.CreateWithWidthAndHeightAndDpi(*args))
        elif len(args) == 6:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.CanvasRenderTarget.CreateWithWidthAndHeightAndDpiAndFormatAndAlpha(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def CreateWithSize(cls: win32more.Microsoft.Graphics.Canvas.ICanvasRenderTargetFactory, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, size: win32more.Windows.Foundation.Size) -> win32more.Microsoft.Graphics.Canvas.CanvasRenderTarget: ...
    @winrt_factorymethod
    def CreateWithWidthAndHeight(cls: win32more.Microsoft.Graphics.Canvas.ICanvasRenderTargetFactory, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, width: Single, height: Single) -> win32more.Microsoft.Graphics.Canvas.CanvasRenderTarget: ...
    @winrt_factorymethod
    def CreateWithWidthAndHeightAndDpi(cls: win32more.Microsoft.Graphics.Canvas.ICanvasRenderTargetFactory, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, width: Single, height: Single, dpi: Single) -> win32more.Microsoft.Graphics.Canvas.CanvasRenderTarget: ...
    @winrt_factorymethod
    def CreateWithWidthAndHeightAndDpiAndFormatAndAlpha(cls: win32more.Microsoft.Graphics.Canvas.ICanvasRenderTargetFactory, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, width: Single, height: Single, dpi: Single, format: win32more.Windows.Graphics.DirectX.DirectXPixelFormat, alpha: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Microsoft.Graphics.Canvas.CanvasRenderTarget: ...
    @winrt_mixinmethod
    def CreateDrawingSession(self: win32more.Microsoft.Graphics.Canvas.ICanvasRenderTarget) -> win32more.Microsoft.Graphics.Canvas.CanvasDrawingSession: ...
    @winrt_classmethod
    def CreateFromDirect3D11Surface(cls: win32more.Microsoft.Graphics.Canvas.ICanvasRenderTargetStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, surface: win32more.Windows.Graphics.DirectX.Direct3D11.IDirect3DSurface) -> win32more.Microsoft.Graphics.Canvas.CanvasRenderTarget: ...
    @winrt_classmethod
    def CreateFromDirect3D11SurfaceWithDpi(cls: win32more.Microsoft.Graphics.Canvas.ICanvasRenderTargetStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, surface: win32more.Windows.Graphics.DirectX.Direct3D11.IDirect3DSurface, dpi: Single) -> win32more.Microsoft.Graphics.Canvas.CanvasRenderTarget: ...
    @winrt_classmethod
    def CreateFromDirect3D11SurfaceWithDpiAndAlpha(cls: win32more.Microsoft.Graphics.Canvas.ICanvasRenderTargetStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, surface: win32more.Windows.Graphics.DirectX.Direct3D11.IDirect3DSurface, dpi: Single, alpha: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Microsoft.Graphics.Canvas.CanvasRenderTarget: ...
class CanvasSpriteBatch(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.ICanvasSpriteBatch
    _classid_ = 'Microsoft.Graphics.Canvas.CanvasSpriteBatch'
    @winrt_mixinmethod
    def DrawToRect(self: win32more.Microsoft.Graphics.Canvas.ICanvasSpriteBatch, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, destRect: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def DrawAtOffset(self: win32more.Microsoft.Graphics.Canvas.ICanvasSpriteBatch, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, offset: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_mixinmethod
    def DrawWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasSpriteBatch, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> Void: ...
    @winrt_mixinmethod
    def DrawToRectWithTint(self: win32more.Microsoft.Graphics.Canvas.ICanvasSpriteBatch, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, destRect: win32more.Windows.Foundation.Rect, tint: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_mixinmethod
    def DrawAtOffsetWithTint(self: win32more.Microsoft.Graphics.Canvas.ICanvasSpriteBatch, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, offset: win32more.Windows.Foundation.Numerics.Vector2, tint: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_mixinmethod
    def DrawWithTransformAndTint(self: win32more.Microsoft.Graphics.Canvas.ICanvasSpriteBatch, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, transform: win32more.Windows.Foundation.Numerics.Matrix3x2, tint: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_mixinmethod
    def DrawToRectWithTintAndFlip(self: win32more.Microsoft.Graphics.Canvas.ICanvasSpriteBatch, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, destRect: win32more.Windows.Foundation.Rect, tint: win32more.Windows.Foundation.Numerics.Vector4, flip: win32more.Microsoft.Graphics.Canvas.CanvasSpriteFlip) -> Void: ...
    @winrt_mixinmethod
    def DrawWithTransformAndTintAndFlip(self: win32more.Microsoft.Graphics.Canvas.ICanvasSpriteBatch, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, transform: win32more.Windows.Foundation.Numerics.Matrix3x2, tint: win32more.Windows.Foundation.Numerics.Vector4, flip: win32more.Microsoft.Graphics.Canvas.CanvasSpriteFlip) -> Void: ...
    @winrt_mixinmethod
    def DrawAtOffsetWithTintAndTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasSpriteBatch, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, offset: win32more.Windows.Foundation.Numerics.Vector2, tint: win32more.Windows.Foundation.Numerics.Vector4, origin: win32more.Windows.Foundation.Numerics.Vector2, rotation: Single, scale: win32more.Windows.Foundation.Numerics.Vector2, flip: win32more.Microsoft.Graphics.Canvas.CanvasSpriteFlip) -> Void: ...
    @winrt_mixinmethod
    def DrawFromSpriteSheetToRect(self: win32more.Microsoft.Graphics.Canvas.ICanvasSpriteBatch, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, destRect: win32more.Windows.Foundation.Rect, sourceRect: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def DrawFromSpriteSheetAtOffset(self: win32more.Microsoft.Graphics.Canvas.ICanvasSpriteBatch, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, offset: win32more.Windows.Foundation.Numerics.Vector2, sourceRect: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def DrawFromSpriteSheetWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasSpriteBatch, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, transform: win32more.Windows.Foundation.Numerics.Matrix3x2, sourceRect: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def DrawFromSpriteSheetToRectWithTint(self: win32more.Microsoft.Graphics.Canvas.ICanvasSpriteBatch, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, destRect: win32more.Windows.Foundation.Rect, sourceRect: win32more.Windows.Foundation.Rect, tint: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_mixinmethod
    def DrawFromSpriteSheetAtOffsetWithTint(self: win32more.Microsoft.Graphics.Canvas.ICanvasSpriteBatch, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, offset: win32more.Windows.Foundation.Numerics.Vector2, sourceRect: win32more.Windows.Foundation.Rect, tint: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_mixinmethod
    def DrawFromSpriteSheetWithTransformAndTint(self: win32more.Microsoft.Graphics.Canvas.ICanvasSpriteBatch, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, transform: win32more.Windows.Foundation.Numerics.Matrix3x2, sourceRect: win32more.Windows.Foundation.Rect, tint: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_mixinmethod
    def DrawFromSpriteSheetToRectWithTintAndFlip(self: win32more.Microsoft.Graphics.Canvas.ICanvasSpriteBatch, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, destRect: win32more.Windows.Foundation.Rect, sourceRect: win32more.Windows.Foundation.Rect, tint: win32more.Windows.Foundation.Numerics.Vector4, flip: win32more.Microsoft.Graphics.Canvas.CanvasSpriteFlip) -> Void: ...
    @winrt_mixinmethod
    def DrawFromSpriteSheetWithTransformAndTintAndFlip(self: win32more.Microsoft.Graphics.Canvas.ICanvasSpriteBatch, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, transform: win32more.Windows.Foundation.Numerics.Matrix3x2, sourceRect: win32more.Windows.Foundation.Rect, tint: win32more.Windows.Foundation.Numerics.Vector4, flip: win32more.Microsoft.Graphics.Canvas.CanvasSpriteFlip) -> Void: ...
    @winrt_mixinmethod
    def DrawFromSpriteSheetAtOffsetWithTintAndTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasSpriteBatch, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, offset: win32more.Windows.Foundation.Numerics.Vector2, sourceRect: win32more.Windows.Foundation.Rect, tint: win32more.Windows.Foundation.Numerics.Vector4, origin: win32more.Windows.Foundation.Numerics.Vector2, rotation: Single, scale: win32more.Windows.Foundation.Numerics.Vector2, flip: win32more.Microsoft.Graphics.Canvas.CanvasSpriteFlip) -> Void: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    @winrt_mixinmethod
    def get_Dpi(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> Single: ...
    @winrt_mixinmethod
    def ConvertPixelsToDips(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, pixels: Int32) -> Single: ...
    @winrt_mixinmethod
    def ConvertDipsToPixels(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, dips: Single, dpiRounding: win32more.Microsoft.Graphics.Canvas.CanvasDpiRounding) -> Int32: ...
    @winrt_mixinmethod
    def get_Device(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    @winrt_classmethod
    def IsSupported(cls: win32more.Microsoft.Graphics.Canvas.ICanvasSpriteBatchStatics, device: win32more.Microsoft.Graphics.Canvas.CanvasDevice) -> Boolean: ...
    Device = property(get_Device, None)
    Dpi = property(get_Dpi, None)
class CanvasSpriteFlip(Enum, UInt32):
    None_ = 0
    Horizontal = 1
    Vertical = 2
    Both = 3
class CanvasSpriteOptions(Enum, UInt32):
    None_ = 0
    ClampToSourceRect = 1
class CanvasSpriteSortMode(Enum, Int32):
    None_ = 0
    Bitmap = 1
class CanvasSwapChain(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.ICanvasSwapChain
    _classid_ = 'Microsoft.Graphics.Canvas.CanvasSwapChain'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 2:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.CanvasSwapChain.CreateWithSize(*args))
        elif len(args) == 3:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.CanvasSwapChain.CreateWithWidthAndHeight(*args))
        elif len(args) == 4:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.CanvasSwapChain.CreateWithWidthAndHeightAndDpi(*args))
        elif len(args) == 7:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.CanvasSwapChain.CreateWithAllOptions(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def CreateWithSize(cls: win32more.Microsoft.Graphics.Canvas.ICanvasSwapChainFactory, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, size: win32more.Windows.Foundation.Size) -> win32more.Microsoft.Graphics.Canvas.CanvasSwapChain: ...
    @winrt_factorymethod
    def CreateWithWidthAndHeight(cls: win32more.Microsoft.Graphics.Canvas.ICanvasSwapChainFactory, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, width: Single, height: Single) -> win32more.Microsoft.Graphics.Canvas.CanvasSwapChain: ...
    @winrt_factorymethod
    def CreateWithWidthAndHeightAndDpi(cls: win32more.Microsoft.Graphics.Canvas.ICanvasSwapChainFactory, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, width: Single, height: Single, dpi: Single) -> win32more.Microsoft.Graphics.Canvas.CanvasSwapChain: ...
    @winrt_factorymethod
    def CreateWithAllOptions(cls: win32more.Microsoft.Graphics.Canvas.ICanvasSwapChainFactory, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, width: Single, height: Single, dpi: Single, format: win32more.Windows.Graphics.DirectX.DirectXPixelFormat, bufferCount: Int32, alphaMode: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Microsoft.Graphics.Canvas.CanvasSwapChain: ...
    @winrt_mixinmethod
    def Present(self: win32more.Microsoft.Graphics.Canvas.ICanvasSwapChain) -> Void: ...
    @winrt_mixinmethod
    def PresentWithSyncInterval(self: win32more.Microsoft.Graphics.Canvas.ICanvasSwapChain, syncInterval: Int32) -> Void: ...
    @winrt_mixinmethod
    def ResizeBuffersWithSize(self: win32more.Microsoft.Graphics.Canvas.ICanvasSwapChain, newSize: win32more.Windows.Foundation.Size) -> Void: ...
    @winrt_mixinmethod
    def ResizeBuffersWithWidthAndHeight(self: win32more.Microsoft.Graphics.Canvas.ICanvasSwapChain, newWidth: Single, newHeight: Single) -> Void: ...
    @winrt_mixinmethod
    def ResizeBuffersWithWidthAndHeightAndDpi(self: win32more.Microsoft.Graphics.Canvas.ICanvasSwapChain, newWidth: Single, newHeight: Single, newDpi: Single) -> Void: ...
    @winrt_mixinmethod
    def ResizeBuffersWithAllOptions(self: win32more.Microsoft.Graphics.Canvas.ICanvasSwapChain, newWidth: Single, newHeight: Single, newDpi: Single, newFormat: win32more.Windows.Graphics.DirectX.DirectXPixelFormat, bufferCount: Int32) -> Void: ...
    @winrt_mixinmethod
    def get_Size(self: win32more.Microsoft.Graphics.Canvas.ICanvasSwapChain) -> win32more.Windows.Foundation.Size: ...
    @winrt_mixinmethod
    def get_SizeInPixels(self: win32more.Microsoft.Graphics.Canvas.ICanvasSwapChain) -> win32more.Windows.Graphics.Imaging.BitmapSize: ...
    @winrt_mixinmethod
    def get_Format(self: win32more.Microsoft.Graphics.Canvas.ICanvasSwapChain) -> win32more.Windows.Graphics.DirectX.DirectXPixelFormat: ...
    @winrt_mixinmethod
    def get_BufferCount(self: win32more.Microsoft.Graphics.Canvas.ICanvasSwapChain) -> Int32: ...
    @winrt_mixinmethod
    def get_AlphaMode(self: win32more.Microsoft.Graphics.Canvas.ICanvasSwapChain) -> win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode: ...
    @winrt_mixinmethod
    def get_Rotation(self: win32more.Microsoft.Graphics.Canvas.ICanvasSwapChain) -> win32more.Microsoft.Graphics.Canvas.CanvasSwapChainRotation: ...
    @winrt_mixinmethod
    def put_Rotation(self: win32more.Microsoft.Graphics.Canvas.ICanvasSwapChain, value: win32more.Microsoft.Graphics.Canvas.CanvasSwapChainRotation) -> Void: ...
    @winrt_mixinmethod
    def get_SourceSize(self: win32more.Microsoft.Graphics.Canvas.ICanvasSwapChain) -> win32more.Windows.Foundation.Size: ...
    @winrt_mixinmethod
    def put_SourceSize(self: win32more.Microsoft.Graphics.Canvas.ICanvasSwapChain, value: win32more.Windows.Foundation.Size) -> Void: ...
    @winrt_mixinmethod
    def get_TransformMatrix(self: win32more.Microsoft.Graphics.Canvas.ICanvasSwapChain) -> win32more.Windows.Foundation.Numerics.Matrix3x2: ...
    @winrt_mixinmethod
    def put_TransformMatrix(self: win32more.Microsoft.Graphics.Canvas.ICanvasSwapChain, value: win32more.Windows.Foundation.Numerics.Matrix3x2) -> Void: ...
    @winrt_mixinmethod
    def CreateDrawingSession(self: win32more.Microsoft.Graphics.Canvas.ICanvasSwapChain, clearColor: win32more.Windows.UI.Color) -> win32more.Microsoft.Graphics.Canvas.CanvasDrawingSession: ...
    @winrt_mixinmethod
    def WaitForVerticalBlank(self: win32more.Microsoft.Graphics.Canvas.ICanvasSwapChain) -> Void: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    @winrt_mixinmethod
    def get_Dpi(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> Single: ...
    @winrt_mixinmethod
    def ConvertPixelsToDips(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, pixels: Int32) -> Single: ...
    @winrt_mixinmethod
    def ConvertDipsToPixels(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, dips: Single, dpiRounding: win32more.Microsoft.Graphics.Canvas.CanvasDpiRounding) -> Int32: ...
    @winrt_mixinmethod
    def get_Device(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    @winrt_classmethod
    def CreateForCoreWindowWithDpi(cls: win32more.Microsoft.Graphics.Canvas.ICanvasSwapChainStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, coreWindow: win32more.Windows.UI.Core.CoreWindow, dpi: Single) -> win32more.Microsoft.Graphics.Canvas.CanvasSwapChain: ...
    @winrt_classmethod
    def CreateForCoreWindowWithAllOptions(cls: win32more.Microsoft.Graphics.Canvas.ICanvasSwapChainStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, coreWindow: win32more.Windows.UI.Core.CoreWindow, width: Single, height: Single, dpi: Single, format: win32more.Windows.Graphics.DirectX.DirectXPixelFormat, bufferCount: Int32) -> win32more.Microsoft.Graphics.Canvas.CanvasSwapChain: ...
    @winrt_classmethod
    def CreateForWindowIdWithDpi(cls: win32more.Microsoft.Graphics.Canvas.ICanvasSwapChainStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, windowId: win32more.Microsoft.UI.WindowId, width: Single, height: Single, dpi: Single) -> win32more.Microsoft.Graphics.Canvas.CanvasSwapChain: ...
    @winrt_classmethod
    def CreateForWindowIdWithAllOptions(cls: win32more.Microsoft.Graphics.Canvas.ICanvasSwapChainStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, windowId: win32more.Microsoft.UI.WindowId, width: Single, height: Single, dpi: Single, format: win32more.Windows.Graphics.DirectX.DirectXPixelFormat, bufferCount: Int32) -> win32more.Microsoft.Graphics.Canvas.CanvasSwapChain: ...
    AlphaMode = property(get_AlphaMode, None)
    BufferCount = property(get_BufferCount, None)
    Device = property(get_Device, None)
    Dpi = property(get_Dpi, None)
    Format = property(get_Format, None)
    Rotation = property(get_Rotation, put_Rotation)
    Size = property(get_Size, None)
    SizeInPixels = property(get_SizeInPixels, None)
    SourceSize = property(get_SourceSize, put_SourceSize)
    TransformMatrix = property(get_TransformMatrix, put_TransformMatrix)
class CanvasSwapChainRotation(Enum, Int32):
    None_ = 0
    Rotate90 = 1
    Rotate180 = 2
    Rotate270 = 3
class CanvasUnits(Enum, Int32):
    Dips = 0
    Pixels = 1
class CanvasVirtualBitmap(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.ICanvasVirtualBitmap
    _classid_ = 'Microsoft.Graphics.Canvas.CanvasVirtualBitmap'
    @winrt_mixinmethod
    def get_Device(self: win32more.Microsoft.Graphics.Canvas.ICanvasVirtualBitmap) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    @winrt_mixinmethod
    def get_IsCachedOnDemand(self: win32more.Microsoft.Graphics.Canvas.ICanvasVirtualBitmap) -> Boolean: ...
    @winrt_mixinmethod
    def get_SizeInPixels(self: win32more.Microsoft.Graphics.Canvas.ICanvasVirtualBitmap) -> win32more.Windows.Graphics.Imaging.BitmapSize: ...
    @winrt_mixinmethod
    def get_Size(self: win32more.Microsoft.Graphics.Canvas.ICanvasVirtualBitmap) -> win32more.Windows.Foundation.Size: ...
    @winrt_mixinmethod
    def get_Bounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasVirtualBitmap) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_classmethod
    def LoadAsyncFromFileName(cls: win32more.Microsoft.Graphics.Canvas.ICanvasVirtualBitmapStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, fileName: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasVirtualBitmap]: ...
    @winrt_classmethod
    def LoadAsyncFromFileNameWithOptions(cls: win32more.Microsoft.Graphics.Canvas.ICanvasVirtualBitmapStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, fileName: WinRT_String, options: win32more.Microsoft.Graphics.Canvas.CanvasVirtualBitmapOptions) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasVirtualBitmap]: ...
    @winrt_classmethod
    def LoadAsyncFromFileNameWithOptionsAndAlpha(cls: win32more.Microsoft.Graphics.Canvas.ICanvasVirtualBitmapStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, fileName: WinRT_String, options: win32more.Microsoft.Graphics.Canvas.CanvasVirtualBitmapOptions, alpha: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasVirtualBitmap]: ...
    @winrt_classmethod
    def LoadAsyncFromUri(cls: win32more.Microsoft.Graphics.Canvas.ICanvasVirtualBitmapStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, uri: win32more.Windows.Foundation.Uri) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasVirtualBitmap]: ...
    @winrt_classmethod
    def LoadAsyncFromUriWithOptions(cls: win32more.Microsoft.Graphics.Canvas.ICanvasVirtualBitmapStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, uri: win32more.Windows.Foundation.Uri, options: win32more.Microsoft.Graphics.Canvas.CanvasVirtualBitmapOptions) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasVirtualBitmap]: ...
    @winrt_classmethod
    def LoadAsyncFromUriWithOptionsAndAlpha(cls: win32more.Microsoft.Graphics.Canvas.ICanvasVirtualBitmapStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, uri: win32more.Windows.Foundation.Uri, options: win32more.Microsoft.Graphics.Canvas.CanvasVirtualBitmapOptions, alpha: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasVirtualBitmap]: ...
    @winrt_classmethod
    def LoadAsyncFromStream(cls: win32more.Microsoft.Graphics.Canvas.ICanvasVirtualBitmapStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, stream: win32more.Windows.Storage.Streams.IRandomAccessStream) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasVirtualBitmap]: ...
    @winrt_classmethod
    def LoadAsyncFromStreamWithOptions(cls: win32more.Microsoft.Graphics.Canvas.ICanvasVirtualBitmapStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, stream: win32more.Windows.Storage.Streams.IRandomAccessStream, options: win32more.Microsoft.Graphics.Canvas.CanvasVirtualBitmapOptions) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasVirtualBitmap]: ...
    @winrt_classmethod
    def LoadAsyncFromStreamWithOptionsAndAlpha(cls: win32more.Microsoft.Graphics.Canvas.ICanvasVirtualBitmapStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, stream: win32more.Windows.Storage.Streams.IRandomAccessStream, options: win32more.Microsoft.Graphics.Canvas.CanvasVirtualBitmapOptions, alpha: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasVirtualBitmap]: ...
    Bounds = property(get_Bounds, None)
    Device = property(get_Device, None)
    IsCachedOnDemand = property(get_IsCachedOnDemand, None)
    Size = property(get_Size, None)
    SizeInPixels = property(get_SizeInPixels, None)
class CanvasVirtualBitmapOptions(Enum, Int32):
    None_ = 0
    ReleaseSource = 1
    CacheOnDemand = 2
class ICanvasActiveLayer(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.ICanvasActiveLayer'
    _iid_ = Guid('{49ecfc58-5e1c-4ee3-8088-542f94e93c60}')
class ICanvasBitmap(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.ICanvasBitmap'
    _iid_ = Guid('{c57532ed-709e-4ac2-86be-a1ec3a7fa8fe}')
    @winrt_commethod(6)
    def get_SizeInPixels(self) -> win32more.Windows.Graphics.Imaging.BitmapSize: ...
    @winrt_commethod(7)
    def get_Size(self) -> win32more.Windows.Foundation.Size: ...
    @winrt_commethod(8)
    def get_Bounds(self) -> win32more.Windows.Foundation.Rect: ...
    @winrt_commethod(9)
    def get_Format(self) -> win32more.Windows.Graphics.DirectX.DirectXPixelFormat: ...
    @winrt_commethod(10)
    def get_AlphaMode(self) -> win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode: ...
    @winrt_commethod(11)
    def SaveToFileAsync(self, fileName: WinRT_String) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_commethod(12)
    def SaveToFileWithBitmapFileFormatAsync(self, fileName: WinRT_String, fileFormat: win32more.Microsoft.Graphics.Canvas.CanvasBitmapFileFormat) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_commethod(13)
    def SaveToFileWithBitmapFileFormatAndQualityAsync(self, fileName: WinRT_String, fileFormat: win32more.Microsoft.Graphics.Canvas.CanvasBitmapFileFormat, quality: Single) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_commethod(14)
    def SaveToStreamAsync(self, stream: win32more.Windows.Storage.Streams.IRandomAccessStream, fileFormat: win32more.Microsoft.Graphics.Canvas.CanvasBitmapFileFormat) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_commethod(15)
    def SaveToStreamWithQualityAsync(self, stream: win32more.Windows.Storage.Streams.IRandomAccessStream, fileFormat: win32more.Microsoft.Graphics.Canvas.CanvasBitmapFileFormat, quality: Single) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_commethod(16)
    def GetPixelBytes(self) -> ReceiveArray[Byte]: ...
    @winrt_commethod(17)
    def GetPixelBytesWithSubrectangle(self, left: Int32, top: Int32, width: Int32, height: Int32) -> ReceiveArray[Byte]: ...
    @winrt_commethod(18)
    def GetPixelBytesWithBuffer(self, buffer: win32more.Windows.Storage.Streams.IBuffer) -> Void: ...
    @winrt_commethod(19)
    def GetPixelBytesWithBufferAndSubrectangle(self, buffer: win32more.Windows.Storage.Streams.IBuffer, left: Int32, top: Int32, width: Int32, height: Int32) -> Void: ...
    @winrt_commethod(20)
    def GetPixelColors(self) -> ReceiveArray[win32more.Windows.UI.Color]: ...
    @winrt_commethod(21)
    def GetPixelColorsWithSubrectangle(self, left: Int32, top: Int32, width: Int32, height: Int32) -> ReceiveArray[win32more.Windows.UI.Color]: ...
    @winrt_commethod(22)
    def SetPixelBytes(self, valueElements: PassArray[Byte]) -> Void: ...
    @winrt_commethod(23)
    def SetPixelBytesWithSubrectangle(self, valueElements: PassArray[Byte], left: Int32, top: Int32, width: Int32, height: Int32) -> Void: ...
    @winrt_commethod(24)
    def SetPixelBytesWithBuffer(self, buffer: win32more.Windows.Storage.Streams.IBuffer) -> Void: ...
    @winrt_commethod(25)
    def SetPixelBytesWithBufferAndSubrectangle(self, buffer: win32more.Windows.Storage.Streams.IBuffer, left: Int32, top: Int32, width: Int32, height: Int32) -> Void: ...
    @winrt_commethod(26)
    def SetPixelColors(self, valueElements: PassArray[win32more.Windows.UI.Color]) -> Void: ...
    @winrt_commethod(27)
    def SetPixelColorsWithSubrectangle(self, valueElements: PassArray[win32more.Windows.UI.Color], left: Int32, top: Int32, width: Int32, height: Int32) -> Void: ...
    @winrt_commethod(28)
    def CopyPixelsFromBitmap(self, otherBitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap) -> Void: ...
    @winrt_commethod(29)
    def CopyPixelsFromBitmapWithDestPoint(self, otherBitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, destX: Int32, destY: Int32) -> Void: ...
    @winrt_commethod(30)
    def CopyPixelsFromBitmapWithDestPointAndSourceRect(self, otherBitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, destX: Int32, destY: Int32, sourceRectLeft: Int32, sourceRectTop: Int32, sourceRectWidth: Int32, sourceRectHeight: Int32) -> Void: ...
    AlphaMode = property(get_AlphaMode, None)
    Bounds = property(get_Bounds, None)
    Format = property(get_Format, None)
    Size = property(get_Size, None)
    SizeInPixels = property(get_SizeInPixels, None)
class ICanvasBitmapFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.ICanvasBitmapFactory'
    _iid_ = Guid('{f2d0eb0e-16f3-4bcf-b1d1-04834ab97de4}')
class ICanvasBitmapStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.ICanvasBitmapStatics'
    _iid_ = Guid('{c8948dea-a41d-4cc2-af9a-fdde01b606dc}')
    @winrt_commethod(6)
    def CreateFromDirect3D11Surface(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, surface: win32more.Windows.Graphics.DirectX.Direct3D11.IDirect3DSurface) -> win32more.Microsoft.Graphics.Canvas.CanvasBitmap: ...
    @winrt_commethod(7)
    def CreateFromDirect3D11SurfaceWithDpi(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, surface: win32more.Windows.Graphics.DirectX.Direct3D11.IDirect3DSurface, dpi: Single) -> win32more.Microsoft.Graphics.Canvas.CanvasBitmap: ...
    @winrt_commethod(8)
    def CreateFromDirect3D11SurfaceWithDpiAndAlpha(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, surface: win32more.Windows.Graphics.DirectX.Direct3D11.IDirect3DSurface, dpi: Single, alpha: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Microsoft.Graphics.Canvas.CanvasBitmap: ...
    @winrt_commethod(9)
    def CreateFromBytes(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, bytes: PassArray[Byte], widthInPixels: Int32, heightInPixels: Int32, format: win32more.Windows.Graphics.DirectX.DirectXPixelFormat) -> win32more.Microsoft.Graphics.Canvas.CanvasBitmap: ...
    @winrt_commethod(10)
    def CreateFromBytesWithDpi(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, bytes: PassArray[Byte], widthInPixels: Int32, heightInPixels: Int32, format: win32more.Windows.Graphics.DirectX.DirectXPixelFormat, dpi: Single) -> win32more.Microsoft.Graphics.Canvas.CanvasBitmap: ...
    @winrt_commethod(11)
    def CreateFromBytesWithDpiAndAlpha(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, bytes: PassArray[Byte], widthInPixels: Int32, heightInPixels: Int32, format: win32more.Windows.Graphics.DirectX.DirectXPixelFormat, dpi: Single, alpha: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Microsoft.Graphics.Canvas.CanvasBitmap: ...
    @winrt_commethod(12)
    def CreateFromBytesWithBuffer(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, buffer: win32more.Windows.Storage.Streams.IBuffer, widthInPixels: Int32, heightInPixels: Int32, format: win32more.Windows.Graphics.DirectX.DirectXPixelFormat) -> win32more.Microsoft.Graphics.Canvas.CanvasBitmap: ...
    @winrt_commethod(13)
    def CreateFromBytesWithBufferAndDpi(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, buffer: win32more.Windows.Storage.Streams.IBuffer, widthInPixels: Int32, heightInPixels: Int32, format: win32more.Windows.Graphics.DirectX.DirectXPixelFormat, dpi: Single) -> win32more.Microsoft.Graphics.Canvas.CanvasBitmap: ...
    @winrt_commethod(14)
    def CreateFromBytesWithBufferAndDpiAndAlpha(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, buffer: win32more.Windows.Storage.Streams.IBuffer, widthInPixels: Int32, heightInPixels: Int32, format: win32more.Windows.Graphics.DirectX.DirectXPixelFormat, dpi: Single, alpha: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Microsoft.Graphics.Canvas.CanvasBitmap: ...
    @winrt_commethod(15)
    def CreateFromColors(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, colors: PassArray[win32more.Windows.UI.Color], widthInPixels: Int32, heightInPixels: Int32) -> win32more.Microsoft.Graphics.Canvas.CanvasBitmap: ...
    @winrt_commethod(16)
    def CreateFromColorsWithDpi(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, colors: PassArray[win32more.Windows.UI.Color], widthInPixels: Int32, heightInPixels: Int32, dpi: Single) -> win32more.Microsoft.Graphics.Canvas.CanvasBitmap: ...
    @winrt_commethod(17)
    def CreateFromColorsWithDpiAndAlpha(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, colors: PassArray[win32more.Windows.UI.Color], widthInPixels: Int32, heightInPixels: Int32, dpi: Single, alpha: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Microsoft.Graphics.Canvas.CanvasBitmap: ...
    @winrt_commethod(18)
    def CreateFromSoftwareBitmap(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, sourceBitmap: win32more.Windows.Graphics.Imaging.SoftwareBitmap) -> win32more.Microsoft.Graphics.Canvas.CanvasBitmap: ...
    @winrt_commethod(19)
    def LoadAsyncFromHstring(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, fileName: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasBitmap]: ...
    @winrt_commethod(20)
    def LoadAsyncFromHstringWithDpi(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, fileName: WinRT_String, dpi: Single) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasBitmap]: ...
    @winrt_commethod(21)
    def LoadAsyncFromHstringWithDpiAndAlpha(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, fileName: WinRT_String, dpi: Single, alpha: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasBitmap]: ...
    @winrt_commethod(22)
    def LoadAsyncFromUri(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, uri: win32more.Windows.Foundation.Uri) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasBitmap]: ...
    @winrt_commethod(23)
    def LoadAsyncFromUriWithDpi(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, uri: win32more.Windows.Foundation.Uri, dpi: Single) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasBitmap]: ...
    @winrt_commethod(24)
    def LoadAsyncFromUriWithDpiAndAlpha(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, uri: win32more.Windows.Foundation.Uri, dpi: Single, alpha: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasBitmap]: ...
    @winrt_commethod(25)
    def LoadAsyncFromStream(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, stream: win32more.Windows.Storage.Streams.IRandomAccessStream) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasBitmap]: ...
    @winrt_commethod(26)
    def LoadAsyncFromStreamWithDpi(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, stream: win32more.Windows.Storage.Streams.IRandomAccessStream, dpi: Single) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasBitmap]: ...
    @winrt_commethod(27)
    def LoadAsyncFromStreamWithDpiAndAlpha(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, stream: win32more.Windows.Storage.Streams.IRandomAccessStream, dpi: Single, alpha: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasBitmap]: ...
class ICanvasCommandList(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.ICanvasCommandList'
    _iid_ = Guid('{b71e73cf-2fe7-4d3a-bbb8-19f016f5be1b}')
    @winrt_commethod(6)
    def CreateDrawingSession(self) -> win32more.Microsoft.Graphics.Canvas.CanvasDrawingSession: ...
    @winrt_commethod(7)
    def get_Device(self) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    Device = property(get_Device, None)
class ICanvasCommandListFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.ICanvasCommandListFactory'
    _iid_ = Guid('{b3d44e68-d931-4b5b-b957-0888980a7d50}')
    @winrt_commethod(6)
    def Create(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Microsoft.Graphics.Canvas.CanvasCommandList: ...
class ICanvasDevice(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.ICanvasDevice'
    _iid_ = Guid('{a27f0b5d-ec2c-4d4f-948f-0aa1e95e33e6}')
    @winrt_commethod(6)
    def get_ForceSoftwareRenderer(self) -> Boolean: ...
    @winrt_commethod(7)
    def get_MaximumBitmapSizeInPixels(self) -> Int32: ...
    @winrt_commethod(8)
    def IsPixelFormatSupported(self, pixelFormat: win32more.Windows.Graphics.DirectX.DirectXPixelFormat) -> Boolean: ...
    @winrt_commethod(9)
    def IsBufferPrecisionSupported(self, bufferPrecision: win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision) -> Boolean: ...
    @winrt_commethod(10)
    def get_MaximumCacheSize(self) -> UInt64: ...
    @winrt_commethod(11)
    def put_MaximumCacheSize(self, value: UInt64) -> Void: ...
    @winrt_commethod(12)
    def get_LowPriority(self) -> Boolean: ...
    @winrt_commethod(13)
    def put_LowPriority(self, value: Boolean) -> Void: ...
    @winrt_commethod(14)
    def add_DeviceLost(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.Graphics.Canvas.CanvasDevice, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(15)
    def remove_DeviceLost(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(16)
    def IsDeviceLost(self, hresult: Int32) -> Boolean: ...
    @winrt_commethod(17)
    def RaiseDeviceLost(self) -> Void: ...
    @winrt_commethod(18)
    def Lock(self) -> win32more.Microsoft.Graphics.Canvas.CanvasLock: ...
    @winrt_commethod(19)
    def IsDeviceLost2(self) -> Boolean: ...
    @winrt_commethod(20)
    def GetDeviceLostReason(self) -> Int32: ...
    ForceSoftwareRenderer = property(get_ForceSoftwareRenderer, None)
    LowPriority = property(get_LowPriority, put_LowPriority)
    MaximumBitmapSizeInPixels = property(get_MaximumBitmapSizeInPixels, None)
    MaximumCacheSize = property(get_MaximumCacheSize, put_MaximumCacheSize)
    DeviceLost = event()
class ICanvasDeviceFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.ICanvasDeviceFactory'
    _iid_ = Guid('{e2c2bf21-5418-43b9-a2da-539e287c790f}')
    @winrt_commethod(6)
    def CreateWithForceSoftwareRendererOption(self, forceSoftwareRenderer: Boolean) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
class ICanvasDeviceStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.ICanvasDeviceStatics'
    _iid_ = Guid('{9b6e2b27-cd07-421a-8f69-0ae8a787fe8c}')
    @winrt_commethod(6)
    def CreateFromDirect3D11Device(self, direct3DDevice: win32more.Windows.Graphics.DirectX.Direct3D11.IDirect3DDevice) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    @winrt_commethod(7)
    def GetSharedDevice(self) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    @winrt_commethod(8)
    def GetSharedDeviceWithForceSoftwareRenderer(self, forceSoftwareRenderer: Boolean) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    @winrt_commethod(9)
    def put_DebugLevel(self, value: win32more.Microsoft.Graphics.Canvas.CanvasDebugLevel) -> Void: ...
    @winrt_commethod(10)
    def get_DebugLevel(self) -> win32more.Microsoft.Graphics.Canvas.CanvasDebugLevel: ...
    DebugLevel = property(get_DebugLevel, put_DebugLevel)
class ICanvasDrawingSession(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.ICanvasDrawingSession'
    _iid_ = Guid('{f60afd09-e623-4be0-b750-578aa920b1db}')
    @winrt_commethod(6)
    def Clear(self, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(7)
    def ClearHdr(self, color: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_commethod(8)
    def Flush(self) -> Void: ...
    @winrt_commethod(9)
    def DrawImageAtOrigin(self, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage) -> Void: ...
    @winrt_commethod(10)
    def DrawImageAtOffset(self, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, offset: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_commethod(11)
    def DrawImageAtCoords(self, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, x: Single, y: Single) -> Void: ...
    @winrt_commethod(12)
    def DrawImageToRect(self, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, destinationRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_commethod(13)
    def DrawImageAtOffsetWithSourceRect(self, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, offset: win32more.Windows.Foundation.Numerics.Vector2, sourceRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_commethod(14)
    def DrawImageAtCoordsWithSourceRect(self, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, x: Single, y: Single, sourceRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_commethod(15)
    def DrawImageToRectWithSourceRect(self, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, destinationRectangle: win32more.Windows.Foundation.Rect, sourceRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_commethod(16)
    def DrawImageAtOffsetWithSourceRectAndOpacity(self, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, offset: win32more.Windows.Foundation.Numerics.Vector2, sourceRectangle: win32more.Windows.Foundation.Rect, opacity: Single) -> Void: ...
    @winrt_commethod(17)
    def DrawImageAtCoordsWithSourceRectAndOpacity(self, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, x: Single, y: Single, sourceRectangle: win32more.Windows.Foundation.Rect, opacity: Single) -> Void: ...
    @winrt_commethod(18)
    def DrawImageToRectWithSourceRectAndOpacity(self, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, destinationRectangle: win32more.Windows.Foundation.Rect, sourceRectangle: win32more.Windows.Foundation.Rect, opacity: Single) -> Void: ...
    @winrt_commethod(19)
    def DrawImageAtOffsetWithSourceRectAndOpacityAndInterpolation(self, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, offset: win32more.Windows.Foundation.Numerics.Vector2, sourceRectangle: win32more.Windows.Foundation.Rect, opacity: Single, interpolation: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_commethod(20)
    def DrawImageAtCoordsWithSourceRectAndOpacityAndInterpolation(self, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, x: Single, y: Single, sourceRectangle: win32more.Windows.Foundation.Rect, opacity: Single, interpolation: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_commethod(21)
    def DrawImageToRectWithSourceRectAndOpacityAndInterpolation(self, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, destinationRectangle: win32more.Windows.Foundation.Rect, sourceRectangle: win32more.Windows.Foundation.Rect, opacity: Single, interpolation: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_commethod(22)
    def DrawImageAtOffsetWithSourceRectAndOpacityAndInterpolationAndComposite(self, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, offset: win32more.Windows.Foundation.Numerics.Vector2, sourceRectangle: win32more.Windows.Foundation.Rect, opacity: Single, interpolation: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation, composite: win32more.Microsoft.Graphics.Canvas.CanvasComposite) -> Void: ...
    @winrt_commethod(23)
    def DrawImageAtCoordsWithSourceRectAndOpacityAndInterpolationAndComposite(self, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, x: Single, y: Single, sourceRectangle: win32more.Windows.Foundation.Rect, opacity: Single, interpolation: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation, composite: win32more.Microsoft.Graphics.Canvas.CanvasComposite) -> Void: ...
    @winrt_commethod(24)
    def DrawImageToRectWithSourceRectAndOpacityAndInterpolationAndComposite(self, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, destinationRectangle: win32more.Windows.Foundation.Rect, sourceRectangle: win32more.Windows.Foundation.Rect, opacity: Single, interpolation: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation, composite: win32more.Microsoft.Graphics.Canvas.CanvasComposite) -> Void: ...
    @winrt_commethod(25)
    def DrawImageAtOffsetWithSourceRectAndOpacityAndInterpolationAndPerspective(self, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, offset: win32more.Windows.Foundation.Numerics.Vector2, sourceRectangle: win32more.Windows.Foundation.Rect, opacity: Single, interpolation: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation, perspective: win32more.Windows.Foundation.Numerics.Matrix4x4) -> Void: ...
    @winrt_commethod(26)
    def DrawImageAtCoordsWithSourceRectAndOpacityAndInterpolationAndPerspective(self, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, x: Single, y: Single, sourceRectangle: win32more.Windows.Foundation.Rect, opacity: Single, interpolation: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation, perspective: win32more.Windows.Foundation.Numerics.Matrix4x4) -> Void: ...
    @winrt_commethod(27)
    def DrawImageToRectWithSourceRectAndOpacityAndInterpolationAndPerspective(self, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, destinationRectangle: win32more.Windows.Foundation.Rect, sourceRectangle: win32more.Windows.Foundation.Rect, opacity: Single, interpolation: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation, perspective: win32more.Windows.Foundation.Numerics.Matrix4x4) -> Void: ...
    @winrt_commethod(28)
    def DrawLineWithBrush(self, point0: win32more.Windows.Foundation.Numerics.Vector2, point1: win32more.Windows.Foundation.Numerics.Vector2, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(29)
    def DrawLineAtCoordsWithBrush(self, x0: Single, y0: Single, x1: Single, y1: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(30)
    def DrawLineWithColor(self, point0: win32more.Windows.Foundation.Numerics.Vector2, point1: win32more.Windows.Foundation.Numerics.Vector2, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(31)
    def DrawLineAtCoordsWithColor(self, x0: Single, y0: Single, x1: Single, y1: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(32)
    def DrawLineWithBrushAndStrokeWidth(self, point0: win32more.Windows.Foundation.Numerics.Vector2, point1: win32more.Windows.Foundation.Numerics.Vector2, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single) -> Void: ...
    @winrt_commethod(33)
    def DrawLineAtCoordsWithBrushAndStrokeWidth(self, x0: Single, y0: Single, x1: Single, y1: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single) -> Void: ...
    @winrt_commethod(34)
    def DrawLineWithColorAndStrokeWidth(self, point0: win32more.Windows.Foundation.Numerics.Vector2, point1: win32more.Windows.Foundation.Numerics.Vector2, color: win32more.Windows.UI.Color, strokeWidth: Single) -> Void: ...
    @winrt_commethod(35)
    def DrawLineAtCoordsWithColorAndStrokeWidth(self, x0: Single, y0: Single, x1: Single, y1: Single, color: win32more.Windows.UI.Color, strokeWidth: Single) -> Void: ...
    @winrt_commethod(36)
    def DrawLineWithBrushAndStrokeWidthAndStrokeStyle(self, point0: win32more.Windows.Foundation.Numerics.Vector2, point1: win32more.Windows.Foundation.Numerics.Vector2, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_commethod(37)
    def DrawLineAtCoordsWithBrushAndStrokeWidthAndStrokeStyle(self, x0: Single, y0: Single, x1: Single, y1: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_commethod(38)
    def DrawLineWithColorAndStrokeWidthAndStrokeStyle(self, point0: win32more.Windows.Foundation.Numerics.Vector2, point1: win32more.Windows.Foundation.Numerics.Vector2, color: win32more.Windows.UI.Color, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_commethod(39)
    def DrawLineAtCoordsWithColorAndStrokeWidthAndStrokeStyle(self, x0: Single, y0: Single, x1: Single, y1: Single, color: win32more.Windows.UI.Color, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_commethod(40)
    def DrawRectangleWithBrush(self, rect: win32more.Windows.Foundation.Rect, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(41)
    def DrawRectangleAtCoordsWithBrush(self, x: Single, y: Single, w: Single, h: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(42)
    def DrawRectangleWithColor(self, rect: win32more.Windows.Foundation.Rect, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(43)
    def DrawRectangleAtCoordsWithColor(self, x: Single, y: Single, w: Single, h: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(44)
    def DrawRectangleWithBrushAndStrokeWidth(self, rect: win32more.Windows.Foundation.Rect, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single) -> Void: ...
    @winrt_commethod(45)
    def DrawRectangleAtCoordsWithBrushAndStrokeWidth(self, x: Single, y: Single, w: Single, h: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single) -> Void: ...
    @winrt_commethod(46)
    def DrawRectangleWithColorAndStrokeWidth(self, rect: win32more.Windows.Foundation.Rect, color: win32more.Windows.UI.Color, strokeWidth: Single) -> Void: ...
    @winrt_commethod(47)
    def DrawRectangleAtCoordsWithColorAndStrokeWidth(self, x: Single, y: Single, w: Single, h: Single, color: win32more.Windows.UI.Color, strokeWidth: Single) -> Void: ...
    @winrt_commethod(48)
    def DrawRectangleWithBrushAndStrokeWidthAndStrokeStyle(self, rect: win32more.Windows.Foundation.Rect, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_commethod(49)
    def DrawRectangleAtCoordsWithBrushAndStrokeWidthAndStrokeStyle(self, x: Single, y: Single, w: Single, h: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_commethod(50)
    def DrawRectangleWithColorAndStrokeWidthAndStrokeStyle(self, rect: win32more.Windows.Foundation.Rect, color: win32more.Windows.UI.Color, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_commethod(51)
    def DrawRectangleAtCoordsWithColorAndStrokeWidthAndStrokeStyle(self, x: Single, y: Single, w: Single, h: Single, color: win32more.Windows.UI.Color, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_commethod(52)
    def FillRectangleWithBrush(self, rect: win32more.Windows.Foundation.Rect, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(53)
    def FillRectangleAtCoordsWithBrush(self, x: Single, y: Single, w: Single, h: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(54)
    def FillRectangleWithColor(self, rect: win32more.Windows.Foundation.Rect, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(55)
    def FillRectangleAtCoordsWithColor(self, x: Single, y: Single, w: Single, h: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(56)
    def FillRectangleWithBrushAndOpacityBrush(self, rect: win32more.Windows.Foundation.Rect, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, opacityBrush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(57)
    def FillRectangleAtCoordsWithBrushAndOpacityBrush(self, x: Single, y: Single, w: Single, h: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, opacityBrush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(58)
    def DrawRoundedRectangleWithBrush(self, rect: win32more.Windows.Foundation.Rect, radiusX: Single, radiusY: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(59)
    def DrawRoundedRectangleAtCoordsWithBrush(self, x: Single, y: Single, w: Single, h: Single, radiusX: Single, radiusY: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(60)
    def DrawRoundedRectangleWithColor(self, rect: win32more.Windows.Foundation.Rect, radiusX: Single, radiusY: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(61)
    def DrawRoundedRectangleAtCoordsWithColor(self, x: Single, y: Single, w: Single, h: Single, radiusX: Single, radiusY: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(62)
    def DrawRoundedRectangleWithBrushAndStrokeWidth(self, rect: win32more.Windows.Foundation.Rect, radiusX: Single, radiusY: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single) -> Void: ...
    @winrt_commethod(63)
    def DrawRoundedRectangleAtCoordsWithBrushAndStrokeWidth(self, x: Single, y: Single, w: Single, h: Single, radiusX: Single, radiusY: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single) -> Void: ...
    @winrt_commethod(64)
    def DrawRoundedRectangleWithColorAndStrokeWidth(self, rect: win32more.Windows.Foundation.Rect, radiusX: Single, radiusY: Single, color: win32more.Windows.UI.Color, strokeWidth: Single) -> Void: ...
    @winrt_commethod(65)
    def DrawRoundedRectangleAtCoordsWithColorAndStrokeWidth(self, x: Single, y: Single, w: Single, h: Single, radiusX: Single, radiusY: Single, color: win32more.Windows.UI.Color, strokeWidth: Single) -> Void: ...
    @winrt_commethod(66)
    def DrawRoundedRectangleWithBrushAndStrokeWidthAndStrokeStyle(self, rect: win32more.Windows.Foundation.Rect, radiusX: Single, radiusY: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_commethod(67)
    def DrawRoundedRectangleAtCoordsWithBrushAndStrokeWidthAndStrokeStyle(self, x: Single, y: Single, w: Single, h: Single, radiusX: Single, radiusY: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_commethod(68)
    def DrawRoundedRectangleWithColorAndStrokeWidthAndStrokeStyle(self, rect: win32more.Windows.Foundation.Rect, radiusX: Single, radiusY: Single, color: win32more.Windows.UI.Color, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_commethod(69)
    def DrawRoundedRectangleAtCoordsWithColorAndStrokeWidthAndStrokeStyle(self, x: Single, y: Single, w: Single, h: Single, radiusX: Single, radiusY: Single, color: win32more.Windows.UI.Color, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_commethod(70)
    def FillRoundedRectangleWithBrush(self, rect: win32more.Windows.Foundation.Rect, radiusX: Single, radiusY: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(71)
    def FillRoundedRectangleAtCoordsWithBrush(self, x: Single, y: Single, w: Single, h: Single, radiusX: Single, radiusY: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(72)
    def FillRoundedRectangleWithColor(self, rect: win32more.Windows.Foundation.Rect, radiusX: Single, radiusY: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(73)
    def FillRoundedRectangleAtCoordsWithColor(self, x: Single, y: Single, w: Single, h: Single, radiusX: Single, radiusY: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(74)
    def DrawEllipseWithBrush(self, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radiusX: Single, radiusY: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(75)
    def DrawEllipseAtCoordsWithBrush(self, x: Single, y: Single, radiusX: Single, radiusY: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(76)
    def DrawEllipseWithColor(self, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radiusX: Single, radiusY: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(77)
    def DrawEllipseAtCoordsWithColor(self, x: Single, y: Single, radiusX: Single, radiusY: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(78)
    def DrawEllipseWithBrushAndStrokeWidth(self, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radiusX: Single, radiusY: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single) -> Void: ...
    @winrt_commethod(79)
    def DrawEllipseAtCoordsWithBrushAndStrokeWidth(self, x: Single, y: Single, radiusX: Single, radiusY: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single) -> Void: ...
    @winrt_commethod(80)
    def DrawEllipseWithColorAndStrokeWidth(self, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radiusX: Single, radiusY: Single, color: win32more.Windows.UI.Color, strokeWidth: Single) -> Void: ...
    @winrt_commethod(81)
    def DrawEllipseAtCoordsWithColorAndStrokeWidth(self, x: Single, y: Single, radiusX: Single, radiusY: Single, color: win32more.Windows.UI.Color, strokeWidth: Single) -> Void: ...
    @winrt_commethod(82)
    def DrawEllipseWithBrushAndStrokeWidthAndStrokeStyle(self, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radiusX: Single, radiusY: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_commethod(83)
    def DrawEllipseAtCoordsWithBrushAndStrokeWidthAndStrokeStyle(self, x: Single, y: Single, radiusX: Single, radiusY: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_commethod(84)
    def DrawEllipseWithColorAndStrokeWidthAndStrokeStyle(self, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radiusX: Single, radiusY: Single, color: win32more.Windows.UI.Color, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_commethod(85)
    def DrawEllipseAtCoordsWithColorAndStrokeWidthAndStrokeStyle(self, x: Single, y: Single, radiusX: Single, radiusY: Single, color: win32more.Windows.UI.Color, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_commethod(86)
    def FillEllipseWithBrush(self, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radiusX: Single, radiusY: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(87)
    def FillEllipseAtCoordsWithBrush(self, x: Single, y: Single, radiusX: Single, radiusY: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(88)
    def FillEllipseWithColor(self, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radiusX: Single, radiusY: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(89)
    def FillEllipseAtCoordsWithColor(self, x: Single, y: Single, radiusX: Single, radiusY: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(90)
    def DrawCircleWithBrush(self, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radius: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(91)
    def DrawCircleAtCoordsWithBrush(self, x: Single, y: Single, radius: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(92)
    def DrawCircleWithColor(self, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radius: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(93)
    def DrawCircleAtCoordsWithColor(self, x: Single, y: Single, radius: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(94)
    def DrawCircleWithBrushAndStrokeWidth(self, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radius: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single) -> Void: ...
    @winrt_commethod(95)
    def DrawCircleAtCoordsWithBrushAndStrokeWidth(self, x: Single, y: Single, radius: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single) -> Void: ...
    @winrt_commethod(96)
    def DrawCircleWithColorAndStrokeWidth(self, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radius: Single, color: win32more.Windows.UI.Color, strokeWidth: Single) -> Void: ...
    @winrt_commethod(97)
    def DrawCircleAtCoordsWithColorAndStrokeWidth(self, x: Single, y: Single, radius: Single, color: win32more.Windows.UI.Color, strokeWidth: Single) -> Void: ...
    @winrt_commethod(98)
    def DrawCircleWithBrushAndStrokeWidthAndStrokeStyle(self, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radius: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_commethod(99)
    def DrawCircleAtCoordsWithBrushAndStrokeWidthAndStrokeStyle(self, x: Single, y: Single, radius: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_commethod(100)
    def DrawCircleWithColorAndStrokeWidthAndStrokeStyle(self, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radius: Single, color: win32more.Windows.UI.Color, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_commethod(101)
    def DrawCircleAtCoordsWithColorAndStrokeWidthAndStrokeStyle(self, x: Single, y: Single, radius: Single, color: win32more.Windows.UI.Color, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_commethod(102)
    def FillCircleWithBrush(self, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radius: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(103)
    def FillCircleAtCoordsWithBrush(self, x: Single, y: Single, radius: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(104)
    def FillCircleWithColor(self, centerPoint: win32more.Windows.Foundation.Numerics.Vector2, radius: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(105)
    def FillCircleAtCoordsWithColor(self, x: Single, y: Single, radius: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(106)
    def DrawTextAtPointWithColor(self, text: WinRT_String, point: win32more.Windows.Foundation.Numerics.Vector2, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(107)
    def DrawTextAtPointCoordsWithColor(self, text: WinRT_String, x: Single, y: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(108)
    def DrawTextAtPointWithBrushAndFormat(self, text: WinRT_String, point: win32more.Windows.Foundation.Numerics.Vector2, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, format: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextFormat) -> Void: ...
    @winrt_commethod(109)
    def DrawTextAtRectWithBrushAndFormat(self, text: WinRT_String, rectangle: win32more.Windows.Foundation.Rect, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, format: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextFormat) -> Void: ...
    @winrt_commethod(110)
    def DrawTextAtPointCoordsWithBrushAndFormat(self, text: WinRT_String, x: Single, y: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, format: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextFormat) -> Void: ...
    @winrt_commethod(111)
    def DrawTextAtRectCoordsWithBrushAndFormat(self, text: WinRT_String, x: Single, y: Single, w: Single, h: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, format: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextFormat) -> Void: ...
    @winrt_commethod(112)
    def DrawTextAtPointWithColorAndFormat(self, text: WinRT_String, point: win32more.Windows.Foundation.Numerics.Vector2, color: win32more.Windows.UI.Color, format: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextFormat) -> Void: ...
    @winrt_commethod(113)
    def DrawTextAtRectWithColorAndFormat(self, text: WinRT_String, rectangle: win32more.Windows.Foundation.Rect, color: win32more.Windows.UI.Color, format: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextFormat) -> Void: ...
    @winrt_commethod(114)
    def DrawTextAtPointCoordsWithColorAndFormat(self, text: WinRT_String, x: Single, y: Single, color: win32more.Windows.UI.Color, format: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextFormat) -> Void: ...
    @winrt_commethod(115)
    def DrawTextAtRectCoordsWithColorAndFormat(self, text: WinRT_String, x: Single, y: Single, w: Single, h: Single, color: win32more.Windows.UI.Color, format: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextFormat) -> Void: ...
    @winrt_commethod(116)
    def DrawGeometryWithBrush(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, offset: win32more.Windows.Foundation.Numerics.Vector2, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(117)
    def DrawGeometryWithColor(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, offset: win32more.Windows.Foundation.Numerics.Vector2, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(118)
    def DrawGeometryAtCoordsWithBrush(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, x: Single, y: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(119)
    def DrawGeometryAtCoordsWithColor(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, x: Single, y: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(120)
    def DrawGeometryAtOriginWithBrush(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(121)
    def DrawGeometryAtOriginWithColor(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(122)
    def DrawGeometryWithBrushAndStrokeWidth(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, offset: win32more.Windows.Foundation.Numerics.Vector2, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single) -> Void: ...
    @winrt_commethod(123)
    def DrawGeometryWithColorAndStrokeWidth(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, offset: win32more.Windows.Foundation.Numerics.Vector2, color: win32more.Windows.UI.Color, strokeWidth: Single) -> Void: ...
    @winrt_commethod(124)
    def DrawGeometryAtCoordsWithBrushAndStrokeWidth(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, x: Single, y: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single) -> Void: ...
    @winrt_commethod(125)
    def DrawGeometryAtCoordsWithColorAndStrokeWidth(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, x: Single, y: Single, color: win32more.Windows.UI.Color, strokeWidth: Single) -> Void: ...
    @winrt_commethod(126)
    def DrawGeometryAtOriginWithBrushAndStrokeWidth(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single) -> Void: ...
    @winrt_commethod(127)
    def DrawGeometryAtOriginWithColorAndStrokeWidth(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, color: win32more.Windows.UI.Color, strokeWidth: Single) -> Void: ...
    @winrt_commethod(128)
    def DrawGeometryWithBrushAndStrokeWidthAndStrokeStyle(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, offset: win32more.Windows.Foundation.Numerics.Vector2, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_commethod(129)
    def DrawGeometryWithColorAndStrokeWidthAndStrokeStyle(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, offset: win32more.Windows.Foundation.Numerics.Vector2, color: win32more.Windows.UI.Color, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_commethod(130)
    def DrawGeometryAtCoordsWithBrushAndStrokeWidthAndStrokeStyle(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, x: Single, y: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_commethod(131)
    def DrawGeometryAtCoordsWithColorAndStrokeWidthAndStrokeStyle(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, x: Single, y: Single, color: win32more.Windows.UI.Color, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_commethod(132)
    def DrawGeometryAtOriginWithBrushAndStrokeWidthAndStrokeStyle(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_commethod(133)
    def DrawGeometryAtOriginWithColorAndStrokeWidthAndStrokeStyle(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, color: win32more.Windows.UI.Color, strokeWidth: Single, strokeStyle: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasStrokeStyle) -> Void: ...
    @winrt_commethod(134)
    def FillGeometryWithBrush(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, offset: win32more.Windows.Foundation.Numerics.Vector2, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(135)
    def FillGeometryWithBrushAndOpacityBrush(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, offset: win32more.Windows.Foundation.Numerics.Vector2, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, opacityBrush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(136)
    def FillGeometryWithColor(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, offset: win32more.Windows.Foundation.Numerics.Vector2, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(137)
    def FillGeometryAtCoordsWithBrush(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, x: Single, y: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(138)
    def FillGeometryAtCoordsWithBrushAndOpacityBrush(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, x: Single, y: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, opacityBrush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(139)
    def FillGeometryAtCoordsWithColor(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, x: Single, y: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(140)
    def FillGeometryAtOriginWithBrush(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(141)
    def FillGeometryAtOriginWithBrushAndOpacityBrush(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, opacityBrush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(142)
    def FillGeometryAtOriginWithColor(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(143)
    def DrawCachedGeometryWithBrush(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCachedGeometry, offset: win32more.Windows.Foundation.Numerics.Vector2, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(144)
    def DrawCachedGeometryWithColor(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCachedGeometry, offset: win32more.Windows.Foundation.Numerics.Vector2, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(145)
    def DrawCachedGeometryAtCoordsWithBrush(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCachedGeometry, x: Single, y: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(146)
    def DrawCachedGeometryAtCoordsWithColor(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCachedGeometry, x: Single, y: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(147)
    def DrawCachedGeometryAtOriginWithBrush(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCachedGeometry, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(148)
    def DrawCachedGeometryAtOriginWithColor(self, geometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCachedGeometry, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(149)
    def DrawTextLayoutWithBrush(self, textLayout: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextLayout, point: win32more.Windows.Foundation.Numerics.Vector2, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(150)
    def DrawTextLayoutAtCoordsWithBrush(self, textLayout: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextLayout, x: Single, y: Single, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(151)
    def DrawTextLayoutWithColor(self, textLayout: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextLayout, point: win32more.Windows.Foundation.Numerics.Vector2, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(152)
    def DrawTextLayoutAtCoordsWithColor(self, textLayout: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextLayout, x: Single, y: Single, color: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(153)
    def DrawGradientMeshAtOrigin(self, gradientMesh: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGradientMesh) -> Void: ...
    @winrt_commethod(154)
    def DrawGradientMesh(self, gradientMesh: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGradientMesh, point: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_commethod(155)
    def DrawGradientMeshAtCoords(self, gradientMesh: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGradientMesh, x: Single, y: Single) -> Void: ...
    @winrt_commethod(156)
    def DrawSvgAtOrigin(self, svgDocument: win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgDocument, viewportSize: win32more.Windows.Foundation.Size) -> Void: ...
    @winrt_commethod(157)
    def DrawSvgAtPoint(self, svgDocument: win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgDocument, viewportSize: win32more.Windows.Foundation.Size, point: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_commethod(158)
    def DrawSvgAtCoords(self, svgDocument: win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgDocument, viewportSize: win32more.Windows.Foundation.Size, x: Single, y: Single) -> Void: ...
    @winrt_commethod(159)
    def get_Antialiasing(self) -> win32more.Microsoft.Graphics.Canvas.CanvasAntialiasing: ...
    @winrt_commethod(160)
    def put_Antialiasing(self, value: win32more.Microsoft.Graphics.Canvas.CanvasAntialiasing) -> Void: ...
    @winrt_commethod(161)
    def get_Blend(self) -> win32more.Microsoft.Graphics.Canvas.CanvasBlend: ...
    @winrt_commethod(162)
    def put_Blend(self, value: win32more.Microsoft.Graphics.Canvas.CanvasBlend) -> Void: ...
    @winrt_commethod(163)
    def get_TextAntialiasing(self) -> win32more.Microsoft.Graphics.Canvas.Text.CanvasTextAntialiasing: ...
    @winrt_commethod(164)
    def put_TextAntialiasing(self, value: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextAntialiasing) -> Void: ...
    @winrt_commethod(165)
    def get_TextRenderingParameters(self) -> win32more.Microsoft.Graphics.Canvas.Text.CanvasTextRenderingParameters: ...
    @winrt_commethod(166)
    def put_TextRenderingParameters(self, value: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextRenderingParameters) -> Void: ...
    @winrt_commethod(167)
    def get_Transform(self) -> win32more.Windows.Foundation.Numerics.Matrix3x2: ...
    @winrt_commethod(168)
    def put_Transform(self, value: win32more.Windows.Foundation.Numerics.Matrix3x2) -> Void: ...
    @winrt_commethod(169)
    def get_Units(self) -> win32more.Microsoft.Graphics.Canvas.CanvasUnits: ...
    @winrt_commethod(170)
    def put_Units(self, value: win32more.Microsoft.Graphics.Canvas.CanvasUnits) -> Void: ...
    @winrt_commethod(171)
    def get_EffectBufferPrecision(self) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_commethod(172)
    def put_EffectBufferPrecision(self, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_commethod(173)
    def get_EffectTileSize(self) -> win32more.Windows.Graphics.Imaging.BitmapSize: ...
    @winrt_commethod(174)
    def put_EffectTileSize(self, value: win32more.Windows.Graphics.Imaging.BitmapSize) -> Void: ...
    @winrt_commethod(175)
    def CreateLayerWithOpacity(self, opacity: Single) -> win32more.Microsoft.Graphics.Canvas.CanvasActiveLayer: ...
    @winrt_commethod(176)
    def CreateLayerWithOpacityBrush(self, opacityBrush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> win32more.Microsoft.Graphics.Canvas.CanvasActiveLayer: ...
    @winrt_commethod(177)
    def CreateLayerWithOpacityAndClipRectangle(self, opacity: Single, clipRectangle: win32more.Windows.Foundation.Rect) -> win32more.Microsoft.Graphics.Canvas.CanvasActiveLayer: ...
    @winrt_commethod(178)
    def CreateLayerWithOpacityBrushAndClipRectangle(self, opacityBrush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, clipRectangle: win32more.Windows.Foundation.Rect) -> win32more.Microsoft.Graphics.Canvas.CanvasActiveLayer: ...
    @winrt_commethod(179)
    def CreateLayerWithOpacityAndClipGeometry(self, opacity: Single, clipGeometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry) -> win32more.Microsoft.Graphics.Canvas.CanvasActiveLayer: ...
    @winrt_commethod(180)
    def CreateLayerWithOpacityBrushAndClipGeometry(self, opacityBrush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, clipGeometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry) -> win32more.Microsoft.Graphics.Canvas.CanvasActiveLayer: ...
    @winrt_commethod(181)
    def CreateLayerWithOpacityAndClipGeometryAndTransform(self, opacity: Single, clipGeometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, geometryTransform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Microsoft.Graphics.Canvas.CanvasActiveLayer: ...
    @winrt_commethod(182)
    def CreateLayerWithOpacityBrushAndClipGeometryAndTransform(self, opacityBrush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, clipGeometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, geometryTransform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Microsoft.Graphics.Canvas.CanvasActiveLayer: ...
    @winrt_commethod(183)
    def CreateLayerWithAllOptions(self, opacity: Single, opacityBrush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, clipRectangle: win32more.Windows.Foundation.Rect, clipGeometry: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry, geometryTransform: win32more.Windows.Foundation.Numerics.Matrix3x2, options: win32more.Microsoft.Graphics.Canvas.CanvasLayerOptions) -> win32more.Microsoft.Graphics.Canvas.CanvasActiveLayer: ...
    @winrt_commethod(184)
    def DrawGlyphRun(self, point: win32more.Windows.Foundation.Numerics.Vector2, fontFace: win32more.Microsoft.Graphics.Canvas.Text.CanvasFontFace, fontSize: Single, glyphs: PassArray[win32more.Microsoft.Graphics.Canvas.Text.CanvasGlyph], isSideways: Boolean, bidiLevel: UInt32, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush) -> Void: ...
    @winrt_commethod(185)
    def DrawGlyphRunWithMeasuringMode(self, point: win32more.Windows.Foundation.Numerics.Vector2, fontFace: win32more.Microsoft.Graphics.Canvas.Text.CanvasFontFace, fontSize: Single, glyphs: PassArray[win32more.Microsoft.Graphics.Canvas.Text.CanvasGlyph], isSideways: Boolean, bidiLevel: UInt32, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, measuringMode: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextMeasuringMode) -> Void: ...
    @winrt_commethod(186)
    def DrawGlyphRunWithMeasuringModeAndDescription(self, point: win32more.Windows.Foundation.Numerics.Vector2, fontFace: win32more.Microsoft.Graphics.Canvas.Text.CanvasFontFace, fontSize: Single, glyphs: PassArray[win32more.Microsoft.Graphics.Canvas.Text.CanvasGlyph], isSideways: Boolean, bidiLevel: UInt32, brush: win32more.Microsoft.Graphics.Canvas.Brushes.ICanvasBrush, measuringMode: win32more.Microsoft.Graphics.Canvas.Text.CanvasTextMeasuringMode, localeName: WinRT_String, textString: WinRT_String, clusterMapIndices: PassArray[Int32], textPosition: UInt32) -> Void: ...
    @winrt_commethod(187)
    def CreateSpriteBatch(self) -> win32more.Microsoft.Graphics.Canvas.CanvasSpriteBatch: ...
    @winrt_commethod(188)
    def CreateSpriteBatchWithSortMode(self, sortMode: win32more.Microsoft.Graphics.Canvas.CanvasSpriteSortMode) -> win32more.Microsoft.Graphics.Canvas.CanvasSpriteBatch: ...
    @winrt_commethod(189)
    def CreateSpriteBatchWithSortModeAndInterpolation(self, sortMode: win32more.Microsoft.Graphics.Canvas.CanvasSpriteSortMode, interpolation: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> win32more.Microsoft.Graphics.Canvas.CanvasSpriteBatch: ...
    @winrt_commethod(190)
    def CreateSpriteBatchWithSortModeAndInterpolationAndOptions(self, sortMode: win32more.Microsoft.Graphics.Canvas.CanvasSpriteSortMode, interpolation: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation, options: win32more.Microsoft.Graphics.Canvas.CanvasSpriteOptions) -> win32more.Microsoft.Graphics.Canvas.CanvasSpriteBatch: ...
    Antialiasing = property(get_Antialiasing, put_Antialiasing)
    Blend = property(get_Blend, put_Blend)
    EffectBufferPrecision = property(get_EffectBufferPrecision, put_EffectBufferPrecision)
    EffectTileSize = property(get_EffectTileSize, put_EffectTileSize)
    TextAntialiasing = property(get_TextAntialiasing, put_TextAntialiasing)
    TextRenderingParameters = property(get_TextRenderingParameters, put_TextRenderingParameters)
    Transform = property(get_Transform, put_Transform)
    Units = property(get_Units, put_Units)
class ICanvasImage(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.ICanvasImage'
    _iid_ = Guid('{794966d3-6a64-47e9-8da8-b46aaa24d53b}')
    @winrt_commethod(6)
    def GetBounds(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_commethod(7)
    def GetBoundsWithTransform(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
class ICanvasImageStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.ICanvasImageStatics'
    _iid_ = Guid('{c54eea15-5a14-489a-8fa0-6e84541f922d}')
    @winrt_commethod(6)
    def SaveAsync(self, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, sourceRectangle: win32more.Windows.Foundation.Rect, dpi: Single, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, stream: win32more.Windows.Storage.Streams.IRandomAccessStream, fileFormat: win32more.Microsoft.Graphics.Canvas.CanvasBitmapFileFormat) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_commethod(7)
    def SaveWithQualityAsync(self, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, sourceRectangle: win32more.Windows.Foundation.Rect, dpi: Single, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, stream: win32more.Windows.Storage.Streams.IRandomAccessStream, fileFormat: win32more.Microsoft.Graphics.Canvas.CanvasBitmapFileFormat, quality: Single) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_commethod(8)
    def SaveWithQualityAndBufferPrecisionAsync(self, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, sourceRectangle: win32more.Windows.Foundation.Rect, dpi: Single, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, stream: win32more.Windows.Storage.Streams.IRandomAccessStream, fileFormat: win32more.Microsoft.Graphics.Canvas.CanvasBitmapFileFormat, quality: Single, bufferPrecision: win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_commethod(9)
    def ComputeHistogram(self, image: win32more.Microsoft.Graphics.Canvas.ICanvasImage, sourceRectangle: win32more.Windows.Foundation.Rect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, channelSelect: win32more.Microsoft.Graphics.Canvas.Effects.EffectChannelSelect, numberOfBins: Int32) -> ReceiveArray[Single]: ...
    @winrt_commethod(10)
    def IsHistogramSupported(self, device: win32more.Microsoft.Graphics.Canvas.CanvasDevice) -> Boolean: ...
class ICanvasLock(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.ICanvasLock'
    _iid_ = Guid('{7a0e8498-fba9-4fb0-aa8c-6a48b5ee3e4f}')
class ICanvasRenderTarget(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.ICanvasRenderTarget'
    _iid_ = Guid('{2d4c7349-9a32-41b9-b3cc-caf1b7e1099b}')
    @winrt_commethod(6)
    def CreateDrawingSession(self) -> win32more.Microsoft.Graphics.Canvas.CanvasDrawingSession: ...
class ICanvasRenderTargetFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.ICanvasRenderTargetFactory'
    _iid_ = Guid('{620dfdbb-9d08-406c-bfe6-d9b81e6df8e7}')
    @winrt_commethod(6)
    def CreateWithSize(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, size: win32more.Windows.Foundation.Size) -> win32more.Microsoft.Graphics.Canvas.CanvasRenderTarget: ...
    @winrt_commethod(7)
    def CreateWithWidthAndHeight(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, width: Single, height: Single) -> win32more.Microsoft.Graphics.Canvas.CanvasRenderTarget: ...
    @winrt_commethod(8)
    def CreateWithWidthAndHeightAndDpi(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, width: Single, height: Single, dpi: Single) -> win32more.Microsoft.Graphics.Canvas.CanvasRenderTarget: ...
    @winrt_commethod(9)
    def CreateWithWidthAndHeightAndDpiAndFormatAndAlpha(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, width: Single, height: Single, dpi: Single, format: win32more.Windows.Graphics.DirectX.DirectXPixelFormat, alpha: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Microsoft.Graphics.Canvas.CanvasRenderTarget: ...
class ICanvasRenderTargetStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.ICanvasRenderTargetStatics'
    _iid_ = Guid('{c7d1fe37-dd57-45d7-bcc1-15625a21e8d5}')
    @winrt_commethod(6)
    def CreateFromDirect3D11Surface(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, surface: win32more.Windows.Graphics.DirectX.Direct3D11.IDirect3DSurface) -> win32more.Microsoft.Graphics.Canvas.CanvasRenderTarget: ...
    @winrt_commethod(7)
    def CreateFromDirect3D11SurfaceWithDpi(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, surface: win32more.Windows.Graphics.DirectX.Direct3D11.IDirect3DSurface, dpi: Single) -> win32more.Microsoft.Graphics.Canvas.CanvasRenderTarget: ...
    @winrt_commethod(8)
    def CreateFromDirect3D11SurfaceWithDpiAndAlpha(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, surface: win32more.Windows.Graphics.DirectX.Direct3D11.IDirect3DSurface, dpi: Single, alpha: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Microsoft.Graphics.Canvas.CanvasRenderTarget: ...
class ICanvasResourceCreator(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.ICanvasResourceCreator'
    _iid_ = Guid('{8f6d8aa8-492f-4bc6-b3d0-e7f5eae84b11}')
    @winrt_commethod(6)
    def get_Device(self) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    Device = property(get_Device, None)
class ICanvasResourceCreatorWithDpi(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi'
    _iid_ = Guid('{1a75b512-e9fa-49e6-a876-38cae194013e}')
    @winrt_commethod(6)
    def get_Dpi(self) -> Single: ...
    @winrt_commethod(7)
    def ConvertPixelsToDips(self, pixels: Int32) -> Single: ...
    @winrt_commethod(8)
    def ConvertDipsToPixels(self, dips: Single, dpiRounding: win32more.Microsoft.Graphics.Canvas.CanvasDpiRounding) -> Int32: ...
    Dpi = property(get_Dpi, None)
class ICanvasSpriteBatch(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.ICanvasSpriteBatch'
    _iid_ = Guid('{a065dce4-a7f2-4df4-8405-ea9e3a215bf8}')
    @winrt_commethod(6)
    def DrawToRect(self, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, destRect: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_commethod(7)
    def DrawAtOffset(self, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, offset: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_commethod(8)
    def DrawWithTransform(self, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> Void: ...
    @winrt_commethod(9)
    def DrawToRectWithTint(self, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, destRect: win32more.Windows.Foundation.Rect, tint: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_commethod(10)
    def DrawAtOffsetWithTint(self, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, offset: win32more.Windows.Foundation.Numerics.Vector2, tint: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_commethod(11)
    def DrawWithTransformAndTint(self, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, transform: win32more.Windows.Foundation.Numerics.Matrix3x2, tint: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_commethod(12)
    def DrawToRectWithTintAndFlip(self, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, destRect: win32more.Windows.Foundation.Rect, tint: win32more.Windows.Foundation.Numerics.Vector4, flip: win32more.Microsoft.Graphics.Canvas.CanvasSpriteFlip) -> Void: ...
    @winrt_commethod(13)
    def DrawWithTransformAndTintAndFlip(self, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, transform: win32more.Windows.Foundation.Numerics.Matrix3x2, tint: win32more.Windows.Foundation.Numerics.Vector4, flip: win32more.Microsoft.Graphics.Canvas.CanvasSpriteFlip) -> Void: ...
    @winrt_commethod(14)
    def DrawAtOffsetWithTintAndTransform(self, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, offset: win32more.Windows.Foundation.Numerics.Vector2, tint: win32more.Windows.Foundation.Numerics.Vector4, origin: win32more.Windows.Foundation.Numerics.Vector2, rotation: Single, scale: win32more.Windows.Foundation.Numerics.Vector2, flip: win32more.Microsoft.Graphics.Canvas.CanvasSpriteFlip) -> Void: ...
    @winrt_commethod(15)
    def DrawFromSpriteSheetToRect(self, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, destRect: win32more.Windows.Foundation.Rect, sourceRect: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_commethod(16)
    def DrawFromSpriteSheetAtOffset(self, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, offset: win32more.Windows.Foundation.Numerics.Vector2, sourceRect: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_commethod(17)
    def DrawFromSpriteSheetWithTransform(self, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, transform: win32more.Windows.Foundation.Numerics.Matrix3x2, sourceRect: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_commethod(18)
    def DrawFromSpriteSheetToRectWithTint(self, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, destRect: win32more.Windows.Foundation.Rect, sourceRect: win32more.Windows.Foundation.Rect, tint: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_commethod(19)
    def DrawFromSpriteSheetAtOffsetWithTint(self, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, offset: win32more.Windows.Foundation.Numerics.Vector2, sourceRect: win32more.Windows.Foundation.Rect, tint: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_commethod(20)
    def DrawFromSpriteSheetWithTransformAndTint(self, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, transform: win32more.Windows.Foundation.Numerics.Matrix3x2, sourceRect: win32more.Windows.Foundation.Rect, tint: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_commethod(21)
    def DrawFromSpriteSheetToRectWithTintAndFlip(self, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, destRect: win32more.Windows.Foundation.Rect, sourceRect: win32more.Windows.Foundation.Rect, tint: win32more.Windows.Foundation.Numerics.Vector4, flip: win32more.Microsoft.Graphics.Canvas.CanvasSpriteFlip) -> Void: ...
    @winrt_commethod(22)
    def DrawFromSpriteSheetWithTransformAndTintAndFlip(self, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, transform: win32more.Windows.Foundation.Numerics.Matrix3x2, sourceRect: win32more.Windows.Foundation.Rect, tint: win32more.Windows.Foundation.Numerics.Vector4, flip: win32more.Microsoft.Graphics.Canvas.CanvasSpriteFlip) -> Void: ...
    @winrt_commethod(23)
    def DrawFromSpriteSheetAtOffsetWithTintAndTransform(self, bitmap: win32more.Microsoft.Graphics.Canvas.CanvasBitmap, offset: win32more.Windows.Foundation.Numerics.Vector2, sourceRect: win32more.Windows.Foundation.Rect, tint: win32more.Windows.Foundation.Numerics.Vector4, origin: win32more.Windows.Foundation.Numerics.Vector2, rotation: Single, scale: win32more.Windows.Foundation.Numerics.Vector2, flip: win32more.Microsoft.Graphics.Canvas.CanvasSpriteFlip) -> Void: ...
class ICanvasSpriteBatchStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.ICanvasSpriteBatchStatics'
    _iid_ = Guid('{851eb08d-9d01-4b57-9e94-24113151b74b}')
    @winrt_commethod(6)
    def IsSupported(self, device: win32more.Microsoft.Graphics.Canvas.CanvasDevice) -> Boolean: ...
class ICanvasSwapChain(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.ICanvasSwapChain'
    _iid_ = Guid('{882e3c3a-5725-409c-9e76-f80b3bacf1b4}')
    @winrt_commethod(6)
    def Present(self) -> Void: ...
    @winrt_commethod(7)
    def PresentWithSyncInterval(self, syncInterval: Int32) -> Void: ...
    @winrt_commethod(8)
    def ResizeBuffersWithSize(self, newSize: win32more.Windows.Foundation.Size) -> Void: ...
    @winrt_commethod(9)
    def ResizeBuffersWithWidthAndHeight(self, newWidth: Single, newHeight: Single) -> Void: ...
    @winrt_commethod(10)
    def ResizeBuffersWithWidthAndHeightAndDpi(self, newWidth: Single, newHeight: Single, newDpi: Single) -> Void: ...
    @winrt_commethod(11)
    def ResizeBuffersWithAllOptions(self, newWidth: Single, newHeight: Single, newDpi: Single, newFormat: win32more.Windows.Graphics.DirectX.DirectXPixelFormat, bufferCount: Int32) -> Void: ...
    @winrt_commethod(12)
    def get_Size(self) -> win32more.Windows.Foundation.Size: ...
    @winrt_commethod(13)
    def get_SizeInPixels(self) -> win32more.Windows.Graphics.Imaging.BitmapSize: ...
    @winrt_commethod(14)
    def get_Format(self) -> win32more.Windows.Graphics.DirectX.DirectXPixelFormat: ...
    @winrt_commethod(15)
    def get_BufferCount(self) -> Int32: ...
    @winrt_commethod(16)
    def get_AlphaMode(self) -> win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode: ...
    @winrt_commethod(17)
    def get_Rotation(self) -> win32more.Microsoft.Graphics.Canvas.CanvasSwapChainRotation: ...
    @winrt_commethod(18)
    def put_Rotation(self, value: win32more.Microsoft.Graphics.Canvas.CanvasSwapChainRotation) -> Void: ...
    @winrt_commethod(19)
    def get_SourceSize(self) -> win32more.Windows.Foundation.Size: ...
    @winrt_commethod(20)
    def put_SourceSize(self, value: win32more.Windows.Foundation.Size) -> Void: ...
    @winrt_commethod(21)
    def get_TransformMatrix(self) -> win32more.Windows.Foundation.Numerics.Matrix3x2: ...
    @winrt_commethod(22)
    def put_TransformMatrix(self, value: win32more.Windows.Foundation.Numerics.Matrix3x2) -> Void: ...
    @winrt_commethod(23)
    def CreateDrawingSession(self, clearColor: win32more.Windows.UI.Color) -> win32more.Microsoft.Graphics.Canvas.CanvasDrawingSession: ...
    @winrt_commethod(24)
    def WaitForVerticalBlank(self) -> Void: ...
    AlphaMode = property(get_AlphaMode, None)
    BufferCount = property(get_BufferCount, None)
    Format = property(get_Format, None)
    Rotation = property(get_Rotation, put_Rotation)
    Size = property(get_Size, None)
    SizeInPixels = property(get_SizeInPixels, None)
    SourceSize = property(get_SourceSize, put_SourceSize)
    TransformMatrix = property(get_TransformMatrix, put_TransformMatrix)
class ICanvasSwapChainFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.ICanvasSwapChainFactory'
    _iid_ = Guid('{133c25cb-ed3c-492b-bffe-7509b521842b}')
    @winrt_commethod(6)
    def CreateWithSize(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, size: win32more.Windows.Foundation.Size) -> win32more.Microsoft.Graphics.Canvas.CanvasSwapChain: ...
    @winrt_commethod(7)
    def CreateWithWidthAndHeight(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, width: Single, height: Single) -> win32more.Microsoft.Graphics.Canvas.CanvasSwapChain: ...
    @winrt_commethod(8)
    def CreateWithWidthAndHeightAndDpi(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, width: Single, height: Single, dpi: Single) -> win32more.Microsoft.Graphics.Canvas.CanvasSwapChain: ...
    @winrt_commethod(9)
    def CreateWithAllOptions(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, width: Single, height: Single, dpi: Single, format: win32more.Windows.Graphics.DirectX.DirectXPixelFormat, bufferCount: Int32, alphaMode: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Microsoft.Graphics.Canvas.CanvasSwapChain: ...
class ICanvasSwapChainStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.ICanvasSwapChainStatics'
    _iid_ = Guid('{05376d8f-3e8d-4a82-9838-691680d32a52}')
    @winrt_commethod(6)
    def CreateForCoreWindowWithDpi(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, coreWindow: win32more.Windows.UI.Core.CoreWindow, dpi: Single) -> win32more.Microsoft.Graphics.Canvas.CanvasSwapChain: ...
    @winrt_commethod(7)
    def CreateForCoreWindowWithAllOptions(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, coreWindow: win32more.Windows.UI.Core.CoreWindow, width: Single, height: Single, dpi: Single, format: win32more.Windows.Graphics.DirectX.DirectXPixelFormat, bufferCount: Int32) -> win32more.Microsoft.Graphics.Canvas.CanvasSwapChain: ...
    @winrt_commethod(8)
    def CreateForWindowIdWithDpi(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, windowId: win32more.Microsoft.UI.WindowId, width: Single, height: Single, dpi: Single) -> win32more.Microsoft.Graphics.Canvas.CanvasSwapChain: ...
    @winrt_commethod(9)
    def CreateForWindowIdWithAllOptions(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, windowId: win32more.Microsoft.UI.WindowId, width: Single, height: Single, dpi: Single, format: win32more.Windows.Graphics.DirectX.DirectXPixelFormat, bufferCount: Int32) -> win32more.Microsoft.Graphics.Canvas.CanvasSwapChain: ...
class ICanvasVirtualBitmap(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.ICanvasVirtualBitmap'
    _iid_ = Guid('{707d8bb0-05f9-484c-9ee2-179e0681c8a7}')
    @winrt_commethod(6)
    def get_Device(self) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    @winrt_commethod(7)
    def get_IsCachedOnDemand(self) -> Boolean: ...
    @winrt_commethod(8)
    def get_SizeInPixels(self) -> win32more.Windows.Graphics.Imaging.BitmapSize: ...
    @winrt_commethod(9)
    def get_Size(self) -> win32more.Windows.Foundation.Size: ...
    @winrt_commethod(10)
    def get_Bounds(self) -> win32more.Windows.Foundation.Rect: ...
    Bounds = property(get_Bounds, None)
    Device = property(get_Device, None)
    IsCachedOnDemand = property(get_IsCachedOnDemand, None)
    Size = property(get_Size, None)
    SizeInPixels = property(get_SizeInPixels, None)
class ICanvasVirtualBitmapStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.ICanvasVirtualBitmapStatics'
    _iid_ = Guid('{b2f1f8e9-0770-4dd4-956d-78d911390957}')
    @winrt_commethod(6)
    def LoadAsyncFromFileName(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, fileName: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasVirtualBitmap]: ...
    @winrt_commethod(7)
    def LoadAsyncFromFileNameWithOptions(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, fileName: WinRT_String, options: win32more.Microsoft.Graphics.Canvas.CanvasVirtualBitmapOptions) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasVirtualBitmap]: ...
    @winrt_commethod(8)
    def LoadAsyncFromFileNameWithOptionsAndAlpha(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, fileName: WinRT_String, options: win32more.Microsoft.Graphics.Canvas.CanvasVirtualBitmapOptions, alpha: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasVirtualBitmap]: ...
    @winrt_commethod(9)
    def LoadAsyncFromUri(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, uri: win32more.Windows.Foundation.Uri) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasVirtualBitmap]: ...
    @winrt_commethod(10)
    def LoadAsyncFromUriWithOptions(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, uri: win32more.Windows.Foundation.Uri, options: win32more.Microsoft.Graphics.Canvas.CanvasVirtualBitmapOptions) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasVirtualBitmap]: ...
    @winrt_commethod(11)
    def LoadAsyncFromUriWithOptionsAndAlpha(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, uri: win32more.Windows.Foundation.Uri, options: win32more.Microsoft.Graphics.Canvas.CanvasVirtualBitmapOptions, alpha: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasVirtualBitmap]: ...
    @winrt_commethod(12)
    def LoadAsyncFromStream(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, stream: win32more.Windows.Storage.Streams.IRandomAccessStream) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasVirtualBitmap]: ...
    @winrt_commethod(13)
    def LoadAsyncFromStreamWithOptions(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, stream: win32more.Windows.Storage.Streams.IRandomAccessStream, options: win32more.Microsoft.Graphics.Canvas.CanvasVirtualBitmapOptions) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasVirtualBitmap]: ...
    @winrt_commethod(14)
    def LoadAsyncFromStreamWithOptionsAndAlpha(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, stream: win32more.Windows.Storage.Streams.IRandomAccessStream, options: win32more.Microsoft.Graphics.Canvas.CanvasVirtualBitmapOptions, alpha: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.CanvasVirtualBitmap]: ...


make_ready(__name__)
