from __future__ import annotations
from win32more import ARCH, Annotated, Boolean, Byte, Bytes, Char, ComPtr, ConstantLazyLoader, Double, Enum, FAILED, FlexibleArray, Guid, Int16, Int32, Int64, IntPtr, NativeBitfieldAttribute, POINTER, SByte, SUCCEEDED, Single, String, Structure, UInt16, UInt32, UInt64, UIntPtr, UnicodeAlias, Union, Void, VoidPtr, cfunctype, cfunctype_pointer, commethod, make_ready, winfunctype, winfunctype_pointer
from win32more._winrt import AwaitableProtocol, ContextManagerProtocol, FillArray, Generic, IInspectable, IUnknown, IterableProtocol, K, MappingProtocol, MulticastDelegate, PassArray, ReceiveArray, SequenceProtocol, T, TProgress, TResult, TSender, Tuple, V, WinRT_String, event, winrt_activatemethod, winrt_classmethod, winrt_commethod, winrt_factorymethod, winrt_mixinmethod, winrt_overload
import win32more.Microsoft.Windows.ApplicationModel.DynamicDependency
import win32more.Microsoft.Windows.Management.Deployment
import win32more.Windows.ApplicationModel
import win32more.Windows.Foundation
import win32more.Windows.Foundation.Collections
class AddPackageOptions(ComPtr):
    extends: IInspectable
    default_interface: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions
    _classid_ = 'Microsoft.Windows.Management.Deployment.AddPackageOptions'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Windows.Management.Deployment.AddPackageOptions.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Windows.Management.Deployment.AddPackageOptions: ...
    @winrt_mixinmethod
    def get_TargetVolume(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions) -> win32more.Microsoft.Windows.Management.Deployment.PackageVolume: ...
    @winrt_mixinmethod
    def put_TargetVolume(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions, value: win32more.Microsoft.Windows.Management.Deployment.PackageVolume) -> Void: ...
    @winrt_mixinmethod
    def get_DependencyPackageUris(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_mixinmethod
    def get_OptionalPackageFamilyNames(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions) -> win32more.Windows.Foundation.Collections.IVector[WinRT_String]: ...
    @winrt_mixinmethod
    def get_OptionalPackageUris(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_mixinmethod
    def get_RelatedPackageUris(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_mixinmethod
    def get_ExternalLocationUri(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def put_ExternalLocationUri(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_mixinmethod
    def get_StubPackageOption(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions) -> win32more.Microsoft.Windows.Management.Deployment.StubPackageOption: ...
    @winrt_mixinmethod
    def put_StubPackageOption(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions, value: win32more.Microsoft.Windows.Management.Deployment.StubPackageOption) -> Void: ...
    @winrt_mixinmethod
    def get_AllowUnsigned(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_AllowUnsigned(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_DeveloperMode(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_DeveloperMode(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_ForceAppShutdown(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_ForceAppShutdown(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_ForceTargetAppShutdown(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_ForceTargetAppShutdown(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_ForceUpdateFromAnyVersion(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_ForceUpdateFromAnyVersion(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_InstallAllResources(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_InstallAllResources(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_RequiredContentGroupOnly(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_RequiredContentGroupOnly(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_RetainFilesOnFailure(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_RetainFilesOnFailure(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_StageInPlace(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_StageInPlace(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_DeferRegistrationWhenPackagesAreInUse(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_DeferRegistrationWhenPackagesAreInUse(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_IsExpectedDigestsSupported(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def get_ExpectedDigests(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions) -> win32more.Windows.Foundation.Collections.IMap[win32more.Windows.Foundation.Uri, WinRT_String]: ...
    @winrt_mixinmethod
    def get_IsLimitToExistingPackagesSupported(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def get_LimitToExistingPackages(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_LimitToExistingPackages(self: win32more.Microsoft.Windows.Management.Deployment.IAddPackageOptions, value: Boolean) -> Void: ...
    AllowUnsigned = property(get_AllowUnsigned, put_AllowUnsigned)
    DeferRegistrationWhenPackagesAreInUse = property(get_DeferRegistrationWhenPackagesAreInUse, put_DeferRegistrationWhenPackagesAreInUse)
    DependencyPackageUris = property(get_DependencyPackageUris, None)
    DeveloperMode = property(get_DeveloperMode, put_DeveloperMode)
    ExpectedDigests = property(get_ExpectedDigests, None)
    ExternalLocationUri = property(get_ExternalLocationUri, put_ExternalLocationUri)
    ForceAppShutdown = property(get_ForceAppShutdown, put_ForceAppShutdown)
    ForceTargetAppShutdown = property(get_ForceTargetAppShutdown, put_ForceTargetAppShutdown)
    ForceUpdateFromAnyVersion = property(get_ForceUpdateFromAnyVersion, put_ForceUpdateFromAnyVersion)
    InstallAllResources = property(get_InstallAllResources, put_InstallAllResources)
    IsExpectedDigestsSupported = property(get_IsExpectedDigestsSupported, None)
    IsLimitToExistingPackagesSupported = property(get_IsLimitToExistingPackagesSupported, None)
    LimitToExistingPackages = property(get_LimitToExistingPackages, put_LimitToExistingPackages)
    OptionalPackageFamilyNames = property(get_OptionalPackageFamilyNames, None)
    OptionalPackageUris = property(get_OptionalPackageUris, None)
    RelatedPackageUris = property(get_RelatedPackageUris, None)
    RequiredContentGroupOnly = property(get_RequiredContentGroupOnly, put_RequiredContentGroupOnly)
    RetainFilesOnFailure = property(get_RetainFilesOnFailure, put_RetainFilesOnFailure)
    StageInPlace = property(get_StageInPlace, put_StageInPlace)
    StubPackageOption = property(get_StubPackageOption, put_StubPackageOption)
    TargetVolume = property(get_TargetVolume, put_TargetVolume)
class EnsureReadyOptions(ComPtr):
    extends: IInspectable
    default_interface: win32more.Microsoft.Windows.Management.Deployment.IEnsureReadyOptions
    _classid_ = 'Microsoft.Windows.Management.Deployment.EnsureReadyOptions'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Windows.Management.Deployment.EnsureReadyOptions.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Windows.Management.Deployment.EnsureReadyOptions: ...
    @winrt_mixinmethod
    def get_AddPackageOptions(self: win32more.Microsoft.Windows.Management.Deployment.IEnsureReadyOptions) -> win32more.Microsoft.Windows.Management.Deployment.AddPackageOptions: ...
    @winrt_mixinmethod
    def get_RegisterNewerIfAvailable(self: win32more.Microsoft.Windows.Management.Deployment.IEnsureReadyOptions2) -> Boolean: ...
    @winrt_mixinmethod
    def put_RegisterNewerIfAvailable(self: win32more.Microsoft.Windows.Management.Deployment.IEnsureReadyOptions2, value: Boolean) -> Void: ...
    AddPackageOptions = property(get_AddPackageOptions, None)
    RegisterNewerIfAvailable = property(get_RegisterNewerIfAvailable, put_RegisterNewerIfAvailable)
class IAddPackageOptions(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Windows.Management.Deployment.IAddPackageOptions'
    _iid_ = Guid('{e3db7f39-f9d0-5884-bdef-6153b54574a3}')
    @winrt_commethod(6)
    def get_TargetVolume(self) -> win32more.Microsoft.Windows.Management.Deployment.PackageVolume: ...
    @winrt_commethod(7)
    def put_TargetVolume(self, value: win32more.Microsoft.Windows.Management.Deployment.PackageVolume) -> Void: ...
    @winrt_commethod(8)
    def get_DependencyPackageUris(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_commethod(9)
    def get_OptionalPackageFamilyNames(self) -> win32more.Windows.Foundation.Collections.IVector[WinRT_String]: ...
    @winrt_commethod(10)
    def get_OptionalPackageUris(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_commethod(11)
    def get_RelatedPackageUris(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_commethod(12)
    def get_ExternalLocationUri(self) -> win32more.Windows.Foundation.Uri: ...
    @winrt_commethod(13)
    def put_ExternalLocationUri(self, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_commethod(14)
    def get_StubPackageOption(self) -> win32more.Microsoft.Windows.Management.Deployment.StubPackageOption: ...
    @winrt_commethod(15)
    def put_StubPackageOption(self, value: win32more.Microsoft.Windows.Management.Deployment.StubPackageOption) -> Void: ...
    @winrt_commethod(16)
    def get_AllowUnsigned(self) -> Boolean: ...
    @winrt_commethod(17)
    def put_AllowUnsigned(self, value: Boolean) -> Void: ...
    @winrt_commethod(18)
    def get_DeveloperMode(self) -> Boolean: ...
    @winrt_commethod(19)
    def put_DeveloperMode(self, value: Boolean) -> Void: ...
    @winrt_commethod(20)
    def get_ForceAppShutdown(self) -> Boolean: ...
    @winrt_commethod(21)
    def put_ForceAppShutdown(self, value: Boolean) -> Void: ...
    @winrt_commethod(22)
    def get_ForceTargetAppShutdown(self) -> Boolean: ...
    @winrt_commethod(23)
    def put_ForceTargetAppShutdown(self, value: Boolean) -> Void: ...
    @winrt_commethod(24)
    def get_ForceUpdateFromAnyVersion(self) -> Boolean: ...
    @winrt_commethod(25)
    def put_ForceUpdateFromAnyVersion(self, value: Boolean) -> Void: ...
    @winrt_commethod(26)
    def get_InstallAllResources(self) -> Boolean: ...
    @winrt_commethod(27)
    def put_InstallAllResources(self, value: Boolean) -> Void: ...
    @winrt_commethod(28)
    def get_RequiredContentGroupOnly(self) -> Boolean: ...
    @winrt_commethod(29)
    def put_RequiredContentGroupOnly(self, value: Boolean) -> Void: ...
    @winrt_commethod(30)
    def get_RetainFilesOnFailure(self) -> Boolean: ...
    @winrt_commethod(31)
    def put_RetainFilesOnFailure(self, value: Boolean) -> Void: ...
    @winrt_commethod(32)
    def get_StageInPlace(self) -> Boolean: ...
    @winrt_commethod(33)
    def put_StageInPlace(self, value: Boolean) -> Void: ...
    @winrt_commethod(34)
    def get_DeferRegistrationWhenPackagesAreInUse(self) -> Boolean: ...
    @winrt_commethod(35)
    def put_DeferRegistrationWhenPackagesAreInUse(self, value: Boolean) -> Void: ...
    @winrt_commethod(36)
    def get_IsExpectedDigestsSupported(self) -> Boolean: ...
    @winrt_commethod(37)
    def get_ExpectedDigests(self) -> win32more.Windows.Foundation.Collections.IMap[win32more.Windows.Foundation.Uri, WinRT_String]: ...
    @winrt_commethod(38)
    def get_IsLimitToExistingPackagesSupported(self) -> Boolean: ...
    @winrt_commethod(39)
    def get_LimitToExistingPackages(self) -> Boolean: ...
    @winrt_commethod(40)
    def put_LimitToExistingPackages(self, value: Boolean) -> Void: ...
    AllowUnsigned = property(get_AllowUnsigned, put_AllowUnsigned)
    DeferRegistrationWhenPackagesAreInUse = property(get_DeferRegistrationWhenPackagesAreInUse, put_DeferRegistrationWhenPackagesAreInUse)
    DependencyPackageUris = property(get_DependencyPackageUris, None)
    DeveloperMode = property(get_DeveloperMode, put_DeveloperMode)
    ExpectedDigests = property(get_ExpectedDigests, None)
    ExternalLocationUri = property(get_ExternalLocationUri, put_ExternalLocationUri)
    ForceAppShutdown = property(get_ForceAppShutdown, put_ForceAppShutdown)
    ForceTargetAppShutdown = property(get_ForceTargetAppShutdown, put_ForceTargetAppShutdown)
    ForceUpdateFromAnyVersion = property(get_ForceUpdateFromAnyVersion, put_ForceUpdateFromAnyVersion)
    InstallAllResources = property(get_InstallAllResources, put_InstallAllResources)
    IsExpectedDigestsSupported = property(get_IsExpectedDigestsSupported, None)
    IsLimitToExistingPackagesSupported = property(get_IsLimitToExistingPackagesSupported, None)
    LimitToExistingPackages = property(get_LimitToExistingPackages, put_LimitToExistingPackages)
    OptionalPackageFamilyNames = property(get_OptionalPackageFamilyNames, None)
    OptionalPackageUris = property(get_OptionalPackageUris, None)
    RelatedPackageUris = property(get_RelatedPackageUris, None)
    RequiredContentGroupOnly = property(get_RequiredContentGroupOnly, put_RequiredContentGroupOnly)
    RetainFilesOnFailure = property(get_RetainFilesOnFailure, put_RetainFilesOnFailure)
    StageInPlace = property(get_StageInPlace, put_StageInPlace)
    StubPackageOption = property(get_StubPackageOption, put_StubPackageOption)
    TargetVolume = property(get_TargetVolume, put_TargetVolume)
class IEnsureReadyOptions(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Windows.Management.Deployment.IEnsureReadyOptions'
    _iid_ = Guid('{20102d03-ec44-5c2b-8fd6-1104dc99755d}')
    @winrt_commethod(6)
    def get_AddPackageOptions(self) -> win32more.Microsoft.Windows.Management.Deployment.AddPackageOptions: ...
    AddPackageOptions = property(get_AddPackageOptions, None)
class IEnsureReadyOptions2(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Windows.Management.Deployment.IEnsureReadyOptions2'
    _iid_ = Guid('{eefa9259-b13a-50a3-919e-ae116d83c0da}')
    @winrt_commethod(6)
    def get_RegisterNewerIfAvailable(self) -> Boolean: ...
    @winrt_commethod(7)
    def put_RegisterNewerIfAvailable(self, value: Boolean) -> Void: ...
    RegisterNewerIfAvailable = property(get_RegisterNewerIfAvailable, put_RegisterNewerIfAvailable)
class IPackageDeploymentManager(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Windows.Management.Deployment.IPackageDeploymentManager'
    _iid_ = Guid('{f41717d8-5ab2-57ac-83cd-d0c48cc784cd}')
    @winrt_commethod(6)
    def IsPackageReady(self, package: WinRT_String) -> Boolean: ...
    @winrt_commethod(7)
    def IsPackageReadyByUri(self, packageUri: win32more.Windows.Foundation.Uri) -> Boolean: ...
    @winrt_commethod(8)
    def IsPackageSetReady(self, packageSet: win32more.Microsoft.Windows.Management.Deployment.PackageSet) -> Boolean: ...
    @winrt_commethod(9)
    def EnsurePackageReadyAsync(self, package: WinRT_String, options: win32more.Microsoft.Windows.Management.Deployment.EnsureReadyOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_commethod(10)
    def EnsurePackageReadyByUriAsync(self, packageUri: win32more.Windows.Foundation.Uri, options: win32more.Microsoft.Windows.Management.Deployment.EnsureReadyOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_commethod(11)
    def EnsurePackageSetReadyAsync(self, packageSet: win32more.Microsoft.Windows.Management.Deployment.PackageSet, options: win32more.Microsoft.Windows.Management.Deployment.EnsureReadyOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_commethod(12)
    def AddPackageAsync(self, package: WinRT_String, options: win32more.Microsoft.Windows.Management.Deployment.AddPackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_commethod(13)
    def AddPackageByUriAsync(self, packageUri: win32more.Windows.Foundation.Uri, options: win32more.Microsoft.Windows.Management.Deployment.AddPackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_commethod(14)
    def AddPackageSetAsync(self, packageSet: win32more.Microsoft.Windows.Management.Deployment.PackageSet, options: win32more.Microsoft.Windows.Management.Deployment.AddPackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_commethod(15)
    def StagePackageAsync(self, package: WinRT_String, options: win32more.Microsoft.Windows.Management.Deployment.StagePackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_commethod(16)
    def StagePackageByUriAsync(self, packageUri: win32more.Windows.Foundation.Uri, options: win32more.Microsoft.Windows.Management.Deployment.StagePackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_commethod(17)
    def StagePackageSetAsync(self, packageSet: win32more.Microsoft.Windows.Management.Deployment.PackageSet, options: win32more.Microsoft.Windows.Management.Deployment.StagePackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_commethod(18)
    def RegisterPackageAsync(self, package: WinRT_String, options: win32more.Microsoft.Windows.Management.Deployment.RegisterPackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_commethod(19)
    def RegisterPackageByUriAsync(self, packageUri: win32more.Windows.Foundation.Uri, options: win32more.Microsoft.Windows.Management.Deployment.RegisterPackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_commethod(20)
    def RegisterPackageSetAsync(self, packageSet: win32more.Microsoft.Windows.Management.Deployment.PackageSet, options: win32more.Microsoft.Windows.Management.Deployment.RegisterPackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_commethod(21)
    def RemovePackageAsync(self, package: WinRT_String, options: win32more.Microsoft.Windows.Management.Deployment.RemovePackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_commethod(22)
    def RemovePackageByFullNameAsync(self, packageFullName: WinRT_String, options: win32more.Microsoft.Windows.Management.Deployment.RemovePackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_commethod(23)
    def RemovePackageByFamilyNameAsync(self, packageFamilyName: WinRT_String, options: win32more.Microsoft.Windows.Management.Deployment.RemovePackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_commethod(24)
    def RemovePackageByUriAsync(self, packageUri: win32more.Windows.Foundation.Uri, options: win32more.Microsoft.Windows.Management.Deployment.RemovePackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_commethod(25)
    def RemovePackageSetAsync(self, packageSet: win32more.Microsoft.Windows.Management.Deployment.PackageSet, options: win32more.Microsoft.Windows.Management.Deployment.RemovePackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_commethod(26)
    def ResetPackageAsync(self, package: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_commethod(27)
    def ResetPackageByUriAsync(self, packageUri: win32more.Windows.Foundation.Uri) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_commethod(28)
    def ResetPackageSetAsync(self, packageSet: win32more.Microsoft.Windows.Management.Deployment.PackageSet) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_commethod(29)
    def RepairPackageAsync(self, package: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_commethod(30)
    def RepairPackageByUriAsync(self, packageUri: win32more.Windows.Foundation.Uri) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_commethod(31)
    def RepairPackageSetAsync(self, packageSet: win32more.Microsoft.Windows.Management.Deployment.PackageSet) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_commethod(32)
    def ProvisionPackageAsync(self, package: WinRT_String, options: win32more.Microsoft.Windows.Management.Deployment.ProvisionPackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_commethod(33)
    def ProvisionPackageByUriAsync(self, packageUri: win32more.Windows.Foundation.Uri, options: win32more.Microsoft.Windows.Management.Deployment.ProvisionPackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_commethod(34)
    def ProvisionPackageSetAsync(self, packageSet: win32more.Microsoft.Windows.Management.Deployment.PackageSet, options: win32more.Microsoft.Windows.Management.Deployment.ProvisionPackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_commethod(35)
    def DeprovisionPackageAsync(self, package: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_commethod(36)
    def DeprovisionPackageByUriAsync(self, packageUri: win32more.Windows.Foundation.Uri) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_commethod(37)
    def DeprovisionPackageSetAsync(self, packageSet: win32more.Microsoft.Windows.Management.Deployment.PackageSet) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_commethod(38)
    def IsPackageRegistrationPending(self, packageFamilyName: WinRT_String) -> Boolean: ...
    @winrt_commethod(39)
    def IsPackageRegistrationPendingForUser(self, userSecurityId: WinRT_String, packageFamilyName: WinRT_String) -> Boolean: ...
class IPackageDeploymentManager2(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Windows.Management.Deployment.IPackageDeploymentManager2'
    _iid_ = Guid('{6fc6d0f3-f9dd-5c14-9d3f-077165eddf98}')
    @winrt_commethod(6)
    def IsPackageReadyOrNewerAvailable(self, package: WinRT_String) -> win32more.Microsoft.Windows.Management.Deployment.PackageReadyOrNewerAvailableStatus: ...
    @winrt_commethod(7)
    def IsPackageReadyOrNewerAvailableByUri(self, packageUri: win32more.Windows.Foundation.Uri) -> win32more.Microsoft.Windows.Management.Deployment.PackageReadyOrNewerAvailableStatus: ...
    @winrt_commethod(8)
    def IsPackageSetReadyOrNewerAvailable(self, packageSet: win32more.Microsoft.Windows.Management.Deployment.PackageSet) -> win32more.Microsoft.Windows.Management.Deployment.PackageReadyOrNewerAvailableStatus: ...
    @winrt_commethod(9)
    def IsPackageProvisioned(self, package: WinRT_String) -> Boolean: ...
    @winrt_commethod(10)
    def IsPackageProvisionedByUri(self, packageUri: win32more.Windows.Foundation.Uri) -> Boolean: ...
    @winrt_commethod(11)
    def IsPackageSetProvisioned(self, packageSet: win32more.Microsoft.Windows.Management.Deployment.PackageSet) -> Boolean: ...
class IPackageDeploymentManagerStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Windows.Management.Deployment.IPackageDeploymentManagerStatics'
    _iid_ = Guid('{dbda4ac6-ca28-59b8-9fc6-dbfb5765f1c2}')
    @winrt_commethod(6)
    def GetDefault(self) -> win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentManager: ...
class IPackageDeploymentManagerStatics2(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Windows.Management.Deployment.IPackageDeploymentManagerStatics2'
    _iid_ = Guid('{0ec31486-00b5-5937-8cd4-759260fdc4a2}')
    @winrt_commethod(6)
    def IsPackageDeploymentFeatureSupported(self, feature: win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentFeature) -> Boolean: ...
class IPackageDeploymentResult(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Windows.Management.Deployment.IPackageDeploymentResult'
    _iid_ = Guid('{d6b99601-18c2-599e-8bd1-40a9310ad263}')
    @winrt_commethod(6)
    def get_Status(self) -> win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentStatus: ...
    @winrt_commethod(7)
    def get_Error(self) -> win32more.Windows.Foundation.HResult: ...
    @winrt_commethod(8)
    def get_ExtendedError(self) -> win32more.Windows.Foundation.HResult: ...
    @winrt_commethod(9)
    def get_ErrorText(self) -> WinRT_String: ...
    @winrt_commethod(10)
    def get_ActivityId(self) -> Guid: ...
    ActivityId = property(get_ActivityId, None)
    Error = property(get_Error, None)
    ErrorText = property(get_ErrorText, None)
    ExtendedError = property(get_ExtendedError, None)
    Status = property(get_Status, None)
class IPackageRuntimeManager(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Windows.Management.Deployment.IPackageRuntimeManager'
    _iid_ = Guid('{6bf0fd29-6c2a-58d1-af0c-abd2eac45e29}')
    @winrt_commethod(6)
    def AddPackageSet(self, packageSet: win32more.Microsoft.Windows.Management.Deployment.PackageSet) -> win32more.Microsoft.Windows.Management.Deployment.PackageSetRuntimeDisposition: ...
    @winrt_commethod(7)
    def AddPackageSetWithOptions(self, packageSet: win32more.Microsoft.Windows.Management.Deployment.PackageSet, createOptions: win32more.Microsoft.Windows.ApplicationModel.DynamicDependency.CreatePackageDependencyOptions, addOptions: win32more.Microsoft.Windows.ApplicationModel.DynamicDependency.AddPackageDependencyOptions) -> win32more.Microsoft.Windows.Management.Deployment.PackageSetRuntimeDisposition: ...
    @winrt_commethod(8)
    def RemovePackageSet(self, packageSetRuntimeDisposition: win32more.Microsoft.Windows.Management.Deployment.PackageSetRuntimeDisposition) -> Void: ...
class IPackageRuntimeManagerStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Windows.Management.Deployment.IPackageRuntimeManagerStatics'
    _iid_ = Guid('{790947de-01d4-5858-aa69-9c9390fb7d3e}')
    @winrt_commethod(6)
    def GetDefault(self) -> win32more.Microsoft.Windows.Management.Deployment.PackageRuntimeManager: ...
class IPackageSet(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Windows.Management.Deployment.IPackageSet'
    _iid_ = Guid('{229fdf93-8529-5f8d-988c-af8a39ad46f7}')
    @winrt_commethod(6)
    def get_Id(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def put_Id(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(8)
    def get_PackageUri(self) -> win32more.Windows.Foundation.Uri: ...
    @winrt_commethod(9)
    def put_PackageUri(self, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_commethod(10)
    def get_Items(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Microsoft.Windows.Management.Deployment.PackageSetItem]: ...
    Id = property(get_Id, put_Id)
    Items = property(get_Items, None)
    PackageUri = property(get_PackageUri, put_PackageUri)
class IPackageSetItem(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Windows.Management.Deployment.IPackageSetItem'
    _iid_ = Guid('{8f254e15-c371-550f-b4e8-3f0bb1ae375f}')
    @winrt_commethod(6)
    def get_Id(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def put_Id(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(8)
    def get_PackageFamilyName(self) -> WinRT_String: ...
    @winrt_commethod(9)
    def put_PackageFamilyName(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(10)
    def get_MinVersion(self) -> win32more.Windows.ApplicationModel.PackageVersion: ...
    @winrt_commethod(11)
    def put_MinVersion(self, value: win32more.Windows.ApplicationModel.PackageVersion) -> Void: ...
    @winrt_commethod(12)
    def get_ProcessorArchitectureFilter(self) -> win32more.Microsoft.Windows.ApplicationModel.DynamicDependency.PackageDependencyProcessorArchitectures: ...
    @winrt_commethod(13)
    def put_ProcessorArchitectureFilter(self, value: win32more.Microsoft.Windows.ApplicationModel.DynamicDependency.PackageDependencyProcessorArchitectures) -> Void: ...
    @winrt_commethod(14)
    def get_PackageUri(self) -> win32more.Windows.Foundation.Uri: ...
    @winrt_commethod(15)
    def put_PackageUri(self, value: win32more.Windows.Foundation.Uri) -> Void: ...
    Id = property(get_Id, put_Id)
    MinVersion = property(get_MinVersion, put_MinVersion)
    PackageFamilyName = property(get_PackageFamilyName, put_PackageFamilyName)
    PackageUri = property(get_PackageUri, put_PackageUri)
    ProcessorArchitectureFilter = property(get_ProcessorArchitectureFilter, put_ProcessorArchitectureFilter)
class IPackageSetItemRuntimeDisposition(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Windows.Management.Deployment.IPackageSetItemRuntimeDisposition'
    _iid_ = Guid('{7a7f9f70-d416-5f83-a3cd-027bf3d2abfd}')
    @winrt_commethod(6)
    def get_PackageSetItemId(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def get_PackageFullName(self) -> WinRT_String: ...
    @winrt_commethod(8)
    def get_PackageDependencyId(self) -> WinRT_String: ...
    @winrt_commethod(9)
    def get_PackageDependencyContextId(self) -> win32more.Microsoft.Windows.ApplicationModel.DynamicDependency.PackageDependencyContextId: ...
    PackageDependencyContextId = property(get_PackageDependencyContextId, None)
    PackageDependencyId = property(get_PackageDependencyId, None)
    PackageFullName = property(get_PackageFullName, None)
    PackageSetItemId = property(get_PackageSetItemId, None)
class IPackageSetRuntimeDisposition(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Windows.Management.Deployment.IPackageSetRuntimeDisposition'
    _iid_ = Guid('{c13f1088-ea36-5db3-bcdd-e6d59e6c9b71}')
    @winrt_commethod(6)
    def get_PackageSetId(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def put_PackageSetId(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(8)
    def get_PackageSetItemRuntimeDispositions(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Microsoft.Windows.Management.Deployment.PackageSetItemRuntimeDisposition]: ...
    PackageSetId = property(get_PackageSetId, put_PackageSetId)
    PackageSetItemRuntimeDispositions = property(get_PackageSetItemRuntimeDispositions, None)
class IPackageVolume(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Windows.Management.Deployment.IPackageVolume'
    _iid_ = Guid('{9c9710f4-795a-58b3-93f4-c991c4329c49}')
    @winrt_commethod(6)
    def get_IsSystemVolume(self) -> Boolean: ...
    @winrt_commethod(7)
    def get_MountPoint(self) -> WinRT_String: ...
    @winrt_commethod(8)
    def get_Name(self) -> WinRT_String: ...
    @winrt_commethod(9)
    def get_PackageStorePath(self) -> WinRT_String: ...
    @winrt_commethod(10)
    def get_SupportsHardLinks(self) -> Boolean: ...
    @winrt_commethod(11)
    def get_IsFullTrustPackageSupported(self) -> Boolean: ...
    @winrt_commethod(12)
    def get_IsAppxInstallSupported(self) -> Boolean: ...
    @winrt_commethod(13)
    def IsRepairNeeded(self) -> Boolean: ...
    @winrt_commethod(14)
    def Repair(self) -> Void: ...
    IsAppxInstallSupported = property(get_IsAppxInstallSupported, None)
    IsFullTrustPackageSupported = property(get_IsFullTrustPackageSupported, None)
    IsSystemVolume = property(get_IsSystemVolume, None)
    MountPoint = property(get_MountPoint, None)
    Name = property(get_Name, None)
    PackageStorePath = property(get_PackageStorePath, None)
    SupportsHardLinks = property(get_SupportsHardLinks, None)
class IPackageVolumeStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Windows.Management.Deployment.IPackageVolumeStatics'
    _iid_ = Guid('{4c731835-8bc0-5313-9b56-8a4100eaea01}')
    @winrt_commethod(6)
    def FindPackageVolumes(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Microsoft.Windows.Management.Deployment.PackageVolume]: ...
    @winrt_commethod(7)
    def FindPackageVolumeByPath(self, packageStorePath: WinRT_String) -> win32more.Microsoft.Windows.Management.Deployment.PackageVolume: ...
    @winrt_commethod(8)
    def FindPackageVolumeByName(self, name: WinRT_String) -> win32more.Microsoft.Windows.Management.Deployment.PackageVolume: ...
class IProvisionPackageOptions(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Windows.Management.Deployment.IProvisionPackageOptions'
    _iid_ = Guid('{415e300f-d1e3-581e-a114-76d277b06136}')
    @winrt_commethod(6)
    def get_IsOptionalPackageFamilyNamesSupported(self) -> Boolean: ...
    @winrt_commethod(7)
    def get_OptionalPackageFamilyNames(self) -> win32more.Windows.Foundation.Collections.IVector[WinRT_String]: ...
    @winrt_commethod(8)
    def get_IsProjectionOrderPackageFamilyNamesSupported(self) -> Boolean: ...
    @winrt_commethod(9)
    def get_ProjectionOrderPackageFamilyNames(self) -> win32more.Windows.Foundation.Collections.IVector[WinRT_String]: ...
    IsOptionalPackageFamilyNamesSupported = property(get_IsOptionalPackageFamilyNamesSupported, None)
    IsProjectionOrderPackageFamilyNamesSupported = property(get_IsProjectionOrderPackageFamilyNamesSupported, None)
    OptionalPackageFamilyNames = property(get_OptionalPackageFamilyNames, None)
    ProjectionOrderPackageFamilyNames = property(get_ProjectionOrderPackageFamilyNames, None)
class IRegisterPackageOptions(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Windows.Management.Deployment.IRegisterPackageOptions'
    _iid_ = Guid('{83068623-2046-505f-8425-55226c0f84cc}')
    @winrt_commethod(6)
    def get_AppDataVolume(self) -> win32more.Microsoft.Windows.Management.Deployment.PackageVolume: ...
    @winrt_commethod(7)
    def put_AppDataVolume(self, value: win32more.Microsoft.Windows.Management.Deployment.PackageVolume) -> Void: ...
    @winrt_commethod(8)
    def get_DependencyPackageFamilyNames(self) -> win32more.Windows.Foundation.Collections.IVector[WinRT_String]: ...
    @winrt_commethod(9)
    def get_DependencyPackageUris(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_commethod(10)
    def get_OptionalPackageFamilyNames(self) -> win32more.Windows.Foundation.Collections.IVector[WinRT_String]: ...
    @winrt_commethod(11)
    def get_ExternalLocationUri(self) -> win32more.Windows.Foundation.Uri: ...
    @winrt_commethod(12)
    def put_ExternalLocationUri(self, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_commethod(13)
    def get_AllowUnsigned(self) -> Boolean: ...
    @winrt_commethod(14)
    def put_AllowUnsigned(self, value: Boolean) -> Void: ...
    @winrt_commethod(15)
    def get_DeveloperMode(self) -> Boolean: ...
    @winrt_commethod(16)
    def put_DeveloperMode(self, value: Boolean) -> Void: ...
    @winrt_commethod(17)
    def get_ForceAppShutdown(self) -> Boolean: ...
    @winrt_commethod(18)
    def put_ForceAppShutdown(self, value: Boolean) -> Void: ...
    @winrt_commethod(19)
    def get_ForceTargetAppShutdown(self) -> Boolean: ...
    @winrt_commethod(20)
    def put_ForceTargetAppShutdown(self, value: Boolean) -> Void: ...
    @winrt_commethod(21)
    def get_ForceUpdateFromAnyVersion(self) -> Boolean: ...
    @winrt_commethod(22)
    def put_ForceUpdateFromAnyVersion(self, value: Boolean) -> Void: ...
    @winrt_commethod(23)
    def get_InstallAllResources(self) -> Boolean: ...
    @winrt_commethod(24)
    def put_InstallAllResources(self, value: Boolean) -> Void: ...
    @winrt_commethod(25)
    def get_StageInPlace(self) -> Boolean: ...
    @winrt_commethod(26)
    def put_StageInPlace(self, value: Boolean) -> Void: ...
    @winrt_commethod(27)
    def get_DeferRegistrationWhenPackagesAreInUse(self) -> Boolean: ...
    @winrt_commethod(28)
    def put_DeferRegistrationWhenPackagesAreInUse(self, value: Boolean) -> Void: ...
    @winrt_commethod(29)
    def get_IsExpectedDigestsSupported(self) -> Boolean: ...
    @winrt_commethod(30)
    def get_ExpectedDigests(self) -> win32more.Windows.Foundation.Collections.IMap[win32more.Windows.Foundation.Uri, WinRT_String]: ...
    AllowUnsigned = property(get_AllowUnsigned, put_AllowUnsigned)
    AppDataVolume = property(get_AppDataVolume, put_AppDataVolume)
    DeferRegistrationWhenPackagesAreInUse = property(get_DeferRegistrationWhenPackagesAreInUse, put_DeferRegistrationWhenPackagesAreInUse)
    DependencyPackageFamilyNames = property(get_DependencyPackageFamilyNames, None)
    DependencyPackageUris = property(get_DependencyPackageUris, None)
    DeveloperMode = property(get_DeveloperMode, put_DeveloperMode)
    ExpectedDigests = property(get_ExpectedDigests, None)
    ExternalLocationUri = property(get_ExternalLocationUri, put_ExternalLocationUri)
    ForceAppShutdown = property(get_ForceAppShutdown, put_ForceAppShutdown)
    ForceTargetAppShutdown = property(get_ForceTargetAppShutdown, put_ForceTargetAppShutdown)
    ForceUpdateFromAnyVersion = property(get_ForceUpdateFromAnyVersion, put_ForceUpdateFromAnyVersion)
    InstallAllResources = property(get_InstallAllResources, put_InstallAllResources)
    IsExpectedDigestsSupported = property(get_IsExpectedDigestsSupported, None)
    OptionalPackageFamilyNames = property(get_OptionalPackageFamilyNames, None)
    StageInPlace = property(get_StageInPlace, put_StageInPlace)
class IRemovePackageOptions(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Windows.Management.Deployment.IRemovePackageOptions'
    _iid_ = Guid('{e7c90595-9a44-5046-8ebf-41ed326b200e}')
    @winrt_commethod(6)
    def get_FailIfNotFound(self) -> Boolean: ...
    @winrt_commethod(7)
    def put_FailIfNotFound(self, value: Boolean) -> Void: ...
    @winrt_commethod(8)
    def get_PreserveApplicationData(self) -> Boolean: ...
    @winrt_commethod(9)
    def put_PreserveApplicationData(self, value: Boolean) -> Void: ...
    @winrt_commethod(10)
    def get_PreserveRoamableApplicationData(self) -> Boolean: ...
    @winrt_commethod(11)
    def put_PreserveRoamableApplicationData(self, value: Boolean) -> Void: ...
    @winrt_commethod(12)
    def get_RemoveForAllUsers(self) -> Boolean: ...
    @winrt_commethod(13)
    def put_RemoveForAllUsers(self, value: Boolean) -> Void: ...
    FailIfNotFound = property(get_FailIfNotFound, put_FailIfNotFound)
    PreserveApplicationData = property(get_PreserveApplicationData, put_PreserveApplicationData)
    PreserveRoamableApplicationData = property(get_PreserveRoamableApplicationData, put_PreserveRoamableApplicationData)
    RemoveForAllUsers = property(get_RemoveForAllUsers, put_RemoveForAllUsers)
class IStagePackageOptions(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Windows.Management.Deployment.IStagePackageOptions'
    _iid_ = Guid('{9b6b3203-fd7c-5ead-a9d6-ab2e8566be5e}')
    @winrt_commethod(6)
    def get_TargetVolume(self) -> win32more.Microsoft.Windows.Management.Deployment.PackageVolume: ...
    @winrt_commethod(7)
    def put_TargetVolume(self, value: win32more.Microsoft.Windows.Management.Deployment.PackageVolume) -> Void: ...
    @winrt_commethod(8)
    def get_DependencyPackageUris(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_commethod(9)
    def get_OptionalPackageFamilyNames(self) -> win32more.Windows.Foundation.Collections.IVector[WinRT_String]: ...
    @winrt_commethod(10)
    def get_OptionalPackageUris(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_commethod(11)
    def get_RelatedPackageUris(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_commethod(12)
    def get_ExternalLocationUri(self) -> win32more.Windows.Foundation.Uri: ...
    @winrt_commethod(13)
    def put_ExternalLocationUri(self, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_commethod(14)
    def get_StubPackageOption(self) -> win32more.Microsoft.Windows.Management.Deployment.StubPackageOption: ...
    @winrt_commethod(15)
    def put_StubPackageOption(self, value: win32more.Microsoft.Windows.Management.Deployment.StubPackageOption) -> Void: ...
    @winrt_commethod(16)
    def get_DeveloperMode(self) -> Boolean: ...
    @winrt_commethod(17)
    def put_DeveloperMode(self, value: Boolean) -> Void: ...
    @winrt_commethod(18)
    def get_ForceUpdateFromAnyVersion(self) -> Boolean: ...
    @winrt_commethod(19)
    def put_ForceUpdateFromAnyVersion(self, value: Boolean) -> Void: ...
    @winrt_commethod(20)
    def get_InstallAllResources(self) -> Boolean: ...
    @winrt_commethod(21)
    def put_InstallAllResources(self, value: Boolean) -> Void: ...
    @winrt_commethod(22)
    def get_RequiredContentGroupOnly(self) -> Boolean: ...
    @winrt_commethod(23)
    def put_RequiredContentGroupOnly(self, value: Boolean) -> Void: ...
    @winrt_commethod(24)
    def get_StageInPlace(self) -> Boolean: ...
    @winrt_commethod(25)
    def put_StageInPlace(self, value: Boolean) -> Void: ...
    @winrt_commethod(26)
    def get_AllowUnsigned(self) -> Boolean: ...
    @winrt_commethod(27)
    def put_AllowUnsigned(self, value: Boolean) -> Void: ...
    @winrt_commethod(28)
    def get_IsExpectedDigestsSupported(self) -> Boolean: ...
    @winrt_commethod(29)
    def get_ExpectedDigests(self) -> win32more.Windows.Foundation.Collections.IMap[win32more.Windows.Foundation.Uri, WinRT_String]: ...
    AllowUnsigned = property(get_AllowUnsigned, put_AllowUnsigned)
    DependencyPackageUris = property(get_DependencyPackageUris, None)
    DeveloperMode = property(get_DeveloperMode, put_DeveloperMode)
    ExpectedDigests = property(get_ExpectedDigests, None)
    ExternalLocationUri = property(get_ExternalLocationUri, put_ExternalLocationUri)
    ForceUpdateFromAnyVersion = property(get_ForceUpdateFromAnyVersion, put_ForceUpdateFromAnyVersion)
    InstallAllResources = property(get_InstallAllResources, put_InstallAllResources)
    IsExpectedDigestsSupported = property(get_IsExpectedDigestsSupported, None)
    OptionalPackageFamilyNames = property(get_OptionalPackageFamilyNames, None)
    OptionalPackageUris = property(get_OptionalPackageUris, None)
    RelatedPackageUris = property(get_RelatedPackageUris, None)
    RequiredContentGroupOnly = property(get_RequiredContentGroupOnly, put_RequiredContentGroupOnly)
    StageInPlace = property(get_StageInPlace, put_StageInPlace)
    StubPackageOption = property(get_StubPackageOption, put_StubPackageOption)
    TargetVolume = property(get_TargetVolume, put_TargetVolume)
PackageDeploymentContract: UInt32 = 131072
class PackageDeploymentFeature(Enum, Int32):
    PackageUriScheme_ms_uup = 1
    IsPackageReadyOrNewerAvailable = 2
    RemovePackageByUri = 3
    ResetPackage = 4
    RepairPackage = 5
    ProvisionPackage_Framework = 6
class PackageDeploymentManager(ComPtr):
    extends: IInspectable
    default_interface: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager
    _classid_ = 'Microsoft.Windows.Management.Deployment.PackageDeploymentManager'
    @winrt_mixinmethod
    def IsPackageReady(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, package: WinRT_String) -> Boolean: ...
    @winrt_mixinmethod
    def IsPackageReadyByUri(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, packageUri: win32more.Windows.Foundation.Uri) -> Boolean: ...
    @winrt_mixinmethod
    def IsPackageSetReady(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, packageSet: win32more.Microsoft.Windows.Management.Deployment.PackageSet) -> Boolean: ...
    @winrt_mixinmethod
    def EnsurePackageReadyAsync(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, package: WinRT_String, options: win32more.Microsoft.Windows.Management.Deployment.EnsureReadyOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_mixinmethod
    def EnsurePackageReadyByUriAsync(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, packageUri: win32more.Windows.Foundation.Uri, options: win32more.Microsoft.Windows.Management.Deployment.EnsureReadyOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_mixinmethod
    def EnsurePackageSetReadyAsync(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, packageSet: win32more.Microsoft.Windows.Management.Deployment.PackageSet, options: win32more.Microsoft.Windows.Management.Deployment.EnsureReadyOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_mixinmethod
    def AddPackageAsync(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, package: WinRT_String, options: win32more.Microsoft.Windows.Management.Deployment.AddPackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_mixinmethod
    def AddPackageByUriAsync(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, packageUri: win32more.Windows.Foundation.Uri, options: win32more.Microsoft.Windows.Management.Deployment.AddPackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_mixinmethod
    def AddPackageSetAsync(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, packageSet: win32more.Microsoft.Windows.Management.Deployment.PackageSet, options: win32more.Microsoft.Windows.Management.Deployment.AddPackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_mixinmethod
    def StagePackageAsync(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, package: WinRT_String, options: win32more.Microsoft.Windows.Management.Deployment.StagePackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_mixinmethod
    def StagePackageByUriAsync(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, packageUri: win32more.Windows.Foundation.Uri, options: win32more.Microsoft.Windows.Management.Deployment.StagePackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_mixinmethod
    def StagePackageSetAsync(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, packageSet: win32more.Microsoft.Windows.Management.Deployment.PackageSet, options: win32more.Microsoft.Windows.Management.Deployment.StagePackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_mixinmethod
    def RegisterPackageAsync(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, package: WinRT_String, options: win32more.Microsoft.Windows.Management.Deployment.RegisterPackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_mixinmethod
    def RegisterPackageByUriAsync(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, packageUri: win32more.Windows.Foundation.Uri, options: win32more.Microsoft.Windows.Management.Deployment.RegisterPackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_mixinmethod
    def RegisterPackageSetAsync(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, packageSet: win32more.Microsoft.Windows.Management.Deployment.PackageSet, options: win32more.Microsoft.Windows.Management.Deployment.RegisterPackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_mixinmethod
    def RemovePackageAsync(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, package: WinRT_String, options: win32more.Microsoft.Windows.Management.Deployment.RemovePackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_mixinmethod
    def RemovePackageByFullNameAsync(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, packageFullName: WinRT_String, options: win32more.Microsoft.Windows.Management.Deployment.RemovePackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_mixinmethod
    def RemovePackageByFamilyNameAsync(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, packageFamilyName: WinRT_String, options: win32more.Microsoft.Windows.Management.Deployment.RemovePackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_mixinmethod
    def RemovePackageByUriAsync(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, packageUri: win32more.Windows.Foundation.Uri, options: win32more.Microsoft.Windows.Management.Deployment.RemovePackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_mixinmethod
    def RemovePackageSetAsync(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, packageSet: win32more.Microsoft.Windows.Management.Deployment.PackageSet, options: win32more.Microsoft.Windows.Management.Deployment.RemovePackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_mixinmethod
    def ResetPackageAsync(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, package: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_mixinmethod
    def ResetPackageByUriAsync(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, packageUri: win32more.Windows.Foundation.Uri) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_mixinmethod
    def ResetPackageSetAsync(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, packageSet: win32more.Microsoft.Windows.Management.Deployment.PackageSet) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_mixinmethod
    def RepairPackageAsync(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, package: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_mixinmethod
    def RepairPackageByUriAsync(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, packageUri: win32more.Windows.Foundation.Uri) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_mixinmethod
    def RepairPackageSetAsync(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, packageSet: win32more.Microsoft.Windows.Management.Deployment.PackageSet) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_mixinmethod
    def ProvisionPackageAsync(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, package: WinRT_String, options: win32more.Microsoft.Windows.Management.Deployment.ProvisionPackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_mixinmethod
    def ProvisionPackageByUriAsync(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, packageUri: win32more.Windows.Foundation.Uri, options: win32more.Microsoft.Windows.Management.Deployment.ProvisionPackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_mixinmethod
    def ProvisionPackageSetAsync(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, packageSet: win32more.Microsoft.Windows.Management.Deployment.PackageSet, options: win32more.Microsoft.Windows.Management.Deployment.ProvisionPackageOptions) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_mixinmethod
    def DeprovisionPackageAsync(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, package: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_mixinmethod
    def DeprovisionPackageByUriAsync(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, packageUri: win32more.Windows.Foundation.Uri) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_mixinmethod
    def DeprovisionPackageSetAsync(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, packageSet: win32more.Microsoft.Windows.Management.Deployment.PackageSet) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentResult, win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgress]: ...
    @winrt_mixinmethod
    def IsPackageRegistrationPending(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, packageFamilyName: WinRT_String) -> Boolean: ...
    @winrt_mixinmethod
    def IsPackageRegistrationPendingForUser(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager, userSecurityId: WinRT_String, packageFamilyName: WinRT_String) -> Boolean: ...
    @winrt_mixinmethod
    def IsPackageReadyOrNewerAvailable(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager2, package: WinRT_String) -> win32more.Microsoft.Windows.Management.Deployment.PackageReadyOrNewerAvailableStatus: ...
    @winrt_mixinmethod
    def IsPackageReadyOrNewerAvailableByUri(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager2, packageUri: win32more.Windows.Foundation.Uri) -> win32more.Microsoft.Windows.Management.Deployment.PackageReadyOrNewerAvailableStatus: ...
    @winrt_mixinmethod
    def IsPackageSetReadyOrNewerAvailable(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager2, packageSet: win32more.Microsoft.Windows.Management.Deployment.PackageSet) -> win32more.Microsoft.Windows.Management.Deployment.PackageReadyOrNewerAvailableStatus: ...
    @winrt_mixinmethod
    def IsPackageProvisioned(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager2, package: WinRT_String) -> Boolean: ...
    @winrt_mixinmethod
    def IsPackageProvisionedByUri(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager2, packageUri: win32more.Windows.Foundation.Uri) -> Boolean: ...
    @winrt_mixinmethod
    def IsPackageSetProvisioned(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManager2, packageSet: win32more.Microsoft.Windows.Management.Deployment.PackageSet) -> Boolean: ...
    @winrt_classmethod
    def IsPackageDeploymentFeatureSupported(cls: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManagerStatics2, feature: win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentFeature) -> Boolean: ...
    @winrt_classmethod
    def GetDefault(cls: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentManagerStatics) -> win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentManager: ...
class PackageDeploymentProgress(Structure):
    Status: win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentProgressStatus
    Progress: Double
class PackageDeploymentProgressStatus(Enum, Int32):
    Queued = 0
    InProgress = 1
    CompletedSuccess = 2
    CompletedFailure = 3
class PackageDeploymentResult(ComPtr):
    extends: IInspectable
    default_interface: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentResult
    _classid_ = 'Microsoft.Windows.Management.Deployment.PackageDeploymentResult'
    @winrt_mixinmethod
    def get_Status(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentResult) -> win32more.Microsoft.Windows.Management.Deployment.PackageDeploymentStatus: ...
    @winrt_mixinmethod
    def get_Error(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentResult) -> win32more.Windows.Foundation.HResult: ...
    @winrt_mixinmethod
    def get_ExtendedError(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentResult) -> win32more.Windows.Foundation.HResult: ...
    @winrt_mixinmethod
    def get_ErrorText(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentResult) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_ActivityId(self: win32more.Microsoft.Windows.Management.Deployment.IPackageDeploymentResult) -> Guid: ...
    ActivityId = property(get_ActivityId, None)
    Error = property(get_Error, None)
    ErrorText = property(get_ErrorText, None)
    ExtendedError = property(get_ExtendedError, None)
    Status = property(get_Status, None)
class PackageDeploymentStatus(Enum, Int32):
    InProgress = 0
    CompletedSuccess = 1
    CompletedFailure = 2
class PackageReadyOrNewerAvailableStatus(Enum, Int32):
    NotReady = 0
    Ready = 1
    NewerAvailable = 2
class PackageRuntimeManager(ComPtr):
    extends: IInspectable
    default_interface: win32more.Microsoft.Windows.Management.Deployment.IPackageRuntimeManager
    _classid_ = 'Microsoft.Windows.Management.Deployment.PackageRuntimeManager'
    @winrt_mixinmethod
    def AddPackageSet(self: win32more.Microsoft.Windows.Management.Deployment.IPackageRuntimeManager, packageSet: win32more.Microsoft.Windows.Management.Deployment.PackageSet) -> win32more.Microsoft.Windows.Management.Deployment.PackageSetRuntimeDisposition: ...
    @winrt_mixinmethod
    def AddPackageSetWithOptions(self: win32more.Microsoft.Windows.Management.Deployment.IPackageRuntimeManager, packageSet: win32more.Microsoft.Windows.Management.Deployment.PackageSet, createOptions: win32more.Microsoft.Windows.ApplicationModel.DynamicDependency.CreatePackageDependencyOptions, addOptions: win32more.Microsoft.Windows.ApplicationModel.DynamicDependency.AddPackageDependencyOptions) -> win32more.Microsoft.Windows.Management.Deployment.PackageSetRuntimeDisposition: ...
    @winrt_mixinmethod
    def RemovePackageSet(self: win32more.Microsoft.Windows.Management.Deployment.IPackageRuntimeManager, packageSetRuntimeDisposition: win32more.Microsoft.Windows.Management.Deployment.PackageSetRuntimeDisposition) -> Void: ...
    @winrt_classmethod
    def GetDefault(cls: win32more.Microsoft.Windows.Management.Deployment.IPackageRuntimeManagerStatics) -> win32more.Microsoft.Windows.Management.Deployment.PackageRuntimeManager: ...
class PackageSet(ComPtr):
    extends: IInspectable
    default_interface: win32more.Microsoft.Windows.Management.Deployment.IPackageSet
    _classid_ = 'Microsoft.Windows.Management.Deployment.PackageSet'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Windows.Management.Deployment.PackageSet.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Windows.Management.Deployment.PackageSet: ...
    @winrt_mixinmethod
    def get_Id(self: win32more.Microsoft.Windows.Management.Deployment.IPackageSet) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Id(self: win32more.Microsoft.Windows.Management.Deployment.IPackageSet, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_PackageUri(self: win32more.Microsoft.Windows.Management.Deployment.IPackageSet) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def put_PackageUri(self: win32more.Microsoft.Windows.Management.Deployment.IPackageSet, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_mixinmethod
    def get_Items(self: win32more.Microsoft.Windows.Management.Deployment.IPackageSet) -> win32more.Windows.Foundation.Collections.IVector[win32more.Microsoft.Windows.Management.Deployment.PackageSetItem]: ...
    Id = property(get_Id, put_Id)
    Items = property(get_Items, None)
    PackageUri = property(get_PackageUri, put_PackageUri)
class PackageSetItem(ComPtr):
    extends: IInspectable
    default_interface: win32more.Microsoft.Windows.Management.Deployment.IPackageSetItem
    _classid_ = 'Microsoft.Windows.Management.Deployment.PackageSetItem'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Windows.Management.Deployment.PackageSetItem.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Windows.Management.Deployment.PackageSetItem: ...
    @winrt_mixinmethod
    def get_Id(self: win32more.Microsoft.Windows.Management.Deployment.IPackageSetItem) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Id(self: win32more.Microsoft.Windows.Management.Deployment.IPackageSetItem, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_PackageFamilyName(self: win32more.Microsoft.Windows.Management.Deployment.IPackageSetItem) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_PackageFamilyName(self: win32more.Microsoft.Windows.Management.Deployment.IPackageSetItem, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_MinVersion(self: win32more.Microsoft.Windows.Management.Deployment.IPackageSetItem) -> win32more.Windows.ApplicationModel.PackageVersion: ...
    @winrt_mixinmethod
    def put_MinVersion(self: win32more.Microsoft.Windows.Management.Deployment.IPackageSetItem, value: win32more.Windows.ApplicationModel.PackageVersion) -> Void: ...
    @winrt_mixinmethod
    def get_ProcessorArchitectureFilter(self: win32more.Microsoft.Windows.Management.Deployment.IPackageSetItem) -> win32more.Microsoft.Windows.ApplicationModel.DynamicDependency.PackageDependencyProcessorArchitectures: ...
    @winrt_mixinmethod
    def put_ProcessorArchitectureFilter(self: win32more.Microsoft.Windows.Management.Deployment.IPackageSetItem, value: win32more.Microsoft.Windows.ApplicationModel.DynamicDependency.PackageDependencyProcessorArchitectures) -> Void: ...
    @winrt_mixinmethod
    def get_PackageUri(self: win32more.Microsoft.Windows.Management.Deployment.IPackageSetItem) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def put_PackageUri(self: win32more.Microsoft.Windows.Management.Deployment.IPackageSetItem, value: win32more.Windows.Foundation.Uri) -> Void: ...
    Id = property(get_Id, put_Id)
    MinVersion = property(get_MinVersion, put_MinVersion)
    PackageFamilyName = property(get_PackageFamilyName, put_PackageFamilyName)
    PackageUri = property(get_PackageUri, put_PackageUri)
    ProcessorArchitectureFilter = property(get_ProcessorArchitectureFilter, put_ProcessorArchitectureFilter)
class PackageSetItemRuntimeDisposition(ComPtr):
    extends: IInspectable
    default_interface: win32more.Microsoft.Windows.Management.Deployment.IPackageSetItemRuntimeDisposition
    _classid_ = 'Microsoft.Windows.Management.Deployment.PackageSetItemRuntimeDisposition'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Windows.Management.Deployment.PackageSetItemRuntimeDisposition.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Windows.Management.Deployment.PackageSetItemRuntimeDisposition: ...
    @winrt_mixinmethod
    def get_PackageSetItemId(self: win32more.Microsoft.Windows.Management.Deployment.IPackageSetItemRuntimeDisposition) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_PackageFullName(self: win32more.Microsoft.Windows.Management.Deployment.IPackageSetItemRuntimeDisposition) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_PackageDependencyId(self: win32more.Microsoft.Windows.Management.Deployment.IPackageSetItemRuntimeDisposition) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_PackageDependencyContextId(self: win32more.Microsoft.Windows.Management.Deployment.IPackageSetItemRuntimeDisposition) -> win32more.Microsoft.Windows.ApplicationModel.DynamicDependency.PackageDependencyContextId: ...
    PackageDependencyContextId = property(get_PackageDependencyContextId, None)
    PackageDependencyId = property(get_PackageDependencyId, None)
    PackageFullName = property(get_PackageFullName, None)
    PackageSetItemId = property(get_PackageSetItemId, None)
class PackageSetRuntimeDisposition(ComPtr):
    extends: IInspectable
    default_interface: win32more.Microsoft.Windows.Management.Deployment.IPackageSetRuntimeDisposition
    _classid_ = 'Microsoft.Windows.Management.Deployment.PackageSetRuntimeDisposition'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Windows.Management.Deployment.PackageSetRuntimeDisposition.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Windows.Management.Deployment.PackageSetRuntimeDisposition: ...
    @winrt_mixinmethod
    def get_PackageSetId(self: win32more.Microsoft.Windows.Management.Deployment.IPackageSetRuntimeDisposition) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_PackageSetId(self: win32more.Microsoft.Windows.Management.Deployment.IPackageSetRuntimeDisposition, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_PackageSetItemRuntimeDispositions(self: win32more.Microsoft.Windows.Management.Deployment.IPackageSetRuntimeDisposition) -> win32more.Windows.Foundation.Collections.IVector[win32more.Microsoft.Windows.Management.Deployment.PackageSetItemRuntimeDisposition]: ...
    PackageSetId = property(get_PackageSetId, put_PackageSetId)
    PackageSetItemRuntimeDispositions = property(get_PackageSetItemRuntimeDispositions, None)
class PackageVolume(ComPtr):
    extends: IInspectable
    default_interface: win32more.Microsoft.Windows.Management.Deployment.IPackageVolume
    _classid_ = 'Microsoft.Windows.Management.Deployment.PackageVolume'
    @winrt_mixinmethod
    def get_IsSystemVolume(self: win32more.Microsoft.Windows.Management.Deployment.IPackageVolume) -> Boolean: ...
    @winrt_mixinmethod
    def get_MountPoint(self: win32more.Microsoft.Windows.Management.Deployment.IPackageVolume) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Microsoft.Windows.Management.Deployment.IPackageVolume) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_PackageStorePath(self: win32more.Microsoft.Windows.Management.Deployment.IPackageVolume) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_SupportsHardLinks(self: win32more.Microsoft.Windows.Management.Deployment.IPackageVolume) -> Boolean: ...
    @winrt_mixinmethod
    def get_IsFullTrustPackageSupported(self: win32more.Microsoft.Windows.Management.Deployment.IPackageVolume) -> Boolean: ...
    @winrt_mixinmethod
    def get_IsAppxInstallSupported(self: win32more.Microsoft.Windows.Management.Deployment.IPackageVolume) -> Boolean: ...
    @winrt_mixinmethod
    def IsRepairNeeded(self: win32more.Microsoft.Windows.Management.Deployment.IPackageVolume) -> Boolean: ...
    @winrt_mixinmethod
    def Repair(self: win32more.Microsoft.Windows.Management.Deployment.IPackageVolume) -> Void: ...
    @winrt_classmethod
    def FindPackageVolumes(cls: win32more.Microsoft.Windows.Management.Deployment.IPackageVolumeStatics) -> win32more.Windows.Foundation.Collections.IVector[win32more.Microsoft.Windows.Management.Deployment.PackageVolume]: ...
    @winrt_classmethod
    def FindPackageVolumeByPath(cls: win32more.Microsoft.Windows.Management.Deployment.IPackageVolumeStatics, packageStorePath: WinRT_String) -> win32more.Microsoft.Windows.Management.Deployment.PackageVolume: ...
    @winrt_classmethod
    def FindPackageVolumeByName(cls: win32more.Microsoft.Windows.Management.Deployment.IPackageVolumeStatics, name: WinRT_String) -> win32more.Microsoft.Windows.Management.Deployment.PackageVolume: ...
    IsAppxInstallSupported = property(get_IsAppxInstallSupported, None)
    IsFullTrustPackageSupported = property(get_IsFullTrustPackageSupported, None)
    IsSystemVolume = property(get_IsSystemVolume, None)
    MountPoint = property(get_MountPoint, None)
    Name = property(get_Name, None)
    PackageStorePath = property(get_PackageStorePath, None)
    SupportsHardLinks = property(get_SupportsHardLinks, None)
class ProvisionPackageOptions(ComPtr):
    extends: IInspectable
    default_interface: win32more.Microsoft.Windows.Management.Deployment.IProvisionPackageOptions
    _classid_ = 'Microsoft.Windows.Management.Deployment.ProvisionPackageOptions'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Windows.Management.Deployment.ProvisionPackageOptions.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Windows.Management.Deployment.ProvisionPackageOptions: ...
    @winrt_mixinmethod
    def get_IsOptionalPackageFamilyNamesSupported(self: win32more.Microsoft.Windows.Management.Deployment.IProvisionPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def get_OptionalPackageFamilyNames(self: win32more.Microsoft.Windows.Management.Deployment.IProvisionPackageOptions) -> win32more.Windows.Foundation.Collections.IVector[WinRT_String]: ...
    @winrt_mixinmethod
    def get_IsProjectionOrderPackageFamilyNamesSupported(self: win32more.Microsoft.Windows.Management.Deployment.IProvisionPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def get_ProjectionOrderPackageFamilyNames(self: win32more.Microsoft.Windows.Management.Deployment.IProvisionPackageOptions) -> win32more.Windows.Foundation.Collections.IVector[WinRT_String]: ...
    IsOptionalPackageFamilyNamesSupported = property(get_IsOptionalPackageFamilyNamesSupported, None)
    IsProjectionOrderPackageFamilyNamesSupported = property(get_IsProjectionOrderPackageFamilyNamesSupported, None)
    OptionalPackageFamilyNames = property(get_OptionalPackageFamilyNames, None)
    ProjectionOrderPackageFamilyNames = property(get_ProjectionOrderPackageFamilyNames, None)
class RegisterPackageOptions(ComPtr):
    extends: IInspectable
    default_interface: win32more.Microsoft.Windows.Management.Deployment.IRegisterPackageOptions
    _classid_ = 'Microsoft.Windows.Management.Deployment.RegisterPackageOptions'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Windows.Management.Deployment.RegisterPackageOptions.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Windows.Management.Deployment.RegisterPackageOptions: ...
    @winrt_mixinmethod
    def get_AppDataVolume(self: win32more.Microsoft.Windows.Management.Deployment.IRegisterPackageOptions) -> win32more.Microsoft.Windows.Management.Deployment.PackageVolume: ...
    @winrt_mixinmethod
    def put_AppDataVolume(self: win32more.Microsoft.Windows.Management.Deployment.IRegisterPackageOptions, value: win32more.Microsoft.Windows.Management.Deployment.PackageVolume) -> Void: ...
    @winrt_mixinmethod
    def get_DependencyPackageFamilyNames(self: win32more.Microsoft.Windows.Management.Deployment.IRegisterPackageOptions) -> win32more.Windows.Foundation.Collections.IVector[WinRT_String]: ...
    @winrt_mixinmethod
    def get_DependencyPackageUris(self: win32more.Microsoft.Windows.Management.Deployment.IRegisterPackageOptions) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_mixinmethod
    def get_OptionalPackageFamilyNames(self: win32more.Microsoft.Windows.Management.Deployment.IRegisterPackageOptions) -> win32more.Windows.Foundation.Collections.IVector[WinRT_String]: ...
    @winrt_mixinmethod
    def get_ExternalLocationUri(self: win32more.Microsoft.Windows.Management.Deployment.IRegisterPackageOptions) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def put_ExternalLocationUri(self: win32more.Microsoft.Windows.Management.Deployment.IRegisterPackageOptions, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_mixinmethod
    def get_AllowUnsigned(self: win32more.Microsoft.Windows.Management.Deployment.IRegisterPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_AllowUnsigned(self: win32more.Microsoft.Windows.Management.Deployment.IRegisterPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_DeveloperMode(self: win32more.Microsoft.Windows.Management.Deployment.IRegisterPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_DeveloperMode(self: win32more.Microsoft.Windows.Management.Deployment.IRegisterPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_ForceAppShutdown(self: win32more.Microsoft.Windows.Management.Deployment.IRegisterPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_ForceAppShutdown(self: win32more.Microsoft.Windows.Management.Deployment.IRegisterPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_ForceTargetAppShutdown(self: win32more.Microsoft.Windows.Management.Deployment.IRegisterPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_ForceTargetAppShutdown(self: win32more.Microsoft.Windows.Management.Deployment.IRegisterPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_ForceUpdateFromAnyVersion(self: win32more.Microsoft.Windows.Management.Deployment.IRegisterPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_ForceUpdateFromAnyVersion(self: win32more.Microsoft.Windows.Management.Deployment.IRegisterPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_InstallAllResources(self: win32more.Microsoft.Windows.Management.Deployment.IRegisterPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_InstallAllResources(self: win32more.Microsoft.Windows.Management.Deployment.IRegisterPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_StageInPlace(self: win32more.Microsoft.Windows.Management.Deployment.IRegisterPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_StageInPlace(self: win32more.Microsoft.Windows.Management.Deployment.IRegisterPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_DeferRegistrationWhenPackagesAreInUse(self: win32more.Microsoft.Windows.Management.Deployment.IRegisterPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_DeferRegistrationWhenPackagesAreInUse(self: win32more.Microsoft.Windows.Management.Deployment.IRegisterPackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_IsExpectedDigestsSupported(self: win32more.Microsoft.Windows.Management.Deployment.IRegisterPackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def get_ExpectedDigests(self: win32more.Microsoft.Windows.Management.Deployment.IRegisterPackageOptions) -> win32more.Windows.Foundation.Collections.IMap[win32more.Windows.Foundation.Uri, WinRT_String]: ...
    AllowUnsigned = property(get_AllowUnsigned, put_AllowUnsigned)
    AppDataVolume = property(get_AppDataVolume, put_AppDataVolume)
    DeferRegistrationWhenPackagesAreInUse = property(get_DeferRegistrationWhenPackagesAreInUse, put_DeferRegistrationWhenPackagesAreInUse)
    DependencyPackageFamilyNames = property(get_DependencyPackageFamilyNames, None)
    DependencyPackageUris = property(get_DependencyPackageUris, None)
    DeveloperMode = property(get_DeveloperMode, put_DeveloperMode)
    ExpectedDigests = property(get_ExpectedDigests, None)
    ExternalLocationUri = property(get_ExternalLocationUri, put_ExternalLocationUri)
    ForceAppShutdown = property(get_ForceAppShutdown, put_ForceAppShutdown)
    ForceTargetAppShutdown = property(get_ForceTargetAppShutdown, put_ForceTargetAppShutdown)
    ForceUpdateFromAnyVersion = property(get_ForceUpdateFromAnyVersion, put_ForceUpdateFromAnyVersion)
    InstallAllResources = property(get_InstallAllResources, put_InstallAllResources)
    IsExpectedDigestsSupported = property(get_IsExpectedDigestsSupported, None)
    OptionalPackageFamilyNames = property(get_OptionalPackageFamilyNames, None)
    StageInPlace = property(get_StageInPlace, put_StageInPlace)
class RemovePackageOptions(ComPtr):
    extends: IInspectable
    default_interface: win32more.Microsoft.Windows.Management.Deployment.IRemovePackageOptions
    _classid_ = 'Microsoft.Windows.Management.Deployment.RemovePackageOptions'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Windows.Management.Deployment.RemovePackageOptions.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Windows.Management.Deployment.RemovePackageOptions: ...
    @winrt_mixinmethod
    def get_FailIfNotFound(self: win32more.Microsoft.Windows.Management.Deployment.IRemovePackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_FailIfNotFound(self: win32more.Microsoft.Windows.Management.Deployment.IRemovePackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_PreserveApplicationData(self: win32more.Microsoft.Windows.Management.Deployment.IRemovePackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_PreserveApplicationData(self: win32more.Microsoft.Windows.Management.Deployment.IRemovePackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_PreserveRoamableApplicationData(self: win32more.Microsoft.Windows.Management.Deployment.IRemovePackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_PreserveRoamableApplicationData(self: win32more.Microsoft.Windows.Management.Deployment.IRemovePackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_RemoveForAllUsers(self: win32more.Microsoft.Windows.Management.Deployment.IRemovePackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_RemoveForAllUsers(self: win32more.Microsoft.Windows.Management.Deployment.IRemovePackageOptions, value: Boolean) -> Void: ...
    FailIfNotFound = property(get_FailIfNotFound, put_FailIfNotFound)
    PreserveApplicationData = property(get_PreserveApplicationData, put_PreserveApplicationData)
    PreserveRoamableApplicationData = property(get_PreserveRoamableApplicationData, put_PreserveRoamableApplicationData)
    RemoveForAllUsers = property(get_RemoveForAllUsers, put_RemoveForAllUsers)
class StagePackageOptions(ComPtr):
    extends: IInspectable
    default_interface: win32more.Microsoft.Windows.Management.Deployment.IStagePackageOptions
    _classid_ = 'Microsoft.Windows.Management.Deployment.StagePackageOptions'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Windows.Management.Deployment.StagePackageOptions.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Windows.Management.Deployment.StagePackageOptions: ...
    @winrt_mixinmethod
    def get_TargetVolume(self: win32more.Microsoft.Windows.Management.Deployment.IStagePackageOptions) -> win32more.Microsoft.Windows.Management.Deployment.PackageVolume: ...
    @winrt_mixinmethod
    def put_TargetVolume(self: win32more.Microsoft.Windows.Management.Deployment.IStagePackageOptions, value: win32more.Microsoft.Windows.Management.Deployment.PackageVolume) -> Void: ...
    @winrt_mixinmethod
    def get_DependencyPackageUris(self: win32more.Microsoft.Windows.Management.Deployment.IStagePackageOptions) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_mixinmethod
    def get_OptionalPackageFamilyNames(self: win32more.Microsoft.Windows.Management.Deployment.IStagePackageOptions) -> win32more.Windows.Foundation.Collections.IVector[WinRT_String]: ...
    @winrt_mixinmethod
    def get_OptionalPackageUris(self: win32more.Microsoft.Windows.Management.Deployment.IStagePackageOptions) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_mixinmethod
    def get_RelatedPackageUris(self: win32more.Microsoft.Windows.Management.Deployment.IStagePackageOptions) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Foundation.Uri]: ...
    @winrt_mixinmethod
    def get_ExternalLocationUri(self: win32more.Microsoft.Windows.Management.Deployment.IStagePackageOptions) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def put_ExternalLocationUri(self: win32more.Microsoft.Windows.Management.Deployment.IStagePackageOptions, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_mixinmethod
    def get_StubPackageOption(self: win32more.Microsoft.Windows.Management.Deployment.IStagePackageOptions) -> win32more.Microsoft.Windows.Management.Deployment.StubPackageOption: ...
    @winrt_mixinmethod
    def put_StubPackageOption(self: win32more.Microsoft.Windows.Management.Deployment.IStagePackageOptions, value: win32more.Microsoft.Windows.Management.Deployment.StubPackageOption) -> Void: ...
    @winrt_mixinmethod
    def get_DeveloperMode(self: win32more.Microsoft.Windows.Management.Deployment.IStagePackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_DeveloperMode(self: win32more.Microsoft.Windows.Management.Deployment.IStagePackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_ForceUpdateFromAnyVersion(self: win32more.Microsoft.Windows.Management.Deployment.IStagePackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_ForceUpdateFromAnyVersion(self: win32more.Microsoft.Windows.Management.Deployment.IStagePackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_InstallAllResources(self: win32more.Microsoft.Windows.Management.Deployment.IStagePackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_InstallAllResources(self: win32more.Microsoft.Windows.Management.Deployment.IStagePackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_RequiredContentGroupOnly(self: win32more.Microsoft.Windows.Management.Deployment.IStagePackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_RequiredContentGroupOnly(self: win32more.Microsoft.Windows.Management.Deployment.IStagePackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_StageInPlace(self: win32more.Microsoft.Windows.Management.Deployment.IStagePackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_StageInPlace(self: win32more.Microsoft.Windows.Management.Deployment.IStagePackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_AllowUnsigned(self: win32more.Microsoft.Windows.Management.Deployment.IStagePackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_AllowUnsigned(self: win32more.Microsoft.Windows.Management.Deployment.IStagePackageOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_IsExpectedDigestsSupported(self: win32more.Microsoft.Windows.Management.Deployment.IStagePackageOptions) -> Boolean: ...
    @winrt_mixinmethod
    def get_ExpectedDigests(self: win32more.Microsoft.Windows.Management.Deployment.IStagePackageOptions) -> win32more.Windows.Foundation.Collections.IMap[win32more.Windows.Foundation.Uri, WinRT_String]: ...
    AllowUnsigned = property(get_AllowUnsigned, put_AllowUnsigned)
    DependencyPackageUris = property(get_DependencyPackageUris, None)
    DeveloperMode = property(get_DeveloperMode, put_DeveloperMode)
    ExpectedDigests = property(get_ExpectedDigests, None)
    ExternalLocationUri = property(get_ExternalLocationUri, put_ExternalLocationUri)
    ForceUpdateFromAnyVersion = property(get_ForceUpdateFromAnyVersion, put_ForceUpdateFromAnyVersion)
    InstallAllResources = property(get_InstallAllResources, put_InstallAllResources)
    IsExpectedDigestsSupported = property(get_IsExpectedDigestsSupported, None)
    OptionalPackageFamilyNames = property(get_OptionalPackageFamilyNames, None)
    OptionalPackageUris = property(get_OptionalPackageUris, None)
    RelatedPackageUris = property(get_RelatedPackageUris, None)
    RequiredContentGroupOnly = property(get_RequiredContentGroupOnly, put_RequiredContentGroupOnly)
    StageInPlace = property(get_StageInPlace, put_StageInPlace)
    StubPackageOption = property(get_StubPackageOption, put_StubPackageOption)
    TargetVolume = property(get_TargetVolume, put_TargetVolume)
class StubPackageOption(Enum, Int32):
    Default = 0
    InstallFull = 1
    InstallStub = 2
    UsePreference = 3


make_ready(__name__)
