from __future__ import annotations
from win32more import ARCH, Annotated, Boolean, Byte, Bytes, Char, ComPtr, ConstantLazyLoader, Double, Enum, FAILED, FlexibleArray, Guid, Int16, Int32, Int64, IntPtr, NativeBitfieldAttribute, POINTER, SByte, SUCCEEDED, Single, String, Structure, UInt16, UInt32, UInt64, UIntPtr, UnicodeAlias, Union, Void, VoidPtr, cfunctype, cfunctype_pointer, commethod, make_ready, winfunctype, winfunctype_pointer
from win32more._winrt import AwaitableProtocol, ContextManagerProtocol, FillArray, Generic, IInspectable, IUnknown, IterableProtocol, K, MappingProtocol, MulticastDelegate, PassArray, ReceiveArray, SequenceProtocol, T, TProgress, TResult, TSender, Tuple, V, WinRT_String, event, winrt_activatemethod, winrt_classmethod, winrt_commethod, winrt_factorymethod, winrt_mixinmethod, winrt_overload
import win32more.Windows.Foundation
import win32more.Windows.Foundation.Diagnostics
import win32more.Windows.Storage
class AsyncCausalityTracer(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Foundation.Diagnostics.AsyncCausalityTracer'
    @winrt_classmethod
    def TraceOperationCreation(cls: win32more.Windows.Foundation.Diagnostics.IAsyncCausalityTracerStatics, traceLevel: win32more.Windows.Foundation.Diagnostics.CausalityTraceLevel, source: win32more.Windows.Foundation.Diagnostics.CausalitySource, platformId: Guid, operationId: UInt64, operationName: WinRT_String, relatedContext: UInt64) -> Void: ...
    @winrt_classmethod
    def TraceOperationCompletion(cls: win32more.Windows.Foundation.Diagnostics.IAsyncCausalityTracerStatics, traceLevel: win32more.Windows.Foundation.Diagnostics.CausalityTraceLevel, source: win32more.Windows.Foundation.Diagnostics.CausalitySource, platformId: Guid, operationId: UInt64, status: win32more.Windows.Foundation.AsyncStatus) -> Void: ...
    @winrt_classmethod
    def TraceOperationRelation(cls: win32more.Windows.Foundation.Diagnostics.IAsyncCausalityTracerStatics, traceLevel: win32more.Windows.Foundation.Diagnostics.CausalityTraceLevel, source: win32more.Windows.Foundation.Diagnostics.CausalitySource, platformId: Guid, operationId: UInt64, relation: win32more.Windows.Foundation.Diagnostics.CausalityRelation) -> Void: ...
    @winrt_classmethod
    def TraceSynchronousWorkStart(cls: win32more.Windows.Foundation.Diagnostics.IAsyncCausalityTracerStatics, traceLevel: win32more.Windows.Foundation.Diagnostics.CausalityTraceLevel, source: win32more.Windows.Foundation.Diagnostics.CausalitySource, platformId: Guid, operationId: UInt64, work: win32more.Windows.Foundation.Diagnostics.CausalitySynchronousWork) -> Void: ...
    @winrt_classmethod
    def TraceSynchronousWorkCompletion(cls: win32more.Windows.Foundation.Diagnostics.IAsyncCausalityTracerStatics, traceLevel: win32more.Windows.Foundation.Diagnostics.CausalityTraceLevel, source: win32more.Windows.Foundation.Diagnostics.CausalitySource, work: win32more.Windows.Foundation.Diagnostics.CausalitySynchronousWork) -> Void: ...
    @winrt_classmethod
    def add_TracingStatusChanged(cls: win32more.Windows.Foundation.Diagnostics.IAsyncCausalityTracerStatics, handler: win32more.Windows.Foundation.EventHandler[win32more.Windows.Foundation.Diagnostics.TracingStatusChangedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_classmethod
    def remove_TracingStatusChanged(cls: win32more.Windows.Foundation.Diagnostics.IAsyncCausalityTracerStatics, cookie: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
class CausalityRelation(Enum, Int32):
    AssignDelegate = 0
    Join = 1
    Choice = 2
    Cancel = 3
    Error = 4
class CausalitySource(Enum, Int32):
    Application = 0
    Library = 1
    System = 2
class CausalitySynchronousWork(Enum, Int32):
    CompletionNotification = 0
    ProgressNotification = 1
    Execution = 2
class CausalityTraceLevel(Enum, Int32):
    Required = 0
    Important = 1
    Verbose = 2
class ErrorDetails(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Foundation.Diagnostics.IErrorDetails
    _classid_ = 'Windows.Foundation.Diagnostics.ErrorDetails'
    @winrt_mixinmethod
    def get_Description(self: win32more.Windows.Foundation.Diagnostics.IErrorDetails) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_LongDescription(self: win32more.Windows.Foundation.Diagnostics.IErrorDetails) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_HelpUri(self: win32more.Windows.Foundation.Diagnostics.IErrorDetails) -> win32more.Windows.Foundation.Uri: ...
    @winrt_classmethod
    def CreateFromHResultAsync(cls: win32more.Windows.Foundation.Diagnostics.IErrorDetailsStatics, errorCode: Int32) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Diagnostics.ErrorDetails]: ...
    Description = property(get_Description, None)
    HelpUri = property(get_HelpUri, None)
    LongDescription = property(get_LongDescription, None)
class ErrorOptions(Enum, UInt32):
    None_ = 0
    SuppressExceptions = 1
    ForceExceptions = 2
    UseSetErrorInfo = 4
    SuppressSetErrorInfo = 8
class FileLoggingSession(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Windows.Foundation.Diagnostics.IFileLoggingSession
    _classid_ = 'Windows.Foundation.Diagnostics.FileLoggingSession'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Foundation.Diagnostics.FileLoggingSession.Create(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def Create(cls: win32more.Windows.Foundation.Diagnostics.IFileLoggingSessionFactory, name: WinRT_String) -> win32more.Windows.Foundation.Diagnostics.FileLoggingSession: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Foundation.Diagnostics.IFileLoggingSession) -> WinRT_String: ...
    @winrt_mixinmethod
    def AddLoggingChannel(self: win32more.Windows.Foundation.Diagnostics.IFileLoggingSession, loggingChannel: win32more.Windows.Foundation.Diagnostics.ILoggingChannel) -> Void: ...
    @winrt_mixinmethod
    def AddLoggingChannelWithLevel(self: win32more.Windows.Foundation.Diagnostics.IFileLoggingSession, loggingChannel: win32more.Windows.Foundation.Diagnostics.ILoggingChannel, maxLevel: win32more.Windows.Foundation.Diagnostics.LoggingLevel) -> Void: ...
    @winrt_mixinmethod
    def RemoveLoggingChannel(self: win32more.Windows.Foundation.Diagnostics.IFileLoggingSession, loggingChannel: win32more.Windows.Foundation.Diagnostics.ILoggingChannel) -> Void: ...
    @winrt_mixinmethod
    def CloseAndSaveToFileAsync(self: win32more.Windows.Foundation.Diagnostics.IFileLoggingSession) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Storage.StorageFile]: ...
    @winrt_mixinmethod
    def add_LogFileGenerated(self: win32more.Windows.Foundation.Diagnostics.IFileLoggingSession, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Foundation.Diagnostics.IFileLoggingSession, win32more.Windows.Foundation.Diagnostics.LogFileGeneratedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_LogFileGenerated(self: win32more.Windows.Foundation.Diagnostics.IFileLoggingSession, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    Name = property(get_Name, None)
    LogFileGenerated = event()
class IAsyncCausalityTracerStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Foundation.Diagnostics.IAsyncCausalityTracerStatics'
    _iid_ = Guid('{50850b26-267e-451b-a890-ab6a370245ee}')
    @winrt_commethod(6)
    def TraceOperationCreation(self, traceLevel: win32more.Windows.Foundation.Diagnostics.CausalityTraceLevel, source: win32more.Windows.Foundation.Diagnostics.CausalitySource, platformId: Guid, operationId: UInt64, operationName: WinRT_String, relatedContext: UInt64) -> Void: ...
    @winrt_commethod(7)
    def TraceOperationCompletion(self, traceLevel: win32more.Windows.Foundation.Diagnostics.CausalityTraceLevel, source: win32more.Windows.Foundation.Diagnostics.CausalitySource, platformId: Guid, operationId: UInt64, status: win32more.Windows.Foundation.AsyncStatus) -> Void: ...
    @winrt_commethod(8)
    def TraceOperationRelation(self, traceLevel: win32more.Windows.Foundation.Diagnostics.CausalityTraceLevel, source: win32more.Windows.Foundation.Diagnostics.CausalitySource, platformId: Guid, operationId: UInt64, relation: win32more.Windows.Foundation.Diagnostics.CausalityRelation) -> Void: ...
    @winrt_commethod(9)
    def TraceSynchronousWorkStart(self, traceLevel: win32more.Windows.Foundation.Diagnostics.CausalityTraceLevel, source: win32more.Windows.Foundation.Diagnostics.CausalitySource, platformId: Guid, operationId: UInt64, work: win32more.Windows.Foundation.Diagnostics.CausalitySynchronousWork) -> Void: ...
    @winrt_commethod(10)
    def TraceSynchronousWorkCompletion(self, traceLevel: win32more.Windows.Foundation.Diagnostics.CausalityTraceLevel, source: win32more.Windows.Foundation.Diagnostics.CausalitySource, work: win32more.Windows.Foundation.Diagnostics.CausalitySynchronousWork) -> Void: ...
    @winrt_commethod(11)
    def add_TracingStatusChanged(self, handler: win32more.Windows.Foundation.EventHandler[win32more.Windows.Foundation.Diagnostics.TracingStatusChangedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(12)
    def remove_TracingStatusChanged(self, cookie: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    TracingStatusChanged = event()
class IErrorDetails(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Foundation.Diagnostics.IErrorDetails'
    _iid_ = Guid('{378cbb01-2cc9-428f-8c55-2c990d463e8f}')
    @winrt_commethod(6)
    def get_Description(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def get_LongDescription(self) -> WinRT_String: ...
    @winrt_commethod(8)
    def get_HelpUri(self) -> win32more.Windows.Foundation.Uri: ...
    Description = property(get_Description, None)
    HelpUri = property(get_HelpUri, None)
    LongDescription = property(get_LongDescription, None)
class IErrorDetailsStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Foundation.Diagnostics.IErrorDetailsStatics'
    _iid_ = Guid('{b7703750-0b1d-46c8-aa0e-4b8178e4fce9}')
    @winrt_commethod(6)
    def CreateFromHResultAsync(self, errorCode: Int32) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Diagnostics.ErrorDetails]: ...
class IErrorReportingSettings(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Foundation.Diagnostics.IErrorReportingSettings'
    _iid_ = Guid('{16369792-b03e-4ba1-8bb8-d28f4ab4d2c0}')
    @winrt_commethod(6)
    def SetErrorOptions(self, value: win32more.Windows.Foundation.Diagnostics.ErrorOptions) -> Void: ...
    @winrt_commethod(7)
    def GetErrorOptions(self) -> win32more.Windows.Foundation.Diagnostics.ErrorOptions: ...
class IFileLoggingSession(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Windows.Foundation.Diagnostics.IFileLoggingSession'
    _iid_ = Guid('{24c74216-fed2-404c-895f-1f9699cb02f7}')
    @winrt_commethod(6)
    def get_Name(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def AddLoggingChannel(self, loggingChannel: win32more.Windows.Foundation.Diagnostics.ILoggingChannel) -> Void: ...
    @winrt_commethod(8)
    def AddLoggingChannelWithLevel(self, loggingChannel: win32more.Windows.Foundation.Diagnostics.ILoggingChannel, maxLevel: win32more.Windows.Foundation.Diagnostics.LoggingLevel) -> Void: ...
    @winrt_commethod(9)
    def RemoveLoggingChannel(self, loggingChannel: win32more.Windows.Foundation.Diagnostics.ILoggingChannel) -> Void: ...
    @winrt_commethod(10)
    def CloseAndSaveToFileAsync(self) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Storage.StorageFile]: ...
    @winrt_commethod(11)
    def add_LogFileGenerated(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Foundation.Diagnostics.IFileLoggingSession, win32more.Windows.Foundation.Diagnostics.LogFileGeneratedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(12)
    def remove_LogFileGenerated(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    Name = property(get_Name, None)
    LogFileGenerated = event()
class IFileLoggingSessionFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Foundation.Diagnostics.IFileLoggingSessionFactory'
    _iid_ = Guid('{eea08dce-8447-4daa-9133-12eb46f697d4}')
    @winrt_commethod(6)
    def Create(self, name: WinRT_String) -> win32more.Windows.Foundation.Diagnostics.FileLoggingSession: ...
class ILogFileGeneratedEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Foundation.Diagnostics.ILogFileGeneratedEventArgs'
    _iid_ = Guid('{269e976f-0d38-4c1a-b53f-b395d881df84}')
    @winrt_commethod(6)
    def get_File(self) -> win32more.Windows.Storage.StorageFile: ...
    File = property(get_File, None)
class ILoggingActivity(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Windows.Foundation.Diagnostics.ILoggingActivity'
    _iid_ = Guid('{bc032941-b766-4cb5-9848-97ac6ba6d60c}')
    @winrt_commethod(6)
    def get_Name(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def get_Id(self) -> Guid: ...
    Id = property(get_Id, None)
    Name = property(get_Name, None)
class ILoggingActivity2(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Windows.Foundation.Diagnostics.ILoggingActivity2'
    _iid_ = Guid('{26c29808-6322-456a-af82-80c8642f178b}')
    @winrt_commethod(6)
    def get_Channel(self) -> win32more.Windows.Foundation.Diagnostics.LoggingChannel: ...
    @winrt_commethod(7)
    def StopActivity(self, stopEventName: WinRT_String) -> Void: ...
    @winrt_commethod(8)
    def StopActivityWithFields(self, stopEventName: WinRT_String, fields: win32more.Windows.Foundation.Diagnostics.LoggingFields) -> Void: ...
    @winrt_commethod(9)
    def StopActivityWithFieldsAndOptions(self, stopEventName: WinRT_String, fields: win32more.Windows.Foundation.Diagnostics.LoggingFields, options: win32more.Windows.Foundation.Diagnostics.LoggingOptions) -> Void: ...
    Channel = property(get_Channel, None)
class ILoggingActivityFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Foundation.Diagnostics.ILoggingActivityFactory'
    _iid_ = Guid('{6b33b483-e10a-4c58-97d5-10fb451074fb}')
    @winrt_commethod(6)
    def CreateLoggingActivity(self, activityName: WinRT_String, loggingChannel: win32more.Windows.Foundation.Diagnostics.ILoggingChannel) -> win32more.Windows.Foundation.Diagnostics.LoggingActivity: ...
    @winrt_commethod(7)
    def CreateLoggingActivityWithLevel(self, activityName: WinRT_String, loggingChannel: win32more.Windows.Foundation.Diagnostics.ILoggingChannel, level: win32more.Windows.Foundation.Diagnostics.LoggingLevel) -> win32more.Windows.Foundation.Diagnostics.LoggingActivity: ...
class ILoggingChannel(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Windows.Foundation.Diagnostics.ILoggingChannel'
    _iid_ = Guid('{e9a50343-11d7-4f01-b5ca-cf495278c0a8}')
    @winrt_commethod(6)
    def get_Name(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def get_Enabled(self) -> Boolean: ...
    @winrt_commethod(8)
    def get_Level(self) -> win32more.Windows.Foundation.Diagnostics.LoggingLevel: ...
    @winrt_commethod(9)
    def LogMessage(self, eventString: WinRT_String) -> Void: ...
    @winrt_commethod(10)
    def LogMessageWithLevel(self, eventString: WinRT_String, level: win32more.Windows.Foundation.Diagnostics.LoggingLevel) -> Void: ...
    @winrt_commethod(11)
    def LogValuePair(self, value1: WinRT_String, value2: Int32) -> Void: ...
    @winrt_commethod(12)
    def LogValuePairWithLevel(self, value1: WinRT_String, value2: Int32, level: win32more.Windows.Foundation.Diagnostics.LoggingLevel) -> Void: ...
    @winrt_commethod(13)
    def add_LoggingEnabled(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Foundation.Diagnostics.ILoggingChannel, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(14)
    def remove_LoggingEnabled(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    Enabled = property(get_Enabled, None)
    Level = property(get_Level, None)
    Name = property(get_Name, None)
    LoggingEnabled = event()
class ILoggingChannel2(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Windows.Foundation.Diagnostics.ILoggingChannel2'
    _iid_ = Guid('{9f4c3cf3-0bac-45a5-9e33-baf3f3a246a5}')
    @winrt_commethod(6)
    def get_Id(self) -> Guid: ...
    Id = property(get_Id, None)
class ILoggingChannelFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Foundation.Diagnostics.ILoggingChannelFactory'
    _iid_ = Guid('{4edc5b9c-af80-4a9b-b0dc-398f9ae5207b}')
    @winrt_commethod(6)
    def Create(self, name: WinRT_String) -> win32more.Windows.Foundation.Diagnostics.LoggingChannel: ...
class ILoggingChannelFactory2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Foundation.Diagnostics.ILoggingChannelFactory2'
    _iid_ = Guid('{4c6ef5dd-3b27-4dc9-99f0-299c6e4603a1}')
    @winrt_commethod(6)
    def CreateWithOptions(self, name: WinRT_String, options: win32more.Windows.Foundation.Diagnostics.LoggingChannelOptions) -> win32more.Windows.Foundation.Diagnostics.LoggingChannel: ...
    @winrt_commethod(7)
    def CreateWithOptionsAndId(self, name: WinRT_String, options: win32more.Windows.Foundation.Diagnostics.LoggingChannelOptions, id: Guid) -> win32more.Windows.Foundation.Diagnostics.LoggingChannel: ...
class ILoggingChannelOptions(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Foundation.Diagnostics.ILoggingChannelOptions'
    _iid_ = Guid('{c3e847ff-0ebb-4a53-8c54-dec24926cb2c}')
    @winrt_commethod(6)
    def get_Group(self) -> Guid: ...
    @winrt_commethod(7)
    def put_Group(self, value: Guid) -> Void: ...
    Group = property(get_Group, put_Group)
class ILoggingChannelOptionsFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Foundation.Diagnostics.ILoggingChannelOptionsFactory'
    _iid_ = Guid('{a93151da-7faf-4191-8755-5e86dc65d896}')
    @winrt_commethod(6)
    def Create(self, group: Guid) -> win32more.Windows.Foundation.Diagnostics.LoggingChannelOptions: ...
class ILoggingFields(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Foundation.Diagnostics.ILoggingFields'
    _iid_ = Guid('{d7f6b7af-762d-4579-83bd-52c23bc333bc}')
    @winrt_commethod(6)
    def Clear(self) -> Void: ...
    @winrt_commethod(7)
    def BeginStruct(self, name: WinRT_String) -> Void: ...
    @winrt_commethod(8)
    def BeginStructWithTags(self, name: WinRT_String, tags: Int32) -> Void: ...
    @winrt_commethod(9)
    def EndStruct(self) -> Void: ...
    @winrt_commethod(10)
    def AddEmpty(self, name: WinRT_String) -> Void: ...
    @winrt_commethod(11)
    def AddEmptyWithFormat(self, name: WinRT_String, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(12)
    def AddEmptyWithFormatAndTags(self, name: WinRT_String, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(13)
    def AddUInt8(self, name: WinRT_String, value: Byte) -> Void: ...
    @winrt_commethod(14)
    def AddUInt8WithFormat(self, name: WinRT_String, value: Byte, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(15)
    def AddUInt8WithFormatAndTags(self, name: WinRT_String, value: Byte, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(16)
    def AddUInt8Array(self, name: WinRT_String, value: PassArray[Byte]) -> Void: ...
    @winrt_commethod(17)
    def AddUInt8ArrayWithFormat(self, name: WinRT_String, value: PassArray[Byte], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(18)
    def AddUInt8ArrayWithFormatAndTags(self, name: WinRT_String, value: PassArray[Byte], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(19)
    def AddInt16(self, name: WinRT_String, value: Int16) -> Void: ...
    @winrt_commethod(20)
    def AddInt16WithFormat(self, name: WinRT_String, value: Int16, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(21)
    def AddInt16WithFormatAndTags(self, name: WinRT_String, value: Int16, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(22)
    def AddInt16Array(self, name: WinRT_String, value: PassArray[Int16]) -> Void: ...
    @winrt_commethod(23)
    def AddInt16ArrayWithFormat(self, name: WinRT_String, value: PassArray[Int16], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(24)
    def AddInt16ArrayWithFormatAndTags(self, name: WinRT_String, value: PassArray[Int16], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(25)
    def AddUInt16(self, name: WinRT_String, value: UInt16) -> Void: ...
    @winrt_commethod(26)
    def AddUInt16WithFormat(self, name: WinRT_String, value: UInt16, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(27)
    def AddUInt16WithFormatAndTags(self, name: WinRT_String, value: UInt16, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(28)
    def AddUInt16Array(self, name: WinRT_String, value: PassArray[UInt16]) -> Void: ...
    @winrt_commethod(29)
    def AddUInt16ArrayWithFormat(self, name: WinRT_String, value: PassArray[UInt16], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(30)
    def AddUInt16ArrayWithFormatAndTags(self, name: WinRT_String, value: PassArray[UInt16], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(31)
    def AddInt32(self, name: WinRT_String, value: Int32) -> Void: ...
    @winrt_commethod(32)
    def AddInt32WithFormat(self, name: WinRT_String, value: Int32, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(33)
    def AddInt32WithFormatAndTags(self, name: WinRT_String, value: Int32, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(34)
    def AddInt32Array(self, name: WinRT_String, value: PassArray[Int32]) -> Void: ...
    @winrt_commethod(35)
    def AddInt32ArrayWithFormat(self, name: WinRT_String, value: PassArray[Int32], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(36)
    def AddInt32ArrayWithFormatAndTags(self, name: WinRT_String, value: PassArray[Int32], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(37)
    def AddUInt32(self, name: WinRT_String, value: UInt32) -> Void: ...
    @winrt_commethod(38)
    def AddUInt32WithFormat(self, name: WinRT_String, value: UInt32, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(39)
    def AddUInt32WithFormatAndTags(self, name: WinRT_String, value: UInt32, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(40)
    def AddUInt32Array(self, name: WinRT_String, value: PassArray[UInt32]) -> Void: ...
    @winrt_commethod(41)
    def AddUInt32ArrayWithFormat(self, name: WinRT_String, value: PassArray[UInt32], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(42)
    def AddUInt32ArrayWithFormatAndTags(self, name: WinRT_String, value: PassArray[UInt32], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(43)
    def AddInt64(self, name: WinRT_String, value: Int64) -> Void: ...
    @winrt_commethod(44)
    def AddInt64WithFormat(self, name: WinRT_String, value: Int64, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(45)
    def AddInt64WithFormatAndTags(self, name: WinRT_String, value: Int64, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(46)
    def AddInt64Array(self, name: WinRT_String, value: PassArray[Int64]) -> Void: ...
    @winrt_commethod(47)
    def AddInt64ArrayWithFormat(self, name: WinRT_String, value: PassArray[Int64], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(48)
    def AddInt64ArrayWithFormatAndTags(self, name: WinRT_String, value: PassArray[Int64], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(49)
    def AddUInt64(self, name: WinRT_String, value: UInt64) -> Void: ...
    @winrt_commethod(50)
    def AddUInt64WithFormat(self, name: WinRT_String, value: UInt64, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(51)
    def AddUInt64WithFormatAndTags(self, name: WinRT_String, value: UInt64, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(52)
    def AddUInt64Array(self, name: WinRT_String, value: PassArray[UInt64]) -> Void: ...
    @winrt_commethod(53)
    def AddUInt64ArrayWithFormat(self, name: WinRT_String, value: PassArray[UInt64], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(54)
    def AddUInt64ArrayWithFormatAndTags(self, name: WinRT_String, value: PassArray[UInt64], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(55)
    def AddSingle(self, name: WinRT_String, value: Single) -> Void: ...
    @winrt_commethod(56)
    def AddSingleWithFormat(self, name: WinRT_String, value: Single, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(57)
    def AddSingleWithFormatAndTags(self, name: WinRT_String, value: Single, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(58)
    def AddSingleArray(self, name: WinRT_String, value: PassArray[Single]) -> Void: ...
    @winrt_commethod(59)
    def AddSingleArrayWithFormat(self, name: WinRT_String, value: PassArray[Single], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(60)
    def AddSingleArrayWithFormatAndTags(self, name: WinRT_String, value: PassArray[Single], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(61)
    def AddDouble(self, name: WinRT_String, value: Double) -> Void: ...
    @winrt_commethod(62)
    def AddDoubleWithFormat(self, name: WinRT_String, value: Double, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(63)
    def AddDoubleWithFormatAndTags(self, name: WinRT_String, value: Double, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(64)
    def AddDoubleArray(self, name: WinRT_String, value: PassArray[Double]) -> Void: ...
    @winrt_commethod(65)
    def AddDoubleArrayWithFormat(self, name: WinRT_String, value: PassArray[Double], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(66)
    def AddDoubleArrayWithFormatAndTags(self, name: WinRT_String, value: PassArray[Double], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(67)
    def AddChar16(self, name: WinRT_String, value: Char) -> Void: ...
    @winrt_commethod(68)
    def AddChar16WithFormat(self, name: WinRT_String, value: Char, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(69)
    def AddChar16WithFormatAndTags(self, name: WinRT_String, value: Char, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(70)
    def AddChar16Array(self, name: WinRT_String, value: PassArray[Char]) -> Void: ...
    @winrt_commethod(71)
    def AddChar16ArrayWithFormat(self, name: WinRT_String, value: PassArray[Char], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(72)
    def AddChar16ArrayWithFormatAndTags(self, name: WinRT_String, value: PassArray[Char], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(73)
    def AddBoolean(self, name: WinRT_String, value: Boolean) -> Void: ...
    @winrt_commethod(74)
    def AddBooleanWithFormat(self, name: WinRT_String, value: Boolean, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(75)
    def AddBooleanWithFormatAndTags(self, name: WinRT_String, value: Boolean, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(76)
    def AddBooleanArray(self, name: WinRT_String, value: PassArray[Boolean]) -> Void: ...
    @winrt_commethod(77)
    def AddBooleanArrayWithFormat(self, name: WinRT_String, value: PassArray[Boolean], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(78)
    def AddBooleanArrayWithFormatAndTags(self, name: WinRT_String, value: PassArray[Boolean], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(79)
    def AddString(self, name: WinRT_String, value: WinRT_String) -> Void: ...
    @winrt_commethod(80)
    def AddStringWithFormat(self, name: WinRT_String, value: WinRT_String, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(81)
    def AddStringWithFormatAndTags(self, name: WinRT_String, value: WinRT_String, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(82)
    def AddStringArray(self, name: WinRT_String, value: PassArray[WinRT_String]) -> Void: ...
    @winrt_commethod(83)
    def AddStringArrayWithFormat(self, name: WinRT_String, value: PassArray[WinRT_String], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(84)
    def AddStringArrayWithFormatAndTags(self, name: WinRT_String, value: PassArray[WinRT_String], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(85)
    def AddGuid(self, name: WinRT_String, value: Guid) -> Void: ...
    @winrt_commethod(86)
    def AddGuidWithFormat(self, name: WinRT_String, value: Guid, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(87)
    def AddGuidWithFormatAndTags(self, name: WinRT_String, value: Guid, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(88)
    def AddGuidArray(self, name: WinRT_String, value: PassArray[Guid]) -> Void: ...
    @winrt_commethod(89)
    def AddGuidArrayWithFormat(self, name: WinRT_String, value: PassArray[Guid], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(90)
    def AddGuidArrayWithFormatAndTags(self, name: WinRT_String, value: PassArray[Guid], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(91)
    def AddDateTime(self, name: WinRT_String, value: win32more.Windows.Foundation.DateTime) -> Void: ...
    @winrt_commethod(92)
    def AddDateTimeWithFormat(self, name: WinRT_String, value: win32more.Windows.Foundation.DateTime, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(93)
    def AddDateTimeWithFormatAndTags(self, name: WinRT_String, value: win32more.Windows.Foundation.DateTime, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(94)
    def AddDateTimeArray(self, name: WinRT_String, value: PassArray[win32more.Windows.Foundation.DateTime]) -> Void: ...
    @winrt_commethod(95)
    def AddDateTimeArrayWithFormat(self, name: WinRT_String, value: PassArray[win32more.Windows.Foundation.DateTime], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(96)
    def AddDateTimeArrayWithFormatAndTags(self, name: WinRT_String, value: PassArray[win32more.Windows.Foundation.DateTime], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(97)
    def AddTimeSpan(self, name: WinRT_String, value: win32more.Windows.Foundation.TimeSpan) -> Void: ...
    @winrt_commethod(98)
    def AddTimeSpanWithFormat(self, name: WinRT_String, value: win32more.Windows.Foundation.TimeSpan, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(99)
    def AddTimeSpanWithFormatAndTags(self, name: WinRT_String, value: win32more.Windows.Foundation.TimeSpan, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(100)
    def AddTimeSpanArray(self, name: WinRT_String, value: PassArray[win32more.Windows.Foundation.TimeSpan]) -> Void: ...
    @winrt_commethod(101)
    def AddTimeSpanArrayWithFormat(self, name: WinRT_String, value: PassArray[win32more.Windows.Foundation.TimeSpan], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(102)
    def AddTimeSpanArrayWithFormatAndTags(self, name: WinRT_String, value: PassArray[win32more.Windows.Foundation.TimeSpan], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(103)
    def AddPoint(self, name: WinRT_String, value: win32more.Windows.Foundation.Point) -> Void: ...
    @winrt_commethod(104)
    def AddPointWithFormat(self, name: WinRT_String, value: win32more.Windows.Foundation.Point, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(105)
    def AddPointWithFormatAndTags(self, name: WinRT_String, value: win32more.Windows.Foundation.Point, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(106)
    def AddPointArray(self, name: WinRT_String, value: PassArray[win32more.Windows.Foundation.Point]) -> Void: ...
    @winrt_commethod(107)
    def AddPointArrayWithFormat(self, name: WinRT_String, value: PassArray[win32more.Windows.Foundation.Point], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(108)
    def AddPointArrayWithFormatAndTags(self, name: WinRT_String, value: PassArray[win32more.Windows.Foundation.Point], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(109)
    def AddSize(self, name: WinRT_String, value: win32more.Windows.Foundation.Size) -> Void: ...
    @winrt_commethod(110)
    def AddSizeWithFormat(self, name: WinRT_String, value: win32more.Windows.Foundation.Size, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(111)
    def AddSizeWithFormatAndTags(self, name: WinRT_String, value: win32more.Windows.Foundation.Size, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(112)
    def AddSizeArray(self, name: WinRT_String, value: PassArray[win32more.Windows.Foundation.Size]) -> Void: ...
    @winrt_commethod(113)
    def AddSizeArrayWithFormat(self, name: WinRT_String, value: PassArray[win32more.Windows.Foundation.Size], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(114)
    def AddSizeArrayWithFormatAndTags(self, name: WinRT_String, value: PassArray[win32more.Windows.Foundation.Size], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(115)
    def AddRect(self, name: WinRT_String, value: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_commethod(116)
    def AddRectWithFormat(self, name: WinRT_String, value: win32more.Windows.Foundation.Rect, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(117)
    def AddRectWithFormatAndTags(self, name: WinRT_String, value: win32more.Windows.Foundation.Rect, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_commethod(118)
    def AddRectArray(self, name: WinRT_String, value: PassArray[win32more.Windows.Foundation.Rect]) -> Void: ...
    @winrt_commethod(119)
    def AddRectArrayWithFormat(self, name: WinRT_String, value: PassArray[win32more.Windows.Foundation.Rect], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_commethod(120)
    def AddRectArrayWithFormatAndTags(self, name: WinRT_String, value: PassArray[win32more.Windows.Foundation.Rect], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
class ILoggingOptions(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Foundation.Diagnostics.ILoggingOptions'
    _iid_ = Guid('{90bc7850-0192-4f5d-ac26-006adaca12d8}')
    @winrt_commethod(6)
    def get_Keywords(self) -> Int64: ...
    @winrt_commethod(7)
    def put_Keywords(self, value: Int64) -> Void: ...
    @winrt_commethod(8)
    def get_Tags(self) -> Int32: ...
    @winrt_commethod(9)
    def put_Tags(self, value: Int32) -> Void: ...
    @winrt_commethod(10)
    def get_Task(self) -> Int16: ...
    @winrt_commethod(11)
    def put_Task(self, value: Int16) -> Void: ...
    @winrt_commethod(12)
    def get_Opcode(self) -> win32more.Windows.Foundation.Diagnostics.LoggingOpcode: ...
    @winrt_commethod(13)
    def put_Opcode(self, value: win32more.Windows.Foundation.Diagnostics.LoggingOpcode) -> Void: ...
    @winrt_commethod(14)
    def get_ActivityId(self) -> Guid: ...
    @winrt_commethod(15)
    def put_ActivityId(self, value: Guid) -> Void: ...
    @winrt_commethod(16)
    def get_RelatedActivityId(self) -> Guid: ...
    @winrt_commethod(17)
    def put_RelatedActivityId(self, value: Guid) -> Void: ...
    ActivityId = property(get_ActivityId, put_ActivityId)
    Keywords = property(get_Keywords, put_Keywords)
    Opcode = property(get_Opcode, put_Opcode)
    RelatedActivityId = property(get_RelatedActivityId, put_RelatedActivityId)
    Tags = property(get_Tags, put_Tags)
    Task = property(get_Task, put_Task)
class ILoggingOptionsFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Foundation.Diagnostics.ILoggingOptionsFactory'
    _iid_ = Guid('{d713c6cb-98ab-464b-9f22-a3268478368a}')
    @winrt_commethod(6)
    def CreateWithKeywords(self, keywords: Int64) -> win32more.Windows.Foundation.Diagnostics.LoggingOptions: ...
class ILoggingSession(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Windows.Foundation.Diagnostics.ILoggingSession'
    _iid_ = Guid('{6221f306-9380-4ad7-baf5-41ea9310d768}')
    @winrt_commethod(6)
    def get_Name(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def SaveToFileAsync(self, folder: win32more.Windows.Storage.IStorageFolder, fileName: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Storage.StorageFile]: ...
    @winrt_commethod(8)
    def AddLoggingChannel(self, loggingChannel: win32more.Windows.Foundation.Diagnostics.ILoggingChannel) -> Void: ...
    @winrt_commethod(9)
    def AddLoggingChannelWithLevel(self, loggingChannel: win32more.Windows.Foundation.Diagnostics.ILoggingChannel, maxLevel: win32more.Windows.Foundation.Diagnostics.LoggingLevel) -> Void: ...
    @winrt_commethod(10)
    def RemoveLoggingChannel(self, loggingChannel: win32more.Windows.Foundation.Diagnostics.ILoggingChannel) -> Void: ...
    Name = property(get_Name, None)
class ILoggingSessionFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Foundation.Diagnostics.ILoggingSessionFactory'
    _iid_ = Guid('{4e937ee5-58fd-45e0-8c2f-a132eff95c1e}')
    @winrt_commethod(6)
    def Create(self, name: WinRT_String) -> win32more.Windows.Foundation.Diagnostics.LoggingSession: ...
class ILoggingTarget(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Foundation.Diagnostics.ILoggingTarget'
    _iid_ = Guid('{65f16c35-e388-4e26-b17a-f51cd3a83916}')
    @winrt_commethod(6)
    def IsEnabled(self) -> Boolean: ...
    @winrt_commethod(7)
    def IsEnabledWithLevel(self, level: win32more.Windows.Foundation.Diagnostics.LoggingLevel) -> Boolean: ...
    @winrt_commethod(8)
    def IsEnabledWithLevelAndKeywords(self, level: win32more.Windows.Foundation.Diagnostics.LoggingLevel, keywords: Int64) -> Boolean: ...
    @winrt_commethod(9)
    def LogEvent(self, eventName: WinRT_String) -> Void: ...
    @winrt_commethod(10)
    def LogEventWithFields(self, eventName: WinRT_String, fields: win32more.Windows.Foundation.Diagnostics.LoggingFields) -> Void: ...
    @winrt_commethod(11)
    def LogEventWithFieldsAndLevel(self, eventName: WinRT_String, fields: win32more.Windows.Foundation.Diagnostics.LoggingFields, level: win32more.Windows.Foundation.Diagnostics.LoggingLevel) -> Void: ...
    @winrt_commethod(12)
    def LogEventWithFieldsAndOptions(self, eventName: WinRT_String, fields: win32more.Windows.Foundation.Diagnostics.LoggingFields, level: win32more.Windows.Foundation.Diagnostics.LoggingLevel, options: win32more.Windows.Foundation.Diagnostics.LoggingOptions) -> Void: ...
    @winrt_commethod(13)
    def StartActivity(self, startEventName: WinRT_String) -> win32more.Windows.Foundation.Diagnostics.LoggingActivity: ...
    @winrt_commethod(14)
    def StartActivityWithFields(self, startEventName: WinRT_String, fields: win32more.Windows.Foundation.Diagnostics.LoggingFields) -> win32more.Windows.Foundation.Diagnostics.LoggingActivity: ...
    @winrt_commethod(15)
    def StartActivityWithFieldsAndLevel(self, startEventName: WinRT_String, fields: win32more.Windows.Foundation.Diagnostics.LoggingFields, level: win32more.Windows.Foundation.Diagnostics.LoggingLevel) -> win32more.Windows.Foundation.Diagnostics.LoggingActivity: ...
    @winrt_commethod(16)
    def StartActivityWithFieldsAndOptions(self, startEventName: WinRT_String, fields: win32more.Windows.Foundation.Diagnostics.LoggingFields, level: win32more.Windows.Foundation.Diagnostics.LoggingLevel, options: win32more.Windows.Foundation.Diagnostics.LoggingOptions) -> win32more.Windows.Foundation.Diagnostics.LoggingActivity: ...
class ITracingStatusChangedEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Foundation.Diagnostics.ITracingStatusChangedEventArgs'
    _iid_ = Guid('{410b7711-ff3b-477f-9c9a-d2efda302dc3}')
    @winrt_commethod(6)
    def get_Enabled(self) -> Boolean: ...
    @winrt_commethod(7)
    def get_TraceLevel(self) -> win32more.Windows.Foundation.Diagnostics.CausalityTraceLevel: ...
    Enabled = property(get_Enabled, None)
    TraceLevel = property(get_TraceLevel, None)
class LogFileGeneratedEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Foundation.Diagnostics.ILogFileGeneratedEventArgs
    _classid_ = 'Windows.Foundation.Diagnostics.LogFileGeneratedEventArgs'
    @winrt_mixinmethod
    def get_File(self: win32more.Windows.Foundation.Diagnostics.ILogFileGeneratedEventArgs) -> win32more.Windows.Storage.StorageFile: ...
    File = property(get_File, None)
class LoggingActivity(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Windows.Foundation.Diagnostics.ILoggingActivity
    _classid_ = 'Windows.Foundation.Diagnostics.LoggingActivity'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 2:
            super().__init__(move=win32more.Windows.Foundation.Diagnostics.LoggingActivity.CreateLoggingActivity(*args))
        elif len(args) == 3:
            super().__init__(move=win32more.Windows.Foundation.Diagnostics.LoggingActivity.CreateLoggingActivityWithLevel(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def CreateLoggingActivity(cls: win32more.Windows.Foundation.Diagnostics.ILoggingActivityFactory, activityName: WinRT_String, loggingChannel: win32more.Windows.Foundation.Diagnostics.ILoggingChannel) -> win32more.Windows.Foundation.Diagnostics.LoggingActivity: ...
    @winrt_factorymethod
    def CreateLoggingActivityWithLevel(cls: win32more.Windows.Foundation.Diagnostics.ILoggingActivityFactory, activityName: WinRT_String, loggingChannel: win32more.Windows.Foundation.Diagnostics.ILoggingChannel, level: win32more.Windows.Foundation.Diagnostics.LoggingLevel) -> win32more.Windows.Foundation.Diagnostics.LoggingActivity: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Foundation.Diagnostics.ILoggingActivity) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_Id(self: win32more.Windows.Foundation.Diagnostics.ILoggingActivity) -> Guid: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    @winrt_mixinmethod
    def get_Channel(self: win32more.Windows.Foundation.Diagnostics.ILoggingActivity2) -> win32more.Windows.Foundation.Diagnostics.LoggingChannel: ...
    @winrt_mixinmethod
    def StopActivity(self: win32more.Windows.Foundation.Diagnostics.ILoggingActivity2, stopEventName: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def StopActivityWithFields(self: win32more.Windows.Foundation.Diagnostics.ILoggingActivity2, stopEventName: WinRT_String, fields: win32more.Windows.Foundation.Diagnostics.LoggingFields) -> Void: ...
    @winrt_mixinmethod
    def StopActivityWithFieldsAndOptions(self: win32more.Windows.Foundation.Diagnostics.ILoggingActivity2, stopEventName: WinRT_String, fields: win32more.Windows.Foundation.Diagnostics.LoggingFields, options: win32more.Windows.Foundation.Diagnostics.LoggingOptions) -> Void: ...
    @winrt_mixinmethod
    def IsEnabled(self: win32more.Windows.Foundation.Diagnostics.ILoggingTarget) -> Boolean: ...
    @winrt_mixinmethod
    def IsEnabledWithLevel(self: win32more.Windows.Foundation.Diagnostics.ILoggingTarget, level: win32more.Windows.Foundation.Diagnostics.LoggingLevel) -> Boolean: ...
    @winrt_mixinmethod
    def IsEnabledWithLevelAndKeywords(self: win32more.Windows.Foundation.Diagnostics.ILoggingTarget, level: win32more.Windows.Foundation.Diagnostics.LoggingLevel, keywords: Int64) -> Boolean: ...
    @winrt_mixinmethod
    def LogEvent(self: win32more.Windows.Foundation.Diagnostics.ILoggingTarget, eventName: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def LogEventWithFields(self: win32more.Windows.Foundation.Diagnostics.ILoggingTarget, eventName: WinRT_String, fields: win32more.Windows.Foundation.Diagnostics.LoggingFields) -> Void: ...
    @winrt_mixinmethod
    def LogEventWithFieldsAndLevel(self: win32more.Windows.Foundation.Diagnostics.ILoggingTarget, eventName: WinRT_String, fields: win32more.Windows.Foundation.Diagnostics.LoggingFields, level: win32more.Windows.Foundation.Diagnostics.LoggingLevel) -> Void: ...
    @winrt_mixinmethod
    def LogEventWithFieldsAndOptions(self: win32more.Windows.Foundation.Diagnostics.ILoggingTarget, eventName: WinRT_String, fields: win32more.Windows.Foundation.Diagnostics.LoggingFields, level: win32more.Windows.Foundation.Diagnostics.LoggingLevel, options: win32more.Windows.Foundation.Diagnostics.LoggingOptions) -> Void: ...
    @winrt_mixinmethod
    def StartActivity(self: win32more.Windows.Foundation.Diagnostics.ILoggingTarget, startEventName: WinRT_String) -> win32more.Windows.Foundation.Diagnostics.LoggingActivity: ...
    @winrt_mixinmethod
    def StartActivityWithFields(self: win32more.Windows.Foundation.Diagnostics.ILoggingTarget, startEventName: WinRT_String, fields: win32more.Windows.Foundation.Diagnostics.LoggingFields) -> win32more.Windows.Foundation.Diagnostics.LoggingActivity: ...
    @winrt_mixinmethod
    def StartActivityWithFieldsAndLevel(self: win32more.Windows.Foundation.Diagnostics.ILoggingTarget, startEventName: WinRT_String, fields: win32more.Windows.Foundation.Diagnostics.LoggingFields, level: win32more.Windows.Foundation.Diagnostics.LoggingLevel) -> win32more.Windows.Foundation.Diagnostics.LoggingActivity: ...
    @winrt_mixinmethod
    def StartActivityWithFieldsAndOptions(self: win32more.Windows.Foundation.Diagnostics.ILoggingTarget, startEventName: WinRT_String, fields: win32more.Windows.Foundation.Diagnostics.LoggingFields, level: win32more.Windows.Foundation.Diagnostics.LoggingLevel, options: win32more.Windows.Foundation.Diagnostics.LoggingOptions) -> win32more.Windows.Foundation.Diagnostics.LoggingActivity: ...
    Channel = property(get_Channel, None)
    Id = property(get_Id, None)
    Name = property(get_Name, None)
class LoggingChannel(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Windows.Foundation.Diagnostics.ILoggingChannel
    _classid_ = 'Windows.Foundation.Diagnostics.LoggingChannel'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Foundation.Diagnostics.LoggingChannel.Create(*args))
        elif len(args) == 2:
            super().__init__(move=win32more.Windows.Foundation.Diagnostics.LoggingChannel.CreateWithOptions(*args))
        elif len(args) == 3:
            super().__init__(move=win32more.Windows.Foundation.Diagnostics.LoggingChannel.CreateWithOptionsAndId(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def Create(cls: win32more.Windows.Foundation.Diagnostics.ILoggingChannelFactory, name: WinRT_String) -> win32more.Windows.Foundation.Diagnostics.LoggingChannel: ...
    @winrt_factorymethod
    def CreateWithOptions(cls: win32more.Windows.Foundation.Diagnostics.ILoggingChannelFactory2, name: WinRT_String, options: win32more.Windows.Foundation.Diagnostics.LoggingChannelOptions) -> win32more.Windows.Foundation.Diagnostics.LoggingChannel: ...
    @winrt_factorymethod
    def CreateWithOptionsAndId(cls: win32more.Windows.Foundation.Diagnostics.ILoggingChannelFactory2, name: WinRT_String, options: win32more.Windows.Foundation.Diagnostics.LoggingChannelOptions, id: Guid) -> win32more.Windows.Foundation.Diagnostics.LoggingChannel: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Foundation.Diagnostics.ILoggingChannel) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_Enabled(self: win32more.Windows.Foundation.Diagnostics.ILoggingChannel) -> Boolean: ...
    @winrt_mixinmethod
    def get_Level(self: win32more.Windows.Foundation.Diagnostics.ILoggingChannel) -> win32more.Windows.Foundation.Diagnostics.LoggingLevel: ...
    @winrt_mixinmethod
    def LogMessage(self: win32more.Windows.Foundation.Diagnostics.ILoggingChannel, eventString: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def LogMessageWithLevel(self: win32more.Windows.Foundation.Diagnostics.ILoggingChannel, eventString: WinRT_String, level: win32more.Windows.Foundation.Diagnostics.LoggingLevel) -> Void: ...
    @winrt_mixinmethod
    def LogValuePair(self: win32more.Windows.Foundation.Diagnostics.ILoggingChannel, value1: WinRT_String, value2: Int32) -> Void: ...
    @winrt_mixinmethod
    def LogValuePairWithLevel(self: win32more.Windows.Foundation.Diagnostics.ILoggingChannel, value1: WinRT_String, value2: Int32, level: win32more.Windows.Foundation.Diagnostics.LoggingLevel) -> Void: ...
    @winrt_mixinmethod
    def add_LoggingEnabled(self: win32more.Windows.Foundation.Diagnostics.ILoggingChannel, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Foundation.Diagnostics.ILoggingChannel, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_LoggingEnabled(self: win32more.Windows.Foundation.Diagnostics.ILoggingChannel, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    @winrt_mixinmethod
    def get_Id(self: win32more.Windows.Foundation.Diagnostics.ILoggingChannel2) -> Guid: ...
    @winrt_mixinmethod
    def IsEnabled(self: win32more.Windows.Foundation.Diagnostics.ILoggingTarget) -> Boolean: ...
    @winrt_mixinmethod
    def IsEnabledWithLevel(self: win32more.Windows.Foundation.Diagnostics.ILoggingTarget, level: win32more.Windows.Foundation.Diagnostics.LoggingLevel) -> Boolean: ...
    @winrt_mixinmethod
    def IsEnabledWithLevelAndKeywords(self: win32more.Windows.Foundation.Diagnostics.ILoggingTarget, level: win32more.Windows.Foundation.Diagnostics.LoggingLevel, keywords: Int64) -> Boolean: ...
    @winrt_mixinmethod
    def LogEvent(self: win32more.Windows.Foundation.Diagnostics.ILoggingTarget, eventName: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def LogEventWithFields(self: win32more.Windows.Foundation.Diagnostics.ILoggingTarget, eventName: WinRT_String, fields: win32more.Windows.Foundation.Diagnostics.LoggingFields) -> Void: ...
    @winrt_mixinmethod
    def LogEventWithFieldsAndLevel(self: win32more.Windows.Foundation.Diagnostics.ILoggingTarget, eventName: WinRT_String, fields: win32more.Windows.Foundation.Diagnostics.LoggingFields, level: win32more.Windows.Foundation.Diagnostics.LoggingLevel) -> Void: ...
    @winrt_mixinmethod
    def LogEventWithFieldsAndOptions(self: win32more.Windows.Foundation.Diagnostics.ILoggingTarget, eventName: WinRT_String, fields: win32more.Windows.Foundation.Diagnostics.LoggingFields, level: win32more.Windows.Foundation.Diagnostics.LoggingLevel, options: win32more.Windows.Foundation.Diagnostics.LoggingOptions) -> Void: ...
    @winrt_mixinmethod
    def StartActivity(self: win32more.Windows.Foundation.Diagnostics.ILoggingTarget, startEventName: WinRT_String) -> win32more.Windows.Foundation.Diagnostics.LoggingActivity: ...
    @winrt_mixinmethod
    def StartActivityWithFields(self: win32more.Windows.Foundation.Diagnostics.ILoggingTarget, startEventName: WinRT_String, fields: win32more.Windows.Foundation.Diagnostics.LoggingFields) -> win32more.Windows.Foundation.Diagnostics.LoggingActivity: ...
    @winrt_mixinmethod
    def StartActivityWithFieldsAndLevel(self: win32more.Windows.Foundation.Diagnostics.ILoggingTarget, startEventName: WinRT_String, fields: win32more.Windows.Foundation.Diagnostics.LoggingFields, level: win32more.Windows.Foundation.Diagnostics.LoggingLevel) -> win32more.Windows.Foundation.Diagnostics.LoggingActivity: ...
    @winrt_mixinmethod
    def StartActivityWithFieldsAndOptions(self: win32more.Windows.Foundation.Diagnostics.ILoggingTarget, startEventName: WinRT_String, fields: win32more.Windows.Foundation.Diagnostics.LoggingFields, level: win32more.Windows.Foundation.Diagnostics.LoggingLevel, options: win32more.Windows.Foundation.Diagnostics.LoggingOptions) -> win32more.Windows.Foundation.Diagnostics.LoggingActivity: ...
    Enabled = property(get_Enabled, None)
    Id = property(get_Id, None)
    Level = property(get_Level, None)
    Name = property(get_Name, None)
    LoggingEnabled = event()
class LoggingChannelOptions(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Foundation.Diagnostics.ILoggingChannelOptions
    _classid_ = 'Windows.Foundation.Diagnostics.LoggingChannelOptions'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.Foundation.Diagnostics.LoggingChannelOptions.CreateInstance(*args))
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Foundation.Diagnostics.LoggingChannelOptions.Create(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.Foundation.Diagnostics.LoggingChannelOptions: ...
    @winrt_factorymethod
    def Create(cls: win32more.Windows.Foundation.Diagnostics.ILoggingChannelOptionsFactory, group: Guid) -> win32more.Windows.Foundation.Diagnostics.LoggingChannelOptions: ...
    @winrt_mixinmethod
    def get_Group(self: win32more.Windows.Foundation.Diagnostics.ILoggingChannelOptions) -> Guid: ...
    @winrt_mixinmethod
    def put_Group(self: win32more.Windows.Foundation.Diagnostics.ILoggingChannelOptions, value: Guid) -> Void: ...
    Group = property(get_Group, put_Group)
class LoggingFieldFormat(Enum, Int32):
    Default = 0
    Hidden = 1
    String = 2
    Boolean = 3
    Hexadecimal = 4
    ProcessId = 5
    ThreadId = 6
    Port = 7
    Ipv4Address = 8
    Ipv6Address = 9
    SocketAddress = 10
    Xml = 11
    Json = 12
    Win32Error = 13
    NTStatus = 14
    HResult = 15
    FileTime = 16
    Signed = 17
    Unsigned = 18
class LoggingFields(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Foundation.Diagnostics.ILoggingFields
    _classid_ = 'Windows.Foundation.Diagnostics.LoggingFields'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.Foundation.Diagnostics.LoggingFields.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.Foundation.Diagnostics.LoggingFields: ...
    @winrt_mixinmethod
    def Clear(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields) -> Void: ...
    @winrt_mixinmethod
    def BeginStruct(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def BeginStructWithTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def EndStruct(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields) -> Void: ...
    @winrt_mixinmethod
    def AddEmpty(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def AddEmptyWithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddEmptyWithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddUInt8(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: Byte) -> Void: ...
    @winrt_mixinmethod
    def AddUInt8WithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: Byte, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddUInt8WithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: Byte, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddUInt8Array(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[Byte]) -> Void: ...
    @winrt_mixinmethod
    def AddUInt8ArrayWithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[Byte], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddUInt8ArrayWithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[Byte], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddInt16(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: Int16) -> Void: ...
    @winrt_mixinmethod
    def AddInt16WithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: Int16, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddInt16WithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: Int16, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddInt16Array(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[Int16]) -> Void: ...
    @winrt_mixinmethod
    def AddInt16ArrayWithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[Int16], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddInt16ArrayWithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[Int16], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddUInt16(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: UInt16) -> Void: ...
    @winrt_mixinmethod
    def AddUInt16WithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: UInt16, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddUInt16WithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: UInt16, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddUInt16Array(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[UInt16]) -> Void: ...
    @winrt_mixinmethod
    def AddUInt16ArrayWithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[UInt16], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddUInt16ArrayWithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[UInt16], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddInt32(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddInt32WithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: Int32, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddInt32WithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: Int32, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddInt32Array(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[Int32]) -> Void: ...
    @winrt_mixinmethod
    def AddInt32ArrayWithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[Int32], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddInt32ArrayWithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[Int32], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddUInt32(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: UInt32) -> Void: ...
    @winrt_mixinmethod
    def AddUInt32WithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: UInt32, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddUInt32WithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: UInt32, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddUInt32Array(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[UInt32]) -> Void: ...
    @winrt_mixinmethod
    def AddUInt32ArrayWithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[UInt32], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddUInt32ArrayWithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[UInt32], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddInt64(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: Int64) -> Void: ...
    @winrt_mixinmethod
    def AddInt64WithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: Int64, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddInt64WithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: Int64, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddInt64Array(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[Int64]) -> Void: ...
    @winrt_mixinmethod
    def AddInt64ArrayWithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[Int64], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddInt64ArrayWithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[Int64], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddUInt64(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: UInt64) -> Void: ...
    @winrt_mixinmethod
    def AddUInt64WithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: UInt64, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddUInt64WithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: UInt64, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddUInt64Array(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[UInt64]) -> Void: ...
    @winrt_mixinmethod
    def AddUInt64ArrayWithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[UInt64], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddUInt64ArrayWithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[UInt64], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddSingle(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: Single) -> Void: ...
    @winrt_mixinmethod
    def AddSingleWithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: Single, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddSingleWithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: Single, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddSingleArray(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[Single]) -> Void: ...
    @winrt_mixinmethod
    def AddSingleArrayWithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[Single], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddSingleArrayWithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[Single], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddDouble(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: Double) -> Void: ...
    @winrt_mixinmethod
    def AddDoubleWithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: Double, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddDoubleWithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: Double, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddDoubleArray(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[Double]) -> Void: ...
    @winrt_mixinmethod
    def AddDoubleArrayWithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[Double], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddDoubleArrayWithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[Double], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddChar16(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: Char) -> Void: ...
    @winrt_mixinmethod
    def AddChar16WithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: Char, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddChar16WithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: Char, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddChar16Array(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[Char]) -> Void: ...
    @winrt_mixinmethod
    def AddChar16ArrayWithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[Char], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddChar16ArrayWithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[Char], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddBoolean(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def AddBooleanWithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: Boolean, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddBooleanWithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: Boolean, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddBooleanArray(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[Boolean]) -> Void: ...
    @winrt_mixinmethod
    def AddBooleanArrayWithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[Boolean], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddBooleanArrayWithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[Boolean], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddString(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def AddStringWithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: WinRT_String, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddStringWithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: WinRT_String, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddStringArray(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[WinRT_String]) -> Void: ...
    @winrt_mixinmethod
    def AddStringArrayWithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[WinRT_String], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddStringArrayWithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[WinRT_String], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddGuid(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: Guid) -> Void: ...
    @winrt_mixinmethod
    def AddGuidWithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: Guid, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddGuidWithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: Guid, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddGuidArray(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[Guid]) -> Void: ...
    @winrt_mixinmethod
    def AddGuidArrayWithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[Guid], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddGuidArrayWithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[Guid], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddDateTime(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: win32more.Windows.Foundation.DateTime) -> Void: ...
    @winrt_mixinmethod
    def AddDateTimeWithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: win32more.Windows.Foundation.DateTime, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddDateTimeWithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: win32more.Windows.Foundation.DateTime, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddDateTimeArray(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[win32more.Windows.Foundation.DateTime]) -> Void: ...
    @winrt_mixinmethod
    def AddDateTimeArrayWithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[win32more.Windows.Foundation.DateTime], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddDateTimeArrayWithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[win32more.Windows.Foundation.DateTime], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddTimeSpan(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: win32more.Windows.Foundation.TimeSpan) -> Void: ...
    @winrt_mixinmethod
    def AddTimeSpanWithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: win32more.Windows.Foundation.TimeSpan, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddTimeSpanWithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: win32more.Windows.Foundation.TimeSpan, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddTimeSpanArray(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[win32more.Windows.Foundation.TimeSpan]) -> Void: ...
    @winrt_mixinmethod
    def AddTimeSpanArrayWithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[win32more.Windows.Foundation.TimeSpan], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddTimeSpanArrayWithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[win32more.Windows.Foundation.TimeSpan], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddPoint(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: win32more.Windows.Foundation.Point) -> Void: ...
    @winrt_mixinmethod
    def AddPointWithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: win32more.Windows.Foundation.Point, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddPointWithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: win32more.Windows.Foundation.Point, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddPointArray(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[win32more.Windows.Foundation.Point]) -> Void: ...
    @winrt_mixinmethod
    def AddPointArrayWithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[win32more.Windows.Foundation.Point], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddPointArrayWithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[win32more.Windows.Foundation.Point], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddSize(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: win32more.Windows.Foundation.Size) -> Void: ...
    @winrt_mixinmethod
    def AddSizeWithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: win32more.Windows.Foundation.Size, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddSizeWithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: win32more.Windows.Foundation.Size, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddSizeArray(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[win32more.Windows.Foundation.Size]) -> Void: ...
    @winrt_mixinmethod
    def AddSizeArrayWithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[win32more.Windows.Foundation.Size], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddSizeArrayWithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[win32more.Windows.Foundation.Size], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddRect(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def AddRectWithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: win32more.Windows.Foundation.Rect, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddRectWithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: win32more.Windows.Foundation.Rect, format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddRectArray(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[win32more.Windows.Foundation.Rect]) -> Void: ...
    @winrt_mixinmethod
    def AddRectArrayWithFormat(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[win32more.Windows.Foundation.Rect], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat) -> Void: ...
    @winrt_mixinmethod
    def AddRectArrayWithFormatAndTags(self: win32more.Windows.Foundation.Diagnostics.ILoggingFields, name: WinRT_String, value: PassArray[win32more.Windows.Foundation.Rect], format: win32more.Windows.Foundation.Diagnostics.LoggingFieldFormat, tags: Int32) -> Void: ...
class LoggingLevel(Enum, Int32):
    Verbose = 0
    Information = 1
    Warning = 2
    Error = 3
    Critical = 4
class LoggingOpcode(Enum, Int32):
    Info = 0
    Start = 1
    Stop = 2
    Reply = 6
    Resume = 7
    Suspend = 8
    Send = 9
class LoggingOptions(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Foundation.Diagnostics.ILoggingOptions
    _classid_ = 'Windows.Foundation.Diagnostics.LoggingOptions'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.Foundation.Diagnostics.LoggingOptions.CreateInstance(*args))
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Foundation.Diagnostics.LoggingOptions.CreateWithKeywords(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.Foundation.Diagnostics.LoggingOptions: ...
    @winrt_factorymethod
    def CreateWithKeywords(cls: win32more.Windows.Foundation.Diagnostics.ILoggingOptionsFactory, keywords: Int64) -> win32more.Windows.Foundation.Diagnostics.LoggingOptions: ...
    @winrt_mixinmethod
    def get_Keywords(self: win32more.Windows.Foundation.Diagnostics.ILoggingOptions) -> Int64: ...
    @winrt_mixinmethod
    def put_Keywords(self: win32more.Windows.Foundation.Diagnostics.ILoggingOptions, value: Int64) -> Void: ...
    @winrt_mixinmethod
    def get_Tags(self: win32more.Windows.Foundation.Diagnostics.ILoggingOptions) -> Int32: ...
    @winrt_mixinmethod
    def put_Tags(self: win32more.Windows.Foundation.Diagnostics.ILoggingOptions, value: Int32) -> Void: ...
    @winrt_mixinmethod
    def get_Task(self: win32more.Windows.Foundation.Diagnostics.ILoggingOptions) -> Int16: ...
    @winrt_mixinmethod
    def put_Task(self: win32more.Windows.Foundation.Diagnostics.ILoggingOptions, value: Int16) -> Void: ...
    @winrt_mixinmethod
    def get_Opcode(self: win32more.Windows.Foundation.Diagnostics.ILoggingOptions) -> win32more.Windows.Foundation.Diagnostics.LoggingOpcode: ...
    @winrt_mixinmethod
    def put_Opcode(self: win32more.Windows.Foundation.Diagnostics.ILoggingOptions, value: win32more.Windows.Foundation.Diagnostics.LoggingOpcode) -> Void: ...
    @winrt_mixinmethod
    def get_ActivityId(self: win32more.Windows.Foundation.Diagnostics.ILoggingOptions) -> Guid: ...
    @winrt_mixinmethod
    def put_ActivityId(self: win32more.Windows.Foundation.Diagnostics.ILoggingOptions, value: Guid) -> Void: ...
    @winrt_mixinmethod
    def get_RelatedActivityId(self: win32more.Windows.Foundation.Diagnostics.ILoggingOptions) -> Guid: ...
    @winrt_mixinmethod
    def put_RelatedActivityId(self: win32more.Windows.Foundation.Diagnostics.ILoggingOptions, value: Guid) -> Void: ...
    ActivityId = property(get_ActivityId, put_ActivityId)
    Keywords = property(get_Keywords, put_Keywords)
    Opcode = property(get_Opcode, put_Opcode)
    RelatedActivityId = property(get_RelatedActivityId, put_RelatedActivityId)
    Tags = property(get_Tags, put_Tags)
    Task = property(get_Task, put_Task)
class LoggingSession(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Windows.Foundation.Diagnostics.ILoggingSession
    _classid_ = 'Windows.Foundation.Diagnostics.LoggingSession'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Foundation.Diagnostics.LoggingSession.Create(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def Create(cls: win32more.Windows.Foundation.Diagnostics.ILoggingSessionFactory, name: WinRT_String) -> win32more.Windows.Foundation.Diagnostics.LoggingSession: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Foundation.Diagnostics.ILoggingSession) -> WinRT_String: ...
    @winrt_mixinmethod
    def SaveToFileAsync(self: win32more.Windows.Foundation.Diagnostics.ILoggingSession, folder: win32more.Windows.Storage.IStorageFolder, fileName: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Storage.StorageFile]: ...
    @winrt_mixinmethod
    def AddLoggingChannel(self: win32more.Windows.Foundation.Diagnostics.ILoggingSession, loggingChannel: win32more.Windows.Foundation.Diagnostics.ILoggingChannel) -> Void: ...
    @winrt_mixinmethod
    def AddLoggingChannelWithLevel(self: win32more.Windows.Foundation.Diagnostics.ILoggingSession, loggingChannel: win32more.Windows.Foundation.Diagnostics.ILoggingChannel, maxLevel: win32more.Windows.Foundation.Diagnostics.LoggingLevel) -> Void: ...
    @winrt_mixinmethod
    def RemoveLoggingChannel(self: win32more.Windows.Foundation.Diagnostics.ILoggingSession, loggingChannel: win32more.Windows.Foundation.Diagnostics.ILoggingChannel) -> Void: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    Name = property(get_Name, None)
class RuntimeBrokerErrorSettings(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Foundation.Diagnostics.IErrorReportingSettings
    _classid_ = 'Windows.Foundation.Diagnostics.RuntimeBrokerErrorSettings'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.Foundation.Diagnostics.RuntimeBrokerErrorSettings.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.Foundation.Diagnostics.RuntimeBrokerErrorSettings: ...
    @winrt_mixinmethod
    def SetErrorOptions(self: win32more.Windows.Foundation.Diagnostics.IErrorReportingSettings, value: win32more.Windows.Foundation.Diagnostics.ErrorOptions) -> Void: ...
    @winrt_mixinmethod
    def GetErrorOptions(self: win32more.Windows.Foundation.Diagnostics.IErrorReportingSettings) -> win32more.Windows.Foundation.Diagnostics.ErrorOptions: ...
class TracingStatusChangedEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Foundation.Diagnostics.ITracingStatusChangedEventArgs
    _classid_ = 'Windows.Foundation.Diagnostics.TracingStatusChangedEventArgs'
    @winrt_mixinmethod
    def get_Enabled(self: win32more.Windows.Foundation.Diagnostics.ITracingStatusChangedEventArgs) -> Boolean: ...
    @winrt_mixinmethod
    def get_TraceLevel(self: win32more.Windows.Foundation.Diagnostics.ITracingStatusChangedEventArgs) -> win32more.Windows.Foundation.Diagnostics.CausalityTraceLevel: ...
    Enabled = property(get_Enabled, None)
    TraceLevel = property(get_TraceLevel, None)


make_ready(__name__)
