from __future__ import annotations
from win32more import ARCH, Annotated, Boolean, Byte, Bytes, Char, ComPtr, ConstantLazyLoader, Double, Enum, FAILED, FlexibleArray, Guid, Int16, Int32, Int64, IntPtr, NativeBitfieldAttribute, POINTER, SByte, SUCCEEDED, Single, String, Structure, UInt16, UInt32, UInt64, UIntPtr, UnicodeAlias, Union, Void, VoidPtr, cfunctype, cfunctype_pointer, commethod, make_ready, winfunctype, winfunctype_pointer
from win32more._winrt import AwaitableProtocol, ContextManagerProtocol, FillArray, Generic, IInspectable, IUnknown, IterableProtocol, K, MappingProtocol, MulticastDelegate, PassArray, ReceiveArray, SequenceProtocol, T, TProgress, TResult, TSender, Tuple, V, WinRT_String, event, winrt_activatemethod, winrt_classmethod, winrt_commethod, winrt_factorymethod, winrt_mixinmethod, winrt_overload
import win32more.Windows.Devices.Enumeration
import win32more.Windows.Foundation
import win32more.Windows.Foundation.Collections
import win32more.Windows.Foundation.Numerics
import win32more.Windows.Graphics.DirectX.Direct3D11
import win32more.Windows.Media
import win32more.Windows.Media.Audio
import win32more.Windows.Media.Casting
import win32more.Windows.Media.Core
import win32more.Windows.Media.MediaProperties
import win32more.Windows.Media.Playback
import win32more.Windows.Media.Protection
import win32more.Windows.Storage
import win32more.Windows.Storage.Streams
import win32more.Windows.UI.Composition
class AutoLoadedDisplayPropertyKind(Enum, Int32):
    None_ = 0
    MusicOrVideo = 1
    Music = 2
    Video = 3
class _BackgroundMediaPlayer_Meta_(ComPtr.__class__):
    pass
class BackgroundMediaPlayer(ComPtr, metaclass=_BackgroundMediaPlayer_Meta_):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.BackgroundMediaPlayer'
    @winrt_classmethod
    def get_Current(cls: win32more.Windows.Media.Playback.IBackgroundMediaPlayerStatics) -> win32more.Windows.Media.Playback.MediaPlayer: ...
    @winrt_classmethod
    def add_MessageReceivedFromBackground(cls: win32more.Windows.Media.Playback.IBackgroundMediaPlayerStatics, value: win32more.Windows.Foundation.EventHandler[win32more.Windows.Media.Playback.MediaPlayerDataReceivedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_classmethod
    def remove_MessageReceivedFromBackground(cls: win32more.Windows.Media.Playback.IBackgroundMediaPlayerStatics, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_classmethod
    def add_MessageReceivedFromForeground(cls: win32more.Windows.Media.Playback.IBackgroundMediaPlayerStatics, value: win32more.Windows.Foundation.EventHandler[win32more.Windows.Media.Playback.MediaPlayerDataReceivedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_classmethod
    def remove_MessageReceivedFromForeground(cls: win32more.Windows.Media.Playback.IBackgroundMediaPlayerStatics, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_classmethod
    def SendMessageToBackground(cls: win32more.Windows.Media.Playback.IBackgroundMediaPlayerStatics, value: win32more.Windows.Foundation.Collections.ValueSet) -> Void: ...
    @winrt_classmethod
    def SendMessageToForeground(cls: win32more.Windows.Media.Playback.IBackgroundMediaPlayerStatics, value: win32more.Windows.Foundation.Collections.ValueSet) -> Void: ...
    @winrt_classmethod
    def IsMediaPlaying(cls: win32more.Windows.Media.Playback.IBackgroundMediaPlayerStatics) -> Boolean: ...
    @winrt_classmethod
    def Shutdown(cls: win32more.Windows.Media.Playback.IBackgroundMediaPlayerStatics) -> Void: ...
    _BackgroundMediaPlayer_Meta_.Current = property(get_Current, None)
class CurrentMediaPlaybackItemChangedEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.ICurrentMediaPlaybackItemChangedEventArgs
    _classid_ = 'Windows.Media.Playback.CurrentMediaPlaybackItemChangedEventArgs'
    @winrt_mixinmethod
    def get_NewItem(self: win32more.Windows.Media.Playback.ICurrentMediaPlaybackItemChangedEventArgs) -> win32more.Windows.Media.Playback.MediaPlaybackItem: ...
    @winrt_mixinmethod
    def get_OldItem(self: win32more.Windows.Media.Playback.ICurrentMediaPlaybackItemChangedEventArgs) -> win32more.Windows.Media.Playback.MediaPlaybackItem: ...
    @winrt_mixinmethod
    def get_Reason(self: win32more.Windows.Media.Playback.ICurrentMediaPlaybackItemChangedEventArgs2) -> win32more.Windows.Media.Playback.MediaPlaybackItemChangedReason: ...
    NewItem = property(get_NewItem, None)
    OldItem = property(get_OldItem, None)
    Reason = property(get_Reason, None)
class FailedMediaStreamKind(Enum, Int32):
    Unknown = 0
    Audio = 1
    Video = 2
class IBackgroundMediaPlayerStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IBackgroundMediaPlayerStatics'
    _iid_ = Guid('{856ddbc1-55f7-471f-a0f2-68ac4c904592}')
    @winrt_commethod(6)
    def get_Current(self) -> win32more.Windows.Media.Playback.MediaPlayer: ...
    @winrt_commethod(7)
    def add_MessageReceivedFromBackground(self, value: win32more.Windows.Foundation.EventHandler[win32more.Windows.Media.Playback.MediaPlayerDataReceivedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(8)
    def remove_MessageReceivedFromBackground(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(9)
    def add_MessageReceivedFromForeground(self, value: win32more.Windows.Foundation.EventHandler[win32more.Windows.Media.Playback.MediaPlayerDataReceivedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(10)
    def remove_MessageReceivedFromForeground(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(11)
    def SendMessageToBackground(self, value: win32more.Windows.Foundation.Collections.ValueSet) -> Void: ...
    @winrt_commethod(12)
    def SendMessageToForeground(self, value: win32more.Windows.Foundation.Collections.ValueSet) -> Void: ...
    @winrt_commethod(13)
    def IsMediaPlaying(self) -> Boolean: ...
    @winrt_commethod(14)
    def Shutdown(self) -> Void: ...
    Current = property(get_Current, None)
    MessageReceivedFromBackground = event()
    MessageReceivedFromForeground = event()
class ICurrentMediaPlaybackItemChangedEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.ICurrentMediaPlaybackItemChangedEventArgs'
    _iid_ = Guid('{1743a892-5c43-4a15-967a-572d2d0f26c6}')
    @winrt_commethod(6)
    def get_NewItem(self) -> win32more.Windows.Media.Playback.MediaPlaybackItem: ...
    @winrt_commethod(7)
    def get_OldItem(self) -> win32more.Windows.Media.Playback.MediaPlaybackItem: ...
    NewItem = property(get_NewItem, None)
    OldItem = property(get_OldItem, None)
class ICurrentMediaPlaybackItemChangedEventArgs2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.ICurrentMediaPlaybackItemChangedEventArgs2'
    _iid_ = Guid('{1d80a51e-996e-40a9-be48-e66ec90b2b7d}')
    @winrt_commethod(6)
    def get_Reason(self) -> win32more.Windows.Media.Playback.MediaPlaybackItemChangedReason: ...
    Reason = property(get_Reason, None)
class IMediaBreak(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaBreak'
    _iid_ = Guid('{714be270-0def-4ebc-a489-6b34930e1558}')
    @winrt_commethod(6)
    def get_PlaybackList(self) -> win32more.Windows.Media.Playback.MediaPlaybackList: ...
    @winrt_commethod(7)
    def get_PresentationPosition(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]: ...
    @winrt_commethod(8)
    def get_InsertionMethod(self) -> win32more.Windows.Media.Playback.MediaBreakInsertionMethod: ...
    @winrt_commethod(9)
    def get_CustomProperties(self) -> win32more.Windows.Foundation.Collections.ValueSet: ...
    @winrt_commethod(10)
    def get_CanStart(self) -> Boolean: ...
    @winrt_commethod(11)
    def put_CanStart(self, value: Boolean) -> Void: ...
    CanStart = property(get_CanStart, put_CanStart)
    CustomProperties = property(get_CustomProperties, None)
    InsertionMethod = property(get_InsertionMethod, None)
    PlaybackList = property(get_PlaybackList, None)
    PresentationPosition = property(get_PresentationPosition, None)
class IMediaBreakEndedEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaBreakEndedEventArgs'
    _iid_ = Guid('{32b93276-1c5d-4fee-8732-236dc3a88580}')
    @winrt_commethod(6)
    def get_MediaBreak(self) -> win32more.Windows.Media.Playback.MediaBreak: ...
    MediaBreak = property(get_MediaBreak, None)
class IMediaBreakFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaBreakFactory'
    _iid_ = Guid('{4516e002-18e0-4079-8b5f-d33495c15d2e}')
    @winrt_commethod(6)
    def Create(self, insertionMethod: win32more.Windows.Media.Playback.MediaBreakInsertionMethod) -> win32more.Windows.Media.Playback.MediaBreak: ...
    @winrt_commethod(7)
    def CreateWithPresentationPosition(self, insertionMethod: win32more.Windows.Media.Playback.MediaBreakInsertionMethod, presentationPosition: win32more.Windows.Foundation.TimeSpan) -> win32more.Windows.Media.Playback.MediaBreak: ...
class IMediaBreakManager(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaBreakManager'
    _iid_ = Guid('{a854ddb1-feb4-4d9b-9d97-0fdbe58e5e39}')
    @winrt_commethod(6)
    def add_BreaksSeekedOver(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaBreakManager, win32more.Windows.Media.Playback.MediaBreakSeekedOverEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(7)
    def remove_BreaksSeekedOver(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(8)
    def add_BreakStarted(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaBreakManager, win32more.Windows.Media.Playback.MediaBreakStartedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(9)
    def remove_BreakStarted(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(10)
    def add_BreakEnded(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaBreakManager, win32more.Windows.Media.Playback.MediaBreakEndedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(11)
    def remove_BreakEnded(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(12)
    def add_BreakSkipped(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaBreakManager, win32more.Windows.Media.Playback.MediaBreakSkippedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(13)
    def remove_BreakSkipped(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(14)
    def get_CurrentBreak(self) -> win32more.Windows.Media.Playback.MediaBreak: ...
    @winrt_commethod(15)
    def get_PlaybackSession(self) -> win32more.Windows.Media.Playback.MediaPlaybackSession: ...
    @winrt_commethod(16)
    def PlayBreak(self, value: win32more.Windows.Media.Playback.MediaBreak) -> Void: ...
    @winrt_commethod(17)
    def SkipCurrentBreak(self) -> Void: ...
    CurrentBreak = property(get_CurrentBreak, None)
    PlaybackSession = property(get_PlaybackSession, None)
    BreaksSeekedOver = event()
    BreakStarted = event()
    BreakEnded = event()
    BreakSkipped = event()
class IMediaBreakSchedule(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaBreakSchedule'
    _iid_ = Guid('{a19a5813-98b6-41d8-83da-f971d22b7bba}')
    @winrt_commethod(6)
    def add_ScheduleChanged(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaBreakSchedule, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(7)
    def remove_ScheduleChanged(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(8)
    def InsertMidrollBreak(self, mediaBreak: win32more.Windows.Media.Playback.MediaBreak) -> Void: ...
    @winrt_commethod(9)
    def RemoveMidrollBreak(self, mediaBreak: win32more.Windows.Media.Playback.MediaBreak) -> Void: ...
    @winrt_commethod(10)
    def get_MidrollBreaks(self) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Media.Playback.MediaBreak]: ...
    @winrt_commethod(11)
    def put_PrerollBreak(self, value: win32more.Windows.Media.Playback.MediaBreak) -> Void: ...
    @winrt_commethod(12)
    def get_PrerollBreak(self) -> win32more.Windows.Media.Playback.MediaBreak: ...
    @winrt_commethod(13)
    def put_PostrollBreak(self, value: win32more.Windows.Media.Playback.MediaBreak) -> Void: ...
    @winrt_commethod(14)
    def get_PostrollBreak(self) -> win32more.Windows.Media.Playback.MediaBreak: ...
    @winrt_commethod(15)
    def get_PlaybackItem(self) -> win32more.Windows.Media.Playback.MediaPlaybackItem: ...
    MidrollBreaks = property(get_MidrollBreaks, None)
    PlaybackItem = property(get_PlaybackItem, None)
    PostrollBreak = property(get_PostrollBreak, put_PostrollBreak)
    PrerollBreak = property(get_PrerollBreak, put_PrerollBreak)
    ScheduleChanged = event()
class IMediaBreakSeekedOverEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaBreakSeekedOverEventArgs'
    _iid_ = Guid('{e5aa6746-0606-4492-b9d3-c3c8fde0a4ea}')
    @winrt_commethod(6)
    def get_SeekedOverBreaks(self) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Media.Playback.MediaBreak]: ...
    @winrt_commethod(7)
    def get_OldPosition(self) -> win32more.Windows.Foundation.TimeSpan: ...
    @winrt_commethod(8)
    def get_NewPosition(self) -> win32more.Windows.Foundation.TimeSpan: ...
    NewPosition = property(get_NewPosition, None)
    OldPosition = property(get_OldPosition, None)
    SeekedOverBreaks = property(get_SeekedOverBreaks, None)
class IMediaBreakSkippedEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaBreakSkippedEventArgs'
    _iid_ = Guid('{6ee94c05-2f54-4a3e-a3ab-24c3b270b4a3}')
    @winrt_commethod(6)
    def get_MediaBreak(self) -> win32more.Windows.Media.Playback.MediaBreak: ...
    MediaBreak = property(get_MediaBreak, None)
class IMediaBreakStartedEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaBreakStartedEventArgs'
    _iid_ = Guid('{a87efe71-dfd4-454a-956e-0a4a648395f8}')
    @winrt_commethod(6)
    def get_MediaBreak(self) -> win32more.Windows.Media.Playback.MediaBreak: ...
    MediaBreak = property(get_MediaBreak, None)
class IMediaEnginePlaybackSource(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaEnginePlaybackSource'
    _iid_ = Guid('{5c1d0ba7-3856-48b9-8dc6-244bf107bf8c}')
    @winrt_commethod(6)
    def get_CurrentItem(self) -> win32more.Windows.Media.Playback.MediaPlaybackItem: ...
    @winrt_commethod(7)
    def SetPlaybackSource(self, source: win32more.Windows.Media.Playback.IMediaPlaybackSource) -> Void: ...
    CurrentItem = property(get_CurrentItem, None)
class IMediaItemDisplayProperties(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaItemDisplayProperties'
    _iid_ = Guid('{1e3c1b48-7097-4384-a217-c1291dfa8c16}')
    @winrt_commethod(6)
    def get_Type(self) -> win32more.Windows.Media.MediaPlaybackType: ...
    @winrt_commethod(7)
    def put_Type(self, value: win32more.Windows.Media.MediaPlaybackType) -> Void: ...
    @winrt_commethod(8)
    def get_MusicProperties(self) -> win32more.Windows.Media.MusicDisplayProperties: ...
    @winrt_commethod(9)
    def get_VideoProperties(self) -> win32more.Windows.Media.VideoDisplayProperties: ...
    @winrt_commethod(10)
    def get_Thumbnail(self) -> win32more.Windows.Storage.Streams.RandomAccessStreamReference: ...
    @winrt_commethod(11)
    def put_Thumbnail(self, value: win32more.Windows.Storage.Streams.RandomAccessStreamReference) -> Void: ...
    @winrt_commethod(12)
    def ClearAll(self) -> Void: ...
    MusicProperties = property(get_MusicProperties, None)
    Thumbnail = property(get_Thumbnail, put_Thumbnail)
    Type = property(get_Type, put_Type)
    VideoProperties = property(get_VideoProperties, None)
class IMediaPlaybackCommandManager(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlaybackCommandManager'
    _iid_ = Guid('{5acee5a6-5cb6-4a5a-8521-cc86b1c1ed37}')
    @winrt_commethod(6)
    def get_IsEnabled(self) -> Boolean: ...
    @winrt_commethod(7)
    def put_IsEnabled(self, value: Boolean) -> Void: ...
    @winrt_commethod(8)
    def get_MediaPlayer(self) -> win32more.Windows.Media.Playback.MediaPlayer: ...
    @winrt_commethod(9)
    def get_PlayBehavior(self) -> win32more.Windows.Media.Playback.MediaPlaybackCommandManagerCommandBehavior: ...
    @winrt_commethod(10)
    def get_PauseBehavior(self) -> win32more.Windows.Media.Playback.MediaPlaybackCommandManagerCommandBehavior: ...
    @winrt_commethod(11)
    def get_NextBehavior(self) -> win32more.Windows.Media.Playback.MediaPlaybackCommandManagerCommandBehavior: ...
    @winrt_commethod(12)
    def get_PreviousBehavior(self) -> win32more.Windows.Media.Playback.MediaPlaybackCommandManagerCommandBehavior: ...
    @winrt_commethod(13)
    def get_FastForwardBehavior(self) -> win32more.Windows.Media.Playback.MediaPlaybackCommandManagerCommandBehavior: ...
    @winrt_commethod(14)
    def get_RewindBehavior(self) -> win32more.Windows.Media.Playback.MediaPlaybackCommandManagerCommandBehavior: ...
    @winrt_commethod(15)
    def get_ShuffleBehavior(self) -> win32more.Windows.Media.Playback.MediaPlaybackCommandManagerCommandBehavior: ...
    @winrt_commethod(16)
    def get_AutoRepeatModeBehavior(self) -> win32more.Windows.Media.Playback.MediaPlaybackCommandManagerCommandBehavior: ...
    @winrt_commethod(17)
    def get_PositionBehavior(self) -> win32more.Windows.Media.Playback.MediaPlaybackCommandManagerCommandBehavior: ...
    @winrt_commethod(18)
    def get_RateBehavior(self) -> win32more.Windows.Media.Playback.MediaPlaybackCommandManagerCommandBehavior: ...
    @winrt_commethod(19)
    def add_PlayReceived(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackCommandManager, win32more.Windows.Media.Playback.MediaPlaybackCommandManagerPlayReceivedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(20)
    def remove_PlayReceived(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(21)
    def add_PauseReceived(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackCommandManager, win32more.Windows.Media.Playback.MediaPlaybackCommandManagerPauseReceivedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(22)
    def remove_PauseReceived(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(23)
    def add_NextReceived(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackCommandManager, win32more.Windows.Media.Playback.MediaPlaybackCommandManagerNextReceivedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(24)
    def remove_NextReceived(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(25)
    def add_PreviousReceived(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackCommandManager, win32more.Windows.Media.Playback.MediaPlaybackCommandManagerPreviousReceivedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(26)
    def remove_PreviousReceived(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(27)
    def add_FastForwardReceived(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackCommandManager, win32more.Windows.Media.Playback.MediaPlaybackCommandManagerFastForwardReceivedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(28)
    def remove_FastForwardReceived(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(29)
    def add_RewindReceived(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackCommandManager, win32more.Windows.Media.Playback.MediaPlaybackCommandManagerRewindReceivedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(30)
    def remove_RewindReceived(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(31)
    def add_ShuffleReceived(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackCommandManager, win32more.Windows.Media.Playback.MediaPlaybackCommandManagerShuffleReceivedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(32)
    def remove_ShuffleReceived(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(33)
    def add_AutoRepeatModeReceived(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackCommandManager, win32more.Windows.Media.Playback.MediaPlaybackCommandManagerAutoRepeatModeReceivedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(34)
    def remove_AutoRepeatModeReceived(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(35)
    def add_PositionReceived(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackCommandManager, win32more.Windows.Media.Playback.MediaPlaybackCommandManagerPositionReceivedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(36)
    def remove_PositionReceived(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(37)
    def add_RateReceived(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackCommandManager, win32more.Windows.Media.Playback.MediaPlaybackCommandManagerRateReceivedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(38)
    def remove_RateReceived(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    AutoRepeatModeBehavior = property(get_AutoRepeatModeBehavior, None)
    FastForwardBehavior = property(get_FastForwardBehavior, None)
    IsEnabled = property(get_IsEnabled, put_IsEnabled)
    MediaPlayer = property(get_MediaPlayer, None)
    NextBehavior = property(get_NextBehavior, None)
    PauseBehavior = property(get_PauseBehavior, None)
    PlayBehavior = property(get_PlayBehavior, None)
    PositionBehavior = property(get_PositionBehavior, None)
    PreviousBehavior = property(get_PreviousBehavior, None)
    RateBehavior = property(get_RateBehavior, None)
    RewindBehavior = property(get_RewindBehavior, None)
    ShuffleBehavior = property(get_ShuffleBehavior, None)
    PlayReceived = event()
    PauseReceived = event()
    NextReceived = event()
    PreviousReceived = event()
    FastForwardReceived = event()
    RewindReceived = event()
    ShuffleReceived = event()
    AutoRepeatModeReceived = event()
    PositionReceived = event()
    RateReceived = event()
class IMediaPlaybackCommandManagerAutoRepeatModeReceivedEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlaybackCommandManagerAutoRepeatModeReceivedEventArgs'
    _iid_ = Guid('{3d6f4f23-5230-4411-a0e9-bad94c2a045c}')
    @winrt_commethod(6)
    def get_Handled(self) -> Boolean: ...
    @winrt_commethod(7)
    def put_Handled(self, value: Boolean) -> Void: ...
    @winrt_commethod(8)
    def get_AutoRepeatMode(self) -> win32more.Windows.Media.MediaPlaybackAutoRepeatMode: ...
    @winrt_commethod(9)
    def GetDeferral(self) -> win32more.Windows.Foundation.Deferral: ...
    AutoRepeatMode = property(get_AutoRepeatMode, None)
    Handled = property(get_Handled, put_Handled)
class IMediaPlaybackCommandManagerCommandBehavior(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlaybackCommandManagerCommandBehavior'
    _iid_ = Guid('{786c1e78-ce78-4a10-afd6-843fcbb90c2e}')
    @winrt_commethod(6)
    def get_CommandManager(self) -> win32more.Windows.Media.Playback.MediaPlaybackCommandManager: ...
    @winrt_commethod(7)
    def get_IsEnabled(self) -> Boolean: ...
    @winrt_commethod(8)
    def get_EnablingRule(self) -> win32more.Windows.Media.Playback.MediaCommandEnablingRule: ...
    @winrt_commethod(9)
    def put_EnablingRule(self, value: win32more.Windows.Media.Playback.MediaCommandEnablingRule) -> Void: ...
    @winrt_commethod(10)
    def add_IsEnabledChanged(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackCommandManagerCommandBehavior, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(11)
    def remove_IsEnabledChanged(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    CommandManager = property(get_CommandManager, None)
    EnablingRule = property(get_EnablingRule, put_EnablingRule)
    IsEnabled = property(get_IsEnabled, None)
    IsEnabledChanged = event()
class IMediaPlaybackCommandManagerFastForwardReceivedEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlaybackCommandManagerFastForwardReceivedEventArgs'
    _iid_ = Guid('{30f064d9-b491-4d0a-bc21-3098bd1332e9}')
    @winrt_commethod(6)
    def get_Handled(self) -> Boolean: ...
    @winrt_commethod(7)
    def put_Handled(self, value: Boolean) -> Void: ...
    @winrt_commethod(8)
    def GetDeferral(self) -> win32more.Windows.Foundation.Deferral: ...
    Handled = property(get_Handled, put_Handled)
class IMediaPlaybackCommandManagerNextReceivedEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlaybackCommandManagerNextReceivedEventArgs'
    _iid_ = Guid('{e1504433-a2b0-45d4-b9de-5f42ac14a839}')
    @winrt_commethod(6)
    def get_Handled(self) -> Boolean: ...
    @winrt_commethod(7)
    def put_Handled(self, value: Boolean) -> Void: ...
    @winrt_commethod(8)
    def GetDeferral(self) -> win32more.Windows.Foundation.Deferral: ...
    Handled = property(get_Handled, put_Handled)
class IMediaPlaybackCommandManagerPauseReceivedEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlaybackCommandManagerPauseReceivedEventArgs'
    _iid_ = Guid('{5ceccd1c-c25c-4221-b16c-c3c98ce012d6}')
    @winrt_commethod(6)
    def get_Handled(self) -> Boolean: ...
    @winrt_commethod(7)
    def put_Handled(self, value: Boolean) -> Void: ...
    @winrt_commethod(8)
    def GetDeferral(self) -> win32more.Windows.Foundation.Deferral: ...
    Handled = property(get_Handled, put_Handled)
class IMediaPlaybackCommandManagerPlayReceivedEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlaybackCommandManagerPlayReceivedEventArgs'
    _iid_ = Guid('{9af0004e-578b-4c56-a006-16159d888a48}')
    @winrt_commethod(6)
    def get_Handled(self) -> Boolean: ...
    @winrt_commethod(7)
    def put_Handled(self, value: Boolean) -> Void: ...
    @winrt_commethod(8)
    def GetDeferral(self) -> win32more.Windows.Foundation.Deferral: ...
    Handled = property(get_Handled, put_Handled)
class IMediaPlaybackCommandManagerPositionReceivedEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlaybackCommandManagerPositionReceivedEventArgs'
    _iid_ = Guid('{5591a754-d627-4bdd-a90d-86a015b24902}')
    @winrt_commethod(6)
    def get_Handled(self) -> Boolean: ...
    @winrt_commethod(7)
    def put_Handled(self, value: Boolean) -> Void: ...
    @winrt_commethod(8)
    def get_Position(self) -> win32more.Windows.Foundation.TimeSpan: ...
    @winrt_commethod(9)
    def GetDeferral(self) -> win32more.Windows.Foundation.Deferral: ...
    Handled = property(get_Handled, put_Handled)
    Position = property(get_Position, None)
class IMediaPlaybackCommandManagerPreviousReceivedEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlaybackCommandManagerPreviousReceivedEventArgs'
    _iid_ = Guid('{525e3081-4632-4f76-99b1-d771623f6287}')
    @winrt_commethod(6)
    def get_Handled(self) -> Boolean: ...
    @winrt_commethod(7)
    def put_Handled(self, value: Boolean) -> Void: ...
    @winrt_commethod(8)
    def GetDeferral(self) -> win32more.Windows.Foundation.Deferral: ...
    Handled = property(get_Handled, put_Handled)
class IMediaPlaybackCommandManagerRateReceivedEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlaybackCommandManagerRateReceivedEventArgs'
    _iid_ = Guid('{18ea3939-4a16-4169-8b05-3eb9f5ff78eb}')
    @winrt_commethod(6)
    def get_Handled(self) -> Boolean: ...
    @winrt_commethod(7)
    def put_Handled(self, value: Boolean) -> Void: ...
    @winrt_commethod(8)
    def get_PlaybackRate(self) -> Double: ...
    @winrt_commethod(9)
    def GetDeferral(self) -> win32more.Windows.Foundation.Deferral: ...
    Handled = property(get_Handled, put_Handled)
    PlaybackRate = property(get_PlaybackRate, None)
class IMediaPlaybackCommandManagerRewindReceivedEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlaybackCommandManagerRewindReceivedEventArgs'
    _iid_ = Guid('{9f085947-a3c0-425d-aaef-97ba7898b141}')
    @winrt_commethod(6)
    def get_Handled(self) -> Boolean: ...
    @winrt_commethod(7)
    def put_Handled(self, value: Boolean) -> Void: ...
    @winrt_commethod(8)
    def GetDeferral(self) -> win32more.Windows.Foundation.Deferral: ...
    Handled = property(get_Handled, put_Handled)
class IMediaPlaybackCommandManagerShuffleReceivedEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlaybackCommandManagerShuffleReceivedEventArgs'
    _iid_ = Guid('{50a05cef-63ee-4a96-b7b5-fee08b9ff90c}')
    @winrt_commethod(6)
    def get_Handled(self) -> Boolean: ...
    @winrt_commethod(7)
    def put_Handled(self, value: Boolean) -> Void: ...
    @winrt_commethod(8)
    def get_IsShuffleRequested(self) -> Boolean: ...
    @winrt_commethod(9)
    def GetDeferral(self) -> win32more.Windows.Foundation.Deferral: ...
    Handled = property(get_Handled, put_Handled)
    IsShuffleRequested = property(get_IsShuffleRequested, None)
class IMediaPlaybackItem(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlaybackItem'
    _iid_ = Guid('{047097d2-e4af-48ab-b283-6929e674ece2}')
    @winrt_commethod(6)
    def add_AudioTracksChanged(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackItem, win32more.Windows.Foundation.Collections.IVectorChangedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(7)
    def remove_AudioTracksChanged(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(8)
    def add_VideoTracksChanged(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackItem, win32more.Windows.Foundation.Collections.IVectorChangedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(9)
    def remove_VideoTracksChanged(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(10)
    def add_TimedMetadataTracksChanged(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackItem, win32more.Windows.Foundation.Collections.IVectorChangedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(11)
    def remove_TimedMetadataTracksChanged(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(12)
    def get_Source(self) -> win32more.Windows.Media.Core.MediaSource: ...
    @winrt_commethod(13)
    def get_AudioTracks(self) -> win32more.Windows.Media.Playback.MediaPlaybackAudioTrackList: ...
    @winrt_commethod(14)
    def get_VideoTracks(self) -> win32more.Windows.Media.Playback.MediaPlaybackVideoTrackList: ...
    @winrt_commethod(15)
    def get_TimedMetadataTracks(self) -> win32more.Windows.Media.Playback.MediaPlaybackTimedMetadataTrackList: ...
    AudioTracks = property(get_AudioTracks, None)
    Source = property(get_Source, None)
    TimedMetadataTracks = property(get_TimedMetadataTracks, None)
    VideoTracks = property(get_VideoTracks, None)
    AudioTracksChanged = event()
    VideoTracksChanged = event()
    TimedMetadataTracksChanged = event()
class IMediaPlaybackItem2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlaybackItem2'
    _iid_ = Guid('{d859d171-d7ef-4b81-ac1f-f40493cbb091}')
    @winrt_commethod(6)
    def get_BreakSchedule(self) -> win32more.Windows.Media.Playback.MediaBreakSchedule: ...
    @winrt_commethod(7)
    def get_StartTime(self) -> win32more.Windows.Foundation.TimeSpan: ...
    @winrt_commethod(8)
    def get_DurationLimit(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]: ...
    @winrt_commethod(9)
    def get_CanSkip(self) -> Boolean: ...
    @winrt_commethod(10)
    def put_CanSkip(self, value: Boolean) -> Void: ...
    @winrt_commethod(11)
    def GetDisplayProperties(self) -> win32more.Windows.Media.Playback.MediaItemDisplayProperties: ...
    @winrt_commethod(12)
    def ApplyDisplayProperties(self, value: win32more.Windows.Media.Playback.MediaItemDisplayProperties) -> Void: ...
    BreakSchedule = property(get_BreakSchedule, None)
    CanSkip = property(get_CanSkip, put_CanSkip)
    DurationLimit = property(get_DurationLimit, None)
    StartTime = property(get_StartTime, None)
class IMediaPlaybackItem3(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlaybackItem3'
    _iid_ = Guid('{0d328220-b80a-4d09-9ff8-f87094a1c831}')
    @winrt_commethod(6)
    def get_IsDisabledInPlaybackList(self) -> Boolean: ...
    @winrt_commethod(7)
    def put_IsDisabledInPlaybackList(self, value: Boolean) -> Void: ...
    @winrt_commethod(8)
    def get_TotalDownloadProgress(self) -> Double: ...
    @winrt_commethod(9)
    def get_AutoLoadedDisplayProperties(self) -> win32more.Windows.Media.Playback.AutoLoadedDisplayPropertyKind: ...
    @winrt_commethod(10)
    def put_AutoLoadedDisplayProperties(self, value: win32more.Windows.Media.Playback.AutoLoadedDisplayPropertyKind) -> Void: ...
    AutoLoadedDisplayProperties = property(get_AutoLoadedDisplayProperties, put_AutoLoadedDisplayProperties)
    IsDisabledInPlaybackList = property(get_IsDisabledInPlaybackList, put_IsDisabledInPlaybackList)
    TotalDownloadProgress = property(get_TotalDownloadProgress, None)
class IMediaPlaybackItemError(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlaybackItemError'
    _iid_ = Guid('{69fbef2b-dcd6-4df9-a450-dbf4c6f1c2c2}')
    @winrt_commethod(6)
    def get_ErrorCode(self) -> win32more.Windows.Media.Playback.MediaPlaybackItemErrorCode: ...
    @winrt_commethod(7)
    def get_ExtendedError(self) -> win32more.Windows.Foundation.HResult: ...
    ErrorCode = property(get_ErrorCode, None)
    ExtendedError = property(get_ExtendedError, None)
class IMediaPlaybackItemFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlaybackItemFactory'
    _iid_ = Guid('{7133fce1-1769-4ff9-a7c1-38d2c4d42360}')
    @winrt_commethod(6)
    def Create(self, source: win32more.Windows.Media.Core.MediaSource) -> win32more.Windows.Media.Playback.MediaPlaybackItem: ...
class IMediaPlaybackItemFactory2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlaybackItemFactory2'
    _iid_ = Guid('{d77cdf3a-b947-4972-b35d-adfb931a71e6}')
    @winrt_commethod(6)
    def CreateWithStartTime(self, source: win32more.Windows.Media.Core.MediaSource, startTime: win32more.Windows.Foundation.TimeSpan) -> win32more.Windows.Media.Playback.MediaPlaybackItem: ...
    @winrt_commethod(7)
    def CreateWithStartTimeAndDurationLimit(self, source: win32more.Windows.Media.Core.MediaSource, startTime: win32more.Windows.Foundation.TimeSpan, durationLimit: win32more.Windows.Foundation.TimeSpan) -> win32more.Windows.Media.Playback.MediaPlaybackItem: ...
class IMediaPlaybackItemFailedEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlaybackItemFailedEventArgs'
    _iid_ = Guid('{7703134a-e9a7-47c3-862c-c656d30683d4}')
    @winrt_commethod(6)
    def get_Item(self) -> win32more.Windows.Media.Playback.MediaPlaybackItem: ...
    @winrt_commethod(7)
    def get_Error(self) -> win32more.Windows.Media.Playback.MediaPlaybackItemError: ...
    Error = property(get_Error, None)
    Item = property(get_Item, None)
class IMediaPlaybackItemOpenedEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlaybackItemOpenedEventArgs'
    _iid_ = Guid('{cbd9bd82-3037-4fbe-ae8f-39fc39edf4ef}')
    @winrt_commethod(6)
    def get_Item(self) -> win32more.Windows.Media.Playback.MediaPlaybackItem: ...
    Item = property(get_Item, None)
class IMediaPlaybackItemStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlaybackItemStatics'
    _iid_ = Guid('{4b1be7f4-4345-403c-8a67-f5de91df4c86}')
    @winrt_commethod(6)
    def FindFromMediaSource(self, source: win32more.Windows.Media.Core.MediaSource) -> win32more.Windows.Media.Playback.MediaPlaybackItem: ...
class IMediaPlaybackList(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlaybackList'
    _iid_ = Guid('{7f77ee9c-dc42-4e26-a98d-7850df8ec925}')
    @winrt_commethod(6)
    def add_ItemFailed(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackList, win32more.Windows.Media.Playback.MediaPlaybackItemFailedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(7)
    def remove_ItemFailed(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(8)
    def add_CurrentItemChanged(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackList, win32more.Windows.Media.Playback.CurrentMediaPlaybackItemChangedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(9)
    def remove_CurrentItemChanged(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(10)
    def add_ItemOpened(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackList, win32more.Windows.Media.Playback.MediaPlaybackItemOpenedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(11)
    def remove_ItemOpened(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(12)
    def get_Items(self) -> win32more.Windows.Foundation.Collections.IObservableVector[win32more.Windows.Media.Playback.MediaPlaybackItem]: ...
    @winrt_commethod(13)
    def get_AutoRepeatEnabled(self) -> Boolean: ...
    @winrt_commethod(14)
    def put_AutoRepeatEnabled(self, value: Boolean) -> Void: ...
    @winrt_commethod(15)
    def get_ShuffleEnabled(self) -> Boolean: ...
    @winrt_commethod(16)
    def put_ShuffleEnabled(self, value: Boolean) -> Void: ...
    @winrt_commethod(17)
    def get_CurrentItem(self) -> win32more.Windows.Media.Playback.MediaPlaybackItem: ...
    @winrt_commethod(18)
    def get_CurrentItemIndex(self) -> UInt32: ...
    @winrt_commethod(19)
    def MoveNext(self) -> win32more.Windows.Media.Playback.MediaPlaybackItem: ...
    @winrt_commethod(20)
    def MovePrevious(self) -> win32more.Windows.Media.Playback.MediaPlaybackItem: ...
    @winrt_commethod(21)
    def MoveTo(self, itemIndex: UInt32) -> win32more.Windows.Media.Playback.MediaPlaybackItem: ...
    AutoRepeatEnabled = property(get_AutoRepeatEnabled, put_AutoRepeatEnabled)
    CurrentItem = property(get_CurrentItem, None)
    CurrentItemIndex = property(get_CurrentItemIndex, None)
    Items = property(get_Items, None)
    ShuffleEnabled = property(get_ShuffleEnabled, put_ShuffleEnabled)
    ItemFailed = event()
    CurrentItemChanged = event()
    ItemOpened = event()
class IMediaPlaybackList2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlaybackList2'
    _iid_ = Guid('{0e09b478-600a-4274-a14b-0b6723d0f48b}')
    @winrt_commethod(6)
    def get_MaxPrefetchTime(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]: ...
    @winrt_commethod(7)
    def put_MaxPrefetchTime(self, value: win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]) -> Void: ...
    @winrt_commethod(8)
    def get_StartingItem(self) -> win32more.Windows.Media.Playback.MediaPlaybackItem: ...
    @winrt_commethod(9)
    def put_StartingItem(self, value: win32more.Windows.Media.Playback.MediaPlaybackItem) -> Void: ...
    @winrt_commethod(10)
    def get_ShuffledItems(self) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Media.Playback.MediaPlaybackItem]: ...
    @winrt_commethod(11)
    def SetShuffledItems(self, value: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Media.Playback.MediaPlaybackItem]) -> Void: ...
    MaxPrefetchTime = property(get_MaxPrefetchTime, put_MaxPrefetchTime)
    ShuffledItems = property(get_ShuffledItems, None)
    StartingItem = property(get_StartingItem, put_StartingItem)
class IMediaPlaybackList3(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlaybackList3'
    _iid_ = Guid('{dd24bba9-bc47-4463-aa90-c18b7e5ffde1}')
    @winrt_commethod(6)
    def get_MaxPlayedItemsToKeepOpen(self) -> win32more.Windows.Foundation.IReference[UInt32]: ...
    @winrt_commethod(7)
    def put_MaxPlayedItemsToKeepOpen(self, value: win32more.Windows.Foundation.IReference[UInt32]) -> Void: ...
    MaxPlayedItemsToKeepOpen = property(get_MaxPlayedItemsToKeepOpen, put_MaxPlayedItemsToKeepOpen)
class IMediaPlaybackSession(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlaybackSession'
    _iid_ = Guid('{c32b683d-0407-41ba-8946-8b345a5a5435}')
    @winrt_commethod(6)
    def add_PlaybackStateChanged(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackSession, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(7)
    def remove_PlaybackStateChanged(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(8)
    def add_PlaybackRateChanged(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackSession, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(9)
    def remove_PlaybackRateChanged(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(10)
    def add_SeekCompleted(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackSession, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(11)
    def remove_SeekCompleted(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(12)
    def add_BufferingStarted(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackSession, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(13)
    def remove_BufferingStarted(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(14)
    def add_BufferingEnded(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackSession, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(15)
    def remove_BufferingEnded(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(16)
    def add_BufferingProgressChanged(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackSession, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(17)
    def remove_BufferingProgressChanged(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(18)
    def add_DownloadProgressChanged(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackSession, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(19)
    def remove_DownloadProgressChanged(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(20)
    def add_NaturalDurationChanged(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackSession, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(21)
    def remove_NaturalDurationChanged(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(22)
    def add_PositionChanged(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackSession, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(23)
    def remove_PositionChanged(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(24)
    def add_NaturalVideoSizeChanged(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackSession, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(25)
    def remove_NaturalVideoSizeChanged(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(26)
    def get_MediaPlayer(self) -> win32more.Windows.Media.Playback.MediaPlayer: ...
    @winrt_commethod(27)
    def get_NaturalDuration(self) -> win32more.Windows.Foundation.TimeSpan: ...
    @winrt_commethod(28)
    def get_Position(self) -> win32more.Windows.Foundation.TimeSpan: ...
    @winrt_commethod(29)
    def put_Position(self, value: win32more.Windows.Foundation.TimeSpan) -> Void: ...
    @winrt_commethod(30)
    def get_PlaybackState(self) -> win32more.Windows.Media.Playback.MediaPlaybackState: ...
    @winrt_commethod(31)
    def get_CanSeek(self) -> Boolean: ...
    @winrt_commethod(32)
    def get_CanPause(self) -> Boolean: ...
    @winrt_commethod(33)
    def get_IsProtected(self) -> Boolean: ...
    @winrt_commethod(34)
    def get_PlaybackRate(self) -> Double: ...
    @winrt_commethod(35)
    def put_PlaybackRate(self, value: Double) -> Void: ...
    @winrt_commethod(36)
    def get_BufferingProgress(self) -> Double: ...
    @winrt_commethod(37)
    def get_DownloadProgress(self) -> Double: ...
    @winrt_commethod(38)
    def get_NaturalVideoHeight(self) -> UInt32: ...
    @winrt_commethod(39)
    def get_NaturalVideoWidth(self) -> UInt32: ...
    @winrt_commethod(40)
    def get_NormalizedSourceRect(self) -> win32more.Windows.Foundation.Rect: ...
    @winrt_commethod(41)
    def put_NormalizedSourceRect(self, value: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_commethod(42)
    def get_StereoscopicVideoPackingMode(self) -> win32more.Windows.Media.MediaProperties.StereoscopicVideoPackingMode: ...
    @winrt_commethod(43)
    def put_StereoscopicVideoPackingMode(self, value: win32more.Windows.Media.MediaProperties.StereoscopicVideoPackingMode) -> Void: ...
    BufferingProgress = property(get_BufferingProgress, None)
    CanPause = property(get_CanPause, None)
    CanSeek = property(get_CanSeek, None)
    DownloadProgress = property(get_DownloadProgress, None)
    IsProtected = property(get_IsProtected, None)
    MediaPlayer = property(get_MediaPlayer, None)
    NaturalDuration = property(get_NaturalDuration, None)
    NaturalVideoHeight = property(get_NaturalVideoHeight, None)
    NaturalVideoWidth = property(get_NaturalVideoWidth, None)
    NormalizedSourceRect = property(get_NormalizedSourceRect, put_NormalizedSourceRect)
    PlaybackRate = property(get_PlaybackRate, put_PlaybackRate)
    PlaybackState = property(get_PlaybackState, None)
    Position = property(get_Position, put_Position)
    StereoscopicVideoPackingMode = property(get_StereoscopicVideoPackingMode, put_StereoscopicVideoPackingMode)
    PlaybackStateChanged = event()
    PlaybackRateChanged = event()
    SeekCompleted = event()
    BufferingStarted = event()
    BufferingEnded = event()
    BufferingProgressChanged = event()
    DownloadProgressChanged = event()
    NaturalDurationChanged = event()
    PositionChanged = event()
    NaturalVideoSizeChanged = event()
class IMediaPlaybackSession2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlaybackSession2'
    _iid_ = Guid('{f8ba7c79-1fc8-4097-ad70-c0fa18cc0050}')
    @winrt_commethod(6)
    def add_BufferedRangesChanged(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackSession, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(7)
    def remove_BufferedRangesChanged(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(8)
    def add_PlayedRangesChanged(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackSession, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(9)
    def remove_PlayedRangesChanged(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(10)
    def add_SeekableRangesChanged(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackSession, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(11)
    def remove_SeekableRangesChanged(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(12)
    def add_SupportedPlaybackRatesChanged(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackSession, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(13)
    def remove_SupportedPlaybackRatesChanged(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(14)
    def get_SphericalVideoProjection(self) -> win32more.Windows.Media.Playback.MediaPlaybackSphericalVideoProjection: ...
    @winrt_commethod(15)
    def get_IsMirroring(self) -> Boolean: ...
    @winrt_commethod(16)
    def put_IsMirroring(self, value: Boolean) -> Void: ...
    @winrt_commethod(17)
    def GetBufferedRanges(self) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Media.MediaTimeRange]: ...
    @winrt_commethod(18)
    def GetPlayedRanges(self) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Media.MediaTimeRange]: ...
    @winrt_commethod(19)
    def GetSeekableRanges(self) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Media.MediaTimeRange]: ...
    @winrt_commethod(20)
    def IsSupportedPlaybackRateRange(self, rate1: Double, rate2: Double) -> Boolean: ...
    IsMirroring = property(get_IsMirroring, put_IsMirroring)
    SphericalVideoProjection = property(get_SphericalVideoProjection, None)
    BufferedRangesChanged = event()
    PlayedRangesChanged = event()
    SeekableRangesChanged = event()
    SupportedPlaybackRatesChanged = event()
class IMediaPlaybackSession3(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlaybackSession3'
    _iid_ = Guid('{7ba2b41a-a3e2-405f-b77b-a4812c238b66}')
    @winrt_commethod(6)
    def get_PlaybackRotation(self) -> win32more.Windows.Media.MediaProperties.MediaRotation: ...
    @winrt_commethod(7)
    def put_PlaybackRotation(self, value: win32more.Windows.Media.MediaProperties.MediaRotation) -> Void: ...
    @winrt_commethod(8)
    def GetOutputDegradationPolicyState(self) -> win32more.Windows.Media.Playback.MediaPlaybackSessionOutputDegradationPolicyState: ...
    PlaybackRotation = property(get_PlaybackRotation, put_PlaybackRotation)
class IMediaPlaybackSessionBufferingStartedEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlaybackSessionBufferingStartedEventArgs'
    _iid_ = Guid('{cd6aafed-74e2-43b5-b115-76236c33791a}')
    @winrt_commethod(6)
    def get_IsPlaybackInterruption(self) -> Boolean: ...
    IsPlaybackInterruption = property(get_IsPlaybackInterruption, None)
class IMediaPlaybackSessionOutputDegradationPolicyState(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlaybackSessionOutputDegradationPolicyState'
    _iid_ = Guid('{558e727d-f633-49f9-965a-abaa1db709be}')
    @winrt_commethod(6)
    def get_VideoConstrictionReason(self) -> win32more.Windows.Media.Playback.MediaPlaybackSessionVideoConstrictionReason: ...
    VideoConstrictionReason = property(get_VideoConstrictionReason, None)
class IMediaPlaybackSource(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlaybackSource'
    _iid_ = Guid('{ef9dc2bc-9317-4696-b051-2bad643177b5}')
class IMediaPlaybackSphericalVideoProjection(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlaybackSphericalVideoProjection'
    _iid_ = Guid('{d405b37c-6f0e-4661-b8ee-d487ba9752d5}')
    @winrt_commethod(6)
    def get_IsEnabled(self) -> Boolean: ...
    @winrt_commethod(7)
    def put_IsEnabled(self, value: Boolean) -> Void: ...
    @winrt_commethod(8)
    def get_FrameFormat(self) -> win32more.Windows.Media.MediaProperties.SphericalVideoFrameFormat: ...
    @winrt_commethod(9)
    def put_FrameFormat(self, value: win32more.Windows.Media.MediaProperties.SphericalVideoFrameFormat) -> Void: ...
    @winrt_commethod(10)
    def get_HorizontalFieldOfViewInDegrees(self) -> Double: ...
    @winrt_commethod(11)
    def put_HorizontalFieldOfViewInDegrees(self, value: Double) -> Void: ...
    @winrt_commethod(12)
    def get_ViewOrientation(self) -> win32more.Windows.Foundation.Numerics.Quaternion: ...
    @winrt_commethod(13)
    def put_ViewOrientation(self, value: win32more.Windows.Foundation.Numerics.Quaternion) -> Void: ...
    @winrt_commethod(14)
    def get_ProjectionMode(self) -> win32more.Windows.Media.Playback.SphericalVideoProjectionMode: ...
    @winrt_commethod(15)
    def put_ProjectionMode(self, value: win32more.Windows.Media.Playback.SphericalVideoProjectionMode) -> Void: ...
    FrameFormat = property(get_FrameFormat, put_FrameFormat)
    HorizontalFieldOfViewInDegrees = property(get_HorizontalFieldOfViewInDegrees, put_HorizontalFieldOfViewInDegrees)
    IsEnabled = property(get_IsEnabled, put_IsEnabled)
    ProjectionMode = property(get_ProjectionMode, put_ProjectionMode)
    ViewOrientation = property(get_ViewOrientation, put_ViewOrientation)
class IMediaPlaybackTimedMetadataTrackList(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlaybackTimedMetadataTrackList'
    _iid_ = Guid('{72b41319-bbfb-46a3-9372-9c9c744b9438}')
    @winrt_commethod(6)
    def add_PresentationModeChanged(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackTimedMetadataTrackList, win32more.Windows.Media.Playback.TimedMetadataPresentationModeChangedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(7)
    def remove_PresentationModeChanged(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(8)
    def GetPresentationMode(self, index: UInt32) -> win32more.Windows.Media.Playback.TimedMetadataTrackPresentationMode: ...
    @winrt_commethod(9)
    def SetPresentationMode(self, index: UInt32, value: win32more.Windows.Media.Playback.TimedMetadataTrackPresentationMode) -> Void: ...
    PresentationModeChanged = event()
class IMediaPlayer(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlayer'
    _iid_ = Guid('{381a83cb-6fff-499b-8d64-2885dfc1249e}')
    @winrt_commethod(6)
    def get_AutoPlay(self) -> Boolean: ...
    @winrt_commethod(7)
    def put_AutoPlay(self, value: Boolean) -> Void: ...
    @winrt_commethod(8)
    def get_NaturalDuration(self) -> win32more.Windows.Foundation.TimeSpan: ...
    @winrt_commethod(9)
    def get_Position(self) -> win32more.Windows.Foundation.TimeSpan: ...
    @winrt_commethod(10)
    def put_Position(self, value: win32more.Windows.Foundation.TimeSpan) -> Void: ...
    @winrt_commethod(11)
    def get_BufferingProgress(self) -> Double: ...
    @winrt_commethod(12)
    def get_CurrentState(self) -> win32more.Windows.Media.Playback.MediaPlayerState: ...
    @winrt_commethod(13)
    def get_CanSeek(self) -> Boolean: ...
    @winrt_commethod(14)
    def get_CanPause(self) -> Boolean: ...
    @winrt_commethod(15)
    def get_IsLoopingEnabled(self) -> Boolean: ...
    @winrt_commethod(16)
    def put_IsLoopingEnabled(self, value: Boolean) -> Void: ...
    @winrt_commethod(17)
    def get_IsProtected(self) -> Boolean: ...
    @winrt_commethod(18)
    def get_IsMuted(self) -> Boolean: ...
    @winrt_commethod(19)
    def put_IsMuted(self, value: Boolean) -> Void: ...
    @winrt_commethod(20)
    def get_PlaybackRate(self) -> Double: ...
    @winrt_commethod(21)
    def put_PlaybackRate(self, value: Double) -> Void: ...
    @winrt_commethod(22)
    def get_Volume(self) -> Double: ...
    @winrt_commethod(23)
    def put_Volume(self, value: Double) -> Void: ...
    @winrt_commethod(24)
    def get_PlaybackMediaMarkers(self) -> win32more.Windows.Media.Playback.PlaybackMediaMarkerSequence: ...
    @winrt_commethod(25)
    def add_MediaOpened(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlayer, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(26)
    def remove_MediaOpened(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(27)
    def add_MediaEnded(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlayer, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(28)
    def remove_MediaEnded(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(29)
    def add_MediaFailed(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlayer, win32more.Windows.Media.Playback.MediaPlayerFailedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(30)
    def remove_MediaFailed(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(31)
    def add_CurrentStateChanged(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlayer, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(32)
    def remove_CurrentStateChanged(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(33)
    def add_PlaybackMediaMarkerReached(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlayer, win32more.Windows.Media.Playback.PlaybackMediaMarkerReachedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(34)
    def remove_PlaybackMediaMarkerReached(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(35)
    def add_MediaPlayerRateChanged(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlayer, win32more.Windows.Media.Playback.MediaPlayerRateChangedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(36)
    def remove_MediaPlayerRateChanged(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(37)
    def add_VolumeChanged(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlayer, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(38)
    def remove_VolumeChanged(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(39)
    def add_SeekCompleted(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlayer, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(40)
    def remove_SeekCompleted(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(41)
    def add_BufferingStarted(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlayer, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(42)
    def remove_BufferingStarted(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(43)
    def add_BufferingEnded(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlayer, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(44)
    def remove_BufferingEnded(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(45)
    def Play(self) -> Void: ...
    @winrt_commethod(46)
    def Pause(self) -> Void: ...
    @winrt_commethod(47)
    def SetUriSource(self, value: win32more.Windows.Foundation.Uri) -> Void: ...
    AutoPlay = property(get_AutoPlay, put_AutoPlay)
    BufferingProgress = property(get_BufferingProgress, None)
    CanPause = property(get_CanPause, None)
    CanSeek = property(get_CanSeek, None)
    CurrentState = property(get_CurrentState, None)
    IsLoopingEnabled = property(get_IsLoopingEnabled, put_IsLoopingEnabled)
    IsMuted = property(get_IsMuted, put_IsMuted)
    IsProtected = property(get_IsProtected, None)
    NaturalDuration = property(get_NaturalDuration, None)
    PlaybackMediaMarkers = property(get_PlaybackMediaMarkers, None)
    PlaybackRate = property(get_PlaybackRate, put_PlaybackRate)
    Position = property(get_Position, put_Position)
    Volume = property(get_Volume, put_Volume)
    MediaOpened = event()
    MediaEnded = event()
    MediaFailed = event()
    CurrentStateChanged = event()
    PlaybackMediaMarkerReached = event()
    MediaPlayerRateChanged = event()
    VolumeChanged = event()
    SeekCompleted = event()
    BufferingStarted = event()
    BufferingEnded = event()
class IMediaPlayer2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlayer2'
    _iid_ = Guid('{3c841218-2123-4fc5-9082-2f883f77bdf5}')
    @winrt_commethod(6)
    def get_SystemMediaTransportControls(self) -> win32more.Windows.Media.SystemMediaTransportControls: ...
    @winrt_commethod(7)
    def get_AudioCategory(self) -> win32more.Windows.Media.Playback.MediaPlayerAudioCategory: ...
    @winrt_commethod(8)
    def put_AudioCategory(self, value: win32more.Windows.Media.Playback.MediaPlayerAudioCategory) -> Void: ...
    @winrt_commethod(9)
    def get_AudioDeviceType(self) -> win32more.Windows.Media.Playback.MediaPlayerAudioDeviceType: ...
    @winrt_commethod(10)
    def put_AudioDeviceType(self, value: win32more.Windows.Media.Playback.MediaPlayerAudioDeviceType) -> Void: ...
    AudioCategory = property(get_AudioCategory, put_AudioCategory)
    AudioDeviceType = property(get_AudioDeviceType, put_AudioDeviceType)
    SystemMediaTransportControls = property(get_SystemMediaTransportControls, None)
class IMediaPlayer3(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlayer3'
    _iid_ = Guid('{ee0660da-031b-4feb-bd9b-92e0a0a8d299}')
    @winrt_commethod(6)
    def add_IsMutedChanged(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlayer, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(7)
    def remove_IsMutedChanged(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(8)
    def add_SourceChanged(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlayer, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(9)
    def remove_SourceChanged(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(10)
    def get_AudioBalance(self) -> Double: ...
    @winrt_commethod(11)
    def put_AudioBalance(self, value: Double) -> Void: ...
    @winrt_commethod(12)
    def get_RealTimePlayback(self) -> Boolean: ...
    @winrt_commethod(13)
    def put_RealTimePlayback(self, value: Boolean) -> Void: ...
    @winrt_commethod(14)
    def get_StereoscopicVideoRenderMode(self) -> win32more.Windows.Media.Playback.StereoscopicVideoRenderMode: ...
    @winrt_commethod(15)
    def put_StereoscopicVideoRenderMode(self, value: win32more.Windows.Media.Playback.StereoscopicVideoRenderMode) -> Void: ...
    @winrt_commethod(16)
    def get_BreakManager(self) -> win32more.Windows.Media.Playback.MediaBreakManager: ...
    @winrt_commethod(17)
    def get_CommandManager(self) -> win32more.Windows.Media.Playback.MediaPlaybackCommandManager: ...
    @winrt_commethod(18)
    def get_AudioDevice(self) -> win32more.Windows.Devices.Enumeration.DeviceInformation: ...
    @winrt_commethod(19)
    def put_AudioDevice(self, value: win32more.Windows.Devices.Enumeration.DeviceInformation) -> Void: ...
    @winrt_commethod(20)
    def get_TimelineController(self) -> win32more.Windows.Media.MediaTimelineController: ...
    @winrt_commethod(21)
    def put_TimelineController(self, value: win32more.Windows.Media.MediaTimelineController) -> Void: ...
    @winrt_commethod(22)
    def get_TimelineControllerPositionOffset(self) -> win32more.Windows.Foundation.TimeSpan: ...
    @winrt_commethod(23)
    def put_TimelineControllerPositionOffset(self, value: win32more.Windows.Foundation.TimeSpan) -> Void: ...
    @winrt_commethod(24)
    def get_PlaybackSession(self) -> win32more.Windows.Media.Playback.MediaPlaybackSession: ...
    @winrt_commethod(25)
    def StepForwardOneFrame(self) -> Void: ...
    @winrt_commethod(26)
    def StepBackwardOneFrame(self) -> Void: ...
    @winrt_commethod(27)
    def GetAsCastingSource(self) -> win32more.Windows.Media.Casting.CastingSource: ...
    AudioBalance = property(get_AudioBalance, put_AudioBalance)
    AudioDevice = property(get_AudioDevice, put_AudioDevice)
    BreakManager = property(get_BreakManager, None)
    CommandManager = property(get_CommandManager, None)
    PlaybackSession = property(get_PlaybackSession, None)
    RealTimePlayback = property(get_RealTimePlayback, put_RealTimePlayback)
    StereoscopicVideoRenderMode = property(get_StereoscopicVideoRenderMode, put_StereoscopicVideoRenderMode)
    TimelineController = property(get_TimelineController, put_TimelineController)
    TimelineControllerPositionOffset = property(get_TimelineControllerPositionOffset, put_TimelineControllerPositionOffset)
    IsMutedChanged = event()
    SourceChanged = event()
class IMediaPlayer4(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlayer4'
    _iid_ = Guid('{80035db0-7448-4770-afcf-2a57450914c5}')
    @winrt_commethod(6)
    def SetSurfaceSize(self, size: win32more.Windows.Foundation.Size) -> Void: ...
    @winrt_commethod(7)
    def GetSurface(self, compositor: win32more.Windows.UI.Composition.Compositor) -> win32more.Windows.Media.Playback.MediaPlayerSurface: ...
class IMediaPlayer5(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlayer5'
    _iid_ = Guid('{cfe537fd-f86a-4446-bf4d-c8e792b7b4b3}')
    @winrt_commethod(6)
    def add_VideoFrameAvailable(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlayer, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(7)
    def remove_VideoFrameAvailable(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(8)
    def get_IsVideoFrameServerEnabled(self) -> Boolean: ...
    @winrt_commethod(9)
    def put_IsVideoFrameServerEnabled(self, value: Boolean) -> Void: ...
    @winrt_commethod(10)
    def CopyFrameToVideoSurface(self, destination: win32more.Windows.Graphics.DirectX.Direct3D11.IDirect3DSurface) -> Void: ...
    @winrt_commethod(11)
    def CopyFrameToVideoSurfaceWithTargetRectangle(self, destination: win32more.Windows.Graphics.DirectX.Direct3D11.IDirect3DSurface, targetRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_commethod(12)
    def CopyFrameToStereoscopicVideoSurfaces(self, destinationLeftEye: win32more.Windows.Graphics.DirectX.Direct3D11.IDirect3DSurface, destinationRightEye: win32more.Windows.Graphics.DirectX.Direct3D11.IDirect3DSurface) -> Void: ...
    IsVideoFrameServerEnabled = property(get_IsVideoFrameServerEnabled, put_IsVideoFrameServerEnabled)
    VideoFrameAvailable = event()
class IMediaPlayer6(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlayer6'
    _iid_ = Guid('{e0caa086-ae65-414c-b010-8bc55f00e692}')
    @winrt_commethod(6)
    def add_SubtitleFrameChanged(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlayer, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(7)
    def remove_SubtitleFrameChanged(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(8)
    def RenderSubtitlesToSurface(self, destination: win32more.Windows.Graphics.DirectX.Direct3D11.IDirect3DSurface) -> Boolean: ...
    @winrt_commethod(9)
    def RenderSubtitlesToSurfaceWithTargetRectangle(self, destination: win32more.Windows.Graphics.DirectX.Direct3D11.IDirect3DSurface, targetRectangle: win32more.Windows.Foundation.Rect) -> Boolean: ...
    SubtitleFrameChanged = event()
class IMediaPlayer7(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlayer7'
    _iid_ = Guid('{5d1dc478-4500-4531-b3f4-777a71491f7f}')
    @winrt_commethod(6)
    def get_AudioStateMonitor(self) -> win32more.Windows.Media.Audio.AudioStateMonitor: ...
    AudioStateMonitor = property(get_AudioStateMonitor, None)
class IMediaPlayerDataReceivedEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlayerDataReceivedEventArgs'
    _iid_ = Guid('{c75a9405-c801-412a-835b-83fc0e622a8e}')
    @winrt_commethod(6)
    def get_Data(self) -> win32more.Windows.Foundation.Collections.ValueSet: ...
    Data = property(get_Data, None)
class IMediaPlayerEffects(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlayerEffects'
    _iid_ = Guid('{85a1deda-cab6-4cc0-8be3-6035f4de2591}')
    @winrt_commethod(6)
    def AddAudioEffect(self, activatableClassId: WinRT_String, effectOptional: Boolean, configuration: win32more.Windows.Foundation.Collections.IPropertySet) -> Void: ...
    @winrt_commethod(7)
    def RemoveAllEffects(self) -> Void: ...
class IMediaPlayerEffects2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlayerEffects2'
    _iid_ = Guid('{fa419a79-1bbe-46c5-ae1f-8ee69fb3c2c7}')
    @winrt_commethod(6)
    def AddVideoEffect(self, activatableClassId: WinRT_String, effectOptional: Boolean, effectConfiguration: win32more.Windows.Foundation.Collections.IPropertySet) -> Void: ...
class IMediaPlayerFailedEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlayerFailedEventArgs'
    _iid_ = Guid('{2744e9b9-a7e3-4f16-bac4-7914ebc08301}')
    @winrt_commethod(6)
    def get_Error(self) -> win32more.Windows.Media.Playback.MediaPlayerError: ...
    @winrt_commethod(7)
    def get_ExtendedErrorCode(self) -> win32more.Windows.Foundation.HResult: ...
    @winrt_commethod(8)
    def get_ErrorMessage(self) -> WinRT_String: ...
    Error = property(get_Error, None)
    ErrorMessage = property(get_ErrorMessage, None)
    ExtendedErrorCode = property(get_ExtendedErrorCode, None)
class IMediaPlayerRateChangedEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlayerRateChangedEventArgs'
    _iid_ = Guid('{40600d58-3b61-4bb2-989f-fc65608b6cab}')
    @winrt_commethod(6)
    def get_NewRate(self) -> Double: ...
    NewRate = property(get_NewRate, None)
class IMediaPlayerSource(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlayerSource'
    _iid_ = Guid('{bd4f8897-1423-4c3e-82c5-0fb1af94f715}')
    @winrt_commethod(6)
    def get_ProtectionManager(self) -> win32more.Windows.Media.Protection.MediaProtectionManager: ...
    @winrt_commethod(7)
    def put_ProtectionManager(self, value: win32more.Windows.Media.Protection.MediaProtectionManager) -> Void: ...
    @winrt_commethod(8)
    def SetFileSource(self, file: win32more.Windows.Storage.IStorageFile) -> Void: ...
    @winrt_commethod(9)
    def SetStreamSource(self, stream: win32more.Windows.Storage.Streams.IRandomAccessStream) -> Void: ...
    @winrt_commethod(10)
    def SetMediaSource(self, source: win32more.Windows.Media.Core.IMediaSource) -> Void: ...
    ProtectionManager = property(get_ProtectionManager, put_ProtectionManager)
class IMediaPlayerSource2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlayerSource2'
    _iid_ = Guid('{82449b9f-7322-4c0b-b03b-3e69a48260c5}')
    @winrt_commethod(6)
    def get_Source(self) -> win32more.Windows.Media.Playback.IMediaPlaybackSource: ...
    @winrt_commethod(7)
    def put_Source(self, value: win32more.Windows.Media.Playback.IMediaPlaybackSource) -> Void: ...
    Source = property(get_Source, put_Source)
class IMediaPlayerSurface(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IMediaPlayerSurface'
    _iid_ = Guid('{0ed653bc-b736-49c3-830b-764a3845313a}')
    @winrt_commethod(6)
    def get_CompositionSurface(self) -> win32more.Windows.UI.Composition.ICompositionSurface: ...
    @winrt_commethod(7)
    def get_Compositor(self) -> win32more.Windows.UI.Composition.Compositor: ...
    @winrt_commethod(8)
    def get_MediaPlayer(self) -> win32more.Windows.Media.Playback.MediaPlayer: ...
    CompositionSurface = property(get_CompositionSurface, None)
    Compositor = property(get_Compositor, None)
    MediaPlayer = property(get_MediaPlayer, None)
class IPlaybackMediaMarker(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IPlaybackMediaMarker'
    _iid_ = Guid('{c4d22f5c-3c1c-4444-b6b9-778b0422d41a}')
    @winrt_commethod(6)
    def get_Time(self) -> win32more.Windows.Foundation.TimeSpan: ...
    @winrt_commethod(7)
    def get_MediaMarkerType(self) -> WinRT_String: ...
    @winrt_commethod(8)
    def get_Text(self) -> WinRT_String: ...
    MediaMarkerType = property(get_MediaMarkerType, None)
    Text = property(get_Text, None)
    Time = property(get_Time, None)
class IPlaybackMediaMarkerFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IPlaybackMediaMarkerFactory'
    _iid_ = Guid('{8c530a78-e0ae-4e1a-a8c8-e23f982a937b}')
    @winrt_commethod(6)
    def CreateFromTime(self, value: win32more.Windows.Foundation.TimeSpan) -> win32more.Windows.Media.Playback.PlaybackMediaMarker: ...
    @winrt_commethod(7)
    def Create(self, value: win32more.Windows.Foundation.TimeSpan, mediaMarketType: WinRT_String, text: WinRT_String) -> win32more.Windows.Media.Playback.PlaybackMediaMarker: ...
class IPlaybackMediaMarkerReachedEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.IPlaybackMediaMarkerReachedEventArgs'
    _iid_ = Guid('{578cd1b9-90e2-4e60-abc4-8740b01f6196}')
    @winrt_commethod(6)
    def get_PlaybackMediaMarker(self) -> win32more.Windows.Media.Playback.PlaybackMediaMarker: ...
    PlaybackMediaMarker = property(get_PlaybackMediaMarker, None)
class IPlaybackMediaMarkerSequence(ComPtr):
    extends: IInspectable
    implements: Tuple[IterableProtocol[win32more.Windows.Media.Playback.PlaybackMediaMarker]]
    _classid_ = 'Windows.Media.Playback.IPlaybackMediaMarkerSequence'
    _iid_ = Guid('{f2810cee-638b-46cf-8817-1d111fe9d8c4}')
    @winrt_commethod(6)
    def get_Size(self) -> UInt32: ...
    @winrt_commethod(7)
    def Insert(self, value: win32more.Windows.Media.Playback.PlaybackMediaMarker) -> Void: ...
    @winrt_commethod(8)
    def Clear(self) -> Void: ...
    Size = property(get_Size, None)
class ITimedMetadataPresentationModeChangedEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Media.Playback.ITimedMetadataPresentationModeChangedEventArgs'
    _iid_ = Guid('{d1636099-65df-45ae-8cef-dc0b53fdc2bb}')
    @winrt_commethod(6)
    def get_Track(self) -> win32more.Windows.Media.Core.TimedMetadataTrack: ...
    @winrt_commethod(7)
    def get_OldPresentationMode(self) -> win32more.Windows.Media.Playback.TimedMetadataTrackPresentationMode: ...
    @winrt_commethod(8)
    def get_NewPresentationMode(self) -> win32more.Windows.Media.Playback.TimedMetadataTrackPresentationMode: ...
    NewPresentationMode = property(get_NewPresentationMode, None)
    OldPresentationMode = property(get_OldPresentationMode, None)
    Track = property(get_Track, None)
class MediaBreak(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IMediaBreak
    _classid_ = 'Windows.Media.Playback.MediaBreak'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Media.Playback.MediaBreak.Create(*args))
        elif len(args) == 2:
            super().__init__(move=win32more.Windows.Media.Playback.MediaBreak.CreateWithPresentationPosition(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def Create(cls: win32more.Windows.Media.Playback.IMediaBreakFactory, insertionMethod: win32more.Windows.Media.Playback.MediaBreakInsertionMethod) -> win32more.Windows.Media.Playback.MediaBreak: ...
    @winrt_factorymethod
    def CreateWithPresentationPosition(cls: win32more.Windows.Media.Playback.IMediaBreakFactory, insertionMethod: win32more.Windows.Media.Playback.MediaBreakInsertionMethod, presentationPosition: win32more.Windows.Foundation.TimeSpan) -> win32more.Windows.Media.Playback.MediaBreak: ...
    @winrt_mixinmethod
    def get_PlaybackList(self: win32more.Windows.Media.Playback.IMediaBreak) -> win32more.Windows.Media.Playback.MediaPlaybackList: ...
    @winrt_mixinmethod
    def get_PresentationPosition(self: win32more.Windows.Media.Playback.IMediaBreak) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]: ...
    @winrt_mixinmethod
    def get_InsertionMethod(self: win32more.Windows.Media.Playback.IMediaBreak) -> win32more.Windows.Media.Playback.MediaBreakInsertionMethod: ...
    @winrt_mixinmethod
    def get_CustomProperties(self: win32more.Windows.Media.Playback.IMediaBreak) -> win32more.Windows.Foundation.Collections.ValueSet: ...
    @winrt_mixinmethod
    def get_CanStart(self: win32more.Windows.Media.Playback.IMediaBreak) -> Boolean: ...
    @winrt_mixinmethod
    def put_CanStart(self: win32more.Windows.Media.Playback.IMediaBreak, value: Boolean) -> Void: ...
    CanStart = property(get_CanStart, put_CanStart)
    CustomProperties = property(get_CustomProperties, None)
    InsertionMethod = property(get_InsertionMethod, None)
    PlaybackList = property(get_PlaybackList, None)
    PresentationPosition = property(get_PresentationPosition, None)
class MediaBreakEndedEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IMediaBreakEndedEventArgs
    _classid_ = 'Windows.Media.Playback.MediaBreakEndedEventArgs'
    @winrt_mixinmethod
    def get_MediaBreak(self: win32more.Windows.Media.Playback.IMediaBreakEndedEventArgs) -> win32more.Windows.Media.Playback.MediaBreak: ...
    MediaBreak = property(get_MediaBreak, None)
class MediaBreakInsertionMethod(Enum, Int32):
    Interrupt = 0
    Replace = 1
class MediaBreakManager(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IMediaBreakManager
    _classid_ = 'Windows.Media.Playback.MediaBreakManager'
    @winrt_mixinmethod
    def add_BreaksSeekedOver(self: win32more.Windows.Media.Playback.IMediaBreakManager, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaBreakManager, win32more.Windows.Media.Playback.MediaBreakSeekedOverEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_BreaksSeekedOver(self: win32more.Windows.Media.Playback.IMediaBreakManager, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_BreakStarted(self: win32more.Windows.Media.Playback.IMediaBreakManager, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaBreakManager, win32more.Windows.Media.Playback.MediaBreakStartedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_BreakStarted(self: win32more.Windows.Media.Playback.IMediaBreakManager, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_BreakEnded(self: win32more.Windows.Media.Playback.IMediaBreakManager, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaBreakManager, win32more.Windows.Media.Playback.MediaBreakEndedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_BreakEnded(self: win32more.Windows.Media.Playback.IMediaBreakManager, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_BreakSkipped(self: win32more.Windows.Media.Playback.IMediaBreakManager, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaBreakManager, win32more.Windows.Media.Playback.MediaBreakSkippedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_BreakSkipped(self: win32more.Windows.Media.Playback.IMediaBreakManager, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def get_CurrentBreak(self: win32more.Windows.Media.Playback.IMediaBreakManager) -> win32more.Windows.Media.Playback.MediaBreak: ...
    @winrt_mixinmethod
    def get_PlaybackSession(self: win32more.Windows.Media.Playback.IMediaBreakManager) -> win32more.Windows.Media.Playback.MediaPlaybackSession: ...
    @winrt_mixinmethod
    def PlayBreak(self: win32more.Windows.Media.Playback.IMediaBreakManager, value: win32more.Windows.Media.Playback.MediaBreak) -> Void: ...
    @winrt_mixinmethod
    def SkipCurrentBreak(self: win32more.Windows.Media.Playback.IMediaBreakManager) -> Void: ...
    CurrentBreak = property(get_CurrentBreak, None)
    PlaybackSession = property(get_PlaybackSession, None)
    BreaksSeekedOver = event()
    BreakStarted = event()
    BreakEnded = event()
    BreakSkipped = event()
class MediaBreakSchedule(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IMediaBreakSchedule
    _classid_ = 'Windows.Media.Playback.MediaBreakSchedule'
    @winrt_mixinmethod
    def add_ScheduleChanged(self: win32more.Windows.Media.Playback.IMediaBreakSchedule, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaBreakSchedule, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_ScheduleChanged(self: win32more.Windows.Media.Playback.IMediaBreakSchedule, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def InsertMidrollBreak(self: win32more.Windows.Media.Playback.IMediaBreakSchedule, mediaBreak: win32more.Windows.Media.Playback.MediaBreak) -> Void: ...
    @winrt_mixinmethod
    def RemoveMidrollBreak(self: win32more.Windows.Media.Playback.IMediaBreakSchedule, mediaBreak: win32more.Windows.Media.Playback.MediaBreak) -> Void: ...
    @winrt_mixinmethod
    def get_MidrollBreaks(self: win32more.Windows.Media.Playback.IMediaBreakSchedule) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Media.Playback.MediaBreak]: ...
    @winrt_mixinmethod
    def put_PrerollBreak(self: win32more.Windows.Media.Playback.IMediaBreakSchedule, value: win32more.Windows.Media.Playback.MediaBreak) -> Void: ...
    @winrt_mixinmethod
    def get_PrerollBreak(self: win32more.Windows.Media.Playback.IMediaBreakSchedule) -> win32more.Windows.Media.Playback.MediaBreak: ...
    @winrt_mixinmethod
    def put_PostrollBreak(self: win32more.Windows.Media.Playback.IMediaBreakSchedule, value: win32more.Windows.Media.Playback.MediaBreak) -> Void: ...
    @winrt_mixinmethod
    def get_PostrollBreak(self: win32more.Windows.Media.Playback.IMediaBreakSchedule) -> win32more.Windows.Media.Playback.MediaBreak: ...
    @winrt_mixinmethod
    def get_PlaybackItem(self: win32more.Windows.Media.Playback.IMediaBreakSchedule) -> win32more.Windows.Media.Playback.MediaPlaybackItem: ...
    MidrollBreaks = property(get_MidrollBreaks, None)
    PlaybackItem = property(get_PlaybackItem, None)
    PostrollBreak = property(get_PostrollBreak, put_PostrollBreak)
    PrerollBreak = property(get_PrerollBreak, put_PrerollBreak)
    ScheduleChanged = event()
class MediaBreakSeekedOverEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IMediaBreakSeekedOverEventArgs
    _classid_ = 'Windows.Media.Playback.MediaBreakSeekedOverEventArgs'
    @winrt_mixinmethod
    def get_SeekedOverBreaks(self: win32more.Windows.Media.Playback.IMediaBreakSeekedOverEventArgs) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Media.Playback.MediaBreak]: ...
    @winrt_mixinmethod
    def get_OldPosition(self: win32more.Windows.Media.Playback.IMediaBreakSeekedOverEventArgs) -> win32more.Windows.Foundation.TimeSpan: ...
    @winrt_mixinmethod
    def get_NewPosition(self: win32more.Windows.Media.Playback.IMediaBreakSeekedOverEventArgs) -> win32more.Windows.Foundation.TimeSpan: ...
    NewPosition = property(get_NewPosition, None)
    OldPosition = property(get_OldPosition, None)
    SeekedOverBreaks = property(get_SeekedOverBreaks, None)
class MediaBreakSkippedEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IMediaBreakSkippedEventArgs
    _classid_ = 'Windows.Media.Playback.MediaBreakSkippedEventArgs'
    @winrt_mixinmethod
    def get_MediaBreak(self: win32more.Windows.Media.Playback.IMediaBreakSkippedEventArgs) -> win32more.Windows.Media.Playback.MediaBreak: ...
    MediaBreak = property(get_MediaBreak, None)
class MediaBreakStartedEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IMediaBreakStartedEventArgs
    _classid_ = 'Windows.Media.Playback.MediaBreakStartedEventArgs'
    @winrt_mixinmethod
    def get_MediaBreak(self: win32more.Windows.Media.Playback.IMediaBreakStartedEventArgs) -> win32more.Windows.Media.Playback.MediaBreak: ...
    MediaBreak = property(get_MediaBreak, None)
class MediaCommandEnablingRule(Enum, Int32):
    Auto = 0
    Always = 1
    Never = 2
class MediaItemDisplayProperties(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IMediaItemDisplayProperties
    _classid_ = 'Windows.Media.Playback.MediaItemDisplayProperties'
    @winrt_mixinmethod
    def get_Type(self: win32more.Windows.Media.Playback.IMediaItemDisplayProperties) -> win32more.Windows.Media.MediaPlaybackType: ...
    @winrt_mixinmethod
    def put_Type(self: win32more.Windows.Media.Playback.IMediaItemDisplayProperties, value: win32more.Windows.Media.MediaPlaybackType) -> Void: ...
    @winrt_mixinmethod
    def get_MusicProperties(self: win32more.Windows.Media.Playback.IMediaItemDisplayProperties) -> win32more.Windows.Media.MusicDisplayProperties: ...
    @winrt_mixinmethod
    def get_VideoProperties(self: win32more.Windows.Media.Playback.IMediaItemDisplayProperties) -> win32more.Windows.Media.VideoDisplayProperties: ...
    @winrt_mixinmethod
    def get_Thumbnail(self: win32more.Windows.Media.Playback.IMediaItemDisplayProperties) -> win32more.Windows.Storage.Streams.RandomAccessStreamReference: ...
    @winrt_mixinmethod
    def put_Thumbnail(self: win32more.Windows.Media.Playback.IMediaItemDisplayProperties, value: win32more.Windows.Storage.Streams.RandomAccessStreamReference) -> Void: ...
    @winrt_mixinmethod
    def ClearAll(self: win32more.Windows.Media.Playback.IMediaItemDisplayProperties) -> Void: ...
    MusicProperties = property(get_MusicProperties, None)
    Thumbnail = property(get_Thumbnail, put_Thumbnail)
    Type = property(get_Type, put_Type)
    VideoProperties = property(get_VideoProperties, None)
class MediaPlaybackAudioTrackList(ComPtr):
    extends: IInspectable
    implements: Tuple[SequenceProtocol[win32more.Windows.Media.Core.AudioTrack]]
    default_interface: win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Media.Core.AudioTrack]
    _classid_ = 'Windows.Media.Playback.MediaPlaybackAudioTrackList'
    @winrt_mixinmethod
    def GetAt(self: win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Media.Core.AudioTrack], index: UInt32) -> win32more.Windows.Media.Core.AudioTrack: ...
    @winrt_mixinmethod
    def get_Size(self: win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Media.Core.AudioTrack]) -> UInt32: ...
    @winrt_mixinmethod
    def IndexOf(self: win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Media.Core.AudioTrack], value: win32more.Windows.Media.Core.AudioTrack, index: POINTER(UInt32)) -> Boolean: ...
    @winrt_mixinmethod
    def GetMany(self: win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Media.Core.AudioTrack], startIndex: UInt32, items: FillArray[win32more.Windows.Media.Core.AudioTrack]) -> UInt32: ...
    @winrt_mixinmethod
    def First(self: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Media.Core.AudioTrack]) -> win32more.Windows.Foundation.Collections.IIterator[win32more.Windows.Media.Core.AudioTrack]: ...
    @winrt_mixinmethod
    def add_SelectedIndexChanged(self: win32more.Windows.Media.Core.ISingleSelectMediaTrackList, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Core.ISingleSelectMediaTrackList, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_SelectedIndexChanged(self: win32more.Windows.Media.Core.ISingleSelectMediaTrackList, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def put_SelectedIndex(self: win32more.Windows.Media.Core.ISingleSelectMediaTrackList, value: Int32) -> Void: ...
    @winrt_mixinmethod
    def get_SelectedIndex(self: win32more.Windows.Media.Core.ISingleSelectMediaTrackList) -> Int32: ...
    SelectedIndex = property(get_SelectedIndex, put_SelectedIndex)
    Size = property(get_Size, None)
    SelectedIndexChanged = event()
class MediaPlaybackCommandManager(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager
    _classid_ = 'Windows.Media.Playback.MediaPlaybackCommandManager'
    @winrt_mixinmethod
    def get_IsEnabled(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager) -> Boolean: ...
    @winrt_mixinmethod
    def put_IsEnabled(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_MediaPlayer(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager) -> win32more.Windows.Media.Playback.MediaPlayer: ...
    @winrt_mixinmethod
    def get_PlayBehavior(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager) -> win32more.Windows.Media.Playback.MediaPlaybackCommandManagerCommandBehavior: ...
    @winrt_mixinmethod
    def get_PauseBehavior(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager) -> win32more.Windows.Media.Playback.MediaPlaybackCommandManagerCommandBehavior: ...
    @winrt_mixinmethod
    def get_NextBehavior(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager) -> win32more.Windows.Media.Playback.MediaPlaybackCommandManagerCommandBehavior: ...
    @winrt_mixinmethod
    def get_PreviousBehavior(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager) -> win32more.Windows.Media.Playback.MediaPlaybackCommandManagerCommandBehavior: ...
    @winrt_mixinmethod
    def get_FastForwardBehavior(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager) -> win32more.Windows.Media.Playback.MediaPlaybackCommandManagerCommandBehavior: ...
    @winrt_mixinmethod
    def get_RewindBehavior(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager) -> win32more.Windows.Media.Playback.MediaPlaybackCommandManagerCommandBehavior: ...
    @winrt_mixinmethod
    def get_ShuffleBehavior(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager) -> win32more.Windows.Media.Playback.MediaPlaybackCommandManagerCommandBehavior: ...
    @winrt_mixinmethod
    def get_AutoRepeatModeBehavior(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager) -> win32more.Windows.Media.Playback.MediaPlaybackCommandManagerCommandBehavior: ...
    @winrt_mixinmethod
    def get_PositionBehavior(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager) -> win32more.Windows.Media.Playback.MediaPlaybackCommandManagerCommandBehavior: ...
    @winrt_mixinmethod
    def get_RateBehavior(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager) -> win32more.Windows.Media.Playback.MediaPlaybackCommandManagerCommandBehavior: ...
    @winrt_mixinmethod
    def add_PlayReceived(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackCommandManager, win32more.Windows.Media.Playback.MediaPlaybackCommandManagerPlayReceivedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_PlayReceived(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_PauseReceived(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackCommandManager, win32more.Windows.Media.Playback.MediaPlaybackCommandManagerPauseReceivedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_PauseReceived(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_NextReceived(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackCommandManager, win32more.Windows.Media.Playback.MediaPlaybackCommandManagerNextReceivedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_NextReceived(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_PreviousReceived(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackCommandManager, win32more.Windows.Media.Playback.MediaPlaybackCommandManagerPreviousReceivedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_PreviousReceived(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_FastForwardReceived(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackCommandManager, win32more.Windows.Media.Playback.MediaPlaybackCommandManagerFastForwardReceivedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_FastForwardReceived(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_RewindReceived(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackCommandManager, win32more.Windows.Media.Playback.MediaPlaybackCommandManagerRewindReceivedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_RewindReceived(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_ShuffleReceived(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackCommandManager, win32more.Windows.Media.Playback.MediaPlaybackCommandManagerShuffleReceivedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_ShuffleReceived(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_AutoRepeatModeReceived(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackCommandManager, win32more.Windows.Media.Playback.MediaPlaybackCommandManagerAutoRepeatModeReceivedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_AutoRepeatModeReceived(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_PositionReceived(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackCommandManager, win32more.Windows.Media.Playback.MediaPlaybackCommandManagerPositionReceivedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_PositionReceived(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_RateReceived(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackCommandManager, win32more.Windows.Media.Playback.MediaPlaybackCommandManagerRateReceivedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_RateReceived(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManager, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    AutoRepeatModeBehavior = property(get_AutoRepeatModeBehavior, None)
    FastForwardBehavior = property(get_FastForwardBehavior, None)
    IsEnabled = property(get_IsEnabled, put_IsEnabled)
    MediaPlayer = property(get_MediaPlayer, None)
    NextBehavior = property(get_NextBehavior, None)
    PauseBehavior = property(get_PauseBehavior, None)
    PlayBehavior = property(get_PlayBehavior, None)
    PositionBehavior = property(get_PositionBehavior, None)
    PreviousBehavior = property(get_PreviousBehavior, None)
    RateBehavior = property(get_RateBehavior, None)
    RewindBehavior = property(get_RewindBehavior, None)
    ShuffleBehavior = property(get_ShuffleBehavior, None)
    PlayReceived = event()
    PauseReceived = event()
    NextReceived = event()
    PreviousReceived = event()
    FastForwardReceived = event()
    RewindReceived = event()
    ShuffleReceived = event()
    AutoRepeatModeReceived = event()
    PositionReceived = event()
    RateReceived = event()
class MediaPlaybackCommandManagerAutoRepeatModeReceivedEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerAutoRepeatModeReceivedEventArgs
    _classid_ = 'Windows.Media.Playback.MediaPlaybackCommandManagerAutoRepeatModeReceivedEventArgs'
    @winrt_mixinmethod
    def get_Handled(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerAutoRepeatModeReceivedEventArgs) -> Boolean: ...
    @winrt_mixinmethod
    def put_Handled(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerAutoRepeatModeReceivedEventArgs, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_AutoRepeatMode(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerAutoRepeatModeReceivedEventArgs) -> win32more.Windows.Media.MediaPlaybackAutoRepeatMode: ...
    @winrt_mixinmethod
    def GetDeferral(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerAutoRepeatModeReceivedEventArgs) -> win32more.Windows.Foundation.Deferral: ...
    AutoRepeatMode = property(get_AutoRepeatMode, None)
    Handled = property(get_Handled, put_Handled)
class MediaPlaybackCommandManagerCommandBehavior(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerCommandBehavior
    _classid_ = 'Windows.Media.Playback.MediaPlaybackCommandManagerCommandBehavior'
    @winrt_mixinmethod
    def get_CommandManager(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerCommandBehavior) -> win32more.Windows.Media.Playback.MediaPlaybackCommandManager: ...
    @winrt_mixinmethod
    def get_IsEnabled(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerCommandBehavior) -> Boolean: ...
    @winrt_mixinmethod
    def get_EnablingRule(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerCommandBehavior) -> win32more.Windows.Media.Playback.MediaCommandEnablingRule: ...
    @winrt_mixinmethod
    def put_EnablingRule(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerCommandBehavior, value: win32more.Windows.Media.Playback.MediaCommandEnablingRule) -> Void: ...
    @winrt_mixinmethod
    def add_IsEnabledChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerCommandBehavior, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackCommandManagerCommandBehavior, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_IsEnabledChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerCommandBehavior, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    CommandManager = property(get_CommandManager, None)
    EnablingRule = property(get_EnablingRule, put_EnablingRule)
    IsEnabled = property(get_IsEnabled, None)
    IsEnabledChanged = event()
class MediaPlaybackCommandManagerFastForwardReceivedEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerFastForwardReceivedEventArgs
    _classid_ = 'Windows.Media.Playback.MediaPlaybackCommandManagerFastForwardReceivedEventArgs'
    @winrt_mixinmethod
    def get_Handled(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerFastForwardReceivedEventArgs) -> Boolean: ...
    @winrt_mixinmethod
    def put_Handled(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerFastForwardReceivedEventArgs, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def GetDeferral(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerFastForwardReceivedEventArgs) -> win32more.Windows.Foundation.Deferral: ...
    Handled = property(get_Handled, put_Handled)
class MediaPlaybackCommandManagerNextReceivedEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerNextReceivedEventArgs
    _classid_ = 'Windows.Media.Playback.MediaPlaybackCommandManagerNextReceivedEventArgs'
    @winrt_mixinmethod
    def get_Handled(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerNextReceivedEventArgs) -> Boolean: ...
    @winrt_mixinmethod
    def put_Handled(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerNextReceivedEventArgs, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def GetDeferral(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerNextReceivedEventArgs) -> win32more.Windows.Foundation.Deferral: ...
    Handled = property(get_Handled, put_Handled)
class MediaPlaybackCommandManagerPauseReceivedEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerPauseReceivedEventArgs
    _classid_ = 'Windows.Media.Playback.MediaPlaybackCommandManagerPauseReceivedEventArgs'
    @winrt_mixinmethod
    def get_Handled(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerPauseReceivedEventArgs) -> Boolean: ...
    @winrt_mixinmethod
    def put_Handled(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerPauseReceivedEventArgs, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def GetDeferral(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerPauseReceivedEventArgs) -> win32more.Windows.Foundation.Deferral: ...
    Handled = property(get_Handled, put_Handled)
class MediaPlaybackCommandManagerPlayReceivedEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerPlayReceivedEventArgs
    _classid_ = 'Windows.Media.Playback.MediaPlaybackCommandManagerPlayReceivedEventArgs'
    @winrt_mixinmethod
    def get_Handled(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerPlayReceivedEventArgs) -> Boolean: ...
    @winrt_mixinmethod
    def put_Handled(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerPlayReceivedEventArgs, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def GetDeferral(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerPlayReceivedEventArgs) -> win32more.Windows.Foundation.Deferral: ...
    Handled = property(get_Handled, put_Handled)
class MediaPlaybackCommandManagerPositionReceivedEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerPositionReceivedEventArgs
    _classid_ = 'Windows.Media.Playback.MediaPlaybackCommandManagerPositionReceivedEventArgs'
    @winrt_mixinmethod
    def get_Handled(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerPositionReceivedEventArgs) -> Boolean: ...
    @winrt_mixinmethod
    def put_Handled(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerPositionReceivedEventArgs, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_Position(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerPositionReceivedEventArgs) -> win32more.Windows.Foundation.TimeSpan: ...
    @winrt_mixinmethod
    def GetDeferral(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerPositionReceivedEventArgs) -> win32more.Windows.Foundation.Deferral: ...
    Handled = property(get_Handled, put_Handled)
    Position = property(get_Position, None)
class MediaPlaybackCommandManagerPreviousReceivedEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerPreviousReceivedEventArgs
    _classid_ = 'Windows.Media.Playback.MediaPlaybackCommandManagerPreviousReceivedEventArgs'
    @winrt_mixinmethod
    def get_Handled(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerPreviousReceivedEventArgs) -> Boolean: ...
    @winrt_mixinmethod
    def put_Handled(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerPreviousReceivedEventArgs, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def GetDeferral(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerPreviousReceivedEventArgs) -> win32more.Windows.Foundation.Deferral: ...
    Handled = property(get_Handled, put_Handled)
class MediaPlaybackCommandManagerRateReceivedEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerRateReceivedEventArgs
    _classid_ = 'Windows.Media.Playback.MediaPlaybackCommandManagerRateReceivedEventArgs'
    @winrt_mixinmethod
    def get_Handled(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerRateReceivedEventArgs) -> Boolean: ...
    @winrt_mixinmethod
    def put_Handled(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerRateReceivedEventArgs, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_PlaybackRate(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerRateReceivedEventArgs) -> Double: ...
    @winrt_mixinmethod
    def GetDeferral(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerRateReceivedEventArgs) -> win32more.Windows.Foundation.Deferral: ...
    Handled = property(get_Handled, put_Handled)
    PlaybackRate = property(get_PlaybackRate, None)
class MediaPlaybackCommandManagerRewindReceivedEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerRewindReceivedEventArgs
    _classid_ = 'Windows.Media.Playback.MediaPlaybackCommandManagerRewindReceivedEventArgs'
    @winrt_mixinmethod
    def get_Handled(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerRewindReceivedEventArgs) -> Boolean: ...
    @winrt_mixinmethod
    def put_Handled(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerRewindReceivedEventArgs, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def GetDeferral(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerRewindReceivedEventArgs) -> win32more.Windows.Foundation.Deferral: ...
    Handled = property(get_Handled, put_Handled)
class MediaPlaybackCommandManagerShuffleReceivedEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerShuffleReceivedEventArgs
    _classid_ = 'Windows.Media.Playback.MediaPlaybackCommandManagerShuffleReceivedEventArgs'
    @winrt_mixinmethod
    def get_Handled(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerShuffleReceivedEventArgs) -> Boolean: ...
    @winrt_mixinmethod
    def put_Handled(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerShuffleReceivedEventArgs, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_IsShuffleRequested(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerShuffleReceivedEventArgs) -> Boolean: ...
    @winrt_mixinmethod
    def GetDeferral(self: win32more.Windows.Media.Playback.IMediaPlaybackCommandManagerShuffleReceivedEventArgs) -> win32more.Windows.Foundation.Deferral: ...
    Handled = property(get_Handled, put_Handled)
    IsShuffleRequested = property(get_IsShuffleRequested, None)
class MediaPlaybackItem(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IMediaPlaybackItem
    _classid_ = 'Windows.Media.Playback.MediaPlaybackItem'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Media.Playback.MediaPlaybackItem.Create(*args))
        elif len(args) == 2:
            super().__init__(move=win32more.Windows.Media.Playback.MediaPlaybackItem.CreateWithStartTime(*args))
        elif len(args) == 3:
            super().__init__(move=win32more.Windows.Media.Playback.MediaPlaybackItem.CreateWithStartTimeAndDurationLimit(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def Create(cls: win32more.Windows.Media.Playback.IMediaPlaybackItemFactory, source: win32more.Windows.Media.Core.MediaSource) -> win32more.Windows.Media.Playback.MediaPlaybackItem: ...
    @winrt_factorymethod
    def CreateWithStartTime(cls: win32more.Windows.Media.Playback.IMediaPlaybackItemFactory2, source: win32more.Windows.Media.Core.MediaSource, startTime: win32more.Windows.Foundation.TimeSpan) -> win32more.Windows.Media.Playback.MediaPlaybackItem: ...
    @winrt_factorymethod
    def CreateWithStartTimeAndDurationLimit(cls: win32more.Windows.Media.Playback.IMediaPlaybackItemFactory2, source: win32more.Windows.Media.Core.MediaSource, startTime: win32more.Windows.Foundation.TimeSpan, durationLimit: win32more.Windows.Foundation.TimeSpan) -> win32more.Windows.Media.Playback.MediaPlaybackItem: ...
    @winrt_mixinmethod
    def add_AudioTracksChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackItem, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackItem, win32more.Windows.Foundation.Collections.IVectorChangedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_AudioTracksChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackItem, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_VideoTracksChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackItem, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackItem, win32more.Windows.Foundation.Collections.IVectorChangedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_VideoTracksChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackItem, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_TimedMetadataTracksChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackItem, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackItem, win32more.Windows.Foundation.Collections.IVectorChangedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_TimedMetadataTracksChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackItem, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Windows.Media.Playback.IMediaPlaybackItem) -> win32more.Windows.Media.Core.MediaSource: ...
    @winrt_mixinmethod
    def get_AudioTracks(self: win32more.Windows.Media.Playback.IMediaPlaybackItem) -> win32more.Windows.Media.Playback.MediaPlaybackAudioTrackList: ...
    @winrt_mixinmethod
    def get_VideoTracks(self: win32more.Windows.Media.Playback.IMediaPlaybackItem) -> win32more.Windows.Media.Playback.MediaPlaybackVideoTrackList: ...
    @winrt_mixinmethod
    def get_TimedMetadataTracks(self: win32more.Windows.Media.Playback.IMediaPlaybackItem) -> win32more.Windows.Media.Playback.MediaPlaybackTimedMetadataTrackList: ...
    @winrt_mixinmethod
    def get_BreakSchedule(self: win32more.Windows.Media.Playback.IMediaPlaybackItem2) -> win32more.Windows.Media.Playback.MediaBreakSchedule: ...
    @winrt_mixinmethod
    def get_StartTime(self: win32more.Windows.Media.Playback.IMediaPlaybackItem2) -> win32more.Windows.Foundation.TimeSpan: ...
    @winrt_mixinmethod
    def get_DurationLimit(self: win32more.Windows.Media.Playback.IMediaPlaybackItem2) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]: ...
    @winrt_mixinmethod
    def get_CanSkip(self: win32more.Windows.Media.Playback.IMediaPlaybackItem2) -> Boolean: ...
    @winrt_mixinmethod
    def put_CanSkip(self: win32more.Windows.Media.Playback.IMediaPlaybackItem2, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def GetDisplayProperties(self: win32more.Windows.Media.Playback.IMediaPlaybackItem2) -> win32more.Windows.Media.Playback.MediaItemDisplayProperties: ...
    @winrt_mixinmethod
    def ApplyDisplayProperties(self: win32more.Windows.Media.Playback.IMediaPlaybackItem2, value: win32more.Windows.Media.Playback.MediaItemDisplayProperties) -> Void: ...
    @winrt_mixinmethod
    def get_IsDisabledInPlaybackList(self: win32more.Windows.Media.Playback.IMediaPlaybackItem3) -> Boolean: ...
    @winrt_mixinmethod
    def put_IsDisabledInPlaybackList(self: win32more.Windows.Media.Playback.IMediaPlaybackItem3, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_TotalDownloadProgress(self: win32more.Windows.Media.Playback.IMediaPlaybackItem3) -> Double: ...
    @winrt_mixinmethod
    def get_AutoLoadedDisplayProperties(self: win32more.Windows.Media.Playback.IMediaPlaybackItem3) -> win32more.Windows.Media.Playback.AutoLoadedDisplayPropertyKind: ...
    @winrt_mixinmethod
    def put_AutoLoadedDisplayProperties(self: win32more.Windows.Media.Playback.IMediaPlaybackItem3, value: win32more.Windows.Media.Playback.AutoLoadedDisplayPropertyKind) -> Void: ...
    @winrt_classmethod
    def FindFromMediaSource(cls: win32more.Windows.Media.Playback.IMediaPlaybackItemStatics, source: win32more.Windows.Media.Core.MediaSource) -> win32more.Windows.Media.Playback.MediaPlaybackItem: ...
    AudioTracks = property(get_AudioTracks, None)
    AutoLoadedDisplayProperties = property(get_AutoLoadedDisplayProperties, put_AutoLoadedDisplayProperties)
    BreakSchedule = property(get_BreakSchedule, None)
    CanSkip = property(get_CanSkip, put_CanSkip)
    DurationLimit = property(get_DurationLimit, None)
    IsDisabledInPlaybackList = property(get_IsDisabledInPlaybackList, put_IsDisabledInPlaybackList)
    Source = property(get_Source, None)
    StartTime = property(get_StartTime, None)
    TimedMetadataTracks = property(get_TimedMetadataTracks, None)
    TotalDownloadProgress = property(get_TotalDownloadProgress, None)
    VideoTracks = property(get_VideoTracks, None)
    AudioTracksChanged = event()
    VideoTracksChanged = event()
    TimedMetadataTracksChanged = event()
class MediaPlaybackItemChangedReason(Enum, Int32):
    InitialItem = 0
    EndOfStream = 1
    Error = 2
    AppRequested = 3
class MediaPlaybackItemError(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IMediaPlaybackItemError
    _classid_ = 'Windows.Media.Playback.MediaPlaybackItemError'
    @winrt_mixinmethod
    def get_ErrorCode(self: win32more.Windows.Media.Playback.IMediaPlaybackItemError) -> win32more.Windows.Media.Playback.MediaPlaybackItemErrorCode: ...
    @winrt_mixinmethod
    def get_ExtendedError(self: win32more.Windows.Media.Playback.IMediaPlaybackItemError) -> win32more.Windows.Foundation.HResult: ...
    ErrorCode = property(get_ErrorCode, None)
    ExtendedError = property(get_ExtendedError, None)
class MediaPlaybackItemErrorCode(Enum, Int32):
    None_ = 0
    Aborted = 1
    NetworkError = 2
    DecodeError = 3
    SourceNotSupportedError = 4
    EncryptionError = 5
class MediaPlaybackItemFailedEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IMediaPlaybackItemFailedEventArgs
    _classid_ = 'Windows.Media.Playback.MediaPlaybackItemFailedEventArgs'
    @winrt_mixinmethod
    def get_Item(self: win32more.Windows.Media.Playback.IMediaPlaybackItemFailedEventArgs) -> win32more.Windows.Media.Playback.MediaPlaybackItem: ...
    @winrt_mixinmethod
    def get_Error(self: win32more.Windows.Media.Playback.IMediaPlaybackItemFailedEventArgs) -> win32more.Windows.Media.Playback.MediaPlaybackItemError: ...
    Error = property(get_Error, None)
    Item = property(get_Item, None)
class MediaPlaybackItemOpenedEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IMediaPlaybackItemOpenedEventArgs
    _classid_ = 'Windows.Media.Playback.MediaPlaybackItemOpenedEventArgs'
    @winrt_mixinmethod
    def get_Item(self: win32more.Windows.Media.Playback.IMediaPlaybackItemOpenedEventArgs) -> win32more.Windows.Media.Playback.MediaPlaybackItem: ...
    Item = property(get_Item, None)
class MediaPlaybackList(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IMediaPlaybackList
    _classid_ = 'Windows.Media.Playback.MediaPlaybackList'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.Media.Playback.MediaPlaybackList.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.Media.Playback.MediaPlaybackList: ...
    @winrt_mixinmethod
    def add_ItemFailed(self: win32more.Windows.Media.Playback.IMediaPlaybackList, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackList, win32more.Windows.Media.Playback.MediaPlaybackItemFailedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_ItemFailed(self: win32more.Windows.Media.Playback.IMediaPlaybackList, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_CurrentItemChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackList, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackList, win32more.Windows.Media.Playback.CurrentMediaPlaybackItemChangedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_CurrentItemChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackList, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_ItemOpened(self: win32more.Windows.Media.Playback.IMediaPlaybackList, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackList, win32more.Windows.Media.Playback.MediaPlaybackItemOpenedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_ItemOpened(self: win32more.Windows.Media.Playback.IMediaPlaybackList, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def get_Items(self: win32more.Windows.Media.Playback.IMediaPlaybackList) -> win32more.Windows.Foundation.Collections.IObservableVector[win32more.Windows.Media.Playback.MediaPlaybackItem]: ...
    @winrt_mixinmethod
    def get_AutoRepeatEnabled(self: win32more.Windows.Media.Playback.IMediaPlaybackList) -> Boolean: ...
    @winrt_mixinmethod
    def put_AutoRepeatEnabled(self: win32more.Windows.Media.Playback.IMediaPlaybackList, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_ShuffleEnabled(self: win32more.Windows.Media.Playback.IMediaPlaybackList) -> Boolean: ...
    @winrt_mixinmethod
    def put_ShuffleEnabled(self: win32more.Windows.Media.Playback.IMediaPlaybackList, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_CurrentItem(self: win32more.Windows.Media.Playback.IMediaPlaybackList) -> win32more.Windows.Media.Playback.MediaPlaybackItem: ...
    @winrt_mixinmethod
    def get_CurrentItemIndex(self: win32more.Windows.Media.Playback.IMediaPlaybackList) -> UInt32: ...
    @winrt_mixinmethod
    def MoveNext(self: win32more.Windows.Media.Playback.IMediaPlaybackList) -> win32more.Windows.Media.Playback.MediaPlaybackItem: ...
    @winrt_mixinmethod
    def MovePrevious(self: win32more.Windows.Media.Playback.IMediaPlaybackList) -> win32more.Windows.Media.Playback.MediaPlaybackItem: ...
    @winrt_mixinmethod
    def MoveTo(self: win32more.Windows.Media.Playback.IMediaPlaybackList, itemIndex: UInt32) -> win32more.Windows.Media.Playback.MediaPlaybackItem: ...
    @winrt_mixinmethod
    def get_MaxPrefetchTime(self: win32more.Windows.Media.Playback.IMediaPlaybackList2) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]: ...
    @winrt_mixinmethod
    def put_MaxPrefetchTime(self: win32more.Windows.Media.Playback.IMediaPlaybackList2, value: win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]) -> Void: ...
    @winrt_mixinmethod
    def get_StartingItem(self: win32more.Windows.Media.Playback.IMediaPlaybackList2) -> win32more.Windows.Media.Playback.MediaPlaybackItem: ...
    @winrt_mixinmethod
    def put_StartingItem(self: win32more.Windows.Media.Playback.IMediaPlaybackList2, value: win32more.Windows.Media.Playback.MediaPlaybackItem) -> Void: ...
    @winrt_mixinmethod
    def get_ShuffledItems(self: win32more.Windows.Media.Playback.IMediaPlaybackList2) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Media.Playback.MediaPlaybackItem]: ...
    @winrt_mixinmethod
    def SetShuffledItems(self: win32more.Windows.Media.Playback.IMediaPlaybackList2, value: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Media.Playback.MediaPlaybackItem]) -> Void: ...
    @winrt_mixinmethod
    def get_MaxPlayedItemsToKeepOpen(self: win32more.Windows.Media.Playback.IMediaPlaybackList3) -> win32more.Windows.Foundation.IReference[UInt32]: ...
    @winrt_mixinmethod
    def put_MaxPlayedItemsToKeepOpen(self: win32more.Windows.Media.Playback.IMediaPlaybackList3, value: win32more.Windows.Foundation.IReference[UInt32]) -> Void: ...
    AutoRepeatEnabled = property(get_AutoRepeatEnabled, put_AutoRepeatEnabled)
    CurrentItem = property(get_CurrentItem, None)
    CurrentItemIndex = property(get_CurrentItemIndex, None)
    Items = property(get_Items, None)
    MaxPlayedItemsToKeepOpen = property(get_MaxPlayedItemsToKeepOpen, put_MaxPlayedItemsToKeepOpen)
    MaxPrefetchTime = property(get_MaxPrefetchTime, put_MaxPrefetchTime)
    ShuffleEnabled = property(get_ShuffleEnabled, put_ShuffleEnabled)
    ShuffledItems = property(get_ShuffledItems, None)
    StartingItem = property(get_StartingItem, put_StartingItem)
    ItemFailed = event()
    CurrentItemChanged = event()
    ItemOpened = event()
class MediaPlaybackSession(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IMediaPlaybackSession
    _classid_ = 'Windows.Media.Playback.MediaPlaybackSession'
    @winrt_mixinmethod
    def add_PlaybackStateChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackSession, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackSession, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_PlaybackStateChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackSession, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_PlaybackRateChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackSession, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackSession, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_PlaybackRateChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackSession, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_SeekCompleted(self: win32more.Windows.Media.Playback.IMediaPlaybackSession, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackSession, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_SeekCompleted(self: win32more.Windows.Media.Playback.IMediaPlaybackSession, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_BufferingStarted(self: win32more.Windows.Media.Playback.IMediaPlaybackSession, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackSession, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_BufferingStarted(self: win32more.Windows.Media.Playback.IMediaPlaybackSession, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_BufferingEnded(self: win32more.Windows.Media.Playback.IMediaPlaybackSession, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackSession, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_BufferingEnded(self: win32more.Windows.Media.Playback.IMediaPlaybackSession, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_BufferingProgressChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackSession, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackSession, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_BufferingProgressChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackSession, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_DownloadProgressChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackSession, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackSession, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_DownloadProgressChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackSession, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_NaturalDurationChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackSession, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackSession, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_NaturalDurationChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackSession, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_PositionChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackSession, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackSession, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_PositionChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackSession, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_NaturalVideoSizeChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackSession, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackSession, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_NaturalVideoSizeChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackSession, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def get_MediaPlayer(self: win32more.Windows.Media.Playback.IMediaPlaybackSession) -> win32more.Windows.Media.Playback.MediaPlayer: ...
    @winrt_mixinmethod
    def get_NaturalDuration(self: win32more.Windows.Media.Playback.IMediaPlaybackSession) -> win32more.Windows.Foundation.TimeSpan: ...
    @winrt_mixinmethod
    def get_Position(self: win32more.Windows.Media.Playback.IMediaPlaybackSession) -> win32more.Windows.Foundation.TimeSpan: ...
    @winrt_mixinmethod
    def put_Position(self: win32more.Windows.Media.Playback.IMediaPlaybackSession, value: win32more.Windows.Foundation.TimeSpan) -> Void: ...
    @winrt_mixinmethod
    def get_PlaybackState(self: win32more.Windows.Media.Playback.IMediaPlaybackSession) -> win32more.Windows.Media.Playback.MediaPlaybackState: ...
    @winrt_mixinmethod
    def get_CanSeek(self: win32more.Windows.Media.Playback.IMediaPlaybackSession) -> Boolean: ...
    @winrt_mixinmethod
    def get_CanPause(self: win32more.Windows.Media.Playback.IMediaPlaybackSession) -> Boolean: ...
    @winrt_mixinmethod
    def get_IsProtected(self: win32more.Windows.Media.Playback.IMediaPlaybackSession) -> Boolean: ...
    @winrt_mixinmethod
    def get_PlaybackRate(self: win32more.Windows.Media.Playback.IMediaPlaybackSession) -> Double: ...
    @winrt_mixinmethod
    def put_PlaybackRate(self: win32more.Windows.Media.Playback.IMediaPlaybackSession, value: Double) -> Void: ...
    @winrt_mixinmethod
    def get_BufferingProgress(self: win32more.Windows.Media.Playback.IMediaPlaybackSession) -> Double: ...
    @winrt_mixinmethod
    def get_DownloadProgress(self: win32more.Windows.Media.Playback.IMediaPlaybackSession) -> Double: ...
    @winrt_mixinmethod
    def get_NaturalVideoHeight(self: win32more.Windows.Media.Playback.IMediaPlaybackSession) -> UInt32: ...
    @winrt_mixinmethod
    def get_NaturalVideoWidth(self: win32more.Windows.Media.Playback.IMediaPlaybackSession) -> UInt32: ...
    @winrt_mixinmethod
    def get_NormalizedSourceRect(self: win32more.Windows.Media.Playback.IMediaPlaybackSession) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def put_NormalizedSourceRect(self: win32more.Windows.Media.Playback.IMediaPlaybackSession, value: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def get_StereoscopicVideoPackingMode(self: win32more.Windows.Media.Playback.IMediaPlaybackSession) -> win32more.Windows.Media.MediaProperties.StereoscopicVideoPackingMode: ...
    @winrt_mixinmethod
    def put_StereoscopicVideoPackingMode(self: win32more.Windows.Media.Playback.IMediaPlaybackSession, value: win32more.Windows.Media.MediaProperties.StereoscopicVideoPackingMode) -> Void: ...
    @winrt_mixinmethod
    def add_BufferedRangesChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackSession2, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackSession, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_BufferedRangesChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackSession2, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_PlayedRangesChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackSession2, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackSession, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_PlayedRangesChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackSession2, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_SeekableRangesChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackSession2, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackSession, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_SeekableRangesChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackSession2, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_SupportedPlaybackRatesChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackSession2, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackSession, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_SupportedPlaybackRatesChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackSession2, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def get_SphericalVideoProjection(self: win32more.Windows.Media.Playback.IMediaPlaybackSession2) -> win32more.Windows.Media.Playback.MediaPlaybackSphericalVideoProjection: ...
    @winrt_mixinmethod
    def get_IsMirroring(self: win32more.Windows.Media.Playback.IMediaPlaybackSession2) -> Boolean: ...
    @winrt_mixinmethod
    def put_IsMirroring(self: win32more.Windows.Media.Playback.IMediaPlaybackSession2, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def GetBufferedRanges(self: win32more.Windows.Media.Playback.IMediaPlaybackSession2) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Media.MediaTimeRange]: ...
    @winrt_mixinmethod
    def GetPlayedRanges(self: win32more.Windows.Media.Playback.IMediaPlaybackSession2) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Media.MediaTimeRange]: ...
    @winrt_mixinmethod
    def GetSeekableRanges(self: win32more.Windows.Media.Playback.IMediaPlaybackSession2) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Media.MediaTimeRange]: ...
    @winrt_mixinmethod
    def IsSupportedPlaybackRateRange(self: win32more.Windows.Media.Playback.IMediaPlaybackSession2, rate1: Double, rate2: Double) -> Boolean: ...
    @winrt_mixinmethod
    def get_PlaybackRotation(self: win32more.Windows.Media.Playback.IMediaPlaybackSession3) -> win32more.Windows.Media.MediaProperties.MediaRotation: ...
    @winrt_mixinmethod
    def put_PlaybackRotation(self: win32more.Windows.Media.Playback.IMediaPlaybackSession3, value: win32more.Windows.Media.MediaProperties.MediaRotation) -> Void: ...
    @winrt_mixinmethod
    def GetOutputDegradationPolicyState(self: win32more.Windows.Media.Playback.IMediaPlaybackSession3) -> win32more.Windows.Media.Playback.MediaPlaybackSessionOutputDegradationPolicyState: ...
    BufferingProgress = property(get_BufferingProgress, None)
    CanPause = property(get_CanPause, None)
    CanSeek = property(get_CanSeek, None)
    DownloadProgress = property(get_DownloadProgress, None)
    IsMirroring = property(get_IsMirroring, put_IsMirroring)
    IsProtected = property(get_IsProtected, None)
    MediaPlayer = property(get_MediaPlayer, None)
    NaturalDuration = property(get_NaturalDuration, None)
    NaturalVideoHeight = property(get_NaturalVideoHeight, None)
    NaturalVideoWidth = property(get_NaturalVideoWidth, None)
    NormalizedSourceRect = property(get_NormalizedSourceRect, put_NormalizedSourceRect)
    PlaybackRate = property(get_PlaybackRate, put_PlaybackRate)
    PlaybackRotation = property(get_PlaybackRotation, put_PlaybackRotation)
    PlaybackState = property(get_PlaybackState, None)
    Position = property(get_Position, put_Position)
    SphericalVideoProjection = property(get_SphericalVideoProjection, None)
    StereoscopicVideoPackingMode = property(get_StereoscopicVideoPackingMode, put_StereoscopicVideoPackingMode)
    PlaybackStateChanged = event()
    PlaybackRateChanged = event()
    SeekCompleted = event()
    BufferingStarted = event()
    BufferingEnded = event()
    BufferingProgressChanged = event()
    DownloadProgressChanged = event()
    NaturalDurationChanged = event()
    PositionChanged = event()
    NaturalVideoSizeChanged = event()
    BufferedRangesChanged = event()
    PlayedRangesChanged = event()
    SeekableRangesChanged = event()
    SupportedPlaybackRatesChanged = event()
class MediaPlaybackSessionBufferingStartedEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IMediaPlaybackSessionBufferingStartedEventArgs
    _classid_ = 'Windows.Media.Playback.MediaPlaybackSessionBufferingStartedEventArgs'
    @winrt_mixinmethod
    def get_IsPlaybackInterruption(self: win32more.Windows.Media.Playback.IMediaPlaybackSessionBufferingStartedEventArgs) -> Boolean: ...
    IsPlaybackInterruption = property(get_IsPlaybackInterruption, None)
class MediaPlaybackSessionOutputDegradationPolicyState(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IMediaPlaybackSessionOutputDegradationPolicyState
    _classid_ = 'Windows.Media.Playback.MediaPlaybackSessionOutputDegradationPolicyState'
    @winrt_mixinmethod
    def get_VideoConstrictionReason(self: win32more.Windows.Media.Playback.IMediaPlaybackSessionOutputDegradationPolicyState) -> win32more.Windows.Media.Playback.MediaPlaybackSessionVideoConstrictionReason: ...
    VideoConstrictionReason = property(get_VideoConstrictionReason, None)
class MediaPlaybackSessionVideoConstrictionReason(Enum, Int32):
    None_ = 0
    VirtualMachine = 1
    UnsupportedDisplayAdapter = 2
    UnsignedDriver = 3
    FrameServerEnabled = 4
    OutputProtectionFailed = 5
    Unknown = 6
class MediaPlaybackSphericalVideoProjection(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IMediaPlaybackSphericalVideoProjection
    _classid_ = 'Windows.Media.Playback.MediaPlaybackSphericalVideoProjection'
    @winrt_mixinmethod
    def get_IsEnabled(self: win32more.Windows.Media.Playback.IMediaPlaybackSphericalVideoProjection) -> Boolean: ...
    @winrt_mixinmethod
    def put_IsEnabled(self: win32more.Windows.Media.Playback.IMediaPlaybackSphericalVideoProjection, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_FrameFormat(self: win32more.Windows.Media.Playback.IMediaPlaybackSphericalVideoProjection) -> win32more.Windows.Media.MediaProperties.SphericalVideoFrameFormat: ...
    @winrt_mixinmethod
    def put_FrameFormat(self: win32more.Windows.Media.Playback.IMediaPlaybackSphericalVideoProjection, value: win32more.Windows.Media.MediaProperties.SphericalVideoFrameFormat) -> Void: ...
    @winrt_mixinmethod
    def get_HorizontalFieldOfViewInDegrees(self: win32more.Windows.Media.Playback.IMediaPlaybackSphericalVideoProjection) -> Double: ...
    @winrt_mixinmethod
    def put_HorizontalFieldOfViewInDegrees(self: win32more.Windows.Media.Playback.IMediaPlaybackSphericalVideoProjection, value: Double) -> Void: ...
    @winrt_mixinmethod
    def get_ViewOrientation(self: win32more.Windows.Media.Playback.IMediaPlaybackSphericalVideoProjection) -> win32more.Windows.Foundation.Numerics.Quaternion: ...
    @winrt_mixinmethod
    def put_ViewOrientation(self: win32more.Windows.Media.Playback.IMediaPlaybackSphericalVideoProjection, value: win32more.Windows.Foundation.Numerics.Quaternion) -> Void: ...
    @winrt_mixinmethod
    def get_ProjectionMode(self: win32more.Windows.Media.Playback.IMediaPlaybackSphericalVideoProjection) -> win32more.Windows.Media.Playback.SphericalVideoProjectionMode: ...
    @winrt_mixinmethod
    def put_ProjectionMode(self: win32more.Windows.Media.Playback.IMediaPlaybackSphericalVideoProjection, value: win32more.Windows.Media.Playback.SphericalVideoProjectionMode) -> Void: ...
    FrameFormat = property(get_FrameFormat, put_FrameFormat)
    HorizontalFieldOfViewInDegrees = property(get_HorizontalFieldOfViewInDegrees, put_HorizontalFieldOfViewInDegrees)
    IsEnabled = property(get_IsEnabled, put_IsEnabled)
    ProjectionMode = property(get_ProjectionMode, put_ProjectionMode)
    ViewOrientation = property(get_ViewOrientation, put_ViewOrientation)
class MediaPlaybackState(Enum, Int32):
    None_ = 0
    Opening = 1
    Buffering = 2
    Playing = 3
    Paused = 4
class MediaPlaybackTimedMetadataTrackList(ComPtr):
    extends: IInspectable
    implements: Tuple[SequenceProtocol[win32more.Windows.Media.Core.TimedMetadataTrack]]
    default_interface: win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Media.Core.TimedMetadataTrack]
    _classid_ = 'Windows.Media.Playback.MediaPlaybackTimedMetadataTrackList'
    @winrt_mixinmethod
    def GetAt(self: win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Media.Core.TimedMetadataTrack], index: UInt32) -> win32more.Windows.Media.Core.TimedMetadataTrack: ...
    @winrt_mixinmethod
    def get_Size(self: win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Media.Core.TimedMetadataTrack]) -> UInt32: ...
    @winrt_mixinmethod
    def IndexOf(self: win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Media.Core.TimedMetadataTrack], value: win32more.Windows.Media.Core.TimedMetadataTrack, index: POINTER(UInt32)) -> Boolean: ...
    @winrt_mixinmethod
    def GetMany(self: win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Media.Core.TimedMetadataTrack], startIndex: UInt32, items: FillArray[win32more.Windows.Media.Core.TimedMetadataTrack]) -> UInt32: ...
    @winrt_mixinmethod
    def First(self: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Media.Core.TimedMetadataTrack]) -> win32more.Windows.Foundation.Collections.IIterator[win32more.Windows.Media.Core.TimedMetadataTrack]: ...
    @winrt_mixinmethod
    def add_PresentationModeChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackTimedMetadataTrackList, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlaybackTimedMetadataTrackList, win32more.Windows.Media.Playback.TimedMetadataPresentationModeChangedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_PresentationModeChanged(self: win32more.Windows.Media.Playback.IMediaPlaybackTimedMetadataTrackList, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def GetPresentationMode(self: win32more.Windows.Media.Playback.IMediaPlaybackTimedMetadataTrackList, index: UInt32) -> win32more.Windows.Media.Playback.TimedMetadataTrackPresentationMode: ...
    @winrt_mixinmethod
    def SetPresentationMode(self: win32more.Windows.Media.Playback.IMediaPlaybackTimedMetadataTrackList, index: UInt32, value: win32more.Windows.Media.Playback.TimedMetadataTrackPresentationMode) -> Void: ...
    Size = property(get_Size, None)
    PresentationModeChanged = event()
class MediaPlaybackVideoTrackList(ComPtr):
    extends: IInspectable
    implements: Tuple[SequenceProtocol[win32more.Windows.Media.Core.VideoTrack]]
    default_interface: win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Media.Core.VideoTrack]
    _classid_ = 'Windows.Media.Playback.MediaPlaybackVideoTrackList'
    @winrt_mixinmethod
    def GetAt(self: win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Media.Core.VideoTrack], index: UInt32) -> win32more.Windows.Media.Core.VideoTrack: ...
    @winrt_mixinmethod
    def get_Size(self: win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Media.Core.VideoTrack]) -> UInt32: ...
    @winrt_mixinmethod
    def IndexOf(self: win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Media.Core.VideoTrack], value: win32more.Windows.Media.Core.VideoTrack, index: POINTER(UInt32)) -> Boolean: ...
    @winrt_mixinmethod
    def GetMany(self: win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Media.Core.VideoTrack], startIndex: UInt32, items: FillArray[win32more.Windows.Media.Core.VideoTrack]) -> UInt32: ...
    @winrt_mixinmethod
    def First(self: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Media.Core.VideoTrack]) -> win32more.Windows.Foundation.Collections.IIterator[win32more.Windows.Media.Core.VideoTrack]: ...
    @winrt_mixinmethod
    def add_SelectedIndexChanged(self: win32more.Windows.Media.Core.ISingleSelectMediaTrackList, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Core.ISingleSelectMediaTrackList, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_SelectedIndexChanged(self: win32more.Windows.Media.Core.ISingleSelectMediaTrackList, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def put_SelectedIndex(self: win32more.Windows.Media.Core.ISingleSelectMediaTrackList, value: Int32) -> Void: ...
    @winrt_mixinmethod
    def get_SelectedIndex(self: win32more.Windows.Media.Core.ISingleSelectMediaTrackList) -> Int32: ...
    SelectedIndex = property(get_SelectedIndex, put_SelectedIndex)
    Size = property(get_Size, None)
    SelectedIndexChanged = event()
class MediaPlayer(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Windows.Media.Playback.IMediaPlayer
    _classid_ = 'Windows.Media.Playback.MediaPlayer'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.Media.Playback.MediaPlayer.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.Media.Playback.MediaPlayer: ...
    @winrt_mixinmethod
    def get_AutoPlay(self: win32more.Windows.Media.Playback.IMediaPlayer) -> Boolean: ...
    @winrt_mixinmethod
    def put_AutoPlay(self: win32more.Windows.Media.Playback.IMediaPlayer, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_NaturalDuration(self: win32more.Windows.Media.Playback.IMediaPlayer) -> win32more.Windows.Foundation.TimeSpan: ...
    @winrt_mixinmethod
    def get_Position(self: win32more.Windows.Media.Playback.IMediaPlayer) -> win32more.Windows.Foundation.TimeSpan: ...
    @winrt_mixinmethod
    def put_Position(self: win32more.Windows.Media.Playback.IMediaPlayer, value: win32more.Windows.Foundation.TimeSpan) -> Void: ...
    @winrt_mixinmethod
    def get_BufferingProgress(self: win32more.Windows.Media.Playback.IMediaPlayer) -> Double: ...
    @winrt_mixinmethod
    def get_CurrentState(self: win32more.Windows.Media.Playback.IMediaPlayer) -> win32more.Windows.Media.Playback.MediaPlayerState: ...
    @winrt_mixinmethod
    def get_CanSeek(self: win32more.Windows.Media.Playback.IMediaPlayer) -> Boolean: ...
    @winrt_mixinmethod
    def get_CanPause(self: win32more.Windows.Media.Playback.IMediaPlayer) -> Boolean: ...
    @winrt_mixinmethod
    def get_IsLoopingEnabled(self: win32more.Windows.Media.Playback.IMediaPlayer) -> Boolean: ...
    @winrt_mixinmethod
    def put_IsLoopingEnabled(self: win32more.Windows.Media.Playback.IMediaPlayer, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_IsProtected(self: win32more.Windows.Media.Playback.IMediaPlayer) -> Boolean: ...
    @winrt_mixinmethod
    def get_IsMuted(self: win32more.Windows.Media.Playback.IMediaPlayer) -> Boolean: ...
    @winrt_mixinmethod
    def put_IsMuted(self: win32more.Windows.Media.Playback.IMediaPlayer, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_PlaybackRate(self: win32more.Windows.Media.Playback.IMediaPlayer) -> Double: ...
    @winrt_mixinmethod
    def put_PlaybackRate(self: win32more.Windows.Media.Playback.IMediaPlayer, value: Double) -> Void: ...
    @winrt_mixinmethod
    def get_Volume(self: win32more.Windows.Media.Playback.IMediaPlayer) -> Double: ...
    @winrt_mixinmethod
    def put_Volume(self: win32more.Windows.Media.Playback.IMediaPlayer, value: Double) -> Void: ...
    @winrt_mixinmethod
    def get_PlaybackMediaMarkers(self: win32more.Windows.Media.Playback.IMediaPlayer) -> win32more.Windows.Media.Playback.PlaybackMediaMarkerSequence: ...
    @winrt_mixinmethod
    def add_MediaOpened(self: win32more.Windows.Media.Playback.IMediaPlayer, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlayer, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_MediaOpened(self: win32more.Windows.Media.Playback.IMediaPlayer, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_MediaEnded(self: win32more.Windows.Media.Playback.IMediaPlayer, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlayer, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_MediaEnded(self: win32more.Windows.Media.Playback.IMediaPlayer, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_MediaFailed(self: win32more.Windows.Media.Playback.IMediaPlayer, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlayer, win32more.Windows.Media.Playback.MediaPlayerFailedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_MediaFailed(self: win32more.Windows.Media.Playback.IMediaPlayer, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_CurrentStateChanged(self: win32more.Windows.Media.Playback.IMediaPlayer, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlayer, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_CurrentStateChanged(self: win32more.Windows.Media.Playback.IMediaPlayer, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_PlaybackMediaMarkerReached(self: win32more.Windows.Media.Playback.IMediaPlayer, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlayer, win32more.Windows.Media.Playback.PlaybackMediaMarkerReachedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_PlaybackMediaMarkerReached(self: win32more.Windows.Media.Playback.IMediaPlayer, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_MediaPlayerRateChanged(self: win32more.Windows.Media.Playback.IMediaPlayer, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlayer, win32more.Windows.Media.Playback.MediaPlayerRateChangedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_MediaPlayerRateChanged(self: win32more.Windows.Media.Playback.IMediaPlayer, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_VolumeChanged(self: win32more.Windows.Media.Playback.IMediaPlayer, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlayer, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_VolumeChanged(self: win32more.Windows.Media.Playback.IMediaPlayer, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_SeekCompleted(self: win32more.Windows.Media.Playback.IMediaPlayer, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlayer, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_SeekCompleted(self: win32more.Windows.Media.Playback.IMediaPlayer, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_BufferingStarted(self: win32more.Windows.Media.Playback.IMediaPlayer, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlayer, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_BufferingStarted(self: win32more.Windows.Media.Playback.IMediaPlayer, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_BufferingEnded(self: win32more.Windows.Media.Playback.IMediaPlayer, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlayer, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_BufferingEnded(self: win32more.Windows.Media.Playback.IMediaPlayer, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def Play(self: win32more.Windows.Media.Playback.IMediaPlayer) -> Void: ...
    @winrt_mixinmethod
    def Pause(self: win32more.Windows.Media.Playback.IMediaPlayer) -> Void: ...
    @winrt_mixinmethod
    def SetUriSource(self: win32more.Windows.Media.Playback.IMediaPlayer, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_mixinmethod
    def get_ProtectionManager(self: win32more.Windows.Media.Playback.IMediaPlayerSource) -> win32more.Windows.Media.Protection.MediaProtectionManager: ...
    @winrt_mixinmethod
    def put_ProtectionManager(self: win32more.Windows.Media.Playback.IMediaPlayerSource, value: win32more.Windows.Media.Protection.MediaProtectionManager) -> Void: ...
    @winrt_mixinmethod
    def SetFileSource(self: win32more.Windows.Media.Playback.IMediaPlayerSource, file: win32more.Windows.Storage.IStorageFile) -> Void: ...
    @winrt_mixinmethod
    def SetStreamSource(self: win32more.Windows.Media.Playback.IMediaPlayerSource, stream: win32more.Windows.Storage.Streams.IRandomAccessStream) -> Void: ...
    @winrt_mixinmethod
    def SetMediaSource(self: win32more.Windows.Media.Playback.IMediaPlayerSource, source: win32more.Windows.Media.Core.IMediaSource) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Windows.Media.Playback.IMediaPlayerSource2) -> win32more.Windows.Media.Playback.IMediaPlaybackSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Windows.Media.Playback.IMediaPlayerSource2, value: win32more.Windows.Media.Playback.IMediaPlaybackSource) -> Void: ...
    @winrt_mixinmethod
    def get_SystemMediaTransportControls(self: win32more.Windows.Media.Playback.IMediaPlayer2) -> win32more.Windows.Media.SystemMediaTransportControls: ...
    @winrt_mixinmethod
    def get_AudioCategory(self: win32more.Windows.Media.Playback.IMediaPlayer2) -> win32more.Windows.Media.Playback.MediaPlayerAudioCategory: ...
    @winrt_mixinmethod
    def put_AudioCategory(self: win32more.Windows.Media.Playback.IMediaPlayer2, value: win32more.Windows.Media.Playback.MediaPlayerAudioCategory) -> Void: ...
    @winrt_mixinmethod
    def get_AudioDeviceType(self: win32more.Windows.Media.Playback.IMediaPlayer2) -> win32more.Windows.Media.Playback.MediaPlayerAudioDeviceType: ...
    @winrt_mixinmethod
    def put_AudioDeviceType(self: win32more.Windows.Media.Playback.IMediaPlayer2, value: win32more.Windows.Media.Playback.MediaPlayerAudioDeviceType) -> Void: ...
    @winrt_mixinmethod
    def AddAudioEffect(self: win32more.Windows.Media.Playback.IMediaPlayerEffects, activatableClassId: WinRT_String, effectOptional: Boolean, configuration: win32more.Windows.Foundation.Collections.IPropertySet) -> Void: ...
    @winrt_mixinmethod
    def RemoveAllEffects(self: win32more.Windows.Media.Playback.IMediaPlayerEffects) -> Void: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    @winrt_mixinmethod
    def add_IsMutedChanged(self: win32more.Windows.Media.Playback.IMediaPlayer3, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlayer, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_IsMutedChanged(self: win32more.Windows.Media.Playback.IMediaPlayer3, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_SourceChanged(self: win32more.Windows.Media.Playback.IMediaPlayer3, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlayer, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_SourceChanged(self: win32more.Windows.Media.Playback.IMediaPlayer3, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def get_AudioBalance(self: win32more.Windows.Media.Playback.IMediaPlayer3) -> Double: ...
    @winrt_mixinmethod
    def put_AudioBalance(self: win32more.Windows.Media.Playback.IMediaPlayer3, value: Double) -> Void: ...
    @winrt_mixinmethod
    def get_RealTimePlayback(self: win32more.Windows.Media.Playback.IMediaPlayer3) -> Boolean: ...
    @winrt_mixinmethod
    def put_RealTimePlayback(self: win32more.Windows.Media.Playback.IMediaPlayer3, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_StereoscopicVideoRenderMode(self: win32more.Windows.Media.Playback.IMediaPlayer3) -> win32more.Windows.Media.Playback.StereoscopicVideoRenderMode: ...
    @winrt_mixinmethod
    def put_StereoscopicVideoRenderMode(self: win32more.Windows.Media.Playback.IMediaPlayer3, value: win32more.Windows.Media.Playback.StereoscopicVideoRenderMode) -> Void: ...
    @winrt_mixinmethod
    def get_BreakManager(self: win32more.Windows.Media.Playback.IMediaPlayer3) -> win32more.Windows.Media.Playback.MediaBreakManager: ...
    @winrt_mixinmethod
    def get_CommandManager(self: win32more.Windows.Media.Playback.IMediaPlayer3) -> win32more.Windows.Media.Playback.MediaPlaybackCommandManager: ...
    @winrt_mixinmethod
    def get_AudioDevice(self: win32more.Windows.Media.Playback.IMediaPlayer3) -> win32more.Windows.Devices.Enumeration.DeviceInformation: ...
    @winrt_mixinmethod
    def put_AudioDevice(self: win32more.Windows.Media.Playback.IMediaPlayer3, value: win32more.Windows.Devices.Enumeration.DeviceInformation) -> Void: ...
    @winrt_mixinmethod
    def get_TimelineController(self: win32more.Windows.Media.Playback.IMediaPlayer3) -> win32more.Windows.Media.MediaTimelineController: ...
    @winrt_mixinmethod
    def put_TimelineController(self: win32more.Windows.Media.Playback.IMediaPlayer3, value: win32more.Windows.Media.MediaTimelineController) -> Void: ...
    @winrt_mixinmethod
    def get_TimelineControllerPositionOffset(self: win32more.Windows.Media.Playback.IMediaPlayer3) -> win32more.Windows.Foundation.TimeSpan: ...
    @winrt_mixinmethod
    def put_TimelineControllerPositionOffset(self: win32more.Windows.Media.Playback.IMediaPlayer3, value: win32more.Windows.Foundation.TimeSpan) -> Void: ...
    @winrt_mixinmethod
    def get_PlaybackSession(self: win32more.Windows.Media.Playback.IMediaPlayer3) -> win32more.Windows.Media.Playback.MediaPlaybackSession: ...
    @winrt_mixinmethod
    def StepForwardOneFrame(self: win32more.Windows.Media.Playback.IMediaPlayer3) -> Void: ...
    @winrt_mixinmethod
    def StepBackwardOneFrame(self: win32more.Windows.Media.Playback.IMediaPlayer3) -> Void: ...
    @winrt_mixinmethod
    def GetAsCastingSource(self: win32more.Windows.Media.Playback.IMediaPlayer3) -> win32more.Windows.Media.Casting.CastingSource: ...
    @winrt_mixinmethod
    def SetSurfaceSize(self: win32more.Windows.Media.Playback.IMediaPlayer4, size: win32more.Windows.Foundation.Size) -> Void: ...
    @winrt_mixinmethod
    def GetSurface(self: win32more.Windows.Media.Playback.IMediaPlayer4, compositor: win32more.Windows.UI.Composition.Compositor) -> win32more.Windows.Media.Playback.MediaPlayerSurface: ...
    @winrt_mixinmethod
    def AddVideoEffect(self: win32more.Windows.Media.Playback.IMediaPlayerEffects2, activatableClassId: WinRT_String, effectOptional: Boolean, effectConfiguration: win32more.Windows.Foundation.Collections.IPropertySet) -> Void: ...
    @winrt_mixinmethod
    def add_VideoFrameAvailable(self: win32more.Windows.Media.Playback.IMediaPlayer5, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlayer, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_VideoFrameAvailable(self: win32more.Windows.Media.Playback.IMediaPlayer5, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def get_IsVideoFrameServerEnabled(self: win32more.Windows.Media.Playback.IMediaPlayer5) -> Boolean: ...
    @winrt_mixinmethod
    def put_IsVideoFrameServerEnabled(self: win32more.Windows.Media.Playback.IMediaPlayer5, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def CopyFrameToVideoSurface(self: win32more.Windows.Media.Playback.IMediaPlayer5, destination: win32more.Windows.Graphics.DirectX.Direct3D11.IDirect3DSurface) -> Void: ...
    @winrt_mixinmethod
    def CopyFrameToVideoSurfaceWithTargetRectangle(self: win32more.Windows.Media.Playback.IMediaPlayer5, destination: win32more.Windows.Graphics.DirectX.Direct3D11.IDirect3DSurface, targetRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def CopyFrameToStereoscopicVideoSurfaces(self: win32more.Windows.Media.Playback.IMediaPlayer5, destinationLeftEye: win32more.Windows.Graphics.DirectX.Direct3D11.IDirect3DSurface, destinationRightEye: win32more.Windows.Graphics.DirectX.Direct3D11.IDirect3DSurface) -> Void: ...
    @winrt_mixinmethod
    def add_SubtitleFrameChanged(self: win32more.Windows.Media.Playback.IMediaPlayer6, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Media.Playback.MediaPlayer, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_SubtitleFrameChanged(self: win32more.Windows.Media.Playback.IMediaPlayer6, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def RenderSubtitlesToSurface(self: win32more.Windows.Media.Playback.IMediaPlayer6, destination: win32more.Windows.Graphics.DirectX.Direct3D11.IDirect3DSurface) -> Boolean: ...
    @winrt_mixinmethod
    def RenderSubtitlesToSurfaceWithTargetRectangle(self: win32more.Windows.Media.Playback.IMediaPlayer6, destination: win32more.Windows.Graphics.DirectX.Direct3D11.IDirect3DSurface, targetRectangle: win32more.Windows.Foundation.Rect) -> Boolean: ...
    @winrt_mixinmethod
    def get_AudioStateMonitor(self: win32more.Windows.Media.Playback.IMediaPlayer7) -> win32more.Windows.Media.Audio.AudioStateMonitor: ...
    AudioBalance = property(get_AudioBalance, put_AudioBalance)
    AudioCategory = property(get_AudioCategory, put_AudioCategory)
    AudioDevice = property(get_AudioDevice, put_AudioDevice)
    AudioDeviceType = property(get_AudioDeviceType, put_AudioDeviceType)
    AudioStateMonitor = property(get_AudioStateMonitor, None)
    AutoPlay = property(get_AutoPlay, put_AutoPlay)
    BreakManager = property(get_BreakManager, None)
    BufferingProgress = property(get_BufferingProgress, None)
    CanPause = property(get_CanPause, None)
    CanSeek = property(get_CanSeek, None)
    CommandManager = property(get_CommandManager, None)
    CurrentState = property(get_CurrentState, None)
    IsLoopingEnabled = property(get_IsLoopingEnabled, put_IsLoopingEnabled)
    IsMuted = property(get_IsMuted, put_IsMuted)
    IsProtected = property(get_IsProtected, None)
    IsVideoFrameServerEnabled = property(get_IsVideoFrameServerEnabled, put_IsVideoFrameServerEnabled)
    NaturalDuration = property(get_NaturalDuration, None)
    PlaybackMediaMarkers = property(get_PlaybackMediaMarkers, None)
    PlaybackRate = property(get_PlaybackRate, put_PlaybackRate)
    PlaybackSession = property(get_PlaybackSession, None)
    Position = property(get_Position, put_Position)
    ProtectionManager = property(get_ProtectionManager, put_ProtectionManager)
    RealTimePlayback = property(get_RealTimePlayback, put_RealTimePlayback)
    Source = property(get_Source, put_Source)
    StereoscopicVideoRenderMode = property(get_StereoscopicVideoRenderMode, put_StereoscopicVideoRenderMode)
    SystemMediaTransportControls = property(get_SystemMediaTransportControls, None)
    TimelineController = property(get_TimelineController, put_TimelineController)
    TimelineControllerPositionOffset = property(get_TimelineControllerPositionOffset, put_TimelineControllerPositionOffset)
    Volume = property(get_Volume, put_Volume)
    MediaOpened = event()
    MediaEnded = event()
    MediaFailed = event()
    CurrentStateChanged = event()
    PlaybackMediaMarkerReached = event()
    MediaPlayerRateChanged = event()
    VolumeChanged = event()
    SeekCompleted = event()
    BufferingStarted = event()
    BufferingEnded = event()
    IsMutedChanged = event()
    SourceChanged = event()
    VideoFrameAvailable = event()
    SubtitleFrameChanged = event()
class MediaPlayerAudioCategory(Enum, Int32):
    Other = 0
    Communications = 3
    Alerts = 4
    SoundEffects = 5
    GameEffects = 6
    GameMedia = 7
    GameChat = 8
    Speech = 9
    Movie = 10
    Media = 11
class MediaPlayerAudioDeviceType(Enum, Int32):
    Console = 0
    Multimedia = 1
    Communications = 2
class MediaPlayerDataReceivedEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IMediaPlayerDataReceivedEventArgs
    _classid_ = 'Windows.Media.Playback.MediaPlayerDataReceivedEventArgs'
    @winrt_mixinmethod
    def get_Data(self: win32more.Windows.Media.Playback.IMediaPlayerDataReceivedEventArgs) -> win32more.Windows.Foundation.Collections.ValueSet: ...
    Data = property(get_Data, None)
class MediaPlayerError(Enum, Int32):
    Unknown = 0
    Aborted = 1
    NetworkError = 2
    DecodingError = 3
    SourceNotSupported = 4
class MediaPlayerFailedEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IMediaPlayerFailedEventArgs
    _classid_ = 'Windows.Media.Playback.MediaPlayerFailedEventArgs'
    @winrt_mixinmethod
    def get_Error(self: win32more.Windows.Media.Playback.IMediaPlayerFailedEventArgs) -> win32more.Windows.Media.Playback.MediaPlayerError: ...
    @winrt_mixinmethod
    def get_ExtendedErrorCode(self: win32more.Windows.Media.Playback.IMediaPlayerFailedEventArgs) -> win32more.Windows.Foundation.HResult: ...
    @winrt_mixinmethod
    def get_ErrorMessage(self: win32more.Windows.Media.Playback.IMediaPlayerFailedEventArgs) -> WinRT_String: ...
    Error = property(get_Error, None)
    ErrorMessage = property(get_ErrorMessage, None)
    ExtendedErrorCode = property(get_ExtendedErrorCode, None)
class MediaPlayerRateChangedEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IMediaPlayerRateChangedEventArgs
    _classid_ = 'Windows.Media.Playback.MediaPlayerRateChangedEventArgs'
    @winrt_mixinmethod
    def get_NewRate(self: win32more.Windows.Media.Playback.IMediaPlayerRateChangedEventArgs) -> Double: ...
    NewRate = property(get_NewRate, None)
class MediaPlayerState(Enum, Int32):
    Closed = 0
    Opening = 1
    Buffering = 2
    Playing = 3
    Paused = 4
    Stopped = 5
class MediaPlayerSurface(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Windows.Media.Playback.IMediaPlayerSurface
    _classid_ = 'Windows.Media.Playback.MediaPlayerSurface'
    @winrt_mixinmethod
    def get_CompositionSurface(self: win32more.Windows.Media.Playback.IMediaPlayerSurface) -> win32more.Windows.UI.Composition.ICompositionSurface: ...
    @winrt_mixinmethod
    def get_Compositor(self: win32more.Windows.Media.Playback.IMediaPlayerSurface) -> win32more.Windows.UI.Composition.Compositor: ...
    @winrt_mixinmethod
    def get_MediaPlayer(self: win32more.Windows.Media.Playback.IMediaPlayerSurface) -> win32more.Windows.Media.Playback.MediaPlayer: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    CompositionSurface = property(get_CompositionSurface, None)
    Compositor = property(get_Compositor, None)
    MediaPlayer = property(get_MediaPlayer, None)
class PlaybackMediaMarker(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IPlaybackMediaMarker
    _classid_ = 'Windows.Media.Playback.PlaybackMediaMarker'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Media.Playback.PlaybackMediaMarker.CreateFromTime(*args))
        elif len(args) == 3:
            super().__init__(move=win32more.Windows.Media.Playback.PlaybackMediaMarker.Create(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def CreateFromTime(cls: win32more.Windows.Media.Playback.IPlaybackMediaMarkerFactory, value: win32more.Windows.Foundation.TimeSpan) -> win32more.Windows.Media.Playback.PlaybackMediaMarker: ...
    @winrt_factorymethod
    def Create(cls: win32more.Windows.Media.Playback.IPlaybackMediaMarkerFactory, value: win32more.Windows.Foundation.TimeSpan, mediaMarketType: WinRT_String, text: WinRT_String) -> win32more.Windows.Media.Playback.PlaybackMediaMarker: ...
    @winrt_mixinmethod
    def get_Time(self: win32more.Windows.Media.Playback.IPlaybackMediaMarker) -> win32more.Windows.Foundation.TimeSpan: ...
    @winrt_mixinmethod
    def get_MediaMarkerType(self: win32more.Windows.Media.Playback.IPlaybackMediaMarker) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_Text(self: win32more.Windows.Media.Playback.IPlaybackMediaMarker) -> WinRT_String: ...
    MediaMarkerType = property(get_MediaMarkerType, None)
    Text = property(get_Text, None)
    Time = property(get_Time, None)
class PlaybackMediaMarkerReachedEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.IPlaybackMediaMarkerReachedEventArgs
    _classid_ = 'Windows.Media.Playback.PlaybackMediaMarkerReachedEventArgs'
    @winrt_mixinmethod
    def get_PlaybackMediaMarker(self: win32more.Windows.Media.Playback.IPlaybackMediaMarkerReachedEventArgs) -> win32more.Windows.Media.Playback.PlaybackMediaMarker: ...
    PlaybackMediaMarker = property(get_PlaybackMediaMarker, None)
class PlaybackMediaMarkerSequence(ComPtr):
    extends: IInspectable
    implements: Tuple[IterableProtocol[win32more.Windows.Media.Playback.PlaybackMediaMarker]]
    default_interface: win32more.Windows.Media.Playback.IPlaybackMediaMarkerSequence
    _classid_ = 'Windows.Media.Playback.PlaybackMediaMarkerSequence'
    @winrt_mixinmethod
    def get_Size(self: win32more.Windows.Media.Playback.IPlaybackMediaMarkerSequence) -> UInt32: ...
    @winrt_mixinmethod
    def Insert(self: win32more.Windows.Media.Playback.IPlaybackMediaMarkerSequence, value: win32more.Windows.Media.Playback.PlaybackMediaMarker) -> Void: ...
    @winrt_mixinmethod
    def Clear(self: win32more.Windows.Media.Playback.IPlaybackMediaMarkerSequence) -> Void: ...
    @winrt_mixinmethod
    def First(self: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.Media.Playback.PlaybackMediaMarker]) -> win32more.Windows.Foundation.Collections.IIterator[win32more.Windows.Media.Playback.PlaybackMediaMarker]: ...
    Size = property(get_Size, None)
class SphericalVideoProjectionMode(Enum, Int32):
    Spherical = 0
    Flat = 1
class StereoscopicVideoRenderMode(Enum, Int32):
    Mono = 0
    Stereo = 1
class TimedMetadataPresentationModeChangedEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Media.Playback.ITimedMetadataPresentationModeChangedEventArgs
    _classid_ = 'Windows.Media.Playback.TimedMetadataPresentationModeChangedEventArgs'
    @winrt_mixinmethod
    def get_Track(self: win32more.Windows.Media.Playback.ITimedMetadataPresentationModeChangedEventArgs) -> win32more.Windows.Media.Core.TimedMetadataTrack: ...
    @winrt_mixinmethod
    def get_OldPresentationMode(self: win32more.Windows.Media.Playback.ITimedMetadataPresentationModeChangedEventArgs) -> win32more.Windows.Media.Playback.TimedMetadataTrackPresentationMode: ...
    @winrt_mixinmethod
    def get_NewPresentationMode(self: win32more.Windows.Media.Playback.ITimedMetadataPresentationModeChangedEventArgs) -> win32more.Windows.Media.Playback.TimedMetadataTrackPresentationMode: ...
    NewPresentationMode = property(get_NewPresentationMode, None)
    OldPresentationMode = property(get_OldPresentationMode, None)
    Track = property(get_Track, None)
class TimedMetadataTrackPresentationMode(Enum, Int32):
    Disabled = 0
    Hidden = 1
    ApplicationPresented = 2
    PlatformPresented = 3


make_ready(__name__)
