from __future__ import annotations
from win32more import ARCH, Annotated, Boolean, Byte, Bytes, Char, ComPtr, ConstantLazyLoader, Double, Enum, FAILED, FlexibleArray, Guid, Int16, Int32, Int64, IntPtr, NativeBitfieldAttribute, POINTER, SByte, SUCCEEDED, Single, String, Structure, UInt16, UInt32, UInt64, UIntPtr, UnicodeAlias, Union, Void, VoidPtr, cfunctype, cfunctype_pointer, commethod, make_ready, winfunctype, winfunctype_pointer
from win32more._winrt import AwaitableProtocol, ContextManagerProtocol, FillArray, Generic, IInspectable, IUnknown, IterableProtocol, K, MappingProtocol, MulticastDelegate, PassArray, ReceiveArray, SequenceProtocol, T, TProgress, TResult, TSender, Tuple, V, WinRT_String, event, winrt_activatemethod, winrt_classmethod, winrt_commethod, winrt_factorymethod, winrt_mixinmethod, winrt_overload
import win32more.Windows.Data.Xml.Dom
import win32more.Windows.Foundation
import win32more.Windows.Foundation.Collections
import win32more.Windows.Security.Credentials
import win32more.Windows.Web.Syndication
class ISyndicationAttribute(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Syndication.ISyndicationAttribute'
    _iid_ = Guid('{71e8f969-526e-4001-9a91-e84f83161ab1}')
    @winrt_commethod(6)
    def get_Name(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def put_Name(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(8)
    def get_Namespace(self) -> WinRT_String: ...
    @winrt_commethod(9)
    def put_Namespace(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(10)
    def get_Value(self) -> WinRT_String: ...
    @winrt_commethod(11)
    def put_Value(self, value: WinRT_String) -> Void: ...
    Name = property(get_Name, put_Name)
    Namespace = property(get_Namespace, put_Namespace)
    Value = property(get_Value, put_Value)
class ISyndicationAttributeFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Syndication.ISyndicationAttributeFactory'
    _iid_ = Guid('{624f1599-ed3e-420f-be86-640414886e4b}')
    @winrt_commethod(6)
    def CreateSyndicationAttribute(self, attributeName: WinRT_String, attributeNamespace: WinRT_String, attributeValue: WinRT_String) -> win32more.Windows.Web.Syndication.SyndicationAttribute: ...
class ISyndicationCategory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Syndication.ISyndicationCategory'
    _iid_ = Guid('{8715626f-0cba-4a7f-89ff-ecb5281423b6}')
    @winrt_commethod(6)
    def get_Label(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def put_Label(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(8)
    def get_Scheme(self) -> WinRT_String: ...
    @winrt_commethod(9)
    def put_Scheme(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(10)
    def get_Term(self) -> WinRT_String: ...
    @winrt_commethod(11)
    def put_Term(self, value: WinRT_String) -> Void: ...
    Label = property(get_Label, put_Label)
    Scheme = property(get_Scheme, put_Scheme)
    Term = property(get_Term, put_Term)
class ISyndicationCategoryFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Syndication.ISyndicationCategoryFactory'
    _iid_ = Guid('{ab42802f-49e0-4525-8ab2-ab45c02528ff}')
    @winrt_commethod(6)
    def CreateSyndicationCategory(self, term: WinRT_String) -> win32more.Windows.Web.Syndication.SyndicationCategory: ...
    @winrt_commethod(7)
    def CreateSyndicationCategoryEx(self, term: WinRT_String, scheme: WinRT_String, label: WinRT_String) -> win32more.Windows.Web.Syndication.SyndicationCategory: ...
class ISyndicationClient(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Syndication.ISyndicationClient'
    _iid_ = Guid('{9e18a9b7-7249-4b45-b229-7df895a5a1f5}')
    @winrt_commethod(6)
    def get_ServerCredential(self) -> win32more.Windows.Security.Credentials.PasswordCredential: ...
    @winrt_commethod(7)
    def put_ServerCredential(self, value: win32more.Windows.Security.Credentials.PasswordCredential) -> Void: ...
    @winrt_commethod(8)
    def get_ProxyCredential(self) -> win32more.Windows.Security.Credentials.PasswordCredential: ...
    @winrt_commethod(9)
    def put_ProxyCredential(self, value: win32more.Windows.Security.Credentials.PasswordCredential) -> Void: ...
    @winrt_commethod(10)
    def get_MaxResponseBufferSize(self) -> UInt32: ...
    @winrt_commethod(11)
    def put_MaxResponseBufferSize(self, value: UInt32) -> Void: ...
    @winrt_commethod(12)
    def get_Timeout(self) -> UInt32: ...
    @winrt_commethod(13)
    def put_Timeout(self, value: UInt32) -> Void: ...
    @winrt_commethod(14)
    def get_BypassCacheOnRetrieve(self) -> Boolean: ...
    @winrt_commethod(15)
    def put_BypassCacheOnRetrieve(self, value: Boolean) -> Void: ...
    @winrt_commethod(16)
    def SetRequestHeader(self, name: WinRT_String, value: WinRT_String) -> Void: ...
    @winrt_commethod(17)
    def RetrieveFeedAsync(self, uri: win32more.Windows.Foundation.Uri) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Web.Syndication.SyndicationFeed, win32more.Windows.Web.Syndication.RetrievalProgress]: ...
    BypassCacheOnRetrieve = property(get_BypassCacheOnRetrieve, put_BypassCacheOnRetrieve)
    MaxResponseBufferSize = property(get_MaxResponseBufferSize, put_MaxResponseBufferSize)
    ProxyCredential = property(get_ProxyCredential, put_ProxyCredential)
    ServerCredential = property(get_ServerCredential, put_ServerCredential)
    Timeout = property(get_Timeout, put_Timeout)
class ISyndicationClientFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Syndication.ISyndicationClientFactory'
    _iid_ = Guid('{2ec4b32c-a79b-4114-b29a-05dffbafb9a4}')
    @winrt_commethod(6)
    def CreateSyndicationClient(self, serverCredential: win32more.Windows.Security.Credentials.PasswordCredential) -> win32more.Windows.Web.Syndication.SyndicationClient: ...
class ISyndicationContent(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Syndication.ISyndicationContent'
    _iid_ = Guid('{4641fefe-0e55-40d0-b8d0-6a2ccba9fc7c}')
    @winrt_commethod(6)
    def get_SourceUri(self) -> win32more.Windows.Foundation.Uri: ...
    @winrt_commethod(7)
    def put_SourceUri(self, value: win32more.Windows.Foundation.Uri) -> Void: ...
    SourceUri = property(get_SourceUri, put_SourceUri)
class ISyndicationContentFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Syndication.ISyndicationContentFactory'
    _iid_ = Guid('{3d2fbb93-9520-4173-9388-7e2df324a8a0}')
    @winrt_commethod(6)
    def CreateSyndicationContent(self, text: WinRT_String, type: win32more.Windows.Web.Syndication.SyndicationTextType) -> win32more.Windows.Web.Syndication.SyndicationContent: ...
    @winrt_commethod(7)
    def CreateSyndicationContentWithSourceUri(self, sourceUri: win32more.Windows.Foundation.Uri) -> win32more.Windows.Web.Syndication.SyndicationContent: ...
class ISyndicationErrorStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Syndication.ISyndicationErrorStatics'
    _iid_ = Guid('{1fbb2361-45c7-4833-8aa0-be5f3b58a7f4}')
    @winrt_commethod(6)
    def GetStatus(self, hresult: Int32) -> win32more.Windows.Web.Syndication.SyndicationErrorStatus: ...
class ISyndicationFeed(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Syndication.ISyndicationFeed'
    _iid_ = Guid('{7ffe3cd2-5b66-4d62-8403-1bc10d910d6b}')
    @winrt_commethod(6)
    def get_Authors(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.SyndicationPerson]: ...
    @winrt_commethod(7)
    def get_Categories(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.SyndicationCategory]: ...
    @winrt_commethod(8)
    def get_Contributors(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.SyndicationPerson]: ...
    @winrt_commethod(9)
    def get_Generator(self) -> win32more.Windows.Web.Syndication.SyndicationGenerator: ...
    @winrt_commethod(10)
    def put_Generator(self, value: win32more.Windows.Web.Syndication.SyndicationGenerator) -> Void: ...
    @winrt_commethod(11)
    def get_IconUri(self) -> win32more.Windows.Foundation.Uri: ...
    @winrt_commethod(12)
    def put_IconUri(self, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_commethod(13)
    def get_Id(self) -> WinRT_String: ...
    @winrt_commethod(14)
    def put_Id(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(15)
    def get_Items(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.SyndicationItem]: ...
    @winrt_commethod(16)
    def get_LastUpdatedTime(self) -> win32more.Windows.Foundation.DateTime: ...
    @winrt_commethod(17)
    def put_LastUpdatedTime(self, value: win32more.Windows.Foundation.DateTime) -> Void: ...
    @winrt_commethod(18)
    def get_Links(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.SyndicationLink]: ...
    @winrt_commethod(19)
    def get_ImageUri(self) -> win32more.Windows.Foundation.Uri: ...
    @winrt_commethod(20)
    def put_ImageUri(self, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_commethod(21)
    def get_Rights(self) -> win32more.Windows.Web.Syndication.ISyndicationText: ...
    @winrt_commethod(22)
    def put_Rights(self, value: win32more.Windows.Web.Syndication.ISyndicationText) -> Void: ...
    @winrt_commethod(23)
    def get_Subtitle(self) -> win32more.Windows.Web.Syndication.ISyndicationText: ...
    @winrt_commethod(24)
    def put_Subtitle(self, value: win32more.Windows.Web.Syndication.ISyndicationText) -> Void: ...
    @winrt_commethod(25)
    def get_Title(self) -> win32more.Windows.Web.Syndication.ISyndicationText: ...
    @winrt_commethod(26)
    def put_Title(self, value: win32more.Windows.Web.Syndication.ISyndicationText) -> Void: ...
    @winrt_commethod(27)
    def get_FirstUri(self) -> win32more.Windows.Foundation.Uri: ...
    @winrt_commethod(28)
    def get_LastUri(self) -> win32more.Windows.Foundation.Uri: ...
    @winrt_commethod(29)
    def get_NextUri(self) -> win32more.Windows.Foundation.Uri: ...
    @winrt_commethod(30)
    def get_PreviousUri(self) -> win32more.Windows.Foundation.Uri: ...
    @winrt_commethod(31)
    def get_SourceFormat(self) -> win32more.Windows.Web.Syndication.SyndicationFormat: ...
    @winrt_commethod(32)
    def Load(self, feed: WinRT_String) -> Void: ...
    @winrt_commethod(33)
    def LoadFromXml(self, feedDocument: win32more.Windows.Data.Xml.Dom.XmlDocument) -> Void: ...
    Authors = property(get_Authors, None)
    Categories = property(get_Categories, None)
    Contributors = property(get_Contributors, None)
    FirstUri = property(get_FirstUri, None)
    Generator = property(get_Generator, put_Generator)
    IconUri = property(get_IconUri, put_IconUri)
    Id = property(get_Id, put_Id)
    ImageUri = property(get_ImageUri, put_ImageUri)
    Items = property(get_Items, None)
    LastUpdatedTime = property(get_LastUpdatedTime, put_LastUpdatedTime)
    LastUri = property(get_LastUri, None)
    Links = property(get_Links, None)
    NextUri = property(get_NextUri, None)
    PreviousUri = property(get_PreviousUri, None)
    Rights = property(get_Rights, put_Rights)
    SourceFormat = property(get_SourceFormat, None)
    Subtitle = property(get_Subtitle, put_Subtitle)
    Title = property(get_Title, put_Title)
class ISyndicationFeedFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Syndication.ISyndicationFeedFactory'
    _iid_ = Guid('{23472232-8be9-48b7-8934-6205131d9357}')
    @winrt_commethod(6)
    def CreateSyndicationFeed(self, title: WinRT_String, subtitle: WinRT_String, uri: win32more.Windows.Foundation.Uri) -> win32more.Windows.Web.Syndication.SyndicationFeed: ...
class ISyndicationGenerator(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Syndication.ISyndicationGenerator'
    _iid_ = Guid('{9768b379-fb2b-4f6d-b41c-088a5868825c}')
    @winrt_commethod(6)
    def get_Text(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def put_Text(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(8)
    def get_Uri(self) -> win32more.Windows.Foundation.Uri: ...
    @winrt_commethod(9)
    def put_Uri(self, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_commethod(10)
    def get_Version(self) -> WinRT_String: ...
    @winrt_commethod(11)
    def put_Version(self, value: WinRT_String) -> Void: ...
    Text = property(get_Text, put_Text)
    Uri = property(get_Uri, put_Uri)
    Version = property(get_Version, put_Version)
class ISyndicationGeneratorFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Syndication.ISyndicationGeneratorFactory'
    _iid_ = Guid('{a34083e3-1e26-4dbc-ba9d-1ab84beff97b}')
    @winrt_commethod(6)
    def CreateSyndicationGenerator(self, text: WinRT_String) -> win32more.Windows.Web.Syndication.SyndicationGenerator: ...
class ISyndicationItem(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Syndication.ISyndicationItem'
    _iid_ = Guid('{548db883-c384-45c1-8ae8-a378c4ec486c}')
    @winrt_commethod(6)
    def get_Authors(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.SyndicationPerson]: ...
    @winrt_commethod(7)
    def get_Categories(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.SyndicationCategory]: ...
    @winrt_commethod(8)
    def get_Contributors(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.SyndicationPerson]: ...
    @winrt_commethod(9)
    def get_Content(self) -> win32more.Windows.Web.Syndication.SyndicationContent: ...
    @winrt_commethod(10)
    def put_Content(self, value: win32more.Windows.Web.Syndication.SyndicationContent) -> Void: ...
    @winrt_commethod(11)
    def get_Id(self) -> WinRT_String: ...
    @winrt_commethod(12)
    def put_Id(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(13)
    def get_LastUpdatedTime(self) -> win32more.Windows.Foundation.DateTime: ...
    @winrt_commethod(14)
    def put_LastUpdatedTime(self, value: win32more.Windows.Foundation.DateTime) -> Void: ...
    @winrt_commethod(15)
    def get_Links(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.SyndicationLink]: ...
    @winrt_commethod(16)
    def get_PublishedDate(self) -> win32more.Windows.Foundation.DateTime: ...
    @winrt_commethod(17)
    def put_PublishedDate(self, value: win32more.Windows.Foundation.DateTime) -> Void: ...
    @winrt_commethod(18)
    def get_Rights(self) -> win32more.Windows.Web.Syndication.ISyndicationText: ...
    @winrt_commethod(19)
    def put_Rights(self, value: win32more.Windows.Web.Syndication.ISyndicationText) -> Void: ...
    @winrt_commethod(20)
    def get_Source(self) -> win32more.Windows.Web.Syndication.SyndicationFeed: ...
    @winrt_commethod(21)
    def put_Source(self, value: win32more.Windows.Web.Syndication.SyndicationFeed) -> Void: ...
    @winrt_commethod(22)
    def get_Summary(self) -> win32more.Windows.Web.Syndication.ISyndicationText: ...
    @winrt_commethod(23)
    def put_Summary(self, value: win32more.Windows.Web.Syndication.ISyndicationText) -> Void: ...
    @winrt_commethod(24)
    def get_Title(self) -> win32more.Windows.Web.Syndication.ISyndicationText: ...
    @winrt_commethod(25)
    def put_Title(self, value: win32more.Windows.Web.Syndication.ISyndicationText) -> Void: ...
    @winrt_commethod(26)
    def get_CommentsUri(self) -> win32more.Windows.Foundation.Uri: ...
    @winrt_commethod(27)
    def put_CommentsUri(self, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_commethod(28)
    def get_EditUri(self) -> win32more.Windows.Foundation.Uri: ...
    @winrt_commethod(29)
    def get_EditMediaUri(self) -> win32more.Windows.Foundation.Uri: ...
    @winrt_commethod(30)
    def get_ETag(self) -> WinRT_String: ...
    @winrt_commethod(31)
    def get_ItemUri(self) -> win32more.Windows.Foundation.Uri: ...
    @winrt_commethod(32)
    def Load(self, item: WinRT_String) -> Void: ...
    @winrt_commethod(33)
    def LoadFromXml(self, itemDocument: win32more.Windows.Data.Xml.Dom.XmlDocument) -> Void: ...
    Authors = property(get_Authors, None)
    Categories = property(get_Categories, None)
    CommentsUri = property(get_CommentsUri, put_CommentsUri)
    Content = property(get_Content, put_Content)
    Contributors = property(get_Contributors, None)
    ETag = property(get_ETag, None)
    EditMediaUri = property(get_EditMediaUri, None)
    EditUri = property(get_EditUri, None)
    Id = property(get_Id, put_Id)
    ItemUri = property(get_ItemUri, None)
    LastUpdatedTime = property(get_LastUpdatedTime, put_LastUpdatedTime)
    Links = property(get_Links, None)
    PublishedDate = property(get_PublishedDate, put_PublishedDate)
    Rights = property(get_Rights, put_Rights)
    Source = property(get_Source, put_Source)
    Summary = property(get_Summary, put_Summary)
    Title = property(get_Title, put_Title)
class ISyndicationItemFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Syndication.ISyndicationItemFactory'
    _iid_ = Guid('{251d434f-7db8-487a-85e4-10d191e66ebb}')
    @winrt_commethod(6)
    def CreateSyndicationItem(self, title: WinRT_String, content: win32more.Windows.Web.Syndication.SyndicationContent, uri: win32more.Windows.Foundation.Uri) -> win32more.Windows.Web.Syndication.SyndicationItem: ...
class ISyndicationLink(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Syndication.ISyndicationLink'
    _iid_ = Guid('{27553abd-a10e-41b5-86bd-9759086eb0c5}')
    @winrt_commethod(6)
    def get_Length(self) -> UInt32: ...
    @winrt_commethod(7)
    def put_Length(self, value: UInt32) -> Void: ...
    @winrt_commethod(8)
    def get_MediaType(self) -> WinRT_String: ...
    @winrt_commethod(9)
    def put_MediaType(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(10)
    def get_Relationship(self) -> WinRT_String: ...
    @winrt_commethod(11)
    def put_Relationship(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(12)
    def get_Title(self) -> WinRT_String: ...
    @winrt_commethod(13)
    def put_Title(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(14)
    def get_Uri(self) -> win32more.Windows.Foundation.Uri: ...
    @winrt_commethod(15)
    def put_Uri(self, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_commethod(16)
    def get_ResourceLanguage(self) -> WinRT_String: ...
    @winrt_commethod(17)
    def put_ResourceLanguage(self, value: WinRT_String) -> Void: ...
    Length = property(get_Length, put_Length)
    MediaType = property(get_MediaType, put_MediaType)
    Relationship = property(get_Relationship, put_Relationship)
    ResourceLanguage = property(get_ResourceLanguage, put_ResourceLanguage)
    Title = property(get_Title, put_Title)
    Uri = property(get_Uri, put_Uri)
class ISyndicationLinkFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Syndication.ISyndicationLinkFactory'
    _iid_ = Guid('{5ed863d4-5535-48ac-98d4-c190995080b3}')
    @winrt_commethod(6)
    def CreateSyndicationLink(self, uri: win32more.Windows.Foundation.Uri) -> win32more.Windows.Web.Syndication.SyndicationLink: ...
    @winrt_commethod(7)
    def CreateSyndicationLinkEx(self, uri: win32more.Windows.Foundation.Uri, relationship: WinRT_String, title: WinRT_String, mediaType: WinRT_String, length: UInt32) -> win32more.Windows.Web.Syndication.SyndicationLink: ...
class ISyndicationNode(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Syndication.ISyndicationNode'
    _iid_ = Guid('{753cef78-51f8-45c0-a9f5-f1719dec3fb2}')
    @winrt_commethod(6)
    def get_NodeName(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def put_NodeName(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(8)
    def get_NodeNamespace(self) -> WinRT_String: ...
    @winrt_commethod(9)
    def put_NodeNamespace(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(10)
    def get_NodeValue(self) -> WinRT_String: ...
    @winrt_commethod(11)
    def put_NodeValue(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(12)
    def get_Language(self) -> WinRT_String: ...
    @winrt_commethod(13)
    def put_Language(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(14)
    def get_BaseUri(self) -> win32more.Windows.Foundation.Uri: ...
    @winrt_commethod(15)
    def put_BaseUri(self, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_commethod(16)
    def get_AttributeExtensions(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.SyndicationAttribute]: ...
    @winrt_commethod(17)
    def get_ElementExtensions(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.ISyndicationNode]: ...
    @winrt_commethod(18)
    def GetXmlDocument(self, format: win32more.Windows.Web.Syndication.SyndicationFormat) -> win32more.Windows.Data.Xml.Dom.XmlDocument: ...
    AttributeExtensions = property(get_AttributeExtensions, None)
    BaseUri = property(get_BaseUri, put_BaseUri)
    ElementExtensions = property(get_ElementExtensions, None)
    Language = property(get_Language, put_Language)
    NodeName = property(get_NodeName, put_NodeName)
    NodeNamespace = property(get_NodeNamespace, put_NodeNamespace)
    NodeValue = property(get_NodeValue, put_NodeValue)
class ISyndicationNodeFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Syndication.ISyndicationNodeFactory'
    _iid_ = Guid('{12902188-4acb-49a8-b777-a5eb92e18a79}')
    @winrt_commethod(6)
    def CreateSyndicationNode(self, nodeName: WinRT_String, nodeNamespace: WinRT_String, nodeValue: WinRT_String) -> win32more.Windows.Web.Syndication.SyndicationNode: ...
class ISyndicationPerson(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Syndication.ISyndicationPerson'
    _iid_ = Guid('{fa1ee5da-a7c6-4517-a096-0143faf29327}')
    @winrt_commethod(6)
    def get_Email(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def put_Email(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(8)
    def get_Name(self) -> WinRT_String: ...
    @winrt_commethod(9)
    def put_Name(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(10)
    def get_Uri(self) -> win32more.Windows.Foundation.Uri: ...
    @winrt_commethod(11)
    def put_Uri(self, value: win32more.Windows.Foundation.Uri) -> Void: ...
    Email = property(get_Email, put_Email)
    Name = property(get_Name, put_Name)
    Uri = property(get_Uri, put_Uri)
class ISyndicationPersonFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Syndication.ISyndicationPersonFactory'
    _iid_ = Guid('{dcf4886d-229d-4b58-a49b-f3d2f0f5c99f}')
    @winrt_commethod(6)
    def CreateSyndicationPerson(self, name: WinRT_String) -> win32more.Windows.Web.Syndication.SyndicationPerson: ...
    @winrt_commethod(7)
    def CreateSyndicationPersonEx(self, name: WinRT_String, email: WinRT_String, uri: win32more.Windows.Foundation.Uri) -> win32more.Windows.Web.Syndication.SyndicationPerson: ...
class ISyndicationText(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Syndication.ISyndicationText'
    _iid_ = Guid('{b9cc5e80-313a-4091-a2a6-243e0ee923f9}')
    @winrt_commethod(6)
    def get_Text(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def put_Text(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(8)
    def get_Type(self) -> WinRT_String: ...
    @winrt_commethod(9)
    def put_Type(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(10)
    def get_Xml(self) -> win32more.Windows.Data.Xml.Dom.XmlDocument: ...
    @winrt_commethod(11)
    def put_Xml(self, value: win32more.Windows.Data.Xml.Dom.XmlDocument) -> Void: ...
    Text = property(get_Text, put_Text)
    Type = property(get_Type, put_Type)
    Xml = property(get_Xml, put_Xml)
class ISyndicationTextFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Syndication.ISyndicationTextFactory'
    _iid_ = Guid('{ee7342f7-11c6-4b25-ab62-e596bd162946}')
    @winrt_commethod(6)
    def CreateSyndicationText(self, text: WinRT_String) -> win32more.Windows.Web.Syndication.SyndicationText: ...
    @winrt_commethod(7)
    def CreateSyndicationTextEx(self, text: WinRT_String, type: win32more.Windows.Web.Syndication.SyndicationTextType) -> win32more.Windows.Web.Syndication.SyndicationText: ...
class RetrievalProgress(Structure):
    BytesRetrieved: UInt32
    TotalBytesToRetrieve: UInt32
class SyndicationAttribute(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Web.Syndication.ISyndicationAttribute
    _classid_ = 'Windows.Web.Syndication.SyndicationAttribute'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.Web.Syndication.SyndicationAttribute.CreateInstance(*args))
        elif len(args) == 3:
            super().__init__(move=win32more.Windows.Web.Syndication.SyndicationAttribute.CreateSyndicationAttribute(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.Web.Syndication.SyndicationAttribute: ...
    @winrt_factorymethod
    def CreateSyndicationAttribute(cls: win32more.Windows.Web.Syndication.ISyndicationAttributeFactory, attributeName: WinRT_String, attributeNamespace: WinRT_String, attributeValue: WinRT_String) -> win32more.Windows.Web.Syndication.SyndicationAttribute: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Web.Syndication.ISyndicationAttribute) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Web.Syndication.ISyndicationAttribute, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Namespace(self: win32more.Windows.Web.Syndication.ISyndicationAttribute) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Namespace(self: win32more.Windows.Web.Syndication.ISyndicationAttribute, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Value(self: win32more.Windows.Web.Syndication.ISyndicationAttribute) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Value(self: win32more.Windows.Web.Syndication.ISyndicationAttribute, value: WinRT_String) -> Void: ...
    Name = property(get_Name, put_Name)
    Namespace = property(get_Namespace, put_Namespace)
    Value = property(get_Value, put_Value)
class SyndicationCategory(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Web.Syndication.ISyndicationCategory
    _classid_ = 'Windows.Web.Syndication.SyndicationCategory'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.Web.Syndication.SyndicationCategory.CreateInstance(*args))
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Web.Syndication.SyndicationCategory.CreateSyndicationCategory(*args))
        elif len(args) == 3:
            super().__init__(move=win32more.Windows.Web.Syndication.SyndicationCategory.CreateSyndicationCategoryEx(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.Web.Syndication.SyndicationCategory: ...
    @winrt_factorymethod
    def CreateSyndicationCategory(cls: win32more.Windows.Web.Syndication.ISyndicationCategoryFactory, term: WinRT_String) -> win32more.Windows.Web.Syndication.SyndicationCategory: ...
    @winrt_factorymethod
    def CreateSyndicationCategoryEx(cls: win32more.Windows.Web.Syndication.ISyndicationCategoryFactory, term: WinRT_String, scheme: WinRT_String, label: WinRT_String) -> win32more.Windows.Web.Syndication.SyndicationCategory: ...
    @winrt_mixinmethod
    def get_Label(self: win32more.Windows.Web.Syndication.ISyndicationCategory) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Label(self: win32more.Windows.Web.Syndication.ISyndicationCategory, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Scheme(self: win32more.Windows.Web.Syndication.ISyndicationCategory) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Scheme(self: win32more.Windows.Web.Syndication.ISyndicationCategory, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Term(self: win32more.Windows.Web.Syndication.ISyndicationCategory) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Term(self: win32more.Windows.Web.Syndication.ISyndicationCategory, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_NodeName(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_NodeName(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_NodeNamespace(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_NodeNamespace(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_NodeValue(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_NodeValue(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Language(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Language(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_BaseUri(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def put_BaseUri(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_mixinmethod
    def get_AttributeExtensions(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.SyndicationAttribute]: ...
    @winrt_mixinmethod
    def get_ElementExtensions(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.ISyndicationNode]: ...
    @winrt_mixinmethod
    def GetXmlDocument(self: win32more.Windows.Web.Syndication.ISyndicationNode, format: win32more.Windows.Web.Syndication.SyndicationFormat) -> win32more.Windows.Data.Xml.Dom.XmlDocument: ...
    AttributeExtensions = property(get_AttributeExtensions, None)
    BaseUri = property(get_BaseUri, put_BaseUri)
    ElementExtensions = property(get_ElementExtensions, None)
    Label = property(get_Label, put_Label)
    Language = property(get_Language, put_Language)
    NodeName = property(get_NodeName, put_NodeName)
    NodeNamespace = property(get_NodeNamespace, put_NodeNamespace)
    NodeValue = property(get_NodeValue, put_NodeValue)
    Scheme = property(get_Scheme, put_Scheme)
    Term = property(get_Term, put_Term)
class SyndicationClient(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Web.Syndication.ISyndicationClient
    _classid_ = 'Windows.Web.Syndication.SyndicationClient'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.Web.Syndication.SyndicationClient.CreateInstance(*args))
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Web.Syndication.SyndicationClient.CreateSyndicationClient(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.Web.Syndication.SyndicationClient: ...
    @winrt_factorymethod
    def CreateSyndicationClient(cls: win32more.Windows.Web.Syndication.ISyndicationClientFactory, serverCredential: win32more.Windows.Security.Credentials.PasswordCredential) -> win32more.Windows.Web.Syndication.SyndicationClient: ...
    @winrt_mixinmethod
    def get_ServerCredential(self: win32more.Windows.Web.Syndication.ISyndicationClient) -> win32more.Windows.Security.Credentials.PasswordCredential: ...
    @winrt_mixinmethod
    def put_ServerCredential(self: win32more.Windows.Web.Syndication.ISyndicationClient, value: win32more.Windows.Security.Credentials.PasswordCredential) -> Void: ...
    @winrt_mixinmethod
    def get_ProxyCredential(self: win32more.Windows.Web.Syndication.ISyndicationClient) -> win32more.Windows.Security.Credentials.PasswordCredential: ...
    @winrt_mixinmethod
    def put_ProxyCredential(self: win32more.Windows.Web.Syndication.ISyndicationClient, value: win32more.Windows.Security.Credentials.PasswordCredential) -> Void: ...
    @winrt_mixinmethod
    def get_MaxResponseBufferSize(self: win32more.Windows.Web.Syndication.ISyndicationClient) -> UInt32: ...
    @winrt_mixinmethod
    def put_MaxResponseBufferSize(self: win32more.Windows.Web.Syndication.ISyndicationClient, value: UInt32) -> Void: ...
    @winrt_mixinmethod
    def get_Timeout(self: win32more.Windows.Web.Syndication.ISyndicationClient) -> UInt32: ...
    @winrt_mixinmethod
    def put_Timeout(self: win32more.Windows.Web.Syndication.ISyndicationClient, value: UInt32) -> Void: ...
    @winrt_mixinmethod
    def get_BypassCacheOnRetrieve(self: win32more.Windows.Web.Syndication.ISyndicationClient) -> Boolean: ...
    @winrt_mixinmethod
    def put_BypassCacheOnRetrieve(self: win32more.Windows.Web.Syndication.ISyndicationClient, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def SetRequestHeader(self: win32more.Windows.Web.Syndication.ISyndicationClient, name: WinRT_String, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def RetrieveFeedAsync(self: win32more.Windows.Web.Syndication.ISyndicationClient, uri: win32more.Windows.Foundation.Uri) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Web.Syndication.SyndicationFeed, win32more.Windows.Web.Syndication.RetrievalProgress]: ...
    BypassCacheOnRetrieve = property(get_BypassCacheOnRetrieve, put_BypassCacheOnRetrieve)
    MaxResponseBufferSize = property(get_MaxResponseBufferSize, put_MaxResponseBufferSize)
    ProxyCredential = property(get_ProxyCredential, put_ProxyCredential)
    ServerCredential = property(get_ServerCredential, put_ServerCredential)
    Timeout = property(get_Timeout, put_Timeout)
class SyndicationContent(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Web.Syndication.ISyndicationContent
    _classid_ = 'Windows.Web.Syndication.SyndicationContent'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.Web.Syndication.SyndicationContent.CreateInstance(*args))
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Web.Syndication.SyndicationContent.CreateSyndicationContentWithSourceUri(*args))
        elif len(args) == 2:
            super().__init__(move=win32more.Windows.Web.Syndication.SyndicationContent.CreateSyndicationContent(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.Web.Syndication.SyndicationContent: ...
    @winrt_factorymethod
    def CreateSyndicationContentWithSourceUri(cls: win32more.Windows.Web.Syndication.ISyndicationContentFactory, sourceUri: win32more.Windows.Foundation.Uri) -> win32more.Windows.Web.Syndication.SyndicationContent: ...
    @winrt_factorymethod
    def CreateSyndicationContent(cls: win32more.Windows.Web.Syndication.ISyndicationContentFactory, text: WinRT_String, type: win32more.Windows.Web.Syndication.SyndicationTextType) -> win32more.Windows.Web.Syndication.SyndicationContent: ...
    @winrt_mixinmethod
    def get_Text(self: win32more.Windows.Web.Syndication.ISyndicationText) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Text(self: win32more.Windows.Web.Syndication.ISyndicationText, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Type(self: win32more.Windows.Web.Syndication.ISyndicationText) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Type(self: win32more.Windows.Web.Syndication.ISyndicationText, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Xml(self: win32more.Windows.Web.Syndication.ISyndicationText) -> win32more.Windows.Data.Xml.Dom.XmlDocument: ...
    @winrt_mixinmethod
    def put_Xml(self: win32more.Windows.Web.Syndication.ISyndicationText, value: win32more.Windows.Data.Xml.Dom.XmlDocument) -> Void: ...
    @winrt_mixinmethod
    def get_NodeName(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_NodeName(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_NodeNamespace(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_NodeNamespace(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_NodeValue(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_NodeValue(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Language(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Language(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_BaseUri(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def put_BaseUri(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_mixinmethod
    def get_AttributeExtensions(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.SyndicationAttribute]: ...
    @winrt_mixinmethod
    def get_ElementExtensions(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.ISyndicationNode]: ...
    @winrt_mixinmethod
    def GetXmlDocument(self: win32more.Windows.Web.Syndication.ISyndicationNode, format: win32more.Windows.Web.Syndication.SyndicationFormat) -> win32more.Windows.Data.Xml.Dom.XmlDocument: ...
    @winrt_mixinmethod
    def get_SourceUri(self: win32more.Windows.Web.Syndication.ISyndicationContent) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def put_SourceUri(self: win32more.Windows.Web.Syndication.ISyndicationContent, value: win32more.Windows.Foundation.Uri) -> Void: ...
    AttributeExtensions = property(get_AttributeExtensions, None)
    BaseUri = property(get_BaseUri, put_BaseUri)
    ElementExtensions = property(get_ElementExtensions, None)
    Language = property(get_Language, put_Language)
    NodeName = property(get_NodeName, put_NodeName)
    NodeNamespace = property(get_NodeNamespace, put_NodeNamespace)
    NodeValue = property(get_NodeValue, put_NodeValue)
    SourceUri = property(get_SourceUri, put_SourceUri)
    Text = property(get_Text, put_Text)
    Type = property(get_Type, put_Type)
    Xml = property(get_Xml, put_Xml)
class SyndicationError(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Web.Syndication.SyndicationError'
    @winrt_classmethod
    def GetStatus(cls: win32more.Windows.Web.Syndication.ISyndicationErrorStatics, hresult: Int32) -> win32more.Windows.Web.Syndication.SyndicationErrorStatus: ...
class SyndicationErrorStatus(Enum, Int32):
    Unknown = 0
    MissingRequiredElement = 1
    MissingRequiredAttribute = 2
    InvalidXml = 3
    UnexpectedContent = 4
    UnsupportedFormat = 5
class SyndicationFeed(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Web.Syndication.ISyndicationFeed
    _classid_ = 'Windows.Web.Syndication.SyndicationFeed'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.Web.Syndication.SyndicationFeed.CreateInstance(*args))
        elif len(args) == 3:
            super().__init__(move=win32more.Windows.Web.Syndication.SyndicationFeed.CreateSyndicationFeed(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.Web.Syndication.SyndicationFeed: ...
    @winrt_factorymethod
    def CreateSyndicationFeed(cls: win32more.Windows.Web.Syndication.ISyndicationFeedFactory, title: WinRT_String, subtitle: WinRT_String, uri: win32more.Windows.Foundation.Uri) -> win32more.Windows.Web.Syndication.SyndicationFeed: ...
    @winrt_mixinmethod
    def get_Authors(self: win32more.Windows.Web.Syndication.ISyndicationFeed) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.SyndicationPerson]: ...
    @winrt_mixinmethod
    def get_Categories(self: win32more.Windows.Web.Syndication.ISyndicationFeed) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.SyndicationCategory]: ...
    @winrt_mixinmethod
    def get_Contributors(self: win32more.Windows.Web.Syndication.ISyndicationFeed) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.SyndicationPerson]: ...
    @winrt_mixinmethod
    def get_Generator(self: win32more.Windows.Web.Syndication.ISyndicationFeed) -> win32more.Windows.Web.Syndication.SyndicationGenerator: ...
    @winrt_mixinmethod
    def put_Generator(self: win32more.Windows.Web.Syndication.ISyndicationFeed, value: win32more.Windows.Web.Syndication.SyndicationGenerator) -> Void: ...
    @winrt_mixinmethod
    def get_IconUri(self: win32more.Windows.Web.Syndication.ISyndicationFeed) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def put_IconUri(self: win32more.Windows.Web.Syndication.ISyndicationFeed, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_mixinmethod
    def get_Id(self: win32more.Windows.Web.Syndication.ISyndicationFeed) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Id(self: win32more.Windows.Web.Syndication.ISyndicationFeed, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Items(self: win32more.Windows.Web.Syndication.ISyndicationFeed) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.SyndicationItem]: ...
    @winrt_mixinmethod
    def get_LastUpdatedTime(self: win32more.Windows.Web.Syndication.ISyndicationFeed) -> win32more.Windows.Foundation.DateTime: ...
    @winrt_mixinmethod
    def put_LastUpdatedTime(self: win32more.Windows.Web.Syndication.ISyndicationFeed, value: win32more.Windows.Foundation.DateTime) -> Void: ...
    @winrt_mixinmethod
    def get_Links(self: win32more.Windows.Web.Syndication.ISyndicationFeed) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.SyndicationLink]: ...
    @winrt_mixinmethod
    def get_ImageUri(self: win32more.Windows.Web.Syndication.ISyndicationFeed) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def put_ImageUri(self: win32more.Windows.Web.Syndication.ISyndicationFeed, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_mixinmethod
    def get_Rights(self: win32more.Windows.Web.Syndication.ISyndicationFeed) -> win32more.Windows.Web.Syndication.ISyndicationText: ...
    @winrt_mixinmethod
    def put_Rights(self: win32more.Windows.Web.Syndication.ISyndicationFeed, value: win32more.Windows.Web.Syndication.ISyndicationText) -> Void: ...
    @winrt_mixinmethod
    def get_Subtitle(self: win32more.Windows.Web.Syndication.ISyndicationFeed) -> win32more.Windows.Web.Syndication.ISyndicationText: ...
    @winrt_mixinmethod
    def put_Subtitle(self: win32more.Windows.Web.Syndication.ISyndicationFeed, value: win32more.Windows.Web.Syndication.ISyndicationText) -> Void: ...
    @winrt_mixinmethod
    def get_Title(self: win32more.Windows.Web.Syndication.ISyndicationFeed) -> win32more.Windows.Web.Syndication.ISyndicationText: ...
    @winrt_mixinmethod
    def put_Title(self: win32more.Windows.Web.Syndication.ISyndicationFeed, value: win32more.Windows.Web.Syndication.ISyndicationText) -> Void: ...
    @winrt_mixinmethod
    def get_FirstUri(self: win32more.Windows.Web.Syndication.ISyndicationFeed) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def get_LastUri(self: win32more.Windows.Web.Syndication.ISyndicationFeed) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def get_NextUri(self: win32more.Windows.Web.Syndication.ISyndicationFeed) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def get_PreviousUri(self: win32more.Windows.Web.Syndication.ISyndicationFeed) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def get_SourceFormat(self: win32more.Windows.Web.Syndication.ISyndicationFeed) -> win32more.Windows.Web.Syndication.SyndicationFormat: ...
    @winrt_mixinmethod
    def Load(self: win32more.Windows.Web.Syndication.ISyndicationFeed, feed: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def LoadFromXml(self: win32more.Windows.Web.Syndication.ISyndicationFeed, feedDocument: win32more.Windows.Data.Xml.Dom.XmlDocument) -> Void: ...
    @winrt_mixinmethod
    def get_NodeName(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_NodeName(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_NodeNamespace(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_NodeNamespace(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_NodeValue(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_NodeValue(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Language(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Language(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_BaseUri(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def put_BaseUri(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_mixinmethod
    def get_AttributeExtensions(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.SyndicationAttribute]: ...
    @winrt_mixinmethod
    def get_ElementExtensions(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.ISyndicationNode]: ...
    @winrt_mixinmethod
    def GetXmlDocument(self: win32more.Windows.Web.Syndication.ISyndicationNode, format: win32more.Windows.Web.Syndication.SyndicationFormat) -> win32more.Windows.Data.Xml.Dom.XmlDocument: ...
    AttributeExtensions = property(get_AttributeExtensions, None)
    Authors = property(get_Authors, None)
    BaseUri = property(get_BaseUri, put_BaseUri)
    Categories = property(get_Categories, None)
    Contributors = property(get_Contributors, None)
    ElementExtensions = property(get_ElementExtensions, None)
    FirstUri = property(get_FirstUri, None)
    Generator = property(get_Generator, put_Generator)
    IconUri = property(get_IconUri, put_IconUri)
    Id = property(get_Id, put_Id)
    ImageUri = property(get_ImageUri, put_ImageUri)
    Items = property(get_Items, None)
    Language = property(get_Language, put_Language)
    LastUpdatedTime = property(get_LastUpdatedTime, put_LastUpdatedTime)
    LastUri = property(get_LastUri, None)
    Links = property(get_Links, None)
    NextUri = property(get_NextUri, None)
    NodeName = property(get_NodeName, put_NodeName)
    NodeNamespace = property(get_NodeNamespace, put_NodeNamespace)
    NodeValue = property(get_NodeValue, put_NodeValue)
    PreviousUri = property(get_PreviousUri, None)
    Rights = property(get_Rights, put_Rights)
    SourceFormat = property(get_SourceFormat, None)
    Subtitle = property(get_Subtitle, put_Subtitle)
    Title = property(get_Title, put_Title)
class SyndicationFormat(Enum, Int32):
    Atom10 = 0
    Rss20 = 1
    Rss10 = 2
    Rss092 = 3
    Rss091 = 4
    Atom03 = 5
class SyndicationGenerator(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Web.Syndication.ISyndicationGenerator
    _classid_ = 'Windows.Web.Syndication.SyndicationGenerator'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.Web.Syndication.SyndicationGenerator.CreateInstance(*args))
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Web.Syndication.SyndicationGenerator.CreateSyndicationGenerator(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.Web.Syndication.SyndicationGenerator: ...
    @winrt_factorymethod
    def CreateSyndicationGenerator(cls: win32more.Windows.Web.Syndication.ISyndicationGeneratorFactory, text: WinRT_String) -> win32more.Windows.Web.Syndication.SyndicationGenerator: ...
    @winrt_mixinmethod
    def get_Text(self: win32more.Windows.Web.Syndication.ISyndicationGenerator) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Text(self: win32more.Windows.Web.Syndication.ISyndicationGenerator, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Uri(self: win32more.Windows.Web.Syndication.ISyndicationGenerator) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def put_Uri(self: win32more.Windows.Web.Syndication.ISyndicationGenerator, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_mixinmethod
    def get_Version(self: win32more.Windows.Web.Syndication.ISyndicationGenerator) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Version(self: win32more.Windows.Web.Syndication.ISyndicationGenerator, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_NodeName(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_NodeName(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_NodeNamespace(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_NodeNamespace(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_NodeValue(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_NodeValue(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Language(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Language(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_BaseUri(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def put_BaseUri(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_mixinmethod
    def get_AttributeExtensions(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.SyndicationAttribute]: ...
    @winrt_mixinmethod
    def get_ElementExtensions(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.ISyndicationNode]: ...
    @winrt_mixinmethod
    def GetXmlDocument(self: win32more.Windows.Web.Syndication.ISyndicationNode, format: win32more.Windows.Web.Syndication.SyndicationFormat) -> win32more.Windows.Data.Xml.Dom.XmlDocument: ...
    AttributeExtensions = property(get_AttributeExtensions, None)
    BaseUri = property(get_BaseUri, put_BaseUri)
    ElementExtensions = property(get_ElementExtensions, None)
    Language = property(get_Language, put_Language)
    NodeName = property(get_NodeName, put_NodeName)
    NodeNamespace = property(get_NodeNamespace, put_NodeNamespace)
    NodeValue = property(get_NodeValue, put_NodeValue)
    Text = property(get_Text, put_Text)
    Uri = property(get_Uri, put_Uri)
    Version = property(get_Version, put_Version)
class SyndicationItem(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Web.Syndication.ISyndicationItem
    _classid_ = 'Windows.Web.Syndication.SyndicationItem'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.Web.Syndication.SyndicationItem.CreateInstance(*args))
        elif len(args) == 3:
            super().__init__(move=win32more.Windows.Web.Syndication.SyndicationItem.CreateSyndicationItem(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.Web.Syndication.SyndicationItem: ...
    @winrt_factorymethod
    def CreateSyndicationItem(cls: win32more.Windows.Web.Syndication.ISyndicationItemFactory, title: WinRT_String, content: win32more.Windows.Web.Syndication.SyndicationContent, uri: win32more.Windows.Foundation.Uri) -> win32more.Windows.Web.Syndication.SyndicationItem: ...
    @winrt_mixinmethod
    def get_Authors(self: win32more.Windows.Web.Syndication.ISyndicationItem) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.SyndicationPerson]: ...
    @winrt_mixinmethod
    def get_Categories(self: win32more.Windows.Web.Syndication.ISyndicationItem) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.SyndicationCategory]: ...
    @winrt_mixinmethod
    def get_Contributors(self: win32more.Windows.Web.Syndication.ISyndicationItem) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.SyndicationPerson]: ...
    @winrt_mixinmethod
    def get_Content(self: win32more.Windows.Web.Syndication.ISyndicationItem) -> win32more.Windows.Web.Syndication.SyndicationContent: ...
    @winrt_mixinmethod
    def put_Content(self: win32more.Windows.Web.Syndication.ISyndicationItem, value: win32more.Windows.Web.Syndication.SyndicationContent) -> Void: ...
    @winrt_mixinmethod
    def get_Id(self: win32more.Windows.Web.Syndication.ISyndicationItem) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Id(self: win32more.Windows.Web.Syndication.ISyndicationItem, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_LastUpdatedTime(self: win32more.Windows.Web.Syndication.ISyndicationItem) -> win32more.Windows.Foundation.DateTime: ...
    @winrt_mixinmethod
    def put_LastUpdatedTime(self: win32more.Windows.Web.Syndication.ISyndicationItem, value: win32more.Windows.Foundation.DateTime) -> Void: ...
    @winrt_mixinmethod
    def get_Links(self: win32more.Windows.Web.Syndication.ISyndicationItem) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.SyndicationLink]: ...
    @winrt_mixinmethod
    def get_PublishedDate(self: win32more.Windows.Web.Syndication.ISyndicationItem) -> win32more.Windows.Foundation.DateTime: ...
    @winrt_mixinmethod
    def put_PublishedDate(self: win32more.Windows.Web.Syndication.ISyndicationItem, value: win32more.Windows.Foundation.DateTime) -> Void: ...
    @winrt_mixinmethod
    def get_Rights(self: win32more.Windows.Web.Syndication.ISyndicationItem) -> win32more.Windows.Web.Syndication.ISyndicationText: ...
    @winrt_mixinmethod
    def put_Rights(self: win32more.Windows.Web.Syndication.ISyndicationItem, value: win32more.Windows.Web.Syndication.ISyndicationText) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Windows.Web.Syndication.ISyndicationItem) -> win32more.Windows.Web.Syndication.SyndicationFeed: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Windows.Web.Syndication.ISyndicationItem, value: win32more.Windows.Web.Syndication.SyndicationFeed) -> Void: ...
    @winrt_mixinmethod
    def get_Summary(self: win32more.Windows.Web.Syndication.ISyndicationItem) -> win32more.Windows.Web.Syndication.ISyndicationText: ...
    @winrt_mixinmethod
    def put_Summary(self: win32more.Windows.Web.Syndication.ISyndicationItem, value: win32more.Windows.Web.Syndication.ISyndicationText) -> Void: ...
    @winrt_mixinmethod
    def get_Title(self: win32more.Windows.Web.Syndication.ISyndicationItem) -> win32more.Windows.Web.Syndication.ISyndicationText: ...
    @winrt_mixinmethod
    def put_Title(self: win32more.Windows.Web.Syndication.ISyndicationItem, value: win32more.Windows.Web.Syndication.ISyndicationText) -> Void: ...
    @winrt_mixinmethod
    def get_CommentsUri(self: win32more.Windows.Web.Syndication.ISyndicationItem) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def put_CommentsUri(self: win32more.Windows.Web.Syndication.ISyndicationItem, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_mixinmethod
    def get_EditUri(self: win32more.Windows.Web.Syndication.ISyndicationItem) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def get_EditMediaUri(self: win32more.Windows.Web.Syndication.ISyndicationItem) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def get_ETag(self: win32more.Windows.Web.Syndication.ISyndicationItem) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_ItemUri(self: win32more.Windows.Web.Syndication.ISyndicationItem) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def Load(self: win32more.Windows.Web.Syndication.ISyndicationItem, item: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def LoadFromXml(self: win32more.Windows.Web.Syndication.ISyndicationItem, itemDocument: win32more.Windows.Data.Xml.Dom.XmlDocument) -> Void: ...
    @winrt_mixinmethod
    def get_NodeName(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_NodeName(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_NodeNamespace(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_NodeNamespace(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_NodeValue(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_NodeValue(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Language(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Language(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_BaseUri(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def put_BaseUri(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_mixinmethod
    def get_AttributeExtensions(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.SyndicationAttribute]: ...
    @winrt_mixinmethod
    def get_ElementExtensions(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.ISyndicationNode]: ...
    @winrt_mixinmethod
    def GetXmlDocument(self: win32more.Windows.Web.Syndication.ISyndicationNode, format: win32more.Windows.Web.Syndication.SyndicationFormat) -> win32more.Windows.Data.Xml.Dom.XmlDocument: ...
    AttributeExtensions = property(get_AttributeExtensions, None)
    Authors = property(get_Authors, None)
    BaseUri = property(get_BaseUri, put_BaseUri)
    Categories = property(get_Categories, None)
    CommentsUri = property(get_CommentsUri, put_CommentsUri)
    Content = property(get_Content, put_Content)
    Contributors = property(get_Contributors, None)
    ETag = property(get_ETag, None)
    EditMediaUri = property(get_EditMediaUri, None)
    EditUri = property(get_EditUri, None)
    ElementExtensions = property(get_ElementExtensions, None)
    Id = property(get_Id, put_Id)
    ItemUri = property(get_ItemUri, None)
    Language = property(get_Language, put_Language)
    LastUpdatedTime = property(get_LastUpdatedTime, put_LastUpdatedTime)
    Links = property(get_Links, None)
    NodeName = property(get_NodeName, put_NodeName)
    NodeNamespace = property(get_NodeNamespace, put_NodeNamespace)
    NodeValue = property(get_NodeValue, put_NodeValue)
    PublishedDate = property(get_PublishedDate, put_PublishedDate)
    Rights = property(get_Rights, put_Rights)
    Source = property(get_Source, put_Source)
    Summary = property(get_Summary, put_Summary)
    Title = property(get_Title, put_Title)
class SyndicationLink(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Web.Syndication.ISyndicationLink
    _classid_ = 'Windows.Web.Syndication.SyndicationLink'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.Web.Syndication.SyndicationLink.CreateInstance(*args))
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Web.Syndication.SyndicationLink.CreateSyndicationLink(*args))
        elif len(args) == 5:
            super().__init__(move=win32more.Windows.Web.Syndication.SyndicationLink.CreateSyndicationLinkEx(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.Web.Syndication.SyndicationLink: ...
    @winrt_factorymethod
    def CreateSyndicationLink(cls: win32more.Windows.Web.Syndication.ISyndicationLinkFactory, uri: win32more.Windows.Foundation.Uri) -> win32more.Windows.Web.Syndication.SyndicationLink: ...
    @winrt_factorymethod
    def CreateSyndicationLinkEx(cls: win32more.Windows.Web.Syndication.ISyndicationLinkFactory, uri: win32more.Windows.Foundation.Uri, relationship: WinRT_String, title: WinRT_String, mediaType: WinRT_String, length: UInt32) -> win32more.Windows.Web.Syndication.SyndicationLink: ...
    @winrt_mixinmethod
    def get_Length(self: win32more.Windows.Web.Syndication.ISyndicationLink) -> UInt32: ...
    @winrt_mixinmethod
    def put_Length(self: win32more.Windows.Web.Syndication.ISyndicationLink, value: UInt32) -> Void: ...
    @winrt_mixinmethod
    def get_MediaType(self: win32more.Windows.Web.Syndication.ISyndicationLink) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_MediaType(self: win32more.Windows.Web.Syndication.ISyndicationLink, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Relationship(self: win32more.Windows.Web.Syndication.ISyndicationLink) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Relationship(self: win32more.Windows.Web.Syndication.ISyndicationLink, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Title(self: win32more.Windows.Web.Syndication.ISyndicationLink) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Title(self: win32more.Windows.Web.Syndication.ISyndicationLink, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Uri(self: win32more.Windows.Web.Syndication.ISyndicationLink) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def put_Uri(self: win32more.Windows.Web.Syndication.ISyndicationLink, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_mixinmethod
    def get_ResourceLanguage(self: win32more.Windows.Web.Syndication.ISyndicationLink) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_ResourceLanguage(self: win32more.Windows.Web.Syndication.ISyndicationLink, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_NodeName(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_NodeName(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_NodeNamespace(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_NodeNamespace(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_NodeValue(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_NodeValue(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Language(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Language(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_BaseUri(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def put_BaseUri(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_mixinmethod
    def get_AttributeExtensions(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.SyndicationAttribute]: ...
    @winrt_mixinmethod
    def get_ElementExtensions(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.ISyndicationNode]: ...
    @winrt_mixinmethod
    def GetXmlDocument(self: win32more.Windows.Web.Syndication.ISyndicationNode, format: win32more.Windows.Web.Syndication.SyndicationFormat) -> win32more.Windows.Data.Xml.Dom.XmlDocument: ...
    AttributeExtensions = property(get_AttributeExtensions, None)
    BaseUri = property(get_BaseUri, put_BaseUri)
    ElementExtensions = property(get_ElementExtensions, None)
    Language = property(get_Language, put_Language)
    Length = property(get_Length, put_Length)
    MediaType = property(get_MediaType, put_MediaType)
    NodeName = property(get_NodeName, put_NodeName)
    NodeNamespace = property(get_NodeNamespace, put_NodeNamespace)
    NodeValue = property(get_NodeValue, put_NodeValue)
    Relationship = property(get_Relationship, put_Relationship)
    ResourceLanguage = property(get_ResourceLanguage, put_ResourceLanguage)
    Title = property(get_Title, put_Title)
    Uri = property(get_Uri, put_Uri)
class SyndicationNode(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Web.Syndication.ISyndicationNode
    _classid_ = 'Windows.Web.Syndication.SyndicationNode'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.Web.Syndication.SyndicationNode.CreateInstance(*args))
        elif len(args) == 3:
            super().__init__(move=win32more.Windows.Web.Syndication.SyndicationNode.CreateSyndicationNode(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.Web.Syndication.SyndicationNode: ...
    @winrt_factorymethod
    def CreateSyndicationNode(cls: win32more.Windows.Web.Syndication.ISyndicationNodeFactory, nodeName: WinRT_String, nodeNamespace: WinRT_String, nodeValue: WinRT_String) -> win32more.Windows.Web.Syndication.SyndicationNode: ...
    @winrt_mixinmethod
    def get_NodeName(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_NodeName(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_NodeNamespace(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_NodeNamespace(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_NodeValue(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_NodeValue(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Language(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Language(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_BaseUri(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def put_BaseUri(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_mixinmethod
    def get_AttributeExtensions(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.SyndicationAttribute]: ...
    @winrt_mixinmethod
    def get_ElementExtensions(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.ISyndicationNode]: ...
    @winrt_mixinmethod
    def GetXmlDocument(self: win32more.Windows.Web.Syndication.ISyndicationNode, format: win32more.Windows.Web.Syndication.SyndicationFormat) -> win32more.Windows.Data.Xml.Dom.XmlDocument: ...
    AttributeExtensions = property(get_AttributeExtensions, None)
    BaseUri = property(get_BaseUri, put_BaseUri)
    ElementExtensions = property(get_ElementExtensions, None)
    Language = property(get_Language, put_Language)
    NodeName = property(get_NodeName, put_NodeName)
    NodeNamespace = property(get_NodeNamespace, put_NodeNamespace)
    NodeValue = property(get_NodeValue, put_NodeValue)
class SyndicationPerson(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Web.Syndication.ISyndicationPerson
    _classid_ = 'Windows.Web.Syndication.SyndicationPerson'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.Web.Syndication.SyndicationPerson.CreateInstance(*args))
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Web.Syndication.SyndicationPerson.CreateSyndicationPerson(*args))
        elif len(args) == 3:
            super().__init__(move=win32more.Windows.Web.Syndication.SyndicationPerson.CreateSyndicationPersonEx(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.Web.Syndication.SyndicationPerson: ...
    @winrt_factorymethod
    def CreateSyndicationPerson(cls: win32more.Windows.Web.Syndication.ISyndicationPersonFactory, name: WinRT_String) -> win32more.Windows.Web.Syndication.SyndicationPerson: ...
    @winrt_factorymethod
    def CreateSyndicationPersonEx(cls: win32more.Windows.Web.Syndication.ISyndicationPersonFactory, name: WinRT_String, email: WinRT_String, uri: win32more.Windows.Foundation.Uri) -> win32more.Windows.Web.Syndication.SyndicationPerson: ...
    @winrt_mixinmethod
    def get_Email(self: win32more.Windows.Web.Syndication.ISyndicationPerson) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Email(self: win32more.Windows.Web.Syndication.ISyndicationPerson, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Web.Syndication.ISyndicationPerson) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Web.Syndication.ISyndicationPerson, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Uri(self: win32more.Windows.Web.Syndication.ISyndicationPerson) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def put_Uri(self: win32more.Windows.Web.Syndication.ISyndicationPerson, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_mixinmethod
    def get_NodeName(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_NodeName(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_NodeNamespace(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_NodeNamespace(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_NodeValue(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_NodeValue(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Language(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Language(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_BaseUri(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def put_BaseUri(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_mixinmethod
    def get_AttributeExtensions(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.SyndicationAttribute]: ...
    @winrt_mixinmethod
    def get_ElementExtensions(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.ISyndicationNode]: ...
    @winrt_mixinmethod
    def GetXmlDocument(self: win32more.Windows.Web.Syndication.ISyndicationNode, format: win32more.Windows.Web.Syndication.SyndicationFormat) -> win32more.Windows.Data.Xml.Dom.XmlDocument: ...
    AttributeExtensions = property(get_AttributeExtensions, None)
    BaseUri = property(get_BaseUri, put_BaseUri)
    ElementExtensions = property(get_ElementExtensions, None)
    Email = property(get_Email, put_Email)
    Language = property(get_Language, put_Language)
    Name = property(get_Name, put_Name)
    NodeName = property(get_NodeName, put_NodeName)
    NodeNamespace = property(get_NodeNamespace, put_NodeNamespace)
    NodeValue = property(get_NodeValue, put_NodeValue)
    Uri = property(get_Uri, put_Uri)
class SyndicationText(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Web.Syndication.ISyndicationText
    _classid_ = 'Windows.Web.Syndication.SyndicationText'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.Web.Syndication.SyndicationText.CreateInstance(*args))
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Web.Syndication.SyndicationText.CreateSyndicationText(*args))
        elif len(args) == 2:
            super().__init__(move=win32more.Windows.Web.Syndication.SyndicationText.CreateSyndicationTextEx(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.Web.Syndication.SyndicationText: ...
    @winrt_factorymethod
    def CreateSyndicationText(cls: win32more.Windows.Web.Syndication.ISyndicationTextFactory, text: WinRT_String) -> win32more.Windows.Web.Syndication.SyndicationText: ...
    @winrt_factorymethod
    def CreateSyndicationTextEx(cls: win32more.Windows.Web.Syndication.ISyndicationTextFactory, text: WinRT_String, type: win32more.Windows.Web.Syndication.SyndicationTextType) -> win32more.Windows.Web.Syndication.SyndicationText: ...
    @winrt_mixinmethod
    def get_Text(self: win32more.Windows.Web.Syndication.ISyndicationText) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Text(self: win32more.Windows.Web.Syndication.ISyndicationText, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Type(self: win32more.Windows.Web.Syndication.ISyndicationText) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Type(self: win32more.Windows.Web.Syndication.ISyndicationText, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Xml(self: win32more.Windows.Web.Syndication.ISyndicationText) -> win32more.Windows.Data.Xml.Dom.XmlDocument: ...
    @winrt_mixinmethod
    def put_Xml(self: win32more.Windows.Web.Syndication.ISyndicationText, value: win32more.Windows.Data.Xml.Dom.XmlDocument) -> Void: ...
    @winrt_mixinmethod
    def get_NodeName(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_NodeName(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_NodeNamespace(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_NodeNamespace(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_NodeValue(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_NodeValue(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Language(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Language(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_BaseUri(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def put_BaseUri(self: win32more.Windows.Web.Syndication.ISyndicationNode, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_mixinmethod
    def get_AttributeExtensions(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.SyndicationAttribute]: ...
    @winrt_mixinmethod
    def get_ElementExtensions(self: win32more.Windows.Web.Syndication.ISyndicationNode) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Web.Syndication.ISyndicationNode]: ...
    @winrt_mixinmethod
    def GetXmlDocument(self: win32more.Windows.Web.Syndication.ISyndicationNode, format: win32more.Windows.Web.Syndication.SyndicationFormat) -> win32more.Windows.Data.Xml.Dom.XmlDocument: ...
    AttributeExtensions = property(get_AttributeExtensions, None)
    BaseUri = property(get_BaseUri, put_BaseUri)
    ElementExtensions = property(get_ElementExtensions, None)
    Language = property(get_Language, put_Language)
    NodeName = property(get_NodeName, put_NodeName)
    NodeNamespace = property(get_NodeNamespace, put_NodeNamespace)
    NodeValue = property(get_NodeValue, put_NodeValue)
    Text = property(get_Text, put_Text)
    Type = property(get_Type, put_Type)
    Xml = property(get_Xml, put_Xml)
class SyndicationTextType(Enum, Int32):
    Text = 0
    Html = 1
    Xhtml = 2
class TransferProgress(Structure):
    BytesSent: UInt32
    TotalBytesToSend: UInt32
    BytesRetrieved: UInt32
    TotalBytesToRetrieve: UInt32


make_ready(__name__)
