from __future__ import annotations
from win32more import ARCH, Annotated, Boolean, Byte, Bytes, Char, ComPtr, ConstantLazyLoader, Double, Enum, FAILED, FlexibleArray, Guid, Int16, Int32, Int64, IntPtr, NativeBitfieldAttribute, POINTER, SByte, SUCCEEDED, Single, String, Structure, UInt16, UInt32, UInt64, UIntPtr, UnicodeAlias, Union, Void, VoidPtr, cfunctype, cfunctype_pointer, commethod, make_ready, winfunctype, winfunctype_pointer
import win32more.Windows.Win32.Foundation
import win32more.Windows.Win32.Graphics.Direct2D.Common
import win32more.Windows.Win32.Graphics.Direct3D
import win32more.Windows.Win32.Graphics.DirectComposition
import win32more.Windows.Win32.Graphics.Dxgi
import win32more.Windows.Win32.Graphics.Dxgi.Common
import win32more.Windows.Win32.Security
import win32more.Windows.Win32.System.Com
COMPOSITIONOBJECT_READ: Int32 = 1
COMPOSITIONOBJECT_WRITE: Int32 = 2
DCOMPOSITION_MAX_WAITFORCOMPOSITORCLOCK_OBJECTS: UInt32 = 32
COMPOSITION_STATS_MAX_TARGETS: UInt32 = 256
@winfunctype('dcomp.dll')
def DCompositionCreateDevice(dxgiDevice: win32more.Windows.Win32.Graphics.Dxgi.IDXGIDevice, iid: POINTER(Guid), dcompositionDevice: POINTER(VoidPtr)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
@winfunctype('dcomp.dll')
def DCompositionCreateDevice2(renderingDevice: win32more.Windows.Win32.System.Com.IUnknown, iid: POINTER(Guid), dcompositionDevice: POINTER(VoidPtr)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
@winfunctype('dcomp.dll')
def DCompositionCreateDevice3(renderingDevice: win32more.Windows.Win32.System.Com.IUnknown, iid: POINTER(Guid), dcompositionDevice: POINTER(VoidPtr)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
@winfunctype('dcomp.dll')
def DCompositionCreateSurfaceHandle(desiredAccess: UInt32, securityAttributes: POINTER(win32more.Windows.Win32.Security.SECURITY_ATTRIBUTES), surfaceHandle: POINTER(win32more.Windows.Win32.Foundation.HANDLE)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
@winfunctype('dcomp.dll')
def DCompositionAttachMouseWheelToHwnd(visual: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionVisual, hwnd: win32more.Windows.Win32.Foundation.HWND, enable: win32more.Windows.Win32.Foundation.BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
@winfunctype('dcomp.dll')
def DCompositionAttachMouseDragToHwnd(visual: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionVisual, hwnd: win32more.Windows.Win32.Foundation.HWND, enable: win32more.Windows.Win32.Foundation.BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
@winfunctype('dcomp.dll')
def DCompositionGetFrameId(frameIdType: win32more.Windows.Win32.Graphics.DirectComposition.COMPOSITION_FRAME_ID_TYPE, frameId: POINTER(UInt64)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
@winfunctype('dcomp.dll')
def DCompositionGetStatistics(frameId: UInt64, frameStats: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.COMPOSITION_FRAME_STATS), targetIdCount: UInt32, targetIds: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.COMPOSITION_TARGET_ID), actualTargetIdCount: POINTER(UInt32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
@winfunctype('dcomp.dll')
def DCompositionGetTargetStatistics(frameId: UInt64, targetId: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.COMPOSITION_TARGET_ID), targetStats: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.COMPOSITION_TARGET_STATS)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
@winfunctype('dcomp.dll')
def DCompositionBoostCompositorClock(enable: win32more.Windows.Win32.Foundation.BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
@winfunctype('dcomp.dll')
def DCompositionWaitForCompositorClock(count: UInt32, handles: POINTER(win32more.Windows.Win32.Foundation.HANDLE), timeoutInMs: UInt32) -> UInt32: ...
COMPOSITION_FRAME_ID_TYPE = Int32
COMPOSITION_FRAME_ID_CREATED: win32more.Windows.Win32.Graphics.DirectComposition.COMPOSITION_FRAME_ID_TYPE = 0
COMPOSITION_FRAME_ID_CONFIRMED: win32more.Windows.Win32.Graphics.DirectComposition.COMPOSITION_FRAME_ID_TYPE = 1
COMPOSITION_FRAME_ID_COMPLETED: win32more.Windows.Win32.Graphics.DirectComposition.COMPOSITION_FRAME_ID_TYPE = 2
class COMPOSITION_FRAME_STATS(Structure):
    startTime: UInt64
    targetTime: UInt64
    framePeriod: UInt64
class COMPOSITION_STATS(Structure):
    presentCount: UInt32
    refreshCount: UInt32
    virtualRefreshCount: UInt32
    time: UInt64
class COMPOSITION_TARGET_ID(Structure):
    displayAdapterLuid: win32more.Windows.Win32.Foundation.LUID
    renderAdapterLuid: win32more.Windows.Win32.Foundation.LUID
    vidPnSourceId: UInt32
    vidPnTargetId: UInt32
    uniqueId: UInt32
class COMPOSITION_TARGET_STATS(Structure):
    outstandingPresents: UInt32
    presentTime: UInt64
    vblankDuration: UInt64
    presentedStats: win32more.Windows.Win32.Graphics.DirectComposition.COMPOSITION_STATS
    completedStats: win32more.Windows.Win32.Graphics.DirectComposition.COMPOSITION_STATS
DCOMPOSITION_BACKFACE_VISIBILITY = Int32
DCOMPOSITION_BACKFACE_VISIBILITY_VISIBLE: win32more.Windows.Win32.Graphics.DirectComposition.DCOMPOSITION_BACKFACE_VISIBILITY = 0
DCOMPOSITION_BACKFACE_VISIBILITY_HIDDEN: win32more.Windows.Win32.Graphics.DirectComposition.DCOMPOSITION_BACKFACE_VISIBILITY = 1
DCOMPOSITION_BACKFACE_VISIBILITY_INHERIT: win32more.Windows.Win32.Graphics.DirectComposition.DCOMPOSITION_BACKFACE_VISIBILITY = -1
DCOMPOSITION_BITMAP_INTERPOLATION_MODE = Int32
DCOMPOSITION_BITMAP_INTERPOLATION_MODE_NEAREST_NEIGHBOR: win32more.Windows.Win32.Graphics.DirectComposition.DCOMPOSITION_BITMAP_INTERPOLATION_MODE = 0
DCOMPOSITION_BITMAP_INTERPOLATION_MODE_LINEAR: win32more.Windows.Win32.Graphics.DirectComposition.DCOMPOSITION_BITMAP_INTERPOLATION_MODE = 1
DCOMPOSITION_BITMAP_INTERPOLATION_MODE_INHERIT: win32more.Windows.Win32.Graphics.DirectComposition.DCOMPOSITION_BITMAP_INTERPOLATION_MODE = -1
DCOMPOSITION_BORDER_MODE = Int32
DCOMPOSITION_BORDER_MODE_SOFT: win32more.Windows.Win32.Graphics.DirectComposition.DCOMPOSITION_BORDER_MODE = 0
DCOMPOSITION_BORDER_MODE_HARD: win32more.Windows.Win32.Graphics.DirectComposition.DCOMPOSITION_BORDER_MODE = 1
DCOMPOSITION_BORDER_MODE_INHERIT: win32more.Windows.Win32.Graphics.DirectComposition.DCOMPOSITION_BORDER_MODE = -1
DCOMPOSITION_COMPOSITE_MODE = Int32
DCOMPOSITION_COMPOSITE_MODE_SOURCE_OVER: win32more.Windows.Win32.Graphics.DirectComposition.DCOMPOSITION_COMPOSITE_MODE = 0
DCOMPOSITION_COMPOSITE_MODE_DESTINATION_INVERT: win32more.Windows.Win32.Graphics.DirectComposition.DCOMPOSITION_COMPOSITE_MODE = 1
DCOMPOSITION_COMPOSITE_MODE_MIN_BLEND: win32more.Windows.Win32.Graphics.DirectComposition.DCOMPOSITION_COMPOSITE_MODE = 2
DCOMPOSITION_COMPOSITE_MODE_INHERIT: win32more.Windows.Win32.Graphics.DirectComposition.DCOMPOSITION_COMPOSITE_MODE = -1
DCOMPOSITION_DEPTH_MODE = Int32
DCOMPOSITION_DEPTH_MODE_TREE: win32more.Windows.Win32.Graphics.DirectComposition.DCOMPOSITION_DEPTH_MODE = 0
DCOMPOSITION_DEPTH_MODE_SPATIAL: win32more.Windows.Win32.Graphics.DirectComposition.DCOMPOSITION_DEPTH_MODE = 1
DCOMPOSITION_DEPTH_MODE_SORTED: win32more.Windows.Win32.Graphics.DirectComposition.DCOMPOSITION_DEPTH_MODE = 3
DCOMPOSITION_DEPTH_MODE_INHERIT: win32more.Windows.Win32.Graphics.DirectComposition.DCOMPOSITION_DEPTH_MODE = -1
class DCOMPOSITION_FRAME_STATISTICS(Structure):
    lastFrameTime: Int64
    currentCompositionRate: win32more.Windows.Win32.Graphics.Dxgi.Common.DXGI_RATIONAL
    currentTime: Int64
    timeFrequency: Int64
    nextEstimatedFrameTime: Int64
DCOMPOSITION_OPACITY_MODE = Int32
DCOMPOSITION_OPACITY_MODE_LAYER: win32more.Windows.Win32.Graphics.DirectComposition.DCOMPOSITION_OPACITY_MODE = 0
DCOMPOSITION_OPACITY_MODE_MULTIPLY: win32more.Windows.Win32.Graphics.DirectComposition.DCOMPOSITION_OPACITY_MODE = 1
DCOMPOSITION_OPACITY_MODE_INHERIT: win32more.Windows.Win32.Graphics.DirectComposition.DCOMPOSITION_OPACITY_MODE = -1
class DCompositionInkTrailPoint(Structure):
    x: Single
    y: Single
    radius: Single
class IDCompositionAffineTransform2DEffect(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionFilterEffect
    _iid_ = Guid('{0b74b9e8-cdd6-492f-bbbc-5ed32157026d}')
    @commethod(4)
    def SetInterpolationMode(self, interpolationMode: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def SetBorderMode(self, borderMode: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_BORDER_MODE) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def SetTransformMatrix(self, transformMatrix: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def SetTransformMatrixElement(self, row: Int32, column: Int32, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def SetTransformMatrixElement(self, row: Int32, column: Int32, value: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def SetSharpness(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def SetSharpness(self, sharpness: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionAnimation(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{cbfd91d9-51b2-45e4-b3de-d19ccfb863c5}')
    @commethod(3)
    def Reset(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def SetAbsoluteBeginTime(self, beginTime: Int64) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def AddCubic(self, beginOffset: Double, constantCoefficient: Single, linearCoefficient: Single, quadraticCoefficient: Single, cubicCoefficient: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def AddSinusoidal(self, beginOffset: Double, bias: Single, amplitude: Single, frequency: Single, phase: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def AddRepeat(self, beginOffset: Double, durationToRepeat: Double) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def End(self, endOffset: Double, endValue: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionArithmeticCompositeEffect(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionFilterEffect
    _iid_ = Guid('{3b67dfa8-e3dd-4e61-b640-46c2f3d739dc}')
    @commethod(4)
    def SetCoefficients(self, coefficients: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_VECTOR_4F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def SetClampOutput(self, clampoutput: win32more.Windows.Win32.Foundation.BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def SetCoefficient1(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def SetCoefficient1(self, Coeffcient1: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def SetCoefficient2(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def SetCoefficient2(self, Coefficient2: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def SetCoefficient3(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def SetCoefficient3(self, Coefficient3: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def SetCoefficient4(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def SetCoefficient4(self, Coefficient4: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionBlendEffect(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionFilterEffect
    _iid_ = Guid('{33ecdc0a-578a-4a11-9c14-0cb90517f9c5}')
    @commethod(4)
    def SetMode(self, mode: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_BLEND_MODE) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionBrightnessEffect(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionFilterEffect
    _iid_ = Guid('{6027496e-cb3a-49ab-934f-d798da4f7da6}')
    @commethod(4)
    def SetWhitePoint(self, whitePoint: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_VECTOR_2F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def SetBlackPoint(self, blackPoint: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_VECTOR_2F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def SetWhitePointX(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def SetWhitePointX(self, whitePointX: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def SetWhitePointY(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def SetWhitePointY(self, whitePointY: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def SetBlackPointX(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def SetBlackPointX(self, blackPointX: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def SetBlackPointY(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def SetBlackPointY(self, blackPointY: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionClip(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{64ac3703-9d3f-45ec-a109-7cac0e7a13a7}')
class IDCompositionColorMatrixEffect(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionFilterEffect
    _iid_ = Guid('{c1170a22-3ce2-4966-90d4-55408bfc84c4}')
    @commethod(4)
    def SetMatrix(self, matrix: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_5X4_F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def SetMatrixElement(self, row: Int32, column: Int32, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def SetMatrixElement(self, row: Int32, column: Int32, value: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def SetAlphaMode(self, mode: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_COLORMATRIX_ALPHA_MODE) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def SetClampOutput(self, clamp: win32more.Windows.Win32.Foundation.BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionCompositeEffect(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionFilterEffect
    _iid_ = Guid('{576616c0-a231-494d-a38d-00fd5ec4db46}')
    @commethod(4)
    def SetMode(self, mode: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_COMPOSITE_MODE) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionDelegatedInkTrail(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{c2448e9b-547d-4057-8cf5-8144ede1c2da}')
    @commethod(3)
    def AddTrailPoints(self, inkPoints: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.DCompositionInkTrailPoint), inkPointsCount: UInt32, generationId: POINTER(UInt32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def AddTrailPointsWithPrediction(self, inkPoints: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.DCompositionInkTrailPoint), inkPointsCount: UInt32, predictedInkPoints: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.DCompositionInkTrailPoint), predictedInkPointsCount: UInt32, generationId: POINTER(UInt32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def RemoveTrailPoints(self, generationId: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def StartNewTrail(self, color: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_COLOR_F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionDesktopDevice(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionDevice2
    _iid_ = Guid('{5f4633fe-1e08-4cb8-8c75-ce24333f5602}')
    @commethod(24)
    def CreateTargetForHwnd(self, hwnd: win32more.Windows.Win32.Foundation.HWND, topmost: win32more.Windows.Win32.Foundation.BOOL, target: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionTarget)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(25)
    def CreateSurfaceFromHandle(self, handle: win32more.Windows.Win32.Foundation.HANDLE, surface: POINTER(win32more.Windows.Win32.System.Com.IUnknown)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(26)
    def CreateSurfaceFromHwnd(self, hwnd: win32more.Windows.Win32.Foundation.HWND, surface: POINTER(win32more.Windows.Win32.System.Com.IUnknown)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionDevice(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{c37ea93a-e7aa-450d-b16f-9746cb0407f3}')
    @commethod(3)
    def Commit(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def WaitForCommitCompletion(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def GetFrameStatistics(self, statistics: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.DCOMPOSITION_FRAME_STATISTICS)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def CreateTargetForHwnd(self, hwnd: win32more.Windows.Win32.Foundation.HWND, topmost: win32more.Windows.Win32.Foundation.BOOL, target: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionTarget)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def CreateVisual(self, visual: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionVisual)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def CreateSurface(self, width: UInt32, height: UInt32, pixelFormat: win32more.Windows.Win32.Graphics.Dxgi.Common.DXGI_FORMAT, alphaMode: win32more.Windows.Win32.Graphics.Dxgi.Common.DXGI_ALPHA_MODE, surface: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionSurface)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def CreateVirtualSurface(self, initialWidth: UInt32, initialHeight: UInt32, pixelFormat: win32more.Windows.Win32.Graphics.Dxgi.Common.DXGI_FORMAT, alphaMode: win32more.Windows.Win32.Graphics.Dxgi.Common.DXGI_ALPHA_MODE, virtualSurface: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionVirtualSurface)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def CreateSurfaceFromHandle(self, handle: win32more.Windows.Win32.Foundation.HANDLE, surface: POINTER(win32more.Windows.Win32.System.Com.IUnknown)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def CreateSurfaceFromHwnd(self, hwnd: win32more.Windows.Win32.Foundation.HWND, surface: POINTER(win32more.Windows.Win32.System.Com.IUnknown)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def CreateTranslateTransform(self, translateTransform: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionTranslateTransform)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def CreateScaleTransform(self, scaleTransform: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionScaleTransform)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(14)
    def CreateRotateTransform(self, rotateTransform: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionRotateTransform)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(15)
    def CreateSkewTransform(self, skewTransform: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionSkewTransform)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(16)
    def CreateMatrixTransform(self, matrixTransform: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionMatrixTransform)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(17)
    def CreateTransformGroup(self, transforms: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionTransform), elements: UInt32, transformGroup: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionTransform)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(18)
    def CreateTranslateTransform3D(self, translateTransform3D: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionTranslateTransform3D)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(19)
    def CreateScaleTransform3D(self, scaleTransform3D: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionScaleTransform3D)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(20)
    def CreateRotateTransform3D(self, rotateTransform3D: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionRotateTransform3D)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(21)
    def CreateMatrixTransform3D(self, matrixTransform3D: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionMatrixTransform3D)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(22)
    def CreateTransform3DGroup(self, transforms3D: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionTransform3D), elements: UInt32, transform3DGroup: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionTransform3D)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(23)
    def CreateEffectGroup(self, effectGroup: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionEffectGroup)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(24)
    def CreateRectangleClip(self, clip: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionRectangleClip)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(25)
    def CreateAnimation(self, animation: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(26)
    def CheckDeviceState(self, pfValid: POINTER(win32more.Windows.Win32.Foundation.BOOL)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionDevice2(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{75f6468d-1b8e-447c-9bc6-75fea80b5b25}')
    @commethod(3)
    def Commit(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def WaitForCommitCompletion(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def GetFrameStatistics(self, statistics: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.DCOMPOSITION_FRAME_STATISTICS)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def CreateVisual(self, visual: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionVisual2)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def CreateSurfaceFactory(self, renderingDevice: win32more.Windows.Win32.System.Com.IUnknown, surfaceFactory: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionSurfaceFactory)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def CreateSurface(self, width: UInt32, height: UInt32, pixelFormat: win32more.Windows.Win32.Graphics.Dxgi.Common.DXGI_FORMAT, alphaMode: win32more.Windows.Win32.Graphics.Dxgi.Common.DXGI_ALPHA_MODE, surface: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionSurface)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def CreateVirtualSurface(self, initialWidth: UInt32, initialHeight: UInt32, pixelFormat: win32more.Windows.Win32.Graphics.Dxgi.Common.DXGI_FORMAT, alphaMode: win32more.Windows.Win32.Graphics.Dxgi.Common.DXGI_ALPHA_MODE, virtualSurface: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionVirtualSurface)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def CreateTranslateTransform(self, translateTransform: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionTranslateTransform)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def CreateScaleTransform(self, scaleTransform: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionScaleTransform)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def CreateRotateTransform(self, rotateTransform: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionRotateTransform)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def CreateSkewTransform(self, skewTransform: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionSkewTransform)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(14)
    def CreateMatrixTransform(self, matrixTransform: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionMatrixTransform)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(15)
    def CreateTransformGroup(self, transforms: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionTransform), elements: UInt32, transformGroup: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionTransform)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(16)
    def CreateTranslateTransform3D(self, translateTransform3D: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionTranslateTransform3D)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(17)
    def CreateScaleTransform3D(self, scaleTransform3D: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionScaleTransform3D)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(18)
    def CreateRotateTransform3D(self, rotateTransform3D: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionRotateTransform3D)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(19)
    def CreateMatrixTransform3D(self, matrixTransform3D: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionMatrixTransform3D)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(20)
    def CreateTransform3DGroup(self, transforms3D: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionTransform3D), elements: UInt32, transform3DGroup: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionTransform3D)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(21)
    def CreateEffectGroup(self, effectGroup: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionEffectGroup)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(22)
    def CreateRectangleClip(self, clip: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionRectangleClip)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(23)
    def CreateAnimation(self, animation: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionDevice3(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionDevice2
    _iid_ = Guid('{0987cb06-f916-48bf-8d35-ce7641781bd9}')
    @commethod(24)
    def CreateGaussianBlurEffect(self, gaussianBlurEffect: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionGaussianBlurEffect)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(25)
    def CreateBrightnessEffect(self, brightnessEffect: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionBrightnessEffect)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(26)
    def CreateColorMatrixEffect(self, colorMatrixEffect: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionColorMatrixEffect)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(27)
    def CreateShadowEffect(self, shadowEffect: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionShadowEffect)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(28)
    def CreateHueRotationEffect(self, hueRotationEffect: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionHueRotationEffect)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(29)
    def CreateSaturationEffect(self, saturationEffect: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionSaturationEffect)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(30)
    def CreateTurbulenceEffect(self, turbulenceEffect: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionTurbulenceEffect)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(31)
    def CreateLinearTransferEffect(self, linearTransferEffect: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionLinearTransferEffect)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(32)
    def CreateTableTransferEffect(self, tableTransferEffect: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionTableTransferEffect)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(33)
    def CreateCompositeEffect(self, compositeEffect: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionCompositeEffect)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(34)
    def CreateBlendEffect(self, blendEffect: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionBlendEffect)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(35)
    def CreateArithmeticCompositeEffect(self, arithmeticCompositeEffect: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionArithmeticCompositeEffect)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(36)
    def CreateAffineTransform2DEffect(self, affineTransform2dEffect: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAffineTransform2DEffect)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionDevice4(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionDevice3
    _iid_ = Guid('{85fc5cca-2da6-494c-86b6-4a775c049b8a}')
    @commethod(37)
    def CheckCompositionTextureSupport(self, renderingDevice: win32more.Windows.Win32.System.Com.IUnknown, supportsCompositionTextures: POINTER(win32more.Windows.Win32.Foundation.BOOL)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(38)
    def CreateCompositionTexture(self, d3dTexture: win32more.Windows.Win32.System.Com.IUnknown, compositionTexture: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionTexture)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionDeviceDebug(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{a1a3c64a-224f-4a81-9773-4f03a89d3c6c}')
    @commethod(3)
    def EnableDebugCounters(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def DisableDebugCounters(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionEffect(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{ec81b08f-bfcb-4e8d-b193-a915587999e8}')
class IDCompositionEffectGroup(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionEffect
    _iid_ = Guid('{a7929a74-e6b2-4bd6-8b95-4040119ca34d}')
    @commethod(3)
    def SetOpacity(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def SetOpacity(self, opacity: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def SetTransform3D(self, transform3D: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionTransform3D) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionFilterEffect(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionEffect
    _iid_ = Guid('{30c421d5-8cb2-4e9f-b133-37be270d4ac2}')
    @commethod(3)
    def SetInput(self, index: UInt32, input: win32more.Windows.Win32.System.Com.IUnknown, flags: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionGaussianBlurEffect(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionFilterEffect
    _iid_ = Guid('{45d4d0b7-1bd4-454e-8894-2bfa68443033}')
    @commethod(4)
    def SetStandardDeviation(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def SetStandardDeviation(self, amount: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def SetBorderMode(self, mode: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_BORDER_MODE) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionHueRotationEffect(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionFilterEffect
    _iid_ = Guid('{6db9f920-0770-4781-b0c6-381912f9d167}')
    @commethod(4)
    def SetAngle(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def SetAngle(self, amountDegrees: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionInkTrailDevice(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{df0c7cec-cdeb-4d4a-b91c-721bf22f4e6c}')
    @commethod(3)
    def CreateDelegatedInkTrail(self, inkTrail: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionDelegatedInkTrail)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def CreateDelegatedInkTrailForSwapChain(self, swapChain: win32more.Windows.Win32.System.Com.IUnknown, inkTrail: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionDelegatedInkTrail)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionLinearTransferEffect(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionFilterEffect
    _iid_ = Guid('{4305ee5b-c4a0-4c88-9385-67124e017683}')
    @commethod(4)
    def SetRedYIntercept(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def SetRedYIntercept(self, redYIntercept: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def SetRedSlope(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def SetRedSlope(self, redSlope: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def SetRedDisable(self, redDisable: win32more.Windows.Win32.Foundation.BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def SetGreenYIntercept(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def SetGreenYIntercept(self, greenYIntercept: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def SetGreenSlope(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def SetGreenSlope(self, greenSlope: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def SetGreenDisable(self, greenDisable: win32more.Windows.Win32.Foundation.BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(14)
    def SetBlueYIntercept(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(15)
    def SetBlueYIntercept(self, blueYIntercept: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(16)
    def SetBlueSlope(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(17)
    def SetBlueSlope(self, blueSlope: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(18)
    def SetBlueDisable(self, blueDisable: win32more.Windows.Win32.Foundation.BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(19)
    def SetAlphaYIntercept(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(20)
    def SetAlphaYIntercept(self, alphaYIntercept: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(21)
    def SetAlphaSlope(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(22)
    def SetAlphaSlope(self, alphaSlope: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(23)
    def SetAlphaDisable(self, alphaDisable: win32more.Windows.Win32.Foundation.BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(24)
    def SetClampOutput(self, clampOutput: win32more.Windows.Win32.Foundation.BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionMatrixTransform(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionTransform
    _iid_ = Guid('{16cdff07-c503-419c-83f2-0965c7af1fa6}')
    @commethod(3)
    def SetMatrix(self, matrix: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def SetMatrixElement(self, row: Int32, column: Int32, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def SetMatrixElement(self, row: Int32, column: Int32, value: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionMatrixTransform3D(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionTransform3D
    _iid_ = Guid('{4b3363f0-643b-41b7-b6e0-ccf22d34467c}')
    @commethod(3)
    def SetMatrix(self, matrix: POINTER(win32more.Windows.Win32.Graphics.Direct3D.D3DMATRIX)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def SetMatrixElement(self, row: Int32, column: Int32, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def SetMatrixElement(self, row: Int32, column: Int32, value: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionRectangleClip(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionClip
    _iid_ = Guid('{9842ad7d-d9cf-4908-aed7-48b51da5e7c2}')
    @commethod(3)
    def SetLeft(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def SetLeft(self, left: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def SetTop(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def SetTop(self, top: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def SetRight(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def SetRight(self, right: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def SetBottom(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def SetBottom(self, bottom: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def SetTopLeftRadiusX(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def SetTopLeftRadiusX(self, radius: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def SetTopLeftRadiusY(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(14)
    def SetTopLeftRadiusY(self, radius: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(15)
    def SetTopRightRadiusX(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(16)
    def SetTopRightRadiusX(self, radius: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(17)
    def SetTopRightRadiusY(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(18)
    def SetTopRightRadiusY(self, radius: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(19)
    def SetBottomLeftRadiusX(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(20)
    def SetBottomLeftRadiusX(self, radius: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(21)
    def SetBottomLeftRadiusY(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(22)
    def SetBottomLeftRadiusY(self, radius: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(23)
    def SetBottomRightRadiusX(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(24)
    def SetBottomRightRadiusX(self, radius: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(25)
    def SetBottomRightRadiusY(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(26)
    def SetBottomRightRadiusY(self, radius: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionRotateTransform(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionTransform
    _iid_ = Guid('{641ed83c-ae96-46c5-90dc-32774cc5c6d5}')
    @commethod(3)
    def SetAngle(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def SetAngle(self, angle: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def SetCenterX(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def SetCenterX(self, centerX: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def SetCenterY(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def SetCenterY(self, centerY: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionRotateTransform3D(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionTransform3D
    _iid_ = Guid('{d8f5b23f-d429-4a91-b55a-d2f45fd75b18}')
    @commethod(3)
    def SetAngle(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def SetAngle(self, angle: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def SetAxisX(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def SetAxisX(self, axisX: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def SetAxisY(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def SetAxisY(self, axisY: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def SetAxisZ(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def SetAxisZ(self, axisZ: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def SetCenterX(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def SetCenterX(self, centerX: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def SetCenterY(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(14)
    def SetCenterY(self, centerY: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(15)
    def SetCenterZ(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(16)
    def SetCenterZ(self, centerZ: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionSaturationEffect(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionFilterEffect
    _iid_ = Guid('{a08debda-3258-4fa4-9f16-9174d3fe93b1}')
    @commethod(4)
    def SetSaturation(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def SetSaturation(self, ratio: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionScaleTransform(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionTransform
    _iid_ = Guid('{71fde914-40ef-45ef-bd51-68b037c339f9}')
    @commethod(3)
    def SetScaleX(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def SetScaleX(self, scaleX: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def SetScaleY(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def SetScaleY(self, scaleY: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def SetCenterX(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def SetCenterX(self, centerX: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def SetCenterY(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def SetCenterY(self, centerY: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionScaleTransform3D(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionTransform3D
    _iid_ = Guid('{2a9e9ead-364b-4b15-a7c4-a1997f78b389}')
    @commethod(3)
    def SetScaleX(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def SetScaleX(self, scaleX: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def SetScaleY(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def SetScaleY(self, scaleY: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def SetScaleZ(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def SetScaleZ(self, scaleZ: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def SetCenterX(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def SetCenterX(self, centerX: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def SetCenterY(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def SetCenterY(self, centerY: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def SetCenterZ(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(14)
    def SetCenterZ(self, centerZ: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionShadowEffect(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionFilterEffect
    _iid_ = Guid('{4ad18ac0-cfd2-4c2f-bb62-96e54fdb6879}')
    @commethod(4)
    def SetStandardDeviation(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def SetStandardDeviation(self, amount: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def SetColor(self, color: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_VECTOR_4F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def SetRed(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def SetRed(self, amount: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def SetGreen(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def SetGreen(self, amount: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def SetBlue(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def SetBlue(self, amount: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def SetAlpha(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(14)
    def SetAlpha(self, amount: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionSkewTransform(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionTransform
    _iid_ = Guid('{e57aa735-dcdb-4c72-9c61-0591f58889ee}')
    @commethod(3)
    def SetAngleX(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def SetAngleX(self, angleX: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def SetAngleY(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def SetAngleY(self, angleY: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def SetCenterX(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def SetCenterX(self, centerX: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def SetCenterY(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def SetCenterY(self, centerY: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionSurface(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{bb8a4953-2c99-4f5a-96f5-4819027fa3ac}')
    @commethod(3)
    def BeginDraw(self, updateRect: POINTER(win32more.Windows.Win32.Foundation.RECT), iid: POINTER(Guid), updateObject: POINTER(VoidPtr), updateOffset: POINTER(win32more.Windows.Win32.Foundation.POINT)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def EndDraw(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def SuspendDraw(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def ResumeDraw(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def Scroll(self, scrollRect: POINTER(win32more.Windows.Win32.Foundation.RECT), clipRect: POINTER(win32more.Windows.Win32.Foundation.RECT), offsetX: Int32, offsetY: Int32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionSurfaceFactory(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{e334bc12-3937-4e02-85eb-fcf4eb30d2c8}')
    @commethod(3)
    def CreateSurface(self, width: UInt32, height: UInt32, pixelFormat: win32more.Windows.Win32.Graphics.Dxgi.Common.DXGI_FORMAT, alphaMode: win32more.Windows.Win32.Graphics.Dxgi.Common.DXGI_ALPHA_MODE, surface: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionSurface)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def CreateVirtualSurface(self, initialWidth: UInt32, initialHeight: UInt32, pixelFormat: win32more.Windows.Win32.Graphics.Dxgi.Common.DXGI_FORMAT, alphaMode: win32more.Windows.Win32.Graphics.Dxgi.Common.DXGI_ALPHA_MODE, virtualSurface: POINTER(win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionVirtualSurface)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionTableTransferEffect(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionFilterEffect
    _iid_ = Guid('{9b7e82e2-69c5-4eb4-a5f5-a7033f5132cd}')
    @commethod(4)
    def SetRedTable(self, tableValues: POINTER(Single), count: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def SetGreenTable(self, tableValues: POINTER(Single), count: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def SetBlueTable(self, tableValues: POINTER(Single), count: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def SetAlphaTable(self, tableValues: POINTER(Single), count: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def SetRedDisable(self, redDisable: win32more.Windows.Win32.Foundation.BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def SetGreenDisable(self, greenDisable: win32more.Windows.Win32.Foundation.BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def SetBlueDisable(self, blueDisable: win32more.Windows.Win32.Foundation.BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def SetAlphaDisable(self, alphaDisable: win32more.Windows.Win32.Foundation.BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def SetClampOutput(self, clampOutput: win32more.Windows.Win32.Foundation.BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def SetRedTableValue(self, index: UInt32, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(14)
    def SetRedTableValue(self, index: UInt32, value: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(15)
    def SetGreenTableValue(self, index: UInt32, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(16)
    def SetGreenTableValue(self, index: UInt32, value: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(17)
    def SetBlueTableValue(self, index: UInt32, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(18)
    def SetBlueTableValue(self, index: UInt32, value: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(19)
    def SetAlphaTableValue(self, index: UInt32, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(20)
    def SetAlphaTableValue(self, index: UInt32, value: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionTarget(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{eacdd04c-117e-4e17-88f4-d1b12b0e3d89}')
    @commethod(3)
    def SetRoot(self, visual: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionVisual) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionTexture(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{929bb1aa-725f-433b-abd7-273075a835f2}')
    @commethod(3)
    def SetSourceRect(self, sourceRect: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_U)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def SetColorSpace(self, colorSpace: win32more.Windows.Win32.Graphics.Dxgi.Common.DXGI_COLOR_SPACE_TYPE) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def SetAlphaMode(self, alphaMode: win32more.Windows.Win32.Graphics.Dxgi.Common.DXGI_ALPHA_MODE) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def GetAvailableFence(self, fenceValue: POINTER(UInt64), iid: POINTER(Guid), availableFence: POINTER(VoidPtr)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionTransform(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionTransform3D
    _iid_ = Guid('{fd55faa7-37e0-4c20-95d2-9be45bc33f55}')
class IDCompositionTransform3D(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionEffect
    _iid_ = Guid('{71185722-246b-41f2-aad1-0443f7f4bfc2}')
class IDCompositionTranslateTransform(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionTransform
    _iid_ = Guid('{06791122-c6f0-417d-8323-269e987f5954}')
    @commethod(3)
    def SetOffsetX(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def SetOffsetX(self, offsetX: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def SetOffsetY(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def SetOffsetY(self, offsetY: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionTranslateTransform3D(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionTransform3D
    _iid_ = Guid('{91636d4b-9ba1-4532-aaf7-e3344994d788}')
    @commethod(3)
    def SetOffsetX(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def SetOffsetX(self, offsetX: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def SetOffsetY(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def SetOffsetY(self, offsetY: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def SetOffsetZ(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def SetOffsetZ(self, offsetZ: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionTurbulenceEffect(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionFilterEffect
    _iid_ = Guid('{a6a55bda-c09c-49f3-9193-a41922c89715}')
    @commethod(4)
    def SetOffset(self, offset: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_VECTOR_2F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def SetBaseFrequency(self, frequency: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_VECTOR_2F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def SetSize(self, size: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_VECTOR_2F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def SetNumOctaves(self, numOctaves: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def SetSeed(self, seed: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def SetNoise(self, noise: win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_TURBULENCE_NOISE) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def SetStitchable(self, stitchable: win32more.Windows.Win32.Foundation.BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionVirtualSurface(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionSurface
    _iid_ = Guid('{ae471c51-5f53-4a24-8d3e-d0c39c30b3f0}')
    @commethod(8)
    def Resize(self, width: UInt32, height: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def Trim(self, rectangles: POINTER(win32more.Windows.Win32.Foundation.RECT), count: UInt32) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionVisual(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{4d93059d-097b-4651-9a60-f0f25116e2f3}')
    @commethod(3)
    def SetOffsetX(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def SetOffsetX(self, offsetX: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(5)
    def SetOffsetY(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(6)
    def SetOffsetY(self, offsetY: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(7)
    def SetTransform(self, transform: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionTransform) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(8)
    def SetTransform(self, matrix: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_3X2_F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(9)
    def SetTransformParent(self, visual: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionVisual) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(10)
    def SetEffect(self, effect: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionEffect) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(11)
    def SetBitmapInterpolationMode(self, interpolationMode: win32more.Windows.Win32.Graphics.DirectComposition.DCOMPOSITION_BITMAP_INTERPOLATION_MODE) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(12)
    def SetBorderMode(self, borderMode: win32more.Windows.Win32.Graphics.DirectComposition.DCOMPOSITION_BORDER_MODE) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(13)
    def SetClip(self, clip: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionClip) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(14)
    def SetClip(self, rect: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_RECT_F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(15)
    def SetContent(self, content: win32more.Windows.Win32.System.Com.IUnknown) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(16)
    def AddVisual(self, visual: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionVisual, insertAbove: win32more.Windows.Win32.Foundation.BOOL, referenceVisual: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionVisual) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(17)
    def RemoveVisual(self, visual: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionVisual) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(18)
    def RemoveAllVisuals(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(19)
    def SetCompositeMode(self, compositeMode: win32more.Windows.Win32.Graphics.DirectComposition.DCOMPOSITION_COMPOSITE_MODE) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionVisual2(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionVisual
    _iid_ = Guid('{e8de1639-4331-4b26-bc5f-6a321d347a85}')
    @commethod(20)
    def SetOpacityMode(self, mode: win32more.Windows.Win32.Graphics.DirectComposition.DCOMPOSITION_OPACITY_MODE) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(21)
    def SetBackFaceVisibility(self, visibility: win32more.Windows.Win32.Graphics.DirectComposition.DCOMPOSITION_BACKFACE_VISIBILITY) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionVisual3(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionVisualDebug
    _iid_ = Guid('{2775f462-b6c1-4015-b0be-b3e7d6a4976d}')
    @commethod(26)
    def SetDepthMode(self, mode: win32more.Windows.Win32.Graphics.DirectComposition.DCOMPOSITION_DEPTH_MODE) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(27)
    def SetOffsetZ(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(28)
    def SetOffsetZ(self, offsetZ: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(29)
    def SetOpacity(self, animation: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionAnimation) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(30)
    def SetOpacity(self, opacity: Single) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(31)
    def SetTransform(self, transform: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionTransform3D) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(32)
    def SetTransform(self, matrix: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D_MATRIX_4X4_F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(33)
    def SetVisible(self, visible: win32more.Windows.Win32.Foundation.BOOL) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IDCompositionVisualDebug(ComPtr):
    extends: win32more.Windows.Win32.Graphics.DirectComposition.IDCompositionVisual2
    _iid_ = Guid('{fed2b808-5eb4-43a0-aea3-35f65280f91b}')
    @commethod(22)
    def EnableHeatMap(self, color: POINTER(win32more.Windows.Win32.Graphics.Direct2D.Common.D2D1_COLOR_F)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(23)
    def DisableHeatMap(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(24)
    def EnableRedrawRegions(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(25)
    def DisableRedrawRegions(self) -> win32more.Windows.Win32.Foundation.HRESULT: ...


make_ready(__name__)
