from __future__ import annotations
from win32more import ARCH, Annotated, Boolean, Byte, Bytes, Char, ComPtr, ConstantLazyLoader, Double, Enum, FAILED, FlexibleArray, Guid, Int16, Int32, Int64, IntPtr, NativeBitfieldAttribute, POINTER, SByte, SUCCEEDED, Single, String, Structure, UInt16, UInt32, UInt64, UIntPtr, UnicodeAlias, Union, Void, VoidPtr, cfunctype, cfunctype_pointer, commethod, make_ready, winfunctype, winfunctype_pointer
import win32more.Windows.Win32.Foundation
import win32more.Windows.Win32.System.Antimalware
import win32more.Windows.Win32.System.Com
AMSI_ATTRIBUTE = Int32
AMSI_ATTRIBUTE_APP_NAME: win32more.Windows.Win32.System.Antimalware.AMSI_ATTRIBUTE = 0
AMSI_ATTRIBUTE_CONTENT_NAME: win32more.Windows.Win32.System.Antimalware.AMSI_ATTRIBUTE = 1
AMSI_ATTRIBUTE_CONTENT_SIZE: win32more.Windows.Win32.System.Antimalware.AMSI_ATTRIBUTE = 2
AMSI_ATTRIBUTE_CONTENT_ADDRESS: win32more.Windows.Win32.System.Antimalware.AMSI_ATTRIBUTE = 3
AMSI_ATTRIBUTE_SESSION: win32more.Windows.Win32.System.Antimalware.AMSI_ATTRIBUTE = 4
AMSI_ATTRIBUTE_REDIRECT_CHAIN_SIZE: win32more.Windows.Win32.System.Antimalware.AMSI_ATTRIBUTE = 5
AMSI_ATTRIBUTE_REDIRECT_CHAIN_ADDRESS: win32more.Windows.Win32.System.Antimalware.AMSI_ATTRIBUTE = 6
AMSI_ATTRIBUTE_ALL_SIZE: win32more.Windows.Win32.System.Antimalware.AMSI_ATTRIBUTE = 7
AMSI_ATTRIBUTE_ALL_ADDRESS: win32more.Windows.Win32.System.Antimalware.AMSI_ATTRIBUTE = 8
AMSI_ATTRIBUTE_QUIET: win32more.Windows.Win32.System.Antimalware.AMSI_ATTRIBUTE = 9
AMSI_RESULT = Int32
AMSI_RESULT_CLEAN: win32more.Windows.Win32.System.Antimalware.AMSI_RESULT = 0
AMSI_RESULT_NOT_DETECTED: win32more.Windows.Win32.System.Antimalware.AMSI_RESULT = 1
AMSI_RESULT_BLOCKED_BY_ADMIN_START: win32more.Windows.Win32.System.Antimalware.AMSI_RESULT = 16384
AMSI_RESULT_BLOCKED_BY_ADMIN_END: win32more.Windows.Win32.System.Antimalware.AMSI_RESULT = 20479
AMSI_RESULT_DETECTED: win32more.Windows.Win32.System.Antimalware.AMSI_RESULT = 32768
AMSI_UAC_MSI_ACTION = Int32
AMSI_UAC_MSI_ACTION_INSTALL: win32more.Windows.Win32.System.Antimalware.AMSI_UAC_MSI_ACTION = 0
AMSI_UAC_MSI_ACTION_UNINSTALL: win32more.Windows.Win32.System.Antimalware.AMSI_UAC_MSI_ACTION = 1
AMSI_UAC_MSI_ACTION_UPDATE: win32more.Windows.Win32.System.Antimalware.AMSI_UAC_MSI_ACTION = 2
AMSI_UAC_MSI_ACTION_MAINTENANCE: win32more.Windows.Win32.System.Antimalware.AMSI_UAC_MSI_ACTION = 3
AMSI_UAC_MSI_ACTION_MAX: win32more.Windows.Win32.System.Antimalware.AMSI_UAC_MSI_ACTION = 4
class AMSI_UAC_REQUEST_AX_INFO(Structure):
    ulLength: UInt32
    lpwszLocalInstallPath: win32more.Windows.Win32.Foundation.PWSTR
    lpwszSourceURL: win32more.Windows.Win32.Foundation.PWSTR
class AMSI_UAC_REQUEST_COM_INFO(Structure):
    ulLength: UInt32
    lpwszServerBinary: win32more.Windows.Win32.Foundation.PWSTR
    lpwszRequestor: win32more.Windows.Win32.Foundation.PWSTR
    Clsid: Guid
class AMSI_UAC_REQUEST_CONTEXT(Structure):
    ulLength: UInt32
    ulRequestorProcessId: UInt32
    UACTrustState: win32more.Windows.Win32.System.Antimalware.AMSI_UAC_TRUST_STATE
    Type: win32more.Windows.Win32.System.Antimalware.AMSI_UAC_REQUEST_TYPE
    RequestType: _RequestType_e__Union
    bAutoElevateRequest: win32more.Windows.Win32.Foundation.BOOL
    class _RequestType_e__Union(Union):
        ExeInfo: win32more.Windows.Win32.System.Antimalware.AMSI_UAC_REQUEST_EXE_INFO
        ComInfo: win32more.Windows.Win32.System.Antimalware.AMSI_UAC_REQUEST_COM_INFO
        MsiInfo: win32more.Windows.Win32.System.Antimalware.AMSI_UAC_REQUEST_MSI_INFO
        ActiveXInfo: win32more.Windows.Win32.System.Antimalware.AMSI_UAC_REQUEST_AX_INFO
        PackagedAppInfo: win32more.Windows.Win32.System.Antimalware.AMSI_UAC_REQUEST_PACKAGED_APP_INFO
class AMSI_UAC_REQUEST_EXE_INFO(Structure):
    ulLength: UInt32
    lpwszApplicationName: win32more.Windows.Win32.Foundation.PWSTR
    lpwszCommandLine: win32more.Windows.Win32.Foundation.PWSTR
    lpwszDLLParameter: win32more.Windows.Win32.Foundation.PWSTR
class AMSI_UAC_REQUEST_MSI_INFO(Structure):
    ulLength: UInt32
    MsiAction: win32more.Windows.Win32.System.Antimalware.AMSI_UAC_MSI_ACTION
    lpwszProductName: win32more.Windows.Win32.Foundation.PWSTR
    lpwszVersion: win32more.Windows.Win32.Foundation.PWSTR
    lpwszLanguage: win32more.Windows.Win32.Foundation.PWSTR
    lpwszManufacturer: win32more.Windows.Win32.Foundation.PWSTR
    lpwszPackagePath: win32more.Windows.Win32.Foundation.PWSTR
    lpwszPackageSource: win32more.Windows.Win32.Foundation.PWSTR
    ulUpdates: UInt32
    ppwszUpdates: POINTER(win32more.Windows.Win32.Foundation.PWSTR)
    ppwszUpdateSources: POINTER(win32more.Windows.Win32.Foundation.PWSTR)
class AMSI_UAC_REQUEST_PACKAGED_APP_INFO(Structure):
    ulLength: UInt32
    lpwszApplicationName: win32more.Windows.Win32.Foundation.PWSTR
    lpwszCommandLine: win32more.Windows.Win32.Foundation.PWSTR
    lpPackageFamilyName: win32more.Windows.Win32.Foundation.PWSTR
    lpApplicationId: win32more.Windows.Win32.Foundation.PWSTR
AMSI_UAC_REQUEST_TYPE = Int32
AMSI_UAC_REQUEST_TYPE_EXE: win32more.Windows.Win32.System.Antimalware.AMSI_UAC_REQUEST_TYPE = 0
AMSI_UAC_REQUEST_TYPE_COM: win32more.Windows.Win32.System.Antimalware.AMSI_UAC_REQUEST_TYPE = 1
AMSI_UAC_REQUEST_TYPE_MSI: win32more.Windows.Win32.System.Antimalware.AMSI_UAC_REQUEST_TYPE = 2
AMSI_UAC_REQUEST_TYPE_AX: win32more.Windows.Win32.System.Antimalware.AMSI_UAC_REQUEST_TYPE = 3
AMSI_UAC_REQUEST_TYPE_PACKAGED_APP: win32more.Windows.Win32.System.Antimalware.AMSI_UAC_REQUEST_TYPE = 4
AMSI_UAC_REQUEST_TYPE_MAX: win32more.Windows.Win32.System.Antimalware.AMSI_UAC_REQUEST_TYPE = 5
AMSI_UAC_TRUST_STATE = Int32
AMSI_UAC_TRUST_STATE_TRUSTED: win32more.Windows.Win32.System.Antimalware.AMSI_UAC_TRUST_STATE = 0
AMSI_UAC_TRUST_STATE_UNTRUSTED: win32more.Windows.Win32.System.Antimalware.AMSI_UAC_TRUST_STATE = 1
AMSI_UAC_TRUST_STATE_BLOCKED: win32more.Windows.Win32.System.Antimalware.AMSI_UAC_TRUST_STATE = 2
AMSI_UAC_TRUST_STATE_MAX: win32more.Windows.Win32.System.Antimalware.AMSI_UAC_TRUST_STATE = 3
@winfunctype('Amsi.dll')
def AmsiInitialize(appName: win32more.Windows.Win32.Foundation.PWSTR, amsiContext: POINTER(win32more.Windows.Win32.System.Antimalware.HAMSICONTEXT)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
@winfunctype('Amsi.dll')
def AmsiUninitialize(amsiContext: win32more.Windows.Win32.System.Antimalware.HAMSICONTEXT) -> Void: ...
@winfunctype('Amsi.dll')
def AmsiOpenSession(amsiContext: win32more.Windows.Win32.System.Antimalware.HAMSICONTEXT, amsiSession: POINTER(win32more.Windows.Win32.System.Antimalware.HAMSISESSION)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
@winfunctype('Amsi.dll')
def AmsiCloseSession(amsiContext: win32more.Windows.Win32.System.Antimalware.HAMSICONTEXT, amsiSession: win32more.Windows.Win32.System.Antimalware.HAMSISESSION) -> Void: ...
@winfunctype('Amsi.dll')
def AmsiScanBuffer(amsiContext: win32more.Windows.Win32.System.Antimalware.HAMSICONTEXT, buffer: VoidPtr, length: UInt32, contentName: win32more.Windows.Win32.Foundation.PWSTR, amsiSession: win32more.Windows.Win32.System.Antimalware.HAMSISESSION, result: POINTER(win32more.Windows.Win32.System.Antimalware.AMSI_RESULT)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
@winfunctype('Amsi.dll')
def AmsiNotifyOperation(amsiContext: win32more.Windows.Win32.System.Antimalware.HAMSICONTEXT, buffer: VoidPtr, length: UInt32, contentName: win32more.Windows.Win32.Foundation.PWSTR, result: POINTER(win32more.Windows.Win32.System.Antimalware.AMSI_RESULT)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
@winfunctype('Amsi.dll')
def AmsiScanString(amsiContext: win32more.Windows.Win32.System.Antimalware.HAMSICONTEXT, string: win32more.Windows.Win32.Foundation.PWSTR, contentName: win32more.Windows.Win32.Foundation.PWSTR, amsiSession: win32more.Windows.Win32.System.Antimalware.HAMSISESSION, result: POINTER(win32more.Windows.Win32.System.Antimalware.AMSI_RESULT)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
@winfunctype('KERNEL32.dll')
def InstallELAMCertificateInfo(ELAMFile: win32more.Windows.Win32.Foundation.HANDLE) -> win32more.Windows.Win32.Foundation.BOOL: ...
CAntimalware = Guid('{fdb00e52-a214-4aa1-8fba-4357bb0072ec}')
HAMSICONTEXT = VoidPtr
HAMSISESSION = VoidPtr
class IAmsiStream(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{3e47f2e5-81d4-4d3b-897f-545096770373}')
    @commethod(3)
    def GetAttribute(self, attribute: win32more.Windows.Win32.System.Antimalware.AMSI_ATTRIBUTE, dataSize: UInt32, data: POINTER(Byte), retData: POINTER(UInt32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def Read(self, position: UInt64, size: UInt32, buffer: POINTER(Byte), readSize: POINTER(UInt32)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IAntimalware(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{82d29c2e-f062-44e6-b5c9-3d9a2f24a2df}')
    @commethod(3)
    def Scan(self, stream: win32more.Windows.Win32.System.Antimalware.IAmsiStream, result: POINTER(win32more.Windows.Win32.System.Antimalware.AMSI_RESULT), provider: POINTER(win32more.Windows.Win32.System.Antimalware.IAntimalwareProvider)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def CloseSession(self, session: UInt64) -> Void: ...
class IAntimalware2(ComPtr):
    extends: win32more.Windows.Win32.System.Antimalware.IAntimalware
    _iid_ = Guid('{301035b5-2d42-4f56-8c65-2dcaa7fb3cdc}')
    @commethod(5)
    def Notify(self, buffer: VoidPtr, length: UInt32, contentName: win32more.Windows.Win32.Foundation.PWSTR, appName: win32more.Windows.Win32.Foundation.PWSTR, pResult: POINTER(win32more.Windows.Win32.System.Antimalware.AMSI_RESULT)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IAntimalwareProvider(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{b2cabfe3-fe04-42b1-a5df-08d483d4d125}')
    @commethod(3)
    def Scan(self, stream: win32more.Windows.Win32.System.Antimalware.IAmsiStream, result: POINTER(win32more.Windows.Win32.System.Antimalware.AMSI_RESULT)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def CloseSession(self, session: UInt64) -> Void: ...
    @commethod(5)
    def DisplayName(self, displayName: POINTER(win32more.Windows.Win32.Foundation.PWSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IAntimalwareProvider2(ComPtr):
    extends: win32more.Windows.Win32.System.Antimalware.IAntimalwareProvider
    _iid_ = Guid('{7c1e6570-3f73-4e0f-8ad4-98b94cd3290f}')
    @commethod(6)
    def Notify(self, buffer: VoidPtr, length: UInt32, contentName: win32more.Windows.Win32.Foundation.PWSTR, appName: win32more.Windows.Win32.Foundation.PWSTR, pResult: POINTER(win32more.Windows.Win32.System.Antimalware.AMSI_RESULT)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
class IAntimalwareUacProvider(ComPtr):
    extends: win32more.Windows.Win32.System.Com.IUnknown
    _iid_ = Guid('{b2cabfe4-fe04-42b1-a5df-08d483d4d125}')
    @commethod(3)
    def UacScan(self, context: POINTER(win32more.Windows.Win32.System.Antimalware.AMSI_UAC_REQUEST_CONTEXT), result: POINTER(win32more.Windows.Win32.System.Antimalware.AMSI_RESULT)) -> win32more.Windows.Win32.Foundation.HRESULT: ...
    @commethod(4)
    def DisplayName(self, displayName: POINTER(win32more.Windows.Win32.Foundation.PWSTR)) -> win32more.Windows.Win32.Foundation.HRESULT: ...


make_ready(__name__)
