from __future__ import annotations
from win32more.winrt.prelude import *
import win32more.Microsoft.Graphics.Canvas
import win32more.Microsoft.Graphics.Canvas.Effects
import win32more.Windows.Foundation
import win32more.Windows.Foundation.Collections
import win32more.Windows.Foundation.Numerics
import win32more.Windows.Graphics.DirectX
import win32more.Windows.Graphics.Effects
import win32more.Windows.UI
class _AlphaMaskEffect_Meta_(ComPtr.__class__):
    pass
class AlphaMaskEffect(ComPtr, metaclass=_AlphaMaskEffect_Meta_):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IAlphaMaskEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.AlphaMaskEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.AlphaMaskEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.AlphaMaskEffect: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IAlphaMaskEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IAlphaMaskEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_AlphaMask(self: win32more.Microsoft.Graphics.Canvas.Effects.IAlphaMaskEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_AlphaMask(self: win32more.Microsoft.Graphics.Canvas.Effects.IAlphaMaskEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    @winrt_classmethod
    def get_IsSupported(cls: win32more.Microsoft.Graphics.Canvas.Effects.IAlphaMaskEffectStatics) -> Boolean: ...
    AlphaMask = property(get_AlphaMask, put_AlphaMask)
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)
    _AlphaMaskEffect_Meta_.IsSupported = property(get_IsSupported, None)
class ArithmeticCompositeEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IArithmeticCompositeEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.ArithmeticCompositeEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.ArithmeticCompositeEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.ArithmeticCompositeEffect: ...
    @winrt_mixinmethod
    def get_ClampOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.IArithmeticCompositeEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_ClampOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.IArithmeticCompositeEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_MultiplyAmount(self: win32more.Microsoft.Graphics.Canvas.Effects.IArithmeticCompositeEffect) -> Single: ...
    @winrt_mixinmethod
    def put_MultiplyAmount(self: win32more.Microsoft.Graphics.Canvas.Effects.IArithmeticCompositeEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Source1Amount(self: win32more.Microsoft.Graphics.Canvas.Effects.IArithmeticCompositeEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Source1Amount(self: win32more.Microsoft.Graphics.Canvas.Effects.IArithmeticCompositeEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Source2Amount(self: win32more.Microsoft.Graphics.Canvas.Effects.IArithmeticCompositeEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Source2Amount(self: win32more.Microsoft.Graphics.Canvas.Effects.IArithmeticCompositeEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Offset(self: win32more.Microsoft.Graphics.Canvas.Effects.IArithmeticCompositeEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Offset(self: win32more.Microsoft.Graphics.Canvas.Effects.IArithmeticCompositeEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Source1(self: win32more.Microsoft.Graphics.Canvas.Effects.IArithmeticCompositeEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source1(self: win32more.Microsoft.Graphics.Canvas.Effects.IArithmeticCompositeEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_Source2(self: win32more.Microsoft.Graphics.Canvas.Effects.IArithmeticCompositeEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source2(self: win32more.Microsoft.Graphics.Canvas.Effects.IArithmeticCompositeEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    ClampOutput = property(get_ClampOutput, put_ClampOutput)
    MultiplyAmount = property(get_MultiplyAmount, put_MultiplyAmount)
    Name = property(get_Name, put_Name)
    Offset = property(get_Offset, put_Offset)
    Source1 = property(get_Source1, put_Source1)
    Source1Amount = property(get_Source1Amount, put_Source1Amount)
    Source2 = property(get_Source2, put_Source2)
    Source2Amount = property(get_Source2Amount, put_Source2Amount)
class AtlasEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IAtlasEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.AtlasEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.AtlasEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.AtlasEffect: ...
    @winrt_mixinmethod
    def get_SourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.IAtlasEffect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def put_SourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.IAtlasEffect, value: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def get_PaddingRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.IAtlasEffect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def put_PaddingRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.IAtlasEffect, value: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IAtlasEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IAtlasEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Name = property(get_Name, put_Name)
    PaddingRectangle = property(get_PaddingRectangle, put_PaddingRectangle)
    Source = property(get_Source, put_Source)
    SourceRectangle = property(get_SourceRectangle, put_SourceRectangle)
class BlendEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IBlendEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.BlendEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.BlendEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.BlendEffect: ...
    @winrt_mixinmethod
    def get_Mode(self: win32more.Microsoft.Graphics.Canvas.Effects.IBlendEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.BlendEffectMode: ...
    @winrt_mixinmethod
    def put_Mode(self: win32more.Microsoft.Graphics.Canvas.Effects.IBlendEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.BlendEffectMode) -> Void: ...
    @winrt_mixinmethod
    def get_Background(self: win32more.Microsoft.Graphics.Canvas.Effects.IBlendEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Background(self: win32more.Microsoft.Graphics.Canvas.Effects.IBlendEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_Foreground(self: win32more.Microsoft.Graphics.Canvas.Effects.IBlendEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Foreground(self: win32more.Microsoft.Graphics.Canvas.Effects.IBlendEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    Background = property(get_Background, put_Background)
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Foreground = property(get_Foreground, put_Foreground)
    Mode = property(get_Mode, put_Mode)
    Name = property(get_Name, put_Name)
class BlendEffectMode(Enum, Int32):
    Multiply = 0
    Screen = 1
    Darken = 2
    Lighten = 3
    Dissolve = 4
    ColorBurn = 5
    LinearBurn = 6
    DarkerColor = 7
    LighterColor = 8
    ColorDodge = 9
    LinearDodge = 10
    Overlay = 11
    SoftLight = 12
    HardLight = 13
    VividLight = 14
    LinearLight = 15
    PinLight = 16
    HardMix = 17
    Difference = 18
    Exclusion = 19
    Hue = 20
    Saturation = 21
    Color = 22
    Luminosity = 23
    Subtract = 24
    Division = 25
class BorderEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IBorderEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.BorderEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.BorderEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.BorderEffect: ...
    @winrt_mixinmethod
    def get_ExtendX(self: win32more.Microsoft.Graphics.Canvas.Effects.IBorderEffect) -> win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior: ...
    @winrt_mixinmethod
    def put_ExtendX(self: win32more.Microsoft.Graphics.Canvas.Effects.IBorderEffect, value: win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior) -> Void: ...
    @winrt_mixinmethod
    def get_ExtendY(self: win32more.Microsoft.Graphics.Canvas.Effects.IBorderEffect) -> win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior: ...
    @winrt_mixinmethod
    def put_ExtendY(self: win32more.Microsoft.Graphics.Canvas.Effects.IBorderEffect, value: win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IBorderEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IBorderEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    ExtendX = property(get_ExtendX, put_ExtendX)
    ExtendY = property(get_ExtendY, put_ExtendY)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)
class BrightnessEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IBrightnessEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.BrightnessEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.BrightnessEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.BrightnessEffect: ...
    @winrt_mixinmethod
    def get_WhitePoint(self: win32more.Microsoft.Graphics.Canvas.Effects.IBrightnessEffect) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_mixinmethod
    def put_WhitePoint(self: win32more.Microsoft.Graphics.Canvas.Effects.IBrightnessEffect, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_mixinmethod
    def get_BlackPoint(self: win32more.Microsoft.Graphics.Canvas.Effects.IBrightnessEffect) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_mixinmethod
    def put_BlackPoint(self: win32more.Microsoft.Graphics.Canvas.Effects.IBrightnessEffect, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IBrightnessEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IBrightnessEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BlackPoint = property(get_BlackPoint, put_BlackPoint)
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)
    WhitePoint = property(get_WhitePoint, put_WhitePoint)
class ChromaKeyEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IChromaKeyEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.ChromaKeyEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.ChromaKeyEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.ChromaKeyEffect: ...
    @winrt_mixinmethod
    def get_Color(self: win32more.Microsoft.Graphics.Canvas.Effects.IChromaKeyEffect) -> win32more.Windows.UI.Color: ...
    @winrt_mixinmethod
    def put_Color(self: win32more.Microsoft.Graphics.Canvas.Effects.IChromaKeyEffect, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def get_Tolerance(self: win32more.Microsoft.Graphics.Canvas.Effects.IChromaKeyEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Tolerance(self: win32more.Microsoft.Graphics.Canvas.Effects.IChromaKeyEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_InvertAlpha(self: win32more.Microsoft.Graphics.Canvas.Effects.IChromaKeyEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_InvertAlpha(self: win32more.Microsoft.Graphics.Canvas.Effects.IChromaKeyEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_Feather(self: win32more.Microsoft.Graphics.Canvas.Effects.IChromaKeyEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_Feather(self: win32more.Microsoft.Graphics.Canvas.Effects.IChromaKeyEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_ColorHdr(self: win32more.Microsoft.Graphics.Canvas.Effects.IChromaKeyEffect) -> win32more.Windows.Foundation.Numerics.Vector4: ...
    @winrt_mixinmethod
    def put_ColorHdr(self: win32more.Microsoft.Graphics.Canvas.Effects.IChromaKeyEffect, value: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IChromaKeyEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IChromaKeyEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Color = property(get_Color, put_Color)
    ColorHdr = property(get_ColorHdr, put_ColorHdr)
    Feather = property(get_Feather, put_Feather)
    InvertAlpha = property(get_InvertAlpha, put_InvertAlpha)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)
    Tolerance = property(get_Tolerance, put_Tolerance)
class ColorManagementEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IColorManagementEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.ColorManagementEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementEffect: ...
    @winrt_mixinmethod
    def get_SourceColorProfile(self: win32more.Microsoft.Graphics.Canvas.Effects.IColorManagementEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementProfile: ...
    @winrt_mixinmethod
    def put_SourceColorProfile(self: win32more.Microsoft.Graphics.Canvas.Effects.IColorManagementEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementProfile) -> Void: ...
    @winrt_mixinmethod
    def get_SourceRenderingIntent(self: win32more.Microsoft.Graphics.Canvas.Effects.IColorManagementEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementRenderingIntent: ...
    @winrt_mixinmethod
    def put_SourceRenderingIntent(self: win32more.Microsoft.Graphics.Canvas.Effects.IColorManagementEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementRenderingIntent) -> Void: ...
    @winrt_mixinmethod
    def get_OutputColorProfile(self: win32more.Microsoft.Graphics.Canvas.Effects.IColorManagementEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementProfile: ...
    @winrt_mixinmethod
    def put_OutputColorProfile(self: win32more.Microsoft.Graphics.Canvas.Effects.IColorManagementEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementProfile) -> Void: ...
    @winrt_mixinmethod
    def get_OutputRenderingIntent(self: win32more.Microsoft.Graphics.Canvas.Effects.IColorManagementEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementRenderingIntent: ...
    @winrt_mixinmethod
    def put_OutputRenderingIntent(self: win32more.Microsoft.Graphics.Canvas.Effects.IColorManagementEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementRenderingIntent) -> Void: ...
    @winrt_mixinmethod
    def get_AlphaMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IColorManagementEffect) -> win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode: ...
    @winrt_mixinmethod
    def put_AlphaMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IColorManagementEffect, value: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> Void: ...
    @winrt_mixinmethod
    def get_Quality(self: win32more.Microsoft.Graphics.Canvas.Effects.IColorManagementEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementEffectQuality: ...
    @winrt_mixinmethod
    def put_Quality(self: win32more.Microsoft.Graphics.Canvas.Effects.IColorManagementEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementEffectQuality) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IColorManagementEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IColorManagementEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    @winrt_classmethod
    def IsBestQualitySupported(cls: win32more.Microsoft.Graphics.Canvas.Effects.IColorManagementEffectStatics, device: win32more.Microsoft.Graphics.Canvas.CanvasDevice) -> Boolean: ...
    AlphaMode = property(get_AlphaMode, put_AlphaMode)
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Name = property(get_Name, put_Name)
    OutputColorProfile = property(get_OutputColorProfile, put_OutputColorProfile)
    OutputRenderingIntent = property(get_OutputRenderingIntent, put_OutputRenderingIntent)
    Quality = property(get_Quality, put_Quality)
    Source = property(get_Source, put_Source)
    SourceColorProfile = property(get_SourceColorProfile, put_SourceColorProfile)
    SourceRenderingIntent = property(get_SourceRenderingIntent, put_SourceRenderingIntent)
class ColorManagementEffectQuality(Enum, Int32):
    Proof = 0
    Normal = 1
    Best = 2
class ColorManagementGamma(Enum, Int32):
    G22 = 0
    G10 = 1
    G2084 = 2
class ColorManagementProfile(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IColorManagementProfile
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.ColorManagementProfile'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementProfile.Create(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def Create(cls: win32more.Microsoft.Graphics.Canvas.Effects.IColorManagementProfileFactory, colorSpace: win32more.Microsoft.Graphics.Canvas.CanvasColorSpace) -> win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementProfile: ...
    @winrt_mixinmethod
    def get_ColorSpace(self: win32more.Microsoft.Graphics.Canvas.Effects.IColorManagementProfile) -> win32more.Microsoft.Graphics.Canvas.CanvasColorSpace: ...
    @winrt_mixinmethod
    def get_IccProfile(self: win32more.Microsoft.Graphics.Canvas.Effects.IColorManagementProfile) -> ReceiveArray[Byte]: ...
    @winrt_mixinmethod
    def get_Type(self: win32more.Microsoft.Graphics.Canvas.Effects.IColorManagementProfile) -> win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementProfileType: ...
    @winrt_mixinmethod
    def get_SimpleProfile(self: win32more.Microsoft.Graphics.Canvas.Effects.IColorManagementProfile) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementSimpleProfile]: ...
    @winrt_mixinmethod
    def get_ExtendedColorSpace(self: win32more.Microsoft.Graphics.Canvas.Effects.IColorManagementProfile) -> win32more.Microsoft.Graphics.Canvas.Effects.ExtendedColorSpace: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    @winrt_classmethod
    def CreateCustom(cls: win32more.Microsoft.Graphics.Canvas.Effects.IColorManagementProfileStatics, iccProfile: PassArray[Byte]) -> win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementProfile: ...
    @winrt_classmethod
    def CreateSimple(cls: win32more.Microsoft.Graphics.Canvas.Effects.IColorManagementProfileStatics, simpleProfile: win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementSimpleProfile) -> win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementProfile: ...
    @winrt_classmethod
    def CreateExtended(cls: win32more.Microsoft.Graphics.Canvas.Effects.IColorManagementProfileStatics, colorSpace: win32more.Microsoft.Graphics.Canvas.Effects.ExtendedColorSpace) -> win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementProfile: ...
    @winrt_classmethod
    def IsSupported(cls: win32more.Microsoft.Graphics.Canvas.Effects.IColorManagementProfileStatics, type: win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementProfileType, device: win32more.Microsoft.Graphics.Canvas.CanvasDevice) -> Boolean: ...
    ColorSpace = property(get_ColorSpace, None)
    ExtendedColorSpace = property(get_ExtendedColorSpace, None)
    IccProfile = property(get_IccProfile, None)
    SimpleProfile = property(get_SimpleProfile, None)
    Type = property(get_Type, None)
class ColorManagementProfileType(Enum, Int32):
    Icc = 0
    Simple = 1
    Extended = 2
class ColorManagementRenderingIntent(Enum, Int32):
    Perceptual = 0
    RelativeColorimetric = 1
    Saturation = 2
    AbsoluteColorimetric = 3
class ColorManagementSimpleProfile(Structure):
    RedPrimary: win32more.Windows.Foundation.Numerics.Vector2
    GreenPrimary: win32more.Windows.Foundation.Numerics.Vector2
    BluePrimary: win32more.Windows.Foundation.Numerics.Vector2
    WhitePointXZ: win32more.Windows.Foundation.Numerics.Vector2
    Gamma: win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementGamma
class ColorMatrixEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IColorMatrixEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.ColorMatrixEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.ColorMatrixEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.ColorMatrixEffect: ...
    @winrt_mixinmethod
    def get_ColorMatrix(self: win32more.Microsoft.Graphics.Canvas.Effects.IColorMatrixEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.Matrix5x4: ...
    @winrt_mixinmethod
    def put_ColorMatrix(self: win32more.Microsoft.Graphics.Canvas.Effects.IColorMatrixEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.Matrix5x4) -> Void: ...
    @winrt_mixinmethod
    def get_AlphaMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IColorMatrixEffect) -> win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode: ...
    @winrt_mixinmethod
    def put_AlphaMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IColorMatrixEffect, value: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> Void: ...
    @winrt_mixinmethod
    def get_ClampOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.IColorMatrixEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_ClampOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.IColorMatrixEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IColorMatrixEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IColorMatrixEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    AlphaMode = property(get_AlphaMode, put_AlphaMode)
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    ClampOutput = property(get_ClampOutput, put_ClampOutput)
    ColorMatrix = property(get_ColorMatrix, put_ColorMatrix)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)
class ColorSourceEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IColorSourceEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.ColorSourceEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.ColorSourceEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.ColorSourceEffect: ...
    @winrt_mixinmethod
    def get_Color(self: win32more.Microsoft.Graphics.Canvas.Effects.IColorSourceEffect) -> win32more.Windows.UI.Color: ...
    @winrt_mixinmethod
    def put_Color(self: win32more.Microsoft.Graphics.Canvas.Effects.IColorSourceEffect, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def get_ColorHdr(self: win32more.Microsoft.Graphics.Canvas.Effects.IColorSourceEffect) -> win32more.Windows.Foundation.Numerics.Vector4: ...
    @winrt_mixinmethod
    def put_ColorHdr(self: win32more.Microsoft.Graphics.Canvas.Effects.IColorSourceEffect, value: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Color = property(get_Color, put_Color)
    ColorHdr = property(get_ColorHdr, put_ColorHdr)
    Name = property(get_Name, put_Name)
class CompositeEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.ICompositeEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.CompositeEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.CompositeEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.CompositeEffect: ...
    @winrt_mixinmethod
    def get_Mode(self: win32more.Microsoft.Graphics.Canvas.Effects.ICompositeEffect) -> win32more.Microsoft.Graphics.Canvas.CanvasComposite: ...
    @winrt_mixinmethod
    def put_Mode(self: win32more.Microsoft.Graphics.Canvas.Effects.ICompositeEffect, value: win32more.Microsoft.Graphics.Canvas.CanvasComposite) -> Void: ...
    @winrt_mixinmethod
    def get_Sources(self: win32more.Microsoft.Graphics.Canvas.Effects.ICompositeEffect) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Graphics.Effects.IGraphicsEffectSource]: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Mode = property(get_Mode, put_Mode)
    Name = property(get_Name, put_Name)
    Sources = property(get_Sources, None)
class ContrastEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IContrastEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.ContrastEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.ContrastEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.ContrastEffect: ...
    @winrt_mixinmethod
    def get_Contrast(self: win32more.Microsoft.Graphics.Canvas.Effects.IContrastEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Contrast(self: win32more.Microsoft.Graphics.Canvas.Effects.IContrastEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_ClampSource(self: win32more.Microsoft.Graphics.Canvas.Effects.IContrastEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_ClampSource(self: win32more.Microsoft.Graphics.Canvas.Effects.IContrastEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IContrastEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IContrastEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    ClampSource = property(get_ClampSource, put_ClampSource)
    Contrast = property(get_Contrast, put_Contrast)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)
class ConvolveMatrixEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IConvolveMatrixEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.ConvolveMatrixEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.ConvolveMatrixEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.ConvolveMatrixEffect: ...
    @winrt_mixinmethod
    def get_KernelScale(self: win32more.Microsoft.Graphics.Canvas.Effects.IConvolveMatrixEffect) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_mixinmethod
    def put_KernelScale(self: win32more.Microsoft.Graphics.Canvas.Effects.IConvolveMatrixEffect, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_mixinmethod
    def get_InterpolationMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IConvolveMatrixEffect) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_mixinmethod
    def put_InterpolationMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IConvolveMatrixEffect, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_mixinmethod
    def get_KernelWidth(self: win32more.Microsoft.Graphics.Canvas.Effects.IConvolveMatrixEffect) -> Int32: ...
    @winrt_mixinmethod
    def put_KernelWidth(self: win32more.Microsoft.Graphics.Canvas.Effects.IConvolveMatrixEffect, value: Int32) -> Void: ...
    @winrt_mixinmethod
    def get_KernelHeight(self: win32more.Microsoft.Graphics.Canvas.Effects.IConvolveMatrixEffect) -> Int32: ...
    @winrt_mixinmethod
    def put_KernelHeight(self: win32more.Microsoft.Graphics.Canvas.Effects.IConvolveMatrixEffect, value: Int32) -> Void: ...
    @winrt_mixinmethod
    def get_KernelMatrix(self: win32more.Microsoft.Graphics.Canvas.Effects.IConvolveMatrixEffect) -> ReceiveArray[Single]: ...
    @winrt_mixinmethod
    def put_KernelMatrix(self: win32more.Microsoft.Graphics.Canvas.Effects.IConvolveMatrixEffect, valueElements: PassArray[Single]) -> Void: ...
    @winrt_mixinmethod
    def get_Divisor(self: win32more.Microsoft.Graphics.Canvas.Effects.IConvolveMatrixEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Divisor(self: win32more.Microsoft.Graphics.Canvas.Effects.IConvolveMatrixEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Offset(self: win32more.Microsoft.Graphics.Canvas.Effects.IConvolveMatrixEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Offset(self: win32more.Microsoft.Graphics.Canvas.Effects.IConvolveMatrixEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_KernelOffset(self: win32more.Microsoft.Graphics.Canvas.Effects.IConvolveMatrixEffect) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_mixinmethod
    def put_KernelOffset(self: win32more.Microsoft.Graphics.Canvas.Effects.IConvolveMatrixEffect, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_mixinmethod
    def get_PreserveAlpha(self: win32more.Microsoft.Graphics.Canvas.Effects.IConvolveMatrixEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_PreserveAlpha(self: win32more.Microsoft.Graphics.Canvas.Effects.IConvolveMatrixEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BorderMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IConvolveMatrixEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode: ...
    @winrt_mixinmethod
    def put_BorderMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IConvolveMatrixEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode) -> Void: ...
    @winrt_mixinmethod
    def get_ClampOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.IConvolveMatrixEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_ClampOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.IConvolveMatrixEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IConvolveMatrixEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IConvolveMatrixEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BorderMode = property(get_BorderMode, put_BorderMode)
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    ClampOutput = property(get_ClampOutput, put_ClampOutput)
    Divisor = property(get_Divisor, put_Divisor)
    InterpolationMode = property(get_InterpolationMode, put_InterpolationMode)
    KernelHeight = property(get_KernelHeight, put_KernelHeight)
    KernelMatrix = property(get_KernelMatrix, put_KernelMatrix)
    KernelOffset = property(get_KernelOffset, put_KernelOffset)
    KernelScale = property(get_KernelScale, put_KernelScale)
    KernelWidth = property(get_KernelWidth, put_KernelWidth)
    Name = property(get_Name, put_Name)
    Offset = property(get_Offset, put_Offset)
    PreserveAlpha = property(get_PreserveAlpha, put_PreserveAlpha)
    Source = property(get_Source, put_Source)
class CropEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.ICropEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.CropEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.CropEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.CropEffect: ...
    @winrt_mixinmethod
    def get_SourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICropEffect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def put_SourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICropEffect, value: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def get_BorderMode(self: win32more.Microsoft.Graphics.Canvas.Effects.ICropEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode: ...
    @winrt_mixinmethod
    def put_BorderMode(self: win32more.Microsoft.Graphics.Canvas.Effects.ICropEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.ICropEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.ICropEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BorderMode = property(get_BorderMode, put_BorderMode)
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)
    SourceRectangle = property(get_SourceRectangle, put_SourceRectangle)
class _CrossFadeEffect_Meta_(ComPtr.__class__):
    pass
class CrossFadeEffect(ComPtr, metaclass=_CrossFadeEffect_Meta_):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.ICrossFadeEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.CrossFadeEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.CrossFadeEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.CrossFadeEffect: ...
    @winrt_mixinmethod
    def get_CrossFade(self: win32more.Microsoft.Graphics.Canvas.Effects.ICrossFadeEffect) -> Single: ...
    @winrt_mixinmethod
    def put_CrossFade(self: win32more.Microsoft.Graphics.Canvas.Effects.ICrossFadeEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Source2(self: win32more.Microsoft.Graphics.Canvas.Effects.ICrossFadeEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source2(self: win32more.Microsoft.Graphics.Canvas.Effects.ICrossFadeEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_Source1(self: win32more.Microsoft.Graphics.Canvas.Effects.ICrossFadeEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source1(self: win32more.Microsoft.Graphics.Canvas.Effects.ICrossFadeEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    @winrt_classmethod
    def get_IsSupported(cls: win32more.Microsoft.Graphics.Canvas.Effects.ICrossFadeEffectStatics) -> Boolean: ...
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    CrossFade = property(get_CrossFade, put_CrossFade)
    Name = property(get_Name, put_Name)
    Source1 = property(get_Source1, put_Source1)
    Source2 = property(get_Source2, put_Source2)
    _CrossFadeEffect_Meta_.IsSupported = property(get_IsSupported, None)
class DirectionalBlurEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IDirectionalBlurEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.DirectionalBlurEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.DirectionalBlurEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.DirectionalBlurEffect: ...
    @winrt_mixinmethod
    def get_BlurAmount(self: win32more.Microsoft.Graphics.Canvas.Effects.IDirectionalBlurEffect) -> Single: ...
    @winrt_mixinmethod
    def put_BlurAmount(self: win32more.Microsoft.Graphics.Canvas.Effects.IDirectionalBlurEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Angle(self: win32more.Microsoft.Graphics.Canvas.Effects.IDirectionalBlurEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Angle(self: win32more.Microsoft.Graphics.Canvas.Effects.IDirectionalBlurEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Optimization(self: win32more.Microsoft.Graphics.Canvas.Effects.IDirectionalBlurEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectOptimization: ...
    @winrt_mixinmethod
    def put_Optimization(self: win32more.Microsoft.Graphics.Canvas.Effects.IDirectionalBlurEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectOptimization) -> Void: ...
    @winrt_mixinmethod
    def get_BorderMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IDirectionalBlurEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode: ...
    @winrt_mixinmethod
    def put_BorderMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IDirectionalBlurEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IDirectionalBlurEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IDirectionalBlurEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    Angle = property(get_Angle, put_Angle)
    BlurAmount = property(get_BlurAmount, put_BlurAmount)
    BorderMode = property(get_BorderMode, put_BorderMode)
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Name = property(get_Name, put_Name)
    Optimization = property(get_Optimization, put_Optimization)
    Source = property(get_Source, put_Source)
class DiscreteTransferEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IDiscreteTransferEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.DiscreteTransferEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.DiscreteTransferEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.DiscreteTransferEffect: ...
    @winrt_mixinmethod
    def get_RedTable(self: win32more.Microsoft.Graphics.Canvas.Effects.IDiscreteTransferEffect) -> ReceiveArray[Single]: ...
    @winrt_mixinmethod
    def put_RedTable(self: win32more.Microsoft.Graphics.Canvas.Effects.IDiscreteTransferEffect, valueElements: PassArray[Single]) -> Void: ...
    @winrt_mixinmethod
    def get_RedDisable(self: win32more.Microsoft.Graphics.Canvas.Effects.IDiscreteTransferEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_RedDisable(self: win32more.Microsoft.Graphics.Canvas.Effects.IDiscreteTransferEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_GreenTable(self: win32more.Microsoft.Graphics.Canvas.Effects.IDiscreteTransferEffect) -> ReceiveArray[Single]: ...
    @winrt_mixinmethod
    def put_GreenTable(self: win32more.Microsoft.Graphics.Canvas.Effects.IDiscreteTransferEffect, valueElements: PassArray[Single]) -> Void: ...
    @winrt_mixinmethod
    def get_GreenDisable(self: win32more.Microsoft.Graphics.Canvas.Effects.IDiscreteTransferEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_GreenDisable(self: win32more.Microsoft.Graphics.Canvas.Effects.IDiscreteTransferEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BlueTable(self: win32more.Microsoft.Graphics.Canvas.Effects.IDiscreteTransferEffect) -> ReceiveArray[Single]: ...
    @winrt_mixinmethod
    def put_BlueTable(self: win32more.Microsoft.Graphics.Canvas.Effects.IDiscreteTransferEffect, valueElements: PassArray[Single]) -> Void: ...
    @winrt_mixinmethod
    def get_BlueDisable(self: win32more.Microsoft.Graphics.Canvas.Effects.IDiscreteTransferEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_BlueDisable(self: win32more.Microsoft.Graphics.Canvas.Effects.IDiscreteTransferEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_AlphaTable(self: win32more.Microsoft.Graphics.Canvas.Effects.IDiscreteTransferEffect) -> ReceiveArray[Single]: ...
    @winrt_mixinmethod
    def put_AlphaTable(self: win32more.Microsoft.Graphics.Canvas.Effects.IDiscreteTransferEffect, valueElements: PassArray[Single]) -> Void: ...
    @winrt_mixinmethod
    def get_AlphaDisable(self: win32more.Microsoft.Graphics.Canvas.Effects.IDiscreteTransferEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_AlphaDisable(self: win32more.Microsoft.Graphics.Canvas.Effects.IDiscreteTransferEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_ClampOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.IDiscreteTransferEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_ClampOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.IDiscreteTransferEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IDiscreteTransferEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IDiscreteTransferEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    AlphaDisable = property(get_AlphaDisable, put_AlphaDisable)
    AlphaTable = property(get_AlphaTable, put_AlphaTable)
    BlueDisable = property(get_BlueDisable, put_BlueDisable)
    BlueTable = property(get_BlueTable, put_BlueTable)
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    ClampOutput = property(get_ClampOutput, put_ClampOutput)
    GreenDisable = property(get_GreenDisable, put_GreenDisable)
    GreenTable = property(get_GreenTable, put_GreenTable)
    Name = property(get_Name, put_Name)
    RedDisable = property(get_RedDisable, put_RedDisable)
    RedTable = property(get_RedTable, put_RedTable)
    Source = property(get_Source, put_Source)
class DisplacementMapEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IDisplacementMapEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.DisplacementMapEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.DisplacementMapEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.DisplacementMapEffect: ...
    @winrt_mixinmethod
    def get_Amount(self: win32more.Microsoft.Graphics.Canvas.Effects.IDisplacementMapEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Amount(self: win32more.Microsoft.Graphics.Canvas.Effects.IDisplacementMapEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_XChannelSelect(self: win32more.Microsoft.Graphics.Canvas.Effects.IDisplacementMapEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectChannelSelect: ...
    @winrt_mixinmethod
    def put_XChannelSelect(self: win32more.Microsoft.Graphics.Canvas.Effects.IDisplacementMapEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectChannelSelect) -> Void: ...
    @winrt_mixinmethod
    def get_YChannelSelect(self: win32more.Microsoft.Graphics.Canvas.Effects.IDisplacementMapEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectChannelSelect: ...
    @winrt_mixinmethod
    def put_YChannelSelect(self: win32more.Microsoft.Graphics.Canvas.Effects.IDisplacementMapEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectChannelSelect) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IDisplacementMapEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IDisplacementMapEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_Displacement(self: win32more.Microsoft.Graphics.Canvas.Effects.IDisplacementMapEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Displacement(self: win32more.Microsoft.Graphics.Canvas.Effects.IDisplacementMapEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    Amount = property(get_Amount, put_Amount)
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Displacement = property(get_Displacement, put_Displacement)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)
    XChannelSelect = property(get_XChannelSelect, put_XChannelSelect)
    YChannelSelect = property(get_YChannelSelect, put_YChannelSelect)
class DistantDiffuseEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IDistantDiffuseEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.DistantDiffuseEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.DistantDiffuseEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.DistantDiffuseEffect: ...
    @winrt_mixinmethod
    def get_Azimuth(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantDiffuseEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Azimuth(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantDiffuseEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Elevation(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantDiffuseEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Elevation(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantDiffuseEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_DiffuseAmount(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantDiffuseEffect) -> Single: ...
    @winrt_mixinmethod
    def put_DiffuseAmount(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantDiffuseEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_HeightMapScale(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantDiffuseEffect) -> Single: ...
    @winrt_mixinmethod
    def put_HeightMapScale(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantDiffuseEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_LightColor(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantDiffuseEffect) -> win32more.Windows.UI.Color: ...
    @winrt_mixinmethod
    def put_LightColor(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantDiffuseEffect, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def get_HeightMapKernelSize(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantDiffuseEffect) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_mixinmethod
    def put_HeightMapKernelSize(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantDiffuseEffect, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_mixinmethod
    def get_HeightMapInterpolationMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantDiffuseEffect) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_mixinmethod
    def put_HeightMapInterpolationMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantDiffuseEffect, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_mixinmethod
    def get_LightColorHdr(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantDiffuseEffect) -> win32more.Windows.Foundation.Numerics.Vector4: ...
    @winrt_mixinmethod
    def put_LightColorHdr(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantDiffuseEffect, value: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantDiffuseEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantDiffuseEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    Azimuth = property(get_Azimuth, put_Azimuth)
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    DiffuseAmount = property(get_DiffuseAmount, put_DiffuseAmount)
    Elevation = property(get_Elevation, put_Elevation)
    HeightMapInterpolationMode = property(get_HeightMapInterpolationMode, put_HeightMapInterpolationMode)
    HeightMapKernelSize = property(get_HeightMapKernelSize, put_HeightMapKernelSize)
    HeightMapScale = property(get_HeightMapScale, put_HeightMapScale)
    LightColor = property(get_LightColor, put_LightColor)
    LightColorHdr = property(get_LightColorHdr, put_LightColorHdr)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)
class DistantSpecularEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IDistantSpecularEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.DistantSpecularEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.DistantSpecularEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.DistantSpecularEffect: ...
    @winrt_mixinmethod
    def get_Azimuth(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantSpecularEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Azimuth(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantSpecularEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Elevation(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantSpecularEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Elevation(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantSpecularEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_SpecularExponent(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantSpecularEffect) -> Single: ...
    @winrt_mixinmethod
    def put_SpecularExponent(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantSpecularEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_SpecularAmount(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantSpecularEffect) -> Single: ...
    @winrt_mixinmethod
    def put_SpecularAmount(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantSpecularEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_HeightMapScale(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantSpecularEffect) -> Single: ...
    @winrt_mixinmethod
    def put_HeightMapScale(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantSpecularEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_LightColor(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantSpecularEffect) -> win32more.Windows.UI.Color: ...
    @winrt_mixinmethod
    def put_LightColor(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantSpecularEffect, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def get_HeightMapKernelSize(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantSpecularEffect) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_mixinmethod
    def put_HeightMapKernelSize(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantSpecularEffect, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_mixinmethod
    def get_HeightMapInterpolationMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantSpecularEffect) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_mixinmethod
    def put_HeightMapInterpolationMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantSpecularEffect, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_mixinmethod
    def get_LightColorHdr(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantSpecularEffect) -> win32more.Windows.Foundation.Numerics.Vector4: ...
    @winrt_mixinmethod
    def put_LightColorHdr(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantSpecularEffect, value: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantSpecularEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IDistantSpecularEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    Azimuth = property(get_Azimuth, put_Azimuth)
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Elevation = property(get_Elevation, put_Elevation)
    HeightMapInterpolationMode = property(get_HeightMapInterpolationMode, put_HeightMapInterpolationMode)
    HeightMapKernelSize = property(get_HeightMapKernelSize, put_HeightMapKernelSize)
    HeightMapScale = property(get_HeightMapScale, put_HeightMapScale)
    LightColor = property(get_LightColor, put_LightColor)
    LightColorHdr = property(get_LightColorHdr, put_LightColorHdr)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)
    SpecularAmount = property(get_SpecularAmount, put_SpecularAmount)
    SpecularExponent = property(get_SpecularExponent, put_SpecularExponent)
class DpiCompensationEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IDpiCompensationEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.DpiCompensationEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.DpiCompensationEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.DpiCompensationEffect: ...
    @winrt_mixinmethod
    def get_InterpolationMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IDpiCompensationEffect) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_mixinmethod
    def put_InterpolationMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IDpiCompensationEffect, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_mixinmethod
    def get_BorderMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IDpiCompensationEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode: ...
    @winrt_mixinmethod
    def put_BorderMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IDpiCompensationEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode) -> Void: ...
    @winrt_mixinmethod
    def get_SourceDpi(self: win32more.Microsoft.Graphics.Canvas.Effects.IDpiCompensationEffect) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_mixinmethod
    def put_SourceDpi(self: win32more.Microsoft.Graphics.Canvas.Effects.IDpiCompensationEffect, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IDpiCompensationEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IDpiCompensationEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BorderMode = property(get_BorderMode, put_BorderMode)
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    InterpolationMode = property(get_InterpolationMode, put_InterpolationMode)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)
    SourceDpi = property(get_SourceDpi, put_SourceDpi)
class EdgeDetectionEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IEdgeDetectionEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.EdgeDetectionEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.EdgeDetectionEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.EdgeDetectionEffect: ...
    @winrt_mixinmethod
    def get_Amount(self: win32more.Microsoft.Graphics.Canvas.Effects.IEdgeDetectionEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Amount(self: win32more.Microsoft.Graphics.Canvas.Effects.IEdgeDetectionEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_BlurAmount(self: win32more.Microsoft.Graphics.Canvas.Effects.IEdgeDetectionEffect) -> Single: ...
    @winrt_mixinmethod
    def put_BlurAmount(self: win32more.Microsoft.Graphics.Canvas.Effects.IEdgeDetectionEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Mode(self: win32more.Microsoft.Graphics.Canvas.Effects.IEdgeDetectionEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.EdgeDetectionEffectMode: ...
    @winrt_mixinmethod
    def put_Mode(self: win32more.Microsoft.Graphics.Canvas.Effects.IEdgeDetectionEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.EdgeDetectionEffectMode) -> Void: ...
    @winrt_mixinmethod
    def get_OverlayEdges(self: win32more.Microsoft.Graphics.Canvas.Effects.IEdgeDetectionEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_OverlayEdges(self: win32more.Microsoft.Graphics.Canvas.Effects.IEdgeDetectionEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_AlphaMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IEdgeDetectionEffect) -> win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode: ...
    @winrt_mixinmethod
    def put_AlphaMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IEdgeDetectionEffect, value: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IEdgeDetectionEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IEdgeDetectionEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    AlphaMode = property(get_AlphaMode, put_AlphaMode)
    Amount = property(get_Amount, put_Amount)
    BlurAmount = property(get_BlurAmount, put_BlurAmount)
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Mode = property(get_Mode, put_Mode)
    Name = property(get_Name, put_Name)
    OverlayEdges = property(get_OverlayEdges, put_OverlayEdges)
    Source = property(get_Source, put_Source)
class EdgeDetectionEffectMode(Enum, Int32):
    Sobel = 0
    Prewitt = 1
class EffectBorderMode(Enum, Int32):
    Soft = 0
    Hard = 1
class EffectChannelSelect(Enum, Int32):
    Red = 0
    Green = 1
    Blue = 2
    Alpha = 3
class EffectHueColorSpace(Enum, Int32):
    Hsv = 0
    Hsl = 1
class EffectOptimization(Enum, Int32):
    Speed = 0
    Balanced = 1
    Quality = 2
class EffectTransferTable3D(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IEffectTransferTable3D
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.EffectTransferTable3D'
    @winrt_mixinmethod
    def get_Device(self: win32more.Microsoft.Graphics.Canvas.Effects.IEffectTransferTable3D) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    @winrt_classmethod
    def CreateFromColors(cls: win32more.Microsoft.Graphics.Canvas.Effects.IEffectTransferTable3DStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, colors: PassArray[win32more.Windows.UI.Color], sizeB: Int32, sizeG: Int32, sizeR: Int32) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectTransferTable3D: ...
    @winrt_classmethod
    def CreateFromBytes(cls: win32more.Microsoft.Graphics.Canvas.Effects.IEffectTransferTable3DStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, bytes: PassArray[Byte], sizeB: Int32, sizeG: Int32, sizeR: Int32, format: win32more.Windows.Graphics.DirectX.DirectXPixelFormat) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectTransferTable3D: ...
    Device = property(get_Device, None)
class EmbossEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IEmbossEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.EmbossEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.EmbossEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.EmbossEffect: ...
    @winrt_mixinmethod
    def get_Amount(self: win32more.Microsoft.Graphics.Canvas.Effects.IEmbossEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Amount(self: win32more.Microsoft.Graphics.Canvas.Effects.IEmbossEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Angle(self: win32more.Microsoft.Graphics.Canvas.Effects.IEmbossEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Angle(self: win32more.Microsoft.Graphics.Canvas.Effects.IEmbossEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IEmbossEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IEmbossEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    Amount = property(get_Amount, put_Amount)
    Angle = property(get_Angle, put_Angle)
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)
class ExposureEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IExposureEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.ExposureEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.ExposureEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.ExposureEffect: ...
    @winrt_mixinmethod
    def get_Exposure(self: win32more.Microsoft.Graphics.Canvas.Effects.IExposureEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Exposure(self: win32more.Microsoft.Graphics.Canvas.Effects.IExposureEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IExposureEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IExposureEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Exposure = property(get_Exposure, put_Exposure)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)
class ExtendedColorSpace(Enum, Int32):
    FullG22P709 = 0
    FullG10P709 = 1
    StudioG22P709 = 2
    StudioG22P2020 = 3
    FullG2084P2020 = 12
    StudioG2084P2020 = 14
    FullG22P2020 = 17
    Custom = -1
class GammaTransferEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.GammaTransferEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.GammaTransferEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.GammaTransferEffect: ...
    @winrt_mixinmethod
    def get_RedAmplitude(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect) -> Single: ...
    @winrt_mixinmethod
    def put_RedAmplitude(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_RedExponent(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect) -> Single: ...
    @winrt_mixinmethod
    def put_RedExponent(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_RedOffset(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect) -> Single: ...
    @winrt_mixinmethod
    def put_RedOffset(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_RedDisable(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_RedDisable(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_GreenAmplitude(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect) -> Single: ...
    @winrt_mixinmethod
    def put_GreenAmplitude(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_GreenExponent(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect) -> Single: ...
    @winrt_mixinmethod
    def put_GreenExponent(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_GreenOffset(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect) -> Single: ...
    @winrt_mixinmethod
    def put_GreenOffset(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_GreenDisable(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_GreenDisable(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BlueAmplitude(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect) -> Single: ...
    @winrt_mixinmethod
    def put_BlueAmplitude(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_BlueExponent(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect) -> Single: ...
    @winrt_mixinmethod
    def put_BlueExponent(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_BlueOffset(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect) -> Single: ...
    @winrt_mixinmethod
    def put_BlueOffset(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_BlueDisable(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_BlueDisable(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_AlphaAmplitude(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect) -> Single: ...
    @winrt_mixinmethod
    def put_AlphaAmplitude(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_AlphaExponent(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect) -> Single: ...
    @winrt_mixinmethod
    def put_AlphaExponent(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_AlphaOffset(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect) -> Single: ...
    @winrt_mixinmethod
    def put_AlphaOffset(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_AlphaDisable(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_AlphaDisable(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_ClampOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_ClampOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    AlphaAmplitude = property(get_AlphaAmplitude, put_AlphaAmplitude)
    AlphaDisable = property(get_AlphaDisable, put_AlphaDisable)
    AlphaExponent = property(get_AlphaExponent, put_AlphaExponent)
    AlphaOffset = property(get_AlphaOffset, put_AlphaOffset)
    BlueAmplitude = property(get_BlueAmplitude, put_BlueAmplitude)
    BlueDisable = property(get_BlueDisable, put_BlueDisable)
    BlueExponent = property(get_BlueExponent, put_BlueExponent)
    BlueOffset = property(get_BlueOffset, put_BlueOffset)
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    ClampOutput = property(get_ClampOutput, put_ClampOutput)
    GreenAmplitude = property(get_GreenAmplitude, put_GreenAmplitude)
    GreenDisable = property(get_GreenDisable, put_GreenDisable)
    GreenExponent = property(get_GreenExponent, put_GreenExponent)
    GreenOffset = property(get_GreenOffset, put_GreenOffset)
    Name = property(get_Name, put_Name)
    RedAmplitude = property(get_RedAmplitude, put_RedAmplitude)
    RedDisable = property(get_RedDisable, put_RedDisable)
    RedExponent = property(get_RedExponent, put_RedExponent)
    RedOffset = property(get_RedOffset, put_RedOffset)
    Source = property(get_Source, put_Source)
class GaussianBlurEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IGaussianBlurEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.GaussianBlurEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.GaussianBlurEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.GaussianBlurEffect: ...
    @winrt_mixinmethod
    def get_BlurAmount(self: win32more.Microsoft.Graphics.Canvas.Effects.IGaussianBlurEffect) -> Single: ...
    @winrt_mixinmethod
    def put_BlurAmount(self: win32more.Microsoft.Graphics.Canvas.Effects.IGaussianBlurEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Optimization(self: win32more.Microsoft.Graphics.Canvas.Effects.IGaussianBlurEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectOptimization: ...
    @winrt_mixinmethod
    def put_Optimization(self: win32more.Microsoft.Graphics.Canvas.Effects.IGaussianBlurEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectOptimization) -> Void: ...
    @winrt_mixinmethod
    def get_BorderMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IGaussianBlurEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode: ...
    @winrt_mixinmethod
    def put_BorderMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IGaussianBlurEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IGaussianBlurEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IGaussianBlurEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BlurAmount = property(get_BlurAmount, put_BlurAmount)
    BorderMode = property(get_BorderMode, put_BorderMode)
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Name = property(get_Name, put_Name)
    Optimization = property(get_Optimization, put_Optimization)
    Source = property(get_Source, put_Source)
class GrayscaleEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IGrayscaleEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.GrayscaleEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.GrayscaleEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.GrayscaleEffect: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IGrayscaleEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IGrayscaleEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)
class HighlightsAndShadowsEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IHighlightsAndShadowsEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.HighlightsAndShadowsEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.HighlightsAndShadowsEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.HighlightsAndShadowsEffect: ...
    @winrt_mixinmethod
    def get_Highlights(self: win32more.Microsoft.Graphics.Canvas.Effects.IHighlightsAndShadowsEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Highlights(self: win32more.Microsoft.Graphics.Canvas.Effects.IHighlightsAndShadowsEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Shadows(self: win32more.Microsoft.Graphics.Canvas.Effects.IHighlightsAndShadowsEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Shadows(self: win32more.Microsoft.Graphics.Canvas.Effects.IHighlightsAndShadowsEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Clarity(self: win32more.Microsoft.Graphics.Canvas.Effects.IHighlightsAndShadowsEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Clarity(self: win32more.Microsoft.Graphics.Canvas.Effects.IHighlightsAndShadowsEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_MaskBlurAmount(self: win32more.Microsoft.Graphics.Canvas.Effects.IHighlightsAndShadowsEffect) -> Single: ...
    @winrt_mixinmethod
    def put_MaskBlurAmount(self: win32more.Microsoft.Graphics.Canvas.Effects.IHighlightsAndShadowsEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_SourceIsLinearGamma(self: win32more.Microsoft.Graphics.Canvas.Effects.IHighlightsAndShadowsEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_SourceIsLinearGamma(self: win32more.Microsoft.Graphics.Canvas.Effects.IHighlightsAndShadowsEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IHighlightsAndShadowsEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IHighlightsAndShadowsEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Clarity = property(get_Clarity, put_Clarity)
    Highlights = property(get_Highlights, put_Highlights)
    MaskBlurAmount = property(get_MaskBlurAmount, put_MaskBlurAmount)
    Name = property(get_Name, put_Name)
    Shadows = property(get_Shadows, put_Shadows)
    Source = property(get_Source, put_Source)
    SourceIsLinearGamma = property(get_SourceIsLinearGamma, put_SourceIsLinearGamma)
class HueRotationEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IHueRotationEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.HueRotationEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.HueRotationEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.HueRotationEffect: ...
    @winrt_mixinmethod
    def get_Angle(self: win32more.Microsoft.Graphics.Canvas.Effects.IHueRotationEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Angle(self: win32more.Microsoft.Graphics.Canvas.Effects.IHueRotationEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IHueRotationEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IHueRotationEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    Angle = property(get_Angle, put_Angle)
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)
class HueToRgbEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IHueToRgbEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.HueToRgbEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.HueToRgbEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.HueToRgbEffect: ...
    @winrt_mixinmethod
    def get_SourceColorSpace(self: win32more.Microsoft.Graphics.Canvas.Effects.IHueToRgbEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectHueColorSpace: ...
    @winrt_mixinmethod
    def put_SourceColorSpace(self: win32more.Microsoft.Graphics.Canvas.Effects.IHueToRgbEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectHueColorSpace) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IHueToRgbEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IHueToRgbEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)
    SourceColorSpace = property(get_SourceColorSpace, put_SourceColorSpace)
class IAlphaMaskEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IAlphaMaskEffect'
    _iid_ = Guid('{9ba6607e-75c9-5388-892f-dd3440564d98}')
    @winrt_commethod(6)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(7)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_commethod(8)
    def get_AlphaMask(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(9)
    def put_AlphaMask(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    AlphaMask = property(get_AlphaMask, put_AlphaMask)
    Source = property(get_Source, put_Source)
class IAlphaMaskEffectStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IAlphaMaskEffectStatics'
    _iid_ = Guid('{cc31105c-0377-5708-8484-1ad8ee3e554b}')
    @winrt_commethod(6)
    def get_IsSupported(self) -> Boolean: ...
    IsSupported = property(get_IsSupported, None)
class IArithmeticCompositeEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IArithmeticCompositeEffect'
    _iid_ = Guid('{beeb682b-d64c-5c8b-a1fb-332162ed099c}')
    @winrt_commethod(6)
    def get_ClampOutput(self) -> Boolean: ...
    @winrt_commethod(7)
    def put_ClampOutput(self, value: Boolean) -> Void: ...
    @winrt_commethod(8)
    def get_MultiplyAmount(self) -> Single: ...
    @winrt_commethod(9)
    def put_MultiplyAmount(self, value: Single) -> Void: ...
    @winrt_commethod(10)
    def get_Source1Amount(self) -> Single: ...
    @winrt_commethod(11)
    def put_Source1Amount(self, value: Single) -> Void: ...
    @winrt_commethod(12)
    def get_Source2Amount(self) -> Single: ...
    @winrt_commethod(13)
    def put_Source2Amount(self, value: Single) -> Void: ...
    @winrt_commethod(14)
    def get_Offset(self) -> Single: ...
    @winrt_commethod(15)
    def put_Offset(self, value: Single) -> Void: ...
    @winrt_commethod(16)
    def get_Source1(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(17)
    def put_Source1(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_commethod(18)
    def get_Source2(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(19)
    def put_Source2(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    ClampOutput = property(get_ClampOutput, put_ClampOutput)
    MultiplyAmount = property(get_MultiplyAmount, put_MultiplyAmount)
    Offset = property(get_Offset, put_Offset)
    Source1 = property(get_Source1, put_Source1)
    Source1Amount = property(get_Source1Amount, put_Source1Amount)
    Source2 = property(get_Source2, put_Source2)
    Source2Amount = property(get_Source2Amount, put_Source2Amount)
class IAtlasEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IAtlasEffect'
    _iid_ = Guid('{f7f26eba-f015-5eff-9af3-7bd2d44904bd}')
    @winrt_commethod(6)
    def get_SourceRectangle(self) -> win32more.Windows.Foundation.Rect: ...
    @winrt_commethod(7)
    def put_SourceRectangle(self, value: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_commethod(8)
    def get_PaddingRectangle(self) -> win32more.Windows.Foundation.Rect: ...
    @winrt_commethod(9)
    def put_PaddingRectangle(self, value: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_commethod(10)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(11)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    PaddingRectangle = property(get_PaddingRectangle, put_PaddingRectangle)
    Source = property(get_Source, put_Source)
    SourceRectangle = property(get_SourceRectangle, put_SourceRectangle)
class IBlendEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IBlendEffect'
    _iid_ = Guid('{5673248e-7266-5e49-b2ab-2589d5d875c3}')
    @winrt_commethod(6)
    def get_Mode(self) -> win32more.Microsoft.Graphics.Canvas.Effects.BlendEffectMode: ...
    @winrt_commethod(7)
    def put_Mode(self, value: win32more.Microsoft.Graphics.Canvas.Effects.BlendEffectMode) -> Void: ...
    @winrt_commethod(8)
    def get_Background(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(9)
    def put_Background(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_commethod(10)
    def get_Foreground(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(11)
    def put_Foreground(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    Background = property(get_Background, put_Background)
    Foreground = property(get_Foreground, put_Foreground)
    Mode = property(get_Mode, put_Mode)
class IBorderEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IBorderEffect'
    _iid_ = Guid('{31602441-15db-5b4a-98dd-ba4247548b41}')
    @winrt_commethod(6)
    def get_ExtendX(self) -> win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior: ...
    @winrt_commethod(7)
    def put_ExtendX(self, value: win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior) -> Void: ...
    @winrt_commethod(8)
    def get_ExtendY(self) -> win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior: ...
    @winrt_commethod(9)
    def put_ExtendY(self, value: win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior) -> Void: ...
    @winrt_commethod(10)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(11)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    ExtendX = property(get_ExtendX, put_ExtendX)
    ExtendY = property(get_ExtendY, put_ExtendY)
    Source = property(get_Source, put_Source)
class IBrightnessEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IBrightnessEffect'
    _iid_ = Guid('{beced347-025f-5727-8f7d-498d67df557e}')
    @winrt_commethod(6)
    def get_WhitePoint(self) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_commethod(7)
    def put_WhitePoint(self, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_commethod(8)
    def get_BlackPoint(self) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_commethod(9)
    def put_BlackPoint(self, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_commethod(10)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(11)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    BlackPoint = property(get_BlackPoint, put_BlackPoint)
    Source = property(get_Source, put_Source)
    WhitePoint = property(get_WhitePoint, put_WhitePoint)
class ICanvasEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.ICanvasEffect'
    _iid_ = Guid('{0ef96f8c-9b5e-4bf0-a399-aad8ce53db55}')
    @winrt_commethod(6)
    def get_CacheOutput(self) -> Boolean: ...
    @winrt_commethod(7)
    def put_CacheOutput(self, value: Boolean) -> Void: ...
    @winrt_commethod(8)
    def get_BufferPrecision(self) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_commethod(9)
    def put_BufferPrecision(self, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_commethod(10)
    def InvalidateSourceRectangle(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_commethod(11)
    def GetInvalidRectangles(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_commethod(12)
    def GetRequiredSourceRectangle(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_commethod(13)
    def GetRequiredSourceRectangles(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
class IChromaKeyEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IChromaKeyEffect'
    _iid_ = Guid('{f14b9464-1871-5eaa-9db6-c0901140e9d3}')
    @winrt_commethod(6)
    def get_Color(self) -> win32more.Windows.UI.Color: ...
    @winrt_commethod(7)
    def put_Color(self, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(8)
    def get_Tolerance(self) -> Single: ...
    @winrt_commethod(9)
    def put_Tolerance(self, value: Single) -> Void: ...
    @winrt_commethod(10)
    def get_InvertAlpha(self) -> Boolean: ...
    @winrt_commethod(11)
    def put_InvertAlpha(self, value: Boolean) -> Void: ...
    @winrt_commethod(12)
    def get_Feather(self) -> Boolean: ...
    @winrt_commethod(13)
    def put_Feather(self, value: Boolean) -> Void: ...
    @winrt_commethod(14)
    def get_ColorHdr(self) -> win32more.Windows.Foundation.Numerics.Vector4: ...
    @winrt_commethod(15)
    def put_ColorHdr(self, value: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_commethod(16)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(17)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    Color = property(get_Color, put_Color)
    ColorHdr = property(get_ColorHdr, put_ColorHdr)
    Feather = property(get_Feather, put_Feather)
    InvertAlpha = property(get_InvertAlpha, put_InvertAlpha)
    Source = property(get_Source, put_Source)
    Tolerance = property(get_Tolerance, put_Tolerance)
class IColorManagementEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IColorManagementEffect'
    _iid_ = Guid('{6e8bbe37-e1e4-5ad0-b98d-940e3213a54e}')
    @winrt_commethod(6)
    def get_SourceColorProfile(self) -> win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementProfile: ...
    @winrt_commethod(7)
    def put_SourceColorProfile(self, value: win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementProfile) -> Void: ...
    @winrt_commethod(8)
    def get_SourceRenderingIntent(self) -> win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementRenderingIntent: ...
    @winrt_commethod(9)
    def put_SourceRenderingIntent(self, value: win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementRenderingIntent) -> Void: ...
    @winrt_commethod(10)
    def get_OutputColorProfile(self) -> win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementProfile: ...
    @winrt_commethod(11)
    def put_OutputColorProfile(self, value: win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementProfile) -> Void: ...
    @winrt_commethod(12)
    def get_OutputRenderingIntent(self) -> win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementRenderingIntent: ...
    @winrt_commethod(13)
    def put_OutputRenderingIntent(self, value: win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementRenderingIntent) -> Void: ...
    @winrt_commethod(14)
    def get_AlphaMode(self) -> win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode: ...
    @winrt_commethod(15)
    def put_AlphaMode(self, value: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> Void: ...
    @winrt_commethod(16)
    def get_Quality(self) -> win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementEffectQuality: ...
    @winrt_commethod(17)
    def put_Quality(self, value: win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementEffectQuality) -> Void: ...
    @winrt_commethod(18)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(19)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    AlphaMode = property(get_AlphaMode, put_AlphaMode)
    OutputColorProfile = property(get_OutputColorProfile, put_OutputColorProfile)
    OutputRenderingIntent = property(get_OutputRenderingIntent, put_OutputRenderingIntent)
    Quality = property(get_Quality, put_Quality)
    Source = property(get_Source, put_Source)
    SourceColorProfile = property(get_SourceColorProfile, put_SourceColorProfile)
    SourceRenderingIntent = property(get_SourceRenderingIntent, put_SourceRenderingIntent)
class IColorManagementEffectStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IColorManagementEffectStatics'
    _iid_ = Guid('{31c7af98-f2d4-55fc-b129-a70736e6da05}')
    @winrt_commethod(6)
    def IsBestQualitySupported(self, device: win32more.Microsoft.Graphics.Canvas.CanvasDevice) -> Boolean: ...
class IColorManagementProfile(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IColorManagementProfile'
    _iid_ = Guid('{5123a56b-b199-47ab-aebe-d308044423fe}')
    @winrt_commethod(6)
    def get_ColorSpace(self) -> win32more.Microsoft.Graphics.Canvas.CanvasColorSpace: ...
    @winrt_commethod(7)
    def get_IccProfile(self) -> ReceiveArray[Byte]: ...
    @winrt_commethod(8)
    def get_Type(self) -> win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementProfileType: ...
    @winrt_commethod(9)
    def get_SimpleProfile(self) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementSimpleProfile]: ...
    @winrt_commethod(10)
    def get_ExtendedColorSpace(self) -> win32more.Microsoft.Graphics.Canvas.Effects.ExtendedColorSpace: ...
    ColorSpace = property(get_ColorSpace, None)
    ExtendedColorSpace = property(get_ExtendedColorSpace, None)
    IccProfile = property(get_IccProfile, None)
    SimpleProfile = property(get_SimpleProfile, None)
    Type = property(get_Type, None)
class IColorManagementProfileFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IColorManagementProfileFactory'
    _iid_ = Guid('{7a0f1c98-94c6-4621-9877-c51a17823edf}')
    @winrt_commethod(6)
    def Create(self, colorSpace: win32more.Microsoft.Graphics.Canvas.CanvasColorSpace) -> win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementProfile: ...
class IColorManagementProfileStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IColorManagementProfileStatics'
    _iid_ = Guid('{94eef610-03bd-4e82-9479-62a616be75f1}')
    @winrt_commethod(6)
    def CreateCustom(self, iccProfile: PassArray[Byte]) -> win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementProfile: ...
    @winrt_commethod(7)
    def CreateSimple(self, simpleProfile: win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementSimpleProfile) -> win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementProfile: ...
    @winrt_commethod(8)
    def CreateExtended(self, colorSpace: win32more.Microsoft.Graphics.Canvas.Effects.ExtendedColorSpace) -> win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementProfile: ...
    @winrt_commethod(9)
    def IsSupported(self, type: win32more.Microsoft.Graphics.Canvas.Effects.ColorManagementProfileType, device: win32more.Microsoft.Graphics.Canvas.CanvasDevice) -> Boolean: ...
class IColorMatrixEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IColorMatrixEffect'
    _iid_ = Guid('{e6ae54c4-883d-588e-b451-e9ebe3830437}')
    @winrt_commethod(6)
    def get_ColorMatrix(self) -> win32more.Microsoft.Graphics.Canvas.Effects.Matrix5x4: ...
    @winrt_commethod(7)
    def put_ColorMatrix(self, value: win32more.Microsoft.Graphics.Canvas.Effects.Matrix5x4) -> Void: ...
    @winrt_commethod(8)
    def get_AlphaMode(self) -> win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode: ...
    @winrt_commethod(9)
    def put_AlphaMode(self, value: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> Void: ...
    @winrt_commethod(10)
    def get_ClampOutput(self) -> Boolean: ...
    @winrt_commethod(11)
    def put_ClampOutput(self, value: Boolean) -> Void: ...
    @winrt_commethod(12)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(13)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    AlphaMode = property(get_AlphaMode, put_AlphaMode)
    ClampOutput = property(get_ClampOutput, put_ClampOutput)
    ColorMatrix = property(get_ColorMatrix, put_ColorMatrix)
    Source = property(get_Source, put_Source)
class IColorSourceEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IColorSourceEffect'
    _iid_ = Guid('{25f942c7-7fee-518a-ba7b-22a0060af7f6}')
    @winrt_commethod(6)
    def get_Color(self) -> win32more.Windows.UI.Color: ...
    @winrt_commethod(7)
    def put_Color(self, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(8)
    def get_ColorHdr(self) -> win32more.Windows.Foundation.Numerics.Vector4: ...
    @winrt_commethod(9)
    def put_ColorHdr(self, value: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    Color = property(get_Color, put_Color)
    ColorHdr = property(get_ColorHdr, put_ColorHdr)
class ICompositeEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.ICompositeEffect'
    _iid_ = Guid('{f8808c48-cdc7-5db4-807c-b9344ff71984}')
    @winrt_commethod(6)
    def get_Mode(self) -> win32more.Microsoft.Graphics.Canvas.CanvasComposite: ...
    @winrt_commethod(7)
    def put_Mode(self, value: win32more.Microsoft.Graphics.Canvas.CanvasComposite) -> Void: ...
    @winrt_commethod(8)
    def get_Sources(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.Graphics.Effects.IGraphicsEffectSource]: ...
    Mode = property(get_Mode, put_Mode)
    Sources = property(get_Sources, None)
class IContrastEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IContrastEffect'
    _iid_ = Guid('{da8a2b9f-594e-560a-9eaa-1f912408fe79}')
    @winrt_commethod(6)
    def get_Contrast(self) -> Single: ...
    @winrt_commethod(7)
    def put_Contrast(self, value: Single) -> Void: ...
    @winrt_commethod(8)
    def get_ClampSource(self) -> Boolean: ...
    @winrt_commethod(9)
    def put_ClampSource(self, value: Boolean) -> Void: ...
    @winrt_commethod(10)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(11)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    ClampSource = property(get_ClampSource, put_ClampSource)
    Contrast = property(get_Contrast, put_Contrast)
    Source = property(get_Source, put_Source)
class IConvolveMatrixEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IConvolveMatrixEffect'
    _iid_ = Guid('{82961257-a78d-5440-8026-af57d4a76a9e}')
    @winrt_commethod(6)
    def get_KernelScale(self) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_commethod(7)
    def put_KernelScale(self, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_commethod(8)
    def get_InterpolationMode(self) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_commethod(9)
    def put_InterpolationMode(self, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_commethod(10)
    def get_KernelWidth(self) -> Int32: ...
    @winrt_commethod(11)
    def put_KernelWidth(self, value: Int32) -> Void: ...
    @winrt_commethod(12)
    def get_KernelHeight(self) -> Int32: ...
    @winrt_commethod(13)
    def put_KernelHeight(self, value: Int32) -> Void: ...
    @winrt_commethod(14)
    def get_KernelMatrix(self) -> ReceiveArray[Single]: ...
    @winrt_commethod(15)
    def put_KernelMatrix(self, valueElements: PassArray[Single]) -> Void: ...
    @winrt_commethod(16)
    def get_Divisor(self) -> Single: ...
    @winrt_commethod(17)
    def put_Divisor(self, value: Single) -> Void: ...
    @winrt_commethod(18)
    def get_Offset(self) -> Single: ...
    @winrt_commethod(19)
    def put_Offset(self, value: Single) -> Void: ...
    @winrt_commethod(20)
    def get_KernelOffset(self) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_commethod(21)
    def put_KernelOffset(self, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_commethod(22)
    def get_PreserveAlpha(self) -> Boolean: ...
    @winrt_commethod(23)
    def put_PreserveAlpha(self, value: Boolean) -> Void: ...
    @winrt_commethod(24)
    def get_BorderMode(self) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode: ...
    @winrt_commethod(25)
    def put_BorderMode(self, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode) -> Void: ...
    @winrt_commethod(26)
    def get_ClampOutput(self) -> Boolean: ...
    @winrt_commethod(27)
    def put_ClampOutput(self, value: Boolean) -> Void: ...
    @winrt_commethod(28)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(29)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    BorderMode = property(get_BorderMode, put_BorderMode)
    ClampOutput = property(get_ClampOutput, put_ClampOutput)
    Divisor = property(get_Divisor, put_Divisor)
    InterpolationMode = property(get_InterpolationMode, put_InterpolationMode)
    KernelHeight = property(get_KernelHeight, put_KernelHeight)
    KernelMatrix = property(get_KernelMatrix, put_KernelMatrix)
    KernelOffset = property(get_KernelOffset, put_KernelOffset)
    KernelScale = property(get_KernelScale, put_KernelScale)
    KernelWidth = property(get_KernelWidth, put_KernelWidth)
    Offset = property(get_Offset, put_Offset)
    PreserveAlpha = property(get_PreserveAlpha, put_PreserveAlpha)
    Source = property(get_Source, put_Source)
class ICropEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.ICropEffect'
    _iid_ = Guid('{d8a1c2a5-e031-566d-8f7c-ba07cfb58aae}')
    @winrt_commethod(6)
    def get_SourceRectangle(self) -> win32more.Windows.Foundation.Rect: ...
    @winrt_commethod(7)
    def put_SourceRectangle(self, value: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_commethod(8)
    def get_BorderMode(self) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode: ...
    @winrt_commethod(9)
    def put_BorderMode(self, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode) -> Void: ...
    @winrt_commethod(10)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(11)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    BorderMode = property(get_BorderMode, put_BorderMode)
    Source = property(get_Source, put_Source)
    SourceRectangle = property(get_SourceRectangle, put_SourceRectangle)
class ICrossFadeEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.ICrossFadeEffect'
    _iid_ = Guid('{be161a9f-43d2-5613-8600-d51e3d7ce288}')
    @winrt_commethod(6)
    def get_CrossFade(self) -> Single: ...
    @winrt_commethod(7)
    def put_CrossFade(self, value: Single) -> Void: ...
    @winrt_commethod(8)
    def get_Source2(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(9)
    def put_Source2(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_commethod(10)
    def get_Source1(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(11)
    def put_Source1(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    CrossFade = property(get_CrossFade, put_CrossFade)
    Source1 = property(get_Source1, put_Source1)
    Source2 = property(get_Source2, put_Source2)
class ICrossFadeEffectStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.ICrossFadeEffectStatics'
    _iid_ = Guid('{a3b67330-6284-5ef6-99e8-b4b05d2b8bfc}')
    @winrt_commethod(6)
    def get_IsSupported(self) -> Boolean: ...
    IsSupported = property(get_IsSupported, None)
class IDirectionalBlurEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IDirectionalBlurEffect'
    _iid_ = Guid('{5d155c4b-0882-506a-a8e1-12e1ead17f0a}')
    @winrt_commethod(6)
    def get_BlurAmount(self) -> Single: ...
    @winrt_commethod(7)
    def put_BlurAmount(self, value: Single) -> Void: ...
    @winrt_commethod(8)
    def get_Angle(self) -> Single: ...
    @winrt_commethod(9)
    def put_Angle(self, value: Single) -> Void: ...
    @winrt_commethod(10)
    def get_Optimization(self) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectOptimization: ...
    @winrt_commethod(11)
    def put_Optimization(self, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectOptimization) -> Void: ...
    @winrt_commethod(12)
    def get_BorderMode(self) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode: ...
    @winrt_commethod(13)
    def put_BorderMode(self, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode) -> Void: ...
    @winrt_commethod(14)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(15)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    Angle = property(get_Angle, put_Angle)
    BlurAmount = property(get_BlurAmount, put_BlurAmount)
    BorderMode = property(get_BorderMode, put_BorderMode)
    Optimization = property(get_Optimization, put_Optimization)
    Source = property(get_Source, put_Source)
class IDiscreteTransferEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IDiscreteTransferEffect'
    _iid_ = Guid('{7f1f54f9-21b5-5b91-9506-832c536fddfa}')
    @winrt_commethod(6)
    def get_RedTable(self) -> ReceiveArray[Single]: ...
    @winrt_commethod(7)
    def put_RedTable(self, valueElements: PassArray[Single]) -> Void: ...
    @winrt_commethod(8)
    def get_RedDisable(self) -> Boolean: ...
    @winrt_commethod(9)
    def put_RedDisable(self, value: Boolean) -> Void: ...
    @winrt_commethod(10)
    def get_GreenTable(self) -> ReceiveArray[Single]: ...
    @winrt_commethod(11)
    def put_GreenTable(self, valueElements: PassArray[Single]) -> Void: ...
    @winrt_commethod(12)
    def get_GreenDisable(self) -> Boolean: ...
    @winrt_commethod(13)
    def put_GreenDisable(self, value: Boolean) -> Void: ...
    @winrt_commethod(14)
    def get_BlueTable(self) -> ReceiveArray[Single]: ...
    @winrt_commethod(15)
    def put_BlueTable(self, valueElements: PassArray[Single]) -> Void: ...
    @winrt_commethod(16)
    def get_BlueDisable(self) -> Boolean: ...
    @winrt_commethod(17)
    def put_BlueDisable(self, value: Boolean) -> Void: ...
    @winrt_commethod(18)
    def get_AlphaTable(self) -> ReceiveArray[Single]: ...
    @winrt_commethod(19)
    def put_AlphaTable(self, valueElements: PassArray[Single]) -> Void: ...
    @winrt_commethod(20)
    def get_AlphaDisable(self) -> Boolean: ...
    @winrt_commethod(21)
    def put_AlphaDisable(self, value: Boolean) -> Void: ...
    @winrt_commethod(22)
    def get_ClampOutput(self) -> Boolean: ...
    @winrt_commethod(23)
    def put_ClampOutput(self, value: Boolean) -> Void: ...
    @winrt_commethod(24)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(25)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    AlphaDisable = property(get_AlphaDisable, put_AlphaDisable)
    AlphaTable = property(get_AlphaTable, put_AlphaTable)
    BlueDisable = property(get_BlueDisable, put_BlueDisable)
    BlueTable = property(get_BlueTable, put_BlueTable)
    ClampOutput = property(get_ClampOutput, put_ClampOutput)
    GreenDisable = property(get_GreenDisable, put_GreenDisable)
    GreenTable = property(get_GreenTable, put_GreenTable)
    RedDisable = property(get_RedDisable, put_RedDisable)
    RedTable = property(get_RedTable, put_RedTable)
    Source = property(get_Source, put_Source)
class IDisplacementMapEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IDisplacementMapEffect'
    _iid_ = Guid('{45f57c50-d4d9-5af1-8a6b-50378f3498a2}')
    @winrt_commethod(6)
    def get_Amount(self) -> Single: ...
    @winrt_commethod(7)
    def put_Amount(self, value: Single) -> Void: ...
    @winrt_commethod(8)
    def get_XChannelSelect(self) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectChannelSelect: ...
    @winrt_commethod(9)
    def put_XChannelSelect(self, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectChannelSelect) -> Void: ...
    @winrt_commethod(10)
    def get_YChannelSelect(self) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectChannelSelect: ...
    @winrt_commethod(11)
    def put_YChannelSelect(self, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectChannelSelect) -> Void: ...
    @winrt_commethod(12)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(13)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_commethod(14)
    def get_Displacement(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(15)
    def put_Displacement(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    Amount = property(get_Amount, put_Amount)
    Displacement = property(get_Displacement, put_Displacement)
    Source = property(get_Source, put_Source)
    XChannelSelect = property(get_XChannelSelect, put_XChannelSelect)
    YChannelSelect = property(get_YChannelSelect, put_YChannelSelect)
class IDistantDiffuseEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IDistantDiffuseEffect'
    _iid_ = Guid('{d501b10b-b445-50f4-8b8f-cdecfcdd1321}')
    @winrt_commethod(6)
    def get_Azimuth(self) -> Single: ...
    @winrt_commethod(7)
    def put_Azimuth(self, value: Single) -> Void: ...
    @winrt_commethod(8)
    def get_Elevation(self) -> Single: ...
    @winrt_commethod(9)
    def put_Elevation(self, value: Single) -> Void: ...
    @winrt_commethod(10)
    def get_DiffuseAmount(self) -> Single: ...
    @winrt_commethod(11)
    def put_DiffuseAmount(self, value: Single) -> Void: ...
    @winrt_commethod(12)
    def get_HeightMapScale(self) -> Single: ...
    @winrt_commethod(13)
    def put_HeightMapScale(self, value: Single) -> Void: ...
    @winrt_commethod(14)
    def get_LightColor(self) -> win32more.Windows.UI.Color: ...
    @winrt_commethod(15)
    def put_LightColor(self, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(16)
    def get_HeightMapKernelSize(self) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_commethod(17)
    def put_HeightMapKernelSize(self, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_commethod(18)
    def get_HeightMapInterpolationMode(self) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_commethod(19)
    def put_HeightMapInterpolationMode(self, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_commethod(20)
    def get_LightColorHdr(self) -> win32more.Windows.Foundation.Numerics.Vector4: ...
    @winrt_commethod(21)
    def put_LightColorHdr(self, value: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_commethod(22)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(23)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    Azimuth = property(get_Azimuth, put_Azimuth)
    DiffuseAmount = property(get_DiffuseAmount, put_DiffuseAmount)
    Elevation = property(get_Elevation, put_Elevation)
    HeightMapInterpolationMode = property(get_HeightMapInterpolationMode, put_HeightMapInterpolationMode)
    HeightMapKernelSize = property(get_HeightMapKernelSize, put_HeightMapKernelSize)
    HeightMapScale = property(get_HeightMapScale, put_HeightMapScale)
    LightColor = property(get_LightColor, put_LightColor)
    LightColorHdr = property(get_LightColorHdr, put_LightColorHdr)
    Source = property(get_Source, put_Source)
class IDistantSpecularEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IDistantSpecularEffect'
    _iid_ = Guid('{a7a828df-3072-545f-8d75-86c100f03231}')
    @winrt_commethod(6)
    def get_Azimuth(self) -> Single: ...
    @winrt_commethod(7)
    def put_Azimuth(self, value: Single) -> Void: ...
    @winrt_commethod(8)
    def get_Elevation(self) -> Single: ...
    @winrt_commethod(9)
    def put_Elevation(self, value: Single) -> Void: ...
    @winrt_commethod(10)
    def get_SpecularExponent(self) -> Single: ...
    @winrt_commethod(11)
    def put_SpecularExponent(self, value: Single) -> Void: ...
    @winrt_commethod(12)
    def get_SpecularAmount(self) -> Single: ...
    @winrt_commethod(13)
    def put_SpecularAmount(self, value: Single) -> Void: ...
    @winrt_commethod(14)
    def get_HeightMapScale(self) -> Single: ...
    @winrt_commethod(15)
    def put_HeightMapScale(self, value: Single) -> Void: ...
    @winrt_commethod(16)
    def get_LightColor(self) -> win32more.Windows.UI.Color: ...
    @winrt_commethod(17)
    def put_LightColor(self, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(18)
    def get_HeightMapKernelSize(self) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_commethod(19)
    def put_HeightMapKernelSize(self, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_commethod(20)
    def get_HeightMapInterpolationMode(self) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_commethod(21)
    def put_HeightMapInterpolationMode(self, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_commethod(22)
    def get_LightColorHdr(self) -> win32more.Windows.Foundation.Numerics.Vector4: ...
    @winrt_commethod(23)
    def put_LightColorHdr(self, value: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_commethod(24)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(25)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    Azimuth = property(get_Azimuth, put_Azimuth)
    Elevation = property(get_Elevation, put_Elevation)
    HeightMapInterpolationMode = property(get_HeightMapInterpolationMode, put_HeightMapInterpolationMode)
    HeightMapKernelSize = property(get_HeightMapKernelSize, put_HeightMapKernelSize)
    HeightMapScale = property(get_HeightMapScale, put_HeightMapScale)
    LightColor = property(get_LightColor, put_LightColor)
    LightColorHdr = property(get_LightColorHdr, put_LightColorHdr)
    Source = property(get_Source, put_Source)
    SpecularAmount = property(get_SpecularAmount, put_SpecularAmount)
    SpecularExponent = property(get_SpecularExponent, put_SpecularExponent)
class IDpiCompensationEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IDpiCompensationEffect'
    _iid_ = Guid('{636597cd-f94a-55b6-9cf0-694a53d638ea}')
    @winrt_commethod(6)
    def get_InterpolationMode(self) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_commethod(7)
    def put_InterpolationMode(self, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_commethod(8)
    def get_BorderMode(self) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode: ...
    @winrt_commethod(9)
    def put_BorderMode(self, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode) -> Void: ...
    @winrt_commethod(10)
    def get_SourceDpi(self) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_commethod(11)
    def put_SourceDpi(self, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_commethod(12)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(13)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    BorderMode = property(get_BorderMode, put_BorderMode)
    InterpolationMode = property(get_InterpolationMode, put_InterpolationMode)
    Source = property(get_Source, put_Source)
    SourceDpi = property(get_SourceDpi, put_SourceDpi)
class IEdgeDetectionEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IEdgeDetectionEffect'
    _iid_ = Guid('{69f6cf3a-f38f-5a88-974a-29390b957e5c}')
    @winrt_commethod(6)
    def get_Amount(self) -> Single: ...
    @winrt_commethod(7)
    def put_Amount(self, value: Single) -> Void: ...
    @winrt_commethod(8)
    def get_BlurAmount(self) -> Single: ...
    @winrt_commethod(9)
    def put_BlurAmount(self, value: Single) -> Void: ...
    @winrt_commethod(10)
    def get_Mode(self) -> win32more.Microsoft.Graphics.Canvas.Effects.EdgeDetectionEffectMode: ...
    @winrt_commethod(11)
    def put_Mode(self, value: win32more.Microsoft.Graphics.Canvas.Effects.EdgeDetectionEffectMode) -> Void: ...
    @winrt_commethod(12)
    def get_OverlayEdges(self) -> Boolean: ...
    @winrt_commethod(13)
    def put_OverlayEdges(self, value: Boolean) -> Void: ...
    @winrt_commethod(14)
    def get_AlphaMode(self) -> win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode: ...
    @winrt_commethod(15)
    def put_AlphaMode(self, value: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> Void: ...
    @winrt_commethod(16)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(17)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    AlphaMode = property(get_AlphaMode, put_AlphaMode)
    Amount = property(get_Amount, put_Amount)
    BlurAmount = property(get_BlurAmount, put_BlurAmount)
    Mode = property(get_Mode, put_Mode)
    OverlayEdges = property(get_OverlayEdges, put_OverlayEdges)
    Source = property(get_Source, put_Source)
class IEffectTransferTable3D(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IEffectTransferTable3D'
    _iid_ = Guid('{7af06b86-2c45-49c8-8f44-e15a6d4fa44e}')
    @winrt_commethod(6)
    def get_Device(self) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    Device = property(get_Device, None)
class IEffectTransferTable3DStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IEffectTransferTable3DStatics'
    _iid_ = Guid('{3cb83559-216a-4bca-9bb6-e233c5ad2c48}')
    @winrt_commethod(6)
    def CreateFromColors(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, colors: PassArray[win32more.Windows.UI.Color], sizeB: Int32, sizeG: Int32, sizeR: Int32) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectTransferTable3D: ...
    @winrt_commethod(7)
    def CreateFromBytes(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, bytes: PassArray[Byte], sizeB: Int32, sizeG: Int32, sizeR: Int32, format: win32more.Windows.Graphics.DirectX.DirectXPixelFormat) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectTransferTable3D: ...
class IEmbossEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IEmbossEffect'
    _iid_ = Guid('{617bff35-481c-5596-aba5-00a162349d7b}')
    @winrt_commethod(6)
    def get_Amount(self) -> Single: ...
    @winrt_commethod(7)
    def put_Amount(self, value: Single) -> Void: ...
    @winrt_commethod(8)
    def get_Angle(self) -> Single: ...
    @winrt_commethod(9)
    def put_Angle(self, value: Single) -> Void: ...
    @winrt_commethod(10)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(11)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    Amount = property(get_Amount, put_Amount)
    Angle = property(get_Angle, put_Angle)
    Source = property(get_Source, put_Source)
class IExposureEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IExposureEffect'
    _iid_ = Guid('{b9e20a03-2232-5fd3-b408-15784b79dbb0}')
    @winrt_commethod(6)
    def get_Exposure(self) -> Single: ...
    @winrt_commethod(7)
    def put_Exposure(self, value: Single) -> Void: ...
    @winrt_commethod(8)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(9)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    Exposure = property(get_Exposure, put_Exposure)
    Source = property(get_Source, put_Source)
class IGammaTransferEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IGammaTransferEffect'
    _iid_ = Guid('{b4576b6b-6c3e-534a-8576-d46df4fce93d}')
    @winrt_commethod(6)
    def get_RedAmplitude(self) -> Single: ...
    @winrt_commethod(7)
    def put_RedAmplitude(self, value: Single) -> Void: ...
    @winrt_commethod(8)
    def get_RedExponent(self) -> Single: ...
    @winrt_commethod(9)
    def put_RedExponent(self, value: Single) -> Void: ...
    @winrt_commethod(10)
    def get_RedOffset(self) -> Single: ...
    @winrt_commethod(11)
    def put_RedOffset(self, value: Single) -> Void: ...
    @winrt_commethod(12)
    def get_RedDisable(self) -> Boolean: ...
    @winrt_commethod(13)
    def put_RedDisable(self, value: Boolean) -> Void: ...
    @winrt_commethod(14)
    def get_GreenAmplitude(self) -> Single: ...
    @winrt_commethod(15)
    def put_GreenAmplitude(self, value: Single) -> Void: ...
    @winrt_commethod(16)
    def get_GreenExponent(self) -> Single: ...
    @winrt_commethod(17)
    def put_GreenExponent(self, value: Single) -> Void: ...
    @winrt_commethod(18)
    def get_GreenOffset(self) -> Single: ...
    @winrt_commethod(19)
    def put_GreenOffset(self, value: Single) -> Void: ...
    @winrt_commethod(20)
    def get_GreenDisable(self) -> Boolean: ...
    @winrt_commethod(21)
    def put_GreenDisable(self, value: Boolean) -> Void: ...
    @winrt_commethod(22)
    def get_BlueAmplitude(self) -> Single: ...
    @winrt_commethod(23)
    def put_BlueAmplitude(self, value: Single) -> Void: ...
    @winrt_commethod(24)
    def get_BlueExponent(self) -> Single: ...
    @winrt_commethod(25)
    def put_BlueExponent(self, value: Single) -> Void: ...
    @winrt_commethod(26)
    def get_BlueOffset(self) -> Single: ...
    @winrt_commethod(27)
    def put_BlueOffset(self, value: Single) -> Void: ...
    @winrt_commethod(28)
    def get_BlueDisable(self) -> Boolean: ...
    @winrt_commethod(29)
    def put_BlueDisable(self, value: Boolean) -> Void: ...
    @winrt_commethod(30)
    def get_AlphaAmplitude(self) -> Single: ...
    @winrt_commethod(31)
    def put_AlphaAmplitude(self, value: Single) -> Void: ...
    @winrt_commethod(32)
    def get_AlphaExponent(self) -> Single: ...
    @winrt_commethod(33)
    def put_AlphaExponent(self, value: Single) -> Void: ...
    @winrt_commethod(34)
    def get_AlphaOffset(self) -> Single: ...
    @winrt_commethod(35)
    def put_AlphaOffset(self, value: Single) -> Void: ...
    @winrt_commethod(36)
    def get_AlphaDisable(self) -> Boolean: ...
    @winrt_commethod(37)
    def put_AlphaDisable(self, value: Boolean) -> Void: ...
    @winrt_commethod(38)
    def get_ClampOutput(self) -> Boolean: ...
    @winrt_commethod(39)
    def put_ClampOutput(self, value: Boolean) -> Void: ...
    @winrt_commethod(40)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(41)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    AlphaAmplitude = property(get_AlphaAmplitude, put_AlphaAmplitude)
    AlphaDisable = property(get_AlphaDisable, put_AlphaDisable)
    AlphaExponent = property(get_AlphaExponent, put_AlphaExponent)
    AlphaOffset = property(get_AlphaOffset, put_AlphaOffset)
    BlueAmplitude = property(get_BlueAmplitude, put_BlueAmplitude)
    BlueDisable = property(get_BlueDisable, put_BlueDisable)
    BlueExponent = property(get_BlueExponent, put_BlueExponent)
    BlueOffset = property(get_BlueOffset, put_BlueOffset)
    ClampOutput = property(get_ClampOutput, put_ClampOutput)
    GreenAmplitude = property(get_GreenAmplitude, put_GreenAmplitude)
    GreenDisable = property(get_GreenDisable, put_GreenDisable)
    GreenExponent = property(get_GreenExponent, put_GreenExponent)
    GreenOffset = property(get_GreenOffset, put_GreenOffset)
    RedAmplitude = property(get_RedAmplitude, put_RedAmplitude)
    RedDisable = property(get_RedDisable, put_RedDisable)
    RedExponent = property(get_RedExponent, put_RedExponent)
    RedOffset = property(get_RedOffset, put_RedOffset)
    Source = property(get_Source, put_Source)
class IGaussianBlurEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IGaussianBlurEffect'
    _iid_ = Guid('{a82ec394-6734-5830-9123-2c82b27dd3c0}')
    @winrt_commethod(6)
    def get_BlurAmount(self) -> Single: ...
    @winrt_commethod(7)
    def put_BlurAmount(self, value: Single) -> Void: ...
    @winrt_commethod(8)
    def get_Optimization(self) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectOptimization: ...
    @winrt_commethod(9)
    def put_Optimization(self, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectOptimization) -> Void: ...
    @winrt_commethod(10)
    def get_BorderMode(self) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode: ...
    @winrt_commethod(11)
    def put_BorderMode(self, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode) -> Void: ...
    @winrt_commethod(12)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(13)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    BlurAmount = property(get_BlurAmount, put_BlurAmount)
    BorderMode = property(get_BorderMode, put_BorderMode)
    Optimization = property(get_Optimization, put_Optimization)
    Source = property(get_Source, put_Source)
class IGrayscaleEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IGrayscaleEffect'
    _iid_ = Guid('{78e13b83-0638-53f8-b0b3-5b0b320a9ad2}')
    @winrt_commethod(6)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(7)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    Source = property(get_Source, put_Source)
class IHighlightsAndShadowsEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IHighlightsAndShadowsEffect'
    _iid_ = Guid('{7f90be14-267e-5088-bc36-2e0aad869b52}')
    @winrt_commethod(6)
    def get_Highlights(self) -> Single: ...
    @winrt_commethod(7)
    def put_Highlights(self, value: Single) -> Void: ...
    @winrt_commethod(8)
    def get_Shadows(self) -> Single: ...
    @winrt_commethod(9)
    def put_Shadows(self, value: Single) -> Void: ...
    @winrt_commethod(10)
    def get_Clarity(self) -> Single: ...
    @winrt_commethod(11)
    def put_Clarity(self, value: Single) -> Void: ...
    @winrt_commethod(12)
    def get_MaskBlurAmount(self) -> Single: ...
    @winrt_commethod(13)
    def put_MaskBlurAmount(self, value: Single) -> Void: ...
    @winrt_commethod(14)
    def get_SourceIsLinearGamma(self) -> Boolean: ...
    @winrt_commethod(15)
    def put_SourceIsLinearGamma(self, value: Boolean) -> Void: ...
    @winrt_commethod(16)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(17)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    Clarity = property(get_Clarity, put_Clarity)
    Highlights = property(get_Highlights, put_Highlights)
    MaskBlurAmount = property(get_MaskBlurAmount, put_MaskBlurAmount)
    Shadows = property(get_Shadows, put_Shadows)
    Source = property(get_Source, put_Source)
    SourceIsLinearGamma = property(get_SourceIsLinearGamma, put_SourceIsLinearGamma)
class IHueRotationEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IHueRotationEffect'
    _iid_ = Guid('{c172ebf2-e35f-58ae-ad2c-561eceaf2694}')
    @winrt_commethod(6)
    def get_Angle(self) -> Single: ...
    @winrt_commethod(7)
    def put_Angle(self, value: Single) -> Void: ...
    @winrt_commethod(8)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(9)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    Angle = property(get_Angle, put_Angle)
    Source = property(get_Source, put_Source)
class IHueToRgbEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IHueToRgbEffect'
    _iid_ = Guid('{1e97c12c-b743-53d0-88c4-8435272b0a3d}')
    @winrt_commethod(6)
    def get_SourceColorSpace(self) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectHueColorSpace: ...
    @winrt_commethod(7)
    def put_SourceColorSpace(self, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectHueColorSpace) -> Void: ...
    @winrt_commethod(8)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(9)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    Source = property(get_Source, put_Source)
    SourceColorSpace = property(get_SourceColorSpace, put_SourceColorSpace)
class IInvertEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IInvertEffect'
    _iid_ = Guid('{d4adcdfc-0f60-524d-936a-7f2736ad33d8}')
    @winrt_commethod(6)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(7)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    Source = property(get_Source, put_Source)
class ILinearTransferEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.ILinearTransferEffect'
    _iid_ = Guid('{43d27ad0-8937-5fdb-876a-4e91cb47540c}')
    @winrt_commethod(6)
    def get_RedOffset(self) -> Single: ...
    @winrt_commethod(7)
    def put_RedOffset(self, value: Single) -> Void: ...
    @winrt_commethod(8)
    def get_RedSlope(self) -> Single: ...
    @winrt_commethod(9)
    def put_RedSlope(self, value: Single) -> Void: ...
    @winrt_commethod(10)
    def get_RedDisable(self) -> Boolean: ...
    @winrt_commethod(11)
    def put_RedDisable(self, value: Boolean) -> Void: ...
    @winrt_commethod(12)
    def get_GreenOffset(self) -> Single: ...
    @winrt_commethod(13)
    def put_GreenOffset(self, value: Single) -> Void: ...
    @winrt_commethod(14)
    def get_GreenSlope(self) -> Single: ...
    @winrt_commethod(15)
    def put_GreenSlope(self, value: Single) -> Void: ...
    @winrt_commethod(16)
    def get_GreenDisable(self) -> Boolean: ...
    @winrt_commethod(17)
    def put_GreenDisable(self, value: Boolean) -> Void: ...
    @winrt_commethod(18)
    def get_BlueOffset(self) -> Single: ...
    @winrt_commethod(19)
    def put_BlueOffset(self, value: Single) -> Void: ...
    @winrt_commethod(20)
    def get_BlueSlope(self) -> Single: ...
    @winrt_commethod(21)
    def put_BlueSlope(self, value: Single) -> Void: ...
    @winrt_commethod(22)
    def get_BlueDisable(self) -> Boolean: ...
    @winrt_commethod(23)
    def put_BlueDisable(self, value: Boolean) -> Void: ...
    @winrt_commethod(24)
    def get_AlphaOffset(self) -> Single: ...
    @winrt_commethod(25)
    def put_AlphaOffset(self, value: Single) -> Void: ...
    @winrt_commethod(26)
    def get_AlphaSlope(self) -> Single: ...
    @winrt_commethod(27)
    def put_AlphaSlope(self, value: Single) -> Void: ...
    @winrt_commethod(28)
    def get_AlphaDisable(self) -> Boolean: ...
    @winrt_commethod(29)
    def put_AlphaDisable(self, value: Boolean) -> Void: ...
    @winrt_commethod(30)
    def get_ClampOutput(self) -> Boolean: ...
    @winrt_commethod(31)
    def put_ClampOutput(self, value: Boolean) -> Void: ...
    @winrt_commethod(32)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(33)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    AlphaDisable = property(get_AlphaDisable, put_AlphaDisable)
    AlphaOffset = property(get_AlphaOffset, put_AlphaOffset)
    AlphaSlope = property(get_AlphaSlope, put_AlphaSlope)
    BlueDisable = property(get_BlueDisable, put_BlueDisable)
    BlueOffset = property(get_BlueOffset, put_BlueOffset)
    BlueSlope = property(get_BlueSlope, put_BlueSlope)
    ClampOutput = property(get_ClampOutput, put_ClampOutput)
    GreenDisable = property(get_GreenDisable, put_GreenDisable)
    GreenOffset = property(get_GreenOffset, put_GreenOffset)
    GreenSlope = property(get_GreenSlope, put_GreenSlope)
    RedDisable = property(get_RedDisable, put_RedDisable)
    RedOffset = property(get_RedOffset, put_RedOffset)
    RedSlope = property(get_RedSlope, put_RedSlope)
    Source = property(get_Source, put_Source)
class ILuminanceToAlphaEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.ILuminanceToAlphaEffect'
    _iid_ = Guid('{22364900-ac51-5bd3-8bd2-d626fc9a65f9}')
    @winrt_commethod(6)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(7)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    Source = property(get_Source, put_Source)
class IMorphologyEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IMorphologyEffect'
    _iid_ = Guid('{ff065fdb-62c8-5808-921e-49efa43a3d34}')
    @winrt_commethod(6)
    def get_Mode(self) -> win32more.Microsoft.Graphics.Canvas.Effects.MorphologyEffectMode: ...
    @winrt_commethod(7)
    def put_Mode(self, value: win32more.Microsoft.Graphics.Canvas.Effects.MorphologyEffectMode) -> Void: ...
    @winrt_commethod(8)
    def get_Width(self) -> Int32: ...
    @winrt_commethod(9)
    def put_Width(self, value: Int32) -> Void: ...
    @winrt_commethod(10)
    def get_Height(self) -> Int32: ...
    @winrt_commethod(11)
    def put_Height(self, value: Int32) -> Void: ...
    @winrt_commethod(12)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(13)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    Height = property(get_Height, put_Height)
    Mode = property(get_Mode, put_Mode)
    Source = property(get_Source, put_Source)
    Width = property(get_Width, put_Width)
class IOpacityEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IOpacityEffect'
    _iid_ = Guid('{94b6ad75-c540-51b8-a9d1-544174adc68d}')
    @winrt_commethod(6)
    def get_Opacity(self) -> Single: ...
    @winrt_commethod(7)
    def put_Opacity(self, value: Single) -> Void: ...
    @winrt_commethod(8)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(9)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    Opacity = property(get_Opacity, put_Opacity)
    Source = property(get_Source, put_Source)
class IOpacityEffectStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IOpacityEffectStatics'
    _iid_ = Guid('{91a7cde3-b9b7-5437-8878-fb2e14100e6d}')
    @winrt_commethod(6)
    def get_IsSupported(self) -> Boolean: ...
    IsSupported = property(get_IsSupported, None)
class IOpacityMetadataEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IOpacityMetadataEffect'
    _iid_ = Guid('{099f3299-9b0a-5ed3-b044-4a6fc96f8362}')
    @winrt_commethod(6)
    def get_OpaqueRectangle(self) -> win32more.Windows.Foundation.Rect: ...
    @winrt_commethod(7)
    def put_OpaqueRectangle(self, value: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_commethod(8)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(9)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    OpaqueRectangle = property(get_OpaqueRectangle, put_OpaqueRectangle)
    Source = property(get_Source, put_Source)
class IPixelShaderEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect'
    _iid_ = Guid('{fc8c3c31-fa96-45e2-8b72-1741c65cee8e}')
    @winrt_commethod(6)
    def get_Properties(self) -> win32more.Windows.Foundation.Collections.IMap[WinRT_String, IInspectable]: ...
    @winrt_commethod(7)
    def get_Source1(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(8)
    def get_Source2(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(9)
    def get_Source3(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(10)
    def get_Source4(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(11)
    def get_Source5(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(12)
    def get_Source6(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(13)
    def get_Source7(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(14)
    def get_Source8(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(15)
    def put_Source1(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_commethod(16)
    def put_Source2(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_commethod(17)
    def put_Source3(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_commethod(18)
    def put_Source4(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_commethod(19)
    def put_Source5(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_commethod(20)
    def put_Source6(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_commethod(21)
    def put_Source7(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_commethod(22)
    def put_Source8(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_commethod(23)
    def get_Source1Mapping(self) -> win32more.Microsoft.Graphics.Canvas.Effects.SamplerCoordinateMapping: ...
    @winrt_commethod(24)
    def get_Source2Mapping(self) -> win32more.Microsoft.Graphics.Canvas.Effects.SamplerCoordinateMapping: ...
    @winrt_commethod(25)
    def get_Source3Mapping(self) -> win32more.Microsoft.Graphics.Canvas.Effects.SamplerCoordinateMapping: ...
    @winrt_commethod(26)
    def get_Source4Mapping(self) -> win32more.Microsoft.Graphics.Canvas.Effects.SamplerCoordinateMapping: ...
    @winrt_commethod(27)
    def get_Source5Mapping(self) -> win32more.Microsoft.Graphics.Canvas.Effects.SamplerCoordinateMapping: ...
    @winrt_commethod(28)
    def get_Source6Mapping(self) -> win32more.Microsoft.Graphics.Canvas.Effects.SamplerCoordinateMapping: ...
    @winrt_commethod(29)
    def get_Source7Mapping(self) -> win32more.Microsoft.Graphics.Canvas.Effects.SamplerCoordinateMapping: ...
    @winrt_commethod(30)
    def get_Source8Mapping(self) -> win32more.Microsoft.Graphics.Canvas.Effects.SamplerCoordinateMapping: ...
    @winrt_commethod(31)
    def put_Source1Mapping(self, value: win32more.Microsoft.Graphics.Canvas.Effects.SamplerCoordinateMapping) -> Void: ...
    @winrt_commethod(32)
    def put_Source2Mapping(self, value: win32more.Microsoft.Graphics.Canvas.Effects.SamplerCoordinateMapping) -> Void: ...
    @winrt_commethod(33)
    def put_Source3Mapping(self, value: win32more.Microsoft.Graphics.Canvas.Effects.SamplerCoordinateMapping) -> Void: ...
    @winrt_commethod(34)
    def put_Source4Mapping(self, value: win32more.Microsoft.Graphics.Canvas.Effects.SamplerCoordinateMapping) -> Void: ...
    @winrt_commethod(35)
    def put_Source5Mapping(self, value: win32more.Microsoft.Graphics.Canvas.Effects.SamplerCoordinateMapping) -> Void: ...
    @winrt_commethod(36)
    def put_Source6Mapping(self, value: win32more.Microsoft.Graphics.Canvas.Effects.SamplerCoordinateMapping) -> Void: ...
    @winrt_commethod(37)
    def put_Source7Mapping(self, value: win32more.Microsoft.Graphics.Canvas.Effects.SamplerCoordinateMapping) -> Void: ...
    @winrt_commethod(38)
    def put_Source8Mapping(self, value: win32more.Microsoft.Graphics.Canvas.Effects.SamplerCoordinateMapping) -> Void: ...
    @winrt_commethod(39)
    def get_Source1BorderMode(self) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode: ...
    @winrt_commethod(40)
    def get_Source2BorderMode(self) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode: ...
    @winrt_commethod(41)
    def get_Source3BorderMode(self) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode: ...
    @winrt_commethod(42)
    def get_Source4BorderMode(self) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode: ...
    @winrt_commethod(43)
    def get_Source5BorderMode(self) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode: ...
    @winrt_commethod(44)
    def get_Source6BorderMode(self) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode: ...
    @winrt_commethod(45)
    def get_Source7BorderMode(self) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode: ...
    @winrt_commethod(46)
    def get_Source8BorderMode(self) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode: ...
    @winrt_commethod(47)
    def put_Source1BorderMode(self, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode) -> Void: ...
    @winrt_commethod(48)
    def put_Source2BorderMode(self, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode) -> Void: ...
    @winrt_commethod(49)
    def put_Source3BorderMode(self, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode) -> Void: ...
    @winrt_commethod(50)
    def put_Source4BorderMode(self, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode) -> Void: ...
    @winrt_commethod(51)
    def put_Source5BorderMode(self, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode) -> Void: ...
    @winrt_commethod(52)
    def put_Source6BorderMode(self, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode) -> Void: ...
    @winrt_commethod(53)
    def put_Source7BorderMode(self, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode) -> Void: ...
    @winrt_commethod(54)
    def put_Source8BorderMode(self, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode) -> Void: ...
    @winrt_commethod(55)
    def get_MaxSamplerOffset(self) -> Int32: ...
    @winrt_commethod(56)
    def put_MaxSamplerOffset(self, value: Int32) -> Void: ...
    @winrt_commethod(57)
    def get_Source1Interpolation(self) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_commethod(58)
    def get_Source2Interpolation(self) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_commethod(59)
    def get_Source3Interpolation(self) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_commethod(60)
    def get_Source4Interpolation(self) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_commethod(61)
    def get_Source5Interpolation(self) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_commethod(62)
    def get_Source6Interpolation(self) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_commethod(63)
    def get_Source7Interpolation(self) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_commethod(64)
    def get_Source8Interpolation(self) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_commethod(65)
    def put_Source1Interpolation(self, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_commethod(66)
    def put_Source2Interpolation(self, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_commethod(67)
    def put_Source3Interpolation(self, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_commethod(68)
    def put_Source4Interpolation(self, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_commethod(69)
    def put_Source5Interpolation(self, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_commethod(70)
    def put_Source6Interpolation(self, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_commethod(71)
    def put_Source7Interpolation(self, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_commethod(72)
    def put_Source8Interpolation(self, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_commethod(73)
    def IsSupported(self, device: win32more.Microsoft.Graphics.Canvas.CanvasDevice) -> Boolean: ...
    MaxSamplerOffset = property(get_MaxSamplerOffset, put_MaxSamplerOffset)
    Properties = property(get_Properties, None)
    Source1 = property(get_Source1, put_Source1)
    Source1BorderMode = property(get_Source1BorderMode, put_Source1BorderMode)
    Source1Interpolation = property(get_Source1Interpolation, put_Source1Interpolation)
    Source1Mapping = property(get_Source1Mapping, put_Source1Mapping)
    Source2 = property(get_Source2, put_Source2)
    Source2BorderMode = property(get_Source2BorderMode, put_Source2BorderMode)
    Source2Interpolation = property(get_Source2Interpolation, put_Source2Interpolation)
    Source2Mapping = property(get_Source2Mapping, put_Source2Mapping)
    Source3 = property(get_Source3, put_Source3)
    Source3BorderMode = property(get_Source3BorderMode, put_Source3BorderMode)
    Source3Interpolation = property(get_Source3Interpolation, put_Source3Interpolation)
    Source3Mapping = property(get_Source3Mapping, put_Source3Mapping)
    Source4 = property(get_Source4, put_Source4)
    Source4BorderMode = property(get_Source4BorderMode, put_Source4BorderMode)
    Source4Interpolation = property(get_Source4Interpolation, put_Source4Interpolation)
    Source4Mapping = property(get_Source4Mapping, put_Source4Mapping)
    Source5 = property(get_Source5, put_Source5)
    Source5BorderMode = property(get_Source5BorderMode, put_Source5BorderMode)
    Source5Interpolation = property(get_Source5Interpolation, put_Source5Interpolation)
    Source5Mapping = property(get_Source5Mapping, put_Source5Mapping)
    Source6 = property(get_Source6, put_Source6)
    Source6BorderMode = property(get_Source6BorderMode, put_Source6BorderMode)
    Source6Interpolation = property(get_Source6Interpolation, put_Source6Interpolation)
    Source6Mapping = property(get_Source6Mapping, put_Source6Mapping)
    Source7 = property(get_Source7, put_Source7)
    Source7BorderMode = property(get_Source7BorderMode, put_Source7BorderMode)
    Source7Interpolation = property(get_Source7Interpolation, put_Source7Interpolation)
    Source7Mapping = property(get_Source7Mapping, put_Source7Mapping)
    Source8 = property(get_Source8, put_Source8)
    Source8BorderMode = property(get_Source8BorderMode, put_Source8BorderMode)
    Source8Interpolation = property(get_Source8Interpolation, put_Source8Interpolation)
    Source8Mapping = property(get_Source8Mapping, put_Source8Mapping)
class IPixelShaderEffectFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IPixelShaderEffectFactory'
    _iid_ = Guid('{9d1727e5-489d-4abc-b129-5361e3534af4}')
    @winrt_commethod(6)
    def Create(self, shaderCode: PassArray[Byte]) -> win32more.Microsoft.Graphics.Canvas.Effects.PixelShaderEffect: ...
class IPointDiffuseEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IPointDiffuseEffect'
    _iid_ = Guid('{6cce09ec-f847-5661-af4b-531dd3dd7d6e}')
    @winrt_commethod(6)
    def get_LightPosition(self) -> win32more.Windows.Foundation.Numerics.Vector3: ...
    @winrt_commethod(7)
    def put_LightPosition(self, value: win32more.Windows.Foundation.Numerics.Vector3) -> Void: ...
    @winrt_commethod(8)
    def get_DiffuseAmount(self) -> Single: ...
    @winrt_commethod(9)
    def put_DiffuseAmount(self, value: Single) -> Void: ...
    @winrt_commethod(10)
    def get_HeightMapScale(self) -> Single: ...
    @winrt_commethod(11)
    def put_HeightMapScale(self, value: Single) -> Void: ...
    @winrt_commethod(12)
    def get_LightColor(self) -> win32more.Windows.UI.Color: ...
    @winrt_commethod(13)
    def put_LightColor(self, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(14)
    def get_HeightMapKernelSize(self) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_commethod(15)
    def put_HeightMapKernelSize(self, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_commethod(16)
    def get_HeightMapInterpolationMode(self) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_commethod(17)
    def put_HeightMapInterpolationMode(self, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_commethod(18)
    def get_LightColorHdr(self) -> win32more.Windows.Foundation.Numerics.Vector4: ...
    @winrt_commethod(19)
    def put_LightColorHdr(self, value: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_commethod(20)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(21)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    DiffuseAmount = property(get_DiffuseAmount, put_DiffuseAmount)
    HeightMapInterpolationMode = property(get_HeightMapInterpolationMode, put_HeightMapInterpolationMode)
    HeightMapKernelSize = property(get_HeightMapKernelSize, put_HeightMapKernelSize)
    HeightMapScale = property(get_HeightMapScale, put_HeightMapScale)
    LightColor = property(get_LightColor, put_LightColor)
    LightColorHdr = property(get_LightColorHdr, put_LightColorHdr)
    LightPosition = property(get_LightPosition, put_LightPosition)
    Source = property(get_Source, put_Source)
class IPointSpecularEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IPointSpecularEffect'
    _iid_ = Guid('{ec8afe9b-8501-5286-a43c-1afff7420ad6}')
    @winrt_commethod(6)
    def get_LightPosition(self) -> win32more.Windows.Foundation.Numerics.Vector3: ...
    @winrt_commethod(7)
    def put_LightPosition(self, value: win32more.Windows.Foundation.Numerics.Vector3) -> Void: ...
    @winrt_commethod(8)
    def get_SpecularExponent(self) -> Single: ...
    @winrt_commethod(9)
    def put_SpecularExponent(self, value: Single) -> Void: ...
    @winrt_commethod(10)
    def get_SpecularAmount(self) -> Single: ...
    @winrt_commethod(11)
    def put_SpecularAmount(self, value: Single) -> Void: ...
    @winrt_commethod(12)
    def get_HeightMapScale(self) -> Single: ...
    @winrt_commethod(13)
    def put_HeightMapScale(self, value: Single) -> Void: ...
    @winrt_commethod(14)
    def get_LightColor(self) -> win32more.Windows.UI.Color: ...
    @winrt_commethod(15)
    def put_LightColor(self, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(16)
    def get_HeightMapKernelSize(self) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_commethod(17)
    def put_HeightMapKernelSize(self, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_commethod(18)
    def get_HeightMapInterpolationMode(self) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_commethod(19)
    def put_HeightMapInterpolationMode(self, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_commethod(20)
    def get_LightColorHdr(self) -> win32more.Windows.Foundation.Numerics.Vector4: ...
    @winrt_commethod(21)
    def put_LightColorHdr(self, value: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_commethod(22)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(23)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    HeightMapInterpolationMode = property(get_HeightMapInterpolationMode, put_HeightMapInterpolationMode)
    HeightMapKernelSize = property(get_HeightMapKernelSize, put_HeightMapKernelSize)
    HeightMapScale = property(get_HeightMapScale, put_HeightMapScale)
    LightColor = property(get_LightColor, put_LightColor)
    LightColorHdr = property(get_LightColorHdr, put_LightColorHdr)
    LightPosition = property(get_LightPosition, put_LightPosition)
    Source = property(get_Source, put_Source)
    SpecularAmount = property(get_SpecularAmount, put_SpecularAmount)
    SpecularExponent = property(get_SpecularExponent, put_SpecularExponent)
class IPosterizeEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IPosterizeEffect'
    _iid_ = Guid('{2f631a3b-c89a-507c-9756-299b61434fa4}')
    @winrt_commethod(6)
    def get_RedValueCount(self) -> Int32: ...
    @winrt_commethod(7)
    def put_RedValueCount(self, value: Int32) -> Void: ...
    @winrt_commethod(8)
    def get_GreenValueCount(self) -> Int32: ...
    @winrt_commethod(9)
    def put_GreenValueCount(self, value: Int32) -> Void: ...
    @winrt_commethod(10)
    def get_BlueValueCount(self) -> Int32: ...
    @winrt_commethod(11)
    def put_BlueValueCount(self, value: Int32) -> Void: ...
    @winrt_commethod(12)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(13)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    BlueValueCount = property(get_BlueValueCount, put_BlueValueCount)
    GreenValueCount = property(get_GreenValueCount, put_GreenValueCount)
    RedValueCount = property(get_RedValueCount, put_RedValueCount)
    Source = property(get_Source, put_Source)
class IPremultiplyEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IPremultiplyEffect'
    _iid_ = Guid('{d29a9d1e-bd57-5f3e-9ae0-009c6ac5b06d}')
    @winrt_commethod(6)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(7)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    Source = property(get_Source, put_Source)
class IRgbToHueEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IRgbToHueEffect'
    _iid_ = Guid('{7caeadc6-9eb3-5895-b876-f485c9574847}')
    @winrt_commethod(6)
    def get_OutputColorSpace(self) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectHueColorSpace: ...
    @winrt_commethod(7)
    def put_OutputColorSpace(self, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectHueColorSpace) -> Void: ...
    @winrt_commethod(8)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(9)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    OutputColorSpace = property(get_OutputColorSpace, put_OutputColorSpace)
    Source = property(get_Source, put_Source)
class ISaturationEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.ISaturationEffect'
    _iid_ = Guid('{f85a5ed7-7212-57a6-b357-61038961c58d}')
    @winrt_commethod(6)
    def get_Saturation(self) -> Single: ...
    @winrt_commethod(7)
    def put_Saturation(self, value: Single) -> Void: ...
    @winrt_commethod(8)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(9)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    Saturation = property(get_Saturation, put_Saturation)
    Source = property(get_Source, put_Source)
class IScaleEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IScaleEffect'
    _iid_ = Guid('{7522ae90-bec2-512c-bcc0-4d6a97e3ed34}')
    @winrt_commethod(6)
    def get_Scale(self) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_commethod(7)
    def put_Scale(self, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_commethod(8)
    def get_CenterPoint(self) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_commethod(9)
    def put_CenterPoint(self, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_commethod(10)
    def get_InterpolationMode(self) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_commethod(11)
    def put_InterpolationMode(self, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_commethod(12)
    def get_BorderMode(self) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode: ...
    @winrt_commethod(13)
    def put_BorderMode(self, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode) -> Void: ...
    @winrt_commethod(14)
    def get_Sharpness(self) -> Single: ...
    @winrt_commethod(15)
    def put_Sharpness(self, value: Single) -> Void: ...
    @winrt_commethod(16)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(17)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    BorderMode = property(get_BorderMode, put_BorderMode)
    CenterPoint = property(get_CenterPoint, put_CenterPoint)
    InterpolationMode = property(get_InterpolationMode, put_InterpolationMode)
    Scale = property(get_Scale, put_Scale)
    Sharpness = property(get_Sharpness, put_Sharpness)
    Source = property(get_Source, put_Source)
class ISepiaEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.ISepiaEffect'
    _iid_ = Guid('{f933471f-a7af-5521-be79-b0da22976cff}')
    @winrt_commethod(6)
    def get_Intensity(self) -> Single: ...
    @winrt_commethod(7)
    def put_Intensity(self, value: Single) -> Void: ...
    @winrt_commethod(8)
    def get_AlphaMode(self) -> win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode: ...
    @winrt_commethod(9)
    def put_AlphaMode(self, value: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> Void: ...
    @winrt_commethod(10)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(11)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    AlphaMode = property(get_AlphaMode, put_AlphaMode)
    Intensity = property(get_Intensity, put_Intensity)
    Source = property(get_Source, put_Source)
class IShadowEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IShadowEffect'
    _iid_ = Guid('{3947c621-78da-5489-9927-be655f4576e2}')
    @winrt_commethod(6)
    def get_BlurAmount(self) -> Single: ...
    @winrt_commethod(7)
    def put_BlurAmount(self, value: Single) -> Void: ...
    @winrt_commethod(8)
    def get_ShadowColor(self) -> win32more.Windows.UI.Color: ...
    @winrt_commethod(9)
    def put_ShadowColor(self, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(10)
    def get_Optimization(self) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectOptimization: ...
    @winrt_commethod(11)
    def put_Optimization(self, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectOptimization) -> Void: ...
    @winrt_commethod(12)
    def get_ShadowColorHdr(self) -> win32more.Windows.Foundation.Numerics.Vector4: ...
    @winrt_commethod(13)
    def put_ShadowColorHdr(self, value: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_commethod(14)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(15)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    BlurAmount = property(get_BlurAmount, put_BlurAmount)
    Optimization = property(get_Optimization, put_Optimization)
    ShadowColor = property(get_ShadowColor, put_ShadowColor)
    ShadowColorHdr = property(get_ShadowColorHdr, put_ShadowColorHdr)
    Source = property(get_Source, put_Source)
class ISharpenEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.ISharpenEffect'
    _iid_ = Guid('{7efef0a1-7578-5f62-8364-46145674ef7e}')
    @winrt_commethod(6)
    def get_Amount(self) -> Single: ...
    @winrt_commethod(7)
    def put_Amount(self, value: Single) -> Void: ...
    @winrt_commethod(8)
    def get_Threshold(self) -> Single: ...
    @winrt_commethod(9)
    def put_Threshold(self, value: Single) -> Void: ...
    @winrt_commethod(10)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(11)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    Amount = property(get_Amount, put_Amount)
    Source = property(get_Source, put_Source)
    Threshold = property(get_Threshold, put_Threshold)
class ISpotDiffuseEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.ISpotDiffuseEffect'
    _iid_ = Guid('{b3dcbe44-1dd7-5cb3-95e5-a48974cd12e8}')
    @winrt_commethod(6)
    def get_LightPosition(self) -> win32more.Windows.Foundation.Numerics.Vector3: ...
    @winrt_commethod(7)
    def put_LightPosition(self, value: win32more.Windows.Foundation.Numerics.Vector3) -> Void: ...
    @winrt_commethod(8)
    def get_LightTarget(self) -> win32more.Windows.Foundation.Numerics.Vector3: ...
    @winrt_commethod(9)
    def put_LightTarget(self, value: win32more.Windows.Foundation.Numerics.Vector3) -> Void: ...
    @winrt_commethod(10)
    def get_Focus(self) -> Single: ...
    @winrt_commethod(11)
    def put_Focus(self, value: Single) -> Void: ...
    @winrt_commethod(12)
    def get_LimitingConeAngle(self) -> Single: ...
    @winrt_commethod(13)
    def put_LimitingConeAngle(self, value: Single) -> Void: ...
    @winrt_commethod(14)
    def get_DiffuseAmount(self) -> Single: ...
    @winrt_commethod(15)
    def put_DiffuseAmount(self, value: Single) -> Void: ...
    @winrt_commethod(16)
    def get_HeightMapScale(self) -> Single: ...
    @winrt_commethod(17)
    def put_HeightMapScale(self, value: Single) -> Void: ...
    @winrt_commethod(18)
    def get_LightColor(self) -> win32more.Windows.UI.Color: ...
    @winrt_commethod(19)
    def put_LightColor(self, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(20)
    def get_HeightMapKernelSize(self) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_commethod(21)
    def put_HeightMapKernelSize(self, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_commethod(22)
    def get_HeightMapInterpolationMode(self) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_commethod(23)
    def put_HeightMapInterpolationMode(self, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_commethod(24)
    def get_LightColorHdr(self) -> win32more.Windows.Foundation.Numerics.Vector4: ...
    @winrt_commethod(25)
    def put_LightColorHdr(self, value: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_commethod(26)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(27)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    DiffuseAmount = property(get_DiffuseAmount, put_DiffuseAmount)
    Focus = property(get_Focus, put_Focus)
    HeightMapInterpolationMode = property(get_HeightMapInterpolationMode, put_HeightMapInterpolationMode)
    HeightMapKernelSize = property(get_HeightMapKernelSize, put_HeightMapKernelSize)
    HeightMapScale = property(get_HeightMapScale, put_HeightMapScale)
    LightColor = property(get_LightColor, put_LightColor)
    LightColorHdr = property(get_LightColorHdr, put_LightColorHdr)
    LightPosition = property(get_LightPosition, put_LightPosition)
    LightTarget = property(get_LightTarget, put_LightTarget)
    LimitingConeAngle = property(get_LimitingConeAngle, put_LimitingConeAngle)
    Source = property(get_Source, put_Source)
class ISpotSpecularEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.ISpotSpecularEffect'
    _iid_ = Guid('{83ae4cd0-80aa-5783-8572-f15e5f85329e}')
    @winrt_commethod(6)
    def get_LightPosition(self) -> win32more.Windows.Foundation.Numerics.Vector3: ...
    @winrt_commethod(7)
    def put_LightPosition(self, value: win32more.Windows.Foundation.Numerics.Vector3) -> Void: ...
    @winrt_commethod(8)
    def get_LightTarget(self) -> win32more.Windows.Foundation.Numerics.Vector3: ...
    @winrt_commethod(9)
    def put_LightTarget(self, value: win32more.Windows.Foundation.Numerics.Vector3) -> Void: ...
    @winrt_commethod(10)
    def get_Focus(self) -> Single: ...
    @winrt_commethod(11)
    def put_Focus(self, value: Single) -> Void: ...
    @winrt_commethod(12)
    def get_LimitingConeAngle(self) -> Single: ...
    @winrt_commethod(13)
    def put_LimitingConeAngle(self, value: Single) -> Void: ...
    @winrt_commethod(14)
    def get_SpecularExponent(self) -> Single: ...
    @winrt_commethod(15)
    def put_SpecularExponent(self, value: Single) -> Void: ...
    @winrt_commethod(16)
    def get_SpecularAmount(self) -> Single: ...
    @winrt_commethod(17)
    def put_SpecularAmount(self, value: Single) -> Void: ...
    @winrt_commethod(18)
    def get_HeightMapScale(self) -> Single: ...
    @winrt_commethod(19)
    def put_HeightMapScale(self, value: Single) -> Void: ...
    @winrt_commethod(20)
    def get_LightColor(self) -> win32more.Windows.UI.Color: ...
    @winrt_commethod(21)
    def put_LightColor(self, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(22)
    def get_HeightMapKernelSize(self) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_commethod(23)
    def put_HeightMapKernelSize(self, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_commethod(24)
    def get_HeightMapInterpolationMode(self) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_commethod(25)
    def put_HeightMapInterpolationMode(self, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_commethod(26)
    def get_LightColorHdr(self) -> win32more.Windows.Foundation.Numerics.Vector4: ...
    @winrt_commethod(27)
    def put_LightColorHdr(self, value: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_commethod(28)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(29)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    Focus = property(get_Focus, put_Focus)
    HeightMapInterpolationMode = property(get_HeightMapInterpolationMode, put_HeightMapInterpolationMode)
    HeightMapKernelSize = property(get_HeightMapKernelSize, put_HeightMapKernelSize)
    HeightMapScale = property(get_HeightMapScale, put_HeightMapScale)
    LightColor = property(get_LightColor, put_LightColor)
    LightColorHdr = property(get_LightColorHdr, put_LightColorHdr)
    LightPosition = property(get_LightPosition, put_LightPosition)
    LightTarget = property(get_LightTarget, put_LightTarget)
    LimitingConeAngle = property(get_LimitingConeAngle, put_LimitingConeAngle)
    Source = property(get_Source, put_Source)
    SpecularAmount = property(get_SpecularAmount, put_SpecularAmount)
    SpecularExponent = property(get_SpecularExponent, put_SpecularExponent)
class IStraightenEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IStraightenEffect'
    _iid_ = Guid('{965fc262-2eba-59e6-935f-2389cb5a305a}')
    @winrt_commethod(6)
    def get_Angle(self) -> Single: ...
    @winrt_commethod(7)
    def put_Angle(self, value: Single) -> Void: ...
    @winrt_commethod(8)
    def get_MaintainSize(self) -> Boolean: ...
    @winrt_commethod(9)
    def put_MaintainSize(self, value: Boolean) -> Void: ...
    @winrt_commethod(10)
    def get_InterpolationMode(self) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_commethod(11)
    def put_InterpolationMode(self, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_commethod(12)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(13)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    Angle = property(get_Angle, put_Angle)
    InterpolationMode = property(get_InterpolationMode, put_InterpolationMode)
    MaintainSize = property(get_MaintainSize, put_MaintainSize)
    Source = property(get_Source, put_Source)
class ITableTransfer3DEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.ITableTransfer3DEffect'
    _iid_ = Guid('{ef09c6e0-9437-53f7-b7b4-b53c79a0bc37}')
    @winrt_commethod(6)
    def get_Table(self) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectTransferTable3D: ...
    @winrt_commethod(7)
    def put_Table(self, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectTransferTable3D) -> Void: ...
    @winrt_commethod(8)
    def get_AlphaMode(self) -> win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode: ...
    @winrt_commethod(9)
    def put_AlphaMode(self, value: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> Void: ...
    @winrt_commethod(10)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(11)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    AlphaMode = property(get_AlphaMode, put_AlphaMode)
    Source = property(get_Source, put_Source)
    Table = property(get_Table, put_Table)
class ITableTransferEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.ITableTransferEffect'
    _iid_ = Guid('{bf0b63b6-fe77-5198-a2a1-3fb80c268b8f}')
    @winrt_commethod(6)
    def get_RedTable(self) -> ReceiveArray[Single]: ...
    @winrt_commethod(7)
    def put_RedTable(self, valueElements: PassArray[Single]) -> Void: ...
    @winrt_commethod(8)
    def get_RedDisable(self) -> Boolean: ...
    @winrt_commethod(9)
    def put_RedDisable(self, value: Boolean) -> Void: ...
    @winrt_commethod(10)
    def get_GreenTable(self) -> ReceiveArray[Single]: ...
    @winrt_commethod(11)
    def put_GreenTable(self, valueElements: PassArray[Single]) -> Void: ...
    @winrt_commethod(12)
    def get_GreenDisable(self) -> Boolean: ...
    @winrt_commethod(13)
    def put_GreenDisable(self, value: Boolean) -> Void: ...
    @winrt_commethod(14)
    def get_BlueTable(self) -> ReceiveArray[Single]: ...
    @winrt_commethod(15)
    def put_BlueTable(self, valueElements: PassArray[Single]) -> Void: ...
    @winrt_commethod(16)
    def get_BlueDisable(self) -> Boolean: ...
    @winrt_commethod(17)
    def put_BlueDisable(self, value: Boolean) -> Void: ...
    @winrt_commethod(18)
    def get_AlphaTable(self) -> ReceiveArray[Single]: ...
    @winrt_commethod(19)
    def put_AlphaTable(self, valueElements: PassArray[Single]) -> Void: ...
    @winrt_commethod(20)
    def get_AlphaDisable(self) -> Boolean: ...
    @winrt_commethod(21)
    def put_AlphaDisable(self, value: Boolean) -> Void: ...
    @winrt_commethod(22)
    def get_ClampOutput(self) -> Boolean: ...
    @winrt_commethod(23)
    def put_ClampOutput(self, value: Boolean) -> Void: ...
    @winrt_commethod(24)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(25)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    AlphaDisable = property(get_AlphaDisable, put_AlphaDisable)
    AlphaTable = property(get_AlphaTable, put_AlphaTable)
    BlueDisable = property(get_BlueDisable, put_BlueDisable)
    BlueTable = property(get_BlueTable, put_BlueTable)
    ClampOutput = property(get_ClampOutput, put_ClampOutput)
    GreenDisable = property(get_GreenDisable, put_GreenDisable)
    GreenTable = property(get_GreenTable, put_GreenTable)
    RedDisable = property(get_RedDisable, put_RedDisable)
    RedTable = property(get_RedTable, put_RedTable)
    Source = property(get_Source, put_Source)
class ITemperatureAndTintEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.ITemperatureAndTintEffect'
    _iid_ = Guid('{8ae43e02-2619-5d78-8980-4ed569549bd8}')
    @winrt_commethod(6)
    def get_Temperature(self) -> Single: ...
    @winrt_commethod(7)
    def put_Temperature(self, value: Single) -> Void: ...
    @winrt_commethod(8)
    def get_Tint(self) -> Single: ...
    @winrt_commethod(9)
    def put_Tint(self, value: Single) -> Void: ...
    @winrt_commethod(10)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(11)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    Source = property(get_Source, put_Source)
    Temperature = property(get_Temperature, put_Temperature)
    Tint = property(get_Tint, put_Tint)
class ITileEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.ITileEffect'
    _iid_ = Guid('{78a809cb-1154-5ad6-a880-e3a175772815}')
    @winrt_commethod(6)
    def get_SourceRectangle(self) -> win32more.Windows.Foundation.Rect: ...
    @winrt_commethod(7)
    def put_SourceRectangle(self, value: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_commethod(8)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(9)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    Source = property(get_Source, put_Source)
    SourceRectangle = property(get_SourceRectangle, put_SourceRectangle)
class ITintEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.ITintEffect'
    _iid_ = Guid('{729a21ea-c61e-5308-9eae-d638aa1f5b8c}')
    @winrt_commethod(6)
    def get_Color(self) -> win32more.Windows.UI.Color: ...
    @winrt_commethod(7)
    def put_Color(self, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(8)
    def get_ClampOutput(self) -> Boolean: ...
    @winrt_commethod(9)
    def put_ClampOutput(self, value: Boolean) -> Void: ...
    @winrt_commethod(10)
    def get_ColorHdr(self) -> win32more.Windows.Foundation.Numerics.Vector4: ...
    @winrt_commethod(11)
    def put_ColorHdr(self, value: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_commethod(12)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(13)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    ClampOutput = property(get_ClampOutput, put_ClampOutput)
    Color = property(get_Color, put_Color)
    ColorHdr = property(get_ColorHdr, put_ColorHdr)
    Source = property(get_Source, put_Source)
class ITintEffectStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.ITintEffectStatics'
    _iid_ = Guid('{65e31771-4baf-5c8c-93f4-3b874e29f68d}')
    @winrt_commethod(6)
    def get_IsSupported(self) -> Boolean: ...
    IsSupported = property(get_IsSupported, None)
class ITransform2DEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.ITransform2DEffect'
    _iid_ = Guid('{4467d118-33e7-5b1a-87c2-0f1f0497353d}')
    @winrt_commethod(6)
    def get_InterpolationMode(self) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_commethod(7)
    def put_InterpolationMode(self, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_commethod(8)
    def get_BorderMode(self) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode: ...
    @winrt_commethod(9)
    def put_BorderMode(self, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode) -> Void: ...
    @winrt_commethod(10)
    def get_TransformMatrix(self) -> win32more.Windows.Foundation.Numerics.Matrix3x2: ...
    @winrt_commethod(11)
    def put_TransformMatrix(self, value: win32more.Windows.Foundation.Numerics.Matrix3x2) -> Void: ...
    @winrt_commethod(12)
    def get_Sharpness(self) -> Single: ...
    @winrt_commethod(13)
    def put_Sharpness(self, value: Single) -> Void: ...
    @winrt_commethod(14)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(15)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    BorderMode = property(get_BorderMode, put_BorderMode)
    InterpolationMode = property(get_InterpolationMode, put_InterpolationMode)
    Sharpness = property(get_Sharpness, put_Sharpness)
    Source = property(get_Source, put_Source)
    TransformMatrix = property(get_TransformMatrix, put_TransformMatrix)
class ITransform3DEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.ITransform3DEffect'
    _iid_ = Guid('{3025ed7f-8f25-5e0b-80c9-56bbdd3e8a10}')
    @winrt_commethod(6)
    def get_InterpolationMode(self) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_commethod(7)
    def put_InterpolationMode(self, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_commethod(8)
    def get_BorderMode(self) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode: ...
    @winrt_commethod(9)
    def put_BorderMode(self, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode) -> Void: ...
    @winrt_commethod(10)
    def get_TransformMatrix(self) -> win32more.Windows.Foundation.Numerics.Matrix4x4: ...
    @winrt_commethod(11)
    def put_TransformMatrix(self, value: win32more.Windows.Foundation.Numerics.Matrix4x4) -> Void: ...
    @winrt_commethod(12)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(13)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    BorderMode = property(get_BorderMode, put_BorderMode)
    InterpolationMode = property(get_InterpolationMode, put_InterpolationMode)
    Source = property(get_Source, put_Source)
    TransformMatrix = property(get_TransformMatrix, put_TransformMatrix)
class ITurbulenceEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.ITurbulenceEffect'
    _iid_ = Guid('{1cb1b33d-20e9-564b-856e-37e9fa1d0016}')
    @winrt_commethod(6)
    def get_Offset(self) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_commethod(7)
    def put_Offset(self, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_commethod(8)
    def get_Size(self) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_commethod(9)
    def put_Size(self, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_commethod(10)
    def get_Frequency(self) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_commethod(11)
    def put_Frequency(self, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_commethod(12)
    def get_Octaves(self) -> Int32: ...
    @winrt_commethod(13)
    def put_Octaves(self, value: Int32) -> Void: ...
    @winrt_commethod(14)
    def get_Seed(self) -> Int32: ...
    @winrt_commethod(15)
    def put_Seed(self, value: Int32) -> Void: ...
    @winrt_commethod(16)
    def get_Noise(self) -> win32more.Microsoft.Graphics.Canvas.Effects.TurbulenceEffectNoise: ...
    @winrt_commethod(17)
    def put_Noise(self, value: win32more.Microsoft.Graphics.Canvas.Effects.TurbulenceEffectNoise) -> Void: ...
    @winrt_commethod(18)
    def get_Tileable(self) -> Boolean: ...
    @winrt_commethod(19)
    def put_Tileable(self, value: Boolean) -> Void: ...
    Frequency = property(get_Frequency, put_Frequency)
    Noise = property(get_Noise, put_Noise)
    Octaves = property(get_Octaves, put_Octaves)
    Offset = property(get_Offset, put_Offset)
    Seed = property(get_Seed, put_Seed)
    Size = property(get_Size, put_Size)
    Tileable = property(get_Tileable, put_Tileable)
class IUnPremultiplyEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IUnPremultiplyEffect'
    _iid_ = Guid('{73098bb4-dcf1-5403-af44-3344d2982d40}')
    @winrt_commethod(6)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(7)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    Source = property(get_Source, put_Source)
class IVignetteEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.IVignetteEffect'
    _iid_ = Guid('{574d0f9f-eec7-5989-ac53-135868cf5e0c}')
    @winrt_commethod(6)
    def get_Color(self) -> win32more.Windows.UI.Color: ...
    @winrt_commethod(7)
    def put_Color(self, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(8)
    def get_Amount(self) -> Single: ...
    @winrt_commethod(9)
    def put_Amount(self, value: Single) -> Void: ...
    @winrt_commethod(10)
    def get_Curve(self) -> Single: ...
    @winrt_commethod(11)
    def put_Curve(self, value: Single) -> Void: ...
    @winrt_commethod(12)
    def get_ColorHdr(self) -> win32more.Windows.Foundation.Numerics.Vector4: ...
    @winrt_commethod(13)
    def put_ColorHdr(self, value: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_commethod(14)
    def get_Source(self) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_commethod(15)
    def put_Source(self, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    Amount = property(get_Amount, put_Amount)
    Color = property(get_Color, put_Color)
    ColorHdr = property(get_ColorHdr, put_ColorHdr)
    Curve = property(get_Curve, put_Curve)
    Source = property(get_Source, put_Source)
class InvertEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IInvertEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.InvertEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.InvertEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.InvertEffect: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IInvertEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IInvertEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)
class LinearTransferEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.ILinearTransferEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.LinearTransferEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.LinearTransferEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.LinearTransferEffect: ...
    @winrt_mixinmethod
    def get_RedOffset(self: win32more.Microsoft.Graphics.Canvas.Effects.ILinearTransferEffect) -> Single: ...
    @winrt_mixinmethod
    def put_RedOffset(self: win32more.Microsoft.Graphics.Canvas.Effects.ILinearTransferEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_RedSlope(self: win32more.Microsoft.Graphics.Canvas.Effects.ILinearTransferEffect) -> Single: ...
    @winrt_mixinmethod
    def put_RedSlope(self: win32more.Microsoft.Graphics.Canvas.Effects.ILinearTransferEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_RedDisable(self: win32more.Microsoft.Graphics.Canvas.Effects.ILinearTransferEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_RedDisable(self: win32more.Microsoft.Graphics.Canvas.Effects.ILinearTransferEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_GreenOffset(self: win32more.Microsoft.Graphics.Canvas.Effects.ILinearTransferEffect) -> Single: ...
    @winrt_mixinmethod
    def put_GreenOffset(self: win32more.Microsoft.Graphics.Canvas.Effects.ILinearTransferEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_GreenSlope(self: win32more.Microsoft.Graphics.Canvas.Effects.ILinearTransferEffect) -> Single: ...
    @winrt_mixinmethod
    def put_GreenSlope(self: win32more.Microsoft.Graphics.Canvas.Effects.ILinearTransferEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_GreenDisable(self: win32more.Microsoft.Graphics.Canvas.Effects.ILinearTransferEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_GreenDisable(self: win32more.Microsoft.Graphics.Canvas.Effects.ILinearTransferEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BlueOffset(self: win32more.Microsoft.Graphics.Canvas.Effects.ILinearTransferEffect) -> Single: ...
    @winrt_mixinmethod
    def put_BlueOffset(self: win32more.Microsoft.Graphics.Canvas.Effects.ILinearTransferEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_BlueSlope(self: win32more.Microsoft.Graphics.Canvas.Effects.ILinearTransferEffect) -> Single: ...
    @winrt_mixinmethod
    def put_BlueSlope(self: win32more.Microsoft.Graphics.Canvas.Effects.ILinearTransferEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_BlueDisable(self: win32more.Microsoft.Graphics.Canvas.Effects.ILinearTransferEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_BlueDisable(self: win32more.Microsoft.Graphics.Canvas.Effects.ILinearTransferEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_AlphaOffset(self: win32more.Microsoft.Graphics.Canvas.Effects.ILinearTransferEffect) -> Single: ...
    @winrt_mixinmethod
    def put_AlphaOffset(self: win32more.Microsoft.Graphics.Canvas.Effects.ILinearTransferEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_AlphaSlope(self: win32more.Microsoft.Graphics.Canvas.Effects.ILinearTransferEffect) -> Single: ...
    @winrt_mixinmethod
    def put_AlphaSlope(self: win32more.Microsoft.Graphics.Canvas.Effects.ILinearTransferEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_AlphaDisable(self: win32more.Microsoft.Graphics.Canvas.Effects.ILinearTransferEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_AlphaDisable(self: win32more.Microsoft.Graphics.Canvas.Effects.ILinearTransferEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_ClampOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ILinearTransferEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_ClampOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ILinearTransferEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.ILinearTransferEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.ILinearTransferEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    AlphaDisable = property(get_AlphaDisable, put_AlphaDisable)
    AlphaOffset = property(get_AlphaOffset, put_AlphaOffset)
    AlphaSlope = property(get_AlphaSlope, put_AlphaSlope)
    BlueDisable = property(get_BlueDisable, put_BlueDisable)
    BlueOffset = property(get_BlueOffset, put_BlueOffset)
    BlueSlope = property(get_BlueSlope, put_BlueSlope)
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    ClampOutput = property(get_ClampOutput, put_ClampOutput)
    GreenDisable = property(get_GreenDisable, put_GreenDisable)
    GreenOffset = property(get_GreenOffset, put_GreenOffset)
    GreenSlope = property(get_GreenSlope, put_GreenSlope)
    Name = property(get_Name, put_Name)
    RedDisable = property(get_RedDisable, put_RedDisable)
    RedOffset = property(get_RedOffset, put_RedOffset)
    RedSlope = property(get_RedSlope, put_RedSlope)
    Source = property(get_Source, put_Source)
class LuminanceToAlphaEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.ILuminanceToAlphaEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.LuminanceToAlphaEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.LuminanceToAlphaEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.LuminanceToAlphaEffect: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.ILuminanceToAlphaEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.ILuminanceToAlphaEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)
class Matrix5x4(Structure):
    M11: Single
    M12: Single
    M13: Single
    M14: Single
    M21: Single
    M22: Single
    M23: Single
    M24: Single
    M31: Single
    M32: Single
    M33: Single
    M34: Single
    M41: Single
    M42: Single
    M43: Single
    M44: Single
    M51: Single
    M52: Single
    M53: Single
    M54: Single
class MorphologyEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IMorphologyEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.MorphologyEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.MorphologyEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.MorphologyEffect: ...
    @winrt_mixinmethod
    def get_Mode(self: win32more.Microsoft.Graphics.Canvas.Effects.IMorphologyEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.MorphologyEffectMode: ...
    @winrt_mixinmethod
    def put_Mode(self: win32more.Microsoft.Graphics.Canvas.Effects.IMorphologyEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.MorphologyEffectMode) -> Void: ...
    @winrt_mixinmethod
    def get_Width(self: win32more.Microsoft.Graphics.Canvas.Effects.IMorphologyEffect) -> Int32: ...
    @winrt_mixinmethod
    def put_Width(self: win32more.Microsoft.Graphics.Canvas.Effects.IMorphologyEffect, value: Int32) -> Void: ...
    @winrt_mixinmethod
    def get_Height(self: win32more.Microsoft.Graphics.Canvas.Effects.IMorphologyEffect) -> Int32: ...
    @winrt_mixinmethod
    def put_Height(self: win32more.Microsoft.Graphics.Canvas.Effects.IMorphologyEffect, value: Int32) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IMorphologyEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IMorphologyEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Height = property(get_Height, put_Height)
    Mode = property(get_Mode, put_Mode)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)
    Width = property(get_Width, put_Width)
class MorphologyEffectMode(Enum, Int32):
    Erode = 0
    Dilate = 1
class _OpacityEffect_Meta_(ComPtr.__class__):
    pass
class OpacityEffect(ComPtr, metaclass=_OpacityEffect_Meta_):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IOpacityEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.OpacityEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.OpacityEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.OpacityEffect: ...
    @winrt_mixinmethod
    def get_Opacity(self: win32more.Microsoft.Graphics.Canvas.Effects.IOpacityEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Opacity(self: win32more.Microsoft.Graphics.Canvas.Effects.IOpacityEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IOpacityEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IOpacityEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    @winrt_classmethod
    def get_IsSupported(cls: win32more.Microsoft.Graphics.Canvas.Effects.IOpacityEffectStatics) -> Boolean: ...
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Name = property(get_Name, put_Name)
    Opacity = property(get_Opacity, put_Opacity)
    Source = property(get_Source, put_Source)
    _OpacityEffect_Meta_.IsSupported = property(get_IsSupported, None)
class OpacityMetadataEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IOpacityMetadataEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.OpacityMetadataEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.OpacityMetadataEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.OpacityMetadataEffect: ...
    @winrt_mixinmethod
    def get_OpaqueRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.IOpacityMetadataEffect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def put_OpaqueRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.IOpacityMetadataEffect, value: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IOpacityMetadataEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IOpacityMetadataEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Name = property(get_Name, put_Name)
    OpaqueRectangle = property(get_OpaqueRectangle, put_OpaqueRectangle)
    Source = property(get_Source, put_Source)
class PixelShaderEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.PixelShaderEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.PixelShaderEffect.Create(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def Create(cls: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffectFactory, shaderCode: PassArray[Byte]) -> win32more.Microsoft.Graphics.Canvas.Effects.PixelShaderEffect: ...
    @winrt_mixinmethod
    def get_Properties(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> win32more.Windows.Foundation.Collections.IMap[WinRT_String, IInspectable]: ...
    @winrt_mixinmethod
    def get_Source1(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def get_Source2(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def get_Source3(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def get_Source4(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def get_Source5(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def get_Source6(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def get_Source7(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def get_Source8(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source1(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def put_Source2(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def put_Source3(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def put_Source4(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def put_Source5(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def put_Source6(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def put_Source7(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def put_Source8(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_Source1Mapping(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.SamplerCoordinateMapping: ...
    @winrt_mixinmethod
    def get_Source2Mapping(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.SamplerCoordinateMapping: ...
    @winrt_mixinmethod
    def get_Source3Mapping(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.SamplerCoordinateMapping: ...
    @winrt_mixinmethod
    def get_Source4Mapping(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.SamplerCoordinateMapping: ...
    @winrt_mixinmethod
    def get_Source5Mapping(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.SamplerCoordinateMapping: ...
    @winrt_mixinmethod
    def get_Source6Mapping(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.SamplerCoordinateMapping: ...
    @winrt_mixinmethod
    def get_Source7Mapping(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.SamplerCoordinateMapping: ...
    @winrt_mixinmethod
    def get_Source8Mapping(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.SamplerCoordinateMapping: ...
    @winrt_mixinmethod
    def put_Source1Mapping(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.SamplerCoordinateMapping) -> Void: ...
    @winrt_mixinmethod
    def put_Source2Mapping(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.SamplerCoordinateMapping) -> Void: ...
    @winrt_mixinmethod
    def put_Source3Mapping(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.SamplerCoordinateMapping) -> Void: ...
    @winrt_mixinmethod
    def put_Source4Mapping(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.SamplerCoordinateMapping) -> Void: ...
    @winrt_mixinmethod
    def put_Source5Mapping(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.SamplerCoordinateMapping) -> Void: ...
    @winrt_mixinmethod
    def put_Source6Mapping(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.SamplerCoordinateMapping) -> Void: ...
    @winrt_mixinmethod
    def put_Source7Mapping(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.SamplerCoordinateMapping) -> Void: ...
    @winrt_mixinmethod
    def put_Source8Mapping(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.SamplerCoordinateMapping) -> Void: ...
    @winrt_mixinmethod
    def get_Source1BorderMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode: ...
    @winrt_mixinmethod
    def get_Source2BorderMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode: ...
    @winrt_mixinmethod
    def get_Source3BorderMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode: ...
    @winrt_mixinmethod
    def get_Source4BorderMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode: ...
    @winrt_mixinmethod
    def get_Source5BorderMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode: ...
    @winrt_mixinmethod
    def get_Source6BorderMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode: ...
    @winrt_mixinmethod
    def get_Source7BorderMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode: ...
    @winrt_mixinmethod
    def get_Source8BorderMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode: ...
    @winrt_mixinmethod
    def put_Source1BorderMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode) -> Void: ...
    @winrt_mixinmethod
    def put_Source2BorderMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode) -> Void: ...
    @winrt_mixinmethod
    def put_Source3BorderMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode) -> Void: ...
    @winrt_mixinmethod
    def put_Source4BorderMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode) -> Void: ...
    @winrt_mixinmethod
    def put_Source5BorderMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode) -> Void: ...
    @winrt_mixinmethod
    def put_Source6BorderMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode) -> Void: ...
    @winrt_mixinmethod
    def put_Source7BorderMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode) -> Void: ...
    @winrt_mixinmethod
    def put_Source8BorderMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode) -> Void: ...
    @winrt_mixinmethod
    def get_MaxSamplerOffset(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> Int32: ...
    @winrt_mixinmethod
    def put_MaxSamplerOffset(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, value: Int32) -> Void: ...
    @winrt_mixinmethod
    def get_Source1Interpolation(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_mixinmethod
    def get_Source2Interpolation(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_mixinmethod
    def get_Source3Interpolation(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_mixinmethod
    def get_Source4Interpolation(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_mixinmethod
    def get_Source5Interpolation(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_mixinmethod
    def get_Source6Interpolation(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_mixinmethod
    def get_Source7Interpolation(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_mixinmethod
    def get_Source8Interpolation(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_mixinmethod
    def put_Source1Interpolation(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_mixinmethod
    def put_Source2Interpolation(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_mixinmethod
    def put_Source3Interpolation(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_mixinmethod
    def put_Source4Interpolation(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_mixinmethod
    def put_Source5Interpolation(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_mixinmethod
    def put_Source6Interpolation(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_mixinmethod
    def put_Source7Interpolation(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_mixinmethod
    def put_Source8Interpolation(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_mixinmethod
    def IsSupported(self: win32more.Microsoft.Graphics.Canvas.Effects.IPixelShaderEffect, device: win32more.Microsoft.Graphics.Canvas.CanvasDevice) -> Boolean: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    MaxSamplerOffset = property(get_MaxSamplerOffset, put_MaxSamplerOffset)
    Name = property(get_Name, put_Name)
    Properties = property(get_Properties, None)
    Source1 = property(get_Source1, put_Source1)
    Source1BorderMode = property(get_Source1BorderMode, put_Source1BorderMode)
    Source1Interpolation = property(get_Source1Interpolation, put_Source1Interpolation)
    Source1Mapping = property(get_Source1Mapping, put_Source1Mapping)
    Source2 = property(get_Source2, put_Source2)
    Source2BorderMode = property(get_Source2BorderMode, put_Source2BorderMode)
    Source2Interpolation = property(get_Source2Interpolation, put_Source2Interpolation)
    Source2Mapping = property(get_Source2Mapping, put_Source2Mapping)
    Source3 = property(get_Source3, put_Source3)
    Source3BorderMode = property(get_Source3BorderMode, put_Source3BorderMode)
    Source3Interpolation = property(get_Source3Interpolation, put_Source3Interpolation)
    Source3Mapping = property(get_Source3Mapping, put_Source3Mapping)
    Source4 = property(get_Source4, put_Source4)
    Source4BorderMode = property(get_Source4BorderMode, put_Source4BorderMode)
    Source4Interpolation = property(get_Source4Interpolation, put_Source4Interpolation)
    Source4Mapping = property(get_Source4Mapping, put_Source4Mapping)
    Source5 = property(get_Source5, put_Source5)
    Source5BorderMode = property(get_Source5BorderMode, put_Source5BorderMode)
    Source5Interpolation = property(get_Source5Interpolation, put_Source5Interpolation)
    Source5Mapping = property(get_Source5Mapping, put_Source5Mapping)
    Source6 = property(get_Source6, put_Source6)
    Source6BorderMode = property(get_Source6BorderMode, put_Source6BorderMode)
    Source6Interpolation = property(get_Source6Interpolation, put_Source6Interpolation)
    Source6Mapping = property(get_Source6Mapping, put_Source6Mapping)
    Source7 = property(get_Source7, put_Source7)
    Source7BorderMode = property(get_Source7BorderMode, put_Source7BorderMode)
    Source7Interpolation = property(get_Source7Interpolation, put_Source7Interpolation)
    Source7Mapping = property(get_Source7Mapping, put_Source7Mapping)
    Source8 = property(get_Source8, put_Source8)
    Source8BorderMode = property(get_Source8BorderMode, put_Source8BorderMode)
    Source8Interpolation = property(get_Source8Interpolation, put_Source8Interpolation)
    Source8Mapping = property(get_Source8Mapping, put_Source8Mapping)
class PointDiffuseEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IPointDiffuseEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.PointDiffuseEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.PointDiffuseEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.PointDiffuseEffect: ...
    @winrt_mixinmethod
    def get_LightPosition(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointDiffuseEffect) -> win32more.Windows.Foundation.Numerics.Vector3: ...
    @winrt_mixinmethod
    def put_LightPosition(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointDiffuseEffect, value: win32more.Windows.Foundation.Numerics.Vector3) -> Void: ...
    @winrt_mixinmethod
    def get_DiffuseAmount(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointDiffuseEffect) -> Single: ...
    @winrt_mixinmethod
    def put_DiffuseAmount(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointDiffuseEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_HeightMapScale(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointDiffuseEffect) -> Single: ...
    @winrt_mixinmethod
    def put_HeightMapScale(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointDiffuseEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_LightColor(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointDiffuseEffect) -> win32more.Windows.UI.Color: ...
    @winrt_mixinmethod
    def put_LightColor(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointDiffuseEffect, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def get_HeightMapKernelSize(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointDiffuseEffect) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_mixinmethod
    def put_HeightMapKernelSize(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointDiffuseEffect, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_mixinmethod
    def get_HeightMapInterpolationMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointDiffuseEffect) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_mixinmethod
    def put_HeightMapInterpolationMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointDiffuseEffect, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_mixinmethod
    def get_LightColorHdr(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointDiffuseEffect) -> win32more.Windows.Foundation.Numerics.Vector4: ...
    @winrt_mixinmethod
    def put_LightColorHdr(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointDiffuseEffect, value: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointDiffuseEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointDiffuseEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    DiffuseAmount = property(get_DiffuseAmount, put_DiffuseAmount)
    HeightMapInterpolationMode = property(get_HeightMapInterpolationMode, put_HeightMapInterpolationMode)
    HeightMapKernelSize = property(get_HeightMapKernelSize, put_HeightMapKernelSize)
    HeightMapScale = property(get_HeightMapScale, put_HeightMapScale)
    LightColor = property(get_LightColor, put_LightColor)
    LightColorHdr = property(get_LightColorHdr, put_LightColorHdr)
    LightPosition = property(get_LightPosition, put_LightPosition)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)
class PointSpecularEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IPointSpecularEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.PointSpecularEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.PointSpecularEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.PointSpecularEffect: ...
    @winrt_mixinmethod
    def get_LightPosition(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointSpecularEffect) -> win32more.Windows.Foundation.Numerics.Vector3: ...
    @winrt_mixinmethod
    def put_LightPosition(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointSpecularEffect, value: win32more.Windows.Foundation.Numerics.Vector3) -> Void: ...
    @winrt_mixinmethod
    def get_SpecularExponent(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointSpecularEffect) -> Single: ...
    @winrt_mixinmethod
    def put_SpecularExponent(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointSpecularEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_SpecularAmount(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointSpecularEffect) -> Single: ...
    @winrt_mixinmethod
    def put_SpecularAmount(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointSpecularEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_HeightMapScale(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointSpecularEffect) -> Single: ...
    @winrt_mixinmethod
    def put_HeightMapScale(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointSpecularEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_LightColor(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointSpecularEffect) -> win32more.Windows.UI.Color: ...
    @winrt_mixinmethod
    def put_LightColor(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointSpecularEffect, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def get_HeightMapKernelSize(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointSpecularEffect) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_mixinmethod
    def put_HeightMapKernelSize(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointSpecularEffect, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_mixinmethod
    def get_HeightMapInterpolationMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointSpecularEffect) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_mixinmethod
    def put_HeightMapInterpolationMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointSpecularEffect, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_mixinmethod
    def get_LightColorHdr(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointSpecularEffect) -> win32more.Windows.Foundation.Numerics.Vector4: ...
    @winrt_mixinmethod
    def put_LightColorHdr(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointSpecularEffect, value: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointSpecularEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IPointSpecularEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    HeightMapInterpolationMode = property(get_HeightMapInterpolationMode, put_HeightMapInterpolationMode)
    HeightMapKernelSize = property(get_HeightMapKernelSize, put_HeightMapKernelSize)
    HeightMapScale = property(get_HeightMapScale, put_HeightMapScale)
    LightColor = property(get_LightColor, put_LightColor)
    LightColorHdr = property(get_LightColorHdr, put_LightColorHdr)
    LightPosition = property(get_LightPosition, put_LightPosition)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)
    SpecularAmount = property(get_SpecularAmount, put_SpecularAmount)
    SpecularExponent = property(get_SpecularExponent, put_SpecularExponent)
class PosterizeEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IPosterizeEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.PosterizeEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.PosterizeEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.PosterizeEffect: ...
    @winrt_mixinmethod
    def get_RedValueCount(self: win32more.Microsoft.Graphics.Canvas.Effects.IPosterizeEffect) -> Int32: ...
    @winrt_mixinmethod
    def put_RedValueCount(self: win32more.Microsoft.Graphics.Canvas.Effects.IPosterizeEffect, value: Int32) -> Void: ...
    @winrt_mixinmethod
    def get_GreenValueCount(self: win32more.Microsoft.Graphics.Canvas.Effects.IPosterizeEffect) -> Int32: ...
    @winrt_mixinmethod
    def put_GreenValueCount(self: win32more.Microsoft.Graphics.Canvas.Effects.IPosterizeEffect, value: Int32) -> Void: ...
    @winrt_mixinmethod
    def get_BlueValueCount(self: win32more.Microsoft.Graphics.Canvas.Effects.IPosterizeEffect) -> Int32: ...
    @winrt_mixinmethod
    def put_BlueValueCount(self: win32more.Microsoft.Graphics.Canvas.Effects.IPosterizeEffect, value: Int32) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IPosterizeEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IPosterizeEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BlueValueCount = property(get_BlueValueCount, put_BlueValueCount)
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    GreenValueCount = property(get_GreenValueCount, put_GreenValueCount)
    Name = property(get_Name, put_Name)
    RedValueCount = property(get_RedValueCount, put_RedValueCount)
    Source = property(get_Source, put_Source)
class PremultiplyEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IPremultiplyEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.PremultiplyEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.PremultiplyEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.PremultiplyEffect: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IPremultiplyEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IPremultiplyEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)
class RgbToHueEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IRgbToHueEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.RgbToHueEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.RgbToHueEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.RgbToHueEffect: ...
    @winrt_mixinmethod
    def get_OutputColorSpace(self: win32more.Microsoft.Graphics.Canvas.Effects.IRgbToHueEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectHueColorSpace: ...
    @winrt_mixinmethod
    def put_OutputColorSpace(self: win32more.Microsoft.Graphics.Canvas.Effects.IRgbToHueEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectHueColorSpace) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IRgbToHueEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IRgbToHueEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Name = property(get_Name, put_Name)
    OutputColorSpace = property(get_OutputColorSpace, put_OutputColorSpace)
    Source = property(get_Source, put_Source)
class SamplerCoordinateMapping(Enum, Int32):
    Unknown = 0
    OneToOne = 1
    Offset = 2
class SaturationEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.ISaturationEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.SaturationEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.SaturationEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.SaturationEffect: ...
    @winrt_mixinmethod
    def get_Saturation(self: win32more.Microsoft.Graphics.Canvas.Effects.ISaturationEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Saturation(self: win32more.Microsoft.Graphics.Canvas.Effects.ISaturationEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.ISaturationEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.ISaturationEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Name = property(get_Name, put_Name)
    Saturation = property(get_Saturation, put_Saturation)
    Source = property(get_Source, put_Source)
class ScaleEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IScaleEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.ScaleEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.ScaleEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.ScaleEffect: ...
    @winrt_mixinmethod
    def get_Scale(self: win32more.Microsoft.Graphics.Canvas.Effects.IScaleEffect) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_mixinmethod
    def put_Scale(self: win32more.Microsoft.Graphics.Canvas.Effects.IScaleEffect, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_mixinmethod
    def get_CenterPoint(self: win32more.Microsoft.Graphics.Canvas.Effects.IScaleEffect) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_mixinmethod
    def put_CenterPoint(self: win32more.Microsoft.Graphics.Canvas.Effects.IScaleEffect, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_mixinmethod
    def get_InterpolationMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IScaleEffect) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_mixinmethod
    def put_InterpolationMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IScaleEffect, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_mixinmethod
    def get_BorderMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IScaleEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode: ...
    @winrt_mixinmethod
    def put_BorderMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IScaleEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode) -> Void: ...
    @winrt_mixinmethod
    def get_Sharpness(self: win32more.Microsoft.Graphics.Canvas.Effects.IScaleEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Sharpness(self: win32more.Microsoft.Graphics.Canvas.Effects.IScaleEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IScaleEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IScaleEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BorderMode = property(get_BorderMode, put_BorderMode)
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    CenterPoint = property(get_CenterPoint, put_CenterPoint)
    InterpolationMode = property(get_InterpolationMode, put_InterpolationMode)
    Name = property(get_Name, put_Name)
    Scale = property(get_Scale, put_Scale)
    Sharpness = property(get_Sharpness, put_Sharpness)
    Source = property(get_Source, put_Source)
class SepiaEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.ISepiaEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.SepiaEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.SepiaEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.SepiaEffect: ...
    @winrt_mixinmethod
    def get_Intensity(self: win32more.Microsoft.Graphics.Canvas.Effects.ISepiaEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Intensity(self: win32more.Microsoft.Graphics.Canvas.Effects.ISepiaEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_AlphaMode(self: win32more.Microsoft.Graphics.Canvas.Effects.ISepiaEffect) -> win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode: ...
    @winrt_mixinmethod
    def put_AlphaMode(self: win32more.Microsoft.Graphics.Canvas.Effects.ISepiaEffect, value: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.ISepiaEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.ISepiaEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    AlphaMode = property(get_AlphaMode, put_AlphaMode)
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Intensity = property(get_Intensity, put_Intensity)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)
class ShadowEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IShadowEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.ShadowEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.ShadowEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.ShadowEffect: ...
    @winrt_mixinmethod
    def get_BlurAmount(self: win32more.Microsoft.Graphics.Canvas.Effects.IShadowEffect) -> Single: ...
    @winrt_mixinmethod
    def put_BlurAmount(self: win32more.Microsoft.Graphics.Canvas.Effects.IShadowEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_ShadowColor(self: win32more.Microsoft.Graphics.Canvas.Effects.IShadowEffect) -> win32more.Windows.UI.Color: ...
    @winrt_mixinmethod
    def put_ShadowColor(self: win32more.Microsoft.Graphics.Canvas.Effects.IShadowEffect, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def get_Optimization(self: win32more.Microsoft.Graphics.Canvas.Effects.IShadowEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectOptimization: ...
    @winrt_mixinmethod
    def put_Optimization(self: win32more.Microsoft.Graphics.Canvas.Effects.IShadowEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectOptimization) -> Void: ...
    @winrt_mixinmethod
    def get_ShadowColorHdr(self: win32more.Microsoft.Graphics.Canvas.Effects.IShadowEffect) -> win32more.Windows.Foundation.Numerics.Vector4: ...
    @winrt_mixinmethod
    def put_ShadowColorHdr(self: win32more.Microsoft.Graphics.Canvas.Effects.IShadowEffect, value: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IShadowEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IShadowEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BlurAmount = property(get_BlurAmount, put_BlurAmount)
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Name = property(get_Name, put_Name)
    Optimization = property(get_Optimization, put_Optimization)
    ShadowColor = property(get_ShadowColor, put_ShadowColor)
    ShadowColorHdr = property(get_ShadowColorHdr, put_ShadowColorHdr)
    Source = property(get_Source, put_Source)
class SharpenEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.ISharpenEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.SharpenEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.SharpenEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.SharpenEffect: ...
    @winrt_mixinmethod
    def get_Amount(self: win32more.Microsoft.Graphics.Canvas.Effects.ISharpenEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Amount(self: win32more.Microsoft.Graphics.Canvas.Effects.ISharpenEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Threshold(self: win32more.Microsoft.Graphics.Canvas.Effects.ISharpenEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Threshold(self: win32more.Microsoft.Graphics.Canvas.Effects.ISharpenEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.ISharpenEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.ISharpenEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    Amount = property(get_Amount, put_Amount)
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)
    Threshold = property(get_Threshold, put_Threshold)
class SpotDiffuseEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.ISpotDiffuseEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.SpotDiffuseEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.SpotDiffuseEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.SpotDiffuseEffect: ...
    @winrt_mixinmethod
    def get_LightPosition(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotDiffuseEffect) -> win32more.Windows.Foundation.Numerics.Vector3: ...
    @winrt_mixinmethod
    def put_LightPosition(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotDiffuseEffect, value: win32more.Windows.Foundation.Numerics.Vector3) -> Void: ...
    @winrt_mixinmethod
    def get_LightTarget(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotDiffuseEffect) -> win32more.Windows.Foundation.Numerics.Vector3: ...
    @winrt_mixinmethod
    def put_LightTarget(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotDiffuseEffect, value: win32more.Windows.Foundation.Numerics.Vector3) -> Void: ...
    @winrt_mixinmethod
    def get_Focus(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotDiffuseEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Focus(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotDiffuseEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_LimitingConeAngle(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotDiffuseEffect) -> Single: ...
    @winrt_mixinmethod
    def put_LimitingConeAngle(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotDiffuseEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_DiffuseAmount(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotDiffuseEffect) -> Single: ...
    @winrt_mixinmethod
    def put_DiffuseAmount(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotDiffuseEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_HeightMapScale(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotDiffuseEffect) -> Single: ...
    @winrt_mixinmethod
    def put_HeightMapScale(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotDiffuseEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_LightColor(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotDiffuseEffect) -> win32more.Windows.UI.Color: ...
    @winrt_mixinmethod
    def put_LightColor(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotDiffuseEffect, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def get_HeightMapKernelSize(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotDiffuseEffect) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_mixinmethod
    def put_HeightMapKernelSize(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotDiffuseEffect, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_mixinmethod
    def get_HeightMapInterpolationMode(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotDiffuseEffect) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_mixinmethod
    def put_HeightMapInterpolationMode(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotDiffuseEffect, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_mixinmethod
    def get_LightColorHdr(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotDiffuseEffect) -> win32more.Windows.Foundation.Numerics.Vector4: ...
    @winrt_mixinmethod
    def put_LightColorHdr(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotDiffuseEffect, value: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotDiffuseEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotDiffuseEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    DiffuseAmount = property(get_DiffuseAmount, put_DiffuseAmount)
    Focus = property(get_Focus, put_Focus)
    HeightMapInterpolationMode = property(get_HeightMapInterpolationMode, put_HeightMapInterpolationMode)
    HeightMapKernelSize = property(get_HeightMapKernelSize, put_HeightMapKernelSize)
    HeightMapScale = property(get_HeightMapScale, put_HeightMapScale)
    LightColor = property(get_LightColor, put_LightColor)
    LightColorHdr = property(get_LightColorHdr, put_LightColorHdr)
    LightPosition = property(get_LightPosition, put_LightPosition)
    LightTarget = property(get_LightTarget, put_LightTarget)
    LimitingConeAngle = property(get_LimitingConeAngle, put_LimitingConeAngle)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)
class SpotSpecularEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.ISpotSpecularEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.SpotSpecularEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.SpotSpecularEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.SpotSpecularEffect: ...
    @winrt_mixinmethod
    def get_LightPosition(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotSpecularEffect) -> win32more.Windows.Foundation.Numerics.Vector3: ...
    @winrt_mixinmethod
    def put_LightPosition(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotSpecularEffect, value: win32more.Windows.Foundation.Numerics.Vector3) -> Void: ...
    @winrt_mixinmethod
    def get_LightTarget(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotSpecularEffect) -> win32more.Windows.Foundation.Numerics.Vector3: ...
    @winrt_mixinmethod
    def put_LightTarget(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotSpecularEffect, value: win32more.Windows.Foundation.Numerics.Vector3) -> Void: ...
    @winrt_mixinmethod
    def get_Focus(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotSpecularEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Focus(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotSpecularEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_LimitingConeAngle(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotSpecularEffect) -> Single: ...
    @winrt_mixinmethod
    def put_LimitingConeAngle(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotSpecularEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_SpecularExponent(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotSpecularEffect) -> Single: ...
    @winrt_mixinmethod
    def put_SpecularExponent(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotSpecularEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_SpecularAmount(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotSpecularEffect) -> Single: ...
    @winrt_mixinmethod
    def put_SpecularAmount(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotSpecularEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_HeightMapScale(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotSpecularEffect) -> Single: ...
    @winrt_mixinmethod
    def put_HeightMapScale(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotSpecularEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_LightColor(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotSpecularEffect) -> win32more.Windows.UI.Color: ...
    @winrt_mixinmethod
    def put_LightColor(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotSpecularEffect, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def get_HeightMapKernelSize(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotSpecularEffect) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_mixinmethod
    def put_HeightMapKernelSize(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotSpecularEffect, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_mixinmethod
    def get_HeightMapInterpolationMode(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotSpecularEffect) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_mixinmethod
    def put_HeightMapInterpolationMode(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotSpecularEffect, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_mixinmethod
    def get_LightColorHdr(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotSpecularEffect) -> win32more.Windows.Foundation.Numerics.Vector4: ...
    @winrt_mixinmethod
    def put_LightColorHdr(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotSpecularEffect, value: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotSpecularEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.ISpotSpecularEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Focus = property(get_Focus, put_Focus)
    HeightMapInterpolationMode = property(get_HeightMapInterpolationMode, put_HeightMapInterpolationMode)
    HeightMapKernelSize = property(get_HeightMapKernelSize, put_HeightMapKernelSize)
    HeightMapScale = property(get_HeightMapScale, put_HeightMapScale)
    LightColor = property(get_LightColor, put_LightColor)
    LightColorHdr = property(get_LightColorHdr, put_LightColorHdr)
    LightPosition = property(get_LightPosition, put_LightPosition)
    LightTarget = property(get_LightTarget, put_LightTarget)
    LimitingConeAngle = property(get_LimitingConeAngle, put_LimitingConeAngle)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)
    SpecularAmount = property(get_SpecularAmount, put_SpecularAmount)
    SpecularExponent = property(get_SpecularExponent, put_SpecularExponent)
class StraightenEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IStraightenEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.StraightenEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.StraightenEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.StraightenEffect: ...
    @winrt_mixinmethod
    def get_Angle(self: win32more.Microsoft.Graphics.Canvas.Effects.IStraightenEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Angle(self: win32more.Microsoft.Graphics.Canvas.Effects.IStraightenEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_MaintainSize(self: win32more.Microsoft.Graphics.Canvas.Effects.IStraightenEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_MaintainSize(self: win32more.Microsoft.Graphics.Canvas.Effects.IStraightenEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_InterpolationMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IStraightenEffect) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_mixinmethod
    def put_InterpolationMode(self: win32more.Microsoft.Graphics.Canvas.Effects.IStraightenEffect, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IStraightenEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IStraightenEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    Angle = property(get_Angle, put_Angle)
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    InterpolationMode = property(get_InterpolationMode, put_InterpolationMode)
    MaintainSize = property(get_MaintainSize, put_MaintainSize)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)
class TableTransfer3DEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.ITableTransfer3DEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.TableTransfer3DEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.TableTransfer3DEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.TableTransfer3DEffect: ...
    @winrt_mixinmethod
    def get_Table(self: win32more.Microsoft.Graphics.Canvas.Effects.ITableTransfer3DEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectTransferTable3D: ...
    @winrt_mixinmethod
    def put_Table(self: win32more.Microsoft.Graphics.Canvas.Effects.ITableTransfer3DEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectTransferTable3D) -> Void: ...
    @winrt_mixinmethod
    def get_AlphaMode(self: win32more.Microsoft.Graphics.Canvas.Effects.ITableTransfer3DEffect) -> win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode: ...
    @winrt_mixinmethod
    def put_AlphaMode(self: win32more.Microsoft.Graphics.Canvas.Effects.ITableTransfer3DEffect, value: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.ITableTransfer3DEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.ITableTransfer3DEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    AlphaMode = property(get_AlphaMode, put_AlphaMode)
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)
    Table = property(get_Table, put_Table)
class TableTransferEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.ITableTransferEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.TableTransferEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.TableTransferEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.TableTransferEffect: ...
    @winrt_mixinmethod
    def get_RedTable(self: win32more.Microsoft.Graphics.Canvas.Effects.ITableTransferEffect) -> ReceiveArray[Single]: ...
    @winrt_mixinmethod
    def put_RedTable(self: win32more.Microsoft.Graphics.Canvas.Effects.ITableTransferEffect, valueElements: PassArray[Single]) -> Void: ...
    @winrt_mixinmethod
    def get_RedDisable(self: win32more.Microsoft.Graphics.Canvas.Effects.ITableTransferEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_RedDisable(self: win32more.Microsoft.Graphics.Canvas.Effects.ITableTransferEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_GreenTable(self: win32more.Microsoft.Graphics.Canvas.Effects.ITableTransferEffect) -> ReceiveArray[Single]: ...
    @winrt_mixinmethod
    def put_GreenTable(self: win32more.Microsoft.Graphics.Canvas.Effects.ITableTransferEffect, valueElements: PassArray[Single]) -> Void: ...
    @winrt_mixinmethod
    def get_GreenDisable(self: win32more.Microsoft.Graphics.Canvas.Effects.ITableTransferEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_GreenDisable(self: win32more.Microsoft.Graphics.Canvas.Effects.ITableTransferEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BlueTable(self: win32more.Microsoft.Graphics.Canvas.Effects.ITableTransferEffect) -> ReceiveArray[Single]: ...
    @winrt_mixinmethod
    def put_BlueTable(self: win32more.Microsoft.Graphics.Canvas.Effects.ITableTransferEffect, valueElements: PassArray[Single]) -> Void: ...
    @winrt_mixinmethod
    def get_BlueDisable(self: win32more.Microsoft.Graphics.Canvas.Effects.ITableTransferEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_BlueDisable(self: win32more.Microsoft.Graphics.Canvas.Effects.ITableTransferEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_AlphaTable(self: win32more.Microsoft.Graphics.Canvas.Effects.ITableTransferEffect) -> ReceiveArray[Single]: ...
    @winrt_mixinmethod
    def put_AlphaTable(self: win32more.Microsoft.Graphics.Canvas.Effects.ITableTransferEffect, valueElements: PassArray[Single]) -> Void: ...
    @winrt_mixinmethod
    def get_AlphaDisable(self: win32more.Microsoft.Graphics.Canvas.Effects.ITableTransferEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_AlphaDisable(self: win32more.Microsoft.Graphics.Canvas.Effects.ITableTransferEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_ClampOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ITableTransferEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_ClampOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ITableTransferEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.ITableTransferEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.ITableTransferEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    AlphaDisable = property(get_AlphaDisable, put_AlphaDisable)
    AlphaTable = property(get_AlphaTable, put_AlphaTable)
    BlueDisable = property(get_BlueDisable, put_BlueDisable)
    BlueTable = property(get_BlueTable, put_BlueTable)
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    ClampOutput = property(get_ClampOutput, put_ClampOutput)
    GreenDisable = property(get_GreenDisable, put_GreenDisable)
    GreenTable = property(get_GreenTable, put_GreenTable)
    Name = property(get_Name, put_Name)
    RedDisable = property(get_RedDisable, put_RedDisable)
    RedTable = property(get_RedTable, put_RedTable)
    Source = property(get_Source, put_Source)
class TemperatureAndTintEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.ITemperatureAndTintEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.TemperatureAndTintEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.TemperatureAndTintEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.TemperatureAndTintEffect: ...
    @winrt_mixinmethod
    def get_Temperature(self: win32more.Microsoft.Graphics.Canvas.Effects.ITemperatureAndTintEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Temperature(self: win32more.Microsoft.Graphics.Canvas.Effects.ITemperatureAndTintEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Tint(self: win32more.Microsoft.Graphics.Canvas.Effects.ITemperatureAndTintEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Tint(self: win32more.Microsoft.Graphics.Canvas.Effects.ITemperatureAndTintEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.ITemperatureAndTintEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.ITemperatureAndTintEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)
    Temperature = property(get_Temperature, put_Temperature)
    Tint = property(get_Tint, put_Tint)
class TileEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.ITileEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.TileEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.TileEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.TileEffect: ...
    @winrt_mixinmethod
    def get_SourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ITileEffect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def put_SourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ITileEffect, value: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.ITileEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.ITileEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)
    SourceRectangle = property(get_SourceRectangle, put_SourceRectangle)
class _TintEffect_Meta_(ComPtr.__class__):
    pass
class TintEffect(ComPtr, metaclass=_TintEffect_Meta_):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.ITintEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.TintEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.TintEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.TintEffect: ...
    @winrt_mixinmethod
    def get_Color(self: win32more.Microsoft.Graphics.Canvas.Effects.ITintEffect) -> win32more.Windows.UI.Color: ...
    @winrt_mixinmethod
    def put_Color(self: win32more.Microsoft.Graphics.Canvas.Effects.ITintEffect, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def get_ClampOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ITintEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_ClampOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ITintEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_ColorHdr(self: win32more.Microsoft.Graphics.Canvas.Effects.ITintEffect) -> win32more.Windows.Foundation.Numerics.Vector4: ...
    @winrt_mixinmethod
    def put_ColorHdr(self: win32more.Microsoft.Graphics.Canvas.Effects.ITintEffect, value: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.ITintEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.ITintEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    @winrt_classmethod
    def get_IsSupported(cls: win32more.Microsoft.Graphics.Canvas.Effects.ITintEffectStatics) -> Boolean: ...
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    ClampOutput = property(get_ClampOutput, put_ClampOutput)
    Color = property(get_Color, put_Color)
    ColorHdr = property(get_ColorHdr, put_ColorHdr)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)
    _TintEffect_Meta_.IsSupported = property(get_IsSupported, None)
class Transform2DEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.ITransform2DEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.Transform2DEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.Transform2DEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.Transform2DEffect: ...
    @winrt_mixinmethod
    def get_InterpolationMode(self: win32more.Microsoft.Graphics.Canvas.Effects.ITransform2DEffect) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_mixinmethod
    def put_InterpolationMode(self: win32more.Microsoft.Graphics.Canvas.Effects.ITransform2DEffect, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_mixinmethod
    def get_BorderMode(self: win32more.Microsoft.Graphics.Canvas.Effects.ITransform2DEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode: ...
    @winrt_mixinmethod
    def put_BorderMode(self: win32more.Microsoft.Graphics.Canvas.Effects.ITransform2DEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode) -> Void: ...
    @winrt_mixinmethod
    def get_TransformMatrix(self: win32more.Microsoft.Graphics.Canvas.Effects.ITransform2DEffect) -> win32more.Windows.Foundation.Numerics.Matrix3x2: ...
    @winrt_mixinmethod
    def put_TransformMatrix(self: win32more.Microsoft.Graphics.Canvas.Effects.ITransform2DEffect, value: win32more.Windows.Foundation.Numerics.Matrix3x2) -> Void: ...
    @winrt_mixinmethod
    def get_Sharpness(self: win32more.Microsoft.Graphics.Canvas.Effects.ITransform2DEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Sharpness(self: win32more.Microsoft.Graphics.Canvas.Effects.ITransform2DEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.ITransform2DEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.ITransform2DEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BorderMode = property(get_BorderMode, put_BorderMode)
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    InterpolationMode = property(get_InterpolationMode, put_InterpolationMode)
    Name = property(get_Name, put_Name)
    Sharpness = property(get_Sharpness, put_Sharpness)
    Source = property(get_Source, put_Source)
    TransformMatrix = property(get_TransformMatrix, put_TransformMatrix)
class Transform3DEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.ITransform3DEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.Transform3DEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.Transform3DEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.Transform3DEffect: ...
    @winrt_mixinmethod
    def get_InterpolationMode(self: win32more.Microsoft.Graphics.Canvas.Effects.ITransform3DEffect) -> win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation: ...
    @winrt_mixinmethod
    def put_InterpolationMode(self: win32more.Microsoft.Graphics.Canvas.Effects.ITransform3DEffect, value: win32more.Microsoft.Graphics.Canvas.CanvasImageInterpolation) -> Void: ...
    @winrt_mixinmethod
    def get_BorderMode(self: win32more.Microsoft.Graphics.Canvas.Effects.ITransform3DEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode: ...
    @winrt_mixinmethod
    def put_BorderMode(self: win32more.Microsoft.Graphics.Canvas.Effects.ITransform3DEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.EffectBorderMode) -> Void: ...
    @winrt_mixinmethod
    def get_TransformMatrix(self: win32more.Microsoft.Graphics.Canvas.Effects.ITransform3DEffect) -> win32more.Windows.Foundation.Numerics.Matrix4x4: ...
    @winrt_mixinmethod
    def put_TransformMatrix(self: win32more.Microsoft.Graphics.Canvas.Effects.ITransform3DEffect, value: win32more.Windows.Foundation.Numerics.Matrix4x4) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.ITransform3DEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.ITransform3DEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BorderMode = property(get_BorderMode, put_BorderMode)
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    InterpolationMode = property(get_InterpolationMode, put_InterpolationMode)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)
    TransformMatrix = property(get_TransformMatrix, put_TransformMatrix)
class TurbulenceEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.ITurbulenceEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.TurbulenceEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.TurbulenceEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.TurbulenceEffect: ...
    @winrt_mixinmethod
    def get_Offset(self: win32more.Microsoft.Graphics.Canvas.Effects.ITurbulenceEffect) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_mixinmethod
    def put_Offset(self: win32more.Microsoft.Graphics.Canvas.Effects.ITurbulenceEffect, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_mixinmethod
    def get_Size(self: win32more.Microsoft.Graphics.Canvas.Effects.ITurbulenceEffect) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_mixinmethod
    def put_Size(self: win32more.Microsoft.Graphics.Canvas.Effects.ITurbulenceEffect, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_mixinmethod
    def get_Frequency(self: win32more.Microsoft.Graphics.Canvas.Effects.ITurbulenceEffect) -> win32more.Windows.Foundation.Numerics.Vector2: ...
    @winrt_mixinmethod
    def put_Frequency(self: win32more.Microsoft.Graphics.Canvas.Effects.ITurbulenceEffect, value: win32more.Windows.Foundation.Numerics.Vector2) -> Void: ...
    @winrt_mixinmethod
    def get_Octaves(self: win32more.Microsoft.Graphics.Canvas.Effects.ITurbulenceEffect) -> Int32: ...
    @winrt_mixinmethod
    def put_Octaves(self: win32more.Microsoft.Graphics.Canvas.Effects.ITurbulenceEffect, value: Int32) -> Void: ...
    @winrt_mixinmethod
    def get_Seed(self: win32more.Microsoft.Graphics.Canvas.Effects.ITurbulenceEffect) -> Int32: ...
    @winrt_mixinmethod
    def put_Seed(self: win32more.Microsoft.Graphics.Canvas.Effects.ITurbulenceEffect, value: Int32) -> Void: ...
    @winrt_mixinmethod
    def get_Noise(self: win32more.Microsoft.Graphics.Canvas.Effects.ITurbulenceEffect) -> win32more.Microsoft.Graphics.Canvas.Effects.TurbulenceEffectNoise: ...
    @winrt_mixinmethod
    def put_Noise(self: win32more.Microsoft.Graphics.Canvas.Effects.ITurbulenceEffect, value: win32more.Microsoft.Graphics.Canvas.Effects.TurbulenceEffectNoise) -> Void: ...
    @winrt_mixinmethod
    def get_Tileable(self: win32more.Microsoft.Graphics.Canvas.Effects.ITurbulenceEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_Tileable(self: win32more.Microsoft.Graphics.Canvas.Effects.ITurbulenceEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Frequency = property(get_Frequency, put_Frequency)
    Name = property(get_Name, put_Name)
    Noise = property(get_Noise, put_Noise)
    Octaves = property(get_Octaves, put_Octaves)
    Offset = property(get_Offset, put_Offset)
    Seed = property(get_Seed, put_Seed)
    Size = property(get_Size, put_Size)
    Tileable = property(get_Tileable, put_Tileable)
class TurbulenceEffectNoise(Enum, Int32):
    FractalSum = 0
    Turbulence = 1
class UnPremultiplyEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IUnPremultiplyEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.UnPremultiplyEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.UnPremultiplyEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.UnPremultiplyEffect: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IUnPremultiplyEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IUnPremultiplyEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)
class VignetteEffect(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Effects.IVignetteEffect
    _classid_ = 'Microsoft.Graphics.Canvas.Effects.VignetteEffect'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Effects.VignetteEffect.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.Effects.VignetteEffect: ...
    @winrt_mixinmethod
    def get_Color(self: win32more.Microsoft.Graphics.Canvas.Effects.IVignetteEffect) -> win32more.Windows.UI.Color: ...
    @winrt_mixinmethod
    def put_Color(self: win32more.Microsoft.Graphics.Canvas.Effects.IVignetteEffect, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def get_Amount(self: win32more.Microsoft.Graphics.Canvas.Effects.IVignetteEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Amount(self: win32more.Microsoft.Graphics.Canvas.Effects.IVignetteEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Curve(self: win32more.Microsoft.Graphics.Canvas.Effects.IVignetteEffect) -> Single: ...
    @winrt_mixinmethod
    def put_Curve(self: win32more.Microsoft.Graphics.Canvas.Effects.IVignetteEffect, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_ColorHdr(self: win32more.Microsoft.Graphics.Canvas.Effects.IVignetteEffect) -> win32more.Windows.Foundation.Numerics.Vector4: ...
    @winrt_mixinmethod
    def put_ColorHdr(self: win32more.Microsoft.Graphics.Canvas.Effects.IVignetteEffect, value: win32more.Windows.Foundation.Numerics.Vector4) -> Void: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IVignetteEffect) -> win32more.Windows.Graphics.Effects.IGraphicsEffectSource: ...
    @winrt_mixinmethod
    def put_Source(self: win32more.Microsoft.Graphics.Canvas.Effects.IVignetteEffect, source: win32more.Windows.Graphics.Effects.IGraphicsEffectSource) -> Void: ...
    @winrt_mixinmethod
    def get_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> Boolean: ...
    @winrt_mixinmethod
    def put_CacheOutput(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect) -> win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]: ...
    @winrt_mixinmethod
    def put_BufferPrecision(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, value: win32more.Windows.Foundation.IReference[win32more.Microsoft.Graphics.Canvas.CanvasBufferPrecision]) -> Void: ...
    @winrt_mixinmethod
    def InvalidateSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, sourceIndex: UInt32, invalidRectangle: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetInvalidRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangle(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffect: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, sourceIndex: UInt32, sourceBounds: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetRequiredSourceRectangles(self: win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, outputRectangle: win32more.Windows.Foundation.Rect, sourceEffects: PassArray[win32more.Microsoft.Graphics.Canvas.Effects.ICanvasEffect], sourceIndices: PassArray[UInt32], sourceBounds: PassArray[win32more.Windows.Foundation.Rect]) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Name(self: win32more.Windows.Graphics.Effects.IGraphicsEffect, name: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetBounds(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def GetBoundsWithTransform(self: win32more.Microsoft.Graphics.Canvas.ICanvasImage, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, transform: win32more.Windows.Foundation.Numerics.Matrix3x2) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    Amount = property(get_Amount, put_Amount)
    BufferPrecision = property(get_BufferPrecision, put_BufferPrecision)
    CacheOutput = property(get_CacheOutput, put_CacheOutput)
    Color = property(get_Color, put_Color)
    ColorHdr = property(get_ColorHdr, put_ColorHdr)
    Curve = property(get_Curve, put_Curve)
    Name = property(get_Name, put_Name)
    Source = property(get_Source, put_Source)


make_ready(__name__)
