from __future__ import annotations
from win32more.winrt.prelude import *
import win32more.Microsoft.Graphics.Canvas
import win32more.Microsoft.Graphics.Canvas.Geometry
import win32more.Microsoft.Graphics.Canvas.Svg
import win32more.Windows.Foundation
import win32more.Windows.Foundation.Numerics
import win32more.Windows.Storage.Streams
import win32more.Windows.UI
class CanvasSvgAspectAlignment(Enum, Int32):
    None_ = 0
    XMinYMin = 1
    XMidYMin = 2
    XMaxYMin = 3
    XMinYMid = 4
    XMidYMid = 5
    XMaxYMid = 6
    XMinYMax = 7
    XMidYMax = 8
    XMaxYMax = 9
class CanvasSvgAspectScaling(Enum, Int32):
    Meet = 0
    Slice = 1
class CanvasSvgDisplay(Enum, Int32):
    Inline = 0
    None_ = 1
class CanvasSvgDocument(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgDocument
    _classid_ = 'Microsoft.Graphics.Canvas.Svg.CanvasSvgDocument'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgDocument.CreateEmpty(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def CreateEmpty(cls: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgDocumentFactory, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgDocument: ...
    @winrt_mixinmethod
    def get_Device(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgDocument) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    @winrt_mixinmethod
    def GetXml(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgDocument) -> WinRT_String: ...
    @winrt_mixinmethod
    def SaveAsync(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgDocument, stream: win32more.Windows.Storage.Streams.IRandomAccessStream) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_mixinmethod
    def put_Root(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgDocument, value: win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgNamedElement) -> Void: ...
    @winrt_mixinmethod
    def get_Root(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgDocument) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgNamedElement: ...
    @winrt_mixinmethod
    def FindElementById(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgDocument, id: WinRT_String) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgNamedElement: ...
    @winrt_mixinmethod
    def CreatePaintAttributeWithDefaults(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgDocument) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgPaintAttribute: ...
    @winrt_mixinmethod
    def CreatePaintAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgDocument, paintType: win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgPaintType, color: win32more.Windows.UI.Color, id: WinRT_String) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgPaintAttribute: ...
    @winrt_mixinmethod
    def CreatePathAttributeWithDefaults(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgDocument) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgPathAttribute: ...
    @winrt_mixinmethod
    def CreatePathAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgDocument, segmentData: PassArray[Single], commands: PassArray[win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgPathCommand]) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgPathAttribute: ...
    @winrt_mixinmethod
    def CreatePointsAttributeWithDefaults(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgDocument) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgPointsAttribute: ...
    @winrt_mixinmethod
    def CreatePointsAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgDocument, points: PassArray[win32more.Windows.Foundation.Numerics.Vector2]) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgPointsAttribute: ...
    @winrt_mixinmethod
    def CreateStrokeDashArrayAttributeWithDefaults(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgDocument) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgStrokeDashArrayAttribute: ...
    @winrt_mixinmethod
    def CreateStrokeDashArrayAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgDocument, dashValues: PassArray[Single], unitValues: PassArray[win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgLengthUnits]) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgStrokeDashArrayAttribute: ...
    @winrt_mixinmethod
    def LoadElementFromXml(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgDocument, xmlString: WinRT_String) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgNamedElement: ...
    @winrt_mixinmethod
    def LoadElementAsync(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgDocument, stream: win32more.Windows.Storage.Streams.IRandomAccessStream) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgNamedElement]: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    @winrt_classmethod
    def LoadFromXml(cls: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgDocumentStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, xmlString: WinRT_String) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgDocument: ...
    @winrt_classmethod
    def LoadAsync(cls: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgDocumentStatics, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, stream: win32more.Windows.Storage.Streams.IRandomAccessStream) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgDocument]: ...
    @winrt_classmethod
    def IsSupported(cls: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgDocumentStatics, device: win32more.Microsoft.Graphics.Canvas.CanvasDevice) -> Boolean: ...
    Device = property(get_Device, None)
    Root = property(get_Root, put_Root)
class CanvasSvgLengthUnits(Enum, Int32):
    Number = 0
    Percentage = 1
class CanvasSvgNamedElement(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement
    _classid_ = 'Microsoft.Graphics.Canvas.Svg.CanvasSvgNamedElement'
    @winrt_mixinmethod
    def AppendChild(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, child: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgElement) -> Void: ...
    @winrt_mixinmethod
    def CreateAndAppendNamedChildElement(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, childName: WinRT_String) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgNamedElement: ...
    @winrt_mixinmethod
    def CreateAndAppendTextChildElement(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, textContent: WinRT_String) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgTextElement: ...
    @winrt_mixinmethod
    def get_FirstChild(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement) -> win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgElement: ...
    @winrt_mixinmethod
    def get_LastChild(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement) -> win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgElement: ...
    @winrt_mixinmethod
    def GetPreviousSibling(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, child: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgElement) -> win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgElement: ...
    @winrt_mixinmethod
    def GetNextSibling(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, child: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgElement) -> win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgElement: ...
    @winrt_mixinmethod
    def get_SpecifiedAttributes(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement) -> ReceiveArray[WinRT_String]: ...
    @winrt_mixinmethod
    def get_Tag(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_HasChildren(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement) -> Boolean: ...
    @winrt_mixinmethod
    def InsertChildBefore(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, child: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgElement, referenceChild: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgElement) -> Void: ...
    @winrt_mixinmethod
    def IsAttributeSpecified(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String) -> Boolean: ...
    @winrt_mixinmethod
    def IsAttributeSpecifiedWithInherhited(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String, inherited: Boolean) -> Boolean: ...
    @winrt_mixinmethod
    def RemoveAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def RemoveChild(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, child: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgElement) -> Void: ...
    @winrt_mixinmethod
    def ReplaceChild(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, newChild: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgElement, oldChild: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgElement) -> Void: ...
    @winrt_mixinmethod
    def SetStringAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String, attributeValue: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetStringAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String) -> WinRT_String: ...
    @winrt_mixinmethod
    def SetAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String, attributeValue: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgAttribute) -> Void: ...
    @winrt_mixinmethod
    def GetAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String) -> win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgAttribute: ...
    @winrt_mixinmethod
    def SetIdAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String, attributeValue: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetIdAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String) -> WinRT_String: ...
    @winrt_mixinmethod
    def SetFloatAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String, attributeValue: Single) -> Void: ...
    @winrt_mixinmethod
    def GetFloatAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String) -> Single: ...
    @winrt_mixinmethod
    def SetColorAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String, attributeValue: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def GetColorAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String) -> win32more.Windows.UI.Color: ...
    @winrt_mixinmethod
    def SetFilledRegionDeterminationAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String, attributeValue: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasFilledRegionDetermination) -> Void: ...
    @winrt_mixinmethod
    def GetFilledRegionDeterminationAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasFilledRegionDetermination: ...
    @winrt_mixinmethod
    def SetDisplayAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String, attributeValue: win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgDisplay) -> Void: ...
    @winrt_mixinmethod
    def GetDisplayAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgDisplay: ...
    @winrt_mixinmethod
    def SetOverflowAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String, attributeValue: win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgOverflow) -> Void: ...
    @winrt_mixinmethod
    def GetOverflowAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgOverflow: ...
    @winrt_mixinmethod
    def SetCapStyleAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String, attributeValue: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCapStyle) -> Void: ...
    @winrt_mixinmethod
    def GetCapStyleAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCapStyle: ...
    @winrt_mixinmethod
    def SetLineJoinAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String, attributeValue: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasLineJoin) -> Void: ...
    @winrt_mixinmethod
    def GetLineJoinAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasLineJoin: ...
    @winrt_mixinmethod
    def SetVisibilityAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String, attributeValue: win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgVisibility) -> Void: ...
    @winrt_mixinmethod
    def GetVisibilityAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgVisibility: ...
    @winrt_mixinmethod
    def SetTransformAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String, attributeValue: win32more.Windows.Foundation.Numerics.Matrix3x2) -> Void: ...
    @winrt_mixinmethod
    def GetTransformAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String) -> win32more.Windows.Foundation.Numerics.Matrix3x2: ...
    @winrt_mixinmethod
    def SetUnitsAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String, attributeValue: win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgUnits) -> Void: ...
    @winrt_mixinmethod
    def GetUnitsAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgUnits: ...
    @winrt_mixinmethod
    def SetEdgeBehaviorAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String, attributeValue: win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior) -> Void: ...
    @winrt_mixinmethod
    def GetEdgeBehaviorAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String) -> win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior: ...
    @winrt_mixinmethod
    def SetRectangleAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String, attributeValue: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def GetRectangleAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def SetLengthAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String, value: Single, units: win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgLengthUnits) -> Void: ...
    @winrt_mixinmethod
    def GetLengthAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String, units: POINTER(win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgLengthUnits)) -> Single: ...
    @winrt_mixinmethod
    def SetAspectRatioAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String, alignment: win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgAspectAlignment, meetOrSlice: win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgAspectScaling) -> Void: ...
    @winrt_mixinmethod
    def GetAspectRatioAttribute(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement, attributeName: WinRT_String, meetOrSlice: POINTER(win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgAspectScaling)) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgAspectAlignment: ...
    @winrt_mixinmethod
    def get_ContainingDocument(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgElement) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgDocument: ...
    @winrt_mixinmethod
    def get_Parent(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgElement) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgNamedElement: ...
    @winrt_mixinmethod
    def get_Device(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgElement) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    ContainingDocument = property(get_ContainingDocument, None)
    Device = property(get_Device, None)
    FirstChild = property(get_FirstChild, None)
    HasChildren = property(get_HasChildren, None)
    LastChild = property(get_LastChild, None)
    Parent = property(get_Parent, None)
    SpecifiedAttributes = property(get_SpecifiedAttributes, None)
    Tag = property(get_Tag, None)
class CanvasSvgOverflow(Enum, Int32):
    DoNotClipToViewport = 0
    ClipToViewport = 1
class CanvasSvgPaintAttribute(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgPaintAttribute
    _classid_ = 'Microsoft.Graphics.Canvas.Svg.CanvasSvgPaintAttribute'
    @winrt_mixinmethod
    def put_PaintType(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgPaintAttribute, value: win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgPaintType) -> Void: ...
    @winrt_mixinmethod
    def get_PaintType(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgPaintAttribute) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgPaintType: ...
    @winrt_mixinmethod
    def put_Color(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgPaintAttribute, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def get_Color(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgPaintAttribute) -> win32more.Windows.UI.Color: ...
    @winrt_mixinmethod
    def put_Id(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgPaintAttribute, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Id(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgPaintAttribute) -> WinRT_String: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    @winrt_mixinmethod
    def Clone(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgAttribute) -> win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgAttribute: ...
    @winrt_mixinmethod
    def GetElement(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgAttribute) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgNamedElement: ...
    @winrt_mixinmethod
    def get_Device(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgAttribute) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    Color = property(get_Color, put_Color)
    Device = property(get_Device, None)
    Id = property(get_Id, put_Id)
    PaintType = property(get_PaintType, put_PaintType)
class CanvasSvgPaintType(Enum, Int32):
    None_ = 0
    Color = 1
    CurrentColor = 2
    Uri = 3
    UriThenNone = 4
    UriThenColor = 5
    UriThenCurrentColor = 6
class CanvasSvgPathAttribute(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgPathAttribute
    _classid_ = 'Microsoft.Graphics.Canvas.Svg.CanvasSvgPathAttribute'
    @winrt_mixinmethod
    def CreatePathGeometry(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgPathAttribute) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_mixinmethod
    def CreatePathGeometryWithFill(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgPathAttribute, fill: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasFilledRegionDetermination) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_mixinmethod
    def get_Commands(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgPathAttribute) -> ReceiveArray[win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgPathCommand]: ...
    @winrt_mixinmethod
    def GetCommands(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgPathAttribute, startIndex: Int32, elementCount: Int32) -> ReceiveArray[win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgPathCommand]: ...
    @winrt_mixinmethod
    def get_SegmentData(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgPathAttribute) -> ReceiveArray[Single]: ...
    @winrt_mixinmethod
    def GetSegmentData(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgPathAttribute, startIndex: Int32, elementCount: Int32) -> ReceiveArray[Single]: ...
    @winrt_mixinmethod
    def RemoveCommandsAtEnd(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgPathAttribute, commandsCount: Int32) -> Void: ...
    @winrt_mixinmethod
    def RemoveSegmentDataAtEnd(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgPathAttribute, commandsCount: Int32) -> Void: ...
    @winrt_mixinmethod
    def SetCommands(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgPathAttribute, startIndex: Int32, commands: PassArray[win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgPathCommand]) -> Void: ...
    @winrt_mixinmethod
    def SetSegmentData(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgPathAttribute, startIndex: Int32, segmentData: PassArray[Single]) -> Void: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    @winrt_mixinmethod
    def Clone(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgAttribute) -> win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgAttribute: ...
    @winrt_mixinmethod
    def GetElement(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgAttribute) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgNamedElement: ...
    @winrt_mixinmethod
    def get_Device(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgAttribute) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    Commands = property(get_Commands, None)
    Device = property(get_Device, None)
    SegmentData = property(get_SegmentData, None)
class CanvasSvgPathCommand(Enum, Int32):
    ClosePath = 0
    MoveAbsolute = 1
    MoveRelative = 2
    LineAbsolute = 3
    LineRelative = 4
    CubicAbsolute = 5
    CubicRelative = 6
    QuadraticAbsolute = 7
    QuadraticRelative = 8
    ArcAbsolute = 9
    ArcRelative = 10
    HorizontalAbsolute = 11
    HorizontalRelative = 12
    VerticalAbsolute = 13
    VerticalRelative = 14
    CubicSmoothAbsolute = 15
    CubicSmoothRelative = 16
    QuadraticSmoothAbsolute = 17
    QuadraticSmoothRelative = 18
class CanvasSvgPointsAttribute(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgPointsAttribute
    _classid_ = 'Microsoft.Graphics.Canvas.Svg.CanvasSvgPointsAttribute'
    @winrt_mixinmethod
    def get_Points(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgPointsAttribute) -> ReceiveArray[win32more.Windows.Foundation.Numerics.Vector2]: ...
    @winrt_mixinmethod
    def GetPoints(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgPointsAttribute, startIndex: Int32, elementCount: Int32) -> ReceiveArray[win32more.Windows.Foundation.Numerics.Vector2]: ...
    @winrt_mixinmethod
    def RemovePointsAtEnd(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgPointsAttribute, pointCount: Int32) -> Void: ...
    @winrt_mixinmethod
    def SetPoints(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgPointsAttribute, startIndex: Int32, points: PassArray[win32more.Windows.Foundation.Numerics.Vector2]) -> Void: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    @winrt_mixinmethod
    def Clone(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgAttribute) -> win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgAttribute: ...
    @winrt_mixinmethod
    def GetElement(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgAttribute) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgNamedElement: ...
    @winrt_mixinmethod
    def get_Device(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgAttribute) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    Device = property(get_Device, None)
    Points = property(get_Points, None)
class CanvasSvgStrokeDashArrayAttribute(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgStrokeDashArrayAttribute
    _classid_ = 'Microsoft.Graphics.Canvas.Svg.CanvasSvgStrokeDashArrayAttribute'
    @winrt_mixinmethod
    def GetDashes(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgStrokeDashArrayAttribute) -> ReceiveArray[Single]: ...
    @winrt_mixinmethod
    def GetDashesWithUnits(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgStrokeDashArrayAttribute, startIndex: Int32, elementCount: Int32, outputUnitsElements: ReceiveArray[win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgLengthUnits]) -> ReceiveArray[Single]: ...
    @winrt_mixinmethod
    def RemoveDashesAtEnd(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgStrokeDashArrayAttribute, dashCount: Int32) -> Void: ...
    @winrt_mixinmethod
    def SetDashes(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgStrokeDashArrayAttribute, startIndex: Int32, dashes: PassArray[Single]) -> Void: ...
    @winrt_mixinmethod
    def SetDashesWithUnit(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgStrokeDashArrayAttribute, startIndex: Int32, dashes: PassArray[Single], units: win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgLengthUnits) -> Void: ...
    @winrt_mixinmethod
    def SetDashesWithUnits(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgStrokeDashArrayAttribute, startIndex: Int32, dashValues: PassArray[Single], unitValues: PassArray[win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgLengthUnits]) -> Void: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    @winrt_mixinmethod
    def Clone(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgAttribute) -> win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgAttribute: ...
    @winrt_mixinmethod
    def GetElement(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgAttribute) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgNamedElement: ...
    @winrt_mixinmethod
    def get_Device(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgAttribute) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    Device = property(get_Device, None)
class CanvasSvgTextElement(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgTextElement
    _classid_ = 'Microsoft.Graphics.Canvas.Svg.CanvasSvgTextElement'
    @winrt_mixinmethod
    def put_Text(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgTextElement, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Text(self: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgTextElement) -> WinRT_String: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    Text = property(get_Text, put_Text)
class CanvasSvgUnits(Enum, Int32):
    UserSpaceOnUse = 0
    ObjectBoundingBox = 1
class CanvasSvgVisibility(Enum, Int32):
    Visible = 0
    Hidden = 1
class ICanvasSvgAttribute(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Svg.ICanvasSvgAttribute'
    _iid_ = Guid('{652786a8-f3ab-4083-991d-9748aa86bd6e}')
    @winrt_commethod(6)
    def Clone(self) -> win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgAttribute: ...
    @winrt_commethod(7)
    def GetElement(self) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgNamedElement: ...
    @winrt_commethod(8)
    def get_Device(self) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    Device = property(get_Device, None)
class ICanvasSvgDocument(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Svg.ICanvasSvgDocument'
    _iid_ = Guid('{a0e34929-3551-44fe-a670-d9b3fd800516}')
    @winrt_commethod(6)
    def get_Device(self) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    @winrt_commethod(7)
    def GetXml(self) -> WinRT_String: ...
    @winrt_commethod(8)
    def SaveAsync(self, stream: win32more.Windows.Storage.Streams.IRandomAccessStream) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_commethod(9)
    def put_Root(self, value: win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgNamedElement) -> Void: ...
    @winrt_commethod(10)
    def get_Root(self) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgNamedElement: ...
    @winrt_commethod(11)
    def FindElementById(self, id: WinRT_String) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgNamedElement: ...
    @winrt_commethod(12)
    def CreatePaintAttributeWithDefaults(self) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgPaintAttribute: ...
    @winrt_commethod(13)
    def CreatePaintAttribute(self, paintType: win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgPaintType, color: win32more.Windows.UI.Color, id: WinRT_String) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgPaintAttribute: ...
    @winrt_commethod(14)
    def CreatePathAttributeWithDefaults(self) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgPathAttribute: ...
    @winrt_commethod(15)
    def CreatePathAttribute(self, segmentData: PassArray[Single], commands: PassArray[win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgPathCommand]) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgPathAttribute: ...
    @winrt_commethod(16)
    def CreatePointsAttributeWithDefaults(self) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgPointsAttribute: ...
    @winrt_commethod(17)
    def CreatePointsAttribute(self, points: PassArray[win32more.Windows.Foundation.Numerics.Vector2]) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgPointsAttribute: ...
    @winrt_commethod(18)
    def CreateStrokeDashArrayAttributeWithDefaults(self) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgStrokeDashArrayAttribute: ...
    @winrt_commethod(19)
    def CreateStrokeDashArrayAttribute(self, dashValues: PassArray[Single], unitValues: PassArray[win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgLengthUnits]) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgStrokeDashArrayAttribute: ...
    @winrt_commethod(20)
    def LoadElementFromXml(self, xmlString: WinRT_String) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgNamedElement: ...
    @winrt_commethod(21)
    def LoadElementAsync(self, stream: win32more.Windows.Storage.Streams.IRandomAccessStream) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgNamedElement]: ...
    Device = property(get_Device, None)
    Root = property(get_Root, put_Root)
class ICanvasSvgDocumentFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.Svg.ICanvasSvgDocumentFactory'
    _iid_ = Guid('{bab0f16d-4050-4ef6-8022-8a07e9e74a9d}')
    @winrt_commethod(6)
    def CreateEmpty(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgDocument: ...
class ICanvasSvgDocumentStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.Svg.ICanvasSvgDocumentStatics'
    _iid_ = Guid('{7740e748-cb9a-453f-a678-8b3b3a7254d3}')
    @winrt_commethod(6)
    def LoadFromXml(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, xmlString: WinRT_String) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgDocument: ...
    @winrt_commethod(7)
    def LoadAsync(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, stream: win32more.Windows.Storage.Streams.IRandomAccessStream) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgDocument]: ...
    @winrt_commethod(8)
    def IsSupported(self, device: win32more.Microsoft.Graphics.Canvas.CanvasDevice) -> Boolean: ...
class ICanvasSvgElement(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Svg.ICanvasSvgElement'
    _iid_ = Guid('{0775cb81-c555-45bf-9795-0ff59151c3be}')
    @winrt_commethod(6)
    def get_ContainingDocument(self) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgDocument: ...
    @winrt_commethod(7)
    def get_Parent(self) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgNamedElement: ...
    @winrt_commethod(8)
    def get_Device(self) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    ContainingDocument = property(get_ContainingDocument, None)
    Device = property(get_Device, None)
    Parent = property(get_Parent, None)
class ICanvasSvgNamedElement(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Svg.ICanvasSvgNamedElement'
    _iid_ = Guid('{d8b7cb94-8167-495d-9c71-5e97e5d08d2b}')
    @winrt_commethod(6)
    def AppendChild(self, child: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgElement) -> Void: ...
    @winrt_commethod(7)
    def CreateAndAppendNamedChildElement(self, childName: WinRT_String) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgNamedElement: ...
    @winrt_commethod(8)
    def CreateAndAppendTextChildElement(self, textContent: WinRT_String) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgTextElement: ...
    @winrt_commethod(9)
    def get_FirstChild(self) -> win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgElement: ...
    @winrt_commethod(10)
    def get_LastChild(self) -> win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgElement: ...
    @winrt_commethod(11)
    def GetPreviousSibling(self, child: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgElement) -> win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgElement: ...
    @winrt_commethod(12)
    def GetNextSibling(self, child: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgElement) -> win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgElement: ...
    @winrt_commethod(13)
    def get_SpecifiedAttributes(self) -> ReceiveArray[WinRT_String]: ...
    @winrt_commethod(14)
    def get_Tag(self) -> WinRT_String: ...
    @winrt_commethod(15)
    def get_HasChildren(self) -> Boolean: ...
    @winrt_commethod(16)
    def InsertChildBefore(self, child: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgElement, referenceChild: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgElement) -> Void: ...
    @winrt_commethod(17)
    def IsAttributeSpecified(self, attributeName: WinRT_String) -> Boolean: ...
    @winrt_commethod(18)
    def IsAttributeSpecifiedWithInherhited(self, attributeName: WinRT_String, inherited: Boolean) -> Boolean: ...
    @winrt_commethod(19)
    def RemoveAttribute(self, attributeName: WinRT_String) -> Void: ...
    @winrt_commethod(20)
    def RemoveChild(self, child: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgElement) -> Void: ...
    @winrt_commethod(21)
    def ReplaceChild(self, newChild: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgElement, oldChild: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgElement) -> Void: ...
    @winrt_commethod(22)
    def SetStringAttribute(self, attributeName: WinRT_String, attributeValue: WinRT_String) -> Void: ...
    @winrt_commethod(23)
    def GetStringAttribute(self, attributeName: WinRT_String) -> WinRT_String: ...
    @winrt_commethod(24)
    def SetAttribute(self, attributeName: WinRT_String, attributeValue: win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgAttribute) -> Void: ...
    @winrt_commethod(25)
    def GetAttribute(self, attributeName: WinRT_String) -> win32more.Microsoft.Graphics.Canvas.Svg.ICanvasSvgAttribute: ...
    @winrt_commethod(26)
    def SetIdAttribute(self, attributeName: WinRT_String, attributeValue: WinRT_String) -> Void: ...
    @winrt_commethod(27)
    def GetIdAttribute(self, attributeName: WinRT_String) -> WinRT_String: ...
    @winrt_commethod(28)
    def SetFloatAttribute(self, attributeName: WinRT_String, attributeValue: Single) -> Void: ...
    @winrt_commethod(29)
    def GetFloatAttribute(self, attributeName: WinRT_String) -> Single: ...
    @winrt_commethod(30)
    def SetColorAttribute(self, attributeName: WinRT_String, attributeValue: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(31)
    def GetColorAttribute(self, attributeName: WinRT_String) -> win32more.Windows.UI.Color: ...
    @winrt_commethod(32)
    def SetFilledRegionDeterminationAttribute(self, attributeName: WinRT_String, attributeValue: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasFilledRegionDetermination) -> Void: ...
    @winrt_commethod(33)
    def GetFilledRegionDeterminationAttribute(self, attributeName: WinRT_String) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasFilledRegionDetermination: ...
    @winrt_commethod(34)
    def SetDisplayAttribute(self, attributeName: WinRT_String, attributeValue: win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgDisplay) -> Void: ...
    @winrt_commethod(35)
    def GetDisplayAttribute(self, attributeName: WinRT_String) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgDisplay: ...
    @winrt_commethod(36)
    def SetOverflowAttribute(self, attributeName: WinRT_String, attributeValue: win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgOverflow) -> Void: ...
    @winrt_commethod(37)
    def GetOverflowAttribute(self, attributeName: WinRT_String) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgOverflow: ...
    @winrt_commethod(38)
    def SetCapStyleAttribute(self, attributeName: WinRT_String, attributeValue: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCapStyle) -> Void: ...
    @winrt_commethod(39)
    def GetCapStyleAttribute(self, attributeName: WinRT_String) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasCapStyle: ...
    @winrt_commethod(40)
    def SetLineJoinAttribute(self, attributeName: WinRT_String, attributeValue: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasLineJoin) -> Void: ...
    @winrt_commethod(41)
    def GetLineJoinAttribute(self, attributeName: WinRT_String) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasLineJoin: ...
    @winrt_commethod(42)
    def SetVisibilityAttribute(self, attributeName: WinRT_String, attributeValue: win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgVisibility) -> Void: ...
    @winrt_commethod(43)
    def GetVisibilityAttribute(self, attributeName: WinRT_String) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgVisibility: ...
    @winrt_commethod(44)
    def SetTransformAttribute(self, attributeName: WinRT_String, attributeValue: win32more.Windows.Foundation.Numerics.Matrix3x2) -> Void: ...
    @winrt_commethod(45)
    def GetTransformAttribute(self, attributeName: WinRT_String) -> win32more.Windows.Foundation.Numerics.Matrix3x2: ...
    @winrt_commethod(46)
    def SetUnitsAttribute(self, attributeName: WinRT_String, attributeValue: win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgUnits) -> Void: ...
    @winrt_commethod(47)
    def GetUnitsAttribute(self, attributeName: WinRT_String) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgUnits: ...
    @winrt_commethod(48)
    def SetEdgeBehaviorAttribute(self, attributeName: WinRT_String, attributeValue: win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior) -> Void: ...
    @winrt_commethod(49)
    def GetEdgeBehaviorAttribute(self, attributeName: WinRT_String) -> win32more.Microsoft.Graphics.Canvas.CanvasEdgeBehavior: ...
    @winrt_commethod(50)
    def SetRectangleAttribute(self, attributeName: WinRT_String, attributeValue: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_commethod(51)
    def GetRectangleAttribute(self, attributeName: WinRT_String) -> win32more.Windows.Foundation.Rect: ...
    @winrt_commethod(52)
    def SetLengthAttribute(self, attributeName: WinRT_String, value: Single, units: win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgLengthUnits) -> Void: ...
    @winrt_commethod(53)
    def GetLengthAttribute(self, attributeName: WinRT_String, units: POINTER(win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgLengthUnits)) -> Single: ...
    @winrt_commethod(54)
    def SetAspectRatioAttribute(self, attributeName: WinRT_String, alignment: win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgAspectAlignment, meetOrSlice: win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgAspectScaling) -> Void: ...
    @winrt_commethod(55)
    def GetAspectRatioAttribute(self, attributeName: WinRT_String, meetOrSlice: POINTER(win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgAspectScaling)) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgAspectAlignment: ...
    FirstChild = property(get_FirstChild, None)
    HasChildren = property(get_HasChildren, None)
    LastChild = property(get_LastChild, None)
    SpecifiedAttributes = property(get_SpecifiedAttributes, None)
    Tag = property(get_Tag, None)
class ICanvasSvgPaintAttribute(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Svg.ICanvasSvgPaintAttribute'
    _iid_ = Guid('{653786a8-f3ab-4083-991d-9748aa86bd6e}')
    @winrt_commethod(6)
    def put_PaintType(self, value: win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgPaintType) -> Void: ...
    @winrt_commethod(7)
    def get_PaintType(self) -> win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgPaintType: ...
    @winrt_commethod(8)
    def put_Color(self, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(9)
    def get_Color(self) -> win32more.Windows.UI.Color: ...
    @winrt_commethod(10)
    def put_Id(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(11)
    def get_Id(self) -> WinRT_String: ...
    Color = property(get_Color, put_Color)
    Id = property(get_Id, put_Id)
    PaintType = property(get_PaintType, put_PaintType)
class ICanvasSvgPathAttribute(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Svg.ICanvasSvgPathAttribute'
    _iid_ = Guid('{652786a8-f3ab-4083-991d-9748ab86bd6e}')
    @winrt_commethod(6)
    def CreatePathGeometry(self) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_commethod(7)
    def CreatePathGeometryWithFill(self, fill: win32more.Microsoft.Graphics.Canvas.Geometry.CanvasFilledRegionDetermination) -> win32more.Microsoft.Graphics.Canvas.Geometry.CanvasGeometry: ...
    @winrt_commethod(8)
    def get_Commands(self) -> ReceiveArray[win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgPathCommand]: ...
    @winrt_commethod(9)
    def GetCommands(self, startIndex: Int32, elementCount: Int32) -> ReceiveArray[win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgPathCommand]: ...
    @winrt_commethod(10)
    def get_SegmentData(self) -> ReceiveArray[Single]: ...
    @winrt_commethod(11)
    def GetSegmentData(self, startIndex: Int32, elementCount: Int32) -> ReceiveArray[Single]: ...
    @winrt_commethod(12)
    def RemoveCommandsAtEnd(self, commandsCount: Int32) -> Void: ...
    @winrt_commethod(13)
    def RemoveSegmentDataAtEnd(self, commandsCount: Int32) -> Void: ...
    @winrt_commethod(14)
    def SetCommands(self, startIndex: Int32, commands: PassArray[win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgPathCommand]) -> Void: ...
    @winrt_commethod(15)
    def SetSegmentData(self, startIndex: Int32, segmentData: PassArray[Single]) -> Void: ...
    Commands = property(get_Commands, None)
    SegmentData = property(get_SegmentData, None)
class ICanvasSvgPointsAttribute(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Svg.ICanvasSvgPointsAttribute'
    _iid_ = Guid('{652786a8-f3ab-4083-991d-9748aa86bd6f}')
    @winrt_commethod(6)
    def get_Points(self) -> ReceiveArray[win32more.Windows.Foundation.Numerics.Vector2]: ...
    @winrt_commethod(7)
    def GetPoints(self, startIndex: Int32, elementCount: Int32) -> ReceiveArray[win32more.Windows.Foundation.Numerics.Vector2]: ...
    @winrt_commethod(8)
    def RemovePointsAtEnd(self, pointCount: Int32) -> Void: ...
    @winrt_commethod(9)
    def SetPoints(self, startIndex: Int32, points: PassArray[win32more.Windows.Foundation.Numerics.Vector2]) -> Void: ...
    Points = property(get_Points, None)
class ICanvasSvgStrokeDashArrayAttribute(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Svg.ICanvasSvgStrokeDashArrayAttribute'
    _iid_ = Guid('{652786a8-f3ab-4083-991d-9748aa86bd70}')
    @winrt_commethod(6)
    def GetDashes(self) -> ReceiveArray[Single]: ...
    @winrt_commethod(7)
    def GetDashesWithUnits(self, startIndex: Int32, elementCount: Int32, outputUnitsElements: ReceiveArray[win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgLengthUnits]) -> ReceiveArray[Single]: ...
    @winrt_commethod(8)
    def RemoveDashesAtEnd(self, dashCount: Int32) -> Void: ...
    @winrt_commethod(9)
    def SetDashes(self, startIndex: Int32, dashes: PassArray[Single]) -> Void: ...
    @winrt_commethod(10)
    def SetDashesWithUnit(self, startIndex: Int32, dashes: PassArray[Single], units: win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgLengthUnits) -> Void: ...
    @winrt_commethod(11)
    def SetDashesWithUnits(self, startIndex: Int32, dashValues: PassArray[Single], unitValues: PassArray[win32more.Microsoft.Graphics.Canvas.Svg.CanvasSvgLengthUnits]) -> Void: ...
class ICanvasSvgTextElement(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Microsoft.Graphics.Canvas.Svg.ICanvasSvgTextElement'
    _iid_ = Guid('{652786a8-f3ab-4083-991d-9748aa86bd6d}')
    @winrt_commethod(6)
    def put_Text(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(7)
    def get_Text(self) -> WinRT_String: ...
    Text = property(get_Text, put_Text)


make_ready(__name__)
