from __future__ import annotations
from win32more.winrt.prelude import *
import win32more.Microsoft.Graphics.Canvas
import win32more.Microsoft.Graphics.Canvas.UI
import win32more.Microsoft.Graphics.Canvas.UI.Xaml
import win32more.Microsoft.UI.Dispatching
import win32more.Microsoft.UI.Input
import win32more.Microsoft.UI.Xaml.Controls
import win32more.Microsoft.UI.Xaml.Media.Imaging
import win32more.Windows.Foundation
import win32more.Windows.Graphics.Imaging
import win32more.Windows.UI
class CanvasAnimatedControl(ComPtr):
    extends: win32more.Microsoft.UI.Xaml.Controls.UserControl
    default_interface: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl
    _classid_ = 'Microsoft.Graphics.Canvas.UI.Xaml.CanvasAnimatedControl'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasAnimatedControl.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasAnimatedControl: ...
    @winrt_mixinmethod
    def add_CreateResources(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasAnimatedControl, win32more.Microsoft.Graphics.Canvas.UI.CanvasCreateResourcesEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_CreateResources(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_Update(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl, win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasAnimatedUpdateEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_Update(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_Draw(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl, win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasAnimatedDrawEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_Draw(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_GameLoopStarting(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_GameLoopStarting(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_GameLoopStopped(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_GameLoopStopped(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def get_ReadyToDraw(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl) -> Boolean: ...
    @winrt_mixinmethod
    def put_IsFixedTimeStep(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_IsFixedTimeStep(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl) -> Boolean: ...
    @winrt_mixinmethod
    def put_TargetElapsedTime(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl, value: win32more.Windows.Foundation.TimeSpan) -> Void: ...
    @winrt_mixinmethod
    def get_TargetElapsedTime(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl) -> win32more.Windows.Foundation.TimeSpan: ...
    @winrt_mixinmethod
    def put_Paused(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_Paused(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl) -> Boolean: ...
    @winrt_mixinmethod
    def put_ClearColor(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def get_ClearColor(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl) -> win32more.Windows.UI.Color: ...
    @winrt_mixinmethod
    def get_Size(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl) -> win32more.Windows.Foundation.Size: ...
    @winrt_mixinmethod
    def Invalidate(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl) -> Void: ...
    @winrt_mixinmethod
    def ResetElapsedTime(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl) -> Void: ...
    @winrt_mixinmethod
    def CreateCoreIndependentInputSource(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl, deviceTypes: win32more.Microsoft.UI.Input.InputPointerSourceDeviceKinds) -> win32more.Microsoft.UI.Input.InputPointerSource: ...
    @winrt_mixinmethod
    def RemoveFromVisualTree(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl) -> Void: ...
    @winrt_mixinmethod
    def get_HasGameLoopThreadAccess(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl) -> Boolean: ...
    @winrt_mixinmethod
    def RunOnGameLoopThreadAsync(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl, agileCallback: win32more.Microsoft.UI.Dispatching.DispatcherQueueHandler) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_mixinmethod
    def get_UseSharedDevice(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl) -> Boolean: ...
    @winrt_mixinmethod
    def put_UseSharedDevice(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_ForceSoftwareRenderer(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl) -> Boolean: ...
    @winrt_mixinmethod
    def put_ForceSoftwareRenderer(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_CustomDevice(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    @winrt_mixinmethod
    def put_CustomDevice(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl, value: win32more.Microsoft.Graphics.Canvas.CanvasDevice) -> Void: ...
    @winrt_mixinmethod
    def get_DpiScale(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl) -> Single: ...
    @winrt_mixinmethod
    def put_DpiScale(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl, ratio: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Dpi(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> Single: ...
    @winrt_mixinmethod
    def ConvertPixelsToDips(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, pixels: Int32) -> Single: ...
    @winrt_mixinmethod
    def ConvertDipsToPixels(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, dips: Single, dpiRounding: win32more.Microsoft.Graphics.Canvas.CanvasDpiRounding) -> Int32: ...
    @winrt_mixinmethod
    def get_Device(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    ClearColor = property(get_ClearColor, put_ClearColor)
    CustomDevice = property(get_CustomDevice, put_CustomDevice)
    Device = property(get_Device, None)
    Dpi = property(get_Dpi, None)
    DpiScale = property(get_DpiScale, put_DpiScale)
    ForceSoftwareRenderer = property(get_ForceSoftwareRenderer, put_ForceSoftwareRenderer)
    HasGameLoopThreadAccess = property(get_HasGameLoopThreadAccess, None)
    IsFixedTimeStep = property(get_IsFixedTimeStep, put_IsFixedTimeStep)
    Paused = property(get_Paused, put_Paused)
    ReadyToDraw = property(get_ReadyToDraw, None)
    Size = property(get_Size, None)
    TargetElapsedTime = property(get_TargetElapsedTime, put_TargetElapsedTime)
    UseSharedDevice = property(get_UseSharedDevice, put_UseSharedDevice)
    CreateResources = event()
    Update = event()
    Draw = event()
    GameLoopStarting = event()
    GameLoopStopped = event()
class CanvasAnimatedDrawEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedDrawEventArgs
    _classid_ = 'Microsoft.Graphics.Canvas.UI.Xaml.CanvasAnimatedDrawEventArgs'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 2:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasAnimatedDrawEventArgs.Create(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def Create(cls: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedDrawEventArgsFactory, canvasDrawingSession: win32more.Microsoft.Graphics.Canvas.CanvasDrawingSession, timingInformation: win32more.Microsoft.Graphics.Canvas.UI.CanvasTimingInformation) -> win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasAnimatedDrawEventArgs: ...
    @winrt_mixinmethod
    def get_DrawingSession(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedDrawEventArgs) -> win32more.Microsoft.Graphics.Canvas.CanvasDrawingSession: ...
    @winrt_mixinmethod
    def get_Timing(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedDrawEventArgs) -> win32more.Microsoft.Graphics.Canvas.UI.CanvasTimingInformation: ...
    DrawingSession = property(get_DrawingSession, None)
    Timing = property(get_Timing, None)
class CanvasAnimatedUpdateEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedUpdateEventArgs
    _classid_ = 'Microsoft.Graphics.Canvas.UI.Xaml.CanvasAnimatedUpdateEventArgs'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasAnimatedUpdateEventArgs.Create(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def Create(cls: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedUpdateEventArgsFactory, timingInformation: win32more.Microsoft.Graphics.Canvas.UI.CanvasTimingInformation) -> win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasAnimatedUpdateEventArgs: ...
    @winrt_mixinmethod
    def get_Timing(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedUpdateEventArgs) -> win32more.Microsoft.Graphics.Canvas.UI.CanvasTimingInformation: ...
    Timing = property(get_Timing, None)
class CanvasControl(ComPtr):
    extends: win32more.Microsoft.UI.Xaml.Controls.UserControl
    default_interface: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasControl
    _classid_ = 'Microsoft.Graphics.Canvas.UI.Xaml.CanvasControl'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasControl.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasControl: ...
    @winrt_mixinmethod
    def add_CreateResources(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasControl, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasControl, win32more.Microsoft.Graphics.Canvas.UI.CanvasCreateResourcesEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_CreateResources(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasControl, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def get_ReadyToDraw(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasControl) -> Boolean: ...
    @winrt_mixinmethod
    def add_Draw(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasControl, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasControl, win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasDrawEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_Draw(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasControl, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def put_ClearColor(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasControl, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def get_ClearColor(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasControl) -> win32more.Windows.UI.Color: ...
    @winrt_mixinmethod
    def Invalidate(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasControl) -> Void: ...
    @winrt_mixinmethod
    def get_Size(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasControl) -> win32more.Windows.Foundation.Size: ...
    @winrt_mixinmethod
    def RemoveFromVisualTree(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasControl) -> Void: ...
    @winrt_mixinmethod
    def get_UseSharedDevice(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasControl) -> Boolean: ...
    @winrt_mixinmethod
    def put_UseSharedDevice(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasControl, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_ForceSoftwareRenderer(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasControl) -> Boolean: ...
    @winrt_mixinmethod
    def put_ForceSoftwareRenderer(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasControl, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_CustomDevice(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasControl) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    @winrt_mixinmethod
    def put_CustomDevice(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasControl, value: win32more.Microsoft.Graphics.Canvas.CanvasDevice) -> Void: ...
    @winrt_mixinmethod
    def get_DpiScale(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasControl) -> Single: ...
    @winrt_mixinmethod
    def put_DpiScale(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasControl, ratio: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Dpi(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> Single: ...
    @winrt_mixinmethod
    def ConvertPixelsToDips(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, pixels: Int32) -> Single: ...
    @winrt_mixinmethod
    def ConvertDipsToPixels(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, dips: Single, dpiRounding: win32more.Microsoft.Graphics.Canvas.CanvasDpiRounding) -> Int32: ...
    @winrt_mixinmethod
    def get_Device(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    ClearColor = property(get_ClearColor, put_ClearColor)
    CustomDevice = property(get_CustomDevice, put_CustomDevice)
    Device = property(get_Device, None)
    Dpi = property(get_Dpi, None)
    DpiScale = property(get_DpiScale, put_DpiScale)
    ForceSoftwareRenderer = property(get_ForceSoftwareRenderer, put_ForceSoftwareRenderer)
    ReadyToDraw = property(get_ReadyToDraw, None)
    Size = property(get_Size, None)
    UseSharedDevice = property(get_UseSharedDevice, put_UseSharedDevice)
    CreateResources = event()
    Draw = event()
class CanvasDrawEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasDrawEventArgs
    _classid_ = 'Microsoft.Graphics.Canvas.UI.Xaml.CanvasDrawEventArgs'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasDrawEventArgs.Create(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def Create(cls: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasDrawEventArgsFactory, canvasDrawingSession: win32more.Microsoft.Graphics.Canvas.CanvasDrawingSession) -> win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasDrawEventArgs: ...
    @winrt_mixinmethod
    def get_DrawingSession(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasDrawEventArgs) -> win32more.Microsoft.Graphics.Canvas.CanvasDrawingSession: ...
    DrawingSession = property(get_DrawingSession, None)
class CanvasImageSource(ComPtr):
    extends: win32more.Microsoft.UI.Xaml.Media.Imaging.SurfaceImageSource
    default_interface: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasImageSource
    _classid_ = 'Microsoft.Graphics.Canvas.UI.Xaml.CanvasImageSource'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 2:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasImageSource.CreateWithSize(*args))
        elif len(args) == 3:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasImageSource.CreateWithWidthAndHeight(*args))
        elif len(args) == 4:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasImageSource.CreateWithWidthAndHeightAndDpi(*args))
        elif len(args) == 5:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasImageSource.CreateWithWidthAndHeightAndDpiAndAlphaMode(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def CreateWithSize(cls: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasImageSourceFactory, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, size: win32more.Windows.Foundation.Size) -> win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasImageSource: ...
    @winrt_factorymethod
    def CreateWithWidthAndHeight(cls: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasImageSourceFactory, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, width: Single, height: Single) -> win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasImageSource: ...
    @winrt_factorymethod
    def CreateWithWidthAndHeightAndDpi(cls: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasImageSourceFactory, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, width: Single, height: Single, dpi: Single) -> win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasImageSource: ...
    @winrt_factorymethod
    def CreateWithWidthAndHeightAndDpiAndAlphaMode(cls: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasImageSourceFactory, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, width: Single, height: Single, dpi: Single, alphaMode: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasImageSource: ...
    @winrt_mixinmethod
    def CreateDrawingSession(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasImageSource, clearColor: win32more.Windows.UI.Color) -> win32more.Microsoft.Graphics.Canvas.CanvasDrawingSession: ...
    @winrt_mixinmethod
    def CreateDrawingSessionWithUpdateRectangle(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasImageSource, clearColor: win32more.Windows.UI.Color, updateRectangle: win32more.Windows.Foundation.Rect) -> win32more.Microsoft.Graphics.Canvas.CanvasDrawingSession: ...
    @winrt_mixinmethod
    def Recreate(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasImageSource, value: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> Void: ...
    @winrt_mixinmethod
    def get_Size(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasImageSource) -> win32more.Windows.Foundation.Size: ...
    @winrt_mixinmethod
    def get_SizeInPixels(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasImageSource) -> win32more.Windows.Graphics.Imaging.BitmapSize: ...
    @winrt_mixinmethod
    def get_AlphaMode(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasImageSource) -> win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode: ...
    @winrt_mixinmethod
    def get_Dpi(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> Single: ...
    @winrt_mixinmethod
    def ConvertPixelsToDips(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, pixels: Int32) -> Single: ...
    @winrt_mixinmethod
    def ConvertDipsToPixels(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, dips: Single, dpiRounding: win32more.Microsoft.Graphics.Canvas.CanvasDpiRounding) -> Int32: ...
    @winrt_mixinmethod
    def get_Device(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    AlphaMode = property(get_AlphaMode, None)
    Device = property(get_Device, None)
    Dpi = property(get_Dpi, None)
    Size = property(get_Size, None)
    SizeInPixels = property(get_SizeInPixels, None)
class CanvasRegionsInvalidatedEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasRegionsInvalidatedEventArgs
    _classid_ = 'Microsoft.Graphics.Canvas.UI.Xaml.CanvasRegionsInvalidatedEventArgs'
    @winrt_mixinmethod
    def get_InvalidatedRegions(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasRegionsInvalidatedEventArgs) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_mixinmethod
    def get_VisibleRegion(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasRegionsInvalidatedEventArgs) -> win32more.Windows.Foundation.Rect: ...
    InvalidatedRegions = property(get_InvalidatedRegions, None)
    VisibleRegion = property(get_VisibleRegion, None)
class CanvasSwapChainPanel(ComPtr):
    extends: win32more.Microsoft.UI.Xaml.Controls.SwapChainPanel
    default_interface: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasSwapChainPanel
    _classid_ = 'Microsoft.Graphics.Canvas.UI.Xaml.CanvasSwapChainPanel'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasSwapChainPanel.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasSwapChainPanel: ...
    @winrt_mixinmethod
    def put_SwapChain(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasSwapChainPanel, value: win32more.Microsoft.Graphics.Canvas.CanvasSwapChain) -> Void: ...
    @winrt_mixinmethod
    def get_SwapChain(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasSwapChainPanel) -> win32more.Microsoft.Graphics.Canvas.CanvasSwapChain: ...
    @winrt_mixinmethod
    def RemoveFromVisualTree(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasSwapChainPanel) -> Void: ...
    SwapChain = property(get_SwapChain, put_SwapChain)
class CanvasVirtualControl(ComPtr):
    extends: win32more.Microsoft.UI.Xaml.Controls.UserControl
    default_interface: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualControl
    _classid_ = 'Microsoft.Graphics.Canvas.UI.Xaml.CanvasVirtualControl'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasVirtualControl.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasVirtualControl: ...
    @winrt_mixinmethod
    def add_CreateResources(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualControl, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasVirtualControl, win32more.Microsoft.Graphics.Canvas.UI.CanvasCreateResourcesEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_CreateResources(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualControl, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def get_ReadyToDraw(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualControl) -> Boolean: ...
    @winrt_mixinmethod
    def add_RegionsInvalidated(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualControl, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasVirtualControl, win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasRegionsInvalidatedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_RegionsInvalidated(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualControl, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def put_ClearColor(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualControl, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def get_ClearColor(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualControl) -> win32more.Windows.UI.Color: ...
    @winrt_mixinmethod
    def CreateDrawingSession(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualControl, updateRectangle: win32more.Windows.Foundation.Rect) -> win32more.Microsoft.Graphics.Canvas.CanvasDrawingSession: ...
    @winrt_mixinmethod
    def SuspendDrawingSession(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualControl, drawingSession: win32more.Microsoft.Graphics.Canvas.CanvasDrawingSession) -> Void: ...
    @winrt_mixinmethod
    def ResumeDrawingSession(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualControl, drawingSession: win32more.Microsoft.Graphics.Canvas.CanvasDrawingSession) -> Void: ...
    @winrt_mixinmethod
    def Invalidate(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualControl) -> Void: ...
    @winrt_mixinmethod
    def InvalidateRegion(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualControl, region: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def get_Size(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualControl) -> win32more.Windows.Foundation.Size: ...
    @winrt_mixinmethod
    def RemoveFromVisualTree(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualControl) -> Void: ...
    @winrt_mixinmethod
    def get_UseSharedDevice(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualControl) -> Boolean: ...
    @winrt_mixinmethod
    def put_UseSharedDevice(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualControl, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_ForceSoftwareRenderer(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualControl) -> Boolean: ...
    @winrt_mixinmethod
    def put_ForceSoftwareRenderer(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualControl, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_CustomDevice(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualControl) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    @winrt_mixinmethod
    def put_CustomDevice(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualControl, value: win32more.Microsoft.Graphics.Canvas.CanvasDevice) -> Void: ...
    @winrt_mixinmethod
    def get_DpiScale(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualControl) -> Single: ...
    @winrt_mixinmethod
    def put_DpiScale(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualControl, ratio: Single) -> Void: ...
    @winrt_mixinmethod
    def get_Dpi(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> Single: ...
    @winrt_mixinmethod
    def ConvertPixelsToDips(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, pixels: Int32) -> Single: ...
    @winrt_mixinmethod
    def ConvertDipsToPixels(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, dips: Single, dpiRounding: win32more.Microsoft.Graphics.Canvas.CanvasDpiRounding) -> Int32: ...
    @winrt_mixinmethod
    def get_Device(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    ClearColor = property(get_ClearColor, put_ClearColor)
    CustomDevice = property(get_CustomDevice, put_CustomDevice)
    Device = property(get_Device, None)
    Dpi = property(get_Dpi, None)
    DpiScale = property(get_DpiScale, put_DpiScale)
    ForceSoftwareRenderer = property(get_ForceSoftwareRenderer, put_ForceSoftwareRenderer)
    ReadyToDraw = property(get_ReadyToDraw, None)
    Size = property(get_Size, None)
    UseSharedDevice = property(get_UseSharedDevice, put_UseSharedDevice)
    CreateResources = event()
    RegionsInvalidated = event()
class CanvasVirtualImageSource(ComPtr):
    extends: IInspectable
    default_interface: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualImageSource
    _classid_ = 'Microsoft.Graphics.Canvas.UI.Xaml.CanvasVirtualImageSource'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 2:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasVirtualImageSource.CreateWithSize(*args))
        elif len(args) == 3:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasVirtualImageSource.CreateWithWidthAndHeight(*args))
        elif len(args) == 4:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasVirtualImageSource.CreateWithWidthAndHeightAndDpi(*args))
        elif len(args) == 5:
            super().__init__(move=win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasVirtualImageSource.CreateWithWidthAndHeightAndDpiAndAlphaMode(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def CreateWithSize(cls: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualImageSourceFactory, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, size: win32more.Windows.Foundation.Size) -> win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasVirtualImageSource: ...
    @winrt_factorymethod
    def CreateWithWidthAndHeight(cls: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualImageSourceFactory, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, width: Single, height: Single) -> win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasVirtualImageSource: ...
    @winrt_factorymethod
    def CreateWithWidthAndHeightAndDpi(cls: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualImageSourceFactory, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, width: Single, height: Single, dpi: Single) -> win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasVirtualImageSource: ...
    @winrt_factorymethod
    def CreateWithWidthAndHeightAndDpiAndAlphaMode(cls: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualImageSourceFactory, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, width: Single, height: Single, dpi: Single, alphaMode: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasVirtualImageSource: ...
    @winrt_mixinmethod
    def get_Source(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualImageSource) -> win32more.Microsoft.UI.Xaml.Media.Imaging.VirtualSurfaceImageSource: ...
    @winrt_mixinmethod
    def CreateDrawingSession(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualImageSource, clearColor: win32more.Windows.UI.Color, updateRectangle: win32more.Windows.Foundation.Rect) -> win32more.Microsoft.Graphics.Canvas.CanvasDrawingSession: ...
    @winrt_mixinmethod
    def SuspendDrawingSession(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualImageSource, drawingSession: win32more.Microsoft.Graphics.Canvas.CanvasDrawingSession) -> Void: ...
    @winrt_mixinmethod
    def ResumeDrawingSession(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualImageSource, drawingSession: win32more.Microsoft.Graphics.Canvas.CanvasDrawingSession) -> Void: ...
    @winrt_mixinmethod
    def Invalidate(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualImageSource) -> Void: ...
    @winrt_mixinmethod
    def InvalidateRegion(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualImageSource, region: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def RaiseRegionsInvalidatedIfAny(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualImageSource) -> Void: ...
    @winrt_mixinmethod
    def add_RegionsInvalidated(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualImageSource, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasVirtualImageSource, win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasRegionsInvalidatedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_RegionsInvalidated(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualImageSource, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def ResizeWithSize(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualImageSource, size: win32more.Windows.Foundation.Size) -> Void: ...
    @winrt_mixinmethod
    def ResizeWithWidthAndHeight(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualImageSource, width: Single, height: Single) -> Void: ...
    @winrt_mixinmethod
    def ResizeWithWidthAndHeightAndDpi(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualImageSource, width: Single, height: Single, dpi: Single) -> Void: ...
    @winrt_mixinmethod
    def Recreate(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualImageSource, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> Void: ...
    @winrt_mixinmethod
    def get_Size(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualImageSource) -> win32more.Windows.Foundation.Size: ...
    @winrt_mixinmethod
    def get_SizeInPixels(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualImageSource) -> win32more.Windows.Graphics.Imaging.BitmapSize: ...
    @winrt_mixinmethod
    def get_AlphaMode(self: win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualImageSource) -> win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode: ...
    @winrt_mixinmethod
    def get_Dpi(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi) -> Single: ...
    @winrt_mixinmethod
    def ConvertPixelsToDips(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, pixels: Int32) -> Single: ...
    @winrt_mixinmethod
    def ConvertDipsToPixels(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, dips: Single, dpiRounding: win32more.Microsoft.Graphics.Canvas.CanvasDpiRounding) -> Int32: ...
    @winrt_mixinmethod
    def get_Device(self: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    AlphaMode = property(get_AlphaMode, None)
    Device = property(get_Device, None)
    Dpi = property(get_Dpi, None)
    Size = property(get_Size, None)
    SizeInPixels = property(get_SizeInPixels, None)
    Source = property(get_Source, None)
    RegionsInvalidated = event()
class ICanvasAnimatedControl(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl'
    _iid_ = Guid('{9bd47d0d-d57d-43b7-82cb-489cc566e887}')
    @winrt_commethod(6)
    def add_CreateResources(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasAnimatedControl, win32more.Microsoft.Graphics.Canvas.UI.CanvasCreateResourcesEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(7)
    def remove_CreateResources(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(8)
    def add_Update(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl, win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasAnimatedUpdateEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(9)
    def remove_Update(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(10)
    def add_Draw(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl, win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasAnimatedDrawEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(11)
    def remove_Draw(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(12)
    def add_GameLoopStarting(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(13)
    def remove_GameLoopStarting(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(14)
    def add_GameLoopStopped(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedControl, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(15)
    def remove_GameLoopStopped(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(16)
    def get_ReadyToDraw(self) -> Boolean: ...
    @winrt_commethod(17)
    def put_IsFixedTimeStep(self, value: Boolean) -> Void: ...
    @winrt_commethod(18)
    def get_IsFixedTimeStep(self) -> Boolean: ...
    @winrt_commethod(19)
    def put_TargetElapsedTime(self, value: win32more.Windows.Foundation.TimeSpan) -> Void: ...
    @winrt_commethod(20)
    def get_TargetElapsedTime(self) -> win32more.Windows.Foundation.TimeSpan: ...
    @winrt_commethod(21)
    def put_Paused(self, value: Boolean) -> Void: ...
    @winrt_commethod(22)
    def get_Paused(self) -> Boolean: ...
    @winrt_commethod(23)
    def put_ClearColor(self, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(24)
    def get_ClearColor(self) -> win32more.Windows.UI.Color: ...
    @winrt_commethod(25)
    def get_Size(self) -> win32more.Windows.Foundation.Size: ...
    @winrt_commethod(26)
    def Invalidate(self) -> Void: ...
    @winrt_commethod(27)
    def ResetElapsedTime(self) -> Void: ...
    @winrt_commethod(28)
    def CreateCoreIndependentInputSource(self, deviceTypes: win32more.Microsoft.UI.Input.InputPointerSourceDeviceKinds) -> win32more.Microsoft.UI.Input.InputPointerSource: ...
    @winrt_commethod(29)
    def RemoveFromVisualTree(self) -> Void: ...
    @winrt_commethod(30)
    def get_HasGameLoopThreadAccess(self) -> Boolean: ...
    @winrt_commethod(31)
    def RunOnGameLoopThreadAsync(self, agileCallback: win32more.Microsoft.UI.Dispatching.DispatcherQueueHandler) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_commethod(32)
    def get_UseSharedDevice(self) -> Boolean: ...
    @winrt_commethod(33)
    def put_UseSharedDevice(self, value: Boolean) -> Void: ...
    @winrt_commethod(34)
    def get_ForceSoftwareRenderer(self) -> Boolean: ...
    @winrt_commethod(35)
    def put_ForceSoftwareRenderer(self, value: Boolean) -> Void: ...
    @winrt_commethod(36)
    def get_CustomDevice(self) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    @winrt_commethod(37)
    def put_CustomDevice(self, value: win32more.Microsoft.Graphics.Canvas.CanvasDevice) -> Void: ...
    @winrt_commethod(38)
    def get_DpiScale(self) -> Single: ...
    @winrt_commethod(39)
    def put_DpiScale(self, ratio: Single) -> Void: ...
    ClearColor = property(get_ClearColor, put_ClearColor)
    CustomDevice = property(get_CustomDevice, put_CustomDevice)
    DpiScale = property(get_DpiScale, put_DpiScale)
    ForceSoftwareRenderer = property(get_ForceSoftwareRenderer, put_ForceSoftwareRenderer)
    HasGameLoopThreadAccess = property(get_HasGameLoopThreadAccess, None)
    IsFixedTimeStep = property(get_IsFixedTimeStep, put_IsFixedTimeStep)
    Paused = property(get_Paused, put_Paused)
    ReadyToDraw = property(get_ReadyToDraw, None)
    Size = property(get_Size, None)
    TargetElapsedTime = property(get_TargetElapsedTime, put_TargetElapsedTime)
    UseSharedDevice = property(get_UseSharedDevice, put_UseSharedDevice)
    CreateResources = event()
    Update = event()
    Draw = event()
    GameLoopStarting = event()
    GameLoopStopped = event()
class ICanvasAnimatedDrawEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedDrawEventArgs'
    _iid_ = Guid('{bc01ff4d-ff6c-4d4d-a9e9-8eeb2139f23f}')
    @winrt_commethod(6)
    def get_DrawingSession(self) -> win32more.Microsoft.Graphics.Canvas.CanvasDrawingSession: ...
    @winrt_commethod(7)
    def get_Timing(self) -> win32more.Microsoft.Graphics.Canvas.UI.CanvasTimingInformation: ...
    DrawingSession = property(get_DrawingSession, None)
    Timing = property(get_Timing, None)
class ICanvasAnimatedDrawEventArgsFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedDrawEventArgsFactory'
    _iid_ = Guid('{c0c8fdac-0dfc-4e18-a6e9-9ef7dc82bcc2}')
    @winrt_commethod(6)
    def Create(self, canvasDrawingSession: win32more.Microsoft.Graphics.Canvas.CanvasDrawingSession, timingInformation: win32more.Microsoft.Graphics.Canvas.UI.CanvasTimingInformation) -> win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasAnimatedDrawEventArgs: ...
class ICanvasAnimatedUpdateEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedUpdateEventArgs'
    _iid_ = Guid('{a96b2b2a-0c6e-4aa8-925b-7137263b4e44}')
    @winrt_commethod(6)
    def get_Timing(self) -> win32more.Microsoft.Graphics.Canvas.UI.CanvasTimingInformation: ...
    Timing = property(get_Timing, None)
class ICanvasAnimatedUpdateEventArgsFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.UI.Xaml.ICanvasAnimatedUpdateEventArgsFactory'
    _iid_ = Guid('{766f4867-b22a-464b-89b1-0da6ab62be68}')
    @winrt_commethod(6)
    def Create(self, timingInformation: win32more.Microsoft.Graphics.Canvas.UI.CanvasTimingInformation) -> win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasAnimatedUpdateEventArgs: ...
class ICanvasControl(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.UI.Xaml.ICanvasControl'
    _iid_ = Guid('{f006e06d-79db-484f-b898-479cf069c0f5}')
    @winrt_commethod(6)
    def add_CreateResources(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasControl, win32more.Microsoft.Graphics.Canvas.UI.CanvasCreateResourcesEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(7)
    def remove_CreateResources(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(8)
    def get_ReadyToDraw(self) -> Boolean: ...
    @winrt_commethod(9)
    def add_Draw(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasControl, win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasDrawEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(10)
    def remove_Draw(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(11)
    def put_ClearColor(self, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(12)
    def get_ClearColor(self) -> win32more.Windows.UI.Color: ...
    @winrt_commethod(13)
    def Invalidate(self) -> Void: ...
    @winrt_commethod(14)
    def get_Size(self) -> win32more.Windows.Foundation.Size: ...
    @winrt_commethod(15)
    def RemoveFromVisualTree(self) -> Void: ...
    @winrt_commethod(16)
    def get_UseSharedDevice(self) -> Boolean: ...
    @winrt_commethod(17)
    def put_UseSharedDevice(self, value: Boolean) -> Void: ...
    @winrt_commethod(18)
    def get_ForceSoftwareRenderer(self) -> Boolean: ...
    @winrt_commethod(19)
    def put_ForceSoftwareRenderer(self, value: Boolean) -> Void: ...
    @winrt_commethod(20)
    def get_CustomDevice(self) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    @winrt_commethod(21)
    def put_CustomDevice(self, value: win32more.Microsoft.Graphics.Canvas.CanvasDevice) -> Void: ...
    @winrt_commethod(22)
    def get_DpiScale(self) -> Single: ...
    @winrt_commethod(23)
    def put_DpiScale(self, ratio: Single) -> Void: ...
    ClearColor = property(get_ClearColor, put_ClearColor)
    CustomDevice = property(get_CustomDevice, put_CustomDevice)
    DpiScale = property(get_DpiScale, put_DpiScale)
    ForceSoftwareRenderer = property(get_ForceSoftwareRenderer, put_ForceSoftwareRenderer)
    ReadyToDraw = property(get_ReadyToDraw, None)
    Size = property(get_Size, None)
    UseSharedDevice = property(get_UseSharedDevice, put_UseSharedDevice)
    CreateResources = event()
    Draw = event()
class ICanvasDrawEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.UI.Xaml.ICanvasDrawEventArgs'
    _iid_ = Guid('{fb86169f-25d4-4551-bd8f-214beaf0ac24}')
    @winrt_commethod(6)
    def get_DrawingSession(self) -> win32more.Microsoft.Graphics.Canvas.CanvasDrawingSession: ...
    DrawingSession = property(get_DrawingSession, None)
class ICanvasDrawEventArgsFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.UI.Xaml.ICanvasDrawEventArgsFactory'
    _iid_ = Guid('{7299d72c-f8e4-4a2f-9e30-7cdfccf31c44}')
    @winrt_commethod(6)
    def Create(self, canvasDrawingSession: win32more.Microsoft.Graphics.Canvas.CanvasDrawingSession) -> win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasDrawEventArgs: ...
class ICanvasImageSource(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.UI.Xaml.ICanvasImageSource'
    _iid_ = Guid('{3c35e87a-e881-4f44-b0d1-551413aec66d}')
    @winrt_commethod(6)
    def CreateDrawingSession(self, clearColor: win32more.Windows.UI.Color) -> win32more.Microsoft.Graphics.Canvas.CanvasDrawingSession: ...
    @winrt_commethod(7)
    def CreateDrawingSessionWithUpdateRectangle(self, clearColor: win32more.Windows.UI.Color, updateRectangle: win32more.Windows.Foundation.Rect) -> win32more.Microsoft.Graphics.Canvas.CanvasDrawingSession: ...
    @winrt_commethod(8)
    def Recreate(self, value: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> Void: ...
    @winrt_commethod(9)
    def get_Size(self) -> win32more.Windows.Foundation.Size: ...
    @winrt_commethod(10)
    def get_SizeInPixels(self) -> win32more.Windows.Graphics.Imaging.BitmapSize: ...
    @winrt_commethod(11)
    def get_AlphaMode(self) -> win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode: ...
    AlphaMode = property(get_AlphaMode, None)
    Size = property(get_Size, None)
    SizeInPixels = property(get_SizeInPixels, None)
class ICanvasImageSourceFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.UI.Xaml.ICanvasImageSourceFactory'
    _iid_ = Guid('{8596bedd-d7f7-4c6b-b1ad-41949035e084}')
    @winrt_commethod(6)
    def CreateWithSize(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, size: win32more.Windows.Foundation.Size) -> win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasImageSource: ...
    @winrt_commethod(7)
    def CreateWithWidthAndHeight(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, width: Single, height: Single) -> win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasImageSource: ...
    @winrt_commethod(8)
    def CreateWithWidthAndHeightAndDpi(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, width: Single, height: Single, dpi: Single) -> win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasImageSource: ...
    @winrt_commethod(9)
    def CreateWithWidthAndHeightAndDpiAndAlphaMode(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, width: Single, height: Single, dpi: Single, alphaMode: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasImageSource: ...
class ICanvasRegionsInvalidatedEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.UI.Xaml.ICanvasRegionsInvalidatedEventArgs'
    _iid_ = Guid('{3a21a204-f52f-4e7a-9b3f-94669819d981}')
    @winrt_commethod(6)
    def get_InvalidatedRegions(self) -> ReceiveArray[win32more.Windows.Foundation.Rect]: ...
    @winrt_commethod(7)
    def get_VisibleRegion(self) -> win32more.Windows.Foundation.Rect: ...
    InvalidatedRegions = property(get_InvalidatedRegions, None)
    VisibleRegion = property(get_VisibleRegion, None)
class ICanvasSwapChainPanel(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.UI.Xaml.ICanvasSwapChainPanel'
    _iid_ = Guid('{dbdccb96-147e-4a82-af3a-c91c7800daa7}')
    @winrt_commethod(6)
    def put_SwapChain(self, value: win32more.Microsoft.Graphics.Canvas.CanvasSwapChain) -> Void: ...
    @winrt_commethod(7)
    def get_SwapChain(self) -> win32more.Microsoft.Graphics.Canvas.CanvasSwapChain: ...
    @winrt_commethod(8)
    def RemoveFromVisualTree(self) -> Void: ...
    SwapChain = property(get_SwapChain, put_SwapChain)
class ICanvasVirtualControl(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualControl'
    _iid_ = Guid('{3c2b5177-7c61-41d2-95ae-fcfc92fd617a}')
    @winrt_commethod(6)
    def add_CreateResources(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasVirtualControl, win32more.Microsoft.Graphics.Canvas.UI.CanvasCreateResourcesEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(7)
    def remove_CreateResources(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(8)
    def get_ReadyToDraw(self) -> Boolean: ...
    @winrt_commethod(9)
    def add_RegionsInvalidated(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasVirtualControl, win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasRegionsInvalidatedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(10)
    def remove_RegionsInvalidated(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(11)
    def put_ClearColor(self, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(12)
    def get_ClearColor(self) -> win32more.Windows.UI.Color: ...
    @winrt_commethod(13)
    def CreateDrawingSession(self, updateRectangle: win32more.Windows.Foundation.Rect) -> win32more.Microsoft.Graphics.Canvas.CanvasDrawingSession: ...
    @winrt_commethod(14)
    def SuspendDrawingSession(self, drawingSession: win32more.Microsoft.Graphics.Canvas.CanvasDrawingSession) -> Void: ...
    @winrt_commethod(15)
    def ResumeDrawingSession(self, drawingSession: win32more.Microsoft.Graphics.Canvas.CanvasDrawingSession) -> Void: ...
    @winrt_commethod(16)
    def Invalidate(self) -> Void: ...
    @winrt_commethod(17)
    def InvalidateRegion(self, region: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_commethod(18)
    def get_Size(self) -> win32more.Windows.Foundation.Size: ...
    @winrt_commethod(19)
    def RemoveFromVisualTree(self) -> Void: ...
    @winrt_commethod(20)
    def get_UseSharedDevice(self) -> Boolean: ...
    @winrt_commethod(21)
    def put_UseSharedDevice(self, value: Boolean) -> Void: ...
    @winrt_commethod(22)
    def get_ForceSoftwareRenderer(self) -> Boolean: ...
    @winrt_commethod(23)
    def put_ForceSoftwareRenderer(self, value: Boolean) -> Void: ...
    @winrt_commethod(24)
    def get_CustomDevice(self) -> win32more.Microsoft.Graphics.Canvas.CanvasDevice: ...
    @winrt_commethod(25)
    def put_CustomDevice(self, value: win32more.Microsoft.Graphics.Canvas.CanvasDevice) -> Void: ...
    @winrt_commethod(26)
    def get_DpiScale(self) -> Single: ...
    @winrt_commethod(27)
    def put_DpiScale(self, ratio: Single) -> Void: ...
    ClearColor = property(get_ClearColor, put_ClearColor)
    CustomDevice = property(get_CustomDevice, put_CustomDevice)
    DpiScale = property(get_DpiScale, put_DpiScale)
    ForceSoftwareRenderer = property(get_ForceSoftwareRenderer, put_ForceSoftwareRenderer)
    ReadyToDraw = property(get_ReadyToDraw, None)
    Size = property(get_Size, None)
    UseSharedDevice = property(get_UseSharedDevice, put_UseSharedDevice)
    CreateResources = event()
    RegionsInvalidated = event()
class ICanvasVirtualImageSource(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualImageSource'
    _iid_ = Guid('{df342987-4fe6-4bcd-b885-2ad3e6ef9fce}')
    @winrt_commethod(6)
    def get_Source(self) -> win32more.Microsoft.UI.Xaml.Media.Imaging.VirtualSurfaceImageSource: ...
    @winrt_commethod(7)
    def CreateDrawingSession(self, clearColor: win32more.Windows.UI.Color, updateRectangle: win32more.Windows.Foundation.Rect) -> win32more.Microsoft.Graphics.Canvas.CanvasDrawingSession: ...
    @winrt_commethod(8)
    def SuspendDrawingSession(self, drawingSession: win32more.Microsoft.Graphics.Canvas.CanvasDrawingSession) -> Void: ...
    @winrt_commethod(9)
    def ResumeDrawingSession(self, drawingSession: win32more.Microsoft.Graphics.Canvas.CanvasDrawingSession) -> Void: ...
    @winrt_commethod(10)
    def Invalidate(self) -> Void: ...
    @winrt_commethod(11)
    def InvalidateRegion(self, region: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_commethod(12)
    def RaiseRegionsInvalidatedIfAny(self) -> Void: ...
    @winrt_commethod(13)
    def add_RegionsInvalidated(self, value: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasVirtualImageSource, win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasRegionsInvalidatedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(14)
    def remove_RegionsInvalidated(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(15)
    def ResizeWithSize(self, size: win32more.Windows.Foundation.Size) -> Void: ...
    @winrt_commethod(16)
    def ResizeWithWidthAndHeight(self, width: Single, height: Single) -> Void: ...
    @winrt_commethod(17)
    def ResizeWithWidthAndHeightAndDpi(self, width: Single, height: Single, dpi: Single) -> Void: ...
    @winrt_commethod(18)
    def Recreate(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator) -> Void: ...
    @winrt_commethod(19)
    def get_Size(self) -> win32more.Windows.Foundation.Size: ...
    @winrt_commethod(20)
    def get_SizeInPixels(self) -> win32more.Windows.Graphics.Imaging.BitmapSize: ...
    @winrt_commethod(21)
    def get_AlphaMode(self) -> win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode: ...
    AlphaMode = property(get_AlphaMode, None)
    Size = property(get_Size, None)
    SizeInPixels = property(get_SizeInPixels, None)
    Source = property(get_Source, None)
    RegionsInvalidated = event()
class ICanvasVirtualImageSourceFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Graphics.Canvas.UI.Xaml.ICanvasVirtualImageSourceFactory'
    _iid_ = Guid('{2fe755a1-307a-4623-9250-29590485bdb6}')
    @winrt_commethod(6)
    def CreateWithSize(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, size: win32more.Windows.Foundation.Size) -> win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasVirtualImageSource: ...
    @winrt_commethod(7)
    def CreateWithWidthAndHeight(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreatorWithDpi, width: Single, height: Single) -> win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasVirtualImageSource: ...
    @winrt_commethod(8)
    def CreateWithWidthAndHeightAndDpi(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, width: Single, height: Single, dpi: Single) -> win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasVirtualImageSource: ...
    @winrt_commethod(9)
    def CreateWithWidthAndHeightAndDpiAndAlphaMode(self, resourceCreator: win32more.Microsoft.Graphics.Canvas.ICanvasResourceCreator, width: Single, height: Single, dpi: Single, alphaMode: win32more.Microsoft.Graphics.Canvas.CanvasAlphaMode) -> win32more.Microsoft.Graphics.Canvas.UI.Xaml.CanvasVirtualImageSource: ...


make_ready(__name__)
