from __future__ import annotations
from win32more.winrt.prelude import *
import win32more.Microsoft.UI
import win32more.Microsoft.UI.Dispatching
import win32more.Microsoft.UI.Windowing
import win32more.Windows.Foundation
import win32more.Windows.Foundation.Collections
import win32more.Windows.Graphics
import win32more.Windows.UI
class AppWindow(ComPtr):
    extends: IInspectable
    default_interface: win32more.Microsoft.UI.Windowing.IAppWindow
    _classid_ = 'Microsoft.UI.Windowing.AppWindow'
    @winrt_mixinmethod
    def add_Closing(self: win32more.Microsoft.UI.Windowing.IAppWindow, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.UI.Windowing.AppWindow, win32more.Microsoft.UI.Windowing.AppWindowClosingEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def get_IsShownInSwitchers(self: win32more.Microsoft.UI.Windowing.IAppWindow) -> Boolean: ...
    @winrt_mixinmethod
    def put_IsShownInSwitchers(self: win32more.Microsoft.UI.Windowing.IAppWindow, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_IsVisible(self: win32more.Microsoft.UI.Windowing.IAppWindow) -> Boolean: ...
    @winrt_mixinmethod
    def get_OwnerWindowId(self: win32more.Microsoft.UI.Windowing.IAppWindow) -> win32more.Microsoft.UI.WindowId: ...
    @winrt_mixinmethod
    def get_Position(self: win32more.Microsoft.UI.Windowing.IAppWindow) -> win32more.Windows.Graphics.PointInt32: ...
    @winrt_mixinmethod
    def get_Presenter(self: win32more.Microsoft.UI.Windowing.IAppWindow) -> win32more.Microsoft.UI.Windowing.AppWindowPresenter: ...
    @winrt_mixinmethod
    def get_Size(self: win32more.Microsoft.UI.Windowing.IAppWindow) -> win32more.Windows.Graphics.SizeInt32: ...
    @winrt_mixinmethod
    def get_Title(self: win32more.Microsoft.UI.Windowing.IAppWindow) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Title(self: win32more.Microsoft.UI.Windowing.IAppWindow, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_TitleBar(self: win32more.Microsoft.UI.Windowing.IAppWindow) -> win32more.Microsoft.UI.Windowing.AppWindowTitleBar: ...
    @winrt_mixinmethod
    def Destroy(self: win32more.Microsoft.UI.Windowing.IAppWindow) -> Void: ...
    @winrt_mixinmethod
    def Hide(self: win32more.Microsoft.UI.Windowing.IAppWindow) -> Void: ...
    @winrt_mixinmethod
    def Move(self: win32more.Microsoft.UI.Windowing.IAppWindow, position: win32more.Windows.Graphics.PointInt32) -> Void: ...
    @winrt_mixinmethod
    def MoveAndResize(self: win32more.Microsoft.UI.Windowing.IAppWindow, rect: win32more.Windows.Graphics.RectInt32) -> Void: ...
    @winrt_mixinmethod
    def get_Id(self: win32more.Microsoft.UI.Windowing.IAppWindow) -> win32more.Microsoft.UI.WindowId: ...
    @winrt_mixinmethod
    def Resize(self: win32more.Microsoft.UI.Windowing.IAppWindow, size: win32more.Windows.Graphics.SizeInt32) -> Void: ...
    @winrt_mixinmethod
    def SetIcon(self: win32more.Microsoft.UI.Windowing.IAppWindow, iconPath: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def SetIconWithIconId(self: win32more.Microsoft.UI.Windowing.IAppWindow, iconId: win32more.Microsoft.UI.IconId) -> Void: ...
    @winrt_mixinmethod
    def SetPresenter(self: win32more.Microsoft.UI.Windowing.IAppWindow, appWindowPresenter: win32more.Microsoft.UI.Windowing.AppWindowPresenter) -> Void: ...
    @winrt_mixinmethod
    def SetPresenterByKind(self: win32more.Microsoft.UI.Windowing.IAppWindow, appWindowPresenterKind: win32more.Microsoft.UI.Windowing.AppWindowPresenterKind) -> Void: ...
    @winrt_mixinmethod
    def Show(self: win32more.Microsoft.UI.Windowing.IAppWindow) -> Void: ...
    @winrt_mixinmethod
    def ShowWithActivation(self: win32more.Microsoft.UI.Windowing.IAppWindow, activateWindow: Boolean) -> Void: ...
    @winrt_mixinmethod
    def add_Changed(self: win32more.Microsoft.UI.Windowing.IAppWindow, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.UI.Windowing.AppWindow, win32more.Microsoft.UI.Windowing.AppWindowChangedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_Changed(self: win32more.Microsoft.UI.Windowing.IAppWindow, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def MoveAndResizeRelativeToDisplayArea(self: win32more.Microsoft.UI.Windowing.IAppWindow, rect: win32more.Windows.Graphics.RectInt32, displayarea: win32more.Microsoft.UI.Windowing.DisplayArea) -> Void: ...
    @winrt_mixinmethod
    def remove_Closing(self: win32more.Microsoft.UI.Windowing.IAppWindow, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_Destroying(self: win32more.Microsoft.UI.Windowing.IAppWindow, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.UI.Windowing.AppWindow, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_Destroying(self: win32more.Microsoft.UI.Windowing.IAppWindow, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def get_ClientSize(self: win32more.Microsoft.UI.Windowing.IAppWindow2) -> win32more.Windows.Graphics.SizeInt32: ...
    @winrt_mixinmethod
    def MoveInZOrderAtBottom(self: win32more.Microsoft.UI.Windowing.IAppWindow2) -> Void: ...
    @winrt_mixinmethod
    def MoveInZOrderAtTop(self: win32more.Microsoft.UI.Windowing.IAppWindow2) -> Void: ...
    @winrt_mixinmethod
    def MoveInZOrderBelow(self: win32more.Microsoft.UI.Windowing.IAppWindow2, windowId: win32more.Microsoft.UI.WindowId) -> Void: ...
    @winrt_mixinmethod
    def ResizeClient(self: win32more.Microsoft.UI.Windowing.IAppWindow2, size: win32more.Windows.Graphics.SizeInt32) -> Void: ...
    @winrt_mixinmethod
    def ShowOnceWithRequestedStartupState(self: win32more.Microsoft.UI.Windowing.IAppWindow2) -> Void: ...
    @winrt_mixinmethod
    def AssociateWithDispatcherQueue(self: win32more.Microsoft.UI.Windowing.IAppWindow3, dispatcherQueue: win32more.Microsoft.UI.Dispatching.DispatcherQueue) -> Void: ...
    @winrt_mixinmethod
    def get_DispatcherQueue(self: win32more.Microsoft.UI.Windowing.IAppWindow3) -> win32more.Microsoft.UI.Dispatching.DispatcherQueue: ...
    @winrt_mixinmethod
    def SetTaskbarIcon(self: win32more.Microsoft.UI.Windowing.IAppWindow4, iconPath: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def SetTaskbarIconWithIconId(self: win32more.Microsoft.UI.Windowing.IAppWindow4, iconId: win32more.Microsoft.UI.IconId) -> Void: ...
    @winrt_mixinmethod
    def SetTitleBarIcon(self: win32more.Microsoft.UI.Windowing.IAppWindow4, iconPath: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def SetTitleBarIconWithIconId(self: win32more.Microsoft.UI.Windowing.IAppWindow4, iconId: win32more.Microsoft.UI.IconId) -> Void: ...
    @winrt_classmethod
    def CreateWithDispatcherQueue(cls: win32more.Microsoft.UI.Windowing.IAppWindowStatics2, appWindowPresenter: win32more.Microsoft.UI.Windowing.AppWindowPresenter, ownerWindowId: win32more.Microsoft.UI.WindowId, DispatcherQueue: win32more.Microsoft.UI.Dispatching.DispatcherQueue) -> win32more.Microsoft.UI.Windowing.AppWindow: ...
    @winrt_classmethod
    def Create(cls: win32more.Microsoft.UI.Windowing.IAppWindowStatics) -> win32more.Microsoft.UI.Windowing.AppWindow: ...
    @winrt_classmethod
    def CreateWithPresenter(cls: win32more.Microsoft.UI.Windowing.IAppWindowStatics, appWindowPresenter: win32more.Microsoft.UI.Windowing.AppWindowPresenter) -> win32more.Microsoft.UI.Windowing.AppWindow: ...
    @winrt_classmethod
    def CreateWithPresenterAndOwner(cls: win32more.Microsoft.UI.Windowing.IAppWindowStatics, appWindowPresenter: win32more.Microsoft.UI.Windowing.AppWindowPresenter, ownerWindowId: win32more.Microsoft.UI.WindowId) -> win32more.Microsoft.UI.Windowing.AppWindow: ...
    @winrt_classmethod
    def GetFromWindowId(cls: win32more.Microsoft.UI.Windowing.IAppWindowStatics, windowId: win32more.Microsoft.UI.WindowId) -> win32more.Microsoft.UI.Windowing.AppWindow: ...
    ClientSize = property(get_ClientSize, None)
    DispatcherQueue = property(get_DispatcherQueue, None)
    Id = property(get_Id, None)
    IsShownInSwitchers = property(get_IsShownInSwitchers, put_IsShownInSwitchers)
    IsVisible = property(get_IsVisible, None)
    OwnerWindowId = property(get_OwnerWindowId, None)
    Position = property(get_Position, None)
    Presenter = property(get_Presenter, None)
    Size = property(get_Size, None)
    Title = property(get_Title, put_Title)
    TitleBar = property(get_TitleBar, None)
    Closing = event()
    Changed = event()
    Destroying = event()
class AppWindowChangedEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Microsoft.UI.Windowing.IAppWindowChangedEventArgs
    _classid_ = 'Microsoft.UI.Windowing.AppWindowChangedEventArgs'
    @winrt_mixinmethod
    def get_DidPresenterChange(self: win32more.Microsoft.UI.Windowing.IAppWindowChangedEventArgs) -> Boolean: ...
    @winrt_mixinmethod
    def get_DidPositionChange(self: win32more.Microsoft.UI.Windowing.IAppWindowChangedEventArgs) -> Boolean: ...
    @winrt_mixinmethod
    def get_DidSizeChange(self: win32more.Microsoft.UI.Windowing.IAppWindowChangedEventArgs) -> Boolean: ...
    @winrt_mixinmethod
    def get_DidVisibilityChange(self: win32more.Microsoft.UI.Windowing.IAppWindowChangedEventArgs) -> Boolean: ...
    @winrt_mixinmethod
    def get_DidZOrderChange(self: win32more.Microsoft.UI.Windowing.IAppWindowChangedEventArgs2) -> Boolean: ...
    @winrt_mixinmethod
    def get_IsZOrderAtBottom(self: win32more.Microsoft.UI.Windowing.IAppWindowChangedEventArgs2) -> Boolean: ...
    @winrt_mixinmethod
    def get_IsZOrderAtTop(self: win32more.Microsoft.UI.Windowing.IAppWindowChangedEventArgs2) -> Boolean: ...
    @winrt_mixinmethod
    def get_ZOrderBelowWindowId(self: win32more.Microsoft.UI.Windowing.IAppWindowChangedEventArgs2) -> win32more.Microsoft.UI.WindowId: ...
    DidPositionChange = property(get_DidPositionChange, None)
    DidPresenterChange = property(get_DidPresenterChange, None)
    DidSizeChange = property(get_DidSizeChange, None)
    DidVisibilityChange = property(get_DidVisibilityChange, None)
    DidZOrderChange = property(get_DidZOrderChange, None)
    IsZOrderAtBottom = property(get_IsZOrderAtBottom, None)
    IsZOrderAtTop = property(get_IsZOrderAtTop, None)
    ZOrderBelowWindowId = property(get_ZOrderBelowWindowId, None)
class AppWindowClosingEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Microsoft.UI.Windowing.IAppWindowClosingEventArgs
    _classid_ = 'Microsoft.UI.Windowing.AppWindowClosingEventArgs'
    @winrt_mixinmethod
    def get_Cancel(self: win32more.Microsoft.UI.Windowing.IAppWindowClosingEventArgs) -> Boolean: ...
    @winrt_mixinmethod
    def put_Cancel(self: win32more.Microsoft.UI.Windowing.IAppWindowClosingEventArgs, value: Boolean) -> Void: ...
    Cancel = property(get_Cancel, put_Cancel)
class AppWindowPresenter(ComPtr):
    extends: IInspectable
    default_interface: win32more.Microsoft.UI.Windowing.IAppWindowPresenter
    _classid_ = 'Microsoft.UI.Windowing.AppWindowPresenter'
    @winrt_mixinmethod
    def get_Kind(self: win32more.Microsoft.UI.Windowing.IAppWindowPresenter) -> win32more.Microsoft.UI.Windowing.AppWindowPresenterKind: ...
    Kind = property(get_Kind, None)
class AppWindowPresenterKind(Enum, Int32):
    Default = 0
    CompactOverlay = 1
    FullScreen = 2
    Overlapped = 3
class AppWindowTitleBar(ComPtr):
    extends: IInspectable
    default_interface: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar
    _classid_ = 'Microsoft.UI.Windowing.AppWindowTitleBar'
    @winrt_mixinmethod
    def put_ButtonPressedBackgroundColor(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar, value: win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]) -> Void: ...
    @winrt_mixinmethod
    def put_BackgroundColor(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar, value: win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]) -> Void: ...
    @winrt_mixinmethod
    def get_ButtonBackgroundColor(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar) -> win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]: ...
    @winrt_mixinmethod
    def put_ButtonBackgroundColor(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar, value: win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]) -> Void: ...
    @winrt_mixinmethod
    def get_ButtonForegroundColor(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar) -> win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]: ...
    @winrt_mixinmethod
    def put_ButtonForegroundColor(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar, value: win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]) -> Void: ...
    @winrt_mixinmethod
    def get_ButtonHoverBackgroundColor(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar) -> win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]: ...
    @winrt_mixinmethod
    def put_ButtonHoverBackgroundColor(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar, value: win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]) -> Void: ...
    @winrt_mixinmethod
    def get_ButtonHoverForegroundColor(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar) -> win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]: ...
    @winrt_mixinmethod
    def put_ButtonHoverForegroundColor(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar, value: win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]) -> Void: ...
    @winrt_mixinmethod
    def get_ButtonInactiveBackgroundColor(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar) -> win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]: ...
    @winrt_mixinmethod
    def put_ButtonInactiveBackgroundColor(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar, value: win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]) -> Void: ...
    @winrt_mixinmethod
    def get_BackgroundColor(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar) -> win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]: ...
    @winrt_mixinmethod
    def put_ButtonInactiveForegroundColor(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar, value: win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]) -> Void: ...
    @winrt_mixinmethod
    def get_ButtonPressedBackgroundColor(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar) -> win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]: ...
    @winrt_mixinmethod
    def get_ButtonInactiveForegroundColor(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar) -> win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]: ...
    @winrt_mixinmethod
    def get_ButtonPressedForegroundColor(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar) -> win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]: ...
    @winrt_mixinmethod
    def put_ButtonPressedForegroundColor(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar, value: win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]) -> Void: ...
    @winrt_mixinmethod
    def get_ExtendsContentIntoTitleBar(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar) -> Boolean: ...
    @winrt_mixinmethod
    def put_ExtendsContentIntoTitleBar(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_ForegroundColor(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar) -> win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]: ...
    @winrt_mixinmethod
    def put_ForegroundColor(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar, value: win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]) -> Void: ...
    @winrt_mixinmethod
    def get_Height(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar) -> Int32: ...
    @winrt_mixinmethod
    def get_IconShowOptions(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar) -> win32more.Microsoft.UI.Windowing.IconShowOptions: ...
    @winrt_mixinmethod
    def put_IconShowOptions(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar, value: win32more.Microsoft.UI.Windowing.IconShowOptions) -> Void: ...
    @winrt_mixinmethod
    def get_InactiveBackgroundColor(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar) -> win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]: ...
    @winrt_mixinmethod
    def put_InactiveBackgroundColor(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar, value: win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]) -> Void: ...
    @winrt_mixinmethod
    def get_InactiveForegroundColor(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar) -> win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]: ...
    @winrt_mixinmethod
    def put_InactiveForegroundColor(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar, value: win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]) -> Void: ...
    @winrt_mixinmethod
    def get_LeftInset(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar) -> Int32: ...
    @winrt_mixinmethod
    def get_RightInset(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar) -> Int32: ...
    @winrt_mixinmethod
    def ResetToDefault(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar) -> Void: ...
    @winrt_mixinmethod
    def SetDragRectangles(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar, value: PassArray[win32more.Windows.Graphics.RectInt32]) -> Void: ...
    @winrt_mixinmethod
    def get_PreferredHeightOption(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar2) -> win32more.Microsoft.UI.Windowing.TitleBarHeightOption: ...
    @winrt_mixinmethod
    def put_PreferredHeightOption(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar2, value: win32more.Microsoft.UI.Windowing.TitleBarHeightOption) -> Void: ...
    @winrt_mixinmethod
    def get_PreferredTheme(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar3) -> win32more.Microsoft.UI.Windowing.TitleBarTheme: ...
    @winrt_mixinmethod
    def put_PreferredTheme(self: win32more.Microsoft.UI.Windowing.IAppWindowTitleBar3, value: win32more.Microsoft.UI.Windowing.TitleBarTheme) -> Void: ...
    @winrt_classmethod
    def IsCustomizationSupported(cls: win32more.Microsoft.UI.Windowing.IAppWindowTitleBarStatics) -> Boolean: ...
    BackgroundColor = property(get_BackgroundColor, put_BackgroundColor)
    ButtonBackgroundColor = property(get_ButtonBackgroundColor, put_ButtonBackgroundColor)
    ButtonForegroundColor = property(get_ButtonForegroundColor, put_ButtonForegroundColor)
    ButtonHoverBackgroundColor = property(get_ButtonHoverBackgroundColor, put_ButtonHoverBackgroundColor)
    ButtonHoverForegroundColor = property(get_ButtonHoverForegroundColor, put_ButtonHoverForegroundColor)
    ButtonInactiveBackgroundColor = property(get_ButtonInactiveBackgroundColor, put_ButtonInactiveBackgroundColor)
    ButtonInactiveForegroundColor = property(get_ButtonInactiveForegroundColor, put_ButtonInactiveForegroundColor)
    ButtonPressedBackgroundColor = property(get_ButtonPressedBackgroundColor, put_ButtonPressedBackgroundColor)
    ButtonPressedForegroundColor = property(get_ButtonPressedForegroundColor, put_ButtonPressedForegroundColor)
    ExtendsContentIntoTitleBar = property(get_ExtendsContentIntoTitleBar, put_ExtendsContentIntoTitleBar)
    ForegroundColor = property(get_ForegroundColor, put_ForegroundColor)
    Height = property(get_Height, None)
    IconShowOptions = property(get_IconShowOptions, put_IconShowOptions)
    InactiveBackgroundColor = property(get_InactiveBackgroundColor, put_InactiveBackgroundColor)
    InactiveForegroundColor = property(get_InactiveForegroundColor, put_InactiveForegroundColor)
    LeftInset = property(get_LeftInset, None)
    PreferredHeightOption = property(get_PreferredHeightOption, put_PreferredHeightOption)
    PreferredTheme = property(get_PreferredTheme, put_PreferredTheme)
    RightInset = property(get_RightInset, None)
class CompactOverlayPresenter(ComPtr):
    extends: win32more.Microsoft.UI.Windowing.AppWindowPresenter
    default_interface: win32more.Microsoft.UI.Windowing.ICompactOverlayPresenter
    _classid_ = 'Microsoft.UI.Windowing.CompactOverlayPresenter'
    @winrt_mixinmethod
    def get_InitialSize(self: win32more.Microsoft.UI.Windowing.ICompactOverlayPresenter) -> win32more.Microsoft.UI.Windowing.CompactOverlaySize: ...
    @winrt_mixinmethod
    def put_InitialSize(self: win32more.Microsoft.UI.Windowing.ICompactOverlayPresenter, value: win32more.Microsoft.UI.Windowing.CompactOverlaySize) -> Void: ...
    @winrt_classmethod
    def Create(cls: win32more.Microsoft.UI.Windowing.ICompactOverlayPresenterStatics) -> win32more.Microsoft.UI.Windowing.CompactOverlayPresenter: ...
    InitialSize = property(get_InitialSize, put_InitialSize)
class CompactOverlaySize(Enum, Int32):
    Small = 0
    Medium = 1
    Large = 2
class _DisplayArea_Meta_(ComPtr.__class__):
    pass
class DisplayArea(ComPtr, metaclass=_DisplayArea_Meta_):
    extends: IInspectable
    default_interface: win32more.Microsoft.UI.Windowing.IDisplayArea
    _classid_ = 'Microsoft.UI.Windowing.DisplayArea'
    @winrt_mixinmethod
    def get_OuterBounds(self: win32more.Microsoft.UI.Windowing.IDisplayArea) -> win32more.Windows.Graphics.RectInt32: ...
    @winrt_mixinmethod
    def get_IsPrimary(self: win32more.Microsoft.UI.Windowing.IDisplayArea) -> Boolean: ...
    @winrt_mixinmethod
    def get_DisplayId(self: win32more.Microsoft.UI.Windowing.IDisplayArea) -> win32more.Microsoft.UI.DisplayId: ...
    @winrt_mixinmethod
    def get_WorkArea(self: win32more.Microsoft.UI.Windowing.IDisplayArea) -> win32more.Windows.Graphics.RectInt32: ...
    @winrt_classmethod
    def GetFromDisplayId(cls: win32more.Microsoft.UI.Windowing.IDisplayAreaStatics2, displayId: win32more.Microsoft.UI.DisplayId) -> win32more.Microsoft.UI.Windowing.DisplayArea: ...
    @winrt_classmethod
    def get_Primary(cls: win32more.Microsoft.UI.Windowing.IDisplayAreaStatics) -> win32more.Microsoft.UI.Windowing.DisplayArea: ...
    @winrt_classmethod
    def CreateWatcher(cls: win32more.Microsoft.UI.Windowing.IDisplayAreaStatics) -> win32more.Microsoft.UI.Windowing.DisplayAreaWatcher: ...
    @winrt_classmethod
    def FindAll(cls: win32more.Microsoft.UI.Windowing.IDisplayAreaStatics) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Microsoft.UI.Windowing.DisplayArea]: ...
    @winrt_classmethod
    def GetFromWindowId(cls: win32more.Microsoft.UI.Windowing.IDisplayAreaStatics, windowId: win32more.Microsoft.UI.WindowId, displayAreaFallback: win32more.Microsoft.UI.Windowing.DisplayAreaFallback) -> win32more.Microsoft.UI.Windowing.DisplayArea: ...
    @winrt_classmethod
    def GetFromPoint(cls: win32more.Microsoft.UI.Windowing.IDisplayAreaStatics, point: win32more.Windows.Graphics.PointInt32, displayAreaFallback: win32more.Microsoft.UI.Windowing.DisplayAreaFallback) -> win32more.Microsoft.UI.Windowing.DisplayArea: ...
    @winrt_classmethod
    def GetFromRect(cls: win32more.Microsoft.UI.Windowing.IDisplayAreaStatics, rect: win32more.Windows.Graphics.RectInt32, displayAreaFallback: win32more.Microsoft.UI.Windowing.DisplayAreaFallback) -> win32more.Microsoft.UI.Windowing.DisplayArea: ...
    DisplayId = property(get_DisplayId, None)
    IsPrimary = property(get_IsPrimary, None)
    OuterBounds = property(get_OuterBounds, None)
    WorkArea = property(get_WorkArea, None)
    _DisplayArea_Meta_.Primary = property(get_Primary, None)
class DisplayAreaFallback(Enum, Int32):
    None_ = 0
    Primary = 1
    Nearest = 2
class DisplayAreaWatcher(ComPtr):
    extends: IInspectable
    default_interface: win32more.Microsoft.UI.Windowing.IDisplayAreaWatcher
    _classid_ = 'Microsoft.UI.Windowing.DisplayAreaWatcher'
    @winrt_mixinmethod
    def remove_Added(self: win32more.Microsoft.UI.Windowing.IDisplayAreaWatcher, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def Start(self: win32more.Microsoft.UI.Windowing.IDisplayAreaWatcher) -> Void: ...
    @winrt_mixinmethod
    def Stop(self: win32more.Microsoft.UI.Windowing.IDisplayAreaWatcher) -> Void: ...
    @winrt_mixinmethod
    def add_Added(self: win32more.Microsoft.UI.Windowing.IDisplayAreaWatcher, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.UI.Windowing.DisplayAreaWatcher, win32more.Microsoft.UI.Windowing.DisplayArea]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def get_Status(self: win32more.Microsoft.UI.Windowing.IDisplayAreaWatcher) -> win32more.Microsoft.UI.Windowing.DisplayAreaWatcherStatus: ...
    @winrt_mixinmethod
    def add_EnumerationCompleted(self: win32more.Microsoft.UI.Windowing.IDisplayAreaWatcher, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.UI.Windowing.DisplayAreaWatcher, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_EnumerationCompleted(self: win32more.Microsoft.UI.Windowing.IDisplayAreaWatcher, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_Removed(self: win32more.Microsoft.UI.Windowing.IDisplayAreaWatcher, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.UI.Windowing.DisplayAreaWatcher, win32more.Microsoft.UI.Windowing.DisplayArea]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_Removed(self: win32more.Microsoft.UI.Windowing.IDisplayAreaWatcher, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_Stopped(self: win32more.Microsoft.UI.Windowing.IDisplayAreaWatcher, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.UI.Windowing.DisplayAreaWatcher, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_Stopped(self: win32more.Microsoft.UI.Windowing.IDisplayAreaWatcher, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_Updated(self: win32more.Microsoft.UI.Windowing.IDisplayAreaWatcher, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.UI.Windowing.DisplayAreaWatcher, win32more.Microsoft.UI.Windowing.DisplayArea]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_Updated(self: win32more.Microsoft.UI.Windowing.IDisplayAreaWatcher, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    Status = property(get_Status, None)
    Added = event()
    EnumerationCompleted = event()
    Removed = event()
    Stopped = event()
    Updated = event()
class DisplayAreaWatcherStatus(Enum, Int32):
    Created = 0
    Started = 1
    EnumerationCompleted = 2
    Stopping = 3
    Stopped = 4
    Aborted = 5
class FullScreenPresenter(ComPtr):
    extends: win32more.Microsoft.UI.Windowing.AppWindowPresenter
    default_interface: win32more.Microsoft.UI.Windowing.IFullScreenPresenter
    _classid_ = 'Microsoft.UI.Windowing.FullScreenPresenter'
    @winrt_classmethod
    def Create(cls: win32more.Microsoft.UI.Windowing.IFullScreenPresenterStatics) -> win32more.Microsoft.UI.Windowing.FullScreenPresenter: ...
class IAppWindow(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.UI.Windowing.IAppWindow'
    _iid_ = Guid('{cfa788b3-643b-5c5e-ad4e-321d48a82acd}')
    @winrt_commethod(6)
    def get_Id(self) -> win32more.Microsoft.UI.WindowId: ...
    @winrt_commethod(7)
    def get_IsShownInSwitchers(self) -> Boolean: ...
    @winrt_commethod(8)
    def put_IsShownInSwitchers(self, value: Boolean) -> Void: ...
    @winrt_commethod(9)
    def get_IsVisible(self) -> Boolean: ...
    @winrt_commethod(10)
    def get_OwnerWindowId(self) -> win32more.Microsoft.UI.WindowId: ...
    @winrt_commethod(11)
    def get_Position(self) -> win32more.Windows.Graphics.PointInt32: ...
    @winrt_commethod(12)
    def get_Presenter(self) -> win32more.Microsoft.UI.Windowing.AppWindowPresenter: ...
    @winrt_commethod(13)
    def get_Size(self) -> win32more.Windows.Graphics.SizeInt32: ...
    @winrt_commethod(14)
    def get_Title(self) -> WinRT_String: ...
    @winrt_commethod(15)
    def put_Title(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(16)
    def get_TitleBar(self) -> win32more.Microsoft.UI.Windowing.AppWindowTitleBar: ...
    @winrt_commethod(17)
    def Destroy(self) -> Void: ...
    @winrt_commethod(18)
    def Hide(self) -> Void: ...
    @winrt_commethod(19)
    def Move(self, position: win32more.Windows.Graphics.PointInt32) -> Void: ...
    @winrt_commethod(20)
    def MoveAndResize(self, rect: win32more.Windows.Graphics.RectInt32) -> Void: ...
    @winrt_commethod(21)
    def MoveAndResizeRelativeToDisplayArea(self, rect: win32more.Windows.Graphics.RectInt32, displayarea: win32more.Microsoft.UI.Windowing.DisplayArea) -> Void: ...
    @winrt_commethod(22)
    def Resize(self, size: win32more.Windows.Graphics.SizeInt32) -> Void: ...
    @winrt_commethod(23)
    def SetIcon(self, iconPath: WinRT_String) -> Void: ...
    @winrt_commethod(24)
    def SetIconWithIconId(self, iconId: win32more.Microsoft.UI.IconId) -> Void: ...
    @winrt_commethod(25)
    def SetPresenter(self, appWindowPresenter: win32more.Microsoft.UI.Windowing.AppWindowPresenter) -> Void: ...
    @winrt_commethod(26)
    def SetPresenterByKind(self, appWindowPresenterKind: win32more.Microsoft.UI.Windowing.AppWindowPresenterKind) -> Void: ...
    @winrt_commethod(27)
    def Show(self) -> Void: ...
    @winrt_commethod(28)
    def ShowWithActivation(self, activateWindow: Boolean) -> Void: ...
    @winrt_commethod(29)
    def add_Changed(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.UI.Windowing.AppWindow, win32more.Microsoft.UI.Windowing.AppWindowChangedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(30)
    def remove_Changed(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(31)
    def add_Closing(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.UI.Windowing.AppWindow, win32more.Microsoft.UI.Windowing.AppWindowClosingEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(32)
    def remove_Closing(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(33)
    def add_Destroying(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.UI.Windowing.AppWindow, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(34)
    def remove_Destroying(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    Id = property(get_Id, None)
    IsShownInSwitchers = property(get_IsShownInSwitchers, put_IsShownInSwitchers)
    IsVisible = property(get_IsVisible, None)
    OwnerWindowId = property(get_OwnerWindowId, None)
    Position = property(get_Position, None)
    Presenter = property(get_Presenter, None)
    Size = property(get_Size, None)
    Title = property(get_Title, put_Title)
    TitleBar = property(get_TitleBar, None)
    Changed = event()
    Closing = event()
    Destroying = event()
class IAppWindow2(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.UI.Windowing.IAppWindow2'
    _iid_ = Guid('{6cd41292-794c-5cac-8961-210d012c6ebc}')
    @winrt_commethod(6)
    def get_ClientSize(self) -> win32more.Windows.Graphics.SizeInt32: ...
    @winrt_commethod(7)
    def MoveInZOrderAtBottom(self) -> Void: ...
    @winrt_commethod(8)
    def MoveInZOrderAtTop(self) -> Void: ...
    @winrt_commethod(9)
    def MoveInZOrderBelow(self, windowId: win32more.Microsoft.UI.WindowId) -> Void: ...
    @winrt_commethod(10)
    def ResizeClient(self, size: win32more.Windows.Graphics.SizeInt32) -> Void: ...
    @winrt_commethod(11)
    def ShowOnceWithRequestedStartupState(self) -> Void: ...
    ClientSize = property(get_ClientSize, None)
class IAppWindow3(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.UI.Windowing.IAppWindow3'
    _iid_ = Guid('{2f260cea-193d-5dd6-a904-d7649a608d2f}')
    @winrt_commethod(6)
    def AssociateWithDispatcherQueue(self, dispatcherQueue: win32more.Microsoft.UI.Dispatching.DispatcherQueue) -> Void: ...
    @winrt_commethod(7)
    def get_DispatcherQueue(self) -> win32more.Microsoft.UI.Dispatching.DispatcherQueue: ...
    DispatcherQueue = property(get_DispatcherQueue, None)
class IAppWindow4(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.UI.Windowing.IAppWindow4'
    _iid_ = Guid('{383bfb91-ea29-5414-80cd-6c76d981eb31}')
    @winrt_commethod(6)
    def SetTaskbarIcon(self, iconPath: WinRT_String) -> Void: ...
    @winrt_commethod(7)
    def SetTaskbarIconWithIconId(self, iconId: win32more.Microsoft.UI.IconId) -> Void: ...
    @winrt_commethod(8)
    def SetTitleBarIcon(self, iconPath: WinRT_String) -> Void: ...
    @winrt_commethod(9)
    def SetTitleBarIconWithIconId(self, iconId: win32more.Microsoft.UI.IconId) -> Void: ...
class IAppWindowChangedEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.UI.Windowing.IAppWindowChangedEventArgs'
    _iid_ = Guid('{2182bc5d-fdac-5c3e-bf37-7d8d684e9d1d}')
    @winrt_commethod(6)
    def get_DidPositionChange(self) -> Boolean: ...
    @winrt_commethod(7)
    def get_DidPresenterChange(self) -> Boolean: ...
    @winrt_commethod(8)
    def get_DidSizeChange(self) -> Boolean: ...
    @winrt_commethod(9)
    def get_DidVisibilityChange(self) -> Boolean: ...
    DidPositionChange = property(get_DidPositionChange, None)
    DidPresenterChange = property(get_DidPresenterChange, None)
    DidSizeChange = property(get_DidSizeChange, None)
    DidVisibilityChange = property(get_DidVisibilityChange, None)
class IAppWindowChangedEventArgs2(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.UI.Windowing.IAppWindowChangedEventArgs2'
    _iid_ = Guid('{a773ab4c-a5ec-50e8-98ac-247fe6cd4227}')
    @winrt_commethod(6)
    def get_DidZOrderChange(self) -> Boolean: ...
    @winrt_commethod(7)
    def get_IsZOrderAtBottom(self) -> Boolean: ...
    @winrt_commethod(8)
    def get_IsZOrderAtTop(self) -> Boolean: ...
    @winrt_commethod(9)
    def get_ZOrderBelowWindowId(self) -> win32more.Microsoft.UI.WindowId: ...
    DidZOrderChange = property(get_DidZOrderChange, None)
    IsZOrderAtBottom = property(get_IsZOrderAtBottom, None)
    IsZOrderAtTop = property(get_IsZOrderAtTop, None)
    ZOrderBelowWindowId = property(get_ZOrderBelowWindowId, None)
class IAppWindowClosingEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.UI.Windowing.IAppWindowClosingEventArgs'
    _iid_ = Guid('{0e09d90b-2261-590b-9ad1-8504991d8754}')
    @winrt_commethod(6)
    def get_Cancel(self) -> Boolean: ...
    @winrt_commethod(7)
    def put_Cancel(self, value: Boolean) -> Void: ...
    Cancel = property(get_Cancel, put_Cancel)
class IAppWindowPresenter(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.UI.Windowing.IAppWindowPresenter'
    _iid_ = Guid('{bc3042c2-c6c6-5632-8989-ff0ec6d3b40d}')
    @winrt_commethod(6)
    def get_Kind(self) -> win32more.Microsoft.UI.Windowing.AppWindowPresenterKind: ...
    Kind = property(get_Kind, None)
class IAppWindowPresenterFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.UI.Windowing.IAppWindowPresenterFactory'
    _iid_ = Guid('{62082e3c-1368-5238-90d1-e932dc718a82}')
class IAppWindowStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.UI.Windowing.IAppWindowStatics'
    _iid_ = Guid('{3c315c24-d540-5d72-b518-b226b83627cb}')
    @winrt_commethod(6)
    def Create(self) -> win32more.Microsoft.UI.Windowing.AppWindow: ...
    @winrt_commethod(7)
    def CreateWithPresenter(self, appWindowPresenter: win32more.Microsoft.UI.Windowing.AppWindowPresenter) -> win32more.Microsoft.UI.Windowing.AppWindow: ...
    @winrt_commethod(8)
    def CreateWithPresenterAndOwner(self, appWindowPresenter: win32more.Microsoft.UI.Windowing.AppWindowPresenter, ownerWindowId: win32more.Microsoft.UI.WindowId) -> win32more.Microsoft.UI.Windowing.AppWindow: ...
    @winrt_commethod(9)
    def GetFromWindowId(self, windowId: win32more.Microsoft.UI.WindowId) -> win32more.Microsoft.UI.Windowing.AppWindow: ...
class IAppWindowStatics2(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.UI.Windowing.IAppWindowStatics2'
    _iid_ = Guid('{cabc23db-4606-5d6e-89a5-06de1d8bd3e2}')
    @winrt_commethod(6)
    def CreateWithDispatcherQueue(self, appWindowPresenter: win32more.Microsoft.UI.Windowing.AppWindowPresenter, ownerWindowId: win32more.Microsoft.UI.WindowId, DispatcherQueue: win32more.Microsoft.UI.Dispatching.DispatcherQueue) -> win32more.Microsoft.UI.Windowing.AppWindow: ...
class IAppWindowTitleBar(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.UI.Windowing.IAppWindowTitleBar'
    _iid_ = Guid('{5574efa2-c91c-5700-a363-539c71a7aaf4}')
    @winrt_commethod(6)
    def get_BackgroundColor(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]: ...
    @winrt_commethod(7)
    def put_BackgroundColor(self, value: win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]) -> Void: ...
    @winrt_commethod(8)
    def get_ButtonBackgroundColor(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]: ...
    @winrt_commethod(9)
    def put_ButtonBackgroundColor(self, value: win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]) -> Void: ...
    @winrt_commethod(10)
    def get_ButtonForegroundColor(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]: ...
    @winrt_commethod(11)
    def put_ButtonForegroundColor(self, value: win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]) -> Void: ...
    @winrt_commethod(12)
    def get_ButtonHoverBackgroundColor(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]: ...
    @winrt_commethod(13)
    def put_ButtonHoverBackgroundColor(self, value: win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]) -> Void: ...
    @winrt_commethod(14)
    def get_ButtonHoverForegroundColor(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]: ...
    @winrt_commethod(15)
    def put_ButtonHoverForegroundColor(self, value: win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]) -> Void: ...
    @winrt_commethod(16)
    def get_ButtonInactiveBackgroundColor(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]: ...
    @winrt_commethod(17)
    def put_ButtonInactiveBackgroundColor(self, value: win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]) -> Void: ...
    @winrt_commethod(18)
    def get_ButtonInactiveForegroundColor(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]: ...
    @winrt_commethod(19)
    def put_ButtonInactiveForegroundColor(self, value: win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]) -> Void: ...
    @winrt_commethod(20)
    def get_ButtonPressedBackgroundColor(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]: ...
    @winrt_commethod(21)
    def put_ButtonPressedBackgroundColor(self, value: win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]) -> Void: ...
    @winrt_commethod(22)
    def get_ButtonPressedForegroundColor(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]: ...
    @winrt_commethod(23)
    def put_ButtonPressedForegroundColor(self, value: win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]) -> Void: ...
    @winrt_commethod(24)
    def get_ExtendsContentIntoTitleBar(self) -> Boolean: ...
    @winrt_commethod(25)
    def put_ExtendsContentIntoTitleBar(self, value: Boolean) -> Void: ...
    @winrt_commethod(26)
    def get_ForegroundColor(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]: ...
    @winrt_commethod(27)
    def put_ForegroundColor(self, value: win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]) -> Void: ...
    @winrt_commethod(28)
    def get_Height(self) -> Int32: ...
    @winrt_commethod(29)
    def get_IconShowOptions(self) -> win32more.Microsoft.UI.Windowing.IconShowOptions: ...
    @winrt_commethod(30)
    def put_IconShowOptions(self, value: win32more.Microsoft.UI.Windowing.IconShowOptions) -> Void: ...
    @winrt_commethod(31)
    def get_InactiveBackgroundColor(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]: ...
    @winrt_commethod(32)
    def put_InactiveBackgroundColor(self, value: win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]) -> Void: ...
    @winrt_commethod(33)
    def get_InactiveForegroundColor(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]: ...
    @winrt_commethod(34)
    def put_InactiveForegroundColor(self, value: win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]) -> Void: ...
    @winrt_commethod(35)
    def get_LeftInset(self) -> Int32: ...
    @winrt_commethod(36)
    def get_RightInset(self) -> Int32: ...
    @winrt_commethod(37)
    def ResetToDefault(self) -> Void: ...
    @winrt_commethod(38)
    def SetDragRectangles(self, value: PassArray[win32more.Windows.Graphics.RectInt32]) -> Void: ...
    BackgroundColor = property(get_BackgroundColor, put_BackgroundColor)
    ButtonBackgroundColor = property(get_ButtonBackgroundColor, put_ButtonBackgroundColor)
    ButtonForegroundColor = property(get_ButtonForegroundColor, put_ButtonForegroundColor)
    ButtonHoverBackgroundColor = property(get_ButtonHoverBackgroundColor, put_ButtonHoverBackgroundColor)
    ButtonHoverForegroundColor = property(get_ButtonHoverForegroundColor, put_ButtonHoverForegroundColor)
    ButtonInactiveBackgroundColor = property(get_ButtonInactiveBackgroundColor, put_ButtonInactiveBackgroundColor)
    ButtonInactiveForegroundColor = property(get_ButtonInactiveForegroundColor, put_ButtonInactiveForegroundColor)
    ButtonPressedBackgroundColor = property(get_ButtonPressedBackgroundColor, put_ButtonPressedBackgroundColor)
    ButtonPressedForegroundColor = property(get_ButtonPressedForegroundColor, put_ButtonPressedForegroundColor)
    ExtendsContentIntoTitleBar = property(get_ExtendsContentIntoTitleBar, put_ExtendsContentIntoTitleBar)
    ForegroundColor = property(get_ForegroundColor, put_ForegroundColor)
    Height = property(get_Height, None)
    IconShowOptions = property(get_IconShowOptions, put_IconShowOptions)
    InactiveBackgroundColor = property(get_InactiveBackgroundColor, put_InactiveBackgroundColor)
    InactiveForegroundColor = property(get_InactiveForegroundColor, put_InactiveForegroundColor)
    LeftInset = property(get_LeftInset, None)
    RightInset = property(get_RightInset, None)
class IAppWindowTitleBar2(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.UI.Windowing.IAppWindowTitleBar2'
    _iid_ = Guid('{86faed38-748a-5b4b-9ccf-3ba0496c9041}')
    @winrt_commethod(6)
    def get_PreferredHeightOption(self) -> win32more.Microsoft.UI.Windowing.TitleBarHeightOption: ...
    @winrt_commethod(7)
    def put_PreferredHeightOption(self, value: win32more.Microsoft.UI.Windowing.TitleBarHeightOption) -> Void: ...
    PreferredHeightOption = property(get_PreferredHeightOption, put_PreferredHeightOption)
class IAppWindowTitleBar3(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.UI.Windowing.IAppWindowTitleBar3'
    _iid_ = Guid('{07146e74-0410-5597-aba7-1af276d2ae07}')
    @winrt_commethod(6)
    def get_PreferredTheme(self) -> win32more.Microsoft.UI.Windowing.TitleBarTheme: ...
    @winrt_commethod(7)
    def put_PreferredTheme(self, value: win32more.Microsoft.UI.Windowing.TitleBarTheme) -> Void: ...
    PreferredTheme = property(get_PreferredTheme, put_PreferredTheme)
class IAppWindowTitleBarStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.UI.Windowing.IAppWindowTitleBarStatics'
    _iid_ = Guid('{9e1da52e-8b15-54d6-a886-f7b9f9d930b2}')
    @winrt_commethod(6)
    def IsCustomizationSupported(self) -> Boolean: ...
class ICompactOverlayPresenter(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.UI.Windowing.ICompactOverlayPresenter'
    _iid_ = Guid('{efeb0812-6fc7-5b7d-bd92-cc8f9a6454c9}')
    @winrt_commethod(6)
    def get_InitialSize(self) -> win32more.Microsoft.UI.Windowing.CompactOverlaySize: ...
    @winrt_commethod(7)
    def put_InitialSize(self, value: win32more.Microsoft.UI.Windowing.CompactOverlaySize) -> Void: ...
    InitialSize = property(get_InitialSize, put_InitialSize)
class ICompactOverlayPresenterStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.UI.Windowing.ICompactOverlayPresenterStatics'
    _iid_ = Guid('{eab93186-4f6a-52f9-8c03-da57a1522f6e}')
    @winrt_commethod(6)
    def Create(self) -> win32more.Microsoft.UI.Windowing.CompactOverlayPresenter: ...
class IDisplayArea(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.UI.Windowing.IDisplayArea'
    _iid_ = Guid('{5c7e0537-b621-5579-bcae-a84aa8746167}')
    @winrt_commethod(6)
    def get_DisplayId(self) -> win32more.Microsoft.UI.DisplayId: ...
    @winrt_commethod(7)
    def get_IsPrimary(self) -> Boolean: ...
    @winrt_commethod(8)
    def get_OuterBounds(self) -> win32more.Windows.Graphics.RectInt32: ...
    @winrt_commethod(9)
    def get_WorkArea(self) -> win32more.Windows.Graphics.RectInt32: ...
    DisplayId = property(get_DisplayId, None)
    IsPrimary = property(get_IsPrimary, None)
    OuterBounds = property(get_OuterBounds, None)
    WorkArea = property(get_WorkArea, None)
class IDisplayAreaStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.UI.Windowing.IDisplayAreaStatics'
    _iid_ = Guid('{02ab4926-211e-5d49-8e4b-2af193daed09}')
    @winrt_commethod(6)
    def get_Primary(self) -> win32more.Microsoft.UI.Windowing.DisplayArea: ...
    @winrt_commethod(7)
    def CreateWatcher(self) -> win32more.Microsoft.UI.Windowing.DisplayAreaWatcher: ...
    @winrt_commethod(8)
    def FindAll(self) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Microsoft.UI.Windowing.DisplayArea]: ...
    @winrt_commethod(9)
    def GetFromWindowId(self, windowId: win32more.Microsoft.UI.WindowId, displayAreaFallback: win32more.Microsoft.UI.Windowing.DisplayAreaFallback) -> win32more.Microsoft.UI.Windowing.DisplayArea: ...
    @winrt_commethod(10)
    def GetFromPoint(self, point: win32more.Windows.Graphics.PointInt32, displayAreaFallback: win32more.Microsoft.UI.Windowing.DisplayAreaFallback) -> win32more.Microsoft.UI.Windowing.DisplayArea: ...
    @winrt_commethod(11)
    def GetFromRect(self, rect: win32more.Windows.Graphics.RectInt32, displayAreaFallback: win32more.Microsoft.UI.Windowing.DisplayAreaFallback) -> win32more.Microsoft.UI.Windowing.DisplayArea: ...
    Primary = property(get_Primary, None)
class IDisplayAreaStatics2(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.UI.Windowing.IDisplayAreaStatics2'
    _iid_ = Guid('{7207ad4b-890d-5dd7-bc18-78ffd9544d8f}')
    @winrt_commethod(6)
    def GetFromDisplayId(self, displayId: win32more.Microsoft.UI.DisplayId) -> win32more.Microsoft.UI.Windowing.DisplayArea: ...
class IDisplayAreaWatcher(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.UI.Windowing.IDisplayAreaWatcher'
    _iid_ = Guid('{83f6562f-d3a0-548b-8e4f-a99be3d95c9c}')
    @winrt_commethod(6)
    def get_Status(self) -> win32more.Microsoft.UI.Windowing.DisplayAreaWatcherStatus: ...
    @winrt_commethod(7)
    def Start(self) -> Void: ...
    @winrt_commethod(8)
    def Stop(self) -> Void: ...
    @winrt_commethod(9)
    def add_Added(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.UI.Windowing.DisplayAreaWatcher, win32more.Microsoft.UI.Windowing.DisplayArea]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(10)
    def remove_Added(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(11)
    def add_EnumerationCompleted(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.UI.Windowing.DisplayAreaWatcher, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(12)
    def remove_EnumerationCompleted(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(13)
    def add_Removed(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.UI.Windowing.DisplayAreaWatcher, win32more.Microsoft.UI.Windowing.DisplayArea]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(14)
    def remove_Removed(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(15)
    def add_Stopped(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.UI.Windowing.DisplayAreaWatcher, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(16)
    def remove_Stopped(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(17)
    def add_Updated(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Microsoft.UI.Windowing.DisplayAreaWatcher, win32more.Microsoft.UI.Windowing.DisplayArea]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(18)
    def remove_Updated(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    Status = property(get_Status, None)
    Added = event()
    EnumerationCompleted = event()
    Removed = event()
    Stopped = event()
    Updated = event()
class IFullScreenPresenter(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.UI.Windowing.IFullScreenPresenter'
    _iid_ = Guid('{fa9141fd-b8dd-5da1-8b2b-7cdadb76f593}')
class IFullScreenPresenterStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.UI.Windowing.IFullScreenPresenterStatics'
    _iid_ = Guid('{2ec0d2c1-e086-55bb-a3b2-44942e231c67}')
    @winrt_commethod(6)
    def Create(self) -> win32more.Microsoft.UI.Windowing.FullScreenPresenter: ...
class IOverlappedPresenter(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.UI.Windowing.IOverlappedPresenter'
    _iid_ = Guid('{21693970-4f4c-5172-9e9d-682a2d174884}')
    @winrt_commethod(6)
    def get_HasBorder(self) -> Boolean: ...
    @winrt_commethod(7)
    def get_HasTitleBar(self) -> Boolean: ...
    @winrt_commethod(8)
    def get_IsAlwaysOnTop(self) -> Boolean: ...
    @winrt_commethod(9)
    def put_IsAlwaysOnTop(self, value: Boolean) -> Void: ...
    @winrt_commethod(10)
    def get_IsMaximizable(self) -> Boolean: ...
    @winrt_commethod(11)
    def put_IsMaximizable(self, value: Boolean) -> Void: ...
    @winrt_commethod(12)
    def get_IsMinimizable(self) -> Boolean: ...
    @winrt_commethod(13)
    def put_IsMinimizable(self, value: Boolean) -> Void: ...
    @winrt_commethod(14)
    def get_IsModal(self) -> Boolean: ...
    @winrt_commethod(15)
    def put_IsModal(self, value: Boolean) -> Void: ...
    @winrt_commethod(16)
    def get_IsResizable(self) -> Boolean: ...
    @winrt_commethod(17)
    def put_IsResizable(self, value: Boolean) -> Void: ...
    @winrt_commethod(18)
    def get_State(self) -> win32more.Microsoft.UI.Windowing.OverlappedPresenterState: ...
    @winrt_commethod(19)
    def Maximize(self) -> Void: ...
    @winrt_commethod(20)
    def Minimize(self) -> Void: ...
    @winrt_commethod(21)
    def Restore(self) -> Void: ...
    @winrt_commethod(22)
    def SetBorderAndTitleBar(self, hasBorder: Boolean, hasTitleBar: Boolean) -> Void: ...
    HasBorder = property(get_HasBorder, None)
    HasTitleBar = property(get_HasTitleBar, None)
    IsAlwaysOnTop = property(get_IsAlwaysOnTop, put_IsAlwaysOnTop)
    IsMaximizable = property(get_IsMaximizable, put_IsMaximizable)
    IsMinimizable = property(get_IsMinimizable, put_IsMinimizable)
    IsModal = property(get_IsModal, put_IsModal)
    IsResizable = property(get_IsResizable, put_IsResizable)
    State = property(get_State, None)
class IOverlappedPresenter2(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.UI.Windowing.IOverlappedPresenter2'
    _iid_ = Guid('{5c6ccd93-4244-5cd2-b355-ed5ea34df730}')
    @winrt_commethod(6)
    def MinimizeWithActivation(self, activateWindow: Boolean) -> Void: ...
    @winrt_commethod(7)
    def RestoreWithActivation(self, activateWindow: Boolean) -> Void: ...
class IOverlappedPresenter3(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.UI.Windowing.IOverlappedPresenter3'
    _iid_ = Guid('{55d26138-4c38-57e7-a0c1-d467b774db8c}')
    @winrt_commethod(6)
    def get_PreferredMinimumHeight(self) -> win32more.Windows.Foundation.IReference[Int32]: ...
    @winrt_commethod(7)
    def put_PreferredMinimumHeight(self, value: win32more.Windows.Foundation.IReference[Int32]) -> Void: ...
    @winrt_commethod(8)
    def get_PreferredMinimumWidth(self) -> win32more.Windows.Foundation.IReference[Int32]: ...
    @winrt_commethod(9)
    def put_PreferredMinimumWidth(self, value: win32more.Windows.Foundation.IReference[Int32]) -> Void: ...
    @winrt_commethod(10)
    def get_PreferredMaximumWidth(self) -> win32more.Windows.Foundation.IReference[Int32]: ...
    @winrt_commethod(11)
    def put_PreferredMaximumWidth(self, value: win32more.Windows.Foundation.IReference[Int32]) -> Void: ...
    @winrt_commethod(12)
    def get_PreferredMaximumHeight(self) -> win32more.Windows.Foundation.IReference[Int32]: ...
    @winrt_commethod(13)
    def put_PreferredMaximumHeight(self, value: win32more.Windows.Foundation.IReference[Int32]) -> Void: ...
    PreferredMaximumHeight = property(get_PreferredMaximumHeight, put_PreferredMaximumHeight)
    PreferredMaximumWidth = property(get_PreferredMaximumWidth, put_PreferredMaximumWidth)
    PreferredMinimumHeight = property(get_PreferredMinimumHeight, put_PreferredMinimumHeight)
    PreferredMinimumWidth = property(get_PreferredMinimumWidth, put_PreferredMinimumWidth)
class IOverlappedPresenterStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.UI.Windowing.IOverlappedPresenterStatics'
    _iid_ = Guid('{997225e4-7b00-5aee-a4be-d4068d1999e2}')
    @winrt_commethod(6)
    def Create(self) -> win32more.Microsoft.UI.Windowing.OverlappedPresenter: ...
    @winrt_commethod(7)
    def CreateForContextMenu(self) -> win32more.Microsoft.UI.Windowing.OverlappedPresenter: ...
    @winrt_commethod(8)
    def CreateForDialog(self) -> win32more.Microsoft.UI.Windowing.OverlappedPresenter: ...
    @winrt_commethod(9)
    def CreateForToolWindow(self) -> win32more.Microsoft.UI.Windowing.OverlappedPresenter: ...
class IOverlappedPresenterStatics2(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.UI.Windowing.IOverlappedPresenterStatics2'
    _iid_ = Guid('{ed5c4f92-32f4-5d15-80d0-b2a5efa04d39}')
    @winrt_commethod(6)
    def get_RequestedStartupState(self) -> win32more.Microsoft.UI.Windowing.OverlappedPresenterState: ...
    RequestedStartupState = property(get_RequestedStartupState, None)
class IconShowOptions(Enum, Int32):
    ShowIconAndSystemMenu = 0
    HideIconAndSystemMenu = 1
class _OverlappedPresenter_Meta_(ComPtr.__class__):
    pass
class OverlappedPresenter(ComPtr, metaclass=_OverlappedPresenter_Meta_):
    extends: win32more.Microsoft.UI.Windowing.AppWindowPresenter
    default_interface: win32more.Microsoft.UI.Windowing.IOverlappedPresenter
    _classid_ = 'Microsoft.UI.Windowing.OverlappedPresenter'
    @winrt_mixinmethod
    def put_IsMaximizable(self: win32more.Microsoft.UI.Windowing.IOverlappedPresenter, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_HasTitleBar(self: win32more.Microsoft.UI.Windowing.IOverlappedPresenter) -> Boolean: ...
    @winrt_mixinmethod
    def get_IsAlwaysOnTop(self: win32more.Microsoft.UI.Windowing.IOverlappedPresenter) -> Boolean: ...
    @winrt_mixinmethod
    def put_IsAlwaysOnTop(self: win32more.Microsoft.UI.Windowing.IOverlappedPresenter, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_IsMaximizable(self: win32more.Microsoft.UI.Windowing.IOverlappedPresenter) -> Boolean: ...
    @winrt_mixinmethod
    def get_PreferredMinimumHeight(self: win32more.Microsoft.UI.Windowing.IOverlappedPresenter3) -> win32more.Windows.Foundation.IReference[Int32]: ...
    @winrt_mixinmethod
    def get_IsMinimizable(self: win32more.Microsoft.UI.Windowing.IOverlappedPresenter) -> Boolean: ...
    @winrt_mixinmethod
    def put_IsMinimizable(self: win32more.Microsoft.UI.Windowing.IOverlappedPresenter, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_IsModal(self: win32more.Microsoft.UI.Windowing.IOverlappedPresenter) -> Boolean: ...
    @winrt_mixinmethod
    def put_IsModal(self: win32more.Microsoft.UI.Windowing.IOverlappedPresenter, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_IsResizable(self: win32more.Microsoft.UI.Windowing.IOverlappedPresenter) -> Boolean: ...
    @winrt_mixinmethod
    def put_IsResizable(self: win32more.Microsoft.UI.Windowing.IOverlappedPresenter, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_State(self: win32more.Microsoft.UI.Windowing.IOverlappedPresenter) -> win32more.Microsoft.UI.Windowing.OverlappedPresenterState: ...
    @winrt_mixinmethod
    def Maximize(self: win32more.Microsoft.UI.Windowing.IOverlappedPresenter) -> Void: ...
    @winrt_mixinmethod
    def Minimize(self: win32more.Microsoft.UI.Windowing.IOverlappedPresenter) -> Void: ...
    @winrt_mixinmethod
    def Restore(self: win32more.Microsoft.UI.Windowing.IOverlappedPresenter) -> Void: ...
    @winrt_mixinmethod
    def SetBorderAndTitleBar(self: win32more.Microsoft.UI.Windowing.IOverlappedPresenter, hasBorder: Boolean, hasTitleBar: Boolean) -> Void: ...
    @winrt_mixinmethod
    def MinimizeWithActivation(self: win32more.Microsoft.UI.Windowing.IOverlappedPresenter2, activateWindow: Boolean) -> Void: ...
    @winrt_mixinmethod
    def RestoreWithActivation(self: win32more.Microsoft.UI.Windowing.IOverlappedPresenter2, activateWindow: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_HasBorder(self: win32more.Microsoft.UI.Windowing.IOverlappedPresenter) -> Boolean: ...
    @winrt_mixinmethod
    def put_PreferredMinimumHeight(self: win32more.Microsoft.UI.Windowing.IOverlappedPresenter3, value: win32more.Windows.Foundation.IReference[Int32]) -> Void: ...
    @winrt_mixinmethod
    def get_PreferredMinimumWidth(self: win32more.Microsoft.UI.Windowing.IOverlappedPresenter3) -> win32more.Windows.Foundation.IReference[Int32]: ...
    @winrt_mixinmethod
    def put_PreferredMinimumWidth(self: win32more.Microsoft.UI.Windowing.IOverlappedPresenter3, value: win32more.Windows.Foundation.IReference[Int32]) -> Void: ...
    @winrt_mixinmethod
    def get_PreferredMaximumWidth(self: win32more.Microsoft.UI.Windowing.IOverlappedPresenter3) -> win32more.Windows.Foundation.IReference[Int32]: ...
    @winrt_mixinmethod
    def put_PreferredMaximumWidth(self: win32more.Microsoft.UI.Windowing.IOverlappedPresenter3, value: win32more.Windows.Foundation.IReference[Int32]) -> Void: ...
    @winrt_mixinmethod
    def get_PreferredMaximumHeight(self: win32more.Microsoft.UI.Windowing.IOverlappedPresenter3) -> win32more.Windows.Foundation.IReference[Int32]: ...
    @winrt_mixinmethod
    def put_PreferredMaximumHeight(self: win32more.Microsoft.UI.Windowing.IOverlappedPresenter3, value: win32more.Windows.Foundation.IReference[Int32]) -> Void: ...
    @winrt_classmethod
    def get_RequestedStartupState(cls: win32more.Microsoft.UI.Windowing.IOverlappedPresenterStatics2) -> win32more.Microsoft.UI.Windowing.OverlappedPresenterState: ...
    @winrt_classmethod
    def Create(cls: win32more.Microsoft.UI.Windowing.IOverlappedPresenterStatics) -> win32more.Microsoft.UI.Windowing.OverlappedPresenter: ...
    @winrt_classmethod
    def CreateForContextMenu(cls: win32more.Microsoft.UI.Windowing.IOverlappedPresenterStatics) -> win32more.Microsoft.UI.Windowing.OverlappedPresenter: ...
    @winrt_classmethod
    def CreateForDialog(cls: win32more.Microsoft.UI.Windowing.IOverlappedPresenterStatics) -> win32more.Microsoft.UI.Windowing.OverlappedPresenter: ...
    @winrt_classmethod
    def CreateForToolWindow(cls: win32more.Microsoft.UI.Windowing.IOverlappedPresenterStatics) -> win32more.Microsoft.UI.Windowing.OverlappedPresenter: ...
    HasBorder = property(get_HasBorder, None)
    HasTitleBar = property(get_HasTitleBar, None)
    IsAlwaysOnTop = property(get_IsAlwaysOnTop, put_IsAlwaysOnTop)
    IsMaximizable = property(get_IsMaximizable, put_IsMaximizable)
    IsMinimizable = property(get_IsMinimizable, put_IsMinimizable)
    IsModal = property(get_IsModal, put_IsModal)
    IsResizable = property(get_IsResizable, put_IsResizable)
    PreferredMaximumHeight = property(get_PreferredMaximumHeight, put_PreferredMaximumHeight)
    PreferredMaximumWidth = property(get_PreferredMaximumWidth, put_PreferredMaximumWidth)
    PreferredMinimumHeight = property(get_PreferredMinimumHeight, put_PreferredMinimumHeight)
    PreferredMinimumWidth = property(get_PreferredMinimumWidth, put_PreferredMinimumWidth)
    State = property(get_State, None)
    _OverlappedPresenter_Meta_.RequestedStartupState = property(get_RequestedStartupState, None)
class OverlappedPresenterState(Enum, Int32):
    Maximized = 0
    Minimized = 1
    Restored = 2
class TitleBarHeightOption(Enum, Int32):
    Standard = 0
    Tall = 1
    Collapsed = 2
class TitleBarTheme(Enum, Int32):
    Legacy = 0
    UseDefaultAppMode = 1
    Light = 2
    Dark = 3


make_ready(__name__)
