from __future__ import annotations
from win32more.winrt.prelude import *
import win32more.Microsoft.Windows.AppNotifications
import win32more.Microsoft.Windows.AppNotifications.Builder
import win32more.Windows.Foundation
import win32more.Windows.Foundation.Collections
class AppNotificationAudioLooping(Enum, Int32):
    None_ = 0
    Loop = 1
class AppNotificationBuilder(ComPtr):
    extends: IInspectable
    default_interface: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationBuilder
    _classid_ = 'Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_mixinmethod
    def AddArgument(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationBuilder, key: WinRT_String, value: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_mixinmethod
    def SetTimeStamp(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationBuilder, value: win32more.Windows.Foundation.DateTime) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_mixinmethod
    def SetDuration(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationBuilder, duration: win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationDuration) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_mixinmethod
    def SetScenario(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationBuilder, value: win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationScenario) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_mixinmethod
    def AddText(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationBuilder, text: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_mixinmethod
    def AddText2(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationBuilder, text: WinRT_String, properties: win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationTextProperties) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_mixinmethod
    def SetAttributionText(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationBuilder, text: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_mixinmethod
    def SetAttributionText2(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationBuilder, text: WinRT_String, language: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_mixinmethod
    def SetInlineImage(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationBuilder, imageUri: win32more.Windows.Foundation.Uri) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_mixinmethod
    def SetInlineImage2(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationBuilder, imageUri: win32more.Windows.Foundation.Uri, imageCrop: win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationImageCrop) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_mixinmethod
    def SetInlineImage3(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationBuilder, imageUri: win32more.Windows.Foundation.Uri, imagecrop: win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationImageCrop, alternateText: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_mixinmethod
    def SetAppLogoOverride(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationBuilder, imageUri: win32more.Windows.Foundation.Uri) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_mixinmethod
    def SetAppLogoOverride2(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationBuilder, imageUri: win32more.Windows.Foundation.Uri, imageCrop: win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationImageCrop) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_mixinmethod
    def SetAppLogoOverride3(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationBuilder, imageUri: win32more.Windows.Foundation.Uri, imageCrop: win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationImageCrop, alternateText: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_mixinmethod
    def SetHeroImage(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationBuilder, imageUri: win32more.Windows.Foundation.Uri) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_mixinmethod
    def SetHeroImage2(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationBuilder, imageUri: win32more.Windows.Foundation.Uri, alternateText: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_mixinmethod
    def SetAudioUri(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationBuilder, audioUri: win32more.Windows.Foundation.Uri) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_mixinmethod
    def SetAudioUri2(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationBuilder, audioUri: win32more.Windows.Foundation.Uri, loop: win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationAudioLooping) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_mixinmethod
    def SetAudioEvent(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationBuilder, appNotificationSoundEvent: win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationSoundEvent) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_mixinmethod
    def SetAudioEvent2(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationBuilder, appNotificationSoundEvent: win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationSoundEvent, loop: win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationAudioLooping) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_mixinmethod
    def MuteAudio(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationBuilder) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_mixinmethod
    def AddTextBox(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationBuilder, id: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_mixinmethod
    def AddTextBox2(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationBuilder, id: WinRT_String, placeHolderText: WinRT_String, title: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_mixinmethod
    def AddButton(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationBuilder, value: win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationButton) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_mixinmethod
    def AddComboBox(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationBuilder, value: win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationComboBox) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_mixinmethod
    def AddProgressBar(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationBuilder, value: win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationProgressBar) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_mixinmethod
    def BuildNotification(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationBuilder) -> win32more.Microsoft.Windows.AppNotifications.AppNotification: ...
    @winrt_mixinmethod
    def SetTag(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationBuilder, value: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_mixinmethod
    def SetGroup(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationBuilder, group: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_classmethod
    def IsUrgentScenarioSupported(cls: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationBuilderStatics) -> Boolean: ...
AppNotificationBuilderContract: UInt32 = 131072
class AppNotificationButton(ComPtr):
    extends: IInspectable
    default_interface: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationButton
    _classid_ = 'Microsoft.Windows.AppNotifications.Builder.AppNotificationButton'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationButton.CreateInstance(*args))
        elif len(args) == 1:
            super().__init__(move=win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationButton.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_overload
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationButton: ...
    @CreateInstance.register
    @winrt_factorymethod
    def CreateInstance(cls: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationButtonFactory, content: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationButton: ...
    @winrt_mixinmethod
    def get_Content(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationButton) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Content(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationButton, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Arguments(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationButton) -> win32more.Windows.Foundation.Collections.IMap[WinRT_String, WinRT_String]: ...
    @winrt_mixinmethod
    def put_Arguments(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationButton, value: win32more.Windows.Foundation.Collections.IMap[WinRT_String, WinRT_String]) -> Void: ...
    @winrt_mixinmethod
    def get_Icon(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationButton) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def put_Icon(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationButton, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_mixinmethod
    def get_ToolTip(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationButton) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_ToolTip(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationButton, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_ContextMenuPlacement(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationButton) -> Boolean: ...
    @winrt_mixinmethod
    def put_ContextMenuPlacement(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationButton, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_ButtonStyle(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationButton) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationButtonStyle: ...
    @winrt_mixinmethod
    def put_ButtonStyle(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationButton, value: win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationButtonStyle) -> Void: ...
    @winrt_mixinmethod
    def get_InputId(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationButton) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_InputId(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationButton, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_InvokeUri(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationButton) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def put_InvokeUri(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationButton, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_mixinmethod
    def get_TargetAppId(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationButton) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_TargetAppId(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationButton, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def AddArgument(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationButton, key: WinRT_String, value: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationButton: ...
    @winrt_mixinmethod
    def SetIcon(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationButton, value: win32more.Windows.Foundation.Uri) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationButton: ...
    @winrt_mixinmethod
    def SetToolTip(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationButton, value: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationButton: ...
    @winrt_mixinmethod
    def SetContextMenuPlacement(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationButton) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationButton: ...
    @winrt_mixinmethod
    def SetButtonStyle(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationButton, value: win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationButtonStyle) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationButton: ...
    @winrt_mixinmethod
    def SetInputId(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationButton, value: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationButton: ...
    @winrt_mixinmethod
    def SetInvokeUri(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationButton, protocolUri: win32more.Windows.Foundation.Uri) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationButton: ...
    @winrt_mixinmethod
    def SetInvokeUri2(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationButton, protocolUri: win32more.Windows.Foundation.Uri, targetAppId: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationButton: ...
    @winrt_classmethod
    def IsToolTipSupported(cls: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationButtonStatics) -> Boolean: ...
    @winrt_classmethod
    def IsButtonStyleSupported(cls: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationButtonStatics) -> Boolean: ...
    Arguments = property(get_Arguments, put_Arguments)
    ButtonStyle = property(get_ButtonStyle, put_ButtonStyle)
    Content = property(get_Content, put_Content)
    ContextMenuPlacement = property(get_ContextMenuPlacement, put_ContextMenuPlacement)
    Icon = property(get_Icon, put_Icon)
    InputId = property(get_InputId, put_InputId)
    InvokeUri = property(get_InvokeUri, put_InvokeUri)
    TargetAppId = property(get_TargetAppId, put_TargetAppId)
    ToolTip = property(get_ToolTip, put_ToolTip)
class AppNotificationButtonStyle(Enum, Int32):
    Default = 0
    Success = 1
    Critical = 2
class AppNotificationComboBox(ComPtr):
    extends: IInspectable
    default_interface: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationComboBox
    _classid_ = 'Microsoft.Windows.AppNotifications.Builder.AppNotificationComboBox'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationComboBox.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def CreateInstance(cls: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationComboBoxFactory, id: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationComboBox: ...
    @winrt_mixinmethod
    def get_Items(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationComboBox) -> win32more.Windows.Foundation.Collections.IMap[WinRT_String, WinRT_String]: ...
    @winrt_mixinmethod
    def put_Items(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationComboBox, value: win32more.Windows.Foundation.Collections.IMap[WinRT_String, WinRT_String]) -> Void: ...
    @winrt_mixinmethod
    def get_Title(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationComboBox) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Title(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationComboBox, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_SelectedItem(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationComboBox) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_SelectedItem(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationComboBox, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def AddItem(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationComboBox, id: WinRT_String, content: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationComboBox: ...
    @winrt_mixinmethod
    def SetTitle(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationComboBox, value: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationComboBox: ...
    @winrt_mixinmethod
    def SetSelectedItem(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationComboBox, id: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationComboBox: ...
    Items = property(get_Items, put_Items)
    SelectedItem = property(get_SelectedItem, put_SelectedItem)
    Title = property(get_Title, put_Title)
class AppNotificationDuration(Enum, Int32):
    Default = 0
    Long = 1
class AppNotificationImageCrop(Enum, Int32):
    Default = 0
    Circle = 1
class AppNotificationProgressBar(ComPtr):
    extends: IInspectable
    default_interface: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationProgressBar
    _classid_ = 'Microsoft.Windows.AppNotifications.Builder.AppNotificationProgressBar'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationProgressBar.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationProgressBar: ...
    @winrt_mixinmethod
    def get_Title(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationProgressBar) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Title(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationProgressBar, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Status(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationProgressBar) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Status(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationProgressBar, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Value(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationProgressBar) -> Double: ...
    @winrt_mixinmethod
    def put_Value(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationProgressBar, value: Double) -> Void: ...
    @winrt_mixinmethod
    def get_ValueStringOverride(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationProgressBar) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_ValueStringOverride(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationProgressBar, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def SetTitle(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationProgressBar, value: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationProgressBar: ...
    @winrt_mixinmethod
    def BindTitle(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationProgressBar) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationProgressBar: ...
    @winrt_mixinmethod
    def SetStatus(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationProgressBar, value: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationProgressBar: ...
    @winrt_mixinmethod
    def BindStatus(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationProgressBar) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationProgressBar: ...
    @winrt_mixinmethod
    def SetValue(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationProgressBar, value: Double) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationProgressBar: ...
    @winrt_mixinmethod
    def BindValue(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationProgressBar) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationProgressBar: ...
    @winrt_mixinmethod
    def SetValueStringOverride(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationProgressBar, value: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationProgressBar: ...
    @winrt_mixinmethod
    def BindValueStringOverride(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationProgressBar) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationProgressBar: ...
    Status = property(get_Status, put_Status)
    Title = property(get_Title, put_Title)
    Value = property(get_Value, put_Value)
    ValueStringOverride = property(get_ValueStringOverride, put_ValueStringOverride)
class AppNotificationScenario(Enum, Int32):
    Default = 0
    Reminder = 1
    Alarm = 2
    IncomingCall = 3
    Urgent = 4
class AppNotificationSoundEvent(Enum, Int32):
    Default = 0
    IM = 1
    Mail = 2
    Reminder = 3
    SMS = 4
    Alarm = 5
    Alarm2 = 6
    Alarm3 = 7
    Alarm4 = 8
    Alarm5 = 9
    Alarm6 = 10
    Alarm7 = 11
    Alarm8 = 12
    Alarm9 = 13
    Alarm10 = 14
    Call = 15
    Call2 = 16
    Call3 = 17
    Call4 = 18
    Call5 = 19
    Call6 = 20
    Call7 = 21
    Call8 = 22
    Call9 = 23
    Call10 = 24
class AppNotificationTextProperties(ComPtr):
    extends: IInspectable
    default_interface: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationTextProperties
    _classid_ = 'Microsoft.Windows.AppNotifications.Builder.AppNotificationTextProperties'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationTextProperties.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationTextProperties: ...
    @winrt_mixinmethod
    def get_Language(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationTextProperties) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Language(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationTextProperties, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_IncomingCallAlignment(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationTextProperties) -> Boolean: ...
    @winrt_mixinmethod
    def put_IncomingCallAlignment(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationTextProperties, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_MaxLines(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationTextProperties) -> Int32: ...
    @winrt_mixinmethod
    def put_MaxLines(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationTextProperties, value: Int32) -> Void: ...
    @winrt_mixinmethod
    def SetLanguage(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationTextProperties, value: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationTextProperties: ...
    @winrt_mixinmethod
    def SetIncomingCallAlignment(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationTextProperties) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationTextProperties: ...
    @winrt_mixinmethod
    def SetMaxLines(self: win32more.Microsoft.Windows.AppNotifications.Builder.IAppNotificationTextProperties, value: Int32) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationTextProperties: ...
    IncomingCallAlignment = property(get_IncomingCallAlignment, put_IncomingCallAlignment)
    Language = property(get_Language, put_Language)
    MaxLines = property(get_MaxLines, put_MaxLines)
class IAppNotificationBuilder(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Windows.AppNotifications.Builder.IAppNotificationBuilder'
    _iid_ = Guid('{e801d31f-ce03-505c-adec-8a02724ec9de}')
    @winrt_commethod(6)
    def AddArgument(self, key: WinRT_String, value: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_commethod(7)
    def SetTimeStamp(self, value: win32more.Windows.Foundation.DateTime) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_commethod(8)
    def SetDuration(self, duration: win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationDuration) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_commethod(9)
    def SetScenario(self, value: win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationScenario) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_commethod(10)
    def AddText(self, text: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_commethod(11)
    def AddText2(self, text: WinRT_String, properties: win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationTextProperties) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_commethod(12)
    def SetAttributionText(self, text: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_commethod(13)
    def SetAttributionText2(self, text: WinRT_String, language: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_commethod(14)
    def SetInlineImage(self, imageUri: win32more.Windows.Foundation.Uri) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_commethod(15)
    def SetInlineImage2(self, imageUri: win32more.Windows.Foundation.Uri, imageCrop: win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationImageCrop) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_commethod(16)
    def SetInlineImage3(self, imageUri: win32more.Windows.Foundation.Uri, imagecrop: win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationImageCrop, alternateText: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_commethod(17)
    def SetAppLogoOverride(self, imageUri: win32more.Windows.Foundation.Uri) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_commethod(18)
    def SetAppLogoOverride2(self, imageUri: win32more.Windows.Foundation.Uri, imageCrop: win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationImageCrop) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_commethod(19)
    def SetAppLogoOverride3(self, imageUri: win32more.Windows.Foundation.Uri, imageCrop: win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationImageCrop, alternateText: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_commethod(20)
    def SetHeroImage(self, imageUri: win32more.Windows.Foundation.Uri) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_commethod(21)
    def SetHeroImage2(self, imageUri: win32more.Windows.Foundation.Uri, alternateText: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_commethod(22)
    def SetAudioUri(self, audioUri: win32more.Windows.Foundation.Uri) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_commethod(23)
    def SetAudioUri2(self, audioUri: win32more.Windows.Foundation.Uri, loop: win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationAudioLooping) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_commethod(24)
    def SetAudioEvent(self, appNotificationSoundEvent: win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationSoundEvent) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_commethod(25)
    def SetAudioEvent2(self, appNotificationSoundEvent: win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationSoundEvent, loop: win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationAudioLooping) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_commethod(26)
    def MuteAudio(self) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_commethod(27)
    def AddTextBox(self, id: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_commethod(28)
    def AddTextBox2(self, id: WinRT_String, placeHolderText: WinRT_String, title: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_commethod(29)
    def AddButton(self, value: win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationButton) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_commethod(30)
    def AddComboBox(self, value: win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationComboBox) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_commethod(31)
    def AddProgressBar(self, value: win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationProgressBar) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_commethod(32)
    def BuildNotification(self) -> win32more.Microsoft.Windows.AppNotifications.AppNotification: ...
    @winrt_commethod(33)
    def SetTag(self, value: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
    @winrt_commethod(34)
    def SetGroup(self, group: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationBuilder: ...
class IAppNotificationBuilderStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Windows.AppNotifications.Builder.IAppNotificationBuilderStatics'
    _iid_ = Guid('{c7042d2a-d319-520e-a314-50081c8888cc}')
    @winrt_commethod(6)
    def IsUrgentScenarioSupported(self) -> Boolean: ...
class IAppNotificationButton(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Windows.AppNotifications.Builder.IAppNotificationButton'
    _iid_ = Guid('{a7c03031-5634-5098-aec9-47ecb60c3499}')
    @winrt_commethod(6)
    def get_Content(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def put_Content(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(8)
    def get_Arguments(self) -> win32more.Windows.Foundation.Collections.IMap[WinRT_String, WinRT_String]: ...
    @winrt_commethod(9)
    def put_Arguments(self, value: win32more.Windows.Foundation.Collections.IMap[WinRT_String, WinRT_String]) -> Void: ...
    @winrt_commethod(10)
    def get_Icon(self) -> win32more.Windows.Foundation.Uri: ...
    @winrt_commethod(11)
    def put_Icon(self, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_commethod(12)
    def get_ToolTip(self) -> WinRT_String: ...
    @winrt_commethod(13)
    def put_ToolTip(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(14)
    def get_ContextMenuPlacement(self) -> Boolean: ...
    @winrt_commethod(15)
    def put_ContextMenuPlacement(self, value: Boolean) -> Void: ...
    @winrt_commethod(16)
    def get_ButtonStyle(self) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationButtonStyle: ...
    @winrt_commethod(17)
    def put_ButtonStyle(self, value: win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationButtonStyle) -> Void: ...
    @winrt_commethod(18)
    def get_InputId(self) -> WinRT_String: ...
    @winrt_commethod(19)
    def put_InputId(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(20)
    def get_InvokeUri(self) -> win32more.Windows.Foundation.Uri: ...
    @winrt_commethod(21)
    def put_InvokeUri(self, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_commethod(22)
    def get_TargetAppId(self) -> WinRT_String: ...
    @winrt_commethod(23)
    def put_TargetAppId(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(24)
    def AddArgument(self, key: WinRT_String, value: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationButton: ...
    @winrt_commethod(25)
    def SetIcon(self, value: win32more.Windows.Foundation.Uri) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationButton: ...
    @winrt_commethod(26)
    def SetToolTip(self, value: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationButton: ...
    @winrt_commethod(27)
    def SetContextMenuPlacement(self) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationButton: ...
    @winrt_commethod(28)
    def SetButtonStyle(self, value: win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationButtonStyle) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationButton: ...
    @winrt_commethod(29)
    def SetInputId(self, value: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationButton: ...
    @winrt_commethod(30)
    def SetInvokeUri(self, protocolUri: win32more.Windows.Foundation.Uri) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationButton: ...
    @winrt_commethod(31)
    def SetInvokeUri2(self, protocolUri: win32more.Windows.Foundation.Uri, targetAppId: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationButton: ...
    Arguments = property(get_Arguments, put_Arguments)
    ButtonStyle = property(get_ButtonStyle, put_ButtonStyle)
    Content = property(get_Content, put_Content)
    ContextMenuPlacement = property(get_ContextMenuPlacement, put_ContextMenuPlacement)
    Icon = property(get_Icon, put_Icon)
    InputId = property(get_InputId, put_InputId)
    InvokeUri = property(get_InvokeUri, put_InvokeUri)
    TargetAppId = property(get_TargetAppId, put_TargetAppId)
    ToolTip = property(get_ToolTip, put_ToolTip)
class IAppNotificationButtonFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Windows.AppNotifications.Builder.IAppNotificationButtonFactory'
    _iid_ = Guid('{4f109286-0a6d-5a5e-9e8f-9fe31669fbb8}')
    @winrt_commethod(6)
    def CreateInstance(self, content: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationButton: ...
class IAppNotificationButtonStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Windows.AppNotifications.Builder.IAppNotificationButtonStatics'
    _iid_ = Guid('{fead7c18-4144-59a4-9611-86b7e8191853}')
    @winrt_commethod(6)
    def IsToolTipSupported(self) -> Boolean: ...
    @winrt_commethod(7)
    def IsButtonStyleSupported(self) -> Boolean: ...
class IAppNotificationComboBox(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Windows.AppNotifications.Builder.IAppNotificationComboBox'
    _iid_ = Guid('{4547c9e2-4815-538c-be26-040ce17f8b62}')
    @winrt_commethod(6)
    def get_Items(self) -> win32more.Windows.Foundation.Collections.IMap[WinRT_String, WinRT_String]: ...
    @winrt_commethod(7)
    def put_Items(self, value: win32more.Windows.Foundation.Collections.IMap[WinRT_String, WinRT_String]) -> Void: ...
    @winrt_commethod(8)
    def get_Title(self) -> WinRT_String: ...
    @winrt_commethod(9)
    def put_Title(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(10)
    def get_SelectedItem(self) -> WinRT_String: ...
    @winrt_commethod(11)
    def put_SelectedItem(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(12)
    def AddItem(self, id: WinRT_String, content: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationComboBox: ...
    @winrt_commethod(13)
    def SetTitle(self, value: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationComboBox: ...
    @winrt_commethod(14)
    def SetSelectedItem(self, id: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationComboBox: ...
    Items = property(get_Items, put_Items)
    SelectedItem = property(get_SelectedItem, put_SelectedItem)
    Title = property(get_Title, put_Title)
class IAppNotificationComboBoxFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Windows.AppNotifications.Builder.IAppNotificationComboBoxFactory'
    _iid_ = Guid('{1b31b5b0-9d86-59ed-8629-a79498ab5d4b}')
    @winrt_commethod(6)
    def CreateInstance(self, id: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationComboBox: ...
class IAppNotificationProgressBar(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Windows.AppNotifications.Builder.IAppNotificationProgressBar'
    _iid_ = Guid('{fced62f2-2074-5641-8630-87a14315ac86}')
    @winrt_commethod(6)
    def get_Title(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def put_Title(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(8)
    def get_Status(self) -> WinRT_String: ...
    @winrt_commethod(9)
    def put_Status(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(10)
    def get_Value(self) -> Double: ...
    @winrt_commethod(11)
    def put_Value(self, value: Double) -> Void: ...
    @winrt_commethod(12)
    def get_ValueStringOverride(self) -> WinRT_String: ...
    @winrt_commethod(13)
    def put_ValueStringOverride(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(14)
    def SetTitle(self, value: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationProgressBar: ...
    @winrt_commethod(15)
    def BindTitle(self) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationProgressBar: ...
    @winrt_commethod(16)
    def SetStatus(self, value: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationProgressBar: ...
    @winrt_commethod(17)
    def BindStatus(self) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationProgressBar: ...
    @winrt_commethod(18)
    def SetValue(self, value: Double) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationProgressBar: ...
    @winrt_commethod(19)
    def BindValue(self) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationProgressBar: ...
    @winrt_commethod(20)
    def SetValueStringOverride(self, value: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationProgressBar: ...
    @winrt_commethod(21)
    def BindValueStringOverride(self) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationProgressBar: ...
    Status = property(get_Status, put_Status)
    Title = property(get_Title, put_Title)
    Value = property(get_Value, put_Value)
    ValueStringOverride = property(get_ValueStringOverride, put_ValueStringOverride)
class IAppNotificationTextProperties(ComPtr):
    extends: IInspectable
    _classid_ = 'Microsoft.Windows.AppNotifications.Builder.IAppNotificationTextProperties'
    _iid_ = Guid('{23a30d0b-5258-5853-932e-9521a3642afb}')
    @winrt_commethod(6)
    def get_Language(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def put_Language(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(8)
    def get_IncomingCallAlignment(self) -> Boolean: ...
    @winrt_commethod(9)
    def put_IncomingCallAlignment(self, value: Boolean) -> Void: ...
    @winrt_commethod(10)
    def get_MaxLines(self) -> Int32: ...
    @winrt_commethod(11)
    def put_MaxLines(self, value: Int32) -> Void: ...
    @winrt_commethod(12)
    def SetLanguage(self, value: WinRT_String) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationTextProperties: ...
    @winrt_commethod(13)
    def SetIncomingCallAlignment(self) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationTextProperties: ...
    @winrt_commethod(14)
    def SetMaxLines(self, value: Int32) -> win32more.Microsoft.Windows.AppNotifications.Builder.AppNotificationTextProperties: ...
    IncomingCallAlignment = property(get_IncomingCallAlignment, put_IncomingCallAlignment)
    Language = property(get_Language, put_Language)
    MaxLines = property(get_MaxLines, put_MaxLines)


make_ready(__name__)
