from __future__ import annotations
from win32more.winrt.prelude import *
import win32more.Windows.ApplicationModel.Appointments
import win32more.Windows.Foundation
import win32more.Windows.Foundation.Collections
import win32more.Windows.System
import win32more.Windows.UI
import win32more.Windows.UI.Popups
class Appointment(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.ApplicationModel.Appointments.IAppointment
    _classid_ = 'Windows.ApplicationModel.Appointments.Appointment'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.ApplicationModel.Appointments.Appointment.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.ApplicationModel.Appointments.Appointment: ...
    @winrt_mixinmethod
    def get_StartTime(self: win32more.Windows.ApplicationModel.Appointments.IAppointment) -> win32more.Windows.Foundation.DateTime: ...
    @winrt_mixinmethod
    def put_StartTime(self: win32more.Windows.ApplicationModel.Appointments.IAppointment, value: win32more.Windows.Foundation.DateTime) -> Void: ...
    @winrt_mixinmethod
    def get_Duration(self: win32more.Windows.ApplicationModel.Appointments.IAppointment) -> win32more.Windows.Foundation.TimeSpan: ...
    @winrt_mixinmethod
    def put_Duration(self: win32more.Windows.ApplicationModel.Appointments.IAppointment, value: win32more.Windows.Foundation.TimeSpan) -> Void: ...
    @winrt_mixinmethod
    def get_Location(self: win32more.Windows.ApplicationModel.Appointments.IAppointment) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Location(self: win32more.Windows.ApplicationModel.Appointments.IAppointment, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Subject(self: win32more.Windows.ApplicationModel.Appointments.IAppointment) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Subject(self: win32more.Windows.ApplicationModel.Appointments.IAppointment, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Details(self: win32more.Windows.ApplicationModel.Appointments.IAppointment) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Details(self: win32more.Windows.ApplicationModel.Appointments.IAppointment, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Reminder(self: win32more.Windows.ApplicationModel.Appointments.IAppointment) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]: ...
    @winrt_mixinmethod
    def put_Reminder(self: win32more.Windows.ApplicationModel.Appointments.IAppointment, value: win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]) -> Void: ...
    @winrt_mixinmethod
    def get_Organizer(self: win32more.Windows.ApplicationModel.Appointments.IAppointment) -> win32more.Windows.ApplicationModel.Appointments.AppointmentOrganizer: ...
    @winrt_mixinmethod
    def put_Organizer(self: win32more.Windows.ApplicationModel.Appointments.IAppointment, value: win32more.Windows.ApplicationModel.Appointments.AppointmentOrganizer) -> Void: ...
    @winrt_mixinmethod
    def get_Invitees(self: win32more.Windows.ApplicationModel.Appointments.IAppointment) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.ApplicationModel.Appointments.AppointmentInvitee]: ...
    @winrt_mixinmethod
    def get_Recurrence(self: win32more.Windows.ApplicationModel.Appointments.IAppointment) -> win32more.Windows.ApplicationModel.Appointments.AppointmentRecurrence: ...
    @winrt_mixinmethod
    def put_Recurrence(self: win32more.Windows.ApplicationModel.Appointments.IAppointment, value: win32more.Windows.ApplicationModel.Appointments.AppointmentRecurrence) -> Void: ...
    @winrt_mixinmethod
    def get_BusyStatus(self: win32more.Windows.ApplicationModel.Appointments.IAppointment) -> win32more.Windows.ApplicationModel.Appointments.AppointmentBusyStatus: ...
    @winrt_mixinmethod
    def put_BusyStatus(self: win32more.Windows.ApplicationModel.Appointments.IAppointment, value: win32more.Windows.ApplicationModel.Appointments.AppointmentBusyStatus) -> Void: ...
    @winrt_mixinmethod
    def get_AllDay(self: win32more.Windows.ApplicationModel.Appointments.IAppointment) -> Boolean: ...
    @winrt_mixinmethod
    def put_AllDay(self: win32more.Windows.ApplicationModel.Appointments.IAppointment, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_Sensitivity(self: win32more.Windows.ApplicationModel.Appointments.IAppointment) -> win32more.Windows.ApplicationModel.Appointments.AppointmentSensitivity: ...
    @winrt_mixinmethod
    def put_Sensitivity(self: win32more.Windows.ApplicationModel.Appointments.IAppointment, value: win32more.Windows.ApplicationModel.Appointments.AppointmentSensitivity) -> Void: ...
    @winrt_mixinmethod
    def get_Uri(self: win32more.Windows.ApplicationModel.Appointments.IAppointment) -> win32more.Windows.Foundation.Uri: ...
    @winrt_mixinmethod
    def put_Uri(self: win32more.Windows.ApplicationModel.Appointments.IAppointment, value: win32more.Windows.Foundation.Uri) -> Void: ...
    @winrt_mixinmethod
    def get_LocalId(self: win32more.Windows.ApplicationModel.Appointments.IAppointment2) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_CalendarId(self: win32more.Windows.ApplicationModel.Appointments.IAppointment2) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_RoamingId(self: win32more.Windows.ApplicationModel.Appointments.IAppointment2) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_RoamingId(self: win32more.Windows.ApplicationModel.Appointments.IAppointment2, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_OriginalStartTime(self: win32more.Windows.ApplicationModel.Appointments.IAppointment2) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]: ...
    @winrt_mixinmethod
    def get_IsResponseRequested(self: win32more.Windows.ApplicationModel.Appointments.IAppointment2) -> Boolean: ...
    @winrt_mixinmethod
    def put_IsResponseRequested(self: win32more.Windows.ApplicationModel.Appointments.IAppointment2, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_AllowNewTimeProposal(self: win32more.Windows.ApplicationModel.Appointments.IAppointment2) -> Boolean: ...
    @winrt_mixinmethod
    def put_AllowNewTimeProposal(self: win32more.Windows.ApplicationModel.Appointments.IAppointment2, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_OnlineMeetingLink(self: win32more.Windows.ApplicationModel.Appointments.IAppointment2) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_OnlineMeetingLink(self: win32more.Windows.ApplicationModel.Appointments.IAppointment2, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_ReplyTime(self: win32more.Windows.ApplicationModel.Appointments.IAppointment2) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]: ...
    @winrt_mixinmethod
    def put_ReplyTime(self: win32more.Windows.ApplicationModel.Appointments.IAppointment2, value: win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]) -> Void: ...
    @winrt_mixinmethod
    def get_UserResponse(self: win32more.Windows.ApplicationModel.Appointments.IAppointment2) -> win32more.Windows.ApplicationModel.Appointments.AppointmentParticipantResponse: ...
    @winrt_mixinmethod
    def put_UserResponse(self: win32more.Windows.ApplicationModel.Appointments.IAppointment2, value: win32more.Windows.ApplicationModel.Appointments.AppointmentParticipantResponse) -> Void: ...
    @winrt_mixinmethod
    def get_HasInvitees(self: win32more.Windows.ApplicationModel.Appointments.IAppointment2) -> Boolean: ...
    @winrt_mixinmethod
    def get_IsCanceledMeeting(self: win32more.Windows.ApplicationModel.Appointments.IAppointment2) -> Boolean: ...
    @winrt_mixinmethod
    def put_IsCanceledMeeting(self: win32more.Windows.ApplicationModel.Appointments.IAppointment2, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_IsOrganizedByUser(self: win32more.Windows.ApplicationModel.Appointments.IAppointment2) -> Boolean: ...
    @winrt_mixinmethod
    def put_IsOrganizedByUser(self: win32more.Windows.ApplicationModel.Appointments.IAppointment2, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_ChangeNumber(self: win32more.Windows.ApplicationModel.Appointments.IAppointment3) -> UInt64: ...
    @winrt_mixinmethod
    def get_RemoteChangeNumber(self: win32more.Windows.ApplicationModel.Appointments.IAppointment3) -> UInt64: ...
    @winrt_mixinmethod
    def put_RemoteChangeNumber(self: win32more.Windows.ApplicationModel.Appointments.IAppointment3, value: UInt64) -> Void: ...
    @winrt_mixinmethod
    def get_DetailsKind(self: win32more.Windows.ApplicationModel.Appointments.IAppointment3) -> win32more.Windows.ApplicationModel.Appointments.AppointmentDetailsKind: ...
    @winrt_mixinmethod
    def put_DetailsKind(self: win32more.Windows.ApplicationModel.Appointments.IAppointment3, value: win32more.Windows.ApplicationModel.Appointments.AppointmentDetailsKind) -> Void: ...
    AllDay = property(get_AllDay, put_AllDay)
    AllowNewTimeProposal = property(get_AllowNewTimeProposal, put_AllowNewTimeProposal)
    BusyStatus = property(get_BusyStatus, put_BusyStatus)
    CalendarId = property(get_CalendarId, None)
    ChangeNumber = property(get_ChangeNumber, None)
    Details = property(get_Details, put_Details)
    DetailsKind = property(get_DetailsKind, put_DetailsKind)
    Duration = property(get_Duration, put_Duration)
    HasInvitees = property(get_HasInvitees, None)
    Invitees = property(get_Invitees, None)
    IsCanceledMeeting = property(get_IsCanceledMeeting, put_IsCanceledMeeting)
    IsOrganizedByUser = property(get_IsOrganizedByUser, put_IsOrganizedByUser)
    IsResponseRequested = property(get_IsResponseRequested, put_IsResponseRequested)
    LocalId = property(get_LocalId, None)
    Location = property(get_Location, put_Location)
    OnlineMeetingLink = property(get_OnlineMeetingLink, put_OnlineMeetingLink)
    Organizer = property(get_Organizer, put_Organizer)
    OriginalStartTime = property(get_OriginalStartTime, None)
    Recurrence = property(get_Recurrence, put_Recurrence)
    Reminder = property(get_Reminder, put_Reminder)
    RemoteChangeNumber = property(get_RemoteChangeNumber, put_RemoteChangeNumber)
    ReplyTime = property(get_ReplyTime, put_ReplyTime)
    RoamingId = property(get_RoamingId, put_RoamingId)
    Sensitivity = property(get_Sensitivity, put_Sensitivity)
    StartTime = property(get_StartTime, put_StartTime)
    Subject = property(get_Subject, put_Subject)
    Uri = property(get_Uri, put_Uri)
    UserResponse = property(get_UserResponse, put_UserResponse)
class AppointmentBusyStatus(Enum, Int32):
    Busy = 0
    Tentative = 1
    Free = 2
    OutOfOffice = 3
    WorkingElsewhere = 4
class AppointmentCalendar(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar
    _classid_ = 'Windows.ApplicationModel.Appointments.AppointmentCalendar'
    @winrt_mixinmethod
    def get_DisplayColor(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar) -> win32more.Windows.UI.Color: ...
    @winrt_mixinmethod
    def get_DisplayName(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_DisplayName(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_LocalId(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_IsHidden(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar) -> Boolean: ...
    @winrt_mixinmethod
    def get_OtherAppReadAccess(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar) -> win32more.Windows.ApplicationModel.Appointments.AppointmentCalendarOtherAppReadAccess: ...
    @winrt_mixinmethod
    def put_OtherAppReadAccess(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar, value: win32more.Windows.ApplicationModel.Appointments.AppointmentCalendarOtherAppReadAccess) -> Void: ...
    @winrt_mixinmethod
    def get_OtherAppWriteAccess(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar) -> win32more.Windows.ApplicationModel.Appointments.AppointmentCalendarOtherAppWriteAccess: ...
    @winrt_mixinmethod
    def put_OtherAppWriteAccess(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar, value: win32more.Windows.ApplicationModel.Appointments.AppointmentCalendarOtherAppWriteAccess) -> Void: ...
    @winrt_mixinmethod
    def get_SourceDisplayName(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_SummaryCardView(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar) -> win32more.Windows.ApplicationModel.Appointments.AppointmentSummaryCardView: ...
    @winrt_mixinmethod
    def put_SummaryCardView(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar, value: win32more.Windows.ApplicationModel.Appointments.AppointmentSummaryCardView) -> Void: ...
    @winrt_mixinmethod
    def FindAppointmentsAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar, rangeStart: win32more.Windows.Foundation.DateTime, rangeLength: win32more.Windows.Foundation.TimeSpan) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Appointments.Appointment]]: ...
    @winrt_mixinmethod
    def FindAppointmentsAsyncWithOptions(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar, rangeStart: win32more.Windows.Foundation.DateTime, rangeLength: win32more.Windows.Foundation.TimeSpan, options: win32more.Windows.ApplicationModel.Appointments.FindAppointmentsOptions) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Appointments.Appointment]]: ...
    @winrt_mixinmethod
    def FindExceptionsFromMasterAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar, masterLocalId: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Appointments.AppointmentException]]: ...
    @winrt_mixinmethod
    def FindAllInstancesAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar, masterLocalId: WinRT_String, rangeStart: win32more.Windows.Foundation.DateTime, rangeLength: win32more.Windows.Foundation.TimeSpan) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Appointments.Appointment]]: ...
    @winrt_mixinmethod
    def FindAllInstancesAsyncWithOptions(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar, masterLocalId: WinRT_String, rangeStart: win32more.Windows.Foundation.DateTime, rangeLength: win32more.Windows.Foundation.TimeSpan, pOptions: win32more.Windows.ApplicationModel.Appointments.FindAppointmentsOptions) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Appointments.Appointment]]: ...
    @winrt_mixinmethod
    def GetAppointmentAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar, localId: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Appointments.Appointment]: ...
    @winrt_mixinmethod
    def GetAppointmentInstanceAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar, localId: WinRT_String, instanceStartTime: win32more.Windows.Foundation.DateTime) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Appointments.Appointment]: ...
    @winrt_mixinmethod
    def FindUnexpandedAppointmentsAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Appointments.Appointment]]: ...
    @winrt_mixinmethod
    def FindUnexpandedAppointmentsAsyncWithOptions(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar, options: win32more.Windows.ApplicationModel.Appointments.FindAppointmentsOptions) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Appointments.Appointment]]: ...
    @winrt_mixinmethod
    def DeleteAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_mixinmethod
    def SaveAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_mixinmethod
    def DeleteAppointmentAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar, localId: WinRT_String) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_mixinmethod
    def DeleteAppointmentInstanceAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar, localId: WinRT_String, instanceStartTime: win32more.Windows.Foundation.DateTime) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_mixinmethod
    def SaveAppointmentAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar, pAppointment: win32more.Windows.ApplicationModel.Appointments.Appointment) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_mixinmethod
    def get_SyncManager(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar2) -> win32more.Windows.ApplicationModel.Appointments.AppointmentCalendarSyncManager: ...
    @winrt_mixinmethod
    def get_RemoteId(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar2) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_RemoteId(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar2, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def put_DisplayColor(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar2, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def put_IsHidden(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar2, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_UserDataAccountId(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar2) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_CanCreateOrUpdateAppointments(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar2) -> Boolean: ...
    @winrt_mixinmethod
    def put_CanCreateOrUpdateAppointments(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar2, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_CanCancelMeetings(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar2) -> Boolean: ...
    @winrt_mixinmethod
    def put_CanCancelMeetings(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar2, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_CanForwardMeetings(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar2) -> Boolean: ...
    @winrt_mixinmethod
    def put_CanForwardMeetings(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar2, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_CanProposeNewTimeForMeetings(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar2) -> Boolean: ...
    @winrt_mixinmethod
    def put_CanProposeNewTimeForMeetings(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar2, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_CanUpdateMeetingResponses(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar2) -> Boolean: ...
    @winrt_mixinmethod
    def put_CanUpdateMeetingResponses(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar2, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_CanNotifyInvitees(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar2) -> Boolean: ...
    @winrt_mixinmethod
    def put_CanNotifyInvitees(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar2, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_MustNofityInvitees(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar2) -> Boolean: ...
    @winrt_mixinmethod
    def put_MustNofityInvitees(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar2, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def TryCreateOrUpdateAppointmentAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar2, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment, notifyInvitees: Boolean) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_mixinmethod
    def TryCancelMeetingAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar2, meeting: win32more.Windows.ApplicationModel.Appointments.Appointment, subject: WinRT_String, comment: WinRT_String, notifyInvitees: Boolean) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_mixinmethod
    def TryForwardMeetingAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar2, meeting: win32more.Windows.ApplicationModel.Appointments.Appointment, invitees: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.ApplicationModel.Appointments.AppointmentInvitee], subject: WinRT_String, forwardHeader: WinRT_String, comment: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_mixinmethod
    def TryProposeNewTimeForMeetingAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar2, meeting: win32more.Windows.ApplicationModel.Appointments.Appointment, newStartTime: win32more.Windows.Foundation.DateTime, newDuration: win32more.Windows.Foundation.TimeSpan, subject: WinRT_String, comment: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_mixinmethod
    def TryUpdateMeetingResponseAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar2, meeting: win32more.Windows.ApplicationModel.Appointments.Appointment, response: win32more.Windows.ApplicationModel.Appointments.AppointmentParticipantResponse, subject: WinRT_String, comment: WinRT_String, sendUpdate: Boolean) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_mixinmethod
    def RegisterSyncManagerAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendar3) -> win32more.Windows.Foundation.IAsyncAction: ...
    CanCancelMeetings = property(get_CanCancelMeetings, put_CanCancelMeetings)
    CanCreateOrUpdateAppointments = property(get_CanCreateOrUpdateAppointments, put_CanCreateOrUpdateAppointments)
    CanForwardMeetings = property(get_CanForwardMeetings, put_CanForwardMeetings)
    CanNotifyInvitees = property(get_CanNotifyInvitees, put_CanNotifyInvitees)
    CanProposeNewTimeForMeetings = property(get_CanProposeNewTimeForMeetings, put_CanProposeNewTimeForMeetings)
    CanUpdateMeetingResponses = property(get_CanUpdateMeetingResponses, put_CanUpdateMeetingResponses)
    DisplayColor = property(get_DisplayColor, put_DisplayColor)
    DisplayName = property(get_DisplayName, put_DisplayName)
    IsHidden = property(get_IsHidden, put_IsHidden)
    LocalId = property(get_LocalId, None)
    MustNofityInvitees = property(get_MustNofityInvitees, put_MustNofityInvitees)
    OtherAppReadAccess = property(get_OtherAppReadAccess, put_OtherAppReadAccess)
    OtherAppWriteAccess = property(get_OtherAppWriteAccess, put_OtherAppWriteAccess)
    RemoteId = property(get_RemoteId, put_RemoteId)
    SourceDisplayName = property(get_SourceDisplayName, None)
    SummaryCardView = property(get_SummaryCardView, put_SummaryCardView)
    SyncManager = property(get_SyncManager, None)
    UserDataAccountId = property(get_UserDataAccountId, None)
class AppointmentCalendarOtherAppReadAccess(Enum, Int32):
    SystemOnly = 0
    Limited = 1
    Full = 2
    None_ = 3
class AppointmentCalendarOtherAppWriteAccess(Enum, Int32):
    None_ = 0
    SystemOnly = 1
    Limited = 2
class AppointmentCalendarSyncManager(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendarSyncManager
    _classid_ = 'Windows.ApplicationModel.Appointments.AppointmentCalendarSyncManager'
    @winrt_mixinmethod
    def get_Status(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendarSyncManager) -> win32more.Windows.ApplicationModel.Appointments.AppointmentCalendarSyncStatus: ...
    @winrt_mixinmethod
    def get_LastSuccessfulSyncTime(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendarSyncManager) -> win32more.Windows.Foundation.DateTime: ...
    @winrt_mixinmethod
    def get_LastAttemptedSyncTime(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendarSyncManager) -> win32more.Windows.Foundation.DateTime: ...
    @winrt_mixinmethod
    def SyncAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendarSyncManager) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_mixinmethod
    def add_SyncStatusChanged(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendarSyncManager, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.ApplicationModel.Appointments.AppointmentCalendarSyncManager, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_SyncStatusChanged(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendarSyncManager, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def put_Status(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendarSyncManager2, value: win32more.Windows.ApplicationModel.Appointments.AppointmentCalendarSyncStatus) -> Void: ...
    @winrt_mixinmethod
    def put_LastSuccessfulSyncTime(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendarSyncManager2, value: win32more.Windows.Foundation.DateTime) -> Void: ...
    @winrt_mixinmethod
    def put_LastAttemptedSyncTime(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentCalendarSyncManager2, value: win32more.Windows.Foundation.DateTime) -> Void: ...
    LastAttemptedSyncTime = property(get_LastAttemptedSyncTime, put_LastAttemptedSyncTime)
    LastSuccessfulSyncTime = property(get_LastSuccessfulSyncTime, put_LastSuccessfulSyncTime)
    Status = property(get_Status, put_Status)
    SyncStatusChanged = event()
class AppointmentCalendarSyncStatus(Enum, Int32):
    Idle = 0
    Syncing = 1
    UpToDate = 2
    AuthenticationError = 3
    PolicyError = 4
    UnknownError = 5
    ManualAccountRemovalRequired = 6
class AppointmentConflictResult(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.ApplicationModel.Appointments.IAppointmentConflictResult
    _classid_ = 'Windows.ApplicationModel.Appointments.AppointmentConflictResult'
    @winrt_mixinmethod
    def get_Type(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentConflictResult) -> win32more.Windows.ApplicationModel.Appointments.AppointmentConflictType: ...
    @winrt_mixinmethod
    def get_Date(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentConflictResult) -> win32more.Windows.Foundation.DateTime: ...
    Date = property(get_Date, None)
    Type = property(get_Type, None)
class AppointmentConflictType(Enum, Int32):
    None_ = 0
    Adjacent = 1
    Overlap = 2
class AppointmentDaysOfWeek(Enum, UInt32):
    None_ = 0
    Sunday = 1
    Monday = 2
    Tuesday = 4
    Wednesday = 8
    Thursday = 16
    Friday = 32
    Saturday = 64
class AppointmentDetailsKind(Enum, Int32):
    PlainText = 0
    Html = 1
class AppointmentException(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.ApplicationModel.Appointments.IAppointmentException
    _classid_ = 'Windows.ApplicationModel.Appointments.AppointmentException'
    @winrt_mixinmethod
    def get_Appointment(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentException) -> win32more.Windows.ApplicationModel.Appointments.Appointment: ...
    @winrt_mixinmethod
    def get_ExceptionProperties(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentException) -> win32more.Windows.Foundation.Collections.IVectorView[WinRT_String]: ...
    @winrt_mixinmethod
    def get_IsDeleted(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentException) -> Boolean: ...
    Appointment = property(get_Appointment, None)
    ExceptionProperties = property(get_ExceptionProperties, None)
    IsDeleted = property(get_IsDeleted, None)
class AppointmentInvitee(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.ApplicationModel.Appointments.IAppointmentInvitee
    _classid_ = 'Windows.ApplicationModel.Appointments.AppointmentInvitee'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.ApplicationModel.Appointments.AppointmentInvitee.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.ApplicationModel.Appointments.AppointmentInvitee: ...
    @winrt_mixinmethod
    def get_Role(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentInvitee) -> win32more.Windows.ApplicationModel.Appointments.AppointmentParticipantRole: ...
    @winrt_mixinmethod
    def put_Role(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentInvitee, value: win32more.Windows.ApplicationModel.Appointments.AppointmentParticipantRole) -> Void: ...
    @winrt_mixinmethod
    def get_Response(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentInvitee) -> win32more.Windows.ApplicationModel.Appointments.AppointmentParticipantResponse: ...
    @winrt_mixinmethod
    def put_Response(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentInvitee, value: win32more.Windows.ApplicationModel.Appointments.AppointmentParticipantResponse) -> Void: ...
    @winrt_mixinmethod
    def get_DisplayName(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentParticipant) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_DisplayName(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentParticipant, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Address(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentParticipant) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Address(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentParticipant, value: WinRT_String) -> Void: ...
    Address = property(get_Address, put_Address)
    DisplayName = property(get_DisplayName, put_DisplayName)
    Response = property(get_Response, put_Response)
    Role = property(get_Role, put_Role)
class AppointmentManager(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.AppointmentManager'
    @winrt_classmethod
    def GetForUser(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentManagerStatics3, user: win32more.Windows.System.User) -> win32more.Windows.ApplicationModel.Appointments.AppointmentManagerForUser: ...
    @winrt_classmethod
    def ShowAppointmentDetailsAsync(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentManagerStatics2, appointmentId: WinRT_String) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_classmethod
    def ShowAppointmentDetailsWithDateAsync(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentManagerStatics2, appointmentId: WinRT_String, instanceStartDate: win32more.Windows.Foundation.DateTime) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_classmethod
    def ShowEditNewAppointmentAsync(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentManagerStatics2, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment) -> win32more.Windows.Foundation.IAsyncOperation[WinRT_String]: ...
    @winrt_classmethod
    def RequestStoreAsync(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentManagerStatics2, options: win32more.Windows.ApplicationModel.Appointments.AppointmentStoreAccessType) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Appointments.AppointmentStore]: ...
    @winrt_classmethod
    def ShowAddAppointmentAsync(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentManagerStatics, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment, selection: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.IAsyncOperation[WinRT_String]: ...
    @winrt_classmethod
    def ShowAddAppointmentWithPlacementAsync(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentManagerStatics, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment, selection: win32more.Windows.Foundation.Rect, preferredPlacement: win32more.Windows.UI.Popups.Placement) -> win32more.Windows.Foundation.IAsyncOperation[WinRT_String]: ...
    @winrt_classmethod
    def ShowReplaceAppointmentAsync(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentManagerStatics, appointmentId: WinRT_String, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment, selection: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.IAsyncOperation[WinRT_String]: ...
    @winrt_classmethod
    def ShowReplaceAppointmentWithPlacementAsync(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentManagerStatics, appointmentId: WinRT_String, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment, selection: win32more.Windows.Foundation.Rect, preferredPlacement: win32more.Windows.UI.Popups.Placement) -> win32more.Windows.Foundation.IAsyncOperation[WinRT_String]: ...
    @winrt_classmethod
    def ShowReplaceAppointmentWithPlacementAndDateAsync(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentManagerStatics, appointmentId: WinRT_String, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment, selection: win32more.Windows.Foundation.Rect, preferredPlacement: win32more.Windows.UI.Popups.Placement, instanceStartDate: win32more.Windows.Foundation.DateTime) -> win32more.Windows.Foundation.IAsyncOperation[WinRT_String]: ...
    @winrt_classmethod
    def ShowRemoveAppointmentAsync(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentManagerStatics, appointmentId: WinRT_String, selection: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_classmethod
    def ShowRemoveAppointmentWithPlacementAsync(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentManagerStatics, appointmentId: WinRT_String, selection: win32more.Windows.Foundation.Rect, preferredPlacement: win32more.Windows.UI.Popups.Placement) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_classmethod
    def ShowRemoveAppointmentWithPlacementAndDateAsync(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentManagerStatics, appointmentId: WinRT_String, selection: win32more.Windows.Foundation.Rect, preferredPlacement: win32more.Windows.UI.Popups.Placement, instanceStartDate: win32more.Windows.Foundation.DateTime) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_classmethod
    def ShowTimeFrameAsync(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentManagerStatics, timeToShow: win32more.Windows.Foundation.DateTime, duration: win32more.Windows.Foundation.TimeSpan) -> win32more.Windows.Foundation.IAsyncAction: ...
class AppointmentManagerForUser(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.ApplicationModel.Appointments.IAppointmentManagerForUser
    _classid_ = 'Windows.ApplicationModel.Appointments.AppointmentManagerForUser'
    @winrt_mixinmethod
    def ShowAddAppointmentAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentManagerForUser, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment, selection: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.IAsyncOperation[WinRT_String]: ...
    @winrt_mixinmethod
    def ShowAddAppointmentWithPlacementAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentManagerForUser, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment, selection: win32more.Windows.Foundation.Rect, preferredPlacement: win32more.Windows.UI.Popups.Placement) -> win32more.Windows.Foundation.IAsyncOperation[WinRT_String]: ...
    @winrt_mixinmethod
    def ShowReplaceAppointmentAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentManagerForUser, appointmentId: WinRT_String, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment, selection: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.IAsyncOperation[WinRT_String]: ...
    @winrt_mixinmethod
    def ShowReplaceAppointmentWithPlacementAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentManagerForUser, appointmentId: WinRT_String, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment, selection: win32more.Windows.Foundation.Rect, preferredPlacement: win32more.Windows.UI.Popups.Placement) -> win32more.Windows.Foundation.IAsyncOperation[WinRT_String]: ...
    @winrt_mixinmethod
    def ShowReplaceAppointmentWithPlacementAndDateAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentManagerForUser, appointmentId: WinRT_String, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment, selection: win32more.Windows.Foundation.Rect, preferredPlacement: win32more.Windows.UI.Popups.Placement, instanceStartDate: win32more.Windows.Foundation.DateTime) -> win32more.Windows.Foundation.IAsyncOperation[WinRT_String]: ...
    @winrt_mixinmethod
    def ShowRemoveAppointmentAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentManagerForUser, appointmentId: WinRT_String, selection: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_mixinmethod
    def ShowRemoveAppointmentWithPlacementAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentManagerForUser, appointmentId: WinRT_String, selection: win32more.Windows.Foundation.Rect, preferredPlacement: win32more.Windows.UI.Popups.Placement) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_mixinmethod
    def ShowRemoveAppointmentWithPlacementAndDateAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentManagerForUser, appointmentId: WinRT_String, selection: win32more.Windows.Foundation.Rect, preferredPlacement: win32more.Windows.UI.Popups.Placement, instanceStartDate: win32more.Windows.Foundation.DateTime) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_mixinmethod
    def ShowTimeFrameAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentManagerForUser, timeToShow: win32more.Windows.Foundation.DateTime, duration: win32more.Windows.Foundation.TimeSpan) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_mixinmethod
    def ShowAppointmentDetailsAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentManagerForUser, appointmentId: WinRT_String) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_mixinmethod
    def ShowAppointmentDetailsWithDateAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentManagerForUser, appointmentId: WinRT_String, instanceStartDate: win32more.Windows.Foundation.DateTime) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_mixinmethod
    def ShowEditNewAppointmentAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentManagerForUser, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment) -> win32more.Windows.Foundation.IAsyncOperation[WinRT_String]: ...
    @winrt_mixinmethod
    def RequestStoreAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentManagerForUser, options: win32more.Windows.ApplicationModel.Appointments.AppointmentStoreAccessType) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Appointments.AppointmentStore]: ...
    @winrt_mixinmethod
    def get_User(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentManagerForUser) -> win32more.Windows.System.User: ...
    User = property(get_User, None)
class AppointmentOrganizer(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.ApplicationModel.Appointments.IAppointmentParticipant
    _classid_ = 'Windows.ApplicationModel.Appointments.AppointmentOrganizer'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.ApplicationModel.Appointments.AppointmentOrganizer.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.ApplicationModel.Appointments.AppointmentOrganizer: ...
    @winrt_mixinmethod
    def get_DisplayName(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentParticipant) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_DisplayName(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentParticipant, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Address(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentParticipant) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_Address(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentParticipant, value: WinRT_String) -> Void: ...
    Address = property(get_Address, put_Address)
    DisplayName = property(get_DisplayName, put_DisplayName)
class AppointmentParticipantResponse(Enum, Int32):
    None_ = 0
    Tentative = 1
    Accepted = 2
    Declined = 3
    Unknown = 4
class AppointmentParticipantRole(Enum, Int32):
    RequiredAttendee = 0
    OptionalAttendee = 1
    Resource = 2
class _AppointmentProperties_Meta_(ComPtr.__class__):
    pass
class AppointmentProperties(ComPtr, metaclass=_AppointmentProperties_Meta_):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.AppointmentProperties'
    @winrt_classmethod
    def get_ChangeNumber(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentPropertiesStatics2) -> WinRT_String: ...
    @winrt_classmethod
    def get_RemoteChangeNumber(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentPropertiesStatics2) -> WinRT_String: ...
    @winrt_classmethod
    def get_DetailsKind(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentPropertiesStatics2) -> WinRT_String: ...
    @winrt_classmethod
    def get_Subject(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentPropertiesStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Location(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentPropertiesStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_StartTime(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentPropertiesStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Duration(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentPropertiesStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Reminder(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentPropertiesStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_BusyStatus(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentPropertiesStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Sensitivity(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentPropertiesStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_OriginalStartTime(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentPropertiesStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_IsResponseRequested(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentPropertiesStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_AllowNewTimeProposal(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentPropertiesStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_AllDay(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentPropertiesStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Details(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentPropertiesStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_OnlineMeetingLink(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentPropertiesStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_ReplyTime(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentPropertiesStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Organizer(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentPropertiesStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_UserResponse(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentPropertiesStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_HasInvitees(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentPropertiesStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_IsCanceledMeeting(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentPropertiesStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_IsOrganizedByUser(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentPropertiesStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Recurrence(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentPropertiesStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Uri(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentPropertiesStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Invitees(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentPropertiesStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_DefaultProperties(cls: win32more.Windows.ApplicationModel.Appointments.IAppointmentPropertiesStatics) -> win32more.Windows.Foundation.Collections.IVector[WinRT_String]: ...
    _AppointmentProperties_Meta_.AllDay = property(get_AllDay, None)
    _AppointmentProperties_Meta_.AllowNewTimeProposal = property(get_AllowNewTimeProposal, None)
    _AppointmentProperties_Meta_.BusyStatus = property(get_BusyStatus, None)
    _AppointmentProperties_Meta_.ChangeNumber = property(get_ChangeNumber, None)
    _AppointmentProperties_Meta_.DefaultProperties = property(get_DefaultProperties, None)
    _AppointmentProperties_Meta_.Details = property(get_Details, None)
    _AppointmentProperties_Meta_.DetailsKind = property(get_DetailsKind, None)
    _AppointmentProperties_Meta_.Duration = property(get_Duration, None)
    _AppointmentProperties_Meta_.HasInvitees = property(get_HasInvitees, None)
    _AppointmentProperties_Meta_.Invitees = property(get_Invitees, None)
    _AppointmentProperties_Meta_.IsCanceledMeeting = property(get_IsCanceledMeeting, None)
    _AppointmentProperties_Meta_.IsOrganizedByUser = property(get_IsOrganizedByUser, None)
    _AppointmentProperties_Meta_.IsResponseRequested = property(get_IsResponseRequested, None)
    _AppointmentProperties_Meta_.Location = property(get_Location, None)
    _AppointmentProperties_Meta_.OnlineMeetingLink = property(get_OnlineMeetingLink, None)
    _AppointmentProperties_Meta_.Organizer = property(get_Organizer, None)
    _AppointmentProperties_Meta_.OriginalStartTime = property(get_OriginalStartTime, None)
    _AppointmentProperties_Meta_.Recurrence = property(get_Recurrence, None)
    _AppointmentProperties_Meta_.Reminder = property(get_Reminder, None)
    _AppointmentProperties_Meta_.RemoteChangeNumber = property(get_RemoteChangeNumber, None)
    _AppointmentProperties_Meta_.ReplyTime = property(get_ReplyTime, None)
    _AppointmentProperties_Meta_.Sensitivity = property(get_Sensitivity, None)
    _AppointmentProperties_Meta_.StartTime = property(get_StartTime, None)
    _AppointmentProperties_Meta_.Subject = property(get_Subject, None)
    _AppointmentProperties_Meta_.Uri = property(get_Uri, None)
    _AppointmentProperties_Meta_.UserResponse = property(get_UserResponse, None)
class AppointmentRecurrence(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.ApplicationModel.Appointments.IAppointmentRecurrence
    _classid_ = 'Windows.ApplicationModel.Appointments.AppointmentRecurrence'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.ApplicationModel.Appointments.AppointmentRecurrence.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.ApplicationModel.Appointments.AppointmentRecurrence: ...
    @winrt_mixinmethod
    def get_Unit(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentRecurrence) -> win32more.Windows.ApplicationModel.Appointments.AppointmentRecurrenceUnit: ...
    @winrt_mixinmethod
    def put_Unit(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentRecurrence, value: win32more.Windows.ApplicationModel.Appointments.AppointmentRecurrenceUnit) -> Void: ...
    @winrt_mixinmethod
    def get_Occurrences(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentRecurrence) -> win32more.Windows.Foundation.IReference[UInt32]: ...
    @winrt_mixinmethod
    def put_Occurrences(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentRecurrence, value: win32more.Windows.Foundation.IReference[UInt32]) -> Void: ...
    @winrt_mixinmethod
    def get_Until(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentRecurrence) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]: ...
    @winrt_mixinmethod
    def put_Until(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentRecurrence, value: win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]) -> Void: ...
    @winrt_mixinmethod
    def get_Interval(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentRecurrence) -> UInt32: ...
    @winrt_mixinmethod
    def put_Interval(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentRecurrence, value: UInt32) -> Void: ...
    @winrt_mixinmethod
    def get_DaysOfWeek(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentRecurrence) -> win32more.Windows.ApplicationModel.Appointments.AppointmentDaysOfWeek: ...
    @winrt_mixinmethod
    def put_DaysOfWeek(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentRecurrence, value: win32more.Windows.ApplicationModel.Appointments.AppointmentDaysOfWeek) -> Void: ...
    @winrt_mixinmethod
    def get_WeekOfMonth(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentRecurrence) -> win32more.Windows.ApplicationModel.Appointments.AppointmentWeekOfMonth: ...
    @winrt_mixinmethod
    def put_WeekOfMonth(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentRecurrence, value: win32more.Windows.ApplicationModel.Appointments.AppointmentWeekOfMonth) -> Void: ...
    @winrt_mixinmethod
    def get_Month(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentRecurrence) -> UInt32: ...
    @winrt_mixinmethod
    def put_Month(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentRecurrence, value: UInt32) -> Void: ...
    @winrt_mixinmethod
    def get_Day(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentRecurrence) -> UInt32: ...
    @winrt_mixinmethod
    def put_Day(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentRecurrence, value: UInt32) -> Void: ...
    @winrt_mixinmethod
    def get_RecurrenceType(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentRecurrence2) -> win32more.Windows.ApplicationModel.Appointments.RecurrenceType: ...
    @winrt_mixinmethod
    def get_TimeZone(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentRecurrence2) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_TimeZone(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentRecurrence2, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_CalendarIdentifier(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentRecurrence3) -> WinRT_String: ...
    CalendarIdentifier = property(get_CalendarIdentifier, None)
    Day = property(get_Day, put_Day)
    DaysOfWeek = property(get_DaysOfWeek, put_DaysOfWeek)
    Interval = property(get_Interval, put_Interval)
    Month = property(get_Month, put_Month)
    Occurrences = property(get_Occurrences, put_Occurrences)
    RecurrenceType = property(get_RecurrenceType, None)
    TimeZone = property(get_TimeZone, put_TimeZone)
    Unit = property(get_Unit, put_Unit)
    Until = property(get_Until, put_Until)
    WeekOfMonth = property(get_WeekOfMonth, put_WeekOfMonth)
class AppointmentRecurrenceUnit(Enum, Int32):
    Daily = 0
    Weekly = 1
    Monthly = 2
    MonthlyOnDay = 3
    Yearly = 4
    YearlyOnDay = 5
class AppointmentSensitivity(Enum, Int32):
    Public = 0
    Private = 1
class AppointmentStore(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.ApplicationModel.Appointments.IAppointmentStore
    _classid_ = 'Windows.ApplicationModel.Appointments.AppointmentStore'
    @winrt_mixinmethod
    def get_ChangeTracker(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStore) -> win32more.Windows.ApplicationModel.Appointments.AppointmentStoreChangeTracker: ...
    @winrt_mixinmethod
    def CreateAppointmentCalendarAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStore, name: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Appointments.AppointmentCalendar]: ...
    @winrt_mixinmethod
    def GetAppointmentCalendarAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStore, calendarId: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Appointments.AppointmentCalendar]: ...
    @winrt_mixinmethod
    def GetAppointmentAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStore, localId: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Appointments.Appointment]: ...
    @winrt_mixinmethod
    def GetAppointmentInstanceAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStore, localId: WinRT_String, instanceStartTime: win32more.Windows.Foundation.DateTime) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Appointments.Appointment]: ...
    @winrt_mixinmethod
    def FindAppointmentCalendarsAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStore) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Appointments.AppointmentCalendar]]: ...
    @winrt_mixinmethod
    def FindAppointmentCalendarsAsyncWithOptions(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStore, options: win32more.Windows.ApplicationModel.Appointments.FindAppointmentCalendarsOptions) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Appointments.AppointmentCalendar]]: ...
    @winrt_mixinmethod
    def FindAppointmentsAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStore, rangeStart: win32more.Windows.Foundation.DateTime, rangeLength: win32more.Windows.Foundation.TimeSpan) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Appointments.Appointment]]: ...
    @winrt_mixinmethod
    def FindAppointmentsAsyncWithOptions(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStore, rangeStart: win32more.Windows.Foundation.DateTime, rangeLength: win32more.Windows.Foundation.TimeSpan, options: win32more.Windows.ApplicationModel.Appointments.FindAppointmentsOptions) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Appointments.Appointment]]: ...
    @winrt_mixinmethod
    def FindConflictAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStore, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Appointments.AppointmentConflictResult]: ...
    @winrt_mixinmethod
    def FindConflictAsyncWithInstanceStart(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStore, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment, instanceStartTime: win32more.Windows.Foundation.DateTime) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Appointments.AppointmentConflictResult]: ...
    @winrt_mixinmethod
    def MoveAppointmentAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStore, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment, destinationCalendar: win32more.Windows.ApplicationModel.Appointments.AppointmentCalendar) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_mixinmethod
    def ShowAddAppointmentAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStore, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment, selection: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.IAsyncOperation[WinRT_String]: ...
    @winrt_mixinmethod
    def ShowReplaceAppointmentAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStore, localId: WinRT_String, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment, selection: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.IAsyncOperation[WinRT_String]: ...
    @winrt_mixinmethod
    def ShowReplaceAppointmentWithPlacementAndDateAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStore, localId: WinRT_String, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment, selection: win32more.Windows.Foundation.Rect, preferredPlacement: win32more.Windows.UI.Popups.Placement, instanceStartDate: win32more.Windows.Foundation.DateTime) -> win32more.Windows.Foundation.IAsyncOperation[WinRT_String]: ...
    @winrt_mixinmethod
    def ShowRemoveAppointmentAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStore, localId: WinRT_String, selection: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_mixinmethod
    def ShowRemoveAppointmentWithPlacementAndDateAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStore, localId: WinRT_String, selection: win32more.Windows.Foundation.Rect, preferredPlacement: win32more.Windows.UI.Popups.Placement, instanceStartDate: win32more.Windows.Foundation.DateTime) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_mixinmethod
    def ShowAppointmentDetailsAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStore, localId: WinRT_String) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_mixinmethod
    def ShowAppointmentDetailsWithDateAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStore, localId: WinRT_String, instanceStartDate: win32more.Windows.Foundation.DateTime) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_mixinmethod
    def ShowEditNewAppointmentAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStore, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment) -> win32more.Windows.Foundation.IAsyncOperation[WinRT_String]: ...
    @winrt_mixinmethod
    def FindLocalIdsFromRoamingIdAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStore, roamingId: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[WinRT_String]]: ...
    @winrt_mixinmethod
    def add_StoreChanged(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStore2, pHandler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.ApplicationModel.Appointments.AppointmentStore, win32more.Windows.ApplicationModel.Appointments.AppointmentStoreChangedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_StoreChanged(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStore2, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def CreateAppointmentCalendarInAccountAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStore2, name: WinRT_String, userDataAccountId: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Appointments.AppointmentCalendar]: ...
    @winrt_mixinmethod
    def GetChangeTracker(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStore3, identity: WinRT_String) -> win32more.Windows.ApplicationModel.Appointments.AppointmentStoreChangeTracker: ...
    ChangeTracker = property(get_ChangeTracker, None)
    StoreChanged = event()
class AppointmentStoreAccessType(Enum, Int32):
    AppCalendarsReadWrite = 0
    AllCalendarsReadOnly = 1
    AllCalendarsReadWrite = 2
class AppointmentStoreChange(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.ApplicationModel.Appointments.IAppointmentStoreChange
    _classid_ = 'Windows.ApplicationModel.Appointments.AppointmentStoreChange'
    @winrt_mixinmethod
    def get_Appointment(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStoreChange) -> win32more.Windows.ApplicationModel.Appointments.Appointment: ...
    @winrt_mixinmethod
    def get_ChangeType(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStoreChange) -> win32more.Windows.ApplicationModel.Appointments.AppointmentStoreChangeType: ...
    @winrt_mixinmethod
    def get_AppointmentCalendar(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStoreChange2) -> win32more.Windows.ApplicationModel.Appointments.AppointmentCalendar: ...
    Appointment = property(get_Appointment, None)
    AppointmentCalendar = property(get_AppointmentCalendar, None)
    ChangeType = property(get_ChangeType, None)
class AppointmentStoreChangeReader(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.ApplicationModel.Appointments.IAppointmentStoreChangeReader
    _classid_ = 'Windows.ApplicationModel.Appointments.AppointmentStoreChangeReader'
    @winrt_mixinmethod
    def ReadBatchAsync(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStoreChangeReader) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Appointments.AppointmentStoreChange]]: ...
    @winrt_mixinmethod
    def AcceptChanges(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStoreChangeReader) -> Void: ...
    @winrt_mixinmethod
    def AcceptChangesThrough(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStoreChangeReader, lastChangeToAccept: win32more.Windows.ApplicationModel.Appointments.AppointmentStoreChange) -> Void: ...
class AppointmentStoreChangeTracker(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.ApplicationModel.Appointments.IAppointmentStoreChangeTracker
    _classid_ = 'Windows.ApplicationModel.Appointments.AppointmentStoreChangeTracker'
    @winrt_mixinmethod
    def GetChangeReader(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStoreChangeTracker) -> win32more.Windows.ApplicationModel.Appointments.AppointmentStoreChangeReader: ...
    @winrt_mixinmethod
    def Enable(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStoreChangeTracker) -> Void: ...
    @winrt_mixinmethod
    def Reset(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStoreChangeTracker) -> Void: ...
    @winrt_mixinmethod
    def get_IsTracking(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStoreChangeTracker2) -> Boolean: ...
    IsTracking = property(get_IsTracking, None)
class AppointmentStoreChangeType(Enum, Int32):
    AppointmentCreated = 0
    AppointmentModified = 1
    AppointmentDeleted = 2
    ChangeTrackingLost = 3
    CalendarCreated = 4
    CalendarModified = 5
    CalendarDeleted = 6
class AppointmentStoreChangedDeferral(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.ApplicationModel.Appointments.IAppointmentStoreChangedDeferral
    _classid_ = 'Windows.ApplicationModel.Appointments.AppointmentStoreChangedDeferral'
    @winrt_mixinmethod
    def Complete(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStoreChangedDeferral) -> Void: ...
class AppointmentStoreChangedEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.ApplicationModel.Appointments.IAppointmentStoreChangedEventArgs
    _classid_ = 'Windows.ApplicationModel.Appointments.AppointmentStoreChangedEventArgs'
    @winrt_mixinmethod
    def GetDeferral(self: win32more.Windows.ApplicationModel.Appointments.IAppointmentStoreChangedEventArgs) -> win32more.Windows.ApplicationModel.Appointments.AppointmentStoreChangedDeferral: ...
class AppointmentStoreNotificationTriggerDetails(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.ApplicationModel.Appointments.IAppointmentStoreNotificationTriggerDetails
    _classid_ = 'Windows.ApplicationModel.Appointments.AppointmentStoreNotificationTriggerDetails'
class AppointmentSummaryCardView(Enum, Int32):
    System = 0
    App = 1
class AppointmentWeekOfMonth(Enum, Int32):
    First = 0
    Second = 1
    Third = 2
    Fourth = 3
    Last = 4
class FindAppointmentCalendarsOptions(Enum, UInt32):
    None_ = 0
    IncludeHidden = 1
class FindAppointmentsOptions(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.ApplicationModel.Appointments.IFindAppointmentsOptions
    _classid_ = 'Windows.ApplicationModel.Appointments.FindAppointmentsOptions'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.ApplicationModel.Appointments.FindAppointmentsOptions.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.ApplicationModel.Appointments.FindAppointmentsOptions: ...
    @winrt_mixinmethod
    def get_CalendarIds(self: win32more.Windows.ApplicationModel.Appointments.IFindAppointmentsOptions) -> win32more.Windows.Foundation.Collections.IVector[WinRT_String]: ...
    @winrt_mixinmethod
    def get_FetchProperties(self: win32more.Windows.ApplicationModel.Appointments.IFindAppointmentsOptions) -> win32more.Windows.Foundation.Collections.IVector[WinRT_String]: ...
    @winrt_mixinmethod
    def get_IncludeHidden(self: win32more.Windows.ApplicationModel.Appointments.IFindAppointmentsOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_IncludeHidden(self: win32more.Windows.ApplicationModel.Appointments.IFindAppointmentsOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_MaxCount(self: win32more.Windows.ApplicationModel.Appointments.IFindAppointmentsOptions) -> UInt32: ...
    @winrt_mixinmethod
    def put_MaxCount(self: win32more.Windows.ApplicationModel.Appointments.IFindAppointmentsOptions, value: UInt32) -> Void: ...
    CalendarIds = property(get_CalendarIds, None)
    FetchProperties = property(get_FetchProperties, None)
    IncludeHidden = property(get_IncludeHidden, put_IncludeHidden)
    MaxCount = property(get_MaxCount, put_MaxCount)
class IAppointment(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.IAppointment'
    _iid_ = Guid('{dd002f2f-2bdd-4076-90a3-22c275312965}')
    @winrt_commethod(6)
    def get_StartTime(self) -> win32more.Windows.Foundation.DateTime: ...
    @winrt_commethod(7)
    def put_StartTime(self, value: win32more.Windows.Foundation.DateTime) -> Void: ...
    @winrt_commethod(8)
    def get_Duration(self) -> win32more.Windows.Foundation.TimeSpan: ...
    @winrt_commethod(9)
    def put_Duration(self, value: win32more.Windows.Foundation.TimeSpan) -> Void: ...
    @winrt_commethod(10)
    def get_Location(self) -> WinRT_String: ...
    @winrt_commethod(11)
    def put_Location(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(12)
    def get_Subject(self) -> WinRT_String: ...
    @winrt_commethod(13)
    def put_Subject(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(14)
    def get_Details(self) -> WinRT_String: ...
    @winrt_commethod(15)
    def put_Details(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(16)
    def get_Reminder(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]: ...
    @winrt_commethod(17)
    def put_Reminder(self, value: win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.TimeSpan]) -> Void: ...
    @winrt_commethod(18)
    def get_Organizer(self) -> win32more.Windows.ApplicationModel.Appointments.AppointmentOrganizer: ...
    @winrt_commethod(19)
    def put_Organizer(self, value: win32more.Windows.ApplicationModel.Appointments.AppointmentOrganizer) -> Void: ...
    @winrt_commethod(20)
    def get_Invitees(self) -> win32more.Windows.Foundation.Collections.IVector[win32more.Windows.ApplicationModel.Appointments.AppointmentInvitee]: ...
    @winrt_commethod(21)
    def get_Recurrence(self) -> win32more.Windows.ApplicationModel.Appointments.AppointmentRecurrence: ...
    @winrt_commethod(22)
    def put_Recurrence(self, value: win32more.Windows.ApplicationModel.Appointments.AppointmentRecurrence) -> Void: ...
    @winrt_commethod(23)
    def get_BusyStatus(self) -> win32more.Windows.ApplicationModel.Appointments.AppointmentBusyStatus: ...
    @winrt_commethod(24)
    def put_BusyStatus(self, value: win32more.Windows.ApplicationModel.Appointments.AppointmentBusyStatus) -> Void: ...
    @winrt_commethod(25)
    def get_AllDay(self) -> Boolean: ...
    @winrt_commethod(26)
    def put_AllDay(self, value: Boolean) -> Void: ...
    @winrt_commethod(27)
    def get_Sensitivity(self) -> win32more.Windows.ApplicationModel.Appointments.AppointmentSensitivity: ...
    @winrt_commethod(28)
    def put_Sensitivity(self, value: win32more.Windows.ApplicationModel.Appointments.AppointmentSensitivity) -> Void: ...
    @winrt_commethod(29)
    def get_Uri(self) -> win32more.Windows.Foundation.Uri: ...
    @winrt_commethod(30)
    def put_Uri(self, value: win32more.Windows.Foundation.Uri) -> Void: ...
    AllDay = property(get_AllDay, put_AllDay)
    BusyStatus = property(get_BusyStatus, put_BusyStatus)
    Details = property(get_Details, put_Details)
    Duration = property(get_Duration, put_Duration)
    Invitees = property(get_Invitees, None)
    Location = property(get_Location, put_Location)
    Organizer = property(get_Organizer, put_Organizer)
    Recurrence = property(get_Recurrence, put_Recurrence)
    Reminder = property(get_Reminder, put_Reminder)
    Sensitivity = property(get_Sensitivity, put_Sensitivity)
    StartTime = property(get_StartTime, put_StartTime)
    Subject = property(get_Subject, put_Subject)
    Uri = property(get_Uri, put_Uri)
class IAppointment2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.IAppointment2'
    _iid_ = Guid('{5e85983c-540f-3452-9b5c-0dd7ad4c65a2}')
    @winrt_commethod(6)
    def get_LocalId(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def get_CalendarId(self) -> WinRT_String: ...
    @winrt_commethod(8)
    def get_RoamingId(self) -> WinRT_String: ...
    @winrt_commethod(9)
    def put_RoamingId(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(10)
    def get_OriginalStartTime(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]: ...
    @winrt_commethod(11)
    def get_IsResponseRequested(self) -> Boolean: ...
    @winrt_commethod(12)
    def put_IsResponseRequested(self, value: Boolean) -> Void: ...
    @winrt_commethod(13)
    def get_AllowNewTimeProposal(self) -> Boolean: ...
    @winrt_commethod(14)
    def put_AllowNewTimeProposal(self, value: Boolean) -> Void: ...
    @winrt_commethod(15)
    def get_OnlineMeetingLink(self) -> WinRT_String: ...
    @winrt_commethod(16)
    def put_OnlineMeetingLink(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(17)
    def get_ReplyTime(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]: ...
    @winrt_commethod(18)
    def put_ReplyTime(self, value: win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]) -> Void: ...
    @winrt_commethod(19)
    def get_UserResponse(self) -> win32more.Windows.ApplicationModel.Appointments.AppointmentParticipantResponse: ...
    @winrt_commethod(20)
    def put_UserResponse(self, value: win32more.Windows.ApplicationModel.Appointments.AppointmentParticipantResponse) -> Void: ...
    @winrt_commethod(21)
    def get_HasInvitees(self) -> Boolean: ...
    @winrt_commethod(22)
    def get_IsCanceledMeeting(self) -> Boolean: ...
    @winrt_commethod(23)
    def put_IsCanceledMeeting(self, value: Boolean) -> Void: ...
    @winrt_commethod(24)
    def get_IsOrganizedByUser(self) -> Boolean: ...
    @winrt_commethod(25)
    def put_IsOrganizedByUser(self, value: Boolean) -> Void: ...
    AllowNewTimeProposal = property(get_AllowNewTimeProposal, put_AllowNewTimeProposal)
    CalendarId = property(get_CalendarId, None)
    HasInvitees = property(get_HasInvitees, None)
    IsCanceledMeeting = property(get_IsCanceledMeeting, put_IsCanceledMeeting)
    IsOrganizedByUser = property(get_IsOrganizedByUser, put_IsOrganizedByUser)
    IsResponseRequested = property(get_IsResponseRequested, put_IsResponseRequested)
    LocalId = property(get_LocalId, None)
    OnlineMeetingLink = property(get_OnlineMeetingLink, put_OnlineMeetingLink)
    OriginalStartTime = property(get_OriginalStartTime, None)
    ReplyTime = property(get_ReplyTime, put_ReplyTime)
    RoamingId = property(get_RoamingId, put_RoamingId)
    UserResponse = property(get_UserResponse, put_UserResponse)
class IAppointment3(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.IAppointment3'
    _iid_ = Guid('{bfcc45a9-8961-4991-934b-c48768e5a96c}')
    @winrt_commethod(6)
    def get_ChangeNumber(self) -> UInt64: ...
    @winrt_commethod(7)
    def get_RemoteChangeNumber(self) -> UInt64: ...
    @winrt_commethod(8)
    def put_RemoteChangeNumber(self, value: UInt64) -> Void: ...
    @winrt_commethod(9)
    def get_DetailsKind(self) -> win32more.Windows.ApplicationModel.Appointments.AppointmentDetailsKind: ...
    @winrt_commethod(10)
    def put_DetailsKind(self, value: win32more.Windows.ApplicationModel.Appointments.AppointmentDetailsKind) -> Void: ...
    ChangeNumber = property(get_ChangeNumber, None)
    DetailsKind = property(get_DetailsKind, put_DetailsKind)
    RemoteChangeNumber = property(get_RemoteChangeNumber, put_RemoteChangeNumber)
class IAppointmentCalendar(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.IAppointmentCalendar'
    _iid_ = Guid('{5273819d-8339-3d4f-a02f-64084452bb5d}')
    @winrt_commethod(6)
    def get_DisplayColor(self) -> win32more.Windows.UI.Color: ...
    @winrt_commethod(7)
    def get_DisplayName(self) -> WinRT_String: ...
    @winrt_commethod(8)
    def put_DisplayName(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(9)
    def get_LocalId(self) -> WinRT_String: ...
    @winrt_commethod(10)
    def get_IsHidden(self) -> Boolean: ...
    @winrt_commethod(11)
    def get_OtherAppReadAccess(self) -> win32more.Windows.ApplicationModel.Appointments.AppointmentCalendarOtherAppReadAccess: ...
    @winrt_commethod(12)
    def put_OtherAppReadAccess(self, value: win32more.Windows.ApplicationModel.Appointments.AppointmentCalendarOtherAppReadAccess) -> Void: ...
    @winrt_commethod(13)
    def get_OtherAppWriteAccess(self) -> win32more.Windows.ApplicationModel.Appointments.AppointmentCalendarOtherAppWriteAccess: ...
    @winrt_commethod(14)
    def put_OtherAppWriteAccess(self, value: win32more.Windows.ApplicationModel.Appointments.AppointmentCalendarOtherAppWriteAccess) -> Void: ...
    @winrt_commethod(15)
    def get_SourceDisplayName(self) -> WinRT_String: ...
    @winrt_commethod(16)
    def get_SummaryCardView(self) -> win32more.Windows.ApplicationModel.Appointments.AppointmentSummaryCardView: ...
    @winrt_commethod(17)
    def put_SummaryCardView(self, value: win32more.Windows.ApplicationModel.Appointments.AppointmentSummaryCardView) -> Void: ...
    @winrt_commethod(18)
    def FindAppointmentsAsync(self, rangeStart: win32more.Windows.Foundation.DateTime, rangeLength: win32more.Windows.Foundation.TimeSpan) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Appointments.Appointment]]: ...
    @winrt_commethod(19)
    def FindAppointmentsAsyncWithOptions(self, rangeStart: win32more.Windows.Foundation.DateTime, rangeLength: win32more.Windows.Foundation.TimeSpan, options: win32more.Windows.ApplicationModel.Appointments.FindAppointmentsOptions) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Appointments.Appointment]]: ...
    @winrt_commethod(20)
    def FindExceptionsFromMasterAsync(self, masterLocalId: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Appointments.AppointmentException]]: ...
    @winrt_commethod(21)
    def FindAllInstancesAsync(self, masterLocalId: WinRT_String, rangeStart: win32more.Windows.Foundation.DateTime, rangeLength: win32more.Windows.Foundation.TimeSpan) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Appointments.Appointment]]: ...
    @winrt_commethod(22)
    def FindAllInstancesAsyncWithOptions(self, masterLocalId: WinRT_String, rangeStart: win32more.Windows.Foundation.DateTime, rangeLength: win32more.Windows.Foundation.TimeSpan, pOptions: win32more.Windows.ApplicationModel.Appointments.FindAppointmentsOptions) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Appointments.Appointment]]: ...
    @winrt_commethod(23)
    def GetAppointmentAsync(self, localId: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Appointments.Appointment]: ...
    @winrt_commethod(24)
    def GetAppointmentInstanceAsync(self, localId: WinRT_String, instanceStartTime: win32more.Windows.Foundation.DateTime) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Appointments.Appointment]: ...
    @winrt_commethod(25)
    def FindUnexpandedAppointmentsAsync(self) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Appointments.Appointment]]: ...
    @winrt_commethod(26)
    def FindUnexpandedAppointmentsAsyncWithOptions(self, options: win32more.Windows.ApplicationModel.Appointments.FindAppointmentsOptions) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Appointments.Appointment]]: ...
    @winrt_commethod(27)
    def DeleteAsync(self) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_commethod(28)
    def SaveAsync(self) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_commethod(29)
    def DeleteAppointmentAsync(self, localId: WinRT_String) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_commethod(30)
    def DeleteAppointmentInstanceAsync(self, localId: WinRT_String, instanceStartTime: win32more.Windows.Foundation.DateTime) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_commethod(31)
    def SaveAppointmentAsync(self, pAppointment: win32more.Windows.ApplicationModel.Appointments.Appointment) -> win32more.Windows.Foundation.IAsyncAction: ...
    DisplayColor = property(get_DisplayColor, None)
    DisplayName = property(get_DisplayName, put_DisplayName)
    IsHidden = property(get_IsHidden, None)
    LocalId = property(get_LocalId, None)
    OtherAppReadAccess = property(get_OtherAppReadAccess, put_OtherAppReadAccess)
    OtherAppWriteAccess = property(get_OtherAppWriteAccess, put_OtherAppWriteAccess)
    SourceDisplayName = property(get_SourceDisplayName, None)
    SummaryCardView = property(get_SummaryCardView, put_SummaryCardView)
class IAppointmentCalendar2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.IAppointmentCalendar2'
    _iid_ = Guid('{18e7e422-2467-4e1c-a459-d8a29303d092}')
    @winrt_commethod(6)
    def get_SyncManager(self) -> win32more.Windows.ApplicationModel.Appointments.AppointmentCalendarSyncManager: ...
    @winrt_commethod(7)
    def get_RemoteId(self) -> WinRT_String: ...
    @winrt_commethod(8)
    def put_RemoteId(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(9)
    def put_DisplayColor(self, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(10)
    def put_IsHidden(self, value: Boolean) -> Void: ...
    @winrt_commethod(11)
    def get_UserDataAccountId(self) -> WinRT_String: ...
    @winrt_commethod(12)
    def get_CanCreateOrUpdateAppointments(self) -> Boolean: ...
    @winrt_commethod(13)
    def put_CanCreateOrUpdateAppointments(self, value: Boolean) -> Void: ...
    @winrt_commethod(14)
    def get_CanCancelMeetings(self) -> Boolean: ...
    @winrt_commethod(15)
    def put_CanCancelMeetings(self, value: Boolean) -> Void: ...
    @winrt_commethod(16)
    def get_CanForwardMeetings(self) -> Boolean: ...
    @winrt_commethod(17)
    def put_CanForwardMeetings(self, value: Boolean) -> Void: ...
    @winrt_commethod(18)
    def get_CanProposeNewTimeForMeetings(self) -> Boolean: ...
    @winrt_commethod(19)
    def put_CanProposeNewTimeForMeetings(self, value: Boolean) -> Void: ...
    @winrt_commethod(20)
    def get_CanUpdateMeetingResponses(self) -> Boolean: ...
    @winrt_commethod(21)
    def put_CanUpdateMeetingResponses(self, value: Boolean) -> Void: ...
    @winrt_commethod(22)
    def get_CanNotifyInvitees(self) -> Boolean: ...
    @winrt_commethod(23)
    def put_CanNotifyInvitees(self, value: Boolean) -> Void: ...
    @winrt_commethod(24)
    def get_MustNofityInvitees(self) -> Boolean: ...
    @winrt_commethod(25)
    def put_MustNofityInvitees(self, value: Boolean) -> Void: ...
    @winrt_commethod(26)
    def TryCreateOrUpdateAppointmentAsync(self, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment, notifyInvitees: Boolean) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_commethod(27)
    def TryCancelMeetingAsync(self, meeting: win32more.Windows.ApplicationModel.Appointments.Appointment, subject: WinRT_String, comment: WinRT_String, notifyInvitees: Boolean) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_commethod(28)
    def TryForwardMeetingAsync(self, meeting: win32more.Windows.ApplicationModel.Appointments.Appointment, invitees: win32more.Windows.Foundation.Collections.IIterable[win32more.Windows.ApplicationModel.Appointments.AppointmentInvitee], subject: WinRT_String, forwardHeader: WinRT_String, comment: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_commethod(29)
    def TryProposeNewTimeForMeetingAsync(self, meeting: win32more.Windows.ApplicationModel.Appointments.Appointment, newStartTime: win32more.Windows.Foundation.DateTime, newDuration: win32more.Windows.Foundation.TimeSpan, subject: WinRT_String, comment: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_commethod(30)
    def TryUpdateMeetingResponseAsync(self, meeting: win32more.Windows.ApplicationModel.Appointments.Appointment, response: win32more.Windows.ApplicationModel.Appointments.AppointmentParticipantResponse, subject: WinRT_String, comment: WinRT_String, sendUpdate: Boolean) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    CanCancelMeetings = property(get_CanCancelMeetings, put_CanCancelMeetings)
    CanCreateOrUpdateAppointments = property(get_CanCreateOrUpdateAppointments, put_CanCreateOrUpdateAppointments)
    CanForwardMeetings = property(get_CanForwardMeetings, put_CanForwardMeetings)
    CanNotifyInvitees = property(get_CanNotifyInvitees, put_CanNotifyInvitees)
    CanProposeNewTimeForMeetings = property(get_CanProposeNewTimeForMeetings, put_CanProposeNewTimeForMeetings)
    CanUpdateMeetingResponses = property(get_CanUpdateMeetingResponses, put_CanUpdateMeetingResponses)
    DisplayColor = property(None, put_DisplayColor)
    IsHidden = property(None, put_IsHidden)
    MustNofityInvitees = property(get_MustNofityInvitees, put_MustNofityInvitees)
    RemoteId = property(get_RemoteId, put_RemoteId)
    SyncManager = property(get_SyncManager, None)
    UserDataAccountId = property(get_UserDataAccountId, None)
class IAppointmentCalendar3(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.IAppointmentCalendar3'
    _iid_ = Guid('{eb23d22b-a685-42ae-8495-b3119adb4167}')
    @winrt_commethod(6)
    def RegisterSyncManagerAsync(self) -> win32more.Windows.Foundation.IAsyncAction: ...
class IAppointmentCalendarSyncManager(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.IAppointmentCalendarSyncManager'
    _iid_ = Guid('{2b21b3a0-4aff-4392-bc5f-5645ffcffb17}')
    @winrt_commethod(6)
    def get_Status(self) -> win32more.Windows.ApplicationModel.Appointments.AppointmentCalendarSyncStatus: ...
    @winrt_commethod(7)
    def get_LastSuccessfulSyncTime(self) -> win32more.Windows.Foundation.DateTime: ...
    @winrt_commethod(8)
    def get_LastAttemptedSyncTime(self) -> win32more.Windows.Foundation.DateTime: ...
    @winrt_commethod(9)
    def SyncAsync(self) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_commethod(10)
    def add_SyncStatusChanged(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.ApplicationModel.Appointments.AppointmentCalendarSyncManager, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(11)
    def remove_SyncStatusChanged(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    LastAttemptedSyncTime = property(get_LastAttemptedSyncTime, None)
    LastSuccessfulSyncTime = property(get_LastSuccessfulSyncTime, None)
    Status = property(get_Status, None)
    SyncStatusChanged = event()
class IAppointmentCalendarSyncManager2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.IAppointmentCalendarSyncManager2'
    _iid_ = Guid('{647528ad-0d29-4c7c-aaa7-bf996805537c}')
    @winrt_commethod(6)
    def put_Status(self, value: win32more.Windows.ApplicationModel.Appointments.AppointmentCalendarSyncStatus) -> Void: ...
    @winrt_commethod(7)
    def put_LastSuccessfulSyncTime(self, value: win32more.Windows.Foundation.DateTime) -> Void: ...
    @winrt_commethod(8)
    def put_LastAttemptedSyncTime(self, value: win32more.Windows.Foundation.DateTime) -> Void: ...
    LastAttemptedSyncTime = property(None, put_LastAttemptedSyncTime)
    LastSuccessfulSyncTime = property(None, put_LastSuccessfulSyncTime)
    Status = property(None, put_Status)
class IAppointmentConflictResult(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.IAppointmentConflictResult'
    _iid_ = Guid('{d5cdf0be-2f2f-3b7d-af0a-a7e20f3a46e3}')
    @winrt_commethod(6)
    def get_Type(self) -> win32more.Windows.ApplicationModel.Appointments.AppointmentConflictType: ...
    @winrt_commethod(7)
    def get_Date(self) -> win32more.Windows.Foundation.DateTime: ...
    Date = property(get_Date, None)
    Type = property(get_Type, None)
class IAppointmentException(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.IAppointmentException'
    _iid_ = Guid('{a2076767-16f6-4bce-9f5a-8600b8019fcb}')
    @winrt_commethod(6)
    def get_Appointment(self) -> win32more.Windows.ApplicationModel.Appointments.Appointment: ...
    @winrt_commethod(7)
    def get_ExceptionProperties(self) -> win32more.Windows.Foundation.Collections.IVectorView[WinRT_String]: ...
    @winrt_commethod(8)
    def get_IsDeleted(self) -> Boolean: ...
    Appointment = property(get_Appointment, None)
    ExceptionProperties = property(get_ExceptionProperties, None)
    IsDeleted = property(get_IsDeleted, None)
class IAppointmentInvitee(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.IAppointmentInvitee'
    _iid_ = Guid('{13bf0796-9842-495b-b0e7-ef8f79c0701d}')
    @winrt_commethod(6)
    def get_Role(self) -> win32more.Windows.ApplicationModel.Appointments.AppointmentParticipantRole: ...
    @winrt_commethod(7)
    def put_Role(self, value: win32more.Windows.ApplicationModel.Appointments.AppointmentParticipantRole) -> Void: ...
    @winrt_commethod(8)
    def get_Response(self) -> win32more.Windows.ApplicationModel.Appointments.AppointmentParticipantResponse: ...
    @winrt_commethod(9)
    def put_Response(self, value: win32more.Windows.ApplicationModel.Appointments.AppointmentParticipantResponse) -> Void: ...
    Response = property(get_Response, put_Response)
    Role = property(get_Role, put_Role)
class IAppointmentManagerForUser(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.IAppointmentManagerForUser'
    _iid_ = Guid('{70261423-73cc-4660-b318-b01365302a03}')
    @winrt_commethod(6)
    def ShowAddAppointmentAsync(self, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment, selection: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.IAsyncOperation[WinRT_String]: ...
    @winrt_commethod(7)
    def ShowAddAppointmentWithPlacementAsync(self, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment, selection: win32more.Windows.Foundation.Rect, preferredPlacement: win32more.Windows.UI.Popups.Placement) -> win32more.Windows.Foundation.IAsyncOperation[WinRT_String]: ...
    @winrt_commethod(8)
    def ShowReplaceAppointmentAsync(self, appointmentId: WinRT_String, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment, selection: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.IAsyncOperation[WinRT_String]: ...
    @winrt_commethod(9)
    def ShowReplaceAppointmentWithPlacementAsync(self, appointmentId: WinRT_String, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment, selection: win32more.Windows.Foundation.Rect, preferredPlacement: win32more.Windows.UI.Popups.Placement) -> win32more.Windows.Foundation.IAsyncOperation[WinRT_String]: ...
    @winrt_commethod(10)
    def ShowReplaceAppointmentWithPlacementAndDateAsync(self, appointmentId: WinRT_String, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment, selection: win32more.Windows.Foundation.Rect, preferredPlacement: win32more.Windows.UI.Popups.Placement, instanceStartDate: win32more.Windows.Foundation.DateTime) -> win32more.Windows.Foundation.IAsyncOperation[WinRT_String]: ...
    @winrt_commethod(11)
    def ShowRemoveAppointmentAsync(self, appointmentId: WinRT_String, selection: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_commethod(12)
    def ShowRemoveAppointmentWithPlacementAsync(self, appointmentId: WinRT_String, selection: win32more.Windows.Foundation.Rect, preferredPlacement: win32more.Windows.UI.Popups.Placement) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_commethod(13)
    def ShowRemoveAppointmentWithPlacementAndDateAsync(self, appointmentId: WinRT_String, selection: win32more.Windows.Foundation.Rect, preferredPlacement: win32more.Windows.UI.Popups.Placement, instanceStartDate: win32more.Windows.Foundation.DateTime) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_commethod(14)
    def ShowTimeFrameAsync(self, timeToShow: win32more.Windows.Foundation.DateTime, duration: win32more.Windows.Foundation.TimeSpan) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_commethod(15)
    def ShowAppointmentDetailsAsync(self, appointmentId: WinRT_String) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_commethod(16)
    def ShowAppointmentDetailsWithDateAsync(self, appointmentId: WinRT_String, instanceStartDate: win32more.Windows.Foundation.DateTime) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_commethod(17)
    def ShowEditNewAppointmentAsync(self, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment) -> win32more.Windows.Foundation.IAsyncOperation[WinRT_String]: ...
    @winrt_commethod(18)
    def RequestStoreAsync(self, options: win32more.Windows.ApplicationModel.Appointments.AppointmentStoreAccessType) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Appointments.AppointmentStore]: ...
    @winrt_commethod(19)
    def get_User(self) -> win32more.Windows.System.User: ...
    User = property(get_User, None)
class IAppointmentManagerStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.IAppointmentManagerStatics'
    _iid_ = Guid('{3a30fa01-5c40-499d-b33f-a43050f74fc4}')
    @winrt_commethod(6)
    def ShowAddAppointmentAsync(self, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment, selection: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.IAsyncOperation[WinRT_String]: ...
    @winrt_commethod(7)
    def ShowAddAppointmentWithPlacementAsync(self, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment, selection: win32more.Windows.Foundation.Rect, preferredPlacement: win32more.Windows.UI.Popups.Placement) -> win32more.Windows.Foundation.IAsyncOperation[WinRT_String]: ...
    @winrt_commethod(8)
    def ShowReplaceAppointmentAsync(self, appointmentId: WinRT_String, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment, selection: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.IAsyncOperation[WinRT_String]: ...
    @winrt_commethod(9)
    def ShowReplaceAppointmentWithPlacementAsync(self, appointmentId: WinRT_String, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment, selection: win32more.Windows.Foundation.Rect, preferredPlacement: win32more.Windows.UI.Popups.Placement) -> win32more.Windows.Foundation.IAsyncOperation[WinRT_String]: ...
    @winrt_commethod(10)
    def ShowReplaceAppointmentWithPlacementAndDateAsync(self, appointmentId: WinRT_String, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment, selection: win32more.Windows.Foundation.Rect, preferredPlacement: win32more.Windows.UI.Popups.Placement, instanceStartDate: win32more.Windows.Foundation.DateTime) -> win32more.Windows.Foundation.IAsyncOperation[WinRT_String]: ...
    @winrt_commethod(11)
    def ShowRemoveAppointmentAsync(self, appointmentId: WinRT_String, selection: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_commethod(12)
    def ShowRemoveAppointmentWithPlacementAsync(self, appointmentId: WinRT_String, selection: win32more.Windows.Foundation.Rect, preferredPlacement: win32more.Windows.UI.Popups.Placement) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_commethod(13)
    def ShowRemoveAppointmentWithPlacementAndDateAsync(self, appointmentId: WinRT_String, selection: win32more.Windows.Foundation.Rect, preferredPlacement: win32more.Windows.UI.Popups.Placement, instanceStartDate: win32more.Windows.Foundation.DateTime) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_commethod(14)
    def ShowTimeFrameAsync(self, timeToShow: win32more.Windows.Foundation.DateTime, duration: win32more.Windows.Foundation.TimeSpan) -> win32more.Windows.Foundation.IAsyncAction: ...
class IAppointmentManagerStatics2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.IAppointmentManagerStatics2'
    _iid_ = Guid('{0a81f60d-d04f-4034-af72-a36573b45ff0}')
    @winrt_commethod(6)
    def ShowAppointmentDetailsAsync(self, appointmentId: WinRT_String) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_commethod(7)
    def ShowAppointmentDetailsWithDateAsync(self, appointmentId: WinRT_String, instanceStartDate: win32more.Windows.Foundation.DateTime) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_commethod(8)
    def ShowEditNewAppointmentAsync(self, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment) -> win32more.Windows.Foundation.IAsyncOperation[WinRT_String]: ...
    @winrt_commethod(9)
    def RequestStoreAsync(self, options: win32more.Windows.ApplicationModel.Appointments.AppointmentStoreAccessType) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Appointments.AppointmentStore]: ...
class IAppointmentManagerStatics3(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.IAppointmentManagerStatics3'
    _iid_ = Guid('{2f9ae09c-b34c-4dc7-a35d-cafd88ae3ec6}')
    @winrt_commethod(6)
    def GetForUser(self, user: win32more.Windows.System.User) -> win32more.Windows.ApplicationModel.Appointments.AppointmentManagerForUser: ...
class IAppointmentParticipant(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.IAppointmentParticipant'
    _iid_ = Guid('{615e2902-9718-467b-83fb-b293a19121de}')
    @winrt_commethod(6)
    def get_DisplayName(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def put_DisplayName(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(8)
    def get_Address(self) -> WinRT_String: ...
    @winrt_commethod(9)
    def put_Address(self, value: WinRT_String) -> Void: ...
    Address = property(get_Address, put_Address)
    DisplayName = property(get_DisplayName, put_DisplayName)
class IAppointmentPropertiesStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.IAppointmentPropertiesStatics'
    _iid_ = Guid('{25141fe9-68ae-3aae-855f-bc4441caa234}')
    @winrt_commethod(6)
    def get_Subject(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def get_Location(self) -> WinRT_String: ...
    @winrt_commethod(8)
    def get_StartTime(self) -> WinRT_String: ...
    @winrt_commethod(9)
    def get_Duration(self) -> WinRT_String: ...
    @winrt_commethod(10)
    def get_Reminder(self) -> WinRT_String: ...
    @winrt_commethod(11)
    def get_BusyStatus(self) -> WinRT_String: ...
    @winrt_commethod(12)
    def get_Sensitivity(self) -> WinRT_String: ...
    @winrt_commethod(13)
    def get_OriginalStartTime(self) -> WinRT_String: ...
    @winrt_commethod(14)
    def get_IsResponseRequested(self) -> WinRT_String: ...
    @winrt_commethod(15)
    def get_AllowNewTimeProposal(self) -> WinRT_String: ...
    @winrt_commethod(16)
    def get_AllDay(self) -> WinRT_String: ...
    @winrt_commethod(17)
    def get_Details(self) -> WinRT_String: ...
    @winrt_commethod(18)
    def get_OnlineMeetingLink(self) -> WinRT_String: ...
    @winrt_commethod(19)
    def get_ReplyTime(self) -> WinRT_String: ...
    @winrt_commethod(20)
    def get_Organizer(self) -> WinRT_String: ...
    @winrt_commethod(21)
    def get_UserResponse(self) -> WinRT_String: ...
    @winrt_commethod(22)
    def get_HasInvitees(self) -> WinRT_String: ...
    @winrt_commethod(23)
    def get_IsCanceledMeeting(self) -> WinRT_String: ...
    @winrt_commethod(24)
    def get_IsOrganizedByUser(self) -> WinRT_String: ...
    @winrt_commethod(25)
    def get_Recurrence(self) -> WinRT_String: ...
    @winrt_commethod(26)
    def get_Uri(self) -> WinRT_String: ...
    @winrt_commethod(27)
    def get_Invitees(self) -> WinRT_String: ...
    @winrt_commethod(28)
    def get_DefaultProperties(self) -> win32more.Windows.Foundation.Collections.IVector[WinRT_String]: ...
    AllDay = property(get_AllDay, None)
    AllowNewTimeProposal = property(get_AllowNewTimeProposal, None)
    BusyStatus = property(get_BusyStatus, None)
    DefaultProperties = property(get_DefaultProperties, None)
    Details = property(get_Details, None)
    Duration = property(get_Duration, None)
    HasInvitees = property(get_HasInvitees, None)
    Invitees = property(get_Invitees, None)
    IsCanceledMeeting = property(get_IsCanceledMeeting, None)
    IsOrganizedByUser = property(get_IsOrganizedByUser, None)
    IsResponseRequested = property(get_IsResponseRequested, None)
    Location = property(get_Location, None)
    OnlineMeetingLink = property(get_OnlineMeetingLink, None)
    Organizer = property(get_Organizer, None)
    OriginalStartTime = property(get_OriginalStartTime, None)
    Recurrence = property(get_Recurrence, None)
    Reminder = property(get_Reminder, None)
    ReplyTime = property(get_ReplyTime, None)
    Sensitivity = property(get_Sensitivity, None)
    StartTime = property(get_StartTime, None)
    Subject = property(get_Subject, None)
    Uri = property(get_Uri, None)
    UserResponse = property(get_UserResponse, None)
class IAppointmentPropertiesStatics2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.IAppointmentPropertiesStatics2'
    _iid_ = Guid('{dffc434b-b017-45dd-8af5-d163d10801bb}')
    @winrt_commethod(6)
    def get_ChangeNumber(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def get_RemoteChangeNumber(self) -> WinRT_String: ...
    @winrt_commethod(8)
    def get_DetailsKind(self) -> WinRT_String: ...
    ChangeNumber = property(get_ChangeNumber, None)
    DetailsKind = property(get_DetailsKind, None)
    RemoteChangeNumber = property(get_RemoteChangeNumber, None)
class IAppointmentRecurrence(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.IAppointmentRecurrence'
    _iid_ = Guid('{d87b3e83-15a6-487b-b959-0c361e60e954}')
    @winrt_commethod(6)
    def get_Unit(self) -> win32more.Windows.ApplicationModel.Appointments.AppointmentRecurrenceUnit: ...
    @winrt_commethod(7)
    def put_Unit(self, value: win32more.Windows.ApplicationModel.Appointments.AppointmentRecurrenceUnit) -> Void: ...
    @winrt_commethod(8)
    def get_Occurrences(self) -> win32more.Windows.Foundation.IReference[UInt32]: ...
    @winrt_commethod(9)
    def put_Occurrences(self, value: win32more.Windows.Foundation.IReference[UInt32]) -> Void: ...
    @winrt_commethod(10)
    def get_Until(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]: ...
    @winrt_commethod(11)
    def put_Until(self, value: win32more.Windows.Foundation.IReference[win32more.Windows.Foundation.DateTime]) -> Void: ...
    @winrt_commethod(12)
    def get_Interval(self) -> UInt32: ...
    @winrt_commethod(13)
    def put_Interval(self, value: UInt32) -> Void: ...
    @winrt_commethod(14)
    def get_DaysOfWeek(self) -> win32more.Windows.ApplicationModel.Appointments.AppointmentDaysOfWeek: ...
    @winrt_commethod(15)
    def put_DaysOfWeek(self, value: win32more.Windows.ApplicationModel.Appointments.AppointmentDaysOfWeek) -> Void: ...
    @winrt_commethod(16)
    def get_WeekOfMonth(self) -> win32more.Windows.ApplicationModel.Appointments.AppointmentWeekOfMonth: ...
    @winrt_commethod(17)
    def put_WeekOfMonth(self, value: win32more.Windows.ApplicationModel.Appointments.AppointmentWeekOfMonth) -> Void: ...
    @winrt_commethod(18)
    def get_Month(self) -> UInt32: ...
    @winrt_commethod(19)
    def put_Month(self, value: UInt32) -> Void: ...
    @winrt_commethod(20)
    def get_Day(self) -> UInt32: ...
    @winrt_commethod(21)
    def put_Day(self, value: UInt32) -> Void: ...
    Day = property(get_Day, put_Day)
    DaysOfWeek = property(get_DaysOfWeek, put_DaysOfWeek)
    Interval = property(get_Interval, put_Interval)
    Month = property(get_Month, put_Month)
    Occurrences = property(get_Occurrences, put_Occurrences)
    Unit = property(get_Unit, put_Unit)
    Until = property(get_Until, put_Until)
    WeekOfMonth = property(get_WeekOfMonth, put_WeekOfMonth)
class IAppointmentRecurrence2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.IAppointmentRecurrence2'
    _iid_ = Guid('{3df3a2e0-05a7-4f50-9f86-b03f9436254d}')
    @winrt_commethod(6)
    def get_RecurrenceType(self) -> win32more.Windows.ApplicationModel.Appointments.RecurrenceType: ...
    @winrt_commethod(7)
    def get_TimeZone(self) -> WinRT_String: ...
    @winrt_commethod(8)
    def put_TimeZone(self, value: WinRT_String) -> Void: ...
    RecurrenceType = property(get_RecurrenceType, None)
    TimeZone = property(get_TimeZone, put_TimeZone)
class IAppointmentRecurrence3(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.IAppointmentRecurrence3'
    _iid_ = Guid('{89ff96d9-da4d-4a17-8dd2-1cebc2b5ff9d}')
    @winrt_commethod(6)
    def get_CalendarIdentifier(self) -> WinRT_String: ...
    CalendarIdentifier = property(get_CalendarIdentifier, None)
class IAppointmentStore(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.IAppointmentStore'
    _iid_ = Guid('{a461918c-7a47-4d96-96c9-15cd8a05a735}')
    @winrt_commethod(6)
    def get_ChangeTracker(self) -> win32more.Windows.ApplicationModel.Appointments.AppointmentStoreChangeTracker: ...
    @winrt_commethod(7)
    def CreateAppointmentCalendarAsync(self, name: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Appointments.AppointmentCalendar]: ...
    @winrt_commethod(8)
    def GetAppointmentCalendarAsync(self, calendarId: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Appointments.AppointmentCalendar]: ...
    @winrt_commethod(9)
    def GetAppointmentAsync(self, localId: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Appointments.Appointment]: ...
    @winrt_commethod(10)
    def GetAppointmentInstanceAsync(self, localId: WinRT_String, instanceStartTime: win32more.Windows.Foundation.DateTime) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Appointments.Appointment]: ...
    @winrt_commethod(11)
    def FindAppointmentCalendarsAsync(self) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Appointments.AppointmentCalendar]]: ...
    @winrt_commethod(12)
    def FindAppointmentCalendarsAsyncWithOptions(self, options: win32more.Windows.ApplicationModel.Appointments.FindAppointmentCalendarsOptions) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Appointments.AppointmentCalendar]]: ...
    @winrt_commethod(13)
    def FindAppointmentsAsync(self, rangeStart: win32more.Windows.Foundation.DateTime, rangeLength: win32more.Windows.Foundation.TimeSpan) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Appointments.Appointment]]: ...
    @winrt_commethod(14)
    def FindAppointmentsAsyncWithOptions(self, rangeStart: win32more.Windows.Foundation.DateTime, rangeLength: win32more.Windows.Foundation.TimeSpan, options: win32more.Windows.ApplicationModel.Appointments.FindAppointmentsOptions) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Appointments.Appointment]]: ...
    @winrt_commethod(15)
    def FindConflictAsync(self, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Appointments.AppointmentConflictResult]: ...
    @winrt_commethod(16)
    def FindConflictAsyncWithInstanceStart(self, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment, instanceStartTime: win32more.Windows.Foundation.DateTime) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Appointments.AppointmentConflictResult]: ...
    @winrt_commethod(17)
    def MoveAppointmentAsync(self, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment, destinationCalendar: win32more.Windows.ApplicationModel.Appointments.AppointmentCalendar) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_commethod(18)
    def ShowAddAppointmentAsync(self, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment, selection: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.IAsyncOperation[WinRT_String]: ...
    @winrt_commethod(19)
    def ShowReplaceAppointmentAsync(self, localId: WinRT_String, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment, selection: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.IAsyncOperation[WinRT_String]: ...
    @winrt_commethod(20)
    def ShowReplaceAppointmentWithPlacementAndDateAsync(self, localId: WinRT_String, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment, selection: win32more.Windows.Foundation.Rect, preferredPlacement: win32more.Windows.UI.Popups.Placement, instanceStartDate: win32more.Windows.Foundation.DateTime) -> win32more.Windows.Foundation.IAsyncOperation[WinRT_String]: ...
    @winrt_commethod(21)
    def ShowRemoveAppointmentAsync(self, localId: WinRT_String, selection: win32more.Windows.Foundation.Rect) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_commethod(22)
    def ShowRemoveAppointmentWithPlacementAndDateAsync(self, localId: WinRT_String, selection: win32more.Windows.Foundation.Rect, preferredPlacement: win32more.Windows.UI.Popups.Placement, instanceStartDate: win32more.Windows.Foundation.DateTime) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_commethod(23)
    def ShowAppointmentDetailsAsync(self, localId: WinRT_String) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_commethod(24)
    def ShowAppointmentDetailsWithDateAsync(self, localId: WinRT_String, instanceStartDate: win32more.Windows.Foundation.DateTime) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_commethod(25)
    def ShowEditNewAppointmentAsync(self, appointment: win32more.Windows.ApplicationModel.Appointments.Appointment) -> win32more.Windows.Foundation.IAsyncOperation[WinRT_String]: ...
    @winrt_commethod(26)
    def FindLocalIdsFromRoamingIdAsync(self, roamingId: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[WinRT_String]]: ...
    ChangeTracker = property(get_ChangeTracker, None)
class IAppointmentStore2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.IAppointmentStore2'
    _iid_ = Guid('{25c48c20-1c41-424f-8084-67c1cfe0a854}')
    @winrt_commethod(6)
    def add_StoreChanged(self, pHandler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.ApplicationModel.Appointments.AppointmentStore, win32more.Windows.ApplicationModel.Appointments.AppointmentStoreChangedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(7)
    def remove_StoreChanged(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(8)
    def CreateAppointmentCalendarInAccountAsync(self, name: WinRT_String, userDataAccountId: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Appointments.AppointmentCalendar]: ...
    StoreChanged = event()
class IAppointmentStore3(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.IAppointmentStore3'
    _iid_ = Guid('{4251940b-b078-470a-9a40-c2e01761f72f}')
    @winrt_commethod(6)
    def GetChangeTracker(self, identity: WinRT_String) -> win32more.Windows.ApplicationModel.Appointments.AppointmentStoreChangeTracker: ...
class IAppointmentStoreChange(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.IAppointmentStoreChange'
    _iid_ = Guid('{a5a6e035-0a33-3654-8463-b543e90c3b79}')
    @winrt_commethod(6)
    def get_Appointment(self) -> win32more.Windows.ApplicationModel.Appointments.Appointment: ...
    @winrt_commethod(7)
    def get_ChangeType(self) -> win32more.Windows.ApplicationModel.Appointments.AppointmentStoreChangeType: ...
    Appointment = property(get_Appointment, None)
    ChangeType = property(get_ChangeType, None)
class IAppointmentStoreChange2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.IAppointmentStoreChange2'
    _iid_ = Guid('{b37d0dce-5211-4402-a608-a96fe70b8ee2}')
    @winrt_commethod(6)
    def get_AppointmentCalendar(self) -> win32more.Windows.ApplicationModel.Appointments.AppointmentCalendar: ...
    AppointmentCalendar = property(get_AppointmentCalendar, None)
class IAppointmentStoreChangeReader(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.IAppointmentStoreChangeReader'
    _iid_ = Guid('{8b2409f1-65f3-42a0-961d-4c209bf30370}')
    @winrt_commethod(6)
    def ReadBatchAsync(self) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Appointments.AppointmentStoreChange]]: ...
    @winrt_commethod(7)
    def AcceptChanges(self) -> Void: ...
    @winrt_commethod(8)
    def AcceptChangesThrough(self, lastChangeToAccept: win32more.Windows.ApplicationModel.Appointments.AppointmentStoreChange) -> Void: ...
class IAppointmentStoreChangeTracker(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.IAppointmentStoreChangeTracker'
    _iid_ = Guid('{1b25f4b1-8ece-4f17-93c8-e6412458fd5c}')
    @winrt_commethod(6)
    def GetChangeReader(self) -> win32more.Windows.ApplicationModel.Appointments.AppointmentStoreChangeReader: ...
    @winrt_commethod(7)
    def Enable(self) -> Void: ...
    @winrt_commethod(8)
    def Reset(self) -> Void: ...
class IAppointmentStoreChangeTracker2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.IAppointmentStoreChangeTracker2'
    _iid_ = Guid('{b66aaf45-9542-4cf7-8550-eb370e0c08d3}')
    @winrt_commethod(6)
    def get_IsTracking(self) -> Boolean: ...
    IsTracking = property(get_IsTracking, None)
class IAppointmentStoreChangedDeferral(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.IAppointmentStoreChangedDeferral'
    _iid_ = Guid('{4cb82026-fedb-4bc3-9662-95a9befdf4df}')
    @winrt_commethod(6)
    def Complete(self) -> Void: ...
class IAppointmentStoreChangedEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.IAppointmentStoreChangedEventArgs'
    _iid_ = Guid('{2285f8b9-0791-417e-bfea-cc6d41636c8c}')
    @winrt_commethod(6)
    def GetDeferral(self) -> win32more.Windows.ApplicationModel.Appointments.AppointmentStoreChangedDeferral: ...
class IAppointmentStoreNotificationTriggerDetails(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.IAppointmentStoreNotificationTriggerDetails'
    _iid_ = Guid('{9b33cb11-c301-421e-afef-047ecfa76adb}')
class IFindAppointmentsOptions(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Appointments.IFindAppointmentsOptions'
    _iid_ = Guid('{55f7dc55-9942-3086-82b5-2cb29f64d5f5}')
    @winrt_commethod(6)
    def get_CalendarIds(self) -> win32more.Windows.Foundation.Collections.IVector[WinRT_String]: ...
    @winrt_commethod(7)
    def get_FetchProperties(self) -> win32more.Windows.Foundation.Collections.IVector[WinRT_String]: ...
    @winrt_commethod(8)
    def get_IncludeHidden(self) -> Boolean: ...
    @winrt_commethod(9)
    def put_IncludeHidden(self, value: Boolean) -> Void: ...
    @winrt_commethod(10)
    def get_MaxCount(self) -> UInt32: ...
    @winrt_commethod(11)
    def put_MaxCount(self, value: UInt32) -> Void: ...
    CalendarIds = property(get_CalendarIds, None)
    FetchProperties = property(get_FetchProperties, None)
    IncludeHidden = property(get_IncludeHidden, put_IncludeHidden)
    MaxCount = property(get_MaxCount, put_MaxCount)
class RecurrenceType(Enum, Int32):
    Master = 0
    Instance = 1
    ExceptionInstance = 2


make_ready(__name__)
