from __future__ import annotations
from win32more.winrt.prelude import *
import win32more.Windows.ApplicationModel.Store.Preview.InstallControl
import win32more.Windows.Foundation
import win32more.Windows.Foundation.Collections
import win32more.Windows.Management.Deployment
import win32more.Windows.System
class AppInstallItem(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem
    _classid_ = 'Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem'
    @winrt_mixinmethod
    def get_ProductId(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_PackageFamilyName(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_InstallType(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem) -> win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallType: ...
    @winrt_mixinmethod
    def get_IsUserInitiated(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem) -> Boolean: ...
    @winrt_mixinmethod
    def GetCurrentStatus(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem) -> win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallStatus: ...
    @winrt_mixinmethod
    def Cancel(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem) -> Void: ...
    @winrt_mixinmethod
    def Pause(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem) -> Void: ...
    @winrt_mixinmethod
    def Restart(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem) -> Void: ...
    @winrt_mixinmethod
    def add_Completed(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_Completed(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_StatusChanged(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_StatusChanged(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def CancelWithTelemetry(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem2, correlationVector: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def PauseWithTelemetry(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem2, correlationVector: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def RestartWithTelemetry(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem2, correlationVector: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_Children(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem3) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]: ...
    @winrt_mixinmethod
    def get_ItemOperationsMightAffectOtherItems(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem3) -> Boolean: ...
    @winrt_mixinmethod
    def get_LaunchAfterInstall(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem4) -> Boolean: ...
    @winrt_mixinmethod
    def put_LaunchAfterInstall(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem4, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_PinToDesktopAfterInstall(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem5) -> Boolean: ...
    @winrt_mixinmethod
    def put_PinToDesktopAfterInstall(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem5, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_PinToStartAfterInstall(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem5) -> Boolean: ...
    @winrt_mixinmethod
    def put_PinToStartAfterInstall(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem5, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_PinToTaskbarAfterInstall(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem5) -> Boolean: ...
    @winrt_mixinmethod
    def put_PinToTaskbarAfterInstall(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem5, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_CompletedInstallToastNotificationMode(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem5) -> win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallationToastNotificationMode: ...
    @winrt_mixinmethod
    def put_CompletedInstallToastNotificationMode(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem5, value: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallationToastNotificationMode) -> Void: ...
    @winrt_mixinmethod
    def get_InstallInProgressToastNotificationMode(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem5) -> win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallationToastNotificationMode: ...
    @winrt_mixinmethod
    def put_InstallInProgressToastNotificationMode(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem5, value: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallationToastNotificationMode) -> Void: ...
    Children = property(get_Children, None)
    CompletedInstallToastNotificationMode = property(get_CompletedInstallToastNotificationMode, put_CompletedInstallToastNotificationMode)
    InstallInProgressToastNotificationMode = property(get_InstallInProgressToastNotificationMode, put_InstallInProgressToastNotificationMode)
    InstallType = property(get_InstallType, None)
    IsUserInitiated = property(get_IsUserInitiated, None)
    ItemOperationsMightAffectOtherItems = property(get_ItemOperationsMightAffectOtherItems, None)
    LaunchAfterInstall = property(get_LaunchAfterInstall, put_LaunchAfterInstall)
    PackageFamilyName = property(get_PackageFamilyName, None)
    PinToDesktopAfterInstall = property(get_PinToDesktopAfterInstall, put_PinToDesktopAfterInstall)
    PinToStartAfterInstall = property(get_PinToStartAfterInstall, put_PinToStartAfterInstall)
    PinToTaskbarAfterInstall = property(get_PinToTaskbarAfterInstall, put_PinToTaskbarAfterInstall)
    ProductId = property(get_ProductId, None)
    Completed = event()
    StatusChanged = event()
class AppInstallManager(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager
    _classid_ = 'Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallManager'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallManager.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallManager: ...
    @winrt_mixinmethod
    def get_AppInstallItems(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]: ...
    @winrt_mixinmethod
    def Cancel(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager, productId: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def Pause(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager, productId: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def Restart(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager, productId: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def add_ItemCompleted(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallManager, win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallManagerItemEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_ItemCompleted(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def add_ItemStatusChanged(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallManager, win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallManagerItemEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_ItemStatusChanged(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def get_AutoUpdateSetting(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager) -> win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AutoUpdateSetting: ...
    @winrt_mixinmethod
    def put_AutoUpdateSetting(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager, value: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AutoUpdateSetting) -> Void: ...
    @winrt_mixinmethod
    def get_AcquisitionIdentity(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_AcquisitionIdentity(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetIsApplicableAsync(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager, productId: WinRT_String, skuId: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_mixinmethod
    def StartAppInstallAsync(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager, productId: WinRT_String, skuId: WinRT_String, repair: Boolean, forceUseOfNonRemovableStorage: Boolean) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]: ...
    @winrt_mixinmethod
    def UpdateAppByPackageFamilyNameAsync(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager, packageFamilyName: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]: ...
    @winrt_mixinmethod
    def SearchForUpdatesAsync(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager, productId: WinRT_String, skuId: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]: ...
    @winrt_mixinmethod
    def SearchForAllUpdatesAsync(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]]: ...
    @winrt_mixinmethod
    def IsStoreBlockedByPolicyAsync(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager, storeClientName: WinRT_String, storeClientPublisher: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_mixinmethod
    def GetIsAppAllowedToInstallAsync(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager, productId: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_mixinmethod
    def StartAppInstallWithTelemetryAsync(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager2, productId: WinRT_String, skuId: WinRT_String, repair: Boolean, forceUseOfNonRemovableStorage: Boolean, catalogId: WinRT_String, bundleId: WinRT_String, correlationVector: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]: ...
    @winrt_mixinmethod
    def UpdateAppByPackageFamilyNameWithTelemetryAsync(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager2, packageFamilyName: WinRT_String, correlationVector: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]: ...
    @winrt_mixinmethod
    def SearchForUpdatesWithTelemetryAsync(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager2, productId: WinRT_String, skuId: WinRT_String, catalogId: WinRT_String, correlationVector: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]: ...
    @winrt_mixinmethod
    def SearchForAllUpdatesWithTelemetryAsync(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager2, correlationVector: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]]: ...
    @winrt_mixinmethod
    def GetIsAppAllowedToInstallWithTelemetryAsync(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager2, productId: WinRT_String, skuId: WinRT_String, catalogId: WinRT_String, correlationVector: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_mixinmethod
    def CancelWithTelemetry(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager2, productId: WinRT_String, correlationVector: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def PauseWithTelemetry(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager2, productId: WinRT_String, correlationVector: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def RestartWithTelemetry(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager2, productId: WinRT_String, correlationVector: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def StartProductInstallAsync(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager3, productId: WinRT_String, catalogId: WinRT_String, flightId: WinRT_String, clientId: WinRT_String, repair: Boolean, forceUseOfNonRemovableStorage: Boolean, correlationVector: WinRT_String, targetVolume: win32more.Windows.Management.Deployment.PackageVolume) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]]: ...
    @winrt_mixinmethod
    def StartProductInstallForUserAsync(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager3, user: win32more.Windows.System.User, productId: WinRT_String, catalogId: WinRT_String, flightId: WinRT_String, clientId: WinRT_String, repair: Boolean, forceUseOfNonRemovableStorage: Boolean, correlationVector: WinRT_String, targetVolume: win32more.Windows.Management.Deployment.PackageVolume) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]]: ...
    @winrt_mixinmethod
    def UpdateAppByPackageFamilyNameForUserAsync(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager3, user: win32more.Windows.System.User, packageFamilyName: WinRT_String, correlationVector: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]: ...
    @winrt_mixinmethod
    def SearchForUpdatesForUserAsync(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager3, user: win32more.Windows.System.User, productId: WinRT_String, skuId: WinRT_String, catalogId: WinRT_String, correlationVector: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]: ...
    @winrt_mixinmethod
    def SearchForAllUpdatesForUserAsync(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager3, user: win32more.Windows.System.User, correlationVector: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]]: ...
    @winrt_mixinmethod
    def GetIsAppAllowedToInstallForUserAsync(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager3, user: win32more.Windows.System.User, productId: WinRT_String, skuId: WinRT_String, catalogId: WinRT_String, correlationVector: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_mixinmethod
    def GetIsApplicableForUserAsync(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager3, user: win32more.Windows.System.User, productId: WinRT_String, skuId: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_mixinmethod
    def MoveToFrontOfDownloadQueue(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager3, productId: WinRT_String, correlationVector: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetFreeUserEntitlementAsync(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager4, storeId: WinRT_String, campaignId: WinRT_String, correlationVector: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.GetEntitlementResult]: ...
    @winrt_mixinmethod
    def GetFreeUserEntitlementForUserAsync(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager4, user: win32more.Windows.System.User, storeId: WinRT_String, campaignId: WinRT_String, correlationVector: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.GetEntitlementResult]: ...
    @winrt_mixinmethod
    def GetFreeDeviceEntitlementAsync(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager4, storeId: WinRT_String, campaignId: WinRT_String, correlationVector: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.GetEntitlementResult]: ...
    @winrt_mixinmethod
    def get_AppInstallItemsWithGroupSupport(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager5) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]: ...
    @winrt_mixinmethod
    def SearchForAllUpdatesWithUpdateOptionsAsync(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager6, correlationVector: WinRT_String, clientId: WinRT_String, updateOptions: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppUpdateOptions) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]]: ...
    @winrt_mixinmethod
    def SearchForAllUpdatesWithUpdateOptionsForUserAsync(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager6, user: win32more.Windows.System.User, correlationVector: WinRT_String, clientId: WinRT_String, updateOptions: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppUpdateOptions) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]]: ...
    @winrt_mixinmethod
    def SearchForUpdatesWithUpdateOptionsAsync(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager6, productId: WinRT_String, skuId: WinRT_String, correlationVector: WinRT_String, clientId: WinRT_String, updateOptions: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppUpdateOptions) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]: ...
    @winrt_mixinmethod
    def SearchForUpdatesWithUpdateOptionsForUserAsync(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager6, user: win32more.Windows.System.User, productId: WinRT_String, skuId: WinRT_String, correlationVector: WinRT_String, clientId: WinRT_String, updateOptions: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppUpdateOptions) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]: ...
    @winrt_mixinmethod
    def StartProductInstallWithOptionsAsync(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager6, productId: WinRT_String, flightId: WinRT_String, clientId: WinRT_String, correlationVector: WinRT_String, installOptions: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallOptions) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]]: ...
    @winrt_mixinmethod
    def StartProductInstallWithOptionsForUserAsync(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager6, user: win32more.Windows.System.User, productId: WinRT_String, flightId: WinRT_String, clientId: WinRT_String, correlationVector: WinRT_String, installOptions: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallOptions) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]]: ...
    @winrt_mixinmethod
    def GetIsPackageIdentityAllowedToInstallAsync(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager6, correlationVector: WinRT_String, packageIdentityName: WinRT_String, publisherCertificateName: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_mixinmethod
    def GetIsPackageIdentityAllowedToInstallForUserAsync(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager6, user: win32more.Windows.System.User, correlationVector: WinRT_String, packageIdentityName: WinRT_String, publisherCertificateName: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_mixinmethod
    def get_CanInstallForAllUsers(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager7) -> Boolean: ...
    AcquisitionIdentity = property(get_AcquisitionIdentity, put_AcquisitionIdentity)
    AppInstallItems = property(get_AppInstallItems, None)
    AppInstallItemsWithGroupSupport = property(get_AppInstallItemsWithGroupSupport, None)
    AutoUpdateSetting = property(get_AutoUpdateSetting, put_AutoUpdateSetting)
    CanInstallForAllUsers = property(get_CanInstallForAllUsers, None)
    ItemCompleted = event()
    ItemStatusChanged = event()
class AppInstallManagerItemEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManagerItemEventArgs
    _classid_ = 'Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallManagerItemEventArgs'
    @winrt_mixinmethod
    def get_Item(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManagerItemEventArgs) -> win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem: ...
    Item = property(get_Item, None)
class AppInstallOptions(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallOptions
    _classid_ = 'Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallOptions'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallOptions.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallOptions: ...
    @winrt_mixinmethod
    def get_CatalogId(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallOptions) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_CatalogId(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallOptions, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_ForceUseOfNonRemovableStorage(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_ForceUseOfNonRemovableStorage(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_AllowForcedAppRestart(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_AllowForcedAppRestart(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_Repair(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_Repair(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_TargetVolume(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallOptions) -> win32more.Windows.Management.Deployment.PackageVolume: ...
    @winrt_mixinmethod
    def put_TargetVolume(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallOptions, value: win32more.Windows.Management.Deployment.PackageVolume) -> Void: ...
    @winrt_mixinmethod
    def get_LaunchAfterInstall(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_LaunchAfterInstall(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_PinToDesktopAfterInstall(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallOptions2) -> Boolean: ...
    @winrt_mixinmethod
    def put_PinToDesktopAfterInstall(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallOptions2, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_PinToStartAfterInstall(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallOptions2) -> Boolean: ...
    @winrt_mixinmethod
    def put_PinToStartAfterInstall(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallOptions2, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_PinToTaskbarAfterInstall(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallOptions2) -> Boolean: ...
    @winrt_mixinmethod
    def put_PinToTaskbarAfterInstall(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallOptions2, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_CompletedInstallToastNotificationMode(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallOptions2) -> win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallationToastNotificationMode: ...
    @winrt_mixinmethod
    def put_CompletedInstallToastNotificationMode(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallOptions2, value: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallationToastNotificationMode) -> Void: ...
    @winrt_mixinmethod
    def get_InstallInProgressToastNotificationMode(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallOptions2) -> win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallationToastNotificationMode: ...
    @winrt_mixinmethod
    def put_InstallInProgressToastNotificationMode(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallOptions2, value: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallationToastNotificationMode) -> Void: ...
    @winrt_mixinmethod
    def get_InstallForAllUsers(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallOptions2) -> Boolean: ...
    @winrt_mixinmethod
    def put_InstallForAllUsers(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallOptions2, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_StageButDoNotInstall(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallOptions2) -> Boolean: ...
    @winrt_mixinmethod
    def put_StageButDoNotInstall(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallOptions2, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_CampaignId(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallOptions2) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_CampaignId(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallOptions2, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_ExtendedCampaignId(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallOptions2) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_ExtendedCampaignId(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallOptions2, value: WinRT_String) -> Void: ...
    AllowForcedAppRestart = property(get_AllowForcedAppRestart, put_AllowForcedAppRestart)
    CampaignId = property(get_CampaignId, put_CampaignId)
    CatalogId = property(get_CatalogId, put_CatalogId)
    CompletedInstallToastNotificationMode = property(get_CompletedInstallToastNotificationMode, put_CompletedInstallToastNotificationMode)
    ExtendedCampaignId = property(get_ExtendedCampaignId, put_ExtendedCampaignId)
    ForceUseOfNonRemovableStorage = property(get_ForceUseOfNonRemovableStorage, put_ForceUseOfNonRemovableStorage)
    InstallForAllUsers = property(get_InstallForAllUsers, put_InstallForAllUsers)
    InstallInProgressToastNotificationMode = property(get_InstallInProgressToastNotificationMode, put_InstallInProgressToastNotificationMode)
    LaunchAfterInstall = property(get_LaunchAfterInstall, put_LaunchAfterInstall)
    PinToDesktopAfterInstall = property(get_PinToDesktopAfterInstall, put_PinToDesktopAfterInstall)
    PinToStartAfterInstall = property(get_PinToStartAfterInstall, put_PinToStartAfterInstall)
    PinToTaskbarAfterInstall = property(get_PinToTaskbarAfterInstall, put_PinToTaskbarAfterInstall)
    Repair = property(get_Repair, put_Repair)
    StageButDoNotInstall = property(get_StageButDoNotInstall, put_StageButDoNotInstall)
    TargetVolume = property(get_TargetVolume, put_TargetVolume)
class AppInstallState(Enum, Int32):
    Pending = 0
    Starting = 1
    AcquiringLicense = 2
    Downloading = 3
    RestoringData = 4
    Installing = 5
    Completed = 6
    Canceled = 7
    Paused = 8
    Error = 9
    PausedLowBattery = 10
    PausedWiFiRecommended = 11
    PausedWiFiRequired = 12
    ReadyToDownload = 13
class AppInstallStatus(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallStatus
    _classid_ = 'Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallStatus'
    @winrt_mixinmethod
    def get_InstallState(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallStatus) -> win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallState: ...
    @winrt_mixinmethod
    def get_DownloadSizeInBytes(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallStatus) -> UInt64: ...
    @winrt_mixinmethod
    def get_BytesDownloaded(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallStatus) -> UInt64: ...
    @winrt_mixinmethod
    def get_PercentComplete(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallStatus) -> Double: ...
    @winrt_mixinmethod
    def get_ErrorCode(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallStatus) -> win32more.Windows.Foundation.HResult: ...
    @winrt_mixinmethod
    def get_User(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallStatus2) -> win32more.Windows.System.User: ...
    @winrt_mixinmethod
    def get_ReadyForLaunch(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallStatus2) -> Boolean: ...
    @winrt_mixinmethod
    def get_IsStaged(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallStatus3) -> Boolean: ...
    BytesDownloaded = property(get_BytesDownloaded, None)
    DownloadSizeInBytes = property(get_DownloadSizeInBytes, None)
    ErrorCode = property(get_ErrorCode, None)
    InstallState = property(get_InstallState, None)
    IsStaged = property(get_IsStaged, None)
    PercentComplete = property(get_PercentComplete, None)
    ReadyForLaunch = property(get_ReadyForLaunch, None)
    User = property(get_User, None)
class AppInstallType(Enum, Int32):
    Install = 0
    Update = 1
    Repair = 2
class AppInstallationToastNotificationMode(Enum, Int32):
    Default = 0
    Toast = 1
    ToastWithoutPopup = 2
    NoToast = 3
class AppUpdateOptions(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppUpdateOptions
    _classid_ = 'Windows.ApplicationModel.Store.Preview.InstallControl.AppUpdateOptions'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppUpdateOptions.CreateInstance(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppUpdateOptions: ...
    @winrt_mixinmethod
    def get_CatalogId(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppUpdateOptions) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_CatalogId(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppUpdateOptions, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def get_AllowForcedAppRestart(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppUpdateOptions) -> Boolean: ...
    @winrt_mixinmethod
    def put_AllowForcedAppRestart(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppUpdateOptions, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_AutomaticallyDownloadAndInstallUpdateIfFound(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppUpdateOptions2) -> Boolean: ...
    @winrt_mixinmethod
    def put_AutomaticallyDownloadAndInstallUpdateIfFound(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IAppUpdateOptions2, value: Boolean) -> Void: ...
    AllowForcedAppRestart = property(get_AllowForcedAppRestart, put_AllowForcedAppRestart)
    AutomaticallyDownloadAndInstallUpdateIfFound = property(get_AutomaticallyDownloadAndInstallUpdateIfFound, put_AutomaticallyDownloadAndInstallUpdateIfFound)
    CatalogId = property(get_CatalogId, put_CatalogId)
class AutoUpdateSetting(Enum, Int32):
    Disabled = 0
    Enabled = 1
    DisabledByPolicy = 2
    EnabledByPolicy = 3
class GetEntitlementResult(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IGetEntitlementResult
    _classid_ = 'Windows.ApplicationModel.Store.Preview.InstallControl.GetEntitlementResult'
    @winrt_mixinmethod
    def get_Status(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IGetEntitlementResult) -> win32more.Windows.ApplicationModel.Store.Preview.InstallControl.GetEntitlementStatus: ...
    @winrt_mixinmethod
    def get_IsAlreadyOwned(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IGetEntitlementResult2) -> Boolean: ...
    @winrt_mixinmethod
    def get_OrderId(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IGetEntitlementResult2) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_SkuId(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IGetEntitlementResult2) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_AvailabilityId(self: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.IGetEntitlementResult2) -> WinRT_String: ...
    AvailabilityId = property(get_AvailabilityId, None)
    IsAlreadyOwned = property(get_IsAlreadyOwned, None)
    OrderId = property(get_OrderId, None)
    SkuId = property(get_SkuId, None)
    Status = property(get_Status, None)
class GetEntitlementStatus(Enum, Int32):
    Succeeded = 0
    NoStoreAccount = 1
    NetworkError = 2
    ServerError = 3
class IAppInstallItem(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem'
    _iid_ = Guid('{49d3dfab-168a-4cbf-a93a-9e448c82737d}')
    @winrt_commethod(6)
    def get_ProductId(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def get_PackageFamilyName(self) -> WinRT_String: ...
    @winrt_commethod(8)
    def get_InstallType(self) -> win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallType: ...
    @winrt_commethod(9)
    def get_IsUserInitiated(self) -> Boolean: ...
    @winrt_commethod(10)
    def GetCurrentStatus(self) -> win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallStatus: ...
    @winrt_commethod(11)
    def Cancel(self) -> Void: ...
    @winrt_commethod(12)
    def Pause(self) -> Void: ...
    @winrt_commethod(13)
    def Restart(self) -> Void: ...
    @winrt_commethod(14)
    def add_Completed(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(15)
    def remove_Completed(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(16)
    def add_StatusChanged(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(17)
    def remove_StatusChanged(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    InstallType = property(get_InstallType, None)
    IsUserInitiated = property(get_IsUserInitiated, None)
    PackageFamilyName = property(get_PackageFamilyName, None)
    ProductId = property(get_ProductId, None)
    Completed = event()
    StatusChanged = event()
class IAppInstallItem2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem2'
    _iid_ = Guid('{d3972af8-40c0-4fd7-aa6c-0aa13ca6188c}')
    @winrt_commethod(6)
    def CancelWithTelemetry(self, correlationVector: WinRT_String) -> Void: ...
    @winrt_commethod(7)
    def PauseWithTelemetry(self, correlationVector: WinRT_String) -> Void: ...
    @winrt_commethod(8)
    def RestartWithTelemetry(self, correlationVector: WinRT_String) -> Void: ...
class IAppInstallItem3(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem3'
    _iid_ = Guid('{6f3dc998-dd47-433c-9234-560172d67a45}')
    @winrt_commethod(6)
    def get_Children(self) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]: ...
    @winrt_commethod(7)
    def get_ItemOperationsMightAffectOtherItems(self) -> Boolean: ...
    Children = property(get_Children, None)
    ItemOperationsMightAffectOtherItems = property(get_ItemOperationsMightAffectOtherItems, None)
class IAppInstallItem4(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem4'
    _iid_ = Guid('{c2d1ce12-71ff-4fc8-b540-453d4b37e1d1}')
    @winrt_commethod(6)
    def get_LaunchAfterInstall(self) -> Boolean: ...
    @winrt_commethod(7)
    def put_LaunchAfterInstall(self, value: Boolean) -> Void: ...
    LaunchAfterInstall = property(get_LaunchAfterInstall, put_LaunchAfterInstall)
class IAppInstallItem5(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallItem5'
    _iid_ = Guid('{5510e7cc-4076-4a0b-9472-c21d9d380e55}')
    @winrt_commethod(6)
    def get_PinToDesktopAfterInstall(self) -> Boolean: ...
    @winrt_commethod(7)
    def put_PinToDesktopAfterInstall(self, value: Boolean) -> Void: ...
    @winrt_commethod(8)
    def get_PinToStartAfterInstall(self) -> Boolean: ...
    @winrt_commethod(9)
    def put_PinToStartAfterInstall(self, value: Boolean) -> Void: ...
    @winrt_commethod(10)
    def get_PinToTaskbarAfterInstall(self) -> Boolean: ...
    @winrt_commethod(11)
    def put_PinToTaskbarAfterInstall(self, value: Boolean) -> Void: ...
    @winrt_commethod(12)
    def get_CompletedInstallToastNotificationMode(self) -> win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallationToastNotificationMode: ...
    @winrt_commethod(13)
    def put_CompletedInstallToastNotificationMode(self, value: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallationToastNotificationMode) -> Void: ...
    @winrt_commethod(14)
    def get_InstallInProgressToastNotificationMode(self) -> win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallationToastNotificationMode: ...
    @winrt_commethod(15)
    def put_InstallInProgressToastNotificationMode(self, value: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallationToastNotificationMode) -> Void: ...
    CompletedInstallToastNotificationMode = property(get_CompletedInstallToastNotificationMode, put_CompletedInstallToastNotificationMode)
    InstallInProgressToastNotificationMode = property(get_InstallInProgressToastNotificationMode, put_InstallInProgressToastNotificationMode)
    PinToDesktopAfterInstall = property(get_PinToDesktopAfterInstall, put_PinToDesktopAfterInstall)
    PinToStartAfterInstall = property(get_PinToStartAfterInstall, put_PinToStartAfterInstall)
    PinToTaskbarAfterInstall = property(get_PinToTaskbarAfterInstall, put_PinToTaskbarAfterInstall)
class IAppInstallManager(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager'
    _iid_ = Guid('{9353e170-8441-4b45-bd72-7c2fa925beee}')
    @winrt_commethod(6)
    def get_AppInstallItems(self) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]: ...
    @winrt_commethod(7)
    def Cancel(self, productId: WinRT_String) -> Void: ...
    @winrt_commethod(8)
    def Pause(self, productId: WinRT_String) -> Void: ...
    @winrt_commethod(9)
    def Restart(self, productId: WinRT_String) -> Void: ...
    @winrt_commethod(10)
    def add_ItemCompleted(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallManager, win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallManagerItemEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(11)
    def remove_ItemCompleted(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(12)
    def add_ItemStatusChanged(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallManager, win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallManagerItemEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(13)
    def remove_ItemStatusChanged(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_commethod(14)
    def get_AutoUpdateSetting(self) -> win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AutoUpdateSetting: ...
    @winrt_commethod(15)
    def put_AutoUpdateSetting(self, value: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AutoUpdateSetting) -> Void: ...
    @winrt_commethod(16)
    def get_AcquisitionIdentity(self) -> WinRT_String: ...
    @winrt_commethod(17)
    def put_AcquisitionIdentity(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(18)
    def GetIsApplicableAsync(self, productId: WinRT_String, skuId: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_commethod(19)
    def StartAppInstallAsync(self, productId: WinRT_String, skuId: WinRT_String, repair: Boolean, forceUseOfNonRemovableStorage: Boolean) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]: ...
    @winrt_commethod(20)
    def UpdateAppByPackageFamilyNameAsync(self, packageFamilyName: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]: ...
    @winrt_commethod(21)
    def SearchForUpdatesAsync(self, productId: WinRT_String, skuId: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]: ...
    @winrt_commethod(22)
    def SearchForAllUpdatesAsync(self) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]]: ...
    @winrt_commethod(23)
    def IsStoreBlockedByPolicyAsync(self, storeClientName: WinRT_String, storeClientPublisher: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_commethod(24)
    def GetIsAppAllowedToInstallAsync(self, productId: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    AcquisitionIdentity = property(get_AcquisitionIdentity, put_AcquisitionIdentity)
    AppInstallItems = property(get_AppInstallItems, None)
    AutoUpdateSetting = property(get_AutoUpdateSetting, put_AutoUpdateSetting)
    ItemCompleted = event()
    ItemStatusChanged = event()
class IAppInstallManager2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager2'
    _iid_ = Guid('{16937851-ed37-480d-8314-52e27c03f04a}')
    @winrt_commethod(6)
    def StartAppInstallWithTelemetryAsync(self, productId: WinRT_String, skuId: WinRT_String, repair: Boolean, forceUseOfNonRemovableStorage: Boolean, catalogId: WinRT_String, bundleId: WinRT_String, correlationVector: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]: ...
    @winrt_commethod(7)
    def UpdateAppByPackageFamilyNameWithTelemetryAsync(self, packageFamilyName: WinRT_String, correlationVector: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]: ...
    @winrt_commethod(8)
    def SearchForUpdatesWithTelemetryAsync(self, productId: WinRT_String, skuId: WinRT_String, catalogId: WinRT_String, correlationVector: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]: ...
    @winrt_commethod(9)
    def SearchForAllUpdatesWithTelemetryAsync(self, correlationVector: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]]: ...
    @winrt_commethod(10)
    def GetIsAppAllowedToInstallWithTelemetryAsync(self, productId: WinRT_String, skuId: WinRT_String, catalogId: WinRT_String, correlationVector: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_commethod(11)
    def CancelWithTelemetry(self, productId: WinRT_String, correlationVector: WinRT_String) -> Void: ...
    @winrt_commethod(12)
    def PauseWithTelemetry(self, productId: WinRT_String, correlationVector: WinRT_String) -> Void: ...
    @winrt_commethod(13)
    def RestartWithTelemetry(self, productId: WinRT_String, correlationVector: WinRT_String) -> Void: ...
class IAppInstallManager3(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager3'
    _iid_ = Guid('{95b24b17-e96a-4d0e-84e1-c8cb417a0178}')
    @winrt_commethod(6)
    def StartProductInstallAsync(self, productId: WinRT_String, catalogId: WinRT_String, flightId: WinRT_String, clientId: WinRT_String, repair: Boolean, forceUseOfNonRemovableStorage: Boolean, correlationVector: WinRT_String, targetVolume: win32more.Windows.Management.Deployment.PackageVolume) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]]: ...
    @winrt_commethod(7)
    def StartProductInstallForUserAsync(self, user: win32more.Windows.System.User, productId: WinRT_String, catalogId: WinRT_String, flightId: WinRT_String, clientId: WinRT_String, repair: Boolean, forceUseOfNonRemovableStorage: Boolean, correlationVector: WinRT_String, targetVolume: win32more.Windows.Management.Deployment.PackageVolume) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]]: ...
    @winrt_commethod(8)
    def UpdateAppByPackageFamilyNameForUserAsync(self, user: win32more.Windows.System.User, packageFamilyName: WinRT_String, correlationVector: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]: ...
    @winrt_commethod(9)
    def SearchForUpdatesForUserAsync(self, user: win32more.Windows.System.User, productId: WinRT_String, skuId: WinRT_String, catalogId: WinRT_String, correlationVector: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]: ...
    @winrt_commethod(10)
    def SearchForAllUpdatesForUserAsync(self, user: win32more.Windows.System.User, correlationVector: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]]: ...
    @winrt_commethod(11)
    def GetIsAppAllowedToInstallForUserAsync(self, user: win32more.Windows.System.User, productId: WinRT_String, skuId: WinRT_String, catalogId: WinRT_String, correlationVector: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_commethod(12)
    def GetIsApplicableForUserAsync(self, user: win32more.Windows.System.User, productId: WinRT_String, skuId: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_commethod(13)
    def MoveToFrontOfDownloadQueue(self, productId: WinRT_String, correlationVector: WinRT_String) -> Void: ...
class IAppInstallManager4(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager4'
    _iid_ = Guid('{260a2a16-5a9e-4ebd-b944-f2ba75c31159}')
    @winrt_commethod(6)
    def GetFreeUserEntitlementAsync(self, storeId: WinRT_String, campaignId: WinRT_String, correlationVector: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.GetEntitlementResult]: ...
    @winrt_commethod(7)
    def GetFreeUserEntitlementForUserAsync(self, user: win32more.Windows.System.User, storeId: WinRT_String, campaignId: WinRT_String, correlationVector: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.GetEntitlementResult]: ...
    @winrt_commethod(8)
    def GetFreeDeviceEntitlementAsync(self, storeId: WinRT_String, campaignId: WinRT_String, correlationVector: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.GetEntitlementResult]: ...
class IAppInstallManager5(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager5'
    _iid_ = Guid('{3cd7be4c-1be9-4f7f-b675-aa1d64a529b2}')
    @winrt_commethod(6)
    def get_AppInstallItemsWithGroupSupport(self) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]: ...
    AppInstallItemsWithGroupSupport = property(get_AppInstallItemsWithGroupSupport, None)
class IAppInstallManager6(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager6'
    _iid_ = Guid('{c9e7d408-f27a-4471-b2f4-e76efcbebcca}')
    @winrt_commethod(6)
    def SearchForAllUpdatesWithUpdateOptionsAsync(self, correlationVector: WinRT_String, clientId: WinRT_String, updateOptions: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppUpdateOptions) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]]: ...
    @winrt_commethod(7)
    def SearchForAllUpdatesWithUpdateOptionsForUserAsync(self, user: win32more.Windows.System.User, correlationVector: WinRT_String, clientId: WinRT_String, updateOptions: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppUpdateOptions) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]]: ...
    @winrt_commethod(8)
    def SearchForUpdatesWithUpdateOptionsAsync(self, productId: WinRT_String, skuId: WinRT_String, correlationVector: WinRT_String, clientId: WinRT_String, updateOptions: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppUpdateOptions) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]: ...
    @winrt_commethod(9)
    def SearchForUpdatesWithUpdateOptionsForUserAsync(self, user: win32more.Windows.System.User, productId: WinRT_String, skuId: WinRT_String, correlationVector: WinRT_String, clientId: WinRT_String, updateOptions: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppUpdateOptions) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]: ...
    @winrt_commethod(10)
    def StartProductInstallWithOptionsAsync(self, productId: WinRT_String, flightId: WinRT_String, clientId: WinRT_String, correlationVector: WinRT_String, installOptions: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallOptions) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]]: ...
    @winrt_commethod(11)
    def StartProductInstallWithOptionsForUserAsync(self, user: win32more.Windows.System.User, productId: WinRT_String, flightId: WinRT_String, clientId: WinRT_String, correlationVector: WinRT_String, installOptions: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallOptions) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem]]: ...
    @winrt_commethod(12)
    def GetIsPackageIdentityAllowedToInstallAsync(self, correlationVector: WinRT_String, packageIdentityName: WinRT_String, publisherCertificateName: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
    @winrt_commethod(13)
    def GetIsPackageIdentityAllowedToInstallForUserAsync(self, user: win32more.Windows.System.User, correlationVector: WinRT_String, packageIdentityName: WinRT_String, publisherCertificateName: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[Boolean]: ...
class IAppInstallManager7(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManager7'
    _iid_ = Guid('{a5ee7b30-d5e4-49a3-9853-3db03203321d}')
    @winrt_commethod(6)
    def get_CanInstallForAllUsers(self) -> Boolean: ...
    CanInstallForAllUsers = property(get_CanInstallForAllUsers, None)
class IAppInstallManagerItemEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallManagerItemEventArgs'
    _iid_ = Guid('{bc505743-4674-4dd1-957e-c25682086a14}')
    @winrt_commethod(6)
    def get_Item(self) -> win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallItem: ...
    Item = property(get_Item, None)
class IAppInstallOptions(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallOptions'
    _iid_ = Guid('{c9808300-1cb8-4eb6-8c9f-6a30c64a5b51}')
    @winrt_commethod(6)
    def get_CatalogId(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def put_CatalogId(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(8)
    def get_ForceUseOfNonRemovableStorage(self) -> Boolean: ...
    @winrt_commethod(9)
    def put_ForceUseOfNonRemovableStorage(self, value: Boolean) -> Void: ...
    @winrt_commethod(10)
    def get_AllowForcedAppRestart(self) -> Boolean: ...
    @winrt_commethod(11)
    def put_AllowForcedAppRestart(self, value: Boolean) -> Void: ...
    @winrt_commethod(12)
    def get_Repair(self) -> Boolean: ...
    @winrt_commethod(13)
    def put_Repair(self, value: Boolean) -> Void: ...
    @winrt_commethod(14)
    def get_TargetVolume(self) -> win32more.Windows.Management.Deployment.PackageVolume: ...
    @winrt_commethod(15)
    def put_TargetVolume(self, value: win32more.Windows.Management.Deployment.PackageVolume) -> Void: ...
    @winrt_commethod(16)
    def get_LaunchAfterInstall(self) -> Boolean: ...
    @winrt_commethod(17)
    def put_LaunchAfterInstall(self, value: Boolean) -> Void: ...
    AllowForcedAppRestart = property(get_AllowForcedAppRestart, put_AllowForcedAppRestart)
    CatalogId = property(get_CatalogId, put_CatalogId)
    ForceUseOfNonRemovableStorage = property(get_ForceUseOfNonRemovableStorage, put_ForceUseOfNonRemovableStorage)
    LaunchAfterInstall = property(get_LaunchAfterInstall, put_LaunchAfterInstall)
    Repair = property(get_Repair, put_Repair)
    TargetVolume = property(get_TargetVolume, put_TargetVolume)
class IAppInstallOptions2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallOptions2'
    _iid_ = Guid('{8a04c0d7-c94b-425e-95b4-bf27faeaee89}')
    @winrt_commethod(6)
    def get_PinToDesktopAfterInstall(self) -> Boolean: ...
    @winrt_commethod(7)
    def put_PinToDesktopAfterInstall(self, value: Boolean) -> Void: ...
    @winrt_commethod(8)
    def get_PinToStartAfterInstall(self) -> Boolean: ...
    @winrt_commethod(9)
    def put_PinToStartAfterInstall(self, value: Boolean) -> Void: ...
    @winrt_commethod(10)
    def get_PinToTaskbarAfterInstall(self) -> Boolean: ...
    @winrt_commethod(11)
    def put_PinToTaskbarAfterInstall(self, value: Boolean) -> Void: ...
    @winrt_commethod(12)
    def get_CompletedInstallToastNotificationMode(self) -> win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallationToastNotificationMode: ...
    @winrt_commethod(13)
    def put_CompletedInstallToastNotificationMode(self, value: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallationToastNotificationMode) -> Void: ...
    @winrt_commethod(14)
    def get_InstallInProgressToastNotificationMode(self) -> win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallationToastNotificationMode: ...
    @winrt_commethod(15)
    def put_InstallInProgressToastNotificationMode(self, value: win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallationToastNotificationMode) -> Void: ...
    @winrt_commethod(16)
    def get_InstallForAllUsers(self) -> Boolean: ...
    @winrt_commethod(17)
    def put_InstallForAllUsers(self, value: Boolean) -> Void: ...
    @winrt_commethod(18)
    def get_StageButDoNotInstall(self) -> Boolean: ...
    @winrt_commethod(19)
    def put_StageButDoNotInstall(self, value: Boolean) -> Void: ...
    @winrt_commethod(20)
    def get_CampaignId(self) -> WinRT_String: ...
    @winrt_commethod(21)
    def put_CampaignId(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(22)
    def get_ExtendedCampaignId(self) -> WinRT_String: ...
    @winrt_commethod(23)
    def put_ExtendedCampaignId(self, value: WinRT_String) -> Void: ...
    CampaignId = property(get_CampaignId, put_CampaignId)
    CompletedInstallToastNotificationMode = property(get_CompletedInstallToastNotificationMode, put_CompletedInstallToastNotificationMode)
    ExtendedCampaignId = property(get_ExtendedCampaignId, put_ExtendedCampaignId)
    InstallForAllUsers = property(get_InstallForAllUsers, put_InstallForAllUsers)
    InstallInProgressToastNotificationMode = property(get_InstallInProgressToastNotificationMode, put_InstallInProgressToastNotificationMode)
    PinToDesktopAfterInstall = property(get_PinToDesktopAfterInstall, put_PinToDesktopAfterInstall)
    PinToStartAfterInstall = property(get_PinToStartAfterInstall, put_PinToStartAfterInstall)
    PinToTaskbarAfterInstall = property(get_PinToTaskbarAfterInstall, put_PinToTaskbarAfterInstall)
    StageButDoNotInstall = property(get_StageButDoNotInstall, put_StageButDoNotInstall)
class IAppInstallStatus(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallStatus'
    _iid_ = Guid('{936dccfa-2450-4126-88b1-6127a644dd5c}')
    @winrt_commethod(6)
    def get_InstallState(self) -> win32more.Windows.ApplicationModel.Store.Preview.InstallControl.AppInstallState: ...
    @winrt_commethod(7)
    def get_DownloadSizeInBytes(self) -> UInt64: ...
    @winrt_commethod(8)
    def get_BytesDownloaded(self) -> UInt64: ...
    @winrt_commethod(9)
    def get_PercentComplete(self) -> Double: ...
    @winrt_commethod(10)
    def get_ErrorCode(self) -> win32more.Windows.Foundation.HResult: ...
    BytesDownloaded = property(get_BytesDownloaded, None)
    DownloadSizeInBytes = property(get_DownloadSizeInBytes, None)
    ErrorCode = property(get_ErrorCode, None)
    InstallState = property(get_InstallState, None)
    PercentComplete = property(get_PercentComplete, None)
class IAppInstallStatus2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallStatus2'
    _iid_ = Guid('{96e7818a-5e92-4aa9-8edc-58fed4b87e00}')
    @winrt_commethod(6)
    def get_User(self) -> win32more.Windows.System.User: ...
    @winrt_commethod(7)
    def get_ReadyForLaunch(self) -> Boolean: ...
    ReadyForLaunch = property(get_ReadyForLaunch, None)
    User = property(get_User, None)
class IAppInstallStatus3(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Store.Preview.InstallControl.IAppInstallStatus3'
    _iid_ = Guid('{cb880c56-837b-4b4c-9ebb-6d44a0a96307}')
    @winrt_commethod(6)
    def get_IsStaged(self) -> Boolean: ...
    IsStaged = property(get_IsStaged, None)
class IAppUpdateOptions(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Store.Preview.InstallControl.IAppUpdateOptions'
    _iid_ = Guid('{26f0b02f-c2f3-4aea-af8c-6308dd9db85f}')
    @winrt_commethod(6)
    def get_CatalogId(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def put_CatalogId(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(8)
    def get_AllowForcedAppRestart(self) -> Boolean: ...
    @winrt_commethod(9)
    def put_AllowForcedAppRestart(self, value: Boolean) -> Void: ...
    AllowForcedAppRestart = property(get_AllowForcedAppRestart, put_AllowForcedAppRestart)
    CatalogId = property(get_CatalogId, put_CatalogId)
class IAppUpdateOptions2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Store.Preview.InstallControl.IAppUpdateOptions2'
    _iid_ = Guid('{f4646e08-ed26-4bf9-9679-48f628e53df8}')
    @winrt_commethod(6)
    def get_AutomaticallyDownloadAndInstallUpdateIfFound(self) -> Boolean: ...
    @winrt_commethod(7)
    def put_AutomaticallyDownloadAndInstallUpdateIfFound(self, value: Boolean) -> Void: ...
    AutomaticallyDownloadAndInstallUpdateIfFound = property(get_AutomaticallyDownloadAndInstallUpdateIfFound, put_AutomaticallyDownloadAndInstallUpdateIfFound)
class IGetEntitlementResult(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Store.Preview.InstallControl.IGetEntitlementResult'
    _iid_ = Guid('{74fc843f-1a9e-4609-8e4d-819086d08a3d}')
    @winrt_commethod(6)
    def get_Status(self) -> win32more.Windows.ApplicationModel.Store.Preview.InstallControl.GetEntitlementStatus: ...
    Status = property(get_Status, None)
class IGetEntitlementResult2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.ApplicationModel.Store.Preview.InstallControl.IGetEntitlementResult2'
    _iid_ = Guid('{e3906641-a981-4302-8c68-ff836666bb3b}')
    @winrt_commethod(6)
    def get_IsAlreadyOwned(self) -> Boolean: ...
    @winrt_commethod(7)
    def get_OrderId(self) -> WinRT_String: ...
    @winrt_commethod(8)
    def get_SkuId(self) -> WinRT_String: ...
    @winrt_commethod(9)
    def get_AvailabilityId(self) -> WinRT_String: ...
    AvailabilityId = property(get_AvailabilityId, None)
    IsAlreadyOwned = property(get_IsAlreadyOwned, None)
    OrderId = property(get_OrderId, None)
    SkuId = property(get_SkuId, None)


make_ready(__name__)
