from __future__ import annotations
from win32more.winrt.prelude import *
import win32more.Windows.Devices.Lights
import win32more.Windows.Foundation
import win32more.Windows.Foundation.Numerics
import win32more.Windows.Storage.Streams
import win32more.Windows.System
import win32more.Windows.UI
class ILamp(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    _classid_ = 'Windows.Devices.Lights.ILamp'
    _iid_ = Guid('{047d5b9a-ea45-4b2b-b1a2-14dff00bde7b}')
    @winrt_commethod(6)
    def get_DeviceId(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def get_IsEnabled(self) -> Boolean: ...
    @winrt_commethod(8)
    def put_IsEnabled(self, value: Boolean) -> Void: ...
    @winrt_commethod(9)
    def get_BrightnessLevel(self) -> Single: ...
    @winrt_commethod(10)
    def put_BrightnessLevel(self, value: Single) -> Void: ...
    @winrt_commethod(11)
    def get_IsColorSettable(self) -> Boolean: ...
    @winrt_commethod(12)
    def get_Color(self) -> win32more.Windows.UI.Color: ...
    @winrt_commethod(13)
    def put_Color(self, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(14)
    def add_AvailabilityChanged(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Devices.Lights.Lamp, win32more.Windows.Devices.Lights.LampAvailabilityChangedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(15)
    def remove_AvailabilityChanged(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    BrightnessLevel = property(get_BrightnessLevel, put_BrightnessLevel)
    Color = property(get_Color, put_Color)
    DeviceId = property(get_DeviceId, None)
    IsColorSettable = property(get_IsColorSettable, None)
    IsEnabled = property(get_IsEnabled, put_IsEnabled)
    AvailabilityChanged = event()
class ILampArray(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Devices.Lights.ILampArray'
    _iid_ = Guid('{7ace9787-c8a0-4e95-a1e0-d58676538649}')
    @winrt_commethod(6)
    def get_DeviceId(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def get_HardwareVendorId(self) -> UInt16: ...
    @winrt_commethod(8)
    def get_HardwareProductId(self) -> UInt16: ...
    @winrt_commethod(9)
    def get_HardwareVersion(self) -> UInt16: ...
    @winrt_commethod(10)
    def get_LampArrayKind(self) -> win32more.Windows.Devices.Lights.LampArrayKind: ...
    @winrt_commethod(11)
    def get_LampCount(self) -> Int32: ...
    @winrt_commethod(12)
    def get_MinUpdateInterval(self) -> win32more.Windows.Foundation.TimeSpan: ...
    @winrt_commethod(13)
    def get_BoundingBox(self) -> win32more.Windows.Foundation.Numerics.Vector3: ...
    @winrt_commethod(14)
    def get_IsEnabled(self) -> Boolean: ...
    @winrt_commethod(15)
    def put_IsEnabled(self, value: Boolean) -> Void: ...
    @winrt_commethod(16)
    def get_BrightnessLevel(self) -> Double: ...
    @winrt_commethod(17)
    def put_BrightnessLevel(self, value: Double) -> Void: ...
    @winrt_commethod(18)
    def get_IsConnected(self) -> Boolean: ...
    @winrt_commethod(19)
    def get_SupportsVirtualKeys(self) -> Boolean: ...
    @winrt_commethod(20)
    def GetLampInfo(self, lampIndex: Int32) -> win32more.Windows.Devices.Lights.LampInfo: ...
    @winrt_commethod(21)
    def GetIndicesForKey(self, key: win32more.Windows.System.VirtualKey) -> ReceiveArray[Int32]: ...
    @winrt_commethod(22)
    def GetIndicesForPurposes(self, purposes: win32more.Windows.Devices.Lights.LampPurposes) -> ReceiveArray[Int32]: ...
    @winrt_commethod(23)
    def SetColor(self, desiredColor: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(24)
    def SetColorForIndex(self, lampIndex: Int32, desiredColor: win32more.Windows.UI.Color) -> Void: ...
    @winrt_commethod(25)
    def SetSingleColorForIndices(self, desiredColor: win32more.Windows.UI.Color, lampIndexes: PassArray[Int32]) -> Void: ...
    @winrt_commethod(26)
    def SetColorsForIndices(self, desiredColors: PassArray[win32more.Windows.UI.Color], lampIndexes: PassArray[Int32]) -> Void: ...
    @winrt_commethod(27)
    def SetColorsForKey(self, desiredColor: win32more.Windows.UI.Color, key: win32more.Windows.System.VirtualKey) -> Void: ...
    @winrt_commethod(28)
    def SetColorsForKeys(self, desiredColors: PassArray[win32more.Windows.UI.Color], keys: PassArray[win32more.Windows.System.VirtualKey]) -> Void: ...
    @winrt_commethod(29)
    def SetColorsForPurposes(self, desiredColor: win32more.Windows.UI.Color, purposes: win32more.Windows.Devices.Lights.LampPurposes) -> Void: ...
    @winrt_commethod(30)
    def SendMessageAsync(self, messageId: Int32, message: win32more.Windows.Storage.Streams.IBuffer) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_commethod(31)
    def RequestMessageAsync(self, messageId: Int32) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Storage.Streams.IBuffer]: ...
    BoundingBox = property(get_BoundingBox, None)
    BrightnessLevel = property(get_BrightnessLevel, put_BrightnessLevel)
    DeviceId = property(get_DeviceId, None)
    HardwareProductId = property(get_HardwareProductId, None)
    HardwareVendorId = property(get_HardwareVendorId, None)
    HardwareVersion = property(get_HardwareVersion, None)
    IsConnected = property(get_IsConnected, None)
    IsEnabled = property(get_IsEnabled, put_IsEnabled)
    LampArrayKind = property(get_LampArrayKind, None)
    LampCount = property(get_LampCount, None)
    MinUpdateInterval = property(get_MinUpdateInterval, None)
    SupportsVirtualKeys = property(get_SupportsVirtualKeys, None)
class ILampArray2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Devices.Lights.ILampArray2'
    _iid_ = Guid('{050c181f-60a8-4711-a1af-1b1b4c658ea2}')
    @winrt_commethod(6)
    def get_IsAvailable(self) -> Boolean: ...
    @winrt_commethod(7)
    def add_AvailabilityChanged(self, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Devices.Lights.LampArray, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_commethod(8)
    def remove_AvailabilityChanged(self, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    IsAvailable = property(get_IsAvailable, None)
    AvailabilityChanged = event()
class ILampArrayStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Devices.Lights.ILampArrayStatics'
    _iid_ = Guid('{7bb8c98d-5fc1-452d-bb1f-4ad410d398ff}')
    @winrt_commethod(6)
    def GetDeviceSelector(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def FromIdAsync(self, deviceId: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Devices.Lights.LampArray]: ...
class ILampAvailabilityChangedEventArgs(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Devices.Lights.ILampAvailabilityChangedEventArgs'
    _iid_ = Guid('{4f6e3ded-07a2-499d-9260-67e304532ba4}')
    @winrt_commethod(6)
    def get_IsAvailable(self) -> Boolean: ...
    IsAvailable = property(get_IsAvailable, None)
class ILampInfo(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Devices.Lights.ILampInfo'
    _iid_ = Guid('{30bb521c-0acf-49da-8c10-150b9cf62713}')
    @winrt_commethod(6)
    def get_Index(self) -> Int32: ...
    @winrt_commethod(7)
    def get_Purposes(self) -> win32more.Windows.Devices.Lights.LampPurposes: ...
    @winrt_commethod(8)
    def get_Position(self) -> win32more.Windows.Foundation.Numerics.Vector3: ...
    @winrt_commethod(9)
    def get_RedLevelCount(self) -> Int32: ...
    @winrt_commethod(10)
    def get_GreenLevelCount(self) -> Int32: ...
    @winrt_commethod(11)
    def get_BlueLevelCount(self) -> Int32: ...
    @winrt_commethod(12)
    def get_GainLevelCount(self) -> Int32: ...
    @winrt_commethod(13)
    def get_FixedColor(self) -> win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]: ...
    @winrt_commethod(14)
    def GetNearestSupportedColor(self, desiredColor: win32more.Windows.UI.Color) -> win32more.Windows.UI.Color: ...
    @winrt_commethod(15)
    def get_UpdateLatency(self) -> win32more.Windows.Foundation.TimeSpan: ...
    BlueLevelCount = property(get_BlueLevelCount, None)
    FixedColor = property(get_FixedColor, None)
    GainLevelCount = property(get_GainLevelCount, None)
    GreenLevelCount = property(get_GreenLevelCount, None)
    Index = property(get_Index, None)
    Position = property(get_Position, None)
    Purposes = property(get_Purposes, None)
    RedLevelCount = property(get_RedLevelCount, None)
    UpdateLatency = property(get_UpdateLatency, None)
class ILampStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Devices.Lights.ILampStatics'
    _iid_ = Guid('{a822416c-8885-401e-b821-8e8b38a8e8ec}')
    @winrt_commethod(6)
    def GetDeviceSelector(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def FromIdAsync(self, deviceId: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Devices.Lights.Lamp]: ...
    @winrt_commethod(8)
    def GetDefaultAsync(self) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Devices.Lights.Lamp]: ...
class Lamp(ComPtr):
    extends: IInspectable
    implements: Tuple[ContextManagerProtocol]
    default_interface: win32more.Windows.Devices.Lights.ILamp
    _classid_ = 'Windows.Devices.Lights.Lamp'
    @winrt_mixinmethod
    def get_DeviceId(self: win32more.Windows.Devices.Lights.ILamp) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_IsEnabled(self: win32more.Windows.Devices.Lights.ILamp) -> Boolean: ...
    @winrt_mixinmethod
    def put_IsEnabled(self: win32more.Windows.Devices.Lights.ILamp, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BrightnessLevel(self: win32more.Windows.Devices.Lights.ILamp) -> Single: ...
    @winrt_mixinmethod
    def put_BrightnessLevel(self: win32more.Windows.Devices.Lights.ILamp, value: Single) -> Void: ...
    @winrt_mixinmethod
    def get_IsColorSettable(self: win32more.Windows.Devices.Lights.ILamp) -> Boolean: ...
    @winrt_mixinmethod
    def get_Color(self: win32more.Windows.Devices.Lights.ILamp) -> win32more.Windows.UI.Color: ...
    @winrt_mixinmethod
    def put_Color(self: win32more.Windows.Devices.Lights.ILamp, value: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def add_AvailabilityChanged(self: win32more.Windows.Devices.Lights.ILamp, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Devices.Lights.Lamp, win32more.Windows.Devices.Lights.LampAvailabilityChangedEventArgs]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_AvailabilityChanged(self: win32more.Windows.Devices.Lights.ILamp, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_mixinmethod
    def Close(self: win32more.Windows.Foundation.IClosable) -> Void: ...
    @winrt_classmethod
    def GetDeviceSelector(cls: win32more.Windows.Devices.Lights.ILampStatics) -> WinRT_String: ...
    @winrt_classmethod
    def FromIdAsync(cls: win32more.Windows.Devices.Lights.ILampStatics, deviceId: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Devices.Lights.Lamp]: ...
    @winrt_classmethod
    def GetDefaultAsync(cls: win32more.Windows.Devices.Lights.ILampStatics) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Devices.Lights.Lamp]: ...
    BrightnessLevel = property(get_BrightnessLevel, put_BrightnessLevel)
    Color = property(get_Color, put_Color)
    DeviceId = property(get_DeviceId, None)
    IsColorSettable = property(get_IsColorSettable, None)
    IsEnabled = property(get_IsEnabled, put_IsEnabled)
    AvailabilityChanged = event()
class LampArray(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Devices.Lights.ILampArray
    _classid_ = 'Windows.Devices.Lights.LampArray'
    @winrt_mixinmethod
    def get_DeviceId(self: win32more.Windows.Devices.Lights.ILampArray) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_HardwareVendorId(self: win32more.Windows.Devices.Lights.ILampArray) -> UInt16: ...
    @winrt_mixinmethod
    def get_HardwareProductId(self: win32more.Windows.Devices.Lights.ILampArray) -> UInt16: ...
    @winrt_mixinmethod
    def get_HardwareVersion(self: win32more.Windows.Devices.Lights.ILampArray) -> UInt16: ...
    @winrt_mixinmethod
    def get_LampArrayKind(self: win32more.Windows.Devices.Lights.ILampArray) -> win32more.Windows.Devices.Lights.LampArrayKind: ...
    @winrt_mixinmethod
    def get_LampCount(self: win32more.Windows.Devices.Lights.ILampArray) -> Int32: ...
    @winrt_mixinmethod
    def get_MinUpdateInterval(self: win32more.Windows.Devices.Lights.ILampArray) -> win32more.Windows.Foundation.TimeSpan: ...
    @winrt_mixinmethod
    def get_BoundingBox(self: win32more.Windows.Devices.Lights.ILampArray) -> win32more.Windows.Foundation.Numerics.Vector3: ...
    @winrt_mixinmethod
    def get_IsEnabled(self: win32more.Windows.Devices.Lights.ILampArray) -> Boolean: ...
    @winrt_mixinmethod
    def put_IsEnabled(self: win32more.Windows.Devices.Lights.ILampArray, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_BrightnessLevel(self: win32more.Windows.Devices.Lights.ILampArray) -> Double: ...
    @winrt_mixinmethod
    def put_BrightnessLevel(self: win32more.Windows.Devices.Lights.ILampArray, value: Double) -> Void: ...
    @winrt_mixinmethod
    def get_IsConnected(self: win32more.Windows.Devices.Lights.ILampArray) -> Boolean: ...
    @winrt_mixinmethod
    def get_SupportsVirtualKeys(self: win32more.Windows.Devices.Lights.ILampArray) -> Boolean: ...
    @winrt_mixinmethod
    def GetLampInfo(self: win32more.Windows.Devices.Lights.ILampArray, lampIndex: Int32) -> win32more.Windows.Devices.Lights.LampInfo: ...
    @winrt_mixinmethod
    def GetIndicesForKey(self: win32more.Windows.Devices.Lights.ILampArray, key: win32more.Windows.System.VirtualKey) -> ReceiveArray[Int32]: ...
    @winrt_mixinmethod
    def GetIndicesForPurposes(self: win32more.Windows.Devices.Lights.ILampArray, purposes: win32more.Windows.Devices.Lights.LampPurposes) -> ReceiveArray[Int32]: ...
    @winrt_mixinmethod
    def SetColor(self: win32more.Windows.Devices.Lights.ILampArray, desiredColor: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def SetColorForIndex(self: win32more.Windows.Devices.Lights.ILampArray, lampIndex: Int32, desiredColor: win32more.Windows.UI.Color) -> Void: ...
    @winrt_mixinmethod
    def SetSingleColorForIndices(self: win32more.Windows.Devices.Lights.ILampArray, desiredColor: win32more.Windows.UI.Color, lampIndexes: PassArray[Int32]) -> Void: ...
    @winrt_mixinmethod
    def SetColorsForIndices(self: win32more.Windows.Devices.Lights.ILampArray, desiredColors: PassArray[win32more.Windows.UI.Color], lampIndexes: PassArray[Int32]) -> Void: ...
    @winrt_mixinmethod
    def SetColorsForKey(self: win32more.Windows.Devices.Lights.ILampArray, desiredColor: win32more.Windows.UI.Color, key: win32more.Windows.System.VirtualKey) -> Void: ...
    @winrt_mixinmethod
    def SetColorsForKeys(self: win32more.Windows.Devices.Lights.ILampArray, desiredColors: PassArray[win32more.Windows.UI.Color], keys: PassArray[win32more.Windows.System.VirtualKey]) -> Void: ...
    @winrt_mixinmethod
    def SetColorsForPurposes(self: win32more.Windows.Devices.Lights.ILampArray, desiredColor: win32more.Windows.UI.Color, purposes: win32more.Windows.Devices.Lights.LampPurposes) -> Void: ...
    @winrt_mixinmethod
    def SendMessageAsync(self: win32more.Windows.Devices.Lights.ILampArray, messageId: Int32, message: win32more.Windows.Storage.Streams.IBuffer) -> win32more.Windows.Foundation.IAsyncAction: ...
    @winrt_mixinmethod
    def RequestMessageAsync(self: win32more.Windows.Devices.Lights.ILampArray, messageId: Int32) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Storage.Streams.IBuffer]: ...
    @winrt_mixinmethod
    def get_IsAvailable(self: win32more.Windows.Devices.Lights.ILampArray2) -> Boolean: ...
    @winrt_mixinmethod
    def add_AvailabilityChanged(self: win32more.Windows.Devices.Lights.ILampArray2, handler: win32more.Windows.Foundation.TypedEventHandler[win32more.Windows.Devices.Lights.LampArray, IInspectable]) -> win32more.Windows.Foundation.EventRegistrationToken: ...
    @winrt_mixinmethod
    def remove_AvailabilityChanged(self: win32more.Windows.Devices.Lights.ILampArray2, token: win32more.Windows.Foundation.EventRegistrationToken) -> Void: ...
    @winrt_classmethod
    def GetDeviceSelector(cls: win32more.Windows.Devices.Lights.ILampArrayStatics) -> WinRT_String: ...
    @winrt_classmethod
    def FromIdAsync(cls: win32more.Windows.Devices.Lights.ILampArrayStatics, deviceId: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Devices.Lights.LampArray]: ...
    BoundingBox = property(get_BoundingBox, None)
    BrightnessLevel = property(get_BrightnessLevel, put_BrightnessLevel)
    DeviceId = property(get_DeviceId, None)
    HardwareProductId = property(get_HardwareProductId, None)
    HardwareVendorId = property(get_HardwareVendorId, None)
    HardwareVersion = property(get_HardwareVersion, None)
    IsAvailable = property(get_IsAvailable, None)
    IsConnected = property(get_IsConnected, None)
    IsEnabled = property(get_IsEnabled, put_IsEnabled)
    LampArrayKind = property(get_LampArrayKind, None)
    LampCount = property(get_LampCount, None)
    MinUpdateInterval = property(get_MinUpdateInterval, None)
    SupportsVirtualKeys = property(get_SupportsVirtualKeys, None)
    AvailabilityChanged = event()
class LampArrayKind(Enum, Int32):
    Undefined = 0
    Keyboard = 1
    Mouse = 2
    GameController = 3
    Peripheral = 4
    Scene = 5
    Notification = 6
    Chassis = 7
    Wearable = 8
    Furniture = 9
    Art = 10
    Headset = 11
    Microphone = 12
    Speaker = 13
class LampAvailabilityChangedEventArgs(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Devices.Lights.ILampAvailabilityChangedEventArgs
    _classid_ = 'Windows.Devices.Lights.LampAvailabilityChangedEventArgs'
    @winrt_mixinmethod
    def get_IsAvailable(self: win32more.Windows.Devices.Lights.ILampAvailabilityChangedEventArgs) -> Boolean: ...
    IsAvailable = property(get_IsAvailable, None)
class LampInfo(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Devices.Lights.ILampInfo
    _classid_ = 'Windows.Devices.Lights.LampInfo'
    @winrt_mixinmethod
    def get_Index(self: win32more.Windows.Devices.Lights.ILampInfo) -> Int32: ...
    @winrt_mixinmethod
    def get_Purposes(self: win32more.Windows.Devices.Lights.ILampInfo) -> win32more.Windows.Devices.Lights.LampPurposes: ...
    @winrt_mixinmethod
    def get_Position(self: win32more.Windows.Devices.Lights.ILampInfo) -> win32more.Windows.Foundation.Numerics.Vector3: ...
    @winrt_mixinmethod
    def get_RedLevelCount(self: win32more.Windows.Devices.Lights.ILampInfo) -> Int32: ...
    @winrt_mixinmethod
    def get_GreenLevelCount(self: win32more.Windows.Devices.Lights.ILampInfo) -> Int32: ...
    @winrt_mixinmethod
    def get_BlueLevelCount(self: win32more.Windows.Devices.Lights.ILampInfo) -> Int32: ...
    @winrt_mixinmethod
    def get_GainLevelCount(self: win32more.Windows.Devices.Lights.ILampInfo) -> Int32: ...
    @winrt_mixinmethod
    def get_FixedColor(self: win32more.Windows.Devices.Lights.ILampInfo) -> win32more.Windows.Foundation.IReference[win32more.Windows.UI.Color]: ...
    @winrt_mixinmethod
    def GetNearestSupportedColor(self: win32more.Windows.Devices.Lights.ILampInfo, desiredColor: win32more.Windows.UI.Color) -> win32more.Windows.UI.Color: ...
    @winrt_mixinmethod
    def get_UpdateLatency(self: win32more.Windows.Devices.Lights.ILampInfo) -> win32more.Windows.Foundation.TimeSpan: ...
    BlueLevelCount = property(get_BlueLevelCount, None)
    FixedColor = property(get_FixedColor, None)
    GainLevelCount = property(get_GainLevelCount, None)
    GreenLevelCount = property(get_GreenLevelCount, None)
    Index = property(get_Index, None)
    Position = property(get_Position, None)
    Purposes = property(get_Purposes, None)
    RedLevelCount = property(get_RedLevelCount, None)
    UpdateLatency = property(get_UpdateLatency, None)
class LampPurposes(Enum, UInt32):
    Undefined = 0
    Control = 1
    Accent = 2
    Branding = 4
    Status = 8
    Illumination = 16
    Presentation = 32


make_ready(__name__)
