from __future__ import annotations
from win32more.winrt.prelude import *
import win32more.Windows.Devices.Scanners
import win32more.Windows.Foundation
import win32more.Windows.Foundation.Collections
import win32more.Windows.Graphics.Printing
import win32more.Windows.Storage
import win32more.Windows.Storage.Streams
class IImageScanner(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Devices.Scanners.IImageScanner'
    _iid_ = Guid('{53a88f78-5298-48a0-8da3-8087519665e0}')
    @winrt_commethod(6)
    def get_DeviceId(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def get_DefaultScanSource(self) -> win32more.Windows.Devices.Scanners.ImageScannerScanSource: ...
    @winrt_commethod(8)
    def IsScanSourceSupported(self, value: win32more.Windows.Devices.Scanners.ImageScannerScanSource) -> Boolean: ...
    @winrt_commethod(9)
    def get_FlatbedConfiguration(self) -> win32more.Windows.Devices.Scanners.ImageScannerFlatbedConfiguration: ...
    @winrt_commethod(10)
    def get_FeederConfiguration(self) -> win32more.Windows.Devices.Scanners.ImageScannerFeederConfiguration: ...
    @winrt_commethod(11)
    def get_AutoConfiguration(self) -> win32more.Windows.Devices.Scanners.ImageScannerAutoConfiguration: ...
    @winrt_commethod(12)
    def IsPreviewSupported(self, scanSource: win32more.Windows.Devices.Scanners.ImageScannerScanSource) -> Boolean: ...
    @winrt_commethod(13)
    def ScanPreviewToStreamAsync(self, scanSource: win32more.Windows.Devices.Scanners.ImageScannerScanSource, targetStream: win32more.Windows.Storage.Streams.IRandomAccessStream) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Devices.Scanners.ImageScannerPreviewResult]: ...
    @winrt_commethod(14)
    def ScanFilesToFolderAsync(self, scanSource: win32more.Windows.Devices.Scanners.ImageScannerScanSource, storageFolder: win32more.Windows.Storage.StorageFolder) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Devices.Scanners.ImageScannerScanResult, UInt32]: ...
    AutoConfiguration = property(get_AutoConfiguration, None)
    DefaultScanSource = property(get_DefaultScanSource, None)
    DeviceId = property(get_DeviceId, None)
    FeederConfiguration = property(get_FeederConfiguration, None)
    FlatbedConfiguration = property(get_FlatbedConfiguration, None)
class IImageScannerFeederConfiguration(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Devices.Scanners.IImageScannerFeederConfiguration'
    _iid_ = Guid('{74bdacee-fa97-4c17-8280-40e39c6dcc67}')
    @winrt_commethod(6)
    def get_CanAutoDetectPageSize(self) -> Boolean: ...
    @winrt_commethod(7)
    def get_AutoDetectPageSize(self) -> Boolean: ...
    @winrt_commethod(8)
    def put_AutoDetectPageSize(self, value: Boolean) -> Void: ...
    @winrt_commethod(9)
    def get_PageSize(self) -> win32more.Windows.Graphics.Printing.PrintMediaSize: ...
    @winrt_commethod(10)
    def put_PageSize(self, value: win32more.Windows.Graphics.Printing.PrintMediaSize) -> Void: ...
    @winrt_commethod(11)
    def get_PageOrientation(self) -> win32more.Windows.Graphics.Printing.PrintOrientation: ...
    @winrt_commethod(12)
    def put_PageOrientation(self, value: win32more.Windows.Graphics.Printing.PrintOrientation) -> Void: ...
    @winrt_commethod(13)
    def get_PageSizeDimensions(self) -> win32more.Windows.Foundation.Size: ...
    @winrt_commethod(14)
    def IsPageSizeSupported(self, pageSize: win32more.Windows.Graphics.Printing.PrintMediaSize, pageOrientation: win32more.Windows.Graphics.Printing.PrintOrientation) -> Boolean: ...
    @winrt_commethod(15)
    def get_MaxNumberOfPages(self) -> UInt32: ...
    @winrt_commethod(16)
    def put_MaxNumberOfPages(self, value: UInt32) -> Void: ...
    @winrt_commethod(17)
    def get_CanScanDuplex(self) -> Boolean: ...
    @winrt_commethod(18)
    def get_Duplex(self) -> Boolean: ...
    @winrt_commethod(19)
    def put_Duplex(self, value: Boolean) -> Void: ...
    @winrt_commethod(20)
    def get_CanScanAhead(self) -> Boolean: ...
    @winrt_commethod(21)
    def get_ScanAhead(self) -> Boolean: ...
    @winrt_commethod(22)
    def put_ScanAhead(self, value: Boolean) -> Void: ...
    AutoDetectPageSize = property(get_AutoDetectPageSize, put_AutoDetectPageSize)
    CanAutoDetectPageSize = property(get_CanAutoDetectPageSize, None)
    CanScanAhead = property(get_CanScanAhead, None)
    CanScanDuplex = property(get_CanScanDuplex, None)
    Duplex = property(get_Duplex, put_Duplex)
    MaxNumberOfPages = property(get_MaxNumberOfPages, put_MaxNumberOfPages)
    PageOrientation = property(get_PageOrientation, put_PageOrientation)
    PageSize = property(get_PageSize, put_PageSize)
    PageSizeDimensions = property(get_PageSizeDimensions, None)
    ScanAhead = property(get_ScanAhead, put_ScanAhead)
class IImageScannerFormatConfiguration(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Devices.Scanners.IImageScannerFormatConfiguration'
    _iid_ = Guid('{ae275d11-dadf-4010-bf10-cca5c83dcbb0}')
    @winrt_commethod(6)
    def get_DefaultFormat(self) -> win32more.Windows.Devices.Scanners.ImageScannerFormat: ...
    @winrt_commethod(7)
    def get_Format(self) -> win32more.Windows.Devices.Scanners.ImageScannerFormat: ...
    @winrt_commethod(8)
    def put_Format(self, value: win32more.Windows.Devices.Scanners.ImageScannerFormat) -> Void: ...
    @winrt_commethod(9)
    def IsFormatSupported(self, value: win32more.Windows.Devices.Scanners.ImageScannerFormat) -> Boolean: ...
    DefaultFormat = property(get_DefaultFormat, None)
    Format = property(get_Format, put_Format)
class IImageScannerPreviewResult(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Devices.Scanners.IImageScannerPreviewResult'
    _iid_ = Guid('{08b7fe8e-8891-441d-be9c-176fa109c8bb}')
    @winrt_commethod(6)
    def get_Succeeded(self) -> Boolean: ...
    @winrt_commethod(7)
    def get_Format(self) -> win32more.Windows.Devices.Scanners.ImageScannerFormat: ...
    Format = property(get_Format, None)
    Succeeded = property(get_Succeeded, None)
class IImageScannerScanResult(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Devices.Scanners.IImageScannerScanResult'
    _iid_ = Guid('{c91624cd-9037-4e48-84c1-ac0975076bc5}')
    @winrt_commethod(6)
    def get_ScannedFiles(self) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Storage.StorageFile]: ...
    ScannedFiles = property(get_ScannedFiles, None)
class IImageScannerSourceConfiguration(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Devices.Scanners.IImageScannerSourceConfiguration'
    _iid_ = Guid('{bfb50055-0b44-4c82-9e89-205f9c234e59}')
    @winrt_commethod(6)
    def get_MinScanArea(self) -> win32more.Windows.Foundation.Size: ...
    @winrt_commethod(7)
    def get_MaxScanArea(self) -> win32more.Windows.Foundation.Size: ...
    @winrt_commethod(8)
    def get_SelectedScanRegion(self) -> win32more.Windows.Foundation.Rect: ...
    @winrt_commethod(9)
    def put_SelectedScanRegion(self, value: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_commethod(10)
    def get_AutoCroppingMode(self) -> win32more.Windows.Devices.Scanners.ImageScannerAutoCroppingMode: ...
    @winrt_commethod(11)
    def put_AutoCroppingMode(self, value: win32more.Windows.Devices.Scanners.ImageScannerAutoCroppingMode) -> Void: ...
    @winrt_commethod(12)
    def IsAutoCroppingModeSupported(self, value: win32more.Windows.Devices.Scanners.ImageScannerAutoCroppingMode) -> Boolean: ...
    @winrt_commethod(13)
    def get_MinResolution(self) -> win32more.Windows.Devices.Scanners.ImageScannerResolution: ...
    @winrt_commethod(14)
    def get_MaxResolution(self) -> win32more.Windows.Devices.Scanners.ImageScannerResolution: ...
    @winrt_commethod(15)
    def get_OpticalResolution(self) -> win32more.Windows.Devices.Scanners.ImageScannerResolution: ...
    @winrt_commethod(16)
    def get_DesiredResolution(self) -> win32more.Windows.Devices.Scanners.ImageScannerResolution: ...
    @winrt_commethod(17)
    def put_DesiredResolution(self, value: win32more.Windows.Devices.Scanners.ImageScannerResolution) -> Void: ...
    @winrt_commethod(18)
    def get_ActualResolution(self) -> win32more.Windows.Devices.Scanners.ImageScannerResolution: ...
    @winrt_commethod(19)
    def get_DefaultColorMode(self) -> win32more.Windows.Devices.Scanners.ImageScannerColorMode: ...
    @winrt_commethod(20)
    def get_ColorMode(self) -> win32more.Windows.Devices.Scanners.ImageScannerColorMode: ...
    @winrt_commethod(21)
    def put_ColorMode(self, value: win32more.Windows.Devices.Scanners.ImageScannerColorMode) -> Void: ...
    @winrt_commethod(22)
    def IsColorModeSupported(self, value: win32more.Windows.Devices.Scanners.ImageScannerColorMode) -> Boolean: ...
    @winrt_commethod(23)
    def get_MinBrightness(self) -> Int32: ...
    @winrt_commethod(24)
    def get_MaxBrightness(self) -> Int32: ...
    @winrt_commethod(25)
    def get_BrightnessStep(self) -> UInt32: ...
    @winrt_commethod(26)
    def get_DefaultBrightness(self) -> Int32: ...
    @winrt_commethod(27)
    def get_Brightness(self) -> Int32: ...
    @winrt_commethod(28)
    def put_Brightness(self, value: Int32) -> Void: ...
    @winrt_commethod(29)
    def get_MinContrast(self) -> Int32: ...
    @winrt_commethod(30)
    def get_MaxContrast(self) -> Int32: ...
    @winrt_commethod(31)
    def get_ContrastStep(self) -> UInt32: ...
    @winrt_commethod(32)
    def get_DefaultContrast(self) -> Int32: ...
    @winrt_commethod(33)
    def get_Contrast(self) -> Int32: ...
    @winrt_commethod(34)
    def put_Contrast(self, value: Int32) -> Void: ...
    ActualResolution = property(get_ActualResolution, None)
    AutoCroppingMode = property(get_AutoCroppingMode, put_AutoCroppingMode)
    Brightness = property(get_Brightness, put_Brightness)
    BrightnessStep = property(get_BrightnessStep, None)
    ColorMode = property(get_ColorMode, put_ColorMode)
    Contrast = property(get_Contrast, put_Contrast)
    ContrastStep = property(get_ContrastStep, None)
    DefaultBrightness = property(get_DefaultBrightness, None)
    DefaultColorMode = property(get_DefaultColorMode, None)
    DefaultContrast = property(get_DefaultContrast, None)
    DesiredResolution = property(get_DesiredResolution, put_DesiredResolution)
    MaxBrightness = property(get_MaxBrightness, None)
    MaxContrast = property(get_MaxContrast, None)
    MaxResolution = property(get_MaxResolution, None)
    MaxScanArea = property(get_MaxScanArea, None)
    MinBrightness = property(get_MinBrightness, None)
    MinContrast = property(get_MinContrast, None)
    MinResolution = property(get_MinResolution, None)
    MinScanArea = property(get_MinScanArea, None)
    OpticalResolution = property(get_OpticalResolution, None)
    SelectedScanRegion = property(get_SelectedScanRegion, put_SelectedScanRegion)
class IImageScannerStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Devices.Scanners.IImageScannerStatics'
    _iid_ = Guid('{bc57e70e-d804-4477-9fb5-b911b5473897}')
    @winrt_commethod(6)
    def FromIdAsync(self, deviceId: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Devices.Scanners.ImageScanner]: ...
    @winrt_commethod(7)
    def GetDeviceSelector(self) -> WinRT_String: ...
class ImageScanner(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Devices.Scanners.IImageScanner
    _classid_ = 'Windows.Devices.Scanners.ImageScanner'
    @winrt_mixinmethod
    def get_DeviceId(self: win32more.Windows.Devices.Scanners.IImageScanner) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_DefaultScanSource(self: win32more.Windows.Devices.Scanners.IImageScanner) -> win32more.Windows.Devices.Scanners.ImageScannerScanSource: ...
    @winrt_mixinmethod
    def IsScanSourceSupported(self: win32more.Windows.Devices.Scanners.IImageScanner, value: win32more.Windows.Devices.Scanners.ImageScannerScanSource) -> Boolean: ...
    @winrt_mixinmethod
    def get_FlatbedConfiguration(self: win32more.Windows.Devices.Scanners.IImageScanner) -> win32more.Windows.Devices.Scanners.ImageScannerFlatbedConfiguration: ...
    @winrt_mixinmethod
    def get_FeederConfiguration(self: win32more.Windows.Devices.Scanners.IImageScanner) -> win32more.Windows.Devices.Scanners.ImageScannerFeederConfiguration: ...
    @winrt_mixinmethod
    def get_AutoConfiguration(self: win32more.Windows.Devices.Scanners.IImageScanner) -> win32more.Windows.Devices.Scanners.ImageScannerAutoConfiguration: ...
    @winrt_mixinmethod
    def IsPreviewSupported(self: win32more.Windows.Devices.Scanners.IImageScanner, scanSource: win32more.Windows.Devices.Scanners.ImageScannerScanSource) -> Boolean: ...
    @winrt_mixinmethod
    def ScanPreviewToStreamAsync(self: win32more.Windows.Devices.Scanners.IImageScanner, scanSource: win32more.Windows.Devices.Scanners.ImageScannerScanSource, targetStream: win32more.Windows.Storage.Streams.IRandomAccessStream) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Devices.Scanners.ImageScannerPreviewResult]: ...
    @winrt_mixinmethod
    def ScanFilesToFolderAsync(self: win32more.Windows.Devices.Scanners.IImageScanner, scanSource: win32more.Windows.Devices.Scanners.ImageScannerScanSource, storageFolder: win32more.Windows.Storage.StorageFolder) -> win32more.Windows.Foundation.IAsyncOperationWithProgress[win32more.Windows.Devices.Scanners.ImageScannerScanResult, UInt32]: ...
    @winrt_classmethod
    def FromIdAsync(cls: win32more.Windows.Devices.Scanners.IImageScannerStatics, deviceId: WinRT_String) -> win32more.Windows.Foundation.IAsyncOperation[win32more.Windows.Devices.Scanners.ImageScanner]: ...
    @winrt_classmethod
    def GetDeviceSelector(cls: win32more.Windows.Devices.Scanners.IImageScannerStatics) -> WinRT_String: ...
    AutoConfiguration = property(get_AutoConfiguration, None)
    DefaultScanSource = property(get_DefaultScanSource, None)
    DeviceId = property(get_DeviceId, None)
    FeederConfiguration = property(get_FeederConfiguration, None)
    FlatbedConfiguration = property(get_FlatbedConfiguration, None)
class ImageScannerAutoConfiguration(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Devices.Scanners.IImageScannerFormatConfiguration
    _classid_ = 'Windows.Devices.Scanners.ImageScannerAutoConfiguration'
    @winrt_mixinmethod
    def get_DefaultFormat(self: win32more.Windows.Devices.Scanners.IImageScannerFormatConfiguration) -> win32more.Windows.Devices.Scanners.ImageScannerFormat: ...
    @winrt_mixinmethod
    def get_Format(self: win32more.Windows.Devices.Scanners.IImageScannerFormatConfiguration) -> win32more.Windows.Devices.Scanners.ImageScannerFormat: ...
    @winrt_mixinmethod
    def put_Format(self: win32more.Windows.Devices.Scanners.IImageScannerFormatConfiguration, value: win32more.Windows.Devices.Scanners.ImageScannerFormat) -> Void: ...
    @winrt_mixinmethod
    def IsFormatSupported(self: win32more.Windows.Devices.Scanners.IImageScannerFormatConfiguration, value: win32more.Windows.Devices.Scanners.ImageScannerFormat) -> Boolean: ...
    DefaultFormat = property(get_DefaultFormat, None)
    Format = property(get_Format, put_Format)
class ImageScannerAutoCroppingMode(Enum, Int32):
    Disabled = 0
    SingleRegion = 1
    MultipleRegion = 2
class ImageScannerColorMode(Enum, Int32):
    Color = 0
    Grayscale = 1
    Monochrome = 2
    AutoColor = 3
class ImageScannerFeederConfiguration(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Devices.Scanners.IImageScannerFormatConfiguration
    _classid_ = 'Windows.Devices.Scanners.ImageScannerFeederConfiguration'
    @winrt_mixinmethod
    def get_DefaultFormat(self: win32more.Windows.Devices.Scanners.IImageScannerFormatConfiguration) -> win32more.Windows.Devices.Scanners.ImageScannerFormat: ...
    @winrt_mixinmethod
    def get_Format(self: win32more.Windows.Devices.Scanners.IImageScannerFormatConfiguration) -> win32more.Windows.Devices.Scanners.ImageScannerFormat: ...
    @winrt_mixinmethod
    def put_Format(self: win32more.Windows.Devices.Scanners.IImageScannerFormatConfiguration, value: win32more.Windows.Devices.Scanners.ImageScannerFormat) -> Void: ...
    @winrt_mixinmethod
    def IsFormatSupported(self: win32more.Windows.Devices.Scanners.IImageScannerFormatConfiguration, value: win32more.Windows.Devices.Scanners.ImageScannerFormat) -> Boolean: ...
    @winrt_mixinmethod
    def get_MinScanArea(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> win32more.Windows.Foundation.Size: ...
    @winrt_mixinmethod
    def get_MaxScanArea(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> win32more.Windows.Foundation.Size: ...
    @winrt_mixinmethod
    def get_SelectedScanRegion(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def put_SelectedScanRegion(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration, value: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def get_AutoCroppingMode(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> win32more.Windows.Devices.Scanners.ImageScannerAutoCroppingMode: ...
    @winrt_mixinmethod
    def put_AutoCroppingMode(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration, value: win32more.Windows.Devices.Scanners.ImageScannerAutoCroppingMode) -> Void: ...
    @winrt_mixinmethod
    def IsAutoCroppingModeSupported(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration, value: win32more.Windows.Devices.Scanners.ImageScannerAutoCroppingMode) -> Boolean: ...
    @winrt_mixinmethod
    def get_MinResolution(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> win32more.Windows.Devices.Scanners.ImageScannerResolution: ...
    @winrt_mixinmethod
    def get_MaxResolution(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> win32more.Windows.Devices.Scanners.ImageScannerResolution: ...
    @winrt_mixinmethod
    def get_OpticalResolution(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> win32more.Windows.Devices.Scanners.ImageScannerResolution: ...
    @winrt_mixinmethod
    def get_DesiredResolution(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> win32more.Windows.Devices.Scanners.ImageScannerResolution: ...
    @winrt_mixinmethod
    def put_DesiredResolution(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration, value: win32more.Windows.Devices.Scanners.ImageScannerResolution) -> Void: ...
    @winrt_mixinmethod
    def get_ActualResolution(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> win32more.Windows.Devices.Scanners.ImageScannerResolution: ...
    @winrt_mixinmethod
    def get_DefaultColorMode(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> win32more.Windows.Devices.Scanners.ImageScannerColorMode: ...
    @winrt_mixinmethod
    def get_ColorMode(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> win32more.Windows.Devices.Scanners.ImageScannerColorMode: ...
    @winrt_mixinmethod
    def put_ColorMode(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration, value: win32more.Windows.Devices.Scanners.ImageScannerColorMode) -> Void: ...
    @winrt_mixinmethod
    def IsColorModeSupported(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration, value: win32more.Windows.Devices.Scanners.ImageScannerColorMode) -> Boolean: ...
    @winrt_mixinmethod
    def get_MinBrightness(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> Int32: ...
    @winrt_mixinmethod
    def get_MaxBrightness(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> Int32: ...
    @winrt_mixinmethod
    def get_BrightnessStep(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> UInt32: ...
    @winrt_mixinmethod
    def get_DefaultBrightness(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> Int32: ...
    @winrt_mixinmethod
    def get_Brightness(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> Int32: ...
    @winrt_mixinmethod
    def put_Brightness(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration, value: Int32) -> Void: ...
    @winrt_mixinmethod
    def get_MinContrast(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> Int32: ...
    @winrt_mixinmethod
    def get_MaxContrast(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> Int32: ...
    @winrt_mixinmethod
    def get_ContrastStep(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> UInt32: ...
    @winrt_mixinmethod
    def get_DefaultContrast(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> Int32: ...
    @winrt_mixinmethod
    def get_Contrast(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> Int32: ...
    @winrt_mixinmethod
    def put_Contrast(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration, value: Int32) -> Void: ...
    @winrt_mixinmethod
    def get_CanAutoDetectPageSize(self: win32more.Windows.Devices.Scanners.IImageScannerFeederConfiguration) -> Boolean: ...
    @winrt_mixinmethod
    def get_AutoDetectPageSize(self: win32more.Windows.Devices.Scanners.IImageScannerFeederConfiguration) -> Boolean: ...
    @winrt_mixinmethod
    def put_AutoDetectPageSize(self: win32more.Windows.Devices.Scanners.IImageScannerFeederConfiguration, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_PageSize(self: win32more.Windows.Devices.Scanners.IImageScannerFeederConfiguration) -> win32more.Windows.Graphics.Printing.PrintMediaSize: ...
    @winrt_mixinmethod
    def put_PageSize(self: win32more.Windows.Devices.Scanners.IImageScannerFeederConfiguration, value: win32more.Windows.Graphics.Printing.PrintMediaSize) -> Void: ...
    @winrt_mixinmethod
    def get_PageOrientation(self: win32more.Windows.Devices.Scanners.IImageScannerFeederConfiguration) -> win32more.Windows.Graphics.Printing.PrintOrientation: ...
    @winrt_mixinmethod
    def put_PageOrientation(self: win32more.Windows.Devices.Scanners.IImageScannerFeederConfiguration, value: win32more.Windows.Graphics.Printing.PrintOrientation) -> Void: ...
    @winrt_mixinmethod
    def get_PageSizeDimensions(self: win32more.Windows.Devices.Scanners.IImageScannerFeederConfiguration) -> win32more.Windows.Foundation.Size: ...
    @winrt_mixinmethod
    def IsPageSizeSupported(self: win32more.Windows.Devices.Scanners.IImageScannerFeederConfiguration, pageSize: win32more.Windows.Graphics.Printing.PrintMediaSize, pageOrientation: win32more.Windows.Graphics.Printing.PrintOrientation) -> Boolean: ...
    @winrt_mixinmethod
    def get_MaxNumberOfPages(self: win32more.Windows.Devices.Scanners.IImageScannerFeederConfiguration) -> UInt32: ...
    @winrt_mixinmethod
    def put_MaxNumberOfPages(self: win32more.Windows.Devices.Scanners.IImageScannerFeederConfiguration, value: UInt32) -> Void: ...
    @winrt_mixinmethod
    def get_CanScanDuplex(self: win32more.Windows.Devices.Scanners.IImageScannerFeederConfiguration) -> Boolean: ...
    @winrt_mixinmethod
    def get_Duplex(self: win32more.Windows.Devices.Scanners.IImageScannerFeederConfiguration) -> Boolean: ...
    @winrt_mixinmethod
    def put_Duplex(self: win32more.Windows.Devices.Scanners.IImageScannerFeederConfiguration, value: Boolean) -> Void: ...
    @winrt_mixinmethod
    def get_CanScanAhead(self: win32more.Windows.Devices.Scanners.IImageScannerFeederConfiguration) -> Boolean: ...
    @winrt_mixinmethod
    def get_ScanAhead(self: win32more.Windows.Devices.Scanners.IImageScannerFeederConfiguration) -> Boolean: ...
    @winrt_mixinmethod
    def put_ScanAhead(self: win32more.Windows.Devices.Scanners.IImageScannerFeederConfiguration, value: Boolean) -> Void: ...
    ActualResolution = property(get_ActualResolution, None)
    AutoCroppingMode = property(get_AutoCroppingMode, put_AutoCroppingMode)
    AutoDetectPageSize = property(get_AutoDetectPageSize, put_AutoDetectPageSize)
    Brightness = property(get_Brightness, put_Brightness)
    BrightnessStep = property(get_BrightnessStep, None)
    CanAutoDetectPageSize = property(get_CanAutoDetectPageSize, None)
    CanScanAhead = property(get_CanScanAhead, None)
    CanScanDuplex = property(get_CanScanDuplex, None)
    ColorMode = property(get_ColorMode, put_ColorMode)
    Contrast = property(get_Contrast, put_Contrast)
    ContrastStep = property(get_ContrastStep, None)
    DefaultBrightness = property(get_DefaultBrightness, None)
    DefaultColorMode = property(get_DefaultColorMode, None)
    DefaultContrast = property(get_DefaultContrast, None)
    DefaultFormat = property(get_DefaultFormat, None)
    DesiredResolution = property(get_DesiredResolution, put_DesiredResolution)
    Duplex = property(get_Duplex, put_Duplex)
    Format = property(get_Format, put_Format)
    MaxBrightness = property(get_MaxBrightness, None)
    MaxContrast = property(get_MaxContrast, None)
    MaxNumberOfPages = property(get_MaxNumberOfPages, put_MaxNumberOfPages)
    MaxResolution = property(get_MaxResolution, None)
    MaxScanArea = property(get_MaxScanArea, None)
    MinBrightness = property(get_MinBrightness, None)
    MinContrast = property(get_MinContrast, None)
    MinResolution = property(get_MinResolution, None)
    MinScanArea = property(get_MinScanArea, None)
    OpticalResolution = property(get_OpticalResolution, None)
    PageOrientation = property(get_PageOrientation, put_PageOrientation)
    PageSize = property(get_PageSize, put_PageSize)
    PageSizeDimensions = property(get_PageSizeDimensions, None)
    ScanAhead = property(get_ScanAhead, put_ScanAhead)
    SelectedScanRegion = property(get_SelectedScanRegion, put_SelectedScanRegion)
class ImageScannerFlatbedConfiguration(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Devices.Scanners.IImageScannerFormatConfiguration
    _classid_ = 'Windows.Devices.Scanners.ImageScannerFlatbedConfiguration'
    @winrt_mixinmethod
    def get_DefaultFormat(self: win32more.Windows.Devices.Scanners.IImageScannerFormatConfiguration) -> win32more.Windows.Devices.Scanners.ImageScannerFormat: ...
    @winrt_mixinmethod
    def get_Format(self: win32more.Windows.Devices.Scanners.IImageScannerFormatConfiguration) -> win32more.Windows.Devices.Scanners.ImageScannerFormat: ...
    @winrt_mixinmethod
    def put_Format(self: win32more.Windows.Devices.Scanners.IImageScannerFormatConfiguration, value: win32more.Windows.Devices.Scanners.ImageScannerFormat) -> Void: ...
    @winrt_mixinmethod
    def IsFormatSupported(self: win32more.Windows.Devices.Scanners.IImageScannerFormatConfiguration, value: win32more.Windows.Devices.Scanners.ImageScannerFormat) -> Boolean: ...
    @winrt_mixinmethod
    def get_MinScanArea(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> win32more.Windows.Foundation.Size: ...
    @winrt_mixinmethod
    def get_MaxScanArea(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> win32more.Windows.Foundation.Size: ...
    @winrt_mixinmethod
    def get_SelectedScanRegion(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> win32more.Windows.Foundation.Rect: ...
    @winrt_mixinmethod
    def put_SelectedScanRegion(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration, value: win32more.Windows.Foundation.Rect) -> Void: ...
    @winrt_mixinmethod
    def get_AutoCroppingMode(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> win32more.Windows.Devices.Scanners.ImageScannerAutoCroppingMode: ...
    @winrt_mixinmethod
    def put_AutoCroppingMode(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration, value: win32more.Windows.Devices.Scanners.ImageScannerAutoCroppingMode) -> Void: ...
    @winrt_mixinmethod
    def IsAutoCroppingModeSupported(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration, value: win32more.Windows.Devices.Scanners.ImageScannerAutoCroppingMode) -> Boolean: ...
    @winrt_mixinmethod
    def get_MinResolution(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> win32more.Windows.Devices.Scanners.ImageScannerResolution: ...
    @winrt_mixinmethod
    def get_MaxResolution(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> win32more.Windows.Devices.Scanners.ImageScannerResolution: ...
    @winrt_mixinmethod
    def get_OpticalResolution(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> win32more.Windows.Devices.Scanners.ImageScannerResolution: ...
    @winrt_mixinmethod
    def get_DesiredResolution(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> win32more.Windows.Devices.Scanners.ImageScannerResolution: ...
    @winrt_mixinmethod
    def put_DesiredResolution(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration, value: win32more.Windows.Devices.Scanners.ImageScannerResolution) -> Void: ...
    @winrt_mixinmethod
    def get_ActualResolution(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> win32more.Windows.Devices.Scanners.ImageScannerResolution: ...
    @winrt_mixinmethod
    def get_DefaultColorMode(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> win32more.Windows.Devices.Scanners.ImageScannerColorMode: ...
    @winrt_mixinmethod
    def get_ColorMode(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> win32more.Windows.Devices.Scanners.ImageScannerColorMode: ...
    @winrt_mixinmethod
    def put_ColorMode(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration, value: win32more.Windows.Devices.Scanners.ImageScannerColorMode) -> Void: ...
    @winrt_mixinmethod
    def IsColorModeSupported(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration, value: win32more.Windows.Devices.Scanners.ImageScannerColorMode) -> Boolean: ...
    @winrt_mixinmethod
    def get_MinBrightness(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> Int32: ...
    @winrt_mixinmethod
    def get_MaxBrightness(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> Int32: ...
    @winrt_mixinmethod
    def get_BrightnessStep(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> UInt32: ...
    @winrt_mixinmethod
    def get_DefaultBrightness(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> Int32: ...
    @winrt_mixinmethod
    def get_Brightness(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> Int32: ...
    @winrt_mixinmethod
    def put_Brightness(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration, value: Int32) -> Void: ...
    @winrt_mixinmethod
    def get_MinContrast(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> Int32: ...
    @winrt_mixinmethod
    def get_MaxContrast(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> Int32: ...
    @winrt_mixinmethod
    def get_ContrastStep(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> UInt32: ...
    @winrt_mixinmethod
    def get_DefaultContrast(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> Int32: ...
    @winrt_mixinmethod
    def get_Contrast(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration) -> Int32: ...
    @winrt_mixinmethod
    def put_Contrast(self: win32more.Windows.Devices.Scanners.IImageScannerSourceConfiguration, value: Int32) -> Void: ...
    ActualResolution = property(get_ActualResolution, None)
    AutoCroppingMode = property(get_AutoCroppingMode, put_AutoCroppingMode)
    Brightness = property(get_Brightness, put_Brightness)
    BrightnessStep = property(get_BrightnessStep, None)
    ColorMode = property(get_ColorMode, put_ColorMode)
    Contrast = property(get_Contrast, put_Contrast)
    ContrastStep = property(get_ContrastStep, None)
    DefaultBrightness = property(get_DefaultBrightness, None)
    DefaultColorMode = property(get_DefaultColorMode, None)
    DefaultContrast = property(get_DefaultContrast, None)
    DefaultFormat = property(get_DefaultFormat, None)
    DesiredResolution = property(get_DesiredResolution, put_DesiredResolution)
    Format = property(get_Format, put_Format)
    MaxBrightness = property(get_MaxBrightness, None)
    MaxContrast = property(get_MaxContrast, None)
    MaxResolution = property(get_MaxResolution, None)
    MaxScanArea = property(get_MaxScanArea, None)
    MinBrightness = property(get_MinBrightness, None)
    MinContrast = property(get_MinContrast, None)
    MinResolution = property(get_MinResolution, None)
    MinScanArea = property(get_MinScanArea, None)
    OpticalResolution = property(get_OpticalResolution, None)
    SelectedScanRegion = property(get_SelectedScanRegion, put_SelectedScanRegion)
class ImageScannerFormat(Enum, Int32):
    Jpeg = 0
    Png = 1
    DeviceIndependentBitmap = 2
    Tiff = 3
    Xps = 4
    OpenXps = 5
    Pdf = 6
class ImageScannerPreviewResult(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Devices.Scanners.IImageScannerPreviewResult
    _classid_ = 'Windows.Devices.Scanners.ImageScannerPreviewResult'
    @winrt_mixinmethod
    def get_Succeeded(self: win32more.Windows.Devices.Scanners.IImageScannerPreviewResult) -> Boolean: ...
    @winrt_mixinmethod
    def get_Format(self: win32more.Windows.Devices.Scanners.IImageScannerPreviewResult) -> win32more.Windows.Devices.Scanners.ImageScannerFormat: ...
    Format = property(get_Format, None)
    Succeeded = property(get_Succeeded, None)
class ImageScannerResolution(Structure):
    DpiX: Single
    DpiY: Single
class ImageScannerScanResult(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Devices.Scanners.IImageScannerScanResult
    _classid_ = 'Windows.Devices.Scanners.ImageScannerScanResult'
    @winrt_mixinmethod
    def get_ScannedFiles(self: win32more.Windows.Devices.Scanners.IImageScannerScanResult) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Storage.StorageFile]: ...
    ScannedFiles = property(get_ScannedFiles, None)
class ImageScannerScanSource(Enum, Int32):
    Default = 0
    Flatbed = 1
    Feeder = 2
    AutoConfigured = 3
ScannerDeviceContract: UInt32 = 65536


make_ready(__name__)
