from __future__ import annotations
from win32more.winrt.prelude import *
import win32more.Windows.Foundation
import win32more.Windows.Foundation.Collections
import win32more.Windows.Globalization
import win32more.Windows.System
class _ApplicationLanguages_Meta_(ComPtr.__class__):
    pass
class ApplicationLanguages(ComPtr, metaclass=_ApplicationLanguages_Meta_):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.ApplicationLanguages'
    @winrt_classmethod
    def GetLanguagesForUser(cls: win32more.Windows.Globalization.IApplicationLanguagesStatics2, user: win32more.Windows.System.User) -> win32more.Windows.Foundation.Collections.IVectorView[WinRT_String]: ...
    @winrt_classmethod
    def get_PrimaryLanguageOverride(cls: win32more.Windows.Globalization.IApplicationLanguagesStatics) -> WinRT_String: ...
    @winrt_classmethod
    def put_PrimaryLanguageOverride(cls: win32more.Windows.Globalization.IApplicationLanguagesStatics, value: WinRT_String) -> Void: ...
    @winrt_classmethod
    def get_Languages(cls: win32more.Windows.Globalization.IApplicationLanguagesStatics) -> win32more.Windows.Foundation.Collections.IVectorView[WinRT_String]: ...
    @winrt_classmethod
    def get_ManifestLanguages(cls: win32more.Windows.Globalization.IApplicationLanguagesStatics) -> win32more.Windows.Foundation.Collections.IVectorView[WinRT_String]: ...
    _ApplicationLanguages_Meta_.Languages = property(get_Languages, None)
    _ApplicationLanguages_Meta_.ManifestLanguages = property(get_ManifestLanguages, None)
    _ApplicationLanguages_Meta_.PrimaryLanguageOverride = property(get_PrimaryLanguageOverride, put_PrimaryLanguageOverride)
class Calendar(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Globalization.ICalendar
    _classid_ = 'Windows.Globalization.Calendar'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.Globalization.Calendar.CreateInstance(*args))
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Globalization.Calendar.CreateCalendarDefaultCalendarAndClock(*args))
        elif len(args) == 3:
            super().__init__(move=win32more.Windows.Globalization.Calendar.CreateCalendar(*args))
        elif len(args) == 4:
            super().__init__(move=win32more.Windows.Globalization.Calendar.CreateCalendarWithTimeZone(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.Globalization.Calendar: ...
    @winrt_factorymethod
    def CreateCalendarDefaultCalendarAndClock(cls: win32more.Windows.Globalization.ICalendarFactory, languages: win32more.Windows.Foundation.Collections.IIterable[WinRT_String]) -> win32more.Windows.Globalization.Calendar: ...
    @winrt_factorymethod
    def CreateCalendar(cls: win32more.Windows.Globalization.ICalendarFactory, languages: win32more.Windows.Foundation.Collections.IIterable[WinRT_String], calendar: WinRT_String, clock: WinRT_String) -> win32more.Windows.Globalization.Calendar: ...
    @winrt_factorymethod
    def CreateCalendarWithTimeZone(cls: win32more.Windows.Globalization.ICalendarFactory2, languages: win32more.Windows.Foundation.Collections.IIterable[WinRT_String], calendar: WinRT_String, clock: WinRT_String, timeZoneId: WinRT_String) -> win32more.Windows.Globalization.Calendar: ...
    @winrt_mixinmethod
    def Clone(self: win32more.Windows.Globalization.ICalendar) -> win32more.Windows.Globalization.Calendar: ...
    @winrt_mixinmethod
    def SetToMin(self: win32more.Windows.Globalization.ICalendar) -> Void: ...
    @winrt_mixinmethod
    def SetToMax(self: win32more.Windows.Globalization.ICalendar) -> Void: ...
    @winrt_mixinmethod
    def get_Languages(self: win32more.Windows.Globalization.ICalendar) -> win32more.Windows.Foundation.Collections.IVectorView[WinRT_String]: ...
    @winrt_mixinmethod
    def get_NumeralSystem(self: win32more.Windows.Globalization.ICalendar) -> WinRT_String: ...
    @winrt_mixinmethod
    def put_NumeralSystem(self: win32more.Windows.Globalization.ICalendar, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetCalendarSystem(self: win32more.Windows.Globalization.ICalendar) -> WinRT_String: ...
    @winrt_mixinmethod
    def ChangeCalendarSystem(self: win32more.Windows.Globalization.ICalendar, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetClock(self: win32more.Windows.Globalization.ICalendar) -> WinRT_String: ...
    @winrt_mixinmethod
    def ChangeClock(self: win32more.Windows.Globalization.ICalendar, value: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def GetDateTime(self: win32more.Windows.Globalization.ICalendar) -> win32more.Windows.Foundation.DateTime: ...
    @winrt_mixinmethod
    def SetDateTime(self: win32more.Windows.Globalization.ICalendar, value: win32more.Windows.Foundation.DateTime) -> Void: ...
    @winrt_mixinmethod
    def SetToNow(self: win32more.Windows.Globalization.ICalendar) -> Void: ...
    @winrt_mixinmethod
    def get_FirstEra(self: win32more.Windows.Globalization.ICalendar) -> Int32: ...
    @winrt_mixinmethod
    def get_LastEra(self: win32more.Windows.Globalization.ICalendar) -> Int32: ...
    @winrt_mixinmethod
    def get_NumberOfEras(self: win32more.Windows.Globalization.ICalendar) -> Int32: ...
    @winrt_mixinmethod
    def get_Era(self: win32more.Windows.Globalization.ICalendar) -> Int32: ...
    @winrt_mixinmethod
    def put_Era(self: win32more.Windows.Globalization.ICalendar, value: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddEras(self: win32more.Windows.Globalization.ICalendar, eras: Int32) -> Void: ...
    @winrt_mixinmethod
    def EraAsFullString(self: win32more.Windows.Globalization.ICalendar) -> WinRT_String: ...
    @winrt_mixinmethod
    def EraAsString(self: win32more.Windows.Globalization.ICalendar, idealLength: Int32) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_FirstYearInThisEra(self: win32more.Windows.Globalization.ICalendar) -> Int32: ...
    @winrt_mixinmethod
    def get_LastYearInThisEra(self: win32more.Windows.Globalization.ICalendar) -> Int32: ...
    @winrt_mixinmethod
    def get_NumberOfYearsInThisEra(self: win32more.Windows.Globalization.ICalendar) -> Int32: ...
    @winrt_mixinmethod
    def get_Year(self: win32more.Windows.Globalization.ICalendar) -> Int32: ...
    @winrt_mixinmethod
    def put_Year(self: win32more.Windows.Globalization.ICalendar, value: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddYears(self: win32more.Windows.Globalization.ICalendar, years: Int32) -> Void: ...
    @winrt_mixinmethod
    def YearAsString(self: win32more.Windows.Globalization.ICalendar) -> WinRT_String: ...
    @winrt_mixinmethod
    def YearAsTruncatedString(self: win32more.Windows.Globalization.ICalendar, remainingDigits: Int32) -> WinRT_String: ...
    @winrt_mixinmethod
    def YearAsPaddedString(self: win32more.Windows.Globalization.ICalendar, minDigits: Int32) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_FirstMonthInThisYear(self: win32more.Windows.Globalization.ICalendar) -> Int32: ...
    @winrt_mixinmethod
    def get_LastMonthInThisYear(self: win32more.Windows.Globalization.ICalendar) -> Int32: ...
    @winrt_mixinmethod
    def get_NumberOfMonthsInThisYear(self: win32more.Windows.Globalization.ICalendar) -> Int32: ...
    @winrt_mixinmethod
    def get_Month(self: win32more.Windows.Globalization.ICalendar) -> Int32: ...
    @winrt_mixinmethod
    def put_Month(self: win32more.Windows.Globalization.ICalendar, value: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddMonths(self: win32more.Windows.Globalization.ICalendar, months: Int32) -> Void: ...
    @winrt_mixinmethod
    def MonthAsFullString(self: win32more.Windows.Globalization.ICalendar) -> WinRT_String: ...
    @winrt_mixinmethod
    def MonthAsString(self: win32more.Windows.Globalization.ICalendar, idealLength: Int32) -> WinRT_String: ...
    @winrt_mixinmethod
    def MonthAsFullSoloString(self: win32more.Windows.Globalization.ICalendar) -> WinRT_String: ...
    @winrt_mixinmethod
    def MonthAsSoloString(self: win32more.Windows.Globalization.ICalendar, idealLength: Int32) -> WinRT_String: ...
    @winrt_mixinmethod
    def MonthAsNumericString(self: win32more.Windows.Globalization.ICalendar) -> WinRT_String: ...
    @winrt_mixinmethod
    def MonthAsPaddedNumericString(self: win32more.Windows.Globalization.ICalendar, minDigits: Int32) -> WinRT_String: ...
    @winrt_mixinmethod
    def AddWeeks(self: win32more.Windows.Globalization.ICalendar, weeks: Int32) -> Void: ...
    @winrt_mixinmethod
    def get_FirstDayInThisMonth(self: win32more.Windows.Globalization.ICalendar) -> Int32: ...
    @winrt_mixinmethod
    def get_LastDayInThisMonth(self: win32more.Windows.Globalization.ICalendar) -> Int32: ...
    @winrt_mixinmethod
    def get_NumberOfDaysInThisMonth(self: win32more.Windows.Globalization.ICalendar) -> Int32: ...
    @winrt_mixinmethod
    def get_Day(self: win32more.Windows.Globalization.ICalendar) -> Int32: ...
    @winrt_mixinmethod
    def put_Day(self: win32more.Windows.Globalization.ICalendar, value: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddDays(self: win32more.Windows.Globalization.ICalendar, days: Int32) -> Void: ...
    @winrt_mixinmethod
    def DayAsString(self: win32more.Windows.Globalization.ICalendar) -> WinRT_String: ...
    @winrt_mixinmethod
    def DayAsPaddedString(self: win32more.Windows.Globalization.ICalendar, minDigits: Int32) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_DayOfWeek(self: win32more.Windows.Globalization.ICalendar) -> win32more.Windows.Globalization.DayOfWeek: ...
    @winrt_mixinmethod
    def DayOfWeekAsFullString(self: win32more.Windows.Globalization.ICalendar) -> WinRT_String: ...
    @winrt_mixinmethod
    def DayOfWeekAsString(self: win32more.Windows.Globalization.ICalendar, idealLength: Int32) -> WinRT_String: ...
    @winrt_mixinmethod
    def DayOfWeekAsFullSoloString(self: win32more.Windows.Globalization.ICalendar) -> WinRT_String: ...
    @winrt_mixinmethod
    def DayOfWeekAsSoloString(self: win32more.Windows.Globalization.ICalendar, idealLength: Int32) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_FirstPeriodInThisDay(self: win32more.Windows.Globalization.ICalendar) -> Int32: ...
    @winrt_mixinmethod
    def get_LastPeriodInThisDay(self: win32more.Windows.Globalization.ICalendar) -> Int32: ...
    @winrt_mixinmethod
    def get_NumberOfPeriodsInThisDay(self: win32more.Windows.Globalization.ICalendar) -> Int32: ...
    @winrt_mixinmethod
    def get_Period(self: win32more.Windows.Globalization.ICalendar) -> Int32: ...
    @winrt_mixinmethod
    def put_Period(self: win32more.Windows.Globalization.ICalendar, value: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddPeriods(self: win32more.Windows.Globalization.ICalendar, periods: Int32) -> Void: ...
    @winrt_mixinmethod
    def PeriodAsFullString(self: win32more.Windows.Globalization.ICalendar) -> WinRT_String: ...
    @winrt_mixinmethod
    def PeriodAsString(self: win32more.Windows.Globalization.ICalendar, idealLength: Int32) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_FirstHourInThisPeriod(self: win32more.Windows.Globalization.ICalendar) -> Int32: ...
    @winrt_mixinmethod
    def get_LastHourInThisPeriod(self: win32more.Windows.Globalization.ICalendar) -> Int32: ...
    @winrt_mixinmethod
    def get_NumberOfHoursInThisPeriod(self: win32more.Windows.Globalization.ICalendar) -> Int32: ...
    @winrt_mixinmethod
    def get_Hour(self: win32more.Windows.Globalization.ICalendar) -> Int32: ...
    @winrt_mixinmethod
    def put_Hour(self: win32more.Windows.Globalization.ICalendar, value: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddHours(self: win32more.Windows.Globalization.ICalendar, hours: Int32) -> Void: ...
    @winrt_mixinmethod
    def HourAsString(self: win32more.Windows.Globalization.ICalendar) -> WinRT_String: ...
    @winrt_mixinmethod
    def HourAsPaddedString(self: win32more.Windows.Globalization.ICalendar, minDigits: Int32) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_Minute(self: win32more.Windows.Globalization.ICalendar) -> Int32: ...
    @winrt_mixinmethod
    def put_Minute(self: win32more.Windows.Globalization.ICalendar, value: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddMinutes(self: win32more.Windows.Globalization.ICalendar, minutes: Int32) -> Void: ...
    @winrt_mixinmethod
    def MinuteAsString(self: win32more.Windows.Globalization.ICalendar) -> WinRT_String: ...
    @winrt_mixinmethod
    def MinuteAsPaddedString(self: win32more.Windows.Globalization.ICalendar, minDigits: Int32) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_Second(self: win32more.Windows.Globalization.ICalendar) -> Int32: ...
    @winrt_mixinmethod
    def put_Second(self: win32more.Windows.Globalization.ICalendar, value: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddSeconds(self: win32more.Windows.Globalization.ICalendar, seconds: Int32) -> Void: ...
    @winrt_mixinmethod
    def SecondAsString(self: win32more.Windows.Globalization.ICalendar) -> WinRT_String: ...
    @winrt_mixinmethod
    def SecondAsPaddedString(self: win32more.Windows.Globalization.ICalendar, minDigits: Int32) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_Nanosecond(self: win32more.Windows.Globalization.ICalendar) -> Int32: ...
    @winrt_mixinmethod
    def put_Nanosecond(self: win32more.Windows.Globalization.ICalendar, value: Int32) -> Void: ...
    @winrt_mixinmethod
    def AddNanoseconds(self: win32more.Windows.Globalization.ICalendar, nanoseconds: Int32) -> Void: ...
    @winrt_mixinmethod
    def NanosecondAsString(self: win32more.Windows.Globalization.ICalendar) -> WinRT_String: ...
    @winrt_mixinmethod
    def NanosecondAsPaddedString(self: win32more.Windows.Globalization.ICalendar, minDigits: Int32) -> WinRT_String: ...
    @winrt_mixinmethod
    def Compare(self: win32more.Windows.Globalization.ICalendar, other: win32more.Windows.Globalization.Calendar) -> Int32: ...
    @winrt_mixinmethod
    def CompareDateTime(self: win32more.Windows.Globalization.ICalendar, other: win32more.Windows.Foundation.DateTime) -> Int32: ...
    @winrt_mixinmethod
    def CopyTo(self: win32more.Windows.Globalization.ICalendar, other: win32more.Windows.Globalization.Calendar) -> Void: ...
    @winrt_mixinmethod
    def get_FirstMinuteInThisHour(self: win32more.Windows.Globalization.ICalendar) -> Int32: ...
    @winrt_mixinmethod
    def get_LastMinuteInThisHour(self: win32more.Windows.Globalization.ICalendar) -> Int32: ...
    @winrt_mixinmethod
    def get_NumberOfMinutesInThisHour(self: win32more.Windows.Globalization.ICalendar) -> Int32: ...
    @winrt_mixinmethod
    def get_FirstSecondInThisMinute(self: win32more.Windows.Globalization.ICalendar) -> Int32: ...
    @winrt_mixinmethod
    def get_LastSecondInThisMinute(self: win32more.Windows.Globalization.ICalendar) -> Int32: ...
    @winrt_mixinmethod
    def get_NumberOfSecondsInThisMinute(self: win32more.Windows.Globalization.ICalendar) -> Int32: ...
    @winrt_mixinmethod
    def get_ResolvedLanguage(self: win32more.Windows.Globalization.ICalendar) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_IsDaylightSavingTime(self: win32more.Windows.Globalization.ICalendar) -> Boolean: ...
    @winrt_mixinmethod
    def GetTimeZone(self: win32more.Windows.Globalization.ITimeZoneOnCalendar) -> WinRT_String: ...
    @winrt_mixinmethod
    def ChangeTimeZone(self: win32more.Windows.Globalization.ITimeZoneOnCalendar, timeZoneId: WinRT_String) -> Void: ...
    @winrt_mixinmethod
    def TimeZoneAsFullString(self: win32more.Windows.Globalization.ITimeZoneOnCalendar) -> WinRT_String: ...
    @winrt_mixinmethod
    def TimeZoneAsString(self: win32more.Windows.Globalization.ITimeZoneOnCalendar, idealLength: Int32) -> WinRT_String: ...
    Day = property(get_Day, put_Day)
    DayOfWeek = property(get_DayOfWeek, None)
    Era = property(get_Era, put_Era)
    FirstDayInThisMonth = property(get_FirstDayInThisMonth, None)
    FirstEra = property(get_FirstEra, None)
    FirstHourInThisPeriod = property(get_FirstHourInThisPeriod, None)
    FirstMinuteInThisHour = property(get_FirstMinuteInThisHour, None)
    FirstMonthInThisYear = property(get_FirstMonthInThisYear, None)
    FirstPeriodInThisDay = property(get_FirstPeriodInThisDay, None)
    FirstSecondInThisMinute = property(get_FirstSecondInThisMinute, None)
    FirstYearInThisEra = property(get_FirstYearInThisEra, None)
    Hour = property(get_Hour, put_Hour)
    IsDaylightSavingTime = property(get_IsDaylightSavingTime, None)
    Languages = property(get_Languages, None)
    LastDayInThisMonth = property(get_LastDayInThisMonth, None)
    LastEra = property(get_LastEra, None)
    LastHourInThisPeriod = property(get_LastHourInThisPeriod, None)
    LastMinuteInThisHour = property(get_LastMinuteInThisHour, None)
    LastMonthInThisYear = property(get_LastMonthInThisYear, None)
    LastPeriodInThisDay = property(get_LastPeriodInThisDay, None)
    LastSecondInThisMinute = property(get_LastSecondInThisMinute, None)
    LastYearInThisEra = property(get_LastYearInThisEra, None)
    Minute = property(get_Minute, put_Minute)
    Month = property(get_Month, put_Month)
    Nanosecond = property(get_Nanosecond, put_Nanosecond)
    NumberOfDaysInThisMonth = property(get_NumberOfDaysInThisMonth, None)
    NumberOfEras = property(get_NumberOfEras, None)
    NumberOfHoursInThisPeriod = property(get_NumberOfHoursInThisPeriod, None)
    NumberOfMinutesInThisHour = property(get_NumberOfMinutesInThisHour, None)
    NumberOfMonthsInThisYear = property(get_NumberOfMonthsInThisYear, None)
    NumberOfPeriodsInThisDay = property(get_NumberOfPeriodsInThisDay, None)
    NumberOfSecondsInThisMinute = property(get_NumberOfSecondsInThisMinute, None)
    NumberOfYearsInThisEra = property(get_NumberOfYearsInThisEra, None)
    NumeralSystem = property(get_NumeralSystem, put_NumeralSystem)
    Period = property(get_Period, put_Period)
    ResolvedLanguage = property(get_ResolvedLanguage, None)
    Second = property(get_Second, put_Second)
    Year = property(get_Year, put_Year)
class _CalendarIdentifiers_Meta_(ComPtr.__class__):
    pass
class CalendarIdentifiers(ComPtr, metaclass=_CalendarIdentifiers_Meta_):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.CalendarIdentifiers'
    @winrt_classmethod
    def get_ChineseLunar(cls: win32more.Windows.Globalization.ICalendarIdentifiersStatics3) -> WinRT_String: ...
    @winrt_classmethod
    def get_JapaneseLunar(cls: win32more.Windows.Globalization.ICalendarIdentifiersStatics3) -> WinRT_String: ...
    @winrt_classmethod
    def get_KoreanLunar(cls: win32more.Windows.Globalization.ICalendarIdentifiersStatics3) -> WinRT_String: ...
    @winrt_classmethod
    def get_TaiwanLunar(cls: win32more.Windows.Globalization.ICalendarIdentifiersStatics3) -> WinRT_String: ...
    @winrt_classmethod
    def get_VietnameseLunar(cls: win32more.Windows.Globalization.ICalendarIdentifiersStatics3) -> WinRT_String: ...
    @winrt_classmethod
    def get_Persian(cls: win32more.Windows.Globalization.ICalendarIdentifiersStatics2) -> WinRT_String: ...
    @winrt_classmethod
    def get_Gregorian(cls: win32more.Windows.Globalization.ICalendarIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Hebrew(cls: win32more.Windows.Globalization.ICalendarIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Hijri(cls: win32more.Windows.Globalization.ICalendarIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Japanese(cls: win32more.Windows.Globalization.ICalendarIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Julian(cls: win32more.Windows.Globalization.ICalendarIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Korean(cls: win32more.Windows.Globalization.ICalendarIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Taiwan(cls: win32more.Windows.Globalization.ICalendarIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Thai(cls: win32more.Windows.Globalization.ICalendarIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_UmAlQura(cls: win32more.Windows.Globalization.ICalendarIdentifiersStatics) -> WinRT_String: ...
    _CalendarIdentifiers_Meta_.ChineseLunar = property(get_ChineseLunar, None)
    _CalendarIdentifiers_Meta_.Gregorian = property(get_Gregorian, None)
    _CalendarIdentifiers_Meta_.Hebrew = property(get_Hebrew, None)
    _CalendarIdentifiers_Meta_.Hijri = property(get_Hijri, None)
    _CalendarIdentifiers_Meta_.Japanese = property(get_Japanese, None)
    _CalendarIdentifiers_Meta_.JapaneseLunar = property(get_JapaneseLunar, None)
    _CalendarIdentifiers_Meta_.Julian = property(get_Julian, None)
    _CalendarIdentifiers_Meta_.Korean = property(get_Korean, None)
    _CalendarIdentifiers_Meta_.KoreanLunar = property(get_KoreanLunar, None)
    _CalendarIdentifiers_Meta_.Persian = property(get_Persian, None)
    _CalendarIdentifiers_Meta_.Taiwan = property(get_Taiwan, None)
    _CalendarIdentifiers_Meta_.TaiwanLunar = property(get_TaiwanLunar, None)
    _CalendarIdentifiers_Meta_.Thai = property(get_Thai, None)
    _CalendarIdentifiers_Meta_.UmAlQura = property(get_UmAlQura, None)
    _CalendarIdentifiers_Meta_.VietnameseLunar = property(get_VietnameseLunar, None)
class _ClockIdentifiers_Meta_(ComPtr.__class__):
    pass
class ClockIdentifiers(ComPtr, metaclass=_ClockIdentifiers_Meta_):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.ClockIdentifiers'
    @winrt_classmethod
    def get_TwelveHour(cls: win32more.Windows.Globalization.IClockIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_TwentyFourHour(cls: win32more.Windows.Globalization.IClockIdentifiersStatics) -> WinRT_String: ...
    _ClockIdentifiers_Meta_.TwelveHour = property(get_TwelveHour, None)
    _ClockIdentifiers_Meta_.TwentyFourHour = property(get_TwentyFourHour, None)
class CurrencyAmount(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Globalization.ICurrencyAmount
    _classid_ = 'Windows.Globalization.CurrencyAmount'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 2:
            super().__init__(move=win32more.Windows.Globalization.CurrencyAmount.Create(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def Create(cls: win32more.Windows.Globalization.ICurrencyAmountFactory, amount: WinRT_String, currency: WinRT_String) -> win32more.Windows.Globalization.CurrencyAmount: ...
    @winrt_mixinmethod
    def get_Amount(self: win32more.Windows.Globalization.ICurrencyAmount) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_Currency(self: win32more.Windows.Globalization.ICurrencyAmount) -> WinRT_String: ...
    Amount = property(get_Amount, None)
    Currency = property(get_Currency, None)
class _CurrencyIdentifiers_Meta_(ComPtr.__class__):
    pass
class CurrencyIdentifiers(ComPtr, metaclass=_CurrencyIdentifiers_Meta_):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.CurrencyIdentifiers'
    @winrt_classmethod
    def get_MRU(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics3) -> WinRT_String: ...
    @winrt_classmethod
    def get_SSP(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics3) -> WinRT_String: ...
    @winrt_classmethod
    def get_STN(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics3) -> WinRT_String: ...
    @winrt_classmethod
    def get_VES(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics3) -> WinRT_String: ...
    @winrt_classmethod
    def get_BYN(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics2) -> WinRT_String: ...
    @winrt_classmethod
    def get_AED(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_AFN(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_ALL(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_AMD(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_ANG(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_AOA(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_ARS(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_AUD(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_AWG(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_AZN(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_BAM(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_BBD(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_BDT(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_BGN(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_BHD(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_BIF(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_BMD(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_BND(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_BOB(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_BRL(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_BSD(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_BTN(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_BWP(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_BYR(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_BZD(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_CAD(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_CDF(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_CHF(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_CLP(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_CNY(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_COP(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_CRC(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_CUP(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_CVE(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_CZK(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_DJF(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_DKK(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_DOP(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_DZD(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_EGP(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_ERN(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_ETB(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_EUR(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_FJD(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_FKP(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_GBP(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_GEL(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_GHS(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_GIP(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_GMD(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_GNF(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_GTQ(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_GYD(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_HKD(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_HNL(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_HRK(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_HTG(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_HUF(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_IDR(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_ILS(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_INR(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_IQD(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_IRR(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_ISK(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_JMD(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_JOD(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_JPY(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_KES(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_KGS(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_KHR(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_KMF(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_KPW(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_KRW(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_KWD(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_KYD(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_KZT(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_LAK(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_LBP(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_LKR(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_LRD(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_LSL(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_LTL(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_LVL(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_LYD(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_MAD(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_MDL(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_MGA(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_MKD(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_MMK(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_MNT(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_MOP(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_MRO(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_MUR(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_MVR(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_MWK(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_MXN(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_MYR(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_MZN(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_NAD(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_NGN(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_NIO(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_NOK(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_NPR(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_NZD(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_OMR(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_PAB(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_PEN(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_PGK(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_PHP(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_PKR(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_PLN(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_PYG(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_QAR(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_RON(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_RSD(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_RUB(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_RWF(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_SAR(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_SBD(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_SCR(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_SDG(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_SEK(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_SGD(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_SHP(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_SLL(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_SOS(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_SRD(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_STD(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_SYP(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_SZL(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_THB(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_TJS(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_TMT(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_TND(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_TOP(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_TRY(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_TTD(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_TWD(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_TZS(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_UAH(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_UGX(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_USD(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_UYU(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_UZS(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_VEF(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_VND(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_VUV(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_WST(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_XAF(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_XCD(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_XOF(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_XPF(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_XXX(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_YER(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_ZAR(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_ZMW(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_ZWL(cls: win32more.Windows.Globalization.ICurrencyIdentifiersStatics) -> WinRT_String: ...
    _CurrencyIdentifiers_Meta_.AED = property(get_AED, None)
    _CurrencyIdentifiers_Meta_.AFN = property(get_AFN, None)
    _CurrencyIdentifiers_Meta_.ALL = property(get_ALL, None)
    _CurrencyIdentifiers_Meta_.AMD = property(get_AMD, None)
    _CurrencyIdentifiers_Meta_.ANG = property(get_ANG, None)
    _CurrencyIdentifiers_Meta_.AOA = property(get_AOA, None)
    _CurrencyIdentifiers_Meta_.ARS = property(get_ARS, None)
    _CurrencyIdentifiers_Meta_.AUD = property(get_AUD, None)
    _CurrencyIdentifiers_Meta_.AWG = property(get_AWG, None)
    _CurrencyIdentifiers_Meta_.AZN = property(get_AZN, None)
    _CurrencyIdentifiers_Meta_.BAM = property(get_BAM, None)
    _CurrencyIdentifiers_Meta_.BBD = property(get_BBD, None)
    _CurrencyIdentifiers_Meta_.BDT = property(get_BDT, None)
    _CurrencyIdentifiers_Meta_.BGN = property(get_BGN, None)
    _CurrencyIdentifiers_Meta_.BHD = property(get_BHD, None)
    _CurrencyIdentifiers_Meta_.BIF = property(get_BIF, None)
    _CurrencyIdentifiers_Meta_.BMD = property(get_BMD, None)
    _CurrencyIdentifiers_Meta_.BND = property(get_BND, None)
    _CurrencyIdentifiers_Meta_.BOB = property(get_BOB, None)
    _CurrencyIdentifiers_Meta_.BRL = property(get_BRL, None)
    _CurrencyIdentifiers_Meta_.BSD = property(get_BSD, None)
    _CurrencyIdentifiers_Meta_.BTN = property(get_BTN, None)
    _CurrencyIdentifiers_Meta_.BWP = property(get_BWP, None)
    _CurrencyIdentifiers_Meta_.BYN = property(get_BYN, None)
    _CurrencyIdentifiers_Meta_.BYR = property(get_BYR, None)
    _CurrencyIdentifiers_Meta_.BZD = property(get_BZD, None)
    _CurrencyIdentifiers_Meta_.CAD = property(get_CAD, None)
    _CurrencyIdentifiers_Meta_.CDF = property(get_CDF, None)
    _CurrencyIdentifiers_Meta_.CHF = property(get_CHF, None)
    _CurrencyIdentifiers_Meta_.CLP = property(get_CLP, None)
    _CurrencyIdentifiers_Meta_.CNY = property(get_CNY, None)
    _CurrencyIdentifiers_Meta_.COP = property(get_COP, None)
    _CurrencyIdentifiers_Meta_.CRC = property(get_CRC, None)
    _CurrencyIdentifiers_Meta_.CUP = property(get_CUP, None)
    _CurrencyIdentifiers_Meta_.CVE = property(get_CVE, None)
    _CurrencyIdentifiers_Meta_.CZK = property(get_CZK, None)
    _CurrencyIdentifiers_Meta_.DJF = property(get_DJF, None)
    _CurrencyIdentifiers_Meta_.DKK = property(get_DKK, None)
    _CurrencyIdentifiers_Meta_.DOP = property(get_DOP, None)
    _CurrencyIdentifiers_Meta_.DZD = property(get_DZD, None)
    _CurrencyIdentifiers_Meta_.EGP = property(get_EGP, None)
    _CurrencyIdentifiers_Meta_.ERN = property(get_ERN, None)
    _CurrencyIdentifiers_Meta_.ETB = property(get_ETB, None)
    _CurrencyIdentifiers_Meta_.EUR = property(get_EUR, None)
    _CurrencyIdentifiers_Meta_.FJD = property(get_FJD, None)
    _CurrencyIdentifiers_Meta_.FKP = property(get_FKP, None)
    _CurrencyIdentifiers_Meta_.GBP = property(get_GBP, None)
    _CurrencyIdentifiers_Meta_.GEL = property(get_GEL, None)
    _CurrencyIdentifiers_Meta_.GHS = property(get_GHS, None)
    _CurrencyIdentifiers_Meta_.GIP = property(get_GIP, None)
    _CurrencyIdentifiers_Meta_.GMD = property(get_GMD, None)
    _CurrencyIdentifiers_Meta_.GNF = property(get_GNF, None)
    _CurrencyIdentifiers_Meta_.GTQ = property(get_GTQ, None)
    _CurrencyIdentifiers_Meta_.GYD = property(get_GYD, None)
    _CurrencyIdentifiers_Meta_.HKD = property(get_HKD, None)
    _CurrencyIdentifiers_Meta_.HNL = property(get_HNL, None)
    _CurrencyIdentifiers_Meta_.HRK = property(get_HRK, None)
    _CurrencyIdentifiers_Meta_.HTG = property(get_HTG, None)
    _CurrencyIdentifiers_Meta_.HUF = property(get_HUF, None)
    _CurrencyIdentifiers_Meta_.IDR = property(get_IDR, None)
    _CurrencyIdentifiers_Meta_.ILS = property(get_ILS, None)
    _CurrencyIdentifiers_Meta_.INR = property(get_INR, None)
    _CurrencyIdentifiers_Meta_.IQD = property(get_IQD, None)
    _CurrencyIdentifiers_Meta_.IRR = property(get_IRR, None)
    _CurrencyIdentifiers_Meta_.ISK = property(get_ISK, None)
    _CurrencyIdentifiers_Meta_.JMD = property(get_JMD, None)
    _CurrencyIdentifiers_Meta_.JOD = property(get_JOD, None)
    _CurrencyIdentifiers_Meta_.JPY = property(get_JPY, None)
    _CurrencyIdentifiers_Meta_.KES = property(get_KES, None)
    _CurrencyIdentifiers_Meta_.KGS = property(get_KGS, None)
    _CurrencyIdentifiers_Meta_.KHR = property(get_KHR, None)
    _CurrencyIdentifiers_Meta_.KMF = property(get_KMF, None)
    _CurrencyIdentifiers_Meta_.KPW = property(get_KPW, None)
    _CurrencyIdentifiers_Meta_.KRW = property(get_KRW, None)
    _CurrencyIdentifiers_Meta_.KWD = property(get_KWD, None)
    _CurrencyIdentifiers_Meta_.KYD = property(get_KYD, None)
    _CurrencyIdentifiers_Meta_.KZT = property(get_KZT, None)
    _CurrencyIdentifiers_Meta_.LAK = property(get_LAK, None)
    _CurrencyIdentifiers_Meta_.LBP = property(get_LBP, None)
    _CurrencyIdentifiers_Meta_.LKR = property(get_LKR, None)
    _CurrencyIdentifiers_Meta_.LRD = property(get_LRD, None)
    _CurrencyIdentifiers_Meta_.LSL = property(get_LSL, None)
    _CurrencyIdentifiers_Meta_.LTL = property(get_LTL, None)
    _CurrencyIdentifiers_Meta_.LVL = property(get_LVL, None)
    _CurrencyIdentifiers_Meta_.LYD = property(get_LYD, None)
    _CurrencyIdentifiers_Meta_.MAD = property(get_MAD, None)
    _CurrencyIdentifiers_Meta_.MDL = property(get_MDL, None)
    _CurrencyIdentifiers_Meta_.MGA = property(get_MGA, None)
    _CurrencyIdentifiers_Meta_.MKD = property(get_MKD, None)
    _CurrencyIdentifiers_Meta_.MMK = property(get_MMK, None)
    _CurrencyIdentifiers_Meta_.MNT = property(get_MNT, None)
    _CurrencyIdentifiers_Meta_.MOP = property(get_MOP, None)
    _CurrencyIdentifiers_Meta_.MRO = property(get_MRO, None)
    _CurrencyIdentifiers_Meta_.MRU = property(get_MRU, None)
    _CurrencyIdentifiers_Meta_.MUR = property(get_MUR, None)
    _CurrencyIdentifiers_Meta_.MVR = property(get_MVR, None)
    _CurrencyIdentifiers_Meta_.MWK = property(get_MWK, None)
    _CurrencyIdentifiers_Meta_.MXN = property(get_MXN, None)
    _CurrencyIdentifiers_Meta_.MYR = property(get_MYR, None)
    _CurrencyIdentifiers_Meta_.MZN = property(get_MZN, None)
    _CurrencyIdentifiers_Meta_.NAD = property(get_NAD, None)
    _CurrencyIdentifiers_Meta_.NGN = property(get_NGN, None)
    _CurrencyIdentifiers_Meta_.NIO = property(get_NIO, None)
    _CurrencyIdentifiers_Meta_.NOK = property(get_NOK, None)
    _CurrencyIdentifiers_Meta_.NPR = property(get_NPR, None)
    _CurrencyIdentifiers_Meta_.NZD = property(get_NZD, None)
    _CurrencyIdentifiers_Meta_.OMR = property(get_OMR, None)
    _CurrencyIdentifiers_Meta_.PAB = property(get_PAB, None)
    _CurrencyIdentifiers_Meta_.PEN = property(get_PEN, None)
    _CurrencyIdentifiers_Meta_.PGK = property(get_PGK, None)
    _CurrencyIdentifiers_Meta_.PHP = property(get_PHP, None)
    _CurrencyIdentifiers_Meta_.PKR = property(get_PKR, None)
    _CurrencyIdentifiers_Meta_.PLN = property(get_PLN, None)
    _CurrencyIdentifiers_Meta_.PYG = property(get_PYG, None)
    _CurrencyIdentifiers_Meta_.QAR = property(get_QAR, None)
    _CurrencyIdentifiers_Meta_.RON = property(get_RON, None)
    _CurrencyIdentifiers_Meta_.RSD = property(get_RSD, None)
    _CurrencyIdentifiers_Meta_.RUB = property(get_RUB, None)
    _CurrencyIdentifiers_Meta_.RWF = property(get_RWF, None)
    _CurrencyIdentifiers_Meta_.SAR = property(get_SAR, None)
    _CurrencyIdentifiers_Meta_.SBD = property(get_SBD, None)
    _CurrencyIdentifiers_Meta_.SCR = property(get_SCR, None)
    _CurrencyIdentifiers_Meta_.SDG = property(get_SDG, None)
    _CurrencyIdentifiers_Meta_.SEK = property(get_SEK, None)
    _CurrencyIdentifiers_Meta_.SGD = property(get_SGD, None)
    _CurrencyIdentifiers_Meta_.SHP = property(get_SHP, None)
    _CurrencyIdentifiers_Meta_.SLL = property(get_SLL, None)
    _CurrencyIdentifiers_Meta_.SOS = property(get_SOS, None)
    _CurrencyIdentifiers_Meta_.SRD = property(get_SRD, None)
    _CurrencyIdentifiers_Meta_.SSP = property(get_SSP, None)
    _CurrencyIdentifiers_Meta_.STD = property(get_STD, None)
    _CurrencyIdentifiers_Meta_.STN = property(get_STN, None)
    _CurrencyIdentifiers_Meta_.SYP = property(get_SYP, None)
    _CurrencyIdentifiers_Meta_.SZL = property(get_SZL, None)
    _CurrencyIdentifiers_Meta_.THB = property(get_THB, None)
    _CurrencyIdentifiers_Meta_.TJS = property(get_TJS, None)
    _CurrencyIdentifiers_Meta_.TMT = property(get_TMT, None)
    _CurrencyIdentifiers_Meta_.TND = property(get_TND, None)
    _CurrencyIdentifiers_Meta_.TOP = property(get_TOP, None)
    _CurrencyIdentifiers_Meta_.TRY = property(get_TRY, None)
    _CurrencyIdentifiers_Meta_.TTD = property(get_TTD, None)
    _CurrencyIdentifiers_Meta_.TWD = property(get_TWD, None)
    _CurrencyIdentifiers_Meta_.TZS = property(get_TZS, None)
    _CurrencyIdentifiers_Meta_.UAH = property(get_UAH, None)
    _CurrencyIdentifiers_Meta_.UGX = property(get_UGX, None)
    _CurrencyIdentifiers_Meta_.USD = property(get_USD, None)
    _CurrencyIdentifiers_Meta_.UYU = property(get_UYU, None)
    _CurrencyIdentifiers_Meta_.UZS = property(get_UZS, None)
    _CurrencyIdentifiers_Meta_.VEF = property(get_VEF, None)
    _CurrencyIdentifiers_Meta_.VES = property(get_VES, None)
    _CurrencyIdentifiers_Meta_.VND = property(get_VND, None)
    _CurrencyIdentifiers_Meta_.VUV = property(get_VUV, None)
    _CurrencyIdentifiers_Meta_.WST = property(get_WST, None)
    _CurrencyIdentifiers_Meta_.XAF = property(get_XAF, None)
    _CurrencyIdentifiers_Meta_.XCD = property(get_XCD, None)
    _CurrencyIdentifiers_Meta_.XOF = property(get_XOF, None)
    _CurrencyIdentifiers_Meta_.XPF = property(get_XPF, None)
    _CurrencyIdentifiers_Meta_.XXX = property(get_XXX, None)
    _CurrencyIdentifiers_Meta_.YER = property(get_YER, None)
    _CurrencyIdentifiers_Meta_.ZAR = property(get_ZAR, None)
    _CurrencyIdentifiers_Meta_.ZMW = property(get_ZMW, None)
    _CurrencyIdentifiers_Meta_.ZWL = property(get_ZWL, None)
class DayOfWeek(Enum, Int32):
    Sunday = 0
    Monday = 1
    Tuesday = 2
    Wednesday = 3
    Thursday = 4
    Friday = 5
    Saturday = 6
class GeographicRegion(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Globalization.IGeographicRegion
    _classid_ = 'Windows.Globalization.GeographicRegion'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 0:
            super().__init__(move=win32more.Windows.Globalization.GeographicRegion.CreateInstance(*args))
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Globalization.GeographicRegion.CreateGeographicRegion(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_activatemethod
    def CreateInstance(cls) -> win32more.Windows.Globalization.GeographicRegion: ...
    @winrt_factorymethod
    def CreateGeographicRegion(cls: win32more.Windows.Globalization.IGeographicRegionFactory, geographicRegionCode: WinRT_String) -> win32more.Windows.Globalization.GeographicRegion: ...
    @winrt_mixinmethod
    def get_Code(self: win32more.Windows.Globalization.IGeographicRegion) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_CodeTwoLetter(self: win32more.Windows.Globalization.IGeographicRegion) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_CodeThreeLetter(self: win32more.Windows.Globalization.IGeographicRegion) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_CodeThreeDigit(self: win32more.Windows.Globalization.IGeographicRegion) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_DisplayName(self: win32more.Windows.Globalization.IGeographicRegion) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_NativeName(self: win32more.Windows.Globalization.IGeographicRegion) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_CurrenciesInUse(self: win32more.Windows.Globalization.IGeographicRegion) -> win32more.Windows.Foundation.Collections.IVectorView[WinRT_String]: ...
    @winrt_classmethod
    def IsSupported(cls: win32more.Windows.Globalization.IGeographicRegionStatics, geographicRegionCode: WinRT_String) -> Boolean: ...
    Code = property(get_Code, None)
    CodeThreeDigit = property(get_CodeThreeDigit, None)
    CodeThreeLetter = property(get_CodeThreeLetter, None)
    CodeTwoLetter = property(get_CodeTwoLetter, None)
    CurrenciesInUse = property(get_CurrenciesInUse, None)
    DisplayName = property(get_DisplayName, None)
    NativeName = property(get_NativeName, None)
GlobalizationJapanesePhoneticAnalyzerContract: UInt32 = 65536
class IApplicationLanguagesStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.IApplicationLanguagesStatics'
    _iid_ = Guid('{75b40847-0a4c-4a92-9565-fd63c95f7aed}')
    @winrt_commethod(6)
    def get_PrimaryLanguageOverride(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def put_PrimaryLanguageOverride(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(8)
    def get_Languages(self) -> win32more.Windows.Foundation.Collections.IVectorView[WinRT_String]: ...
    @winrt_commethod(9)
    def get_ManifestLanguages(self) -> win32more.Windows.Foundation.Collections.IVectorView[WinRT_String]: ...
    Languages = property(get_Languages, None)
    ManifestLanguages = property(get_ManifestLanguages, None)
    PrimaryLanguageOverride = property(get_PrimaryLanguageOverride, put_PrimaryLanguageOverride)
class IApplicationLanguagesStatics2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.IApplicationLanguagesStatics2'
    _iid_ = Guid('{1df0de4f-072b-4d7b-8f06-cb2db40f2bb5}')
    @winrt_commethod(6)
    def GetLanguagesForUser(self, user: win32more.Windows.System.User) -> win32more.Windows.Foundation.Collections.IVectorView[WinRT_String]: ...
class ICalendar(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.ICalendar'
    _iid_ = Guid('{ca30221d-86d9-40fb-a26b-d44eb7cf08ea}')
    @winrt_commethod(6)
    def Clone(self) -> win32more.Windows.Globalization.Calendar: ...
    @winrt_commethod(7)
    def SetToMin(self) -> Void: ...
    @winrt_commethod(8)
    def SetToMax(self) -> Void: ...
    @winrt_commethod(9)
    def get_Languages(self) -> win32more.Windows.Foundation.Collections.IVectorView[WinRT_String]: ...
    @winrt_commethod(10)
    def get_NumeralSystem(self) -> WinRT_String: ...
    @winrt_commethod(11)
    def put_NumeralSystem(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(12)
    def GetCalendarSystem(self) -> WinRT_String: ...
    @winrt_commethod(13)
    def ChangeCalendarSystem(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(14)
    def GetClock(self) -> WinRT_String: ...
    @winrt_commethod(15)
    def ChangeClock(self, value: WinRT_String) -> Void: ...
    @winrt_commethod(16)
    def GetDateTime(self) -> win32more.Windows.Foundation.DateTime: ...
    @winrt_commethod(17)
    def SetDateTime(self, value: win32more.Windows.Foundation.DateTime) -> Void: ...
    @winrt_commethod(18)
    def SetToNow(self) -> Void: ...
    @winrt_commethod(19)
    def get_FirstEra(self) -> Int32: ...
    @winrt_commethod(20)
    def get_LastEra(self) -> Int32: ...
    @winrt_commethod(21)
    def get_NumberOfEras(self) -> Int32: ...
    @winrt_commethod(22)
    def get_Era(self) -> Int32: ...
    @winrt_commethod(23)
    def put_Era(self, value: Int32) -> Void: ...
    @winrt_commethod(24)
    def AddEras(self, eras: Int32) -> Void: ...
    @winrt_commethod(25)
    def EraAsFullString(self) -> WinRT_String: ...
    @winrt_commethod(26)
    def EraAsString(self, idealLength: Int32) -> WinRT_String: ...
    @winrt_commethod(27)
    def get_FirstYearInThisEra(self) -> Int32: ...
    @winrt_commethod(28)
    def get_LastYearInThisEra(self) -> Int32: ...
    @winrt_commethod(29)
    def get_NumberOfYearsInThisEra(self) -> Int32: ...
    @winrt_commethod(30)
    def get_Year(self) -> Int32: ...
    @winrt_commethod(31)
    def put_Year(self, value: Int32) -> Void: ...
    @winrt_commethod(32)
    def AddYears(self, years: Int32) -> Void: ...
    @winrt_commethod(33)
    def YearAsString(self) -> WinRT_String: ...
    @winrt_commethod(34)
    def YearAsTruncatedString(self, remainingDigits: Int32) -> WinRT_String: ...
    @winrt_commethod(35)
    def YearAsPaddedString(self, minDigits: Int32) -> WinRT_String: ...
    @winrt_commethod(36)
    def get_FirstMonthInThisYear(self) -> Int32: ...
    @winrt_commethod(37)
    def get_LastMonthInThisYear(self) -> Int32: ...
    @winrt_commethod(38)
    def get_NumberOfMonthsInThisYear(self) -> Int32: ...
    @winrt_commethod(39)
    def get_Month(self) -> Int32: ...
    @winrt_commethod(40)
    def put_Month(self, value: Int32) -> Void: ...
    @winrt_commethod(41)
    def AddMonths(self, months: Int32) -> Void: ...
    @winrt_commethod(42)
    def MonthAsFullString(self) -> WinRT_String: ...
    @winrt_commethod(43)
    def MonthAsString(self, idealLength: Int32) -> WinRT_String: ...
    @winrt_commethod(44)
    def MonthAsFullSoloString(self) -> WinRT_String: ...
    @winrt_commethod(45)
    def MonthAsSoloString(self, idealLength: Int32) -> WinRT_String: ...
    @winrt_commethod(46)
    def MonthAsNumericString(self) -> WinRT_String: ...
    @winrt_commethod(47)
    def MonthAsPaddedNumericString(self, minDigits: Int32) -> WinRT_String: ...
    @winrt_commethod(48)
    def AddWeeks(self, weeks: Int32) -> Void: ...
    @winrt_commethod(49)
    def get_FirstDayInThisMonth(self) -> Int32: ...
    @winrt_commethod(50)
    def get_LastDayInThisMonth(self) -> Int32: ...
    @winrt_commethod(51)
    def get_NumberOfDaysInThisMonth(self) -> Int32: ...
    @winrt_commethod(52)
    def get_Day(self) -> Int32: ...
    @winrt_commethod(53)
    def put_Day(self, value: Int32) -> Void: ...
    @winrt_commethod(54)
    def AddDays(self, days: Int32) -> Void: ...
    @winrt_commethod(55)
    def DayAsString(self) -> WinRT_String: ...
    @winrt_commethod(56)
    def DayAsPaddedString(self, minDigits: Int32) -> WinRT_String: ...
    @winrt_commethod(57)
    def get_DayOfWeek(self) -> win32more.Windows.Globalization.DayOfWeek: ...
    @winrt_commethod(58)
    def DayOfWeekAsFullString(self) -> WinRT_String: ...
    @winrt_commethod(59)
    def DayOfWeekAsString(self, idealLength: Int32) -> WinRT_String: ...
    @winrt_commethod(60)
    def DayOfWeekAsFullSoloString(self) -> WinRT_String: ...
    @winrt_commethod(61)
    def DayOfWeekAsSoloString(self, idealLength: Int32) -> WinRT_String: ...
    @winrt_commethod(62)
    def get_FirstPeriodInThisDay(self) -> Int32: ...
    @winrt_commethod(63)
    def get_LastPeriodInThisDay(self) -> Int32: ...
    @winrt_commethod(64)
    def get_NumberOfPeriodsInThisDay(self) -> Int32: ...
    @winrt_commethod(65)
    def get_Period(self) -> Int32: ...
    @winrt_commethod(66)
    def put_Period(self, value: Int32) -> Void: ...
    @winrt_commethod(67)
    def AddPeriods(self, periods: Int32) -> Void: ...
    @winrt_commethod(68)
    def PeriodAsFullString(self) -> WinRT_String: ...
    @winrt_commethod(69)
    def PeriodAsString(self, idealLength: Int32) -> WinRT_String: ...
    @winrt_commethod(70)
    def get_FirstHourInThisPeriod(self) -> Int32: ...
    @winrt_commethod(71)
    def get_LastHourInThisPeriod(self) -> Int32: ...
    @winrt_commethod(72)
    def get_NumberOfHoursInThisPeriod(self) -> Int32: ...
    @winrt_commethod(73)
    def get_Hour(self) -> Int32: ...
    @winrt_commethod(74)
    def put_Hour(self, value: Int32) -> Void: ...
    @winrt_commethod(75)
    def AddHours(self, hours: Int32) -> Void: ...
    @winrt_commethod(76)
    def HourAsString(self) -> WinRT_String: ...
    @winrt_commethod(77)
    def HourAsPaddedString(self, minDigits: Int32) -> WinRT_String: ...
    @winrt_commethod(78)
    def get_Minute(self) -> Int32: ...
    @winrt_commethod(79)
    def put_Minute(self, value: Int32) -> Void: ...
    @winrt_commethod(80)
    def AddMinutes(self, minutes: Int32) -> Void: ...
    @winrt_commethod(81)
    def MinuteAsString(self) -> WinRT_String: ...
    @winrt_commethod(82)
    def MinuteAsPaddedString(self, minDigits: Int32) -> WinRT_String: ...
    @winrt_commethod(83)
    def get_Second(self) -> Int32: ...
    @winrt_commethod(84)
    def put_Second(self, value: Int32) -> Void: ...
    @winrt_commethod(85)
    def AddSeconds(self, seconds: Int32) -> Void: ...
    @winrt_commethod(86)
    def SecondAsString(self) -> WinRT_String: ...
    @winrt_commethod(87)
    def SecondAsPaddedString(self, minDigits: Int32) -> WinRT_String: ...
    @winrt_commethod(88)
    def get_Nanosecond(self) -> Int32: ...
    @winrt_commethod(89)
    def put_Nanosecond(self, value: Int32) -> Void: ...
    @winrt_commethod(90)
    def AddNanoseconds(self, nanoseconds: Int32) -> Void: ...
    @winrt_commethod(91)
    def NanosecondAsString(self) -> WinRT_String: ...
    @winrt_commethod(92)
    def NanosecondAsPaddedString(self, minDigits: Int32) -> WinRT_String: ...
    @winrt_commethod(93)
    def Compare(self, other: win32more.Windows.Globalization.Calendar) -> Int32: ...
    @winrt_commethod(94)
    def CompareDateTime(self, other: win32more.Windows.Foundation.DateTime) -> Int32: ...
    @winrt_commethod(95)
    def CopyTo(self, other: win32more.Windows.Globalization.Calendar) -> Void: ...
    @winrt_commethod(96)
    def get_FirstMinuteInThisHour(self) -> Int32: ...
    @winrt_commethod(97)
    def get_LastMinuteInThisHour(self) -> Int32: ...
    @winrt_commethod(98)
    def get_NumberOfMinutesInThisHour(self) -> Int32: ...
    @winrt_commethod(99)
    def get_FirstSecondInThisMinute(self) -> Int32: ...
    @winrt_commethod(100)
    def get_LastSecondInThisMinute(self) -> Int32: ...
    @winrt_commethod(101)
    def get_NumberOfSecondsInThisMinute(self) -> Int32: ...
    @winrt_commethod(102)
    def get_ResolvedLanguage(self) -> WinRT_String: ...
    @winrt_commethod(103)
    def get_IsDaylightSavingTime(self) -> Boolean: ...
    Day = property(get_Day, put_Day)
    DayOfWeek = property(get_DayOfWeek, None)
    Era = property(get_Era, put_Era)
    FirstDayInThisMonth = property(get_FirstDayInThisMonth, None)
    FirstEra = property(get_FirstEra, None)
    FirstHourInThisPeriod = property(get_FirstHourInThisPeriod, None)
    FirstMinuteInThisHour = property(get_FirstMinuteInThisHour, None)
    FirstMonthInThisYear = property(get_FirstMonthInThisYear, None)
    FirstPeriodInThisDay = property(get_FirstPeriodInThisDay, None)
    FirstSecondInThisMinute = property(get_FirstSecondInThisMinute, None)
    FirstYearInThisEra = property(get_FirstYearInThisEra, None)
    Hour = property(get_Hour, put_Hour)
    IsDaylightSavingTime = property(get_IsDaylightSavingTime, None)
    Languages = property(get_Languages, None)
    LastDayInThisMonth = property(get_LastDayInThisMonth, None)
    LastEra = property(get_LastEra, None)
    LastHourInThisPeriod = property(get_LastHourInThisPeriod, None)
    LastMinuteInThisHour = property(get_LastMinuteInThisHour, None)
    LastMonthInThisYear = property(get_LastMonthInThisYear, None)
    LastPeriodInThisDay = property(get_LastPeriodInThisDay, None)
    LastSecondInThisMinute = property(get_LastSecondInThisMinute, None)
    LastYearInThisEra = property(get_LastYearInThisEra, None)
    Minute = property(get_Minute, put_Minute)
    Month = property(get_Month, put_Month)
    Nanosecond = property(get_Nanosecond, put_Nanosecond)
    NumberOfDaysInThisMonth = property(get_NumberOfDaysInThisMonth, None)
    NumberOfEras = property(get_NumberOfEras, None)
    NumberOfHoursInThisPeriod = property(get_NumberOfHoursInThisPeriod, None)
    NumberOfMinutesInThisHour = property(get_NumberOfMinutesInThisHour, None)
    NumberOfMonthsInThisYear = property(get_NumberOfMonthsInThisYear, None)
    NumberOfPeriodsInThisDay = property(get_NumberOfPeriodsInThisDay, None)
    NumberOfSecondsInThisMinute = property(get_NumberOfSecondsInThisMinute, None)
    NumberOfYearsInThisEra = property(get_NumberOfYearsInThisEra, None)
    NumeralSystem = property(get_NumeralSystem, put_NumeralSystem)
    Period = property(get_Period, put_Period)
    ResolvedLanguage = property(get_ResolvedLanguage, None)
    Second = property(get_Second, put_Second)
    Year = property(get_Year, put_Year)
class ICalendarFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.ICalendarFactory'
    _iid_ = Guid('{83f58412-e56b-4c75-a66e-0f63d57758a6}')
    @winrt_commethod(6)
    def CreateCalendarDefaultCalendarAndClock(self, languages: win32more.Windows.Foundation.Collections.IIterable[WinRT_String]) -> win32more.Windows.Globalization.Calendar: ...
    @winrt_commethod(7)
    def CreateCalendar(self, languages: win32more.Windows.Foundation.Collections.IIterable[WinRT_String], calendar: WinRT_String, clock: WinRT_String) -> win32more.Windows.Globalization.Calendar: ...
class ICalendarFactory2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.ICalendarFactory2'
    _iid_ = Guid('{b44b378c-ca7e-4590-9e72-ea2bec1a5115}')
    @winrt_commethod(6)
    def CreateCalendarWithTimeZone(self, languages: win32more.Windows.Foundation.Collections.IIterable[WinRT_String], calendar: WinRT_String, clock: WinRT_String, timeZoneId: WinRT_String) -> win32more.Windows.Globalization.Calendar: ...
class ICalendarIdentifiersStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.ICalendarIdentifiersStatics'
    _iid_ = Guid('{80653f68-2cb2-4c1f-b590-f0f52bf4fd1a}')
    @winrt_commethod(6)
    def get_Gregorian(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def get_Hebrew(self) -> WinRT_String: ...
    @winrt_commethod(8)
    def get_Hijri(self) -> WinRT_String: ...
    @winrt_commethod(9)
    def get_Japanese(self) -> WinRT_String: ...
    @winrt_commethod(10)
    def get_Julian(self) -> WinRT_String: ...
    @winrt_commethod(11)
    def get_Korean(self) -> WinRT_String: ...
    @winrt_commethod(12)
    def get_Taiwan(self) -> WinRT_String: ...
    @winrt_commethod(13)
    def get_Thai(self) -> WinRT_String: ...
    @winrt_commethod(14)
    def get_UmAlQura(self) -> WinRT_String: ...
    Gregorian = property(get_Gregorian, None)
    Hebrew = property(get_Hebrew, None)
    Hijri = property(get_Hijri, None)
    Japanese = property(get_Japanese, None)
    Julian = property(get_Julian, None)
    Korean = property(get_Korean, None)
    Taiwan = property(get_Taiwan, None)
    Thai = property(get_Thai, None)
    UmAlQura = property(get_UmAlQura, None)
class ICalendarIdentifiersStatics2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.ICalendarIdentifiersStatics2'
    _iid_ = Guid('{7df4d488-5fd0-42a7-95b5-7d98d823075f}')
    @winrt_commethod(6)
    def get_Persian(self) -> WinRT_String: ...
    Persian = property(get_Persian, None)
class ICalendarIdentifiersStatics3(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.ICalendarIdentifiersStatics3'
    _iid_ = Guid('{2c225423-1fad-40c0-9334-a8eb90db04f5}')
    @winrt_commethod(6)
    def get_ChineseLunar(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def get_JapaneseLunar(self) -> WinRT_String: ...
    @winrt_commethod(8)
    def get_KoreanLunar(self) -> WinRT_String: ...
    @winrt_commethod(9)
    def get_TaiwanLunar(self) -> WinRT_String: ...
    @winrt_commethod(10)
    def get_VietnameseLunar(self) -> WinRT_String: ...
    ChineseLunar = property(get_ChineseLunar, None)
    JapaneseLunar = property(get_JapaneseLunar, None)
    KoreanLunar = property(get_KoreanLunar, None)
    TaiwanLunar = property(get_TaiwanLunar, None)
    VietnameseLunar = property(get_VietnameseLunar, None)
class IClockIdentifiersStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.IClockIdentifiersStatics'
    _iid_ = Guid('{523805bb-12ec-4f83-bc31-b1b4376b0808}')
    @winrt_commethod(6)
    def get_TwelveHour(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def get_TwentyFourHour(self) -> WinRT_String: ...
    TwelveHour = property(get_TwelveHour, None)
    TwentyFourHour = property(get_TwentyFourHour, None)
class ICurrencyAmount(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.ICurrencyAmount'
    _iid_ = Guid('{74b49942-eb75-443a-95b3-7d723f56f93c}')
    @winrt_commethod(6)
    def get_Amount(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def get_Currency(self) -> WinRT_String: ...
    Amount = property(get_Amount, None)
    Currency = property(get_Currency, None)
class ICurrencyAmountFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.ICurrencyAmountFactory'
    _iid_ = Guid('{48d7168f-ef3b-4aee-a6a1-4b036fe03ff0}')
    @winrt_commethod(6)
    def Create(self, amount: WinRT_String, currency: WinRT_String) -> win32more.Windows.Globalization.CurrencyAmount: ...
class ICurrencyIdentifiersStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.ICurrencyIdentifiersStatics'
    _iid_ = Guid('{9f1d091b-d586-4913-9b6a-a9bd2dc12874}')
    @winrt_commethod(6)
    def get_AED(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def get_AFN(self) -> WinRT_String: ...
    @winrt_commethod(8)
    def get_ALL(self) -> WinRT_String: ...
    @winrt_commethod(9)
    def get_AMD(self) -> WinRT_String: ...
    @winrt_commethod(10)
    def get_ANG(self) -> WinRT_String: ...
    @winrt_commethod(11)
    def get_AOA(self) -> WinRT_String: ...
    @winrt_commethod(12)
    def get_ARS(self) -> WinRT_String: ...
    @winrt_commethod(13)
    def get_AUD(self) -> WinRT_String: ...
    @winrt_commethod(14)
    def get_AWG(self) -> WinRT_String: ...
    @winrt_commethod(15)
    def get_AZN(self) -> WinRT_String: ...
    @winrt_commethod(16)
    def get_BAM(self) -> WinRT_String: ...
    @winrt_commethod(17)
    def get_BBD(self) -> WinRT_String: ...
    @winrt_commethod(18)
    def get_BDT(self) -> WinRT_String: ...
    @winrt_commethod(19)
    def get_BGN(self) -> WinRT_String: ...
    @winrt_commethod(20)
    def get_BHD(self) -> WinRT_String: ...
    @winrt_commethod(21)
    def get_BIF(self) -> WinRT_String: ...
    @winrt_commethod(22)
    def get_BMD(self) -> WinRT_String: ...
    @winrt_commethod(23)
    def get_BND(self) -> WinRT_String: ...
    @winrt_commethod(24)
    def get_BOB(self) -> WinRT_String: ...
    @winrt_commethod(25)
    def get_BRL(self) -> WinRT_String: ...
    @winrt_commethod(26)
    def get_BSD(self) -> WinRT_String: ...
    @winrt_commethod(27)
    def get_BTN(self) -> WinRT_String: ...
    @winrt_commethod(28)
    def get_BWP(self) -> WinRT_String: ...
    @winrt_commethod(29)
    def get_BYR(self) -> WinRT_String: ...
    @winrt_commethod(30)
    def get_BZD(self) -> WinRT_String: ...
    @winrt_commethod(31)
    def get_CAD(self) -> WinRT_String: ...
    @winrt_commethod(32)
    def get_CDF(self) -> WinRT_String: ...
    @winrt_commethod(33)
    def get_CHF(self) -> WinRT_String: ...
    @winrt_commethod(34)
    def get_CLP(self) -> WinRT_String: ...
    @winrt_commethod(35)
    def get_CNY(self) -> WinRT_String: ...
    @winrt_commethod(36)
    def get_COP(self) -> WinRT_String: ...
    @winrt_commethod(37)
    def get_CRC(self) -> WinRT_String: ...
    @winrt_commethod(38)
    def get_CUP(self) -> WinRT_String: ...
    @winrt_commethod(39)
    def get_CVE(self) -> WinRT_String: ...
    @winrt_commethod(40)
    def get_CZK(self) -> WinRT_String: ...
    @winrt_commethod(41)
    def get_DJF(self) -> WinRT_String: ...
    @winrt_commethod(42)
    def get_DKK(self) -> WinRT_String: ...
    @winrt_commethod(43)
    def get_DOP(self) -> WinRT_String: ...
    @winrt_commethod(44)
    def get_DZD(self) -> WinRT_String: ...
    @winrt_commethod(45)
    def get_EGP(self) -> WinRT_String: ...
    @winrt_commethod(46)
    def get_ERN(self) -> WinRT_String: ...
    @winrt_commethod(47)
    def get_ETB(self) -> WinRT_String: ...
    @winrt_commethod(48)
    def get_EUR(self) -> WinRT_String: ...
    @winrt_commethod(49)
    def get_FJD(self) -> WinRT_String: ...
    @winrt_commethod(50)
    def get_FKP(self) -> WinRT_String: ...
    @winrt_commethod(51)
    def get_GBP(self) -> WinRT_String: ...
    @winrt_commethod(52)
    def get_GEL(self) -> WinRT_String: ...
    @winrt_commethod(53)
    def get_GHS(self) -> WinRT_String: ...
    @winrt_commethod(54)
    def get_GIP(self) -> WinRT_String: ...
    @winrt_commethod(55)
    def get_GMD(self) -> WinRT_String: ...
    @winrt_commethod(56)
    def get_GNF(self) -> WinRT_String: ...
    @winrt_commethod(57)
    def get_GTQ(self) -> WinRT_String: ...
    @winrt_commethod(58)
    def get_GYD(self) -> WinRT_String: ...
    @winrt_commethod(59)
    def get_HKD(self) -> WinRT_String: ...
    @winrt_commethod(60)
    def get_HNL(self) -> WinRT_String: ...
    @winrt_commethod(61)
    def get_HRK(self) -> WinRT_String: ...
    @winrt_commethod(62)
    def get_HTG(self) -> WinRT_String: ...
    @winrt_commethod(63)
    def get_HUF(self) -> WinRT_String: ...
    @winrt_commethod(64)
    def get_IDR(self) -> WinRT_String: ...
    @winrt_commethod(65)
    def get_ILS(self) -> WinRT_String: ...
    @winrt_commethod(66)
    def get_INR(self) -> WinRT_String: ...
    @winrt_commethod(67)
    def get_IQD(self) -> WinRT_String: ...
    @winrt_commethod(68)
    def get_IRR(self) -> WinRT_String: ...
    @winrt_commethod(69)
    def get_ISK(self) -> WinRT_String: ...
    @winrt_commethod(70)
    def get_JMD(self) -> WinRT_String: ...
    @winrt_commethod(71)
    def get_JOD(self) -> WinRT_String: ...
    @winrt_commethod(72)
    def get_JPY(self) -> WinRT_String: ...
    @winrt_commethod(73)
    def get_KES(self) -> WinRT_String: ...
    @winrt_commethod(74)
    def get_KGS(self) -> WinRT_String: ...
    @winrt_commethod(75)
    def get_KHR(self) -> WinRT_String: ...
    @winrt_commethod(76)
    def get_KMF(self) -> WinRT_String: ...
    @winrt_commethod(77)
    def get_KPW(self) -> WinRT_String: ...
    @winrt_commethod(78)
    def get_KRW(self) -> WinRT_String: ...
    @winrt_commethod(79)
    def get_KWD(self) -> WinRT_String: ...
    @winrt_commethod(80)
    def get_KYD(self) -> WinRT_String: ...
    @winrt_commethod(81)
    def get_KZT(self) -> WinRT_String: ...
    @winrt_commethod(82)
    def get_LAK(self) -> WinRT_String: ...
    @winrt_commethod(83)
    def get_LBP(self) -> WinRT_String: ...
    @winrt_commethod(84)
    def get_LKR(self) -> WinRT_String: ...
    @winrt_commethod(85)
    def get_LRD(self) -> WinRT_String: ...
    @winrt_commethod(86)
    def get_LSL(self) -> WinRT_String: ...
    @winrt_commethod(87)
    def get_LTL(self) -> WinRT_String: ...
    @winrt_commethod(88)
    def get_LVL(self) -> WinRT_String: ...
    @winrt_commethod(89)
    def get_LYD(self) -> WinRT_String: ...
    @winrt_commethod(90)
    def get_MAD(self) -> WinRT_String: ...
    @winrt_commethod(91)
    def get_MDL(self) -> WinRT_String: ...
    @winrt_commethod(92)
    def get_MGA(self) -> WinRT_String: ...
    @winrt_commethod(93)
    def get_MKD(self) -> WinRT_String: ...
    @winrt_commethod(94)
    def get_MMK(self) -> WinRT_String: ...
    @winrt_commethod(95)
    def get_MNT(self) -> WinRT_String: ...
    @winrt_commethod(96)
    def get_MOP(self) -> WinRT_String: ...
    @winrt_commethod(97)
    def get_MRO(self) -> WinRT_String: ...
    @winrt_commethod(98)
    def get_MUR(self) -> WinRT_String: ...
    @winrt_commethod(99)
    def get_MVR(self) -> WinRT_String: ...
    @winrt_commethod(100)
    def get_MWK(self) -> WinRT_String: ...
    @winrt_commethod(101)
    def get_MXN(self) -> WinRT_String: ...
    @winrt_commethod(102)
    def get_MYR(self) -> WinRT_String: ...
    @winrt_commethod(103)
    def get_MZN(self) -> WinRT_String: ...
    @winrt_commethod(104)
    def get_NAD(self) -> WinRT_String: ...
    @winrt_commethod(105)
    def get_NGN(self) -> WinRT_String: ...
    @winrt_commethod(106)
    def get_NIO(self) -> WinRT_String: ...
    @winrt_commethod(107)
    def get_NOK(self) -> WinRT_String: ...
    @winrt_commethod(108)
    def get_NPR(self) -> WinRT_String: ...
    @winrt_commethod(109)
    def get_NZD(self) -> WinRT_String: ...
    @winrt_commethod(110)
    def get_OMR(self) -> WinRT_String: ...
    @winrt_commethod(111)
    def get_PAB(self) -> WinRT_String: ...
    @winrt_commethod(112)
    def get_PEN(self) -> WinRT_String: ...
    @winrt_commethod(113)
    def get_PGK(self) -> WinRT_String: ...
    @winrt_commethod(114)
    def get_PHP(self) -> WinRT_String: ...
    @winrt_commethod(115)
    def get_PKR(self) -> WinRT_String: ...
    @winrt_commethod(116)
    def get_PLN(self) -> WinRT_String: ...
    @winrt_commethod(117)
    def get_PYG(self) -> WinRT_String: ...
    @winrt_commethod(118)
    def get_QAR(self) -> WinRT_String: ...
    @winrt_commethod(119)
    def get_RON(self) -> WinRT_String: ...
    @winrt_commethod(120)
    def get_RSD(self) -> WinRT_String: ...
    @winrt_commethod(121)
    def get_RUB(self) -> WinRT_String: ...
    @winrt_commethod(122)
    def get_RWF(self) -> WinRT_String: ...
    @winrt_commethod(123)
    def get_SAR(self) -> WinRT_String: ...
    @winrt_commethod(124)
    def get_SBD(self) -> WinRT_String: ...
    @winrt_commethod(125)
    def get_SCR(self) -> WinRT_String: ...
    @winrt_commethod(126)
    def get_SDG(self) -> WinRT_String: ...
    @winrt_commethod(127)
    def get_SEK(self) -> WinRT_String: ...
    @winrt_commethod(128)
    def get_SGD(self) -> WinRT_String: ...
    @winrt_commethod(129)
    def get_SHP(self) -> WinRT_String: ...
    @winrt_commethod(130)
    def get_SLL(self) -> WinRT_String: ...
    @winrt_commethod(131)
    def get_SOS(self) -> WinRT_String: ...
    @winrt_commethod(132)
    def get_SRD(self) -> WinRT_String: ...
    @winrt_commethod(133)
    def get_STD(self) -> WinRT_String: ...
    @winrt_commethod(134)
    def get_SYP(self) -> WinRT_String: ...
    @winrt_commethod(135)
    def get_SZL(self) -> WinRT_String: ...
    @winrt_commethod(136)
    def get_THB(self) -> WinRT_String: ...
    @winrt_commethod(137)
    def get_TJS(self) -> WinRT_String: ...
    @winrt_commethod(138)
    def get_TMT(self) -> WinRT_String: ...
    @winrt_commethod(139)
    def get_TND(self) -> WinRT_String: ...
    @winrt_commethod(140)
    def get_TOP(self) -> WinRT_String: ...
    @winrt_commethod(141)
    def get_TRY(self) -> WinRT_String: ...
    @winrt_commethod(142)
    def get_TTD(self) -> WinRT_String: ...
    @winrt_commethod(143)
    def get_TWD(self) -> WinRT_String: ...
    @winrt_commethod(144)
    def get_TZS(self) -> WinRT_String: ...
    @winrt_commethod(145)
    def get_UAH(self) -> WinRT_String: ...
    @winrt_commethod(146)
    def get_UGX(self) -> WinRT_String: ...
    @winrt_commethod(147)
    def get_USD(self) -> WinRT_String: ...
    @winrt_commethod(148)
    def get_UYU(self) -> WinRT_String: ...
    @winrt_commethod(149)
    def get_UZS(self) -> WinRT_String: ...
    @winrt_commethod(150)
    def get_VEF(self) -> WinRT_String: ...
    @winrt_commethod(151)
    def get_VND(self) -> WinRT_String: ...
    @winrt_commethod(152)
    def get_VUV(self) -> WinRT_String: ...
    @winrt_commethod(153)
    def get_WST(self) -> WinRT_String: ...
    @winrt_commethod(154)
    def get_XAF(self) -> WinRT_String: ...
    @winrt_commethod(155)
    def get_XCD(self) -> WinRT_String: ...
    @winrt_commethod(156)
    def get_XOF(self) -> WinRT_String: ...
    @winrt_commethod(157)
    def get_XPF(self) -> WinRT_String: ...
    @winrt_commethod(158)
    def get_XXX(self) -> WinRT_String: ...
    @winrt_commethod(159)
    def get_YER(self) -> WinRT_String: ...
    @winrt_commethod(160)
    def get_ZAR(self) -> WinRT_String: ...
    @winrt_commethod(161)
    def get_ZMW(self) -> WinRT_String: ...
    @winrt_commethod(162)
    def get_ZWL(self) -> WinRT_String: ...
    AED = property(get_AED, None)
    AFN = property(get_AFN, None)
    ALL = property(get_ALL, None)
    AMD = property(get_AMD, None)
    ANG = property(get_ANG, None)
    AOA = property(get_AOA, None)
    ARS = property(get_ARS, None)
    AUD = property(get_AUD, None)
    AWG = property(get_AWG, None)
    AZN = property(get_AZN, None)
    BAM = property(get_BAM, None)
    BBD = property(get_BBD, None)
    BDT = property(get_BDT, None)
    BGN = property(get_BGN, None)
    BHD = property(get_BHD, None)
    BIF = property(get_BIF, None)
    BMD = property(get_BMD, None)
    BND = property(get_BND, None)
    BOB = property(get_BOB, None)
    BRL = property(get_BRL, None)
    BSD = property(get_BSD, None)
    BTN = property(get_BTN, None)
    BWP = property(get_BWP, None)
    BYR = property(get_BYR, None)
    BZD = property(get_BZD, None)
    CAD = property(get_CAD, None)
    CDF = property(get_CDF, None)
    CHF = property(get_CHF, None)
    CLP = property(get_CLP, None)
    CNY = property(get_CNY, None)
    COP = property(get_COP, None)
    CRC = property(get_CRC, None)
    CUP = property(get_CUP, None)
    CVE = property(get_CVE, None)
    CZK = property(get_CZK, None)
    DJF = property(get_DJF, None)
    DKK = property(get_DKK, None)
    DOP = property(get_DOP, None)
    DZD = property(get_DZD, None)
    EGP = property(get_EGP, None)
    ERN = property(get_ERN, None)
    ETB = property(get_ETB, None)
    EUR = property(get_EUR, None)
    FJD = property(get_FJD, None)
    FKP = property(get_FKP, None)
    GBP = property(get_GBP, None)
    GEL = property(get_GEL, None)
    GHS = property(get_GHS, None)
    GIP = property(get_GIP, None)
    GMD = property(get_GMD, None)
    GNF = property(get_GNF, None)
    GTQ = property(get_GTQ, None)
    GYD = property(get_GYD, None)
    HKD = property(get_HKD, None)
    HNL = property(get_HNL, None)
    HRK = property(get_HRK, None)
    HTG = property(get_HTG, None)
    HUF = property(get_HUF, None)
    IDR = property(get_IDR, None)
    ILS = property(get_ILS, None)
    INR = property(get_INR, None)
    IQD = property(get_IQD, None)
    IRR = property(get_IRR, None)
    ISK = property(get_ISK, None)
    JMD = property(get_JMD, None)
    JOD = property(get_JOD, None)
    JPY = property(get_JPY, None)
    KES = property(get_KES, None)
    KGS = property(get_KGS, None)
    KHR = property(get_KHR, None)
    KMF = property(get_KMF, None)
    KPW = property(get_KPW, None)
    KRW = property(get_KRW, None)
    KWD = property(get_KWD, None)
    KYD = property(get_KYD, None)
    KZT = property(get_KZT, None)
    LAK = property(get_LAK, None)
    LBP = property(get_LBP, None)
    LKR = property(get_LKR, None)
    LRD = property(get_LRD, None)
    LSL = property(get_LSL, None)
    LTL = property(get_LTL, None)
    LVL = property(get_LVL, None)
    LYD = property(get_LYD, None)
    MAD = property(get_MAD, None)
    MDL = property(get_MDL, None)
    MGA = property(get_MGA, None)
    MKD = property(get_MKD, None)
    MMK = property(get_MMK, None)
    MNT = property(get_MNT, None)
    MOP = property(get_MOP, None)
    MRO = property(get_MRO, None)
    MUR = property(get_MUR, None)
    MVR = property(get_MVR, None)
    MWK = property(get_MWK, None)
    MXN = property(get_MXN, None)
    MYR = property(get_MYR, None)
    MZN = property(get_MZN, None)
    NAD = property(get_NAD, None)
    NGN = property(get_NGN, None)
    NIO = property(get_NIO, None)
    NOK = property(get_NOK, None)
    NPR = property(get_NPR, None)
    NZD = property(get_NZD, None)
    OMR = property(get_OMR, None)
    PAB = property(get_PAB, None)
    PEN = property(get_PEN, None)
    PGK = property(get_PGK, None)
    PHP = property(get_PHP, None)
    PKR = property(get_PKR, None)
    PLN = property(get_PLN, None)
    PYG = property(get_PYG, None)
    QAR = property(get_QAR, None)
    RON = property(get_RON, None)
    RSD = property(get_RSD, None)
    RUB = property(get_RUB, None)
    RWF = property(get_RWF, None)
    SAR = property(get_SAR, None)
    SBD = property(get_SBD, None)
    SCR = property(get_SCR, None)
    SDG = property(get_SDG, None)
    SEK = property(get_SEK, None)
    SGD = property(get_SGD, None)
    SHP = property(get_SHP, None)
    SLL = property(get_SLL, None)
    SOS = property(get_SOS, None)
    SRD = property(get_SRD, None)
    STD = property(get_STD, None)
    SYP = property(get_SYP, None)
    SZL = property(get_SZL, None)
    THB = property(get_THB, None)
    TJS = property(get_TJS, None)
    TMT = property(get_TMT, None)
    TND = property(get_TND, None)
    TOP = property(get_TOP, None)
    TRY = property(get_TRY, None)
    TTD = property(get_TTD, None)
    TWD = property(get_TWD, None)
    TZS = property(get_TZS, None)
    UAH = property(get_UAH, None)
    UGX = property(get_UGX, None)
    USD = property(get_USD, None)
    UYU = property(get_UYU, None)
    UZS = property(get_UZS, None)
    VEF = property(get_VEF, None)
    VND = property(get_VND, None)
    VUV = property(get_VUV, None)
    WST = property(get_WST, None)
    XAF = property(get_XAF, None)
    XCD = property(get_XCD, None)
    XOF = property(get_XOF, None)
    XPF = property(get_XPF, None)
    XXX = property(get_XXX, None)
    YER = property(get_YER, None)
    ZAR = property(get_ZAR, None)
    ZMW = property(get_ZMW, None)
    ZWL = property(get_ZWL, None)
class ICurrencyIdentifiersStatics2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.ICurrencyIdentifiersStatics2'
    _iid_ = Guid('{1814797f-c3b2-4c33-9591-980011950d37}')
    @winrt_commethod(6)
    def get_BYN(self) -> WinRT_String: ...
    BYN = property(get_BYN, None)
class ICurrencyIdentifiersStatics3(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.ICurrencyIdentifiersStatics3'
    _iid_ = Guid('{4fb23bfa-ed25-4f4d-857f-237f1748c21c}')
    @winrt_commethod(6)
    def get_MRU(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def get_SSP(self) -> WinRT_String: ...
    @winrt_commethod(8)
    def get_STN(self) -> WinRT_String: ...
    @winrt_commethod(9)
    def get_VES(self) -> WinRT_String: ...
    MRU = property(get_MRU, None)
    SSP = property(get_SSP, None)
    STN = property(get_STN, None)
    VES = property(get_VES, None)
class IGeographicRegion(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.IGeographicRegion'
    _iid_ = Guid('{01e9a621-4a64-4ed9-954f-9edeb07bd903}')
    @winrt_commethod(6)
    def get_Code(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def get_CodeTwoLetter(self) -> WinRT_String: ...
    @winrt_commethod(8)
    def get_CodeThreeLetter(self) -> WinRT_String: ...
    @winrt_commethod(9)
    def get_CodeThreeDigit(self) -> WinRT_String: ...
    @winrt_commethod(10)
    def get_DisplayName(self) -> WinRT_String: ...
    @winrt_commethod(11)
    def get_NativeName(self) -> WinRT_String: ...
    @winrt_commethod(12)
    def get_CurrenciesInUse(self) -> win32more.Windows.Foundation.Collections.IVectorView[WinRT_String]: ...
    Code = property(get_Code, None)
    CodeThreeDigit = property(get_CodeThreeDigit, None)
    CodeThreeLetter = property(get_CodeThreeLetter, None)
    CodeTwoLetter = property(get_CodeTwoLetter, None)
    CurrenciesInUse = property(get_CurrenciesInUse, None)
    DisplayName = property(get_DisplayName, None)
    NativeName = property(get_NativeName, None)
class IGeographicRegionFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.IGeographicRegionFactory'
    _iid_ = Guid('{53425270-77b4-426b-859f-81e19d512546}')
    @winrt_commethod(6)
    def CreateGeographicRegion(self, geographicRegionCode: WinRT_String) -> win32more.Windows.Globalization.GeographicRegion: ...
class IGeographicRegionStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.IGeographicRegionStatics'
    _iid_ = Guid('{29e28974-7ad9-4ef4-8799-b3b44fadec08}')
    @winrt_commethod(6)
    def IsSupported(self, geographicRegionCode: WinRT_String) -> Boolean: ...
class IJapanesePhoneme(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.IJapanesePhoneme'
    _iid_ = Guid('{2f6a9300-e85b-43e6-897d-5d82f862df21}')
    @winrt_commethod(6)
    def get_DisplayText(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def get_YomiText(self) -> WinRT_String: ...
    @winrt_commethod(8)
    def get_IsPhraseStart(self) -> Boolean: ...
    DisplayText = property(get_DisplayText, None)
    IsPhraseStart = property(get_IsPhraseStart, None)
    YomiText = property(get_YomiText, None)
class IJapanesePhoneticAnalyzerStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.IJapanesePhoneticAnalyzerStatics'
    _iid_ = Guid('{88ab9e90-93de-41b2-b4d5-8edb227fd1c2}')
    @winrt_commethod(6)
    def GetWords(self, input: WinRT_String) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Globalization.JapanesePhoneme]: ...
    @winrt_commethod(7)
    def GetWordsWithMonoRubyOption(self, input: WinRT_String, monoRuby: Boolean) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Globalization.JapanesePhoneme]: ...
class ILanguage(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.ILanguage'
    _iid_ = Guid('{ea79a752-f7c2-4265-b1bd-c4dec4e4f080}')
    @winrt_commethod(6)
    def get_LanguageTag(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def get_DisplayName(self) -> WinRT_String: ...
    @winrt_commethod(8)
    def get_NativeName(self) -> WinRT_String: ...
    @winrt_commethod(9)
    def get_Script(self) -> WinRT_String: ...
    DisplayName = property(get_DisplayName, None)
    LanguageTag = property(get_LanguageTag, None)
    NativeName = property(get_NativeName, None)
    Script = property(get_Script, None)
class ILanguage2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.ILanguage2'
    _iid_ = Guid('{6a47e5b5-d94d-4886-a404-a5a5b9d5b494}')
    @winrt_commethod(6)
    def get_LayoutDirection(self) -> win32more.Windows.Globalization.LanguageLayoutDirection: ...
    LayoutDirection = property(get_LayoutDirection, None)
class ILanguage3(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.ILanguage3'
    _iid_ = Guid('{c6af3d10-641a-5ba4-bb43-5e12aed75954}')
    @winrt_commethod(6)
    def get_AbbreviatedName(self) -> WinRT_String: ...
    AbbreviatedName = property(get_AbbreviatedName, None)
class ILanguageExtensionSubtags(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.ILanguageExtensionSubtags'
    _iid_ = Guid('{7d7daf45-368d-4364-852b-dec927037b85}')
    @winrt_commethod(6)
    def GetExtensionSubtags(self, singleton: WinRT_String) -> win32more.Windows.Foundation.Collections.IVectorView[WinRT_String]: ...
class ILanguageFactory(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.ILanguageFactory'
    _iid_ = Guid('{9b0252ac-0c27-44f8-b792-9793fb66c63e}')
    @winrt_commethod(6)
    def CreateLanguage(self, languageTag: WinRT_String) -> win32more.Windows.Globalization.Language: ...
class ILanguageStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.ILanguageStatics'
    _iid_ = Guid('{b23cd557-0865-46d4-89b8-d59be8990f0d}')
    @winrt_commethod(6)
    def IsWellFormed(self, languageTag: WinRT_String) -> Boolean: ...
    @winrt_commethod(7)
    def get_CurrentInputMethodLanguageTag(self) -> WinRT_String: ...
    CurrentInputMethodLanguageTag = property(get_CurrentInputMethodLanguageTag, None)
class ILanguageStatics2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.ILanguageStatics2'
    _iid_ = Guid('{30199f6e-914b-4b2a-9d6e-e3b0e27dbe4f}')
    @winrt_commethod(6)
    def TrySetInputMethodLanguageTag(self, languageTag: WinRT_String) -> Boolean: ...
class ILanguageStatics3(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.ILanguageStatics3'
    _iid_ = Guid('{d15ecb5a-71de-5752-9542-fac5b4f27261}')
    @winrt_commethod(6)
    def GetMuiCompatibleLanguageListFromLanguageTags(self, languageTags: win32more.Windows.Foundation.Collections.IIterable[WinRT_String]) -> win32more.Windows.Foundation.Collections.IVector[WinRT_String]: ...
class INumeralSystemIdentifiersStatics(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.INumeralSystemIdentifiersStatics'
    _iid_ = Guid('{a5c662c3-68c9-4d3d-b765-972029e21dec}')
    @winrt_commethod(6)
    def get_Arab(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def get_ArabExt(self) -> WinRT_String: ...
    @winrt_commethod(8)
    def get_Bali(self) -> WinRT_String: ...
    @winrt_commethod(9)
    def get_Beng(self) -> WinRT_String: ...
    @winrt_commethod(10)
    def get_Cham(self) -> WinRT_String: ...
    @winrt_commethod(11)
    def get_Deva(self) -> WinRT_String: ...
    @winrt_commethod(12)
    def get_FullWide(self) -> WinRT_String: ...
    @winrt_commethod(13)
    def get_Gujr(self) -> WinRT_String: ...
    @winrt_commethod(14)
    def get_Guru(self) -> WinRT_String: ...
    @winrt_commethod(15)
    def get_HaniDec(self) -> WinRT_String: ...
    @winrt_commethod(16)
    def get_Java(self) -> WinRT_String: ...
    @winrt_commethod(17)
    def get_Kali(self) -> WinRT_String: ...
    @winrt_commethod(18)
    def get_Khmr(self) -> WinRT_String: ...
    @winrt_commethod(19)
    def get_Knda(self) -> WinRT_String: ...
    @winrt_commethod(20)
    def get_Lana(self) -> WinRT_String: ...
    @winrt_commethod(21)
    def get_LanaTham(self) -> WinRT_String: ...
    @winrt_commethod(22)
    def get_Laoo(self) -> WinRT_String: ...
    @winrt_commethod(23)
    def get_Latn(self) -> WinRT_String: ...
    @winrt_commethod(24)
    def get_Lepc(self) -> WinRT_String: ...
    @winrt_commethod(25)
    def get_Limb(self) -> WinRT_String: ...
    @winrt_commethod(26)
    def get_Mlym(self) -> WinRT_String: ...
    @winrt_commethod(27)
    def get_Mong(self) -> WinRT_String: ...
    @winrt_commethod(28)
    def get_Mtei(self) -> WinRT_String: ...
    @winrt_commethod(29)
    def get_Mymr(self) -> WinRT_String: ...
    @winrt_commethod(30)
    def get_MymrShan(self) -> WinRT_String: ...
    @winrt_commethod(31)
    def get_Nkoo(self) -> WinRT_String: ...
    @winrt_commethod(32)
    def get_Olck(self) -> WinRT_String: ...
    @winrt_commethod(33)
    def get_Orya(self) -> WinRT_String: ...
    @winrt_commethod(34)
    def get_Saur(self) -> WinRT_String: ...
    @winrt_commethod(35)
    def get_Sund(self) -> WinRT_String: ...
    @winrt_commethod(36)
    def get_Talu(self) -> WinRT_String: ...
    @winrt_commethod(37)
    def get_TamlDec(self) -> WinRT_String: ...
    @winrt_commethod(38)
    def get_Telu(self) -> WinRT_String: ...
    @winrt_commethod(39)
    def get_Thai(self) -> WinRT_String: ...
    @winrt_commethod(40)
    def get_Tibt(self) -> WinRT_String: ...
    @winrt_commethod(41)
    def get_Vaii(self) -> WinRT_String: ...
    Arab = property(get_Arab, None)
    ArabExt = property(get_ArabExt, None)
    Bali = property(get_Bali, None)
    Beng = property(get_Beng, None)
    Cham = property(get_Cham, None)
    Deva = property(get_Deva, None)
    FullWide = property(get_FullWide, None)
    Gujr = property(get_Gujr, None)
    Guru = property(get_Guru, None)
    HaniDec = property(get_HaniDec, None)
    Java = property(get_Java, None)
    Kali = property(get_Kali, None)
    Khmr = property(get_Khmr, None)
    Knda = property(get_Knda, None)
    Lana = property(get_Lana, None)
    LanaTham = property(get_LanaTham, None)
    Laoo = property(get_Laoo, None)
    Latn = property(get_Latn, None)
    Lepc = property(get_Lepc, None)
    Limb = property(get_Limb, None)
    Mlym = property(get_Mlym, None)
    Mong = property(get_Mong, None)
    Mtei = property(get_Mtei, None)
    Mymr = property(get_Mymr, None)
    MymrShan = property(get_MymrShan, None)
    Nkoo = property(get_Nkoo, None)
    Olck = property(get_Olck, None)
    Orya = property(get_Orya, None)
    Saur = property(get_Saur, None)
    Sund = property(get_Sund, None)
    Talu = property(get_Talu, None)
    TamlDec = property(get_TamlDec, None)
    Telu = property(get_Telu, None)
    Thai = property(get_Thai, None)
    Tibt = property(get_Tibt, None)
    Vaii = property(get_Vaii, None)
class INumeralSystemIdentifiersStatics2(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.INumeralSystemIdentifiersStatics2'
    _iid_ = Guid('{7f003228-9ddb-4a34-9104-0260c091a7c7}')
    @winrt_commethod(6)
    def get_Brah(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def get_Osma(self) -> WinRT_String: ...
    @winrt_commethod(8)
    def get_MathBold(self) -> WinRT_String: ...
    @winrt_commethod(9)
    def get_MathDbl(self) -> WinRT_String: ...
    @winrt_commethod(10)
    def get_MathSans(self) -> WinRT_String: ...
    @winrt_commethod(11)
    def get_MathSanb(self) -> WinRT_String: ...
    @winrt_commethod(12)
    def get_MathMono(self) -> WinRT_String: ...
    @winrt_commethod(13)
    def get_ZmthBold(self) -> WinRT_String: ...
    @winrt_commethod(14)
    def get_ZmthDbl(self) -> WinRT_String: ...
    @winrt_commethod(15)
    def get_ZmthSans(self) -> WinRT_String: ...
    @winrt_commethod(16)
    def get_ZmthSanb(self) -> WinRT_String: ...
    @winrt_commethod(17)
    def get_ZmthMono(self) -> WinRT_String: ...
    Brah = property(get_Brah, None)
    MathBold = property(get_MathBold, None)
    MathDbl = property(get_MathDbl, None)
    MathMono = property(get_MathMono, None)
    MathSanb = property(get_MathSanb, None)
    MathSans = property(get_MathSans, None)
    Osma = property(get_Osma, None)
    ZmthBold = property(get_ZmthBold, None)
    ZmthDbl = property(get_ZmthDbl, None)
    ZmthMono = property(get_ZmthMono, None)
    ZmthSanb = property(get_ZmthSanb, None)
    ZmthSans = property(get_ZmthSans, None)
class ITimeZoneOnCalendar(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.ITimeZoneOnCalendar'
    _iid_ = Guid('{bb3c25e5-46cf-4317-a3f5-02621ad54478}')
    @winrt_commethod(6)
    def GetTimeZone(self) -> WinRT_String: ...
    @winrt_commethod(7)
    def ChangeTimeZone(self, timeZoneId: WinRT_String) -> Void: ...
    @winrt_commethod(8)
    def TimeZoneAsFullString(self) -> WinRT_String: ...
    @winrt_commethod(9)
    def TimeZoneAsString(self, idealLength: Int32) -> WinRT_String: ...
class JapanesePhoneme(ComPtr):
    extends: IInspectable
    default_interface: win32more.Windows.Globalization.IJapanesePhoneme
    _classid_ = 'Windows.Globalization.JapanesePhoneme'
    @winrt_mixinmethod
    def get_DisplayText(self: win32more.Windows.Globalization.IJapanesePhoneme) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_YomiText(self: win32more.Windows.Globalization.IJapanesePhoneme) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_IsPhraseStart(self: win32more.Windows.Globalization.IJapanesePhoneme) -> Boolean: ...
    DisplayText = property(get_DisplayText, None)
    IsPhraseStart = property(get_IsPhraseStart, None)
    YomiText = property(get_YomiText, None)
class JapanesePhoneticAnalyzer(ComPtr):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.JapanesePhoneticAnalyzer'
    @winrt_classmethod
    def GetWords(cls: win32more.Windows.Globalization.IJapanesePhoneticAnalyzerStatics, input: WinRT_String) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Globalization.JapanesePhoneme]: ...
    @winrt_classmethod
    def GetWordsWithMonoRubyOption(cls: win32more.Windows.Globalization.IJapanesePhoneticAnalyzerStatics, input: WinRT_String, monoRuby: Boolean) -> win32more.Windows.Foundation.Collections.IVectorView[win32more.Windows.Globalization.JapanesePhoneme]: ...
class _Language_Meta_(ComPtr.__class__):
    pass
class Language(ComPtr, metaclass=_Language_Meta_):
    extends: IInspectable
    default_interface: win32more.Windows.Globalization.ILanguage
    _classid_ = 'Windows.Globalization.Language'
    def __init__(self, *args, **kwargs):
        if kwargs:
            super().__init__(**kwargs)
        elif len(args) == 1:
            super().__init__(move=win32more.Windows.Globalization.Language.CreateLanguage(*args))
        else:
            raise ValueError('no matched constructor')
    @winrt_factorymethod
    def CreateLanguage(cls: win32more.Windows.Globalization.ILanguageFactory, languageTag: WinRT_String) -> win32more.Windows.Globalization.Language: ...
    @winrt_mixinmethod
    def get_LanguageTag(self: win32more.Windows.Globalization.ILanguage) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_DisplayName(self: win32more.Windows.Globalization.ILanguage) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_NativeName(self: win32more.Windows.Globalization.ILanguage) -> WinRT_String: ...
    @winrt_mixinmethod
    def get_Script(self: win32more.Windows.Globalization.ILanguage) -> WinRT_String: ...
    @winrt_mixinmethod
    def GetExtensionSubtags(self: win32more.Windows.Globalization.ILanguageExtensionSubtags, singleton: WinRT_String) -> win32more.Windows.Foundation.Collections.IVectorView[WinRT_String]: ...
    @winrt_mixinmethod
    def get_LayoutDirection(self: win32more.Windows.Globalization.ILanguage2) -> win32more.Windows.Globalization.LanguageLayoutDirection: ...
    @winrt_mixinmethod
    def get_AbbreviatedName(self: win32more.Windows.Globalization.ILanguage3) -> WinRT_String: ...
    @winrt_classmethod
    def GetMuiCompatibleLanguageListFromLanguageTags(cls: win32more.Windows.Globalization.ILanguageStatics3, languageTags: win32more.Windows.Foundation.Collections.IIterable[WinRT_String]) -> win32more.Windows.Foundation.Collections.IVector[WinRT_String]: ...
    @winrt_classmethod
    def TrySetInputMethodLanguageTag(cls: win32more.Windows.Globalization.ILanguageStatics2, languageTag: WinRT_String) -> Boolean: ...
    @winrt_classmethod
    def IsWellFormed(cls: win32more.Windows.Globalization.ILanguageStatics, languageTag: WinRT_String) -> Boolean: ...
    @winrt_classmethod
    def get_CurrentInputMethodLanguageTag(cls: win32more.Windows.Globalization.ILanguageStatics) -> WinRT_String: ...
    AbbreviatedName = property(get_AbbreviatedName, None)
    DisplayName = property(get_DisplayName, None)
    LanguageTag = property(get_LanguageTag, None)
    LayoutDirection = property(get_LayoutDirection, None)
    NativeName = property(get_NativeName, None)
    Script = property(get_Script, None)
    _Language_Meta_.CurrentInputMethodLanguageTag = property(get_CurrentInputMethodLanguageTag, None)
class LanguageLayoutDirection(Enum, Int32):
    Ltr = 0
    Rtl = 1
    TtbLtr = 2
    TtbRtl = 3
class _NumeralSystemIdentifiers_Meta_(ComPtr.__class__):
    pass
class NumeralSystemIdentifiers(ComPtr, metaclass=_NumeralSystemIdentifiers_Meta_):
    extends: IInspectable
    _classid_ = 'Windows.Globalization.NumeralSystemIdentifiers'
    @winrt_classmethod
    def get_Brah(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics2) -> WinRT_String: ...
    @winrt_classmethod
    def get_Osma(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics2) -> WinRT_String: ...
    @winrt_classmethod
    def get_MathBold(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics2) -> WinRT_String: ...
    @winrt_classmethod
    def get_MathDbl(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics2) -> WinRT_String: ...
    @winrt_classmethod
    def get_MathSans(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics2) -> WinRT_String: ...
    @winrt_classmethod
    def get_MathSanb(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics2) -> WinRT_String: ...
    @winrt_classmethod
    def get_MathMono(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics2) -> WinRT_String: ...
    @winrt_classmethod
    def get_ZmthBold(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics2) -> WinRT_String: ...
    @winrt_classmethod
    def get_ZmthDbl(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics2) -> WinRT_String: ...
    @winrt_classmethod
    def get_ZmthSans(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics2) -> WinRT_String: ...
    @winrt_classmethod
    def get_ZmthSanb(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics2) -> WinRT_String: ...
    @winrt_classmethod
    def get_ZmthMono(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics2) -> WinRT_String: ...
    @winrt_classmethod
    def get_Arab(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_ArabExt(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Bali(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Beng(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Cham(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Deva(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_FullWide(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Gujr(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Guru(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_HaniDec(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Java(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Kali(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Khmr(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Knda(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Lana(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_LanaTham(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Laoo(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Latn(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Lepc(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Limb(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Mlym(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Mong(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Mtei(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Mymr(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_MymrShan(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Nkoo(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Olck(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Orya(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Saur(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Sund(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Talu(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_TamlDec(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Telu(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Thai(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Tibt(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    @winrt_classmethod
    def get_Vaii(cls: win32more.Windows.Globalization.INumeralSystemIdentifiersStatics) -> WinRT_String: ...
    _NumeralSystemIdentifiers_Meta_.Arab = property(get_Arab, None)
    _NumeralSystemIdentifiers_Meta_.ArabExt = property(get_ArabExt, None)
    _NumeralSystemIdentifiers_Meta_.Bali = property(get_Bali, None)
    _NumeralSystemIdentifiers_Meta_.Beng = property(get_Beng, None)
    _NumeralSystemIdentifiers_Meta_.Brah = property(get_Brah, None)
    _NumeralSystemIdentifiers_Meta_.Cham = property(get_Cham, None)
    _NumeralSystemIdentifiers_Meta_.Deva = property(get_Deva, None)
    _NumeralSystemIdentifiers_Meta_.FullWide = property(get_FullWide, None)
    _NumeralSystemIdentifiers_Meta_.Gujr = property(get_Gujr, None)
    _NumeralSystemIdentifiers_Meta_.Guru = property(get_Guru, None)
    _NumeralSystemIdentifiers_Meta_.HaniDec = property(get_HaniDec, None)
    _NumeralSystemIdentifiers_Meta_.Java = property(get_Java, None)
    _NumeralSystemIdentifiers_Meta_.Kali = property(get_Kali, None)
    _NumeralSystemIdentifiers_Meta_.Khmr = property(get_Khmr, None)
    _NumeralSystemIdentifiers_Meta_.Knda = property(get_Knda, None)
    _NumeralSystemIdentifiers_Meta_.Lana = property(get_Lana, None)
    _NumeralSystemIdentifiers_Meta_.LanaTham = property(get_LanaTham, None)
    _NumeralSystemIdentifiers_Meta_.Laoo = property(get_Laoo, None)
    _NumeralSystemIdentifiers_Meta_.Latn = property(get_Latn, None)
    _NumeralSystemIdentifiers_Meta_.Lepc = property(get_Lepc, None)
    _NumeralSystemIdentifiers_Meta_.Limb = property(get_Limb, None)
    _NumeralSystemIdentifiers_Meta_.MathBold = property(get_MathBold, None)
    _NumeralSystemIdentifiers_Meta_.MathDbl = property(get_MathDbl, None)
    _NumeralSystemIdentifiers_Meta_.MathMono = property(get_MathMono, None)
    _NumeralSystemIdentifiers_Meta_.MathSanb = property(get_MathSanb, None)
    _NumeralSystemIdentifiers_Meta_.MathSans = property(get_MathSans, None)
    _NumeralSystemIdentifiers_Meta_.Mlym = property(get_Mlym, None)
    _NumeralSystemIdentifiers_Meta_.Mong = property(get_Mong, None)
    _NumeralSystemIdentifiers_Meta_.Mtei = property(get_Mtei, None)
    _NumeralSystemIdentifiers_Meta_.Mymr = property(get_Mymr, None)
    _NumeralSystemIdentifiers_Meta_.MymrShan = property(get_MymrShan, None)
    _NumeralSystemIdentifiers_Meta_.Nkoo = property(get_Nkoo, None)
    _NumeralSystemIdentifiers_Meta_.Olck = property(get_Olck, None)
    _NumeralSystemIdentifiers_Meta_.Orya = property(get_Orya, None)
    _NumeralSystemIdentifiers_Meta_.Osma = property(get_Osma, None)
    _NumeralSystemIdentifiers_Meta_.Saur = property(get_Saur, None)
    _NumeralSystemIdentifiers_Meta_.Sund = property(get_Sund, None)
    _NumeralSystemIdentifiers_Meta_.Talu = property(get_Talu, None)
    _NumeralSystemIdentifiers_Meta_.TamlDec = property(get_TamlDec, None)
    _NumeralSystemIdentifiers_Meta_.Telu = property(get_Telu, None)
    _NumeralSystemIdentifiers_Meta_.Thai = property(get_Thai, None)
    _NumeralSystemIdentifiers_Meta_.Tibt = property(get_Tibt, None)
    _NumeralSystemIdentifiers_Meta_.Vaii = property(get_Vaii, None)
    _NumeralSystemIdentifiers_Meta_.ZmthBold = property(get_ZmthBold, None)
    _NumeralSystemIdentifiers_Meta_.ZmthDbl = property(get_ZmthDbl, None)
    _NumeralSystemIdentifiers_Meta_.ZmthMono = property(get_ZmthMono, None)
    _NumeralSystemIdentifiers_Meta_.ZmthSanb = property(get_ZmthSanb, None)
    _NumeralSystemIdentifiers_Meta_.ZmthSans = property(get_ZmthSans, None)


make_ready(__name__)
